<style>
.btn.btn-quarternary{
    color: #fff;
    border-color: transparent !important;
    background: linear-gradient(45deg, #4925ecff 0%, #4d178bff 100%);
    box-shadow: 0px 10px 20px -6px rgba(0, 0, 0, 0.12);
    border-radius: 5px;
    font-weight:600;
}

.btn.btn-quarternary1{
    color: #fff;
    border-color: transparent !important;
    background: linear-gradient(45deg, #ef3030ff 0%, #d6526aff 100%);
    box-shadow: 0px 10px 20px -6px rgba(0, 0, 0, 0.12);
    border-radius: 5px;
    font-weight:600;
}

.btn.btn-quarternaryhome{
    color: #fff;
    border-color: transparent !important;
    background: black;
    box-shadow: 0px 10px 20px -6px rgba(0, 0, 0, 0.12);
    border-radius: 5px;
    font-weight: 600;
    font-size: 12px;
}

.custom-checkbox-wrapper {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 12px 15px;
    background: #f8f9fa;
    border-radius: 8px;
    border: 2px solid #e1e8ed;
    transition: all 0.3s;
}

.custom-checkbox-wrapper:hover {
    border-color: #4925ecff;
    background: #f0f7ff;
}

.custom-checkbox {
    position: relative;
    display: inline-block;
    width: 50px;
    height: 26px;
}

.custom-checkbox input {
    opacity: 0;
    width: 0;
    height: 0;
}

.checkbox-slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #ccc;
    transition: .4s;
    border-radius: 34px;
}

.checkbox-slider:before {
    position: absolute;
    content: "";
    height: 18px;
    width: 18px;
    left: 4px;
    bottom: 4px;
    background-color: white;
    transition: .4s;
    border-radius: 50%;
}

.custom-checkbox input:checked + .checkbox-slider {
    background: linear-gradient(45deg, #4925ecff 0%, #4d178bff 100%);
}

.custom-checkbox input:checked + .checkbox-slider:before {
    transform: translateX(24px);
}

.checkbox-label {
    font-weight: 600;
    color: #333;
    font-size: 14px;
}

.checkbox-status {
    font-size: 12px;
    color: #666;
    margin-left: auto;
}

.status-active {
    color: #28a745;
    font-weight: 600;
}

.status-inactive {
    color: #dc3545;
    font-weight: 600;
}
</style>

<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

                <!-- Card start -->
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1">
                            <?= !empty($data) ? 'Edit Answer Type' : 'Add Answer Type' ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <form role="form" id="Form" method="post" enctype="multipart/form-data">

                            <!-- Hidden: answertypeid -->
                            <input class="form-control" id="answertypeid" name="answertypeid" type="hidden"
                                   value="<?= !empty($data) ? $data[0]->answertypeid : '' ?>" />

                            <!-- Row 1: Answer Type Name | Order Number -->
                            <div class="row gutters">

                                <!-- Answer Type Name -->
                                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
                                    <div class="field-wrapper">
                                        <input class="form-control" type="text" 
                                               name="answertypename" 
                                               id="answertypename"
                                               value="<?= !empty($data) ? $data[0]->answertypename : '' ?>" 
                                               required>
                                        <div class="field-placeholder">Answer Type Name <span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <!-- Order Number -->
                                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
                                    <div class="field-wrapper">
                                        <input class="form-control" type="number" 
                                               name="orderno" 
                                               id="orderno"
                                               value="<?= !empty($data) ? $data[0]->orderno : '' ?>" 
                                               required>
                                        <div class="field-placeholder">Order Number <span class="text-danger">*</span></div>
                                    </div>
                                </div>

                            </div>
                            <!-- Row 1 end -->

                            <!-- Row 2: Active Status Toggle -->
                            <div class="row gutters mt-3">
                                <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 col-12">
                                    <div class="custom-checkbox-wrapper">
                                        <label class="custom-checkbox">
                                            <input type="checkbox" 
                                                   name="is_active" 
                                                   id="is_active" 
                                                   value="1"
                                                   <?php 
                                                   if (!empty($data)) {
                                                       echo (isset($data[0]->is_active) && $data[0]->is_active == 1) ? 'checked' : '';
                                                   } else {
                                                       echo 'checked';
                                                   }
                                                   ?>>
                                            <span class="checkbox-slider"></span>
                                        </label>
                                        <span class="checkbox-label">Active Status</span>
                                        <span class="checkbox-status" id="statusText">
                                            <?php 
                                            if (!empty($data)) {
                                                echo (isset($data[0]->is_active) && $data[0]->is_active == 1) ? 
                                                    '<span class="status-active">Active</span>' : 
                                                    '<span class="status-inactive">Inactive</span>';
                                            } else {
                                                echo '<span class="status-active">Active</span>';
                                            }
                                            ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <!-- Row 2 end -->

                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="card-body">
                        <div class="">
                            <button type="button" class="btn mb-md-0 mb-2 btn-quarternary" id="submit" name="submit">
                                <i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save
                            </button>
                            <a class="btn mb-md-0 mb-2 btn-quarternary1" href="<?= base_url() ?>admin/AnswerType/index" type="button">
                                <i class="fa-solid fa-list"></i>&nbsp;&nbsp;List
                            </a>
                            <button class="btn mb-md-0 mb-2 btn-quarternaryhome text-white" 
                                    type="button"  
                                    onclick="window.location.href='<?= base_url() ?>admin/AnswerType/index'">
                                <i class="fa-solid fa-home"></i>&nbsp;Home
                            </button>
                        </div>
                    </div>

                </form>
                </div>
                <!-- Card end -->

            </div>
        </div>
    </div>
</div>

<!-- Scripts -->
<script src="<?php echo base_url(); ?>Assets/js/jquery.min.js"></script>           
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script> 
<script src="<?php echo base_url(); ?>Assets/js/CreateJs/admin/AnswerType.js"></script> 

<script>
$(document).ready(function() {

    // Toggle status text on checkbox change
    $('#is_active').change(function() {
        if ($(this).is(':checked')) {
            $('#statusText').html('<span class="status-active">Active</span>');
        } else {
            $('#statusText').html('<span class="status-inactive">Inactive</span>');
        }
    });

});
</script>