<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1">Institute Award Report</div>
                    </div>
                    <div class="card-body">
                        <form role="form" id="Form">
                            <div class="row gutters">
                                <!-- Award Type Filter -->
                                <div class="col-xl-5 col-lg-5 col-md-5 col-sm-3 col-12">
                                    <div class="field-wrapper">
                                        <select class="select-single js-states" title="Select Type" data-live-search="true" name="fkAwardType_id" id="fkAwardType_id" multiple>
                                            <?php 
                                            foreach($awarddata as $rw=>$value){
                                                echo '<option value="'.$value->level_id.'">'.$value->leval_name.'</option>';
                                            }
                                            ?>
                                        </select>
                                        <div class="field-placeholder">Award Type</div>
                                    </div>
                                </div>

                                <!-- Year Filter -->
                                <div class="col-md-2">
                                    <div class="field-wrapper">
                                        <select class="select-single js-states" title="Select Product Category" data-live-search="true" name="year" id="year_dropdown">
                                            <option value="0">Select Financial Year</option>
                                            <?php
                                            foreach ($yeardata as $value) {
                                                $selected = ($value->finiYear_id == $active_year_id) ? "selected='selected'" : "";
                                                echo '<option value="'.$value->finiYear_id.'" '.$selected.'>'.$value->fini_Label.'</option>';
                                            }
                                            ?>
                                        </select>
                                        <div class="field-placeholder">Select Year</div>
                                    </div>
                                </div>

                                <!-- Show Data Button -->
                                <div class="col-md-12 mt-2">
                                    <button class="btn btn-success btn-sm m-1 fw-bold" type="button" id="btnShow" style="padding: px 10px;font-size: 13px;">
                                        <i class="fas fa-search"></i> Show Data
                                    </button>
                                </div>
                            </div>

                            <!-- Action Buttons -->
                            <div class="row">
                                <div class="col-md-12 text-right">
                                    <button class="btn btn-danger btn-sm rounded-3" type="button" onclick="printTable()">
                                        <i class="fas fa-print bg-white p-1 rounded-circle text-danger shadow-lg" style="box-shadow: 4px 6px 12px rgba(0, 0, 0, 0.5) !important;"></i> Print
                                    </button>
                                    <button type="button" class="btn btn-success btn-sm rounded-3" onclick="exportToExcel()">
                                        <i class="fas fa-file-excel bg-white p-1 rounded-circle text-success shadow-lg" style="box-shadow: 4px 6px 12px rgba(0, 0, 0, 0.5) !important;"></i>Excel
                                    </button>
                                    <button type="button" class="btn btn-dark btn-sm rounded-3" onclick="window.location.href='<?= base_url() ?>admin/Award/dashboard'">
                                        <i class="fa-solid fa-home bg-white p-1 rounded-circle text-dark shadow-lg"></i>Home
                                    </button>
                                </div>
                            </div>

                            <!-- Data Table -->
                            <div class="table-responsive mt-3" id="printableTable">
                                <table id="leavetable" class="table custom-table">
                                    <thead style="background-color: #1273eb;">
                                        <tr>
                                            <th>Sr.No.</th>
                                            <th>Institute Award Name</th>
                                            <th>Award Certificate</th>
                                            <th>Award Amount</th>
                                            <th>Award Type</th>
                                            <th>Awarded By</th>
                                            <!--<th>Institute Name</th>-->
                                        </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>

                            <hr>

                            <!-- Graphical Report Section -->
                            <div class="row mb-3">
                                <div class="col-md-12 d-flex align-items-center">
                                    <button type="button" class="btn btn-sm btn-primary me-2" onclick="toggleFilterSection()">
                                        <i class="fas fa-filter shadow-lg"></i> Graphical Report
                                    </button>
                                </div>
                            </div>

                            <!-- Filter Section for Charts -->
                             <div id="filterSectionNew">
                            <div id="filterSection" class="card mb-3 p-3" style="display:none;">
                                <div class="row align-items-center">
                                    <div class="col-md-4">
                                        <div class="field-wrapper">
                                            <select class="select-single js-states" id="year_id" name="year_id[]" multiple="multiple">
                                                <?php foreach($yeardata as $rw=>$value){ ?>
                                                    <option value="<?= $value->finiYear_id ?>"><?= $value->fini_Label ?></option>
                                                <?php } ?>
                                            </select>
                                            <div class="field-placeholder">Year</div>
                                        </div>
                                    </div>

                                    <div class="col-md-4 d-flex mb-2 align-items-center">
                                        <button type="button" class="btn btn-success me-2 custom-gradient-btn" id="searchBtn">
                                            <i class="fas fa-search me-1"></i> Search
                                        </button>
                                        <button type="button" class="btn btn-danger custom-gradient-btn bg-danger" onclick="printCombinedChart()" style="box-shadow: 4px 6px 12px rgba(0, 0, 0, 0.5) !important;">
                                            <i class="fas fa-print me-1 bg-white p-1 rounded-circle text-danger shadow-lg"></i> Print
                                        </button>
                                    </div>
                                </div>
                            </div>

                            <!-- Charts Row -->
                            <div id="chartLoader" style="display:none; text-align:center; margin:20px 0;">
    <div class="spinner-border text-primary"></div>
    <p>Loading charts...</p>
</div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="card p-3 text-center">
                                        <h5>Yearwise Chart</h5>
                                        <div style="height:250px;">
                                            <canvas id="yearChart"></canvas>
                                            <div id="yearDetails"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="<?php echo base_url();?>Assets/js/jquery.min.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
// Show Data Handler - UPDATED WITHOUT INSTITUTE FILTER
$(document).ready(function () {
    $('#btnShow').click(function () {
        var fkAwardType_id = $('#fkAwardType_id').val();
        var year_dropdown  = $('#year_dropdown').val();

        // Show spinner
        $('#leavetable tbody').html(`
            <tr>
                <td colspan="7" class="text-center">
                    <div class="table-spinner"></div>
                    <div>Loading data...</div>
                </td>
            </tr>
        `);

        var startTime = new Date().getTime();

        $.ajax({
            url: '<?= base_url("admin/Award/showAllData") ?>',
            type: 'POST',
            data: { 
                fkAwardType_id: fkAwardType_id,
                year: year_dropdown
            },
            dataType: 'json',
            success: function (response) {
                let html = '';

                if (response.length > 0) {
                    $.each(response, function (index, item) {
                        html += `<tr>
                            <td>${index + 1}</td>
                            <td>${item.Award_name}</td>
                            <td>
                                ${item.AwardCertify 
                                    ? `<a href="<?= base_url() ?>${item.AwardCertify}" target="_blank" style="color:#1273eb;">View Certificate</a>` 
                                    : ''}
                            </td>
                            <td>${item.AwardAmt}</td>
                            <td>${item.leval_name}</td>
                            <td>${item.AwardedBy}</td>
                           
                        </tr>`;
                    });
                } else {
                    html = `<tr><td colspan="7" class="text-center text-danger">No data found</td></tr>`;
                }

                var elapsed = new Date().getTime() - startTime;
                var delay = elapsed < 500 ? 500 - elapsed : 0;

                setTimeout(function () {
                    $('#leavetable tbody').html(html);
                }, delay);
            },
            error: function () {
                $('#leavetable tbody').html(`
                    <tr><td colspan="7" class="text-center text-danger">Error loading data</td></tr>
                `);
            }
        });
    });
});

// Print Table Function
function printTable() {
    const printElement = document.getElementById('printableTable');
 
    $.ajax({
        url: '<?= base_url("admin/Award/getPrintHeadings") ?>',
        method: 'GET',
        dataType: 'json',
        success: function (heading) {
            const iframe = document.createElement('iframe');
            iframe.style.position = 'fixed';
            iframe.style.right = '0';
            iframe.style.bottom = '0';
            iframe.style.width = '0';
            iframe.style.height = '0';
            iframe.style.border = '0';
            document.body.appendChild(iframe);
 
            const doc = iframe.contentWindow.document;
            const baseUrl = '<?= base_url() ?>';
            let logoPath = heading.logo || 'Assets/images/sit_logo.png';
            logoPath = logoPath.replace(/^\/+/, '');
            const fullLogoPath = baseUrl + logoPath;
 
            const clonedTable = printElement.cloneNode(true);
            const table = clonedTable.querySelector('table');
            
            // Remove Award Certificate column
            const headerRow = table.querySelector('thead tr');
            if (headerRow) {
                const headerCells = headerRow.querySelectorAll('th');
                if (headerCells[2]) headerCells[2].remove();
            }
            
            const bodyRows = table.querySelectorAll('tbody tr');
            bodyRows.forEach(row => {
                const cells = row.querySelectorAll('td');
                if (cells[2]) cells[2].remove();
            });
 
            doc.open();
            doc.write(`
                <html>
                <head>
                    <title>Print</title>
                    <style>
                        body { font-family: sans-serif; margin: 10px 5px; padding: 0; }
                        .header-section { display: flex; align-items: center; justify-content: center; gap: 10px; margin-bottom: 5px; }
                        .logo-container img { max-height: 80px; max-width: 80px; width: auto; height: auto; }
                        .heading-content { text-align: center; }
                        h4, h6, .sub-heading, .autonomous-badge { margin: 0; padding: 0; }
                        h4 { font-size: 20px; font-weight: bold; color: #d32f2f; }
                        h6 { font-size: 14px; font-weight: normal; }
                        .sub-heading, .autonomous-badge { font-size: 14px; }
                        table { width: 100%; border-collapse: collapse; margin-top: 5px; }
                        th, td { border: 1px solid black; padding: 4px; text-align: center; word-break: break-word; }
                    </style>
                </head>
                <body>
                    <div class="header-section">
                        <div class="logo-container">
                            <img src="${fullLogoPath}" alt="Logo" onerror="this.style.display='none';">
                        </div>
                        <div class="heading-content">
                            <h6>${heading.subHead1 || ''}</h6>
                            <h4>${heading.head || ''}</h4>
                            <div class="autonomous-badge">${heading.subHead2 || ''}</div>
                            <div class="sub-heading">${heading.subHead3 || ''}</div>
                        </div>
                    </div>
                    <br>
                    ${clonedTable.outerHTML}
                </body>
                </html>
            `);
            doc.close();
 
            iframe.contentWindow.onload = function() {
                setTimeout(function() {
                    iframe.contentWindow.focus();
                    iframe.contentWindow.print();
                }, 500);
            };
 
            setTimeout(() => { document.body.removeChild(iframe); }, 3000);
        }
    });
}

// Export to Excel
function exportToExcel() {
    $.ajax({
        url: '<?= base_url("admin/Award/getPrintHeadings") ?>',
        method: 'GET',
        dataType: 'json',
        success: function (heading) {
            var wb = XLSX.utils.book_new();
            var header = [
                [heading.subHead1 || ''],
                [heading.head || ''],
                [heading.subHead2 || ''],
                [heading.subHead3 || ''],
                [''] 
            ];

            var table = document.getElementById('printableTable');
            var wsTable = XLSX.utils.table_to_sheet(table);
            var tableData = XLSX.utils.sheet_to_json(wsTable, { header: 1 });
            var fullData = header.concat(tableData);
            var ws = XLSX.utils.aoa_to_sheet(fullData);
            
            XLSX.utils.book_append_sheet(wb, ws, 'Institute Award');
            XLSX.writeFile(wb, 'Institute_Award.xlsx');
        }
    });
}

// Chart Functions
let yearChart = null;

function toggleFilterSection() {
    $("#filterSection").slideToggle();
}

$("#searchBtn").on("click", function () {

    $("#chartLoader").show();      // Show loader
    $("#yearChart").hide();        // Hide chart until data loads
    $("#yearDetails").html("");    

    let selectedYears = $("#year_id").val();

    $.ajax({
        url: "<?= base_url('admin/Award/getCombinedData') ?>",
        type: "POST",
        data: { years: selectedYears },
        dataType: "json",

        beforeSend: function () {
            $("#chartLoader").html(`
                <div class="spinner-border text-info"></div>
                <p>Please wait, loading chart...</p>
            `);
        },

        success: function (response) {
            if (response.status === "success") {

                renderYearChart({
                    labels: response.yearData.map(y => y.year),
                    values: response.yearData.map(y => y.count),
                    ids: response.yearData.map(y => y.year_id)
                });

                $("#yearChart").show(); // Show chart after render
            }
        },

        complete: function () {
            $("#chartLoader").hide();   // Hide loader
        }
    });
});


function renderYearChart(data) {
    const ctx = document.getElementById("yearChart").getContext("2d");
    if (yearChart) yearChart.destroy();

    yearChart = new Chart(ctx, {
        type: "bar",
        data: {
            labels: data.labels,
            datasets: [{ 
                label: 'Award', 
                data: data.values, 
                borderWidth: 1, 
                backgroundColor: "rgba(18,115,235,0.7)" 
            }]
        },
        options: {
            responsive: true,
            scales: { y: { beginAtZero: true } },
            onClick: function (event, elements) {
                if (elements.length > 0) {
                    const idx = elements[0].index;
                    const yearId = data.ids[idx];
                    const yearLabel = data.labels[idx];
                    loadYearDetails(yearId, yearLabel);
                }
            }
        }
    });
}

function loadYearDetails(yearId, yearLabel) {
    $.ajax({
        url: "<?= base_url('admin/Award/getYearwiseData') ?>",
        type: "POST",
        data: { year: yearId },
        dataType: "json",
        beforeSend: function () {
            $("#yearDetails").html(`<div class="text-center"><div class="spinner-border text-success"></div><p>Loading ${yearLabel} details...</p></div>`);
        },
        success: function (response) {
            if (response.status === "success") {
                populateYearTable(response.types, yearLabel);
            } else {
                $("#yearDetails").html(`<p class="text-danger">No data for ${yearLabel}</p>`);
            }
        }
    });
}

function populateYearTable(data, yearLabel) {
    let html = `
        <div class="card mt-3">
            <div class="card-header bg-success text-white"><h5>${yearLabel} - Institute Award Details</h5></div>
            <div class="card-body year">
                <table class="table table-bordered">
                    <thead>
                        <tr class="head">
                            <th style="color:black !important;">Sr.No</th>
                            <th style="color:black !important;">Award Name</th>
                            <th style="color:black !important;">Award Type</th>
                            <th style="color:black !important">Year</th>
                        </tr>
                    </thead>
                    <tbody id="yearid">`;
    
    if (data.length > 0) {
        data.forEach((row, i) => {
            html += `<tr>
                        <td>${i + 1}</td>
                        <td>${row.Award_name || '-'}</td>
                        <td>${row.leval_name || '-'}</td>
                        <td>${row.year || '-'}</td>
                     </tr>`;
        });
    } else {
        html += `<tr><td colspan="4" class="text-center">No records found</td></tr>`;
    }
    html += `</tbody></table></div></div>`;
    $("#yearDetails").html(html);
}

function printCombinedChart() {
    const yearChartImg = yearChart.toBase64Image();
    const yearTable = document.getElementById("yearDetails").innerHTML;
 
    let printFrame = document.getElementById('printFrame');
    if (printFrame) printFrame.remove();
   
    printFrame = document.createElement('iframe');
    printFrame.id = 'printFrame';
    printFrame.style.position = 'absolute';
    printFrame.style.width = '0';
    printFrame.style.height = '0';
    printFrame.style.border = 'none';
    document.body.appendChild(printFrame);
   
    const frameDoc = printFrame.contentWindow.document;
    frameDoc.open();
    frameDoc.write(`
        <!DOCTYPE html>
        <html>
        <head>
            <title>Charts & Tables Print</title>
            <style>
                @page { size: A4; margin: 15mm; }
                body { font-family: Arial, sans-serif; margin: 0; padding: 20px; }
                .chart-section { margin-bottom: 20px; }
                .chart-section h2 { font-size: 18px; margin-bottom: 15px; color: #000; }
                img { max-width: 100%; height: auto; display: block; margin-bottom: 15px; }
                table { width: 100%; border-collapse: collapse; margin-bottom: 20px; font-size: 11px; }
                th, td { border: 1px solid #333; padding: 6px 8px; text-align: left; }
                th { background: #f2f2f2; color: #000; font-weight: bold; }
            </style>
        </head>
        <body>
            <div class="chart-section">
                <h2>Yearwise Chart</h2>
                <img src="${yearChartImg}" alt="Year Chart">
            </div>
            <div class="table-section">
                <h3>Institute Award Details</h3>
                ${yearTable}
            </div>
        </body>
        </html>
    `);
    frameDoc.close();
   
    setTimeout(() => {
        printFrame.contentWindow.focus();
        printFrame.contentWindow.print();
        setTimeout(() => { if (printFrame) printFrame.remove(); }, 100);
    }, 500);
}
</script>