<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<style>
/* .table-spinner {
    border: 3px solid #f3f3f3;
    border-top: 3px solid #1273eb;
    border-radius: 50%;
    width: 40px;
    height: 40px;
    animation: spin 1s linear infinite;
    margin: 20px auto;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}



.custom-gradient-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(0,0,0,0.15);
}

.view-club-details.active {
    background-color: #28a745 !important;
    border-color: #28a745 !important;
}

.chart-container {
    display: none;
}

.chart-container.show {
    display: block;
} */

 
</style>

<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1">Chapter Report</div>
                    </div>
                    <div class="card-body">
                        <form role="form" id="Form">
                            <div class="row gutters">
                                <!-- Institute Dropdown -->
                                <!-- <div class="col-md-4 col-12">
                                    <div class="field-wrapper">
                                        <select class="select-single js-states" title="Select Institute" data-live-search="true" name="fk_institu" id="fk_institu">
                                            <option value="">Select Institute</option>
                                            <?php foreach($institutedata as $value): ?>
                                                <option value="<?= $value->Institu_id ?>"><?= $value->Institu_name ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Institute Name</div>
                                    </div>
                                </div> -->

                                <div class="col-md-4 col-12">
                                                <div class="field-wrapper">
                                                    <select class="select-single js-states" title="Select Product Category" data-live-search="true" name="fk_institu" id="fk_institu" disabled>
                                                       
                                                         <?php
            foreach($institutedata as $rw=>$value){
                $selected = "";
                if (!empty($data[0]->fk_institu)) {
                    if ($value->Institu_id == $data[0]->fk_institu) {
                        $selected = "selected='selected'";
                    }
                }
                echo '<option value="'.$value->Institu_id.'"'.$selected.' >'.$value->Institu_name.'</option>';
            }
        ?>
                                                    </select>
                                                    <div class="field-placeholder">Institute Name</div>
                                                </div>
                                            </div>
 

                                <!-- Branch Dropdown (Multiple) -->
                                <div class="col-md-3">
                                    <div class="field-wrapper">
                                        <select class="form-control select-single" name="fkbranch_id[]" id="fkbranch_id" multiple>
                                            <option value="">Select Branch</option>
                                            <?php foreach ($Branch as $b): ?>
                                                <option value="<?= $b->branch_id ?>"><?= $b->branch_name ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Branch</div>
                                    </div>
                                </div>

                                <!-- Faculty Dropdown (Multiple) -->
                                <div class="col-md-3">
                                    <div class="field-wrapper">
                                        <select class="form-control select-single" name="fkFacCo_id[]" id="fkFacCo_id" multiple>
                                            <option value="">Select Faculty</option>
                                            <?php if (!empty($Faculty)): foreach ($Faculty as $f): ?>
                                                <option value="<?= $f->fac_id ?>"><?= $f->fac_Fullname ?></option>
                                            <?php endforeach; endif; ?>
                                        </select>
                                        <div class="field-placeholder">Faculty Co-Ordinator</div>
                                    </div>
                                </div>

                                <!-- Student Dropdown (Multiple) -->
                                <div class="col-md-3">
                                    <div class="field-wrapper">
                                        <select class="form-control select-single" name="fkStudCo_id[]" id="fkStudCo_id" multiple>
                                            <option value="">Select Student</option>
                                            <?php if (!empty($Student)): foreach ($Student as $s): ?>
                                                <option value="<?= $s->Student_id ?>"><?= $s->FullName ?></option>
                                            <?php endforeach; endif; ?>
                                        </select>
                                        <div class="field-placeholder">Student Co-Ordinator</div>
                                    </div>
                                </div>

                                <!-- Year Dropdown -->
                                <div class="col-md-2">
                                    <div class="field-wrapper">
                                        <select class="select-single js-states" title="Select Year" data-live-search="true" name="year" id="year_dropdown">
                                            <option value="0">All Years</option>
                                            <?php foreach ($yeardata as $value): 
                                                $selected = ($value->finiYear_id == $active_year_id) ? "selected='selected'" : "";
                                            ?>
                                                <option value="<?= $value->finiYear_id ?>" <?= $selected ?>><?= $value->fini_Label ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Select Year</div>
                                    </div>
                                </div>

                                <!-- Start Date -->
                                <!-- <div class="col-md-2">
                                    <div class="field-wrapper">
                                        <input type="date" class="form-control" name="startdate" id="startdate">
                                        <div class="field-placeholder">Start Date</div>
                                    </div>
                                </div> -->

                                <!-- End Date -->
                                <!-- <div class="col-md-2">
                                    <div class="field-wrapper">
                                        <input type="date" class="form-control" name="enddate" id="enddate">
                                        <div class="field-placeholder">End Date</div>
                                    </div>
                                </div> -->

                                <!-- Show Button -->
                                <div class="col-md-3">
                                    <button class="btn btn-success btn-sm m-1 custom-gradient-btn" type="button" id="btnShow" style="padding: 8px 20px;font-size: 13px; font-weight:600;">
                                        <i class="fas fa-search"></i> Show Result
                                    </button>
                                </div>
                            </div>

                            <!-- Action Buttons -->
                            <div class="row mt-3">
                                <div class="col-md-12 text-right">
                                    <button class="btn btn-danger btn-sm rounded-3" type="button" onclick="printTable()">
                                        <i class="fas fa-print bg-white p-1 rounded-circle text-danger shadow-lg" style="box-shadow: 4px 6px 12px rgba(0, 0, 0, 0.5) !important;"></i> Print
                                    </button>
                                    <button type="button" class="btn btn-success btn-sm rounded-3" onclick="exportToExcel()">
                                        <i class="fas fa-file-excel bg-white p-1 rounded-circle text-success shadow-lg" style="box-shadow: 4px 6px 12px rgba(0, 0, 0, 0.5) !important;"></i> Excel
                                    </button>
                                    <button type="button" class="btn btn-dark btn-sm rounded-3" onclick="window.location.href='<?= base_url() ?>admin/StudnewChapter/dashboard'">
                                        <i class="fa-solid fa-home bg-white p-1 rounded-circle text-dark shadow-lg"></i> Home
                                    </button>
                                </div>
                            </div>

                            <!-- Main Table -->
                            <div class="table-responsive mt-3" id="printableTable">
                                <table id="leavetable" class="table custom-table">
                                    <thead style="background-color: #1273eb;">
                                        <tr>
                                            <th>Sr.No.</th>
                                            <th>Action</th>
                                            <th>Name of Chapter</th>
                                            <th>Faculty Co-Ordinator</th>
                                            <th>President of Chapter</th>
                                            <th>Chapter Link Details</th>
                                            <th>Objective Of Chapter</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td colspan="7" class="text-center">Click "Show Result" to load data</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <hr>

                               <div class="col-md-4 mt-3">
            <div class="field-wrapper">
                <select id="clubDropdown"  class="form-control select-single">
        <option value="">Select Chapter</option>
        <?php foreach ($clubNames as $chapter): ?>
            <option value="<?= $chapter->club_id ?>"><?= htmlspecialchars($chapter->NameClub) ?></option>
        <?php endforeach; ?>
    </select>
                <div class="field-placeholder">Name Of Chapter</div>
            </div>
        </div>
</div>

                            <!-- Students, Faculty and Activities Tables -->
                            <div class="row mt-4">
                                <!-- ✅ Faculty Table -->
                                <div class="col-md-6">
                                    <div class="card p-3">
                                        <div class="card-header bg-warning text-white">
                                            <h5>Faculty List</h5>
                                        </div>
                                        <div class="card-body">
                                            <table class="table table-bordered" id="facultyListTable">
                                                <thead>
                                                    <tr class="head">
                                                        <th style="color:black !important">ID</th>
                                                        <th style="color:black !important">Faculty Name</th>
                                                        <th style="color:black !important">Mobile</th>
                                                        <th style="color:black !important">Email</th>
                                                        <th style="color:black !important">Branch</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td colspan="5" class="text-center">Click "View" button to see faculty</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <!-- Students Table -->
                                <div class="col-md-6">
                                    <div class="card p-3">
                                        <div class="card-header bg-success text-white">
                                            <h5>Student List</h5>
                                        </div>
                                        <div class="card-body">
                                            <table class="table table-bordered" id="studentListTable">
                                                <thead>
                                                    <tr>
                                                        <th style="color:black !important">ID</th>
                                                        <th style="color:black !important">PRN</th>
                                                        <th style="color:black !important">Student Name</th>
                                                        <th style="color:black !important">Branch</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td colspan="4" class="text-center">Click "View" button to see students</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <!-- Activities Table -->
                                <div class="col-md-12">
                                    <div class="card p-3">
                                        <div class="card-header bg-primary text-white">
                                            <h5>Activities</h5>
                                        </div>
                                        <div class="card-body">
                                            <table class="table table-bordered" id="activitiesTable">
                                                <thead>
                                                    <tr>
                                                        <th style="color:black !important">ID</th>
                                                        <th style="color:black !important">Activity Name</th>
                                                        <th style="color:black !important">Date</th>
                                                        <th style="color:black !important">Student Count</th>
                                                        <th style="color:black !important">Remark</th>
                                                        <th style="color:black !important">Photo</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td colspan="6" class="text-center">Click "View" button to see activities</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <hr>

                            <!-- ✅ Graphical Report Section - Shows when Search clicked -->
                            <div class="row mb-3">
                                <div class="col-md-3 d-flex align-items-center">
                                    <button type="button" class="btn btn-sm btn-primary me-2" onclick="toggleFilterSection()">
                                        <i class="fas fa-filter shadow-lg"></i> Graphical Report
                                    </button>
                                </div>
                            </div>

                            <!-- Filter Section -->
                            <div id="filterSection" class="card mb-3 p-3" style="display:none;">
                                <div class="row align-items-center">
                                    <div class="col-md-4">
                                        <div class="field-wrapper">
                                            <select class="select-single js-states" id="year_id" name="year_id[]" multiple="multiple">
                                                <?php foreach($yeardata as $value): ?>
                                                    <option value="<?= $value->finiYear_id ?>"><?= $value->fini_Label ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <div class="field-placeholder">Year</div>
                                        </div>
                                    </div>
                                    <div class="col-md-4 d-flex mb-2 align-items-center">
                                        <!-- ✅ Search Button - Shows Graph -->
                                        <button type="button" class="btn btn-success me-2 custom-gradient-btn" id="searchBtn">
                                            <i class="fas fa-search me-1"></i> Search
                                        </button>
                                        <button type="button" class="btn btn-danger btn-sm rounded-3" onclick="printCombinedChart()" style="box-shadow: 4px 6px 12px rgba(0, 0, 0, 0.5) !important;">
                                            <i class="fas fa-print me-1 bg-white p-1 rounded-circle text-danger shadow-lg"></i> Print
                                        </button>
                                    </div>
                                </div>
                            </div>

                            <!-- Chart Loader -->
                            <div id="chartLoader" style="display:none; text-align:center; margin:20px 0;">
                                <div class="spinner-border text-primary"></div>
                                <p>Loading charts...</p>
                            </div>

                            <!-- ✅ Charts Container - Hidden until Search is clicked -->
                            <div class="chart-container" id="chartContainer">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="card p-3 text-center">
                                            <h5>Yearwise Chart</h5>
                                            <div style="height:250px;">
                                                <canvas id="yearChart"></canvas>
                                                <div id="yearDetails"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="<?php echo base_url();?>Assets/js/jquery.min.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
// Global variables
let yearChart = null;
let currentActiveClubId = null;

// Date formatting
function formatDate(dateStr) {
    const dateObj = new Date(dateStr);
    const day = String(dateObj.getDate()).padStart(2, '0');
    const month = String(dateObj.getMonth() + 1).padStart(2, '0');
    const year = dateObj.getFullYear();
    return `${day}-${month}-${year}`;
}

// ✅ Populate Faculty Table
function populateFaculty(faculties) {
    let tbody = $('#facultyListTable tbody');
    tbody.empty();
    
    if(faculties && faculties.length > 0) {
        $.each(faculties, function(index, faculty) {
            tbody.append(`
                <tr>
                    <td>${faculty.id || '-'}</td>
                    <td>${faculty.Faculty_Name || '-'}</td>
                    <td>${faculty.Mobile || '-'}</td>
                    <td>${faculty.Email_id || '-'}</td>
                    <td>${faculty.Branch || '-'}</td>
                </tr>
            `);
        });
    } else {
        tbody.append('<tr><td colspan="5" class="text-center">No faculty found.</td></tr>');
    }
}

// ✅ Populate Activities Table
function populateActivities(activities) {
    let tbody = $('#activitiesTable tbody');
    tbody.empty();
    
    if(activities && activities.length > 0) {
        $.each(activities, function(index, activity) {
            let baseUrl = '<?= base_url() ?>';
            let photoPath = activity.photo ? activity.photo.replace(/^\/+/, '') : '';
            let photoUrl = photoPath ? baseUrl + photoPath : 'https://via.placeholder.com/100';
            let fileExt = photoPath.split('.').pop().toLowerCase();
            let photoHtml = '';

            if(fileExt === 'jpg' || fileExt === 'jpeg' || fileExt === 'png' || fileExt === 'gif') {
                photoHtml = `<a href="${photoUrl}" target="_blank"><img src="${photoUrl}" alt="Photo" style="width: 100px; height: auto;"></a>`;
            } else if(fileExt === 'pdf') {
                photoHtml = `<a href="${photoUrl}" target="_blank"><img src="https://via.placeholder.com/100?text=PDF" alt="view pdf" style="width: 100px; height: auto;"></a>`;
            } else if(photoPath) {
                photoHtml = `<a href="${photoUrl}" target="_blank">Open File</a>`;
            } else {
                photoHtml = 'No photo';
            }

            tbody.append(`
                <tr>
                    <td>${activity.id || '-'}</td>
                    <td>${activity.activity_name || '-'}</td>
                    <td>${activity.date ? formatDate(activity.date) : '-'}</td>
                    <td>${activity.student_count || 0}</td>
                    <td>${activity.remark || '-'}</td>
                    <td>${photoHtml}</td>
                </tr>
            `);
        });
    } else {
        tbody.append('<tr><td colspan="6" class="text-center">No activities found.</td></tr>');
    }
}

// ✅ Populate Students Table
function populateStudents(students) {
    let tbody = $('#studentListTable tbody');
    tbody.empty();
    
    if(students && students.length > 0) {
        $.each(students, function(index, student) {
            tbody.append(`
                <tr>
                    <td>${student.id || '-'}</td>
                    <td>${student.prn || '-'}</td>
                    <td>${student.student_name || '-'}</td>
                    <td>${student.branch || '-'}</td>
                </tr>
            `);
        });
    } else {
        tbody.append('<tr><td colspan="4" class="text-center">No students found.</td></tr>');
    }
}

// Document Ready
$(document).ready(function () {
    
    // ✅✅✅ CHAPTER DROPDOWN CHANGE EVENT ✅✅✅
    $('#clubDropdown').on('change', function() {
        var club_id = $(this).val();
        
        console.log('Selected Chapter ID:', club_id); // Debug
        
        if(!club_id || club_id === '') {
            $('#activitiesTable tbody').html('<tr><td colspan="6" class="text-center">Please select a chapter</td></tr>');
            $('#studentListTable tbody').html('<tr><td colspan="4" class="text-center">Please select a chapter</td></tr>');
            $('#facultyListTable tbody').html('<tr><td colspan="5" class="text-center">Please select a chapter</td></tr>');
            return;
        }

        // Show loaders
        $('#activitiesTable tbody').html('<tr><td colspan="6" class="text-center"><div class="spinner-border"></div><p>Loading activities...</p></td></tr>');
        $('#studentListTable tbody').html('<tr><td colspan="4" class="text-center"><div class="spinner-border"></div><p>Loading students...</p></td></tr>');
        $('#facultyListTable tbody').html('<tr><td colspan="5" class="text-center"><div class="spinner-border"></div><p>Loading faculty...</p></td></tr>');
        
        // Scroll to tables
        $('html, body').animate({
            scrollTop: $("#facultyListTable").offset().top - 100
        }, 500);
        
        // AJAX Call
        $.ajax({
            url: '<?= base_url("admin/ChapterReport/getClubDetails") ?>',
            type: 'POST',
            data: { club_id: club_id },
            dataType: 'json',
            success: function(response) {
                console.log('Response:', response); // Debug
                
                if(response.status === 'success') {
                    populateFaculty(response.faculties);
                    populateStudents(response.students);
                    populateActivities(response.activities);
                } else {
                    Swal.fire('Error', response.message || 'Failed to load data', 'error');
                }
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error:', error); // Debug
                console.error('Response:', xhr.responseText); // Debug
                
                $('#activitiesTable tbody').html('<tr><td colspan="6" class="text-center text-danger">Error loading activities</td></tr>');
                $('#studentListTable tbody').html('<tr><td colspan="4" class="text-center text-danger">Error loading students</td></tr>');
                $('#facultyListTable tbody').html('<tr><td colspan="5" class="text-center text-danger">Error loading faculty</td></tr>');
                
                Swal.fire('Error', 'Failed to load chapter details: ' + error, 'error');
            }
        });
    });

    // Show Button Click
    $('#btnShow').click(function () {
        var fk_institu = $('#fk_institu').val();
        var startdate = $('#startdate').val();
        var enddate = $('#enddate').val();
        var year = $('#year_dropdown').val();

        if (!fk_institu) {
            Swal.fire('Error', 'Please select an institute.', 'error');
            return;
        }

        $('#leavetable tbody').html(`
            <tr>
                <td colspan="7" class="text-center">
                    <div class="table-spinner"></div>
                    <div>Loading data...</div>
                </td>
            </tr>
        `);

        var startTime = new Date().getTime();

        $.ajax({
            url: '<?= base_url("admin/ChapterReport/showDataByInstitute") ?>',
            type: 'POST',
            data: { 
                InstituteId: fk_institu,
                startdate: startdate,
                enddate: enddate,
                fkbranch_id: $('#fkbranch_id').val(),
                fkFacCo_id: $('#fkFacCo_id').val(),
                fkStudCo_id: $('#fkStudCo_id').val(),
                year: year
            },
            dataType: 'json',
            success: function (response) {
                let html = '';

                if (response.length > 0) {
                    $.each(response, function (index, item) {
                        html += `<tr>
                            <td>${index + 1}</td>
                            <td>
                                <button class="btn btn-sm btn-primary view-club-details" 
                                        data-club-id="${item.club_id}" 
                                        title="View Details">
                                    <i class="fas fa-eye"></i> View
                                </button>
                            </td>
                            <td>${item.NameClub ?? ''}</td>
                            <td>${item.faculty_name ?? ''}</td>
                            <td>${item.student_name ?? ''}</td>
                            <td>
                                ${item.LinkDetails 
                                    ? `<a href="${item.LinkDetails}" target="_blank" style="color:#1273eb;">View Link</a>` 
                                    : ''}
                            </td>
                            <td>${item.Acheivment ?? ''}</td>
                        </tr>`;
                    });
                } else {
                    html = `<tr><td colspan="7" class="text-center text-danger">No data found</td></tr>`;
                }

                var elapsed = new Date().getTime() - startTime;
                var delay = elapsed < 500 ? 500 - elapsed : 0;

                setTimeout(function () {
                    $('#leavetable tbody').html(html);
                }, delay);
            },
            error: function () {
                $('#leavetable tbody').html(`
                    <tr><td colspan="7" class="text-center text-danger">Error loading data</td></tr>
                `);
            }
        });
    });

    // View Button (from table)
    $(document).on('click', '.view-club-details', function(e) {
        e.preventDefault();
        var club_id = $(this).data('club-id');
        
        if(!club_id) {
            Swal.fire('Error', 'Invalid club ID', 'error');
            return;
        }

        $('#activitiesTable tbody').html('<tr><td colspan="6" class="text-center"><div class="spinner-border"></div><p>Loading activities...</p></td></tr>');
        $('#studentListTable tbody').html('<tr><td colspan="4" class="text-center"><div class="spinner-border"></div><p>Loading students...</p></td></tr>');
        $('#facultyListTable tbody').html('<tr><td colspan="5" class="text-center"><div class="spinner-border"></div><p>Loading faculty...</p></td></tr>');
        
        $('html, body').animate({
            scrollTop: $("#facultyListTable").offset().top - 100
        }, 500);
        
        $('.view-club-details').removeClass('active btn-success').addClass('btn-primary');
        $(this).removeClass('btn-primary').addClass('btn-success active');
        
        currentActiveClubId = club_id;
        
        $.ajax({
            url: '<?= base_url("admin/ChapterReport/getClubDetails") ?>',
            type: 'POST',
            data: { club_id: club_id },
            dataType: 'json',
            success: function(response) {
                if(response.status === 'success') {
                    populateActivities(response.activities);
                    populateStudents(response.students);
                    populateFaculty(response.faculties);
                } else {
                    Swal.fire('Error', response.message || 'Failed to load data', 'error');
                }
            },
            error: function(xhr, status, error) {
                $('#activitiesTable tbody').html('<tr><td colspan="6" class="text-center text-danger">Error loading activities</td></tr>');
                $('#studentListTable tbody').html('<tr><td colspan="4" class="text-center text-danger">Error loading students</td></tr>');
                $('#facultyListTable tbody').html('<tr><td colspan="5" class="text-center text-danger">Error loading faculty</td></tr>');
                Swal.fire('Error', 'Failed to load club details', 'error');
            }
        });
    });
});

// Rest of your code (charts, print, etc.) ...
// [Keep all other functions as they are]

// Toggle Filter Section
function toggleFilterSection() {
    $("#filterSection").slideToggle();
}

// ✅ Search Button - Shows Graph when clicked
$("#searchBtn").on("click", function () {
    // Show loader and chart container
    $("#chartLoader").show();
    $("#yearChart").hide();
    $("#yearDetails").html("");
    $("#chartContainer").addClass("show");  // ✅ Show chart container

    let selectedYears = $("#year_id").val();

    $.ajax({
        url: "<?= base_url('admin/ChapterReport/getCombinedData') ?>",
        type: "POST",
        data: {
            fk_institu: $("#fk_institu").val(),
            years: selectedYears,
            StartDate: $("#startdate").val(),
            EndDate: $("#enddate").val()
        },
        dataType: "json",
        beforeSend: function () {
            $("#chartLoader").html(`
                <div class="spinner-border text-info"></div>
                <p>Please wait, loading chart...</p>
            `);
        },
        success: function (response) {
            if (response.status === "success") {
                renderYearChart({
                    labels: response.yearData.map(y => y.year),
                    values: response.yearData.map(y => y.count),
                    ids: response.yearData.map(y => y.year_id)
                });
                $("#yearChart").show();
                $("#yearDetails").html("");
            }
        },
        error: function (xhr, status, error) {
            console.error("AJAX Error:", error);
            Swal.fire('Error', 'Failed to load chart data', 'error');
        },
        complete: function () {
            $("#chartLoader").hide();
        }
    });
});

// Render Year Chart
function renderYearChart(data) {
    const ctx = document.getElementById("yearChart").getContext("2d");
    if (yearChart) yearChart.destroy();

    yearChart = new Chart(ctx, {
        type: "bar",
        data: {
            labels: data.labels,
            datasets: [{ 
                label: 'Number of Chapters', 
                data: data.values, 
                borderWidth: 1, 
                backgroundColor: "rgba(18,115,235,0.7)" 
            }]
        },
        options: {
            responsive: true,
            scales: { y: { beginAtZero: true } },
            onClick: function (event, elements) {
                if (elements.length > 0) {
                    const idx = elements[0].index;
                    const yearId = data.ids[idx];
                    const yearLabel = data.labels[idx];
                    loadYearDetails(yearId, yearLabel);
                }
            }
        }
    });
}

// Load Year Details
function loadYearDetails(yearId, yearLabel) {
    $.ajax({
        url: "<?= base_url('admin/ChapterReport/getYearwiseData') ?>",
        type: "POST",
        data: {
            year: yearId,
            fk_institu: $("#fk_institu").val(),
            branches: $("#fkbranch_id").val(),
            StartDate: $("#startdate").val(),
            EndDate: $("#enddate").val()
        },
        dataType: "json",
        beforeSend: function () {
            $("#yearDetails").html(`<div class="text-center"><div class="spinner-border text-success"></div><p>Loading ${yearLabel} details...</p></div>`);
        },
        success: function (response) {
            if (response.status === "success") {
                populateYearTable(response.types, yearLabel);
            } else {
                $("#yearDetails").html(`<p class="text-danger">No data for ${yearLabel}</p>`);
            }
        },
        error: function () {
            $("#yearDetails").html(`<p class="text-danger">Error loading ${yearLabel} data.</p>`);
        }
    });
}

// Populate Year Table
function populateYearTable(data, yearLabel) {
    let html = `
        <div class="card mt-3">
            <div class="card-header bg-success text-white"><h5>${yearLabel} - Chapter Details</h5></div>
            <div class="card-body year">
                <table class="table table-bordered">
                    <thead>
                        <tr class="head">
                            <th style="color:black !important;">Sr.No</th>
                            <th style="color:black !important;">Name of Chapter</th>
                            <th style="color:black !important">Year</th>
                        </tr>
                    </thead>
                    <tbody id="yearid">`;
    
    if (data.length > 0) {
        data.forEach((row, i) => {
            html += `<tr>
                        <td>${i + 1}</td>
                        <td>${row.NameClub || '-'}</td>
                        <td>${row.year || '-'}</td>
                     </tr>`;
        });
    } else {
        html += `<tr><td colspan="3" class="text-center">No records found</td></tr>`;
    }
    
    html += `</tbody></table></div></div>`;
    $("#yearDetails").html(html);
}

// Print Table Function
function printTable() {
    const printElement = document.getElementById('printableTable');
 
    $.ajax({
        url: '<?= base_url("admin/ChapterReport/getPrintHeadings") ?>',
        method: 'GET',
        dataType: 'json',
        success: function (heading) {
            const iframe = document.createElement('iframe');
            iframe.style.position = 'fixed';
            iframe.style.right = '0';
            iframe.style.bottom = '0';
            iframe.style.width = '0';
            iframe.style.height = '0';
            iframe.style.border = '0';
            document.body.appendChild(iframe);
 
            const doc = iframe.contentWindow.document;
            const baseUrl = '<?= base_url() ?>';
            let logoPath = heading.logo || 'Assets/images/sit_logo.png';
            logoPath = logoPath.replace(/^\/+/, '');
            const fullLogoPath = baseUrl + logoPath;
 
            const tableClone = printElement.cloneNode(true);
            const table = tableClone.querySelector('table');
            
            // Remove "Action" column (2nd column, index 1)
            const headerRow = table.querySelector('thead tr');
            if (headerRow && headerRow.cells[1]) {
                headerRow.deleteCell(1);
            }
            
            const bodyRows = table.querySelectorAll('tbody tr');
            bodyRows.forEach(row => {
                if (row.cells[1]) {
                    row.deleteCell(1);
                }
            });

            // Remove "Link Details" column (originally 6th, now 5th after action removed)
            if (headerRow && headerRow.cells[4]) {
                headerRow.deleteCell(4);
            }
            
            bodyRows.forEach(row => {
                if (row.cells[4]) {
                    row.deleteCell(4);
                }
            });
 
            doc.open();
            doc.write(`
                <html>
                <head>
                    <title>Print</title>
                    <style>
                        body {
                            font-family: sans-serif;
                            margin: 10px 5px;
                            padding: 0;
                        }
                        .header-section {
                            display: flex;
                            align-items: center;
                            justify-content: center;
                            gap: 10px;
                            margin-bottom: 5px;
                        }
                        .logo-container img {
                            max-height: 80px;
                            max-width: 80px;
                            width: auto;
                            height: auto;
                        }
                        .heading-content {
                            text-align: center;
                        }
                        h4, h6, .sub-heading, .autonomous-badge {
                            margin: 0;
                            padding: 0;
                        }
                        h4 {
                            font-size: 20px;
                            font-weight: bold;
                            color: #d32f2f;
                        }
                        h6 {
                            font-size: 14px;
                            font-weight: normal;
                        }
                        .sub-heading, .autonomous-badge {
                            font-size: 14px;
                        }
                        table {
                            width: 100%;
                            border-collapse: collapse;
                            margin-top: 5px;
                            table-layout: fixed;
                        }
                        th, td {
                            border: 1px solid black;
                            padding: 6px 4px;
                            text-align: center;
                            vertical-align: middle;
                            word-wrap: break-word;
                            font-size: 12px;
                        }
                    </style>
                </head>
                <body>
                    <div class="header-section">
                        <div class="logo-container">
                            <img src="${fullLogoPath}" alt="Logo">
                        </div>
                        <div class="heading-content">
                            <h6>${heading.subHead1 || ''}</h6>
                            <h4>${heading.head || ''}</h4>
                            <div class="autonomous-badge">${heading.subHead2 || ''}</div>
                            <div class="sub-heading">${heading.subHead3 || ''}</div>
                        </div>
                    </div>
                    <br>
                    ${tableClone.outerHTML}
                </body>
                </html>
            `);
            doc.close();
 
            iframe.contentWindow.onload = function() {
                setTimeout(function() {
                    iframe.contentWindow.focus();
                    iframe.contentWindow.print();
                }, 500);
            };
 
            setTimeout(() => {
                document.body.removeChild(iframe);
            }, 3000);
        },
        error: function(xhr, status, error) {
            console.error('AJAX Error:', error);
            Swal.fire('Error', 'Error loading print data', 'error');
        }
    });
}

// Export to Excel
function exportToExcel() {
    $.ajax({
        url: '<?= base_url("admin/ChapterReport/getPrintHeadings") ?>',
        method: 'GET',
        dataType: 'json',
        success: function (heading) {
            var wb = XLSX.utils.book_new();

            var header = [
                [heading.subHead1 || ''],
                [heading.head || ''],
                [heading.subHead2 || ''],
                [heading.subHead3 || ''],
                [''] 
            ];

            var table = document.getElementById('printableTable');
            var wsTable = XLSX.utils.table_to_sheet(table);
            var tableData = XLSX.utils.sheet_to_json(wsTable, { header: 1 });

            var fullData = header.concat(tableData);

            var ws = XLSX.utils.aoa_to_sheet(fullData);
            XLSX.utils.book_append_sheet(wb, ws, 'Chapter');
            XLSX.writeFile(wb, 'Student_Chapter_Report.xlsx');
        },
        error: function() {
            Swal.fire('Error', 'Failed to export Excel', 'error');
        }
    });
}

// Print Combined Chart
function printCombinedChart() {
    if(!yearChart) {
        Swal.fire('Error', 'Please generate chart first by clicking Search button', 'error');
        return;
    }

    const yearChartImg = yearChart.toBase64Image();
    const yearTable = document.getElementById("yearDetails").innerHTML;
 
    let printFrame = document.getElementById('printFrame');
    if (printFrame) {
        printFrame.remove();
    }
   
    printFrame = document.createElement('iframe');
    printFrame.id = 'printFrame';
    printFrame.style.position = 'absolute';
    printFrame.style.width = '0';
    printFrame.style.height = '0';
    printFrame.style.border = 'none';
   
    document.body.appendChild(printFrame);
   
    const frameDoc = printFrame.contentWindow.document;
    frameDoc.open();
    frameDoc.write(`
        <!DOCTYPE html>
        <html>
        <head>
            <title>Charts & Tables Print</title>
            <style>
                @page {
                    size: A4;
                    margin: 15mm;
                }
                body {
                    font-family: Arial, sans-serif;
                    margin: 0;
                    padding: 20px;
                }
                .chart-section {
                    margin-bottom: 20px;
                }
                .chart-section h2 {
                    font-size: 18px;
                    margin-bottom: 15px;
                    color: #000;
                }
                .table-section h3 {
                    font-size: 14px;
                    margin: 15px 0 10px 0;
                    color: #000;
                }
                img {
                    max-width: 100%;
                    height: auto;
                    display: block;
                    margin-bottom: 15px;
                }
                table {
                    width: 100%;
                    border-collapse: collapse;
                    margin-bottom: 20px;
                    font-size: 11px;
                }
                th, td {
                    border: 1px solid #333;
                    padding: 6px 8px;
                    text-align: left;
                }
                th {
                    background: #f2f2f2;
                    color: #000;
                    font-weight: bold;
                }
                .page-break {
                    page-break-before: always;
                }
            </style>
        </head>
        <body>
            <div class="chart-section">
                <h2>Yearwise Chart</h2>
                <img src="${yearChartImg}" alt="Year Chart">
            </div>
            <div class="table-section">
                ${yearTable}
            </div>
        </body>
        </html>
    `);
    frameDoc.close();
   
    setTimeout(() => {
        printFrame.contentWindow.focus();
        printFrame.contentWindow.print();
        setTimeout(() => {
            if (printFrame) {
                printFrame.remove();
            }
        }, 100);
    }, 500);
}
</script>