<style>
    .file-upload-cell {
        position: relative;
        width: 120px;
    }
    .file-input {
        position: absolute;
        opacity: 0;
        width: 100%;
        height: 100%;
        cursor: pointer;
    }
    .file-label {
        display: inline-block;
        background: #007bff;
        color: white;
        padding: 5px 10px;
        border-radius: 4px;
        cursor: pointer;
        font-size: 12px;
        text-align: center;
        width: 100px;
    }
    .file-label:hover {
        background: #0056b3;
    }
    .file-name {
        font-size: 10px;
        color: #666;
        margin-top: 2px;
        word-break: break-word;
    }
    .file-remove {
        color: red;
        cursor: pointer;
        font-size: 10px;
        margin-left: 5px;
    }
    .wide-th {
        width: 200px !important;  
    }
    
    .loader-overlay {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.7);
        z-index: 9999;
        justify-content: center;
        align-items: center;
    }

    .loader-overlay.active {
        display: flex;
    }

    .loader-content {
        text-align: center;
        background: white;
        padding: 30px;
        border-radius: 10px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
    }

    .spinner {
        border: 4px solid #f3f3f3;
        border-top: 4px solid #007bff;
        border-radius: 50%;
        width: 50px;
        height: 50px;
        animation: spin 1s linear infinite;
        margin: 0 auto 15px;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    .loader-text {
        font-size: 16px;
        color: #333;
        font-weight: 600;
    }
</style>

<div class="content-wrapper-scroll">
    <div class="loader-overlay" id="loaderOverlay">
        <div class="loader-content">
            <div class="spinner"></div>
            <div class="loader-text">Processing Excel File...</div>
        </div>
    </div>

    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1">Chapter Form</div>
                    </div>
                    <div class="card-body">
                        <form role="form" id="Form" method="post" enctype="multipart/form-data">
                            <div class="row gutters">
                                <input class="form-control" id="club_id" name="club_id" type="hidden"
                                    value="<?= !empty($data) ? $data[0]->club_id : '' ?>" />

                                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <div class="field-wrapper">
                                        <input class="form-control" type="text" name="NameClub" id="NameClub" required  
                                            value="<?php if(!empty($data)) echo $data[0]->NameClub; ?>">
                                        <div class="field-placeholder">Name of Chapter<span class="text-danger">*</span></div>
                                        <div class="form-text">Please enter name.</div>
                                    </div>
                                </div>

                                <div class="col-md-3">
                                    <div class="field-wrapper">
                                        <select class="form-control select-single" name="fkFacCo_id" id="fkFacCo_id" required>
                                            <option value="">Select Chapter</option>
                                            <?php if (!empty($Faculty)): foreach ($Faculty as $f): ?>
                                                <option value="<?= $f->fac_id ?>" 
                                                    <?= (!empty($data[0]->fkFacCo_id) && $f->fac_id == $data[0]->fkFacCo_id) ? 'selected' : '' ?>>
                                                    <?= $f->fac_Fullname ?>
                                                </option>
                                            <?php endforeach; endif; ?>
                                        </select>
                                        <div class="field-placeholder">Faculty Co-Ordinator <span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <div class="col-md-3">
                                    <div class="field-wrapper">
                                        <select class="form-control select-single" name="fkStudCo_id" id="fkStudCo_id">
                                            <option value="">Select Student</option>
                                            <?php if (!empty($Student)): foreach ($Student as $s): ?>
                                                <option value="<?= $s->Student_id ?>" 
                                                    <?= (!empty($data[0]->fkStudCo_id) && $s->Student_id == $data[0]->fkStudCo_id) ? 'selected' : '' ?>>
                                                    <?= $s->FullName ?>
                                                </option>
                                            <?php endforeach; endif; ?>
                                        </select>
                                        <div class="field-placeholder">Student Co-Ordinator</div>
                                    </div>
                                </div>

                                <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
                                    <div class="field-wrapper">
                                        <input class="form-control" type="number" name="StudMobNo" id="StudMobNo" 
                                            onKeyPress="if(this.value.length==10) return false;" 
                                            value="<?php if(!empty($data)) echo $data[0]->StudMobNo; ?>">
                                        <div class="field-placeholder">Student Chapter Contact</div>
                                    </div>
                                </div>

                                <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
                                    <div class="field-wrapper">
                                        <input class="form-control" type="number" name="FacMobNo" id="FacMobNo"  
                                            onKeyPress="if(this.value.length==10) return false;" 
                                            value="<?php if(!empty($data)) echo $data[0]->FacMobNo; ?>">
                                        <div class="field-placeholder">Faculty Contact</div>
                                    </div>
                                </div>

                                <div class="col-md-3">
                                    <div class="field-wrapper">
                                        <select class="form-control select-single" name="FiniYear" id="FiniYear">
                                            <option value="">Select Year</option>
                                            <?php if (!empty($Year)): foreach ($Year as $s): ?>
                                                <option value="<?= $s->finiYear_id ?>" 
                                                    <?= (!empty($data[0]->FiniYear) && $s->finiYear_id == $data[0]->FiniYear) ? 'selected' : '' ?>>
                                                    <?= $s->fini_Label ?>
                                                </option>
                                            <?php endforeach; endif; ?>
                                        </select>
                                        <div class="field-placeholder">Year</div>
                                    </div>
                                </div>

                                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <div class="field-wrapper">
                                        <textarea class="form-control" name="LinkDetails" id="LinkDetails" rows="3"><?php if(!empty($data)) echo $data[0]->LinkDetails; ?></textarea>
                                        <div class="field-placeholder">Chapter Link Details</div>
                                    </div>
                                </div>

                                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <div class="field-wrapper">
                                        <textarea class="form-control" name="Acheivment" id="Acheivment" rows="3"><?php if(!empty($data)) echo $data[0]->Acheivment; ?></textarea>
                                        <div class="field-placeholder">Objective of Chapter</div>
                                    </div>
                                </div>
                            </div>

                            <hr>

                            <!-- ========== STUDENT SECTION ========== -->
                            <div class="col-md-2 m-2">
                                <label for="StudParListFile" class="form-label">Choose Student Excel File</label>
                                <div class="card" id="cardBox"
                                     style="height: 120px; width: 70%; cursor: pointer; padding: 10px;
                                            border: 2px dashed black; text-align: center; display: flex;
                                            flex-direction: column; justify-content: flex-start; align-items: center;"
                                     onclick="document.getElementById('StudParListFile').click();">
                                    <img src="<?= base_url('Assets/img/excel.png'); ?>" id="defaultImg"
                                         style="max-height: 50px; object-fit: contain; margin-bottom: 5px;">
                                    <span id="fileText" style="font-size: 11px; color: black; font-weight:600;">
                                        (<span class="text-danger">*</span>File extension allowed: .xls .xlsx)
                                    </span>
                                    <input type="file" accept=".xls,.xlsx" style="display: none;"
                                           class="form-control form-control-sm"
                                           id="StudParListFile" name="StudParListFile">
                                </div>
                            </div><br><br><br><br><br><br><br><br><br>

                            <div class="row">
                                <div class="mb-2 text-end">
                                    <a href="<?= base_url("uploads/formatexcel/Chapter_Student.xlsx"); ?>" download
                                       style="color: #0b0a0aff; text-decoration: underline; font-weight: 600; font-size:14px;">
                                        <i class="fas fa-file-excel" style="color: green; margin-right: 6px; font-size:16px;"></i>
                                        Download Excel Format
                                    </a>
                                </div>
                            </div>

                            <div class="table-responsive">
                                <table id="studentParentTable" class="table custom-table">
                                    <thead class="table-black">
                                        <tr>
                                            <th>PRN</th>
                                            <th>Student Name</th>
                                            <th>Mobile No</th>
                                            <th>Branch</th>
                                            <th>Designation</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="studentParentTbody">
                                        <?php if (!empty($studentParentList)) { foreach ($studentParentList as $row) { ?>
                                            <tr>
                                                <td><input type="text" name="prn[]" maxlength="16"
                                                    oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 16);" 
                                                    value="<?= $row->prn ?>" class="form-control"></td>
                                                <td><input type="text" name="student_name[]" value="<?= $row->student_name ?>" class="form-control"></td>
                                                <td><input type="number" name="mobile_no[]" maxlength="10"
                                                    oninput="this.value=this.value.replace(/[^0-9]/g,'').slice(0,10);" 
                                                    value="<?= $row->mobile_no ?>" class="form-control"></td>
                                                <td><input type="text" name="branch[]" value="<?= $row->branch ?>" class="form-control"></td>
                                                <td><input type="text" name="Occupation[]" value="<?= $row->Occupation ?>" class="form-control"></td>
                                                <td><button type="button" class="btn btn-sm text-danger removeStudentRow ms-3">
                                                    <i class="fa-solid fa-trash"></i></button></td>
                                            </tr>
                                        <?php } } else { ?>
                                            <tr>
                                                <td><input type="text" name="prn[]" maxlength="16"
                                                    oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 16);" class="form-control"></td>
                                                <td><input type="text" name="student_name[]" class="form-control"></td>
                                                <td><input type="number" name="mobile_no[]" maxlength="10"
                                                    oninput="this.value=this.value.replace(/[^0-9]/g,'').slice(0,10);" class="form-control"></td>
                                                <td><input type="text" name="branch[]" class="form-control"></td>
                                                <td><input type="text" name="Occupation[]" class="form-control"></td>
                                                <td><button type="button" class="btn btn-sm text-danger removeStudentRow ms-3">
                                                    <i class="fa-solid fa-trash"></i></button></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                                <div class="ms-auto float-end">
                                    <button type="button" class="btn btn-success btn-sm p-2 rounded-3" id="addStudentRow">
                                        <i class="fa-solid fa-plus bg-white p-1 rounded-circle text-success shadow-lg"></i>Add Row
                                    </button>
                                </div>
                            </div>

                            <hr>

                            <!-- ========== ACTIVITY SECTION ========== -->
                            <div class="row">
                                <div class="col-md-2 m-2">
                                    <label for="ActivityExcelFile" class="form-label">Choose Activity Excel File</label>
                                    <div class="card" id="activityCardBox"
                                         style="height: 120px; width: 75%; cursor: pointer; padding: 10px;
                                                border: 2px dashed black; text-align: center; display: flex;
                                                flex-direction: column; justify-content: flex-start; align-items: center;"
                                         onclick="document.getElementById('ActivityExcelFile').click();">
                                        <img src="<?= base_url('Assets/img/excel.png'); ?>" id="activityDefaultImg"
                                             style="max-height: 50px; object-fit: contain; margin-bottom: 5px;">
                                        <span id="activityFileText" style="font-size: 11px; color: black; font-weight:600;">
                                            (<span class="text-danger">*</span>File extension allowed: .xls .xlsx)
                                        </span>
                                        <input type="file" accept=".xls,.xlsx" style="display: none;"
                                               class="form-control form-control-sm"
                                               id="ActivityExcelFile" name="ActivityExcelFile">
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="mb-2 text-end">
                                        <a href="<?= base_url("uploads/formatexcel/Chapter_Activities.xlsx"); ?>" download
                                           style="color: #0b0a0aff; text-decoration: underline; font-weight: 600; font-size:14px;">
                                            <i class="fas fa-file-excel" style="color: green; margin-right: 6px; font-size:16px;"></i>
                                            Download Excel Format
                                        </a>
                                    </div>
                                </div>
                            </div>

                            <div class="table-responsive">
                                <table id="activityTable" class="table custom-table">
                                    <thead class="table-black">
                                        <tr>
                                            <th>Activity Type</th>
                                            <th>Activity Name</th>
                                            <th>Date</th>
                                            <th>Total Count</th>
                                            <th>Remark/Achievement</th>
                                            <th>Photo</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="activityTbody">
                                        <?php if (!empty($activityList)) {
                                            $activityIndex = 0;
                                            foreach ($activityList as $row) { ?>
                                            <tr>
                                                <td><input type="text" name="activity_Type[]" 
                                                    value="<?= isset($row->activity_Type) ? $row->activity_Type : '' ?>" 
                                                    class="form-control" placeholder="Activity Type"></td>
                                                <td>
                                                    <input type="hidden" name="activity_id[]" value="<?= $row->id ?>">
                                                    <input type="text" name="activity_name[]" value="<?= $row->activity_name ?>" 
                                                        class="form-control" placeholder="Activity Name">
                                                </td>
                                                <td><input type="date" name="activity_date[]" value="<?= $row->date ?>" class="form-control"></td>
                                                <td><input type="number" name="student_count[]" value="<?= $row->student_count ?>" 
                                                    class="form-control" placeholder="0"></td>
                                                <td><input type="text" name="remark[]" value="<?= $row->remark ?>" 
                                                    class="form-control" placeholder="Remark"></td>
                                                <td>
                                                    <div class="file-upload-cell">
                                                        <?php if (!empty($row->photo)) {
                                                            $ext = strtolower(pathinfo($row->photo, PATHINFO_EXTENSION));
                                                            $fileName = basename($row->photo);
                                                        ?>
                                                            <a href="<?= base_url($row->photo) ?>" target="_blank">
                                                                <span style="color: #007bff; font-size: 12px;">
                                                                    <?php if (in_array($ext, ['jpg', 'jpeg', 'png', 'gif'])) { ?>
                                                                        🖼️ <?= substr($fileName, 0, 15) ?>
                                                                    <?php } elseif ($ext === 'pdf') { ?>
                                                                        📄 <?= substr($fileName, 0, 15) ?>
                                                                    <?php } ?>
                                                                </span>
                                                            </a>
                                                            <span class="file-remove" 
                                                                onclick="removeExistingActivityPhoto(this, '<?= $row->photo ?>', <?= $activityIndex ?>)">✕</span>
                                                            <br>
                                                        <?php } ?>
                                                        <input type="hidden" name="old_activity_photo[]" 
                                                            value="<?= !empty($row->photo) ? $row->photo : '' ?>" 
                                                            class="old-photo-field" id="old_activity_photo_<?= $activityIndex ?>">
                                                        <input type="file" name="activity_photo[]" 
                                                            class="form-control file-input mt-1" accept="image/*,application/pdf"
                                                            id="activity_file_<?= $activityIndex ?>"
                                                            onchange="handleFileSelectExisting(this, 'activity', <?= $activityIndex ?>)">
                                                        <label class="file-label">Choose File</label>
                                                        <div class="file-name" id="activity_name_<?= $activityIndex ?>"></div>
                                                    </div>
                                                </td>
                                                <td><button type="button" class="btn btn-sm text-danger removeActivityRow">
                                                    <i class="fa-solid fa-trash"></i></button></td>
                                            </tr>
                                        <?php
                                            $activityIndex++;
                                            }
                                        } else { ?>
                                            <tr>
                                                <td><input type="text" name="activity_Type[]" placeholder="Activity Type" class="form-control"></td>
                                                <td><input type="text" name="activity_name[]" placeholder="Activity Name" class="form-control"></td>
                                                <td><input type="date" name="activity_date[]" class="form-control"></td>
                                                <td><input type="number" name="student_count[]" placeholder="0" class="form-control"></td>
                                                <td><input type="text" name="remark[]" placeholder="Remark" class="form-control"></td>
                                                <td>
                                                    <div class="file-upload-cell">
                                                        <input type="hidden" name="old_activity_photo[]" value="" class="old-photo-field">
                                                        <input type="file" name="activity_photo[]" accept="image/*,application/pdf" 
                                                            class="form-control file-input" id="activity_file_0"
                                                            onchange="handleFileSelectNew(this, 'activity', '0')">
                                                        <label class="file-label">Choose File</label>
                                                        <div class="file-name" id="activity_name_0"></div>
                                                    </div>
                                                </td>
                                                <td><button type="button" class="btn btn-sm text-danger removeActivityRow">
                                                    <i class="fa-solid fa-trash"></i></button></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                                <div class="ms-auto float-end">
                                    <button type="button" class="btn btn-success btn-sm p-2 rounded-3" id="addActivityRow">
                                        <i class="fa-solid fa-plus bg-white p-1 rounded-circle text-success shadow-lg"></i>Add Row
                                    </button>
                                </div>
                            </div>

                            <hr>

                            <!-- ========== FACULTY SECTION ========== -->
                            <div class="row">
                                <div class="col-md-2 m-2">
                                    <label for="FacultyExcelFile" class="form-label">Choose Faculty Excel File</label>
                                    <div class="card" id="facultyCardBox"
                                         style="height: 120px; width: 75%; cursor: pointer; padding: 10px;
                                                border: 2px dashed black; text-align: center; display: flex;
                                                flex-direction: column; justify-content: flex-start; align-items: center;"
                                         onclick="document.getElementById('FacultyExcelFile').click();">
                                        <img src="<?= base_url('Assets/img/excel.png'); ?>" id="facultyDefaultImg"
                                             style="max-height: 50px; object-fit: contain; margin-bottom: 5px;">
                                        <span id="facultyFileText" style="font-size: 11px; color: black; font-weight:600;">
                                            (<span class="text-danger">*</span>File extension allowed: .xls .xlsx)
                                        </span>
                                        <input type="file" accept=".xls,.xlsx" style="display: none;"
                                               class="form-control form-control-sm"
                                               id="FacultyExcelFile" name="FacultyExcelFile">
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="mb-2 text-end">
                                        <a href="<?= base_url("uploads/formatexcel/Faculty_List_Format.xlsx"); ?>" download
                                           style="color: #0b0a0aff; text-decoration: underline; font-weight: 600; font-size:14px;">
                                            <i class="fas fa-file-excel" style="color: green; margin-right: 6px; font-size:16px;"></i>
                                            Download Excel Format
                                        </a>
                                    </div>
                                </div>
                            </div>

                            <div class="table-responsive">
                                <table id="facultyTable" class="table custom-table">
                                    <thead class="table-black">
                                        <tr>
                                            <th>Faculty Name</th>
                                            <th>Mobile</th>
                                            <th>Email ID</th>
                                            <th>Branch</th>
                                            <th>Membership No</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="facultyTbody">
                                        <?php if (!empty($facultyList)) {
                                            foreach ($facultyList as $row) { ?>
                                            <tr>
                                                <td>
                                                    <input type="hidden" name="faculty_id[]" value="<?= $row->id ?>">
                                                    <input type="text" name="Faculty_Name[]" value="<?= $row->Faculty_Name ?>" 
                                                        class="form-control" placeholder="Faculty Name">
                                                </td>
                                                <td><input type="text" name="Mobile[]" value="<?= $row->Mobile ?>" 
                                                    class="form-control" placeholder="Mobile Number"></td>
                                                <td><input type="email" name="Email_id[]" value="<?= $row->Email_id ?>" 
                                                    class="form-control" placeholder="Email"></td>
                                                <td><input type="text" name="Branch[]" value="<?= $row->Branch ?>" 
                                                    class="form-control" placeholder="Branch"></td>
                                                <td><input type="text" name="Membership_No[]" value="<?= $row->Membership_No ?>" 
                                                    class="form-control" placeholder="Membership No"></td>
                                                <td><button type="button" class="btn btn-sm text-danger removeFacultyRow">
                                                    <i class="fa-solid fa-trash"></i></button></td>
                                            </tr>
                                        <?php }
                                        } else { ?>
                                            <tr>
                                                <td><input type="text" name="Faculty_Name[]" placeholder="Faculty Name" class="form-control"></td>
                                                <td><input type="text" name="Mobile[]" placeholder="Mobile Number" class="form-control"></td>
                                                <td><input type="email" name="Email_id[]" placeholder="Email" class="form-control"></td>
                                                <td><input type="text" name="Branch[]" placeholder="Branch" class="form-control"></td>
                                                <td><input type="text" name="Membership_No[]" placeholder="Membership No" class="form-control"></td>
                                                <td><button type="button" class="btn btn-sm text-danger removeFacultyRow">
                                                    <i class="fa-solid fa-trash"></i></button></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                                <div class="ms-auto float-end">
                                    <button type="button" class="btn btn-success btn-sm p-2 rounded-3" id="addFacultyRow">
                                        <i class="fa-solid fa-plus bg-white p-1 rounded-circle text-success shadow-lg"></i>Add Row
                                    </button>
                                </div>
                            </div>

                            <div class="card-body">
                                <div class="">
                                    <button type="button" class="btn mb-md-0 mb-2 btn-quarternary" id="submit" name="submit">
                                        <i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save
                                    </button>
                                    <a class="btn mb-md-0 mb-2 btn-quarternary1" href="<?=base_url()?>admin/Chapter/index" type="button">
                                        <i class="fa-solid fa-list"></i>&nbsp;&nbsp;List
                                    </a>
                                    <button type="button" class="btn mb-md-0 mb-2 btn-quarternaryhome"
                                        onclick="window.location.href='<?= base_url('admin/Chapter/dashboard') ?>'">
                                        <i class="fa-solid fa-home fa-lg"></i>
                                        <span class="fw-semibold">Home</span>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- XLSX Library -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<script src="<?php echo base_url();?>Assets/js/jquery.min.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<script src="<?php echo base_url();?>Assets/js/CreateJs/admin/Chapter.js"></script>

<script>
// ==================== LOADER FUNCTIONS ====================
function showLoader() {
    document.getElementById('loaderOverlay').classList.add('active');
}

function hideLoader() {
    document.getElementById('loaderOverlay').classList.remove('active');
}

// ==================== STUDENT SECTION ====================
document.getElementById('addStudentRow')?.addEventListener('click', function() {
    let tbody = document.getElementById("studentParentTbody");
    let tr = document.createElement("tr");
    tr.innerHTML = `
        <td><input type="text" name="prn[]" maxlength="16" 
            oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 16);" class="form-control"></td>
        <td><input type="text" name="student_name[]" class="form-control"></td>
        <td><input type="number" name="mobile_no[]" maxlength="10" 
            oninput="this.value=this.value.replace(/[^0-9]/g,'').slice(0,10);" class="form-control"></td>
        <td><input type="text" name="branch[]" class="form-control"></td>
        <td><input type="text" name="Occupation[]" class="form-control"></td>
        <td><button type="button" class="btn btn-sm text-danger removeStudentRow ms-3">
            <i class="fa-solid fa-trash"></i></button></td>
    `;
    tbody.appendChild(tr);
});

document.getElementById('StudParListFile')?.addEventListener('change', function(e) {
    const file = e.target.files[0];
    if (!file) return;

    showLoader();
    const reader = new FileReader();
    reader.onload = function(event) {
        try {
            const data = new Uint8Array(event.target.result);
            const workbook = XLSX.read(data, { type: 'array' });
            const worksheet = workbook.Sheets[workbook.SheetNames[0]];
            const rows = XLSX.utils.sheet_to_json(worksheet, { header: 1 });

            if (rows.length > 1) {
                const tbody = document.getElementById("studentParentTbody");
                tbody.innerHTML = "";

                rows.slice(1).forEach(row => {
                    const tr = document.createElement("tr");
                    tr.innerHTML = `
                        <td><input type="text" name="prn[]" maxlength="16" 
                            oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 16);" 
                            value="${row[0] || ''}" class="form-control"></td>
                        <td><input type="text" name="student_name[]" value="${row[1] || ''}" class="form-control"></td>
                        <td><input type="number" name="mobile_no[]" maxlength="10" 
                            oninput="this.value=this.value.replace(/[^0-9]/g,'').slice(0,10);" 
                            value="${row[2] || ''}" class="form-control"></td>
                        <td><input type="text" name="branch[]" value="${row[3] || ''}" class="form-control"></td>
                        <td><input type="text" name="Occupation[]" value="${row[4] || ''}" class="form-control"></td>
                        <td><button type="button" class="btn btn-sm text-danger removeStudentRow ms-3">
                            <i class="fa-solid fa-trash"></i></button></td>
                    `;
                    tbody.appendChild(tr);
                });
            }
            setTimeout(hideLoader, 300);
        } catch (error) {
            hideLoader();
            alert("Error processing Excel file: " + error.message);
        }
    };
    reader.readAsArrayBuffer(file);
});

document.addEventListener("click", function(e) {
    if (e.target.closest(".removeStudentRow")) {
        e.target.closest("tr").remove();
    }
});

// ==================== ACTIVITY SECTION ====================
let activityRowCounter = <?= !empty($activityList) ? count($activityList) : 1 ?>;

document.getElementById('addActivityRow')?.addEventListener('click', function() {
    let tbody = document.getElementById("activityTbody");
    let currentRowCount = tbody.querySelectorAll('tr').length;
    
    let tr = document.createElement("tr");
    tr.innerHTML = `
        <td><input type="text" name="activity_Type[]" class="form-control"></td>
        <td><input type="text" name="activity_name[]" class="form-control"></td>
        <td><input type="date" name="activity_date[]" class="form-control"></td>
        <td><input type="number" name="student_count[]" class="form-control"></td>
        <td><input type="text" name="remark[]" class="form-control"></td>
        <td>
            <div class="file-upload-cell">
                <input type="hidden" name="old_activity_photo[]" value="" class="old-photo-field">
                <input type="file" name="activity_photo[]" class="form-control file-input" accept="image/*,application/pdf"
                       id="activity_file_${currentRowCount}"
                       onchange="handleFileSelectNew(this, 'activity', '${currentRowCount}')">
                <label class="file-label">Choose File</label>
                <div class="file-name" id="activity_name_${currentRowCount}"></div>
            </div>
        </td>
        <td><button type="button" class="btn btn-sm text-danger removeActivityRow">
            <i class="fa-solid fa-trash"></i></button></td>
    `;
    tbody.appendChild(tr);
});

function formatExcelDate(dateCell) {
    let formattedDate = "";
    if (typeof dateCell === "number") {
        const jsDate = XLSX.SSF.parse_date_code(dateCell);
        if (jsDate) {
            formattedDate = `${jsDate.y}-${String(jsDate.m).padStart(2, '0')}-${String(jsDate.d).padStart(2, '0')}`;
        }
    } else if (typeof dateCell === "string" && dateCell.includes("-")) {
        const parts = dateCell.split("-");
        if (parts.length === 3) {
            formattedDate = `${parts[2]}-${parts[1].padStart(2, '0')}-${parts[0].padStart(2, '0')}`;
        }
    }
    return formattedDate;
}

document.getElementById('ActivityExcelFile')?.addEventListener('change', function(e) {
    const file = e.target.files[0];
    if (!file) return;

    showLoader();
    const reader = new FileReader();
    reader.onload = function(event) {
        try {
            const data = new Uint8Array(event.target.result);
            const workbook = XLSX.read(data, { type: 'array' });
            const worksheet = workbook.Sheets[workbook.SheetNames[0]];
            const rows = XLSX.utils.sheet_to_json(worksheet, { header: 1 });

            if (rows.length > 1) {
                const tbody = document.getElementById("activityTbody");
                tbody.innerHTML = "";

                rows.slice(1).forEach(row => {
                    const formattedDate = formatExcelDate(row[2]);
                    const tr = document.createElement("tr");
                    tr.innerHTML = `
                        <td><input type="text" name="activity_Type[]" value="${row[0] || ''}" class="form-control"></td>
                        <td><input type="text" name="activity_name[]" value="${row[1] || ''}" class="form-control"></td>
                        <td><input type="date" name="activity_date[]" value="${formattedDate}" class="form-control"></td>
                        <td><input type="number" name="student_count[]" value="${row[3] || ''}" class="form-control"></td>
                        <td><input type="text" name="remark[]" value="${row[4] || ''}" class="form-control"></td>
                        <td>
                            <div class="file-upload-cell">
                                <input type="hidden" name="old_activity_photo[]" value="">
                                <input type="file" name="activity_photo[]" class="form-control file-input" accept="image/*,application/pdf">
                                <label class="file-label">Choose File</label>
                                <div class="file-name"></div>
                            </div>
                        </td>
                        <td><button type="button" class="btn btn-sm text-danger removeActivityRow">
                            <i class="fa-solid fa-trash"></i></button></td>
                    `;
                    tbody.appendChild(tr);
                });
            }
            setTimeout(hideLoader, 300);
        } catch (error) {
            hideLoader();
            alert("Error processing Excel file: " + error.message);
        }
    };
    reader.readAsArrayBuffer(file);
});

document.addEventListener("click", function(e) {
    if (e.target.closest(".removeActivityRow")) {
        e.target.closest("tr").remove();
    }
});

// ==================== FACULTY SECTION ====================
document.getElementById('addFacultyRow')?.addEventListener('click', function() {
    let tbody = document.getElementById("facultyTbody");
    let tr = document.createElement("tr");
    tr.innerHTML = `
        <td><input type="text" name="Faculty_Name[]" placeholder="Faculty Name" class="form-control"></td>
        <td><input type="text" name="Mobile[]" placeholder="Mobile Number" class="form-control"></td>
        <td><input type="email" name="Email_id[]" placeholder="Email" class="form-control"></td>
        <td><input type="text" name="Branch[]" placeholder="Branch" class="form-control"></td>
        <td><input type="text" name="Membership_No[]" placeholder="Membership No" class="form-control"></td>
        <td><button type="button" class="btn btn-sm text-danger removeFacultyRow">
            <i class="fa-solid fa-trash"></i></button></td>
    `;
    tbody.appendChild(tr);
});

document.getElementById('FacultyExcelFile')?.addEventListener('change', function(e) {
    const file = e.target.files[0];
    if (!file) return;

    showLoader();
    const reader = new FileReader();
    reader.onload = function(event) {
        try {
            const data = new Uint8Array(event.target.result);
            const workbook = XLSX.read(data, { type: 'array' });
            const worksheet = workbook.Sheets[workbook.SheetNames[0]];
            const rows = XLSX.utils.sheet_to_json(worksheet, { header: 1 });

            if (rows.length > 1) {
                const tbody = document.getElementById("facultyTbody");
                tbody.innerHTML = "";

                rows.slice(1).forEach(row => {
                    const tr = document.createElement("tr");
                    tr.innerHTML = `
                        <td><input type="text" name="Faculty_Name[]" value="${row[0] || ''}" class="form-control"></td>
                        <td><input type="text" name="Mobile[]" value="${row[1] || ''}" class="form-control"></td>
                        <td><input type="email" name="Email_id[]" value="${row[2] || ''}" class="form-control"></td>
                        <td><input type="text" name="Branch[]" value="${row[3] || ''}" class="form-control"></td>
                        <td><input type="text" name="Membership_No[]" value="${row[4] || ''}" class="form-control"></td>
                        <td><button type="button" class="btn btn-sm text-danger removeFacultyRow">
                            <i class="fa-solid fa-trash"></i></button></td>
                    `;
                    tbody.appendChild(tr);
                });
            }
            setTimeout(hideLoader, 300);
        } catch (error) {
            hideLoader();
            alert("Error processing Excel file: " + error.message);
        }
    };
    reader.readAsArrayBuffer(file);
});

document.addEventListener("click", function(e) {
    if (e.target.closest(".removeFacultyRow")) {
        e.target.closest("tr").remove();
    }
});

// ==================== FILE HANDLING ====================
window.handleFileSelectExisting = function(input, type, rowIndex) {
    let fileName = input.files[0] ? input.files[0].name : '';
    let nameDiv = document.getElementById(type + '_name_' + rowIndex);
    if (nameDiv) {
        nameDiv.innerHTML = fileName 
            ? fileName + '<span class="file-remove" onclick="removeFileExisting(\'' + type + '\',' + rowIndex + ')">✕</span>'
            : '';
    }
};

window.handleFileSelectNew = function(input, type, uniqueId) {
    let fileName = input.files[0] ? input.files[0].name : '';
    let nameDiv = document.getElementById(type + '_name_' + uniqueId);
    if (nameDiv) {
        nameDiv.innerHTML = fileName 
            ? fileName + '<span class="file-remove" onclick="removeFileNew(\'' + type + '\', \'' + uniqueId + '\')">✕</span>'
            : '';
    }
};

window.removeFileExisting = function(type, rowIndex) {
    let input = document.getElementById(type + '_file_' + rowIndex);
    let nameDiv = document.getElementById(type + '_name_' + rowIndex);
    if (input) input.value = "";
    if (nameDiv) nameDiv.innerHTML = "";
};

window.removeFileNew = function(type, uniqueId) {
    let input = document.getElementById(type + '_file_' + uniqueId);
    let nameDiv = document.getElementById(type + '_name_' + uniqueId);
    if (input) input.value = "";
    if (nameDiv) nameDiv.innerHTML = "";
};

window.removeExistingActivityPhoto = function(element, photoPath, rowIndex) {
    if (confirm('Are you sure you want to remove this photo?')) {
        element.parentElement.querySelector('a').style.display = 'none';
        element.style.display = 'none';
        let hiddenField = document.getElementById('old_activity_photo_' + rowIndex);
        if (hiddenField) {
            hiddenField.value = '';
        }
    }
};
</script>