<!DOCTYPE html>
<html lang="en">
<head>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <!-- Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= isset($feedbackfor_name) ? htmlspecialchars($feedbackfor_name) : 'College' ?> Feedback Form</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding-bottom: 65px;
        }

        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 10px;
        }

        .college-header {
            background: white;
            padding: 10px 15px;
            margin: 2px -5px 15px -5px;
            border-radius: 15px;
            text-align: center;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }

        .header-inner {
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        .college-logo {
            width: 70px;
            height: 70px;
            object-fit: contain;
        }

        .college-details h1 {
            font-size: 18px;
            color: #e93939;
            font-weight: 600;
            line-height: 1.3;
            margin-bottom: 5px;
        }

        .college-details p {
            font-size: 13px;
            color: #666;
            margin: 2px 0;
        }

        .info-card {
            background: white;
            padding: 20px 15px;
            margin: -10px -5px 4px -5px;
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }

        .form-group {
            margin-bottom: 15px;
        }

        .form-group label {
            display: block;
            font-size: 13px;
            font-weight: 600;
            color: #333;
            margin-bottom: 6px;
        }

        .form-group input,
        .form-group select {
            width: 100%;
            padding: 12px;
            border: 2px solid #e1e8ed;
            border-radius: 10px;
            font-size: 14px;
            transition: all 0.3s;
            background: #f8f9fa;
        }

        .form-group input:focus,
        .form-group select:focus {
            outline: none;
            border-color: #007bff;
            background: white;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.3);
        }

        .form-group input:disabled,
        .form-group select:disabled {
            background: #e9ecef;
            cursor: not-allowed;
        }

        .progress-container {
            background: white;
            padding: 15px;
            margin: 0 -5px 15px -5px;
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }

        .progress-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 10px;
            flex-wrap: wrap;
            gap: 10px;
        }

        .progress-text {
            font-size: 13px;
            color: #666;
        }

        .progress-text span {
            font-weight: bold;
            color: #007bff;
            font-size: 16px;
        }

        .questions-per-page {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .questions-per-page label {
            font-size: 12px;
            color: #666;
            white-space: nowrap;
        }

        .questions-per-page select {
            padding: 5px 10px;
            border: 2px solid #e1e8ed;
            border-radius: 8px;
            font-size: 12px;
            background: #f8f9fa;
            cursor: pointer;
        }

        .progress-bar {
            width: 100%;
            height: 8px;
            background: #e1e8ed;
            border-radius: 10px;
            overflow: hidden;
        }

        .progress-fill {
            height: 100%;
            background: linear-gradient(90deg, #007bff, #0056b3);
            border-radius: 10px;
            transition: width 0.4s ease;
        }

        .section {
            display: none;
        }

        .section.active {
            display: block;
            animation: fadeIn 0.4s ease;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .card {
            background: white;
            padding: 18px 15px;
            border-radius: 15px;
            margin-bottom: 12px;
            margin-left: -5px;
            margin-right: -5px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
        }

        .question {
            font-size: 14px;
            font-weight: 600;
            color: #333;
            margin-bottom: 12px;
            line-height: 1.4;
        }

        .options {
            display: flex;
            flex-direction: column;
            gap: 8px;
        }

        /* Radio & Checkbox Labels */
        .option-label {
            display: flex;
            align-items: center;
            padding: 10px 12px;
            border: 2px solid #e1e8ed;
            border-radius: 10px;
            cursor: pointer;
            transition: all 0.3s;
            background: #f8f9fa;
        }

        .option-label:hover {
            border-color: #007bff;
            background: #f0f7ff;
        }

        .option-label input[type="radio"],
        .option-label input[type="checkbox"] {
            width: 18px;
            height: 18px;
            margin-right: 10px;
            cursor: pointer;
            accent-color: #007bff;
        }

        .option-label:has(input:checked) {
            border-color: #007bff;
            background: #e7f3ff;
        }

        .option-text {
            font-size: 13px;
            color: #333;
            font-weight: 500;
        }

        /* Textarea styling */
        .form-group textarea {
            width: 100%;
            padding: 12px;
            border: 2px solid #e1e8ed;
            border-radius: 10px;
            font-size: 14px;
            transition: all 0.3s;
            background: #f8f9fa;
            resize: vertical;
            min-height: 100px;
            font-family: 'Segoe UI', Tahoma, sans-serif;
        }

        .form-group textarea:focus {
            outline: none;
            border-color: #007bff;
            background: white;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }

        /* Select2 custom styling */
        .select2-container--default .select2-selection--single {
            border: 2px solid #e1e8ed;
            border-radius: 10px;
            height: 45px;
            padding: 8px 12px;
            background: #f8f9fa;
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: 27px;
            color: #333;
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: 43px;
        }

        .select2-container--default.select2-container--focus .select2-selection--single {
            border-color: #007bff;
            background: white;
        }

        .nav-buttons {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            padding: 12px 15px;
            box-shadow: 0 -3px 15px rgba(0, 0, 0, 0.1);
            display: flex;
            gap: 10px;
            z-index: 100;
        }

        .btn {
            flex: 1;
            padding: 14px;
            font-size: 15px;
            font-weight: 600;
            border: none;
            border-radius: 12px;
            cursor: pointer;
            transition: all 0.3s;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .btn-prev {
            background: #f8f9fa;
            color: #666;
            border: 2px solid #e1e8ed;
        }

        .btn-prev:not(.disabled):hover {
            background: #e1e8ed;
        }

        .btn-next {
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
        }

        .btn-next:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }

        .btn.disabled {
            opacity: 0.4;
            cursor: not-allowed;
            pointer-events: none;
        }

        .success-message {
            display: none;
            background: white;
            padding: 40px 20px;
            border-radius: 15px;
            text-align: center;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            animation: fadeIn 0.5s ease;
            margin-top: 5px;
        }

        .success-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, #11998e, #38ef7d);
            border-radius: 50%;
            margin: 0 auto 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 40px;
            color: white;
        }

        .success-message h2 {
            font-size: 22px;
            color: #333;
            margin-bottom: 10px;
        }

        .success-message p {
            color: #666;
            font-size: 14px;
            line-height: 1.6;
        }

        @media (max-width: 480px) {
            .container {
                padding-top: 0px;
            }
            .college-details h1 {
                font-size: 16px;
            }
            .college-logo {
                width: 60px;
                height: 60px;
            }
            .progress-header {
                flex-direction: column;
                gap: 10px;
                align-items: flex-start;
            }
        }
    </style>
</head>
<body>
<div class="container">

<!-- ==================== HEADER ==================== -->
<?php if(isset($heading) && $heading): ?>
<div class="college-header">
    <div class="header-inner">
        <?php if(!empty($heading->logo)): ?>
            <img src="<?= base_url(ltrim($heading->logo, '/')) ?>" alt="College Logo" class="college-logo">
        <?php else: ?>
            <img src="<?= base_url('assets/images/sit_logo.png') ?>" alt="College Logo" class="college-logo">
        <?php endif; ?>
        
        <div class="college-details">
            <h1>
                <?= !empty($heading->subHead1) ? htmlspecialchars($heading->subHead1) : 'Institute Name' ?>
                <?php if(!empty($heading->head)): ?>
                    <br><?= htmlspecialchars($heading->head) ?>
                <?php endif; ?>
            </h1>
            
            <?php if(!empty($heading->subHead2)): ?>
                <h1><?= htmlspecialchars($heading->subHead2) ?></h1>
            <?php endif; ?>
            
            <p>
                <?php if(isset($feedbackfor_name) && !empty($feedbackfor_name)): ?>
                    <?= htmlspecialchars($feedbackfor_name) ?>
                <?php endif; ?>
                Feedback Form
            </p>
            
            <?php if(isset($financial_year) && $financial_year): ?>
                <p>Academic Year <?= htmlspecialchars($financial_year->fini_Label) ?></p>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- ==================== STUDENT INFO CARD ==================== -->
<div class="info-card" style="display:none">
    <div class="form-group">
        <label>Branch *</label>
        
        <?php if($is_branch_fixed && !empty($branch_name)): ?>
            <input type="text" id="branch" value="<?= htmlspecialchars($branch_name) ?>" disabled>
            <input type="hidden" name="branch" id="hiddenBranch" value="<?= htmlspecialchars($branch_name) ?>">
        <?php else: ?>
            <select id="branch" required>
                <option value="">Select your branch</option>
                <?php if (!empty($branches)): ?>
                    <?php foreach ($branches as $b): ?>
                        <option value="<?= htmlspecialchars($b->branch_name) ?>">
                            <?= htmlspecialchars($b->branch_name) ?>
                        </option>
                    <?php endforeach; ?>
                <?php else: ?>
                    <option value="">No branches available</option>
                <?php endif; ?>
            </select>
        <?php endif; ?>
    </div>
</div>

<!-- ==================== PROGRESS BAR with Questions Per Page ==================== -->
<?php $total_questions = count($questions); ?>
<div class="progress-container" style="display:none">
    <div class="progress-header">
        <div class="progress-text">
            Page <span id="currentPage">1</span> of <span id="totalPages">1</span>
            <span style="font-size: 11px; color: #999;">(Questions <span id="questionRange">1-<?= min(1, $total_questions) ?></span> of <?= $total_questions ?>)</span>
        </div>
        <div class="questions-per-page">
            <label>Show:</label>
            <select id="questionsPerPage" onchange="changeQuestionsPerPage()">
                <option value="1" <?= (isset($questionperpage) && $questionperpage == 1) ? 'selected' : '' ?>>1 Question</option>
                <option value="2" <?= (isset($questionperpage) && $questionperpage == 2) ? 'selected' : '' ?>>2 Questions</option>
                <option value="3" <?= (isset($questionperpage) && $questionperpage == 3) ? 'selected' : '' ?>>3 Questions</option>
                <option value="5" <?= (isset($questionperpage) && $questionperpage == 5) ? 'selected' : '' ?>>5 Questions</option>
                <option value="7" <?= (isset($questionperpage) && $questionperpage == 7) ? 'selected' : '' ?>>7 Questions</option>
                <option value="10" <?= (isset($questionperpage) && $questionperpage == 10) ? 'selected' : '' ?>>10 Questions</option>
                <option value="<?= $total_questions ?>" <?= (isset($questionperpage) && $questionperpage == $total_questions) ? 'selected' : '' ?>>All Questions</option>
            </select>
        </div>
    </div>
    <div class="progress-bar">
        <div class="progress-fill" id="progressFill" style="width: 0%"></div>
    </div>
</div>

<!-- ==================== SURVEY FORM ==================== -->
<form id="surveyForm" method="post" action="<?= base_url('admin/CollegeFeedbackSurvey/submit_survey') ?>">

    <input type="hidden" id="hiddenBranchFromForm" name="branch">
    <input type="hidden" name="fkURL_id" value="<?= isset($fkURL_id) && !empty($fkURL_id) ? $fkURL_id : '' ?>">
    <input type="hidden" name="financial_year_id" value="<?= isset($financial_year) ? $financial_year->finiYear_id : '' ?>">
    <input type="hidden" name="institute_id" value="<?= isset($institute_id) ? $institute_id : '' ?>">
    <input type="hidden" name="feedbackfor_id" value="<?= isset($feedbackfor_id) ? $feedbackfor_id : '' ?>">
    <input type="hidden" name="branch_id_from_url" value="<?= isset($branch_id) ? $branch_id : 0 ?>">

    <!-- Dynamic Question Pages -->
    <div id="questionPages">
        <?php if (!empty($questions)): ?>
            <?php $question_index = 0; ?>
            <?php foreach ($questions as $question): ?>
                
                <div class="question-item" data-question-index="<?= $question_index ?>">
                    <div class="card">
                        <div class="question">
                            <?= ($question_index + 1) ?>. <?= htmlspecialchars($question->question_name) ?>
                        </div>
                        
                        <div class="options">
                            <?php 
                            // Determine answer type from isanswerortext
                            $answer_type = isset($question->isanswerortext) ? $question->isanswerortext : 1;
                            
                            // Switch based on answer type
                            if ($answer_type == 1): 
                                // ========== TYPE 1: RADIO BUTTONS ==========
                                if (!empty($answer_options)): 
                                    $first_option = true;
                                    foreach ($answer_options as $option): 
                            ?>
                                    <label class="option-label">
                                        <input type="radio" 
                                               name="q<?= $question->questionid ?>" 
                                               value="<?= $option->answertypeid ?>" 
                                               <?= $first_option ? 'checked' : '' ?>
                                               required>
                                        <span class="option-text">
                                            <?= htmlspecialchars($option->answertypename) ?>
                                        </span>
                                    </label>
                            <?php 
                                    $first_option = false;
                                    endforeach;
                                else:
                            ?>
                                    <p style="color: #999;">No options available</p>
                            <?php 
                                endif;
                                
                            elseif ($answer_type == 2): 
                                // ========== TYPE 2: CHECKBOXES (Single selection like radio) ==========
                                if (!empty($answer_options)): 
                                    $first_option = true;
                                    foreach ($answer_options as $option): 
                            ?>
                                    <label class="option-label">
                                        <input type="checkbox" 
                                               name="q<?= $question->questionid ?>" 
                                               value="<?= $option->answertypeid ?>"
                                               class="single-checkbox"
                                               data-question="q<?= $question->questionid ?>"
                                               <?= $first_option ? 'checked' : '' ?>
                                               required>
                                        <span class="option-text">
                                            <?= htmlspecialchars($option->answertypename) ?>
                                        </span>
                                    </label>
                            <?php 
                                    $first_option = false;
                                    endforeach;
                                else:
                            ?>
                                    <p style="color: #999;">No options available</p>
                            <?php 
                                endif;
                                
                            elseif ($answer_type == 3): 
                                // ========== TYPE 3: SELECT2 DROPDOWN ==========
                                if (!empty($answer_options)): 
                            ?>
                                    <select name="q<?= $question->questionid ?>" 
                                            class="select2-dropdown" 
                                            required
                                            style="width: 100%">
                                        <!--<option value="">Select an option</option>-->
                            <?php 
                                    foreach ($answer_options as $option): 
                            ?>
                                        <option value="<?= $option->answertypeid ?>">
                                            <?= htmlspecialchars($option->answertypename) ?>
                                        </option>
                            <?php 
                                    endforeach;
                            ?>
                                    </select>
                            <?php 
                                else:
                            ?>
                                    <p style="color: #999;">No options available</p>
                            <?php 
                                endif;
                                
                            elseif ($answer_type == 4): 
                                // ========== TYPE 4: TEXTAREA ==========
                            ?>
                                <div class="form-group">
                                    <textarea name="q<?= $question->questionid ?>" 
                                              class="form-control" 
                                              rows="4" 
                                              placeholder="Please provide your answer here..." 
                                              required></textarea>
                                </div>
                            <?php 
                            else:
                                // ========== FALLBACK: Default to radio if type unknown ==========
                                if (!empty($answer_options)): 
                                    $first_option = true;
                                    foreach ($answer_options as $option): 
                            ?>
                                    <label class="option-label">
                                        <input type="radio" 
                                               name="q<?= $question->questionid ?>" 
                                               value="<?= $option->answertypeid ?>" 
                                               <?= $first_option ? 'checked' : '' ?>
                                               required>
                                        <span class="option-text">
                                            <?= htmlspecialchars($option->answertypename) ?>
                                        </span>
                                    </label>
                            <?php 
                                    $first_option = false;
                                    endforeach;
                                else:
                            ?>
                                    <p style="color: #999;">No options available</p>
                            <?php 
                                endif;
                            endif; // End answer_type switch
                            ?>
                        </div>
                    </div>
                </div>
                
                <?php $question_index++; ?>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="card">
                <p>No questions available for this feedback type</p>
            </div>
        <?php endif; ?>
    </div>
</form>

<!-- Success Message -->
<div class="success-message" id="successMsg">
    <div class="success-icon">✓</div>
    <h2>Thank You!</h2>
    <p>Your feedback has been submitted successfully.</p>
</div>

</div>

<!-- Navigation Buttons -->
<div class="nav-buttons">
    <button class="btn btn-prev disabled" id="prevBtn" onclick="prevPage()">Previous</button>
    <button class="btn btn-next" id="nextBtn" onclick="nextPage()">Next</button>
</div>

<!-- jQuery (required for Select2) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- Select2 JS -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<!-- SweetAlert -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
const totalQuestions = <?= $total_questions ?>;
let questionsPerPage = <?= isset($questionperpage) && $questionperpage > 0 ? $questionperpage : 10 ?>; 
let currentPage = 0;
let totalPages = Math.ceil(totalQuestions / questionsPerPage);

// Initialize Select2
$(document).ready(function() {
    $('.select2-dropdown').select2({
        minimumResultsForSearch: 5,
        width: '100%'
    });
    
    // Handle single checkbox selection (Type 2)
    $(document).on('change', 'input.single-checkbox', function() {
        if (this.checked) {
            const questionName = $(this).data('question');
            // Uncheck all other checkboxes for this question
            $('input.single-checkbox[data-question="' + questionName + '"]').not(this).prop('checked', false);
        } else {
            // Don't allow unchecking - at least one must be selected
            this.checked = true;
        }
    });
    
    // Initialize the page display
    updatePageDisplay();
});

function changeQuestionsPerPage() {
    const newQuestionsPerPage = parseInt(document.getElementById('questionsPerPage').value);
    
    // Save current progress
    const currentQuestionIndex = currentPage * questionsPerPage;
    
    // Update questionsPerPage
    questionsPerPage = newQuestionsPerPage;
    totalPages = Math.ceil(totalQuestions / questionsPerPage);
    
    // Calculate new page based on current question
    currentPage = Math.floor(currentQuestionIndex / questionsPerPage);
    
    // Make sure we don't exceed bounds
    if (currentPage >= totalPages) {
        currentPage = totalPages - 1;
    }
    
    updatePageDisplay();
}

function updatePageDisplay() {
    const questionItems = document.querySelectorAll('.question-item');
    
    // Hide all questions first
    questionItems.forEach(item => {
        item.style.display = 'none';
    });
    
    // Calculate which questions to show
    const startIndex = currentPage * questionsPerPage;
    const endIndex = Math.min(startIndex + questionsPerPage, totalQuestions);
    
    // Show questions for current page
    for (let i = startIndex; i < endIndex; i++) {
        if (questionItems[i]) {
            questionItems[i].style.display = 'block';
        }
    }
    
    // Update UI
    document.getElementById('currentPage').textContent = currentPage + 1;
    document.getElementById('totalPages').textContent = totalPages;
    document.getElementById('questionRange').textContent = `${startIndex + 1}-${endIndex}`;
    
    const progress = ((currentPage + 1) / totalPages) * 100;
    document.getElementById('progressFill').style.width = progress + '%';
    
    // Update button states
    document.getElementById('prevBtn').classList.toggle('disabled', currentPage === 0);
    document.getElementById('nextBtn').textContent = currentPage === totalPages - 1 ? 'Submit' : 'Next';
    
    // Scroll to top
    window.scrollTo({ top: 0, behavior: 'smooth' });
    
    // Reinitialize Select2 for newly visible dropdowns
    $('.select2-dropdown').select2({
        minimumResultsForSearch: 5,
        width: '100%'
    });
}

function validateCurrentPage() {
    const startIndex = currentPage * questionsPerPage;
    const endIndex = Math.min(startIndex + questionsPerPage, totalQuestions);
    
    const questionItems = document.querySelectorAll('.question-item');
    
    for (let i = startIndex; i < endIndex; i++) {
        const questionItem = questionItems[i];
        if (!questionItem) continue;
        
        // Check for required radio buttons
        const radioInputs = questionItem.querySelectorAll('input[type="radio"]');
        if (radioInputs.length > 0) {
            const radioName = radioInputs[0].name;
            const checked = questionItem.querySelector(`input[name="${radioName}"]:checked`);
            if (!checked) {
                Swal.fire({
                    position: 'center',
                    icon: 'warning',
                    title: '<strong>Incomplete</strong>',
                    html: 'Please answer all questions on this page.',
                    showConfirmButton: true,
                    confirmButtonColor: '#667eea'
                });
                return false;
            }
        }
        
        // Check for checkboxes (single selection - at least one should be checked)
        const checkboxInputs = questionItem.querySelectorAll('input[type="checkbox"].single-checkbox');
        if (checkboxInputs.length > 0) {
            const anyChecked = Array.from(checkboxInputs).some(cb => cb.checked);
            if (!anyChecked) {
                Swal.fire({
                    position: 'center',
                    icon: 'warning',
                    title: '<strong>Incomplete</strong>',
                    html: 'Please select an option for all checkbox questions.',
                    showConfirmButton: true,
                    confirmButtonColor: '#667eea'
                });
                return false;
            }
        }
        
        // Check for select2 dropdowns
        const selectDropdowns = questionItem.querySelectorAll('.select2-dropdown');
        for (let select of selectDropdowns) {
            if (!select.value || select.value === '') {
                Swal.fire({
                    position: 'center',
                    icon: 'warning',
                    title: '<strong>Incomplete</strong>',
                    html: 'Please select an option from all dropdowns.',
                    showConfirmButton: true,
                    confirmButtonColor: '#667eea'
                });
                return false;
            }
        }
        
        // Check for textareas
        const textareas = questionItem.querySelectorAll('textarea');
        for (let textarea of textareas) {
            if (!textarea.value.trim()) {
                Swal.fire({
                    position: 'center',
                    icon: 'warning',
                    title: '<strong>Incomplete</strong>',
                    html: 'Please provide answers for all text questions.',
                    showConfirmButton: true,
                    confirmButtonColor: '#667eea'
                });
                return false;
            }
        }
    }
    
    return true;
}

function validateStudentInfo() {
    let branch = '';
    const branchDropdown = document.getElementById('branch');
    
    if (branchDropdown.hasAttribute('disabled')) {
        branch = document.getElementById('hiddenBranch').value.trim();
    } else {
        branch = branchDropdown.value.trim();
    }
    
    if (!branch || branch === "") {
        branch = "0";
    }
    
    document.getElementById('hiddenBranchFromForm').value = branch;
    return true;
}

function nextPage() {
    if (currentPage === 0 && !validateStudentInfo()) {
        return;
    }
    
    if (!validateCurrentPage()) {
        return;
    }
    
    if (currentPage < totalPages - 1) {
        currentPage++;
        updatePageDisplay();
    } else {
        submitSurvey();
    }
}

function prevPage() {
    if (currentPage > 0) {
        currentPage--;
        updatePageDisplay();
    }
}

function submitSurvey() {
    if (!validateStudentInfo()) {
        currentPage = 0;
        updatePageDisplay();
        return;
    }
    
    // Final validation of all pages
    for (let page = 0; page < totalPages; page++) {
        currentPage = page;
        if (!validateCurrentPage()) {
            updatePageDisplay();
            return;
        }
    }
    
    const formData = new FormData(document.getElementById('surveyForm'));
    
    Swal.fire({
        title: '<strong>Submitting...</strong>',
        html: 'Please wait while we submit your feedback.',
        allowOutsideClick: false,
        allowEscapeKey: false,
        showConfirmButton: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });
    
    document.getElementById('nextBtn').textContent = 'Submitting...';
    document.getElementById('nextBtn').disabled = true;
    
    fetch('<?= base_url('admin/CollegeFeedbackSurvey/submit_survey') ?>', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.status === 'success') {
            Swal.fire({
                position: 'center',
                icon: 'success',
                title: '<strong>Thank You!</strong>',
                html: 'Your feedback has been submitted successfully.',
                showConfirmButton: false,
                timer: 3000
            }).then(() => {
                document.querySelector('.container').innerHTML = 
                    '<div class="success-message" style="display:block">' +
                    '<div class="success-icon">✓</div>' +
                    '<h2>Thank You!</h2>' +
                    '<p>Your feedback has been submitted successfully.</p>' +
                    '</div>';
                document.querySelector('.nav-buttons').style.display = 'none';
            });
        } else {
            Swal.fire({
                position: 'center',
                icon: 'error',
                title: '<strong>Submission Failed</strong>',
                html: data.message || 'Error submitting survey. Please try again.',
                showConfirmButton: true,
                confirmButtonText: 'OK',
                confirmButtonColor: '#667eea'
            });
            document.getElementById('nextBtn').textContent = 'Submit';
            document.getElementById('nextBtn').disabled = false;
        }
    })
    .catch(error => {
        console.error('Error:', error);
        Swal.fire({
            position: 'center',
            icon: 'error',
            title: '<strong>Network Error</strong>',
            html: 'An error occurred while submitting the survey. Please check your connection and try again.',
            showConfirmButton: true,
            confirmButtonText: 'OK',
            confirmButtonColor: '#667eea'
        });
        document.getElementById('nextBtn').textContent = 'Submit';
        document.getElementById('nextBtn').disabled = false;
    });
}
</script>

</body>
</html>