<style>
    .file-upload-cell {
        position: relative;
        width: 120px;
    }
    .file-input {
        position: absolute;
        opacity: 0;
        width: 100%;
        height: 100%;
        cursor: pointer;
    }
    .file-label {
        display: inline-block;
        background: #007bff;
        color: white;
        padding: 5px 10px;
        border-radius: 4px;
        cursor: pointer;
        font-size: 12px;
        text-align: center;
        width: 100px;
    }
    .file-label:hover {
        background: #0056b3;
    }
    .file-name {
        font-size: 10px;
        color: #666;
        margin-top: 2px;
        word-break: break-word;
    }
    .file-remove {
        color: red;
        cursor: pointer;
        font-size: 10px;
        margin-left: 5px;
    }
    .wide-th {
        width: 200px !important;  
    }
    .total-row {
        background-color: #f8f9fa;
        font-weight: bold;
        border-top: 2px solid #dee2e6;
    }
    .total-row td {
        padding: 12px 8px !important;
        font-size: 14px;
    }
    .total-amount {
        color: #28a745;
        font-size: 16px;
        font-weight: 600;
    }
    .select2-container .select2-selection--single {
        height: 38px !important;
        border: 1px solid #ced4da !important;
        border-radius: 4px !important;
    }
    .select2-container--default .select2-selection--single .select2-selection__rendered {
        line-height: 36px !important;
        padding-left: 12px !important;
        color: #495057 !important;
        padding: 2px;
    }
    .select2-container--default .select2-selection--single .select2-selection__arrow {
        height: 36px !important;
        right: 8px !important;
    }
    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        border-color: #495057 transparent transparent transparent !important;
    }
    .select2-dropdown {
        border: 1px solid #f89450 !important;
        border-radius: 4px !important;
        background-color: #edfff2 !important;
    }
    .select2-container--default .select2-results__option--highlighted[aria-selected] {
        background-color: #007bff !important;
        color: white !important;
    }
    .select2-search--dropdown .select2-search__field {
        border: 1px solid #ced4da !important;
        border-radius: 4px !important;
        padding: 6px 12px !important;
    }
    .select2-container--default.select2-container--focus .select2-selection--single {
        border-color: #80bdff !important;
        outline: 0 !important;
        box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25) !important;
    }
    .select2-container {
        width: 100% !important;
    }
</style>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1"> Course Form </div>
                    </div>
                    <div class="card-body">
                        <form role="form" id="Form" action="" method="post" enctype="multipart/form-data">
                            <div class="row gutters">
                                <!-- CORRECTED: Removed space from Course_id -->
                                <input type="hidden" id="Course_id" name="Course_id" class="hiddenId" 
                                       value="<?php echo isset($record->Course_id) ? $record->Course_id : ''; ?>">

                                <!-- Hidden submenu ID -->
                                <input class="form-control" id="fk_submenuId" name="fk_submenuId" type="hidden"
                                       value="<?= isset($subId) ? $subId : '' ?>" />

                                <?php if(empty($record)): ?>  
                                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <label for="excel_file" class="form-label">Import Excel</label>
                                    <div class="card" id="studentCard"
                                         style="height: 120px; width: 60%; cursor: pointer; padding: 10px;
                                                border: 2px dashed black; text-align: center; display: flex;
                                                flex-direction: column; justify-content: flex-start; align-items: center;
                                                position: relative; overflow: hidden;"
                                         onclick="document.getElementById('excel_file').click();">
                                        <img src="<?= base_url('Assets/img/excel.png'); ?>" id="studentImg"
                                             style="max-height: 50px; object-fit: contain; margin-bottom: 5px;">
                                        <span id="studentFileText" style="font-size: 11px; color: black; font-weight:600;">
                                            (<span class="text-danger">*</span>File extension allowed: .xls .xlsx)
                                        </span>
                                        <input type="file" accept=".xls,.xlsx" style="display: none;"
                                               class="form-control form-control-sm"
                                               id="excel_file" name="excel_file">
                                    </div>
                                    <button class="btn btn-success btn-sm m-1" type="button" id="btnShow" style="padding: 5px 10px;font-size: 13px;"><i class="fas fa-search"></i> Show Excel Data</button>
                                </div>

                                <!-- Branch Selection -->
                                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <div class="field-wrapper">
                                        <select name="fkbranch_id" id="fkbranch_id" class="select-single js-states form-control">
                                            <option value="">Select branch</option>
                                            <?php foreach($branchdata as $branch): ?>
                                                <option value="<?= $branch->branch_id ?>">
                                                    <?= $branch->branch_name ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Department <span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <!-- Academic Year Selection -->
                                <div class="col-md-3">
                                    <div class="field-wrapper">
                                        <select name="finicial_Year" id="finicial_Year" class="select-single js-states form-control">
                                            <?php
                                            $selectedYear = '';
                                            if (!empty($activeYear)) {
                                                $selectedYear = $activeYear->finiYear_id;
                                            }
                                            ?>
                                            <option value="">Select year</option>
                                            <?php foreach($yeardata as $year): ?>
                                                <option value="<?= $year->finiYear_id ?>"
                                                    <?= ($year->finiYear_id == $selectedYear) ? 'selected' : '' ?>>
                                                    <?= $year->fini_Label ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Academic Year <span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-12 text-end mt-3">
                                       <a href="<?= base_url('uploads/formatexcel/Course.xlsx'); ?>"
                                       download
                                       style="color: #0b0a0aff; text-decoration: underline; font-weight: 600; font-size:14px;">
                                       <i class="fas fa-file-excel" style="color: green; margin-right: 6px; font-size:16px;"></i>
                                       Download Excel Format
                                       </a>
                                    </div>
                                </div>
                                <?php else: ?>
                                <!-- Update mode: Show branch and year selections -->
                                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <div class="field-wrapper">
                                        <select name="fkbranch_id" id="fkbranch_id" class="select-single js-states form-control">
                                            <option value="">Select branch</option>
                                            <?php foreach($branchdata as $branch): ?>
                                                <option value="<?= $branch->branch_id ?>" 
                                                    <?= ($branch->branch_id == $record->fkbranch_id) ? 'selected' : '' ?>>
                                                    <?= $branch->branch_name ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Department <span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <div class="col-md-3">
                                    <div class="field-wrapper">
                                        <select name="finicial_Year" id="finicial_Year" class="select-single js-states form-control">
                                            <option value="">Select year</option>
                                            <?php foreach($yeardata as $year): ?>
                                                <option value="<?= $year->finiYear_id ?>"
                                                    <?= ($year->finiYear_id == $record->finicial_Year) ? 'selected' : '' ?>>
                                                    <?= $year->fini_Label ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Academic Year <span class="text-danger">*</span></div>
                                    </div>
                                </div>
                                <?php endif; ?>

                                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-3 col-12">
                                    <div class="table-responsive mt-3" id="printableTable">
                                       <div class="float-end mb-2">
                                         <?php if (empty($record)): ?>
                                            <button class="btn btn-danger btn-sm m-1" type="button" id="btnClearAll" style="padding: 5px 10px;font-size: 13px;">
                                                <i class="fas fa-times"></i> Clear All
                                            </button>
                                         <?php endif; ?>
                                       </div>

                                        <table id="leavetable" class="table custom-table">
                                            <thead style="background-color: #1273eb;">
                                                <tr>
                                                    <th class=".w-auto">Sr.No.</th>
                                                    <th style="min-width:300px;">Course Code</th>
                                                    <th style="min-width:300px;">Course Title</th>
                                                    <th style="min-width:150px;">Order Number</th>
                                                    <th style="min-width:170px;">Status</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>

                                            <tbody id="tableBody">
                                                <?php if(isset($record)): ?>
                                                <tr>
                                                    <td>1</td>
                                                    <td>
                                                        <input type="text" name="Course_code[]" class="form-control" 
                                                               value="<?= $record->Course_code ?>">
                                                    </td>
                                                    <td>
                                                        <input type="text" name="Course_title[]" class="form-control" 
                                                               value="<?= $record->Course_title ?>">
                                                    </td>
                                                    <td>
                                                        <input type="number" name="Order_no[]" class="form-control" 
                                                               value="<?= $record->Order_no ?>">
                                                    </td>
                                                    <td>
                                                        <input type="checkbox" name="status[]" value="1" 
                                                               <?= ($record->status == 1) ? 'checked' : '' ?>>
                                                    </td>
                                                    <td>
                                                        <button type="button" class="btn text-danger btn-sm removeRow">
                                                            <i class="fa-solid fa-trash"></i>
                                                        </button>
                                                    </td>
                                                </tr>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                       <div class="float-end">
                                         <?php if(empty($record)): ?>
                                         <button type="button" class="btn btn-success btn-sm p-2 rounded-3" id="addRowBtn" style="font-size:13px; font-weight:600;">
                                            <i class="fa-solid fa-plus bg-white p-1 rounded-circle text-success shadow-lg me-2" style="box-shadow: 4px 6px 12px rgba(0, 0, 0, 0.5) !important;"></i>Add Row
                                         </button>
                                         <?php endif; ?>
                                       </div>
                                    </div>
                                </div>

                                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 mt-3">
                                    <button type="button" class="btn mb-md-0 mb-2 btn-quarternary" id="submit" name="submit">
                                        <i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save
                                    </button>
                                    <a class="btn mb-md-0 mb-2 btn-quarternary1" href="<?=base_url()?>admin/Course/index">
                                        <i class="fa-solid fa-list"></i>&nbsp;&nbsp;List
                                    </a>
                                    <button class="btn mb-md-0 mb-2 btn-quarternaryhome" type="button" onclick="window.location.href='<?= base_url() ?>admin/PO/Dashboard'">
                                        <i class="fa-solid fa-home"></i>&nbsp;&nbsp;Home
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>

<script>
$(document).ready(function() {
    // Select2 focus functionality
    $(document).on('select2:open', () => {
        setTimeout(() => {
            document.querySelector('.select2-search__field').focus();
        }, 0);
    });

    // Initialize Select2
    function initializeSelect2() {
        $('.select-single').select2({
            placeholder: "Select an option",
            allowClear: false,
            width: '100%'
        });
    }

    initializeSelect2();

    let rowCount = 0;

    // Show one empty row on page load if no data exists
    if ($("#tableBody tr").length === 0) {
        addRow();
    }

    // Add Row Function
    function addRow(
        Course_code = "",
        Course_title = "",
        Order_no = "",
        status = "0"
    ) {
        rowCount++;
        
        let isChecked = (status == "1" || status == 1) ? 'checked' : '';
        
        let newRow = `
            <tr>
                <td>${rowCount}</td>
                <td>
                    <input type="text" name="Course_code[]" class="form-control" value="${Course_code}">
                </td>
                <td>
                    <input type="text" name="Course_title[]" class="form-control" value="${Course_title}">
                </td>
                <td>
                    <input type="number" name="Order_no[]" class="form-control" value="${Order_no}">
                </td>
                <td>
                    <input type="checkbox" name="status[${rowCount - 1}]" value="1" ${isChecked}>
                </td>
                <td>
                    <button type="button" class="btn text-danger btn-sm removeRow">
                        <i class="fa-solid fa-trash"></i>
                    </button>
                </td>
            </tr>`;
        $("#tableBody").append(newRow);
        initializeSelect2();
    }

    // Manual Add Row
    $("#addRowBtn").click(function () {
        addRow();
    });

    // Remove Row
    $(document).on("click", ".removeRow", function () {
        if ($("#tableBody tr").length <= 1) {
            Swal.fire("Warning", "At least one row is required!", "warning");
            return;
        }
        $(this).closest("tr").remove();
        updateSerialNumbers();
    });

    // Update serial numbers
    function updateSerialNumbers() {
        rowCount = 0;
        $("#tableBody tr").each(function () {
            rowCount++;
            $(this).find("td:first").text(rowCount);
            $(this).find('input[type="checkbox"]').attr('name', `status[${rowCount - 1}]`);
        });
    }

    // Clear All Rows
    $("#btnClearAll").click(function () {
        Swal.fire({
            title: 'Are you sure?',
            text: 'This will clear all table data!',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, clear all!'
        }).then((result) => {
            if (result.isConfirmed) {
                $("#tableBody").empty();
                rowCount = 0;
                addRow();
                Swal.fire('Cleared!', 'All table data has been cleared.', 'success');
            }
        });
    });

    // Show Excel Data Button
    $("#btnShow").click(function () {
        let branchId = $("#fkbranch_id").val();
        let yearId = $("#finicial_Year").val();
        let file = $("#excel_file")[0].files[0];

        if (!branchId) {
            Swal.fire("Error", "Please select Department first!", "error");
            return;
        }

        if (!yearId) {
            Swal.fire("Error", "Please select Academic Year first!", "error");
            return;
        }

        if (!file) {
            Swal.fire("Error", "Please select an Excel file first!", "error");
            return;
        }

        if (!file.name.toLowerCase().match(/\.(xlsx|xls)$/)) {
            Swal.fire("Error", "Please select a valid Excel file (.xlsx or .xls)", "error");
            return;
        }

        let reader = new FileReader();
        reader.onload = function (e) {
            try {
                let data = e.target.result;
                let workbook = XLSX.read(data, { 
                    type: "binary",
                    cellText: false,
                    cellDates: true
                });
                
                let firstSheet = workbook.Sheets[workbook.SheetNames[0]];
                let jsonData = XLSX.utils.sheet_to_json(firstSheet, { 
                    header: 1,
                    defval: "",
                    blankrows: false,
                    raw: false
                });

                if (jsonData.length < 2) {
                    Swal.fire("Error", "Excel file must contain header row and at least one data row!", "error");
                    return;
                }

                $("#tableBody").empty();
                rowCount = 0;

                let rowsData = [];

                for (let i = 1; i < jsonData.length; i++) {
                    let row = jsonData[i];
                    
                    if (!row || row.length === 0) {
                        continue;
                    }

                    let Course_code = row[0] ? row[0].toString().trim() : "";
                    let Course_title = row[1] ? row[1].toString().trim() : "";
                    let Order_no = row[2] ? row[2].toString().trim() : "";
                    
                    let statusValue = row[3] ? row[3].toString().trim() : "0";
                    if (statusValue == "1" || 
                        statusValue.toLowerCase() == "yes" || 
                        statusValue.toLowerCase() == "y" || 
                        statusValue.toLowerCase() == "true") {
                        statusValue = "1";
                    } else {
                        statusValue = "0";
                    }

                    if (!Course_code) {
                        continue;
                    }

                    rowsData.push({
                        Course_code: Course_code,
                        Course_title: Course_title,
                        Order_no: Order_no,
                        status: statusValue
                    });
                }

                if (rowsData.length === 0) {
                    Swal.fire("Warning", "No valid records found in the Excel file!", "warning");
                    addRow();
                    return;
                }

                rowsData.forEach((rowData) => {
                    addRow(
                        rowData.Course_code,
                        rowData.Course_title,
                        rowData.Order_no,
                        rowData.status
                    );
                });

                Swal.fire({
                    icon: "success",
                    title: "Success!",
                    text: `Loaded ${rowsData.length} records from Excel!`,
                    timer: 2000,
                    
                    showConfirmButton: false,
                    customClass: {
                            popup: 'custom-swal-popup',
                            icon: 'custom-swal-icon',
                            title: 'custom-swal-title',
                            htmlContainer: 'custom-swal-text'
                        }
                });

            } catch (error) {
                console.error("Excel processing error:", error);
                Swal.fire("Error", "Failed to process Excel file: " + error.message, "error");
            }
        };
        
        reader.onerror = function(error) {
            Swal.fire("Error", "Failed to read Excel file!", "error");
        };
        
        reader.readAsBinaryString(file);
    });

    // Save Form Data
    $("#submit").click(function(e) {
        e.preventDefault();

        if ($("#tableBody tr").length === 0) {
            Swal.fire('Validation Error', 'Please add at least one course record!', 'error');
            return;
        }

        let formData = new FormData($('#Form')[0]);
        
        let Course_id = $('#Course_id').val();
        let isUpdateMode = (Course_id && Course_id.trim() !== '');
        
        console.log("Course ID:", Course_id);
        console.log("Is Update Mode:", isUpdateMode);
        
        let ajaxUrl = isUpdateMode 
            ? '<?= base_url() ?>admin/Course/updateCourse' 
            : '<?= base_url() ?>admin/Course/insertCourse';
        
        console.log("AJAX URL:", ajaxUrl);

        $.ajax({
            url: ajaxUrl,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function() {
                $("#submit").prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');
            },
            success: function(response) {
                console.log("Server response:", response);
                
                try {
                    let result = typeof response === 'string' ? JSON.parse(response) : response;
                    
                    if (result.status === 'success') {
                        Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: '<strong>Success!</strong>',
                        html: 'Data Submitted Successfully',
                        showConfirmButton: false,
                        timer: 2000,
                        customClass: {
                            popup: 'custom-swal-popup',
                            icon: 'custom-swal-icon',
                            title: 'custom-swal-title',
                            htmlContainer: 'custom-swal-text'
                        }
                    }).then(() => { 
                            window.location.href = '<?= base_url() ?>admin/Course/index';
                        });
                    } else {
                        Swal.fire('Error!', result.message || 'Failed to save data!', 'error');
                    }
                } catch (e) {
                    console.error("JSON parse error:", e);
                    Swal.fire('Error!', 'Server returned invalid response.', 'error');
                }
            },
            error: function(xhr, status, error) {
                console.error("AJAX Error:");
                console.error("Status:", status);
                console.error("Response:", xhr.responseText);
                
                let errorMessage = 'Something went wrong!';
                if (xhr.status === 404) {
                    errorMessage = 'Controller method not found (404)';
                } else if (xhr.status === 500) {
                    errorMessage = 'Server error (500)';
                }
                Swal.fire('Error!', errorMessage, 'error');
            },
            complete: function() {
                $("#submit").prop('disabled', false).html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
            }
        });
    });
});
</script>