<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css" integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<style>
.custom-invalid {
    border: 1px solid red !important;
}

body, html {
    overflow-x: hidden !important;
}

.page-wrapper,
.content-wrapper-scroll {
    overflow-x: hidden !important;
}

.wizard {
    margin: 20px auto;
    background: #fff;
}

.wizard-inner {
    position: relative;
    margin-top: -47px;
}

.wizard .nav-tabs {
    display: flex;
    justify-content: space-between;
    align-items: center;
    list-style: none;
    padding-left: 0;
    margin: 40px auto 0;
    border-bottom: none;
    position: relative;
}

.wizard .nav-tabs > li {
    flex: 1;
    text-align: center;
    position: relative;
}

.wizard .nav-tabs > li a {
    width: 70px;
    height: 70px;
    margin: 20px auto;
    border-radius: 100%;
    padding: 0;
    background: transparent;
}

.wizard .nav-tabs > li a:hover {
    background: transparent;
}

span.round-tab {
    width: 70px;
    height: 70px;
    line-height: 70px;
    display: inline-block;
    border-radius: 100px;
    background: #fff;
    border: 2px solid #e0e0e0;
    z-index: 2;
    position: relative;
    text-align: center;
    font-size: 25px;
    transition: 0.3s;
}

span.round-tab i {
    color: #555555;
}

.wizard li.active span.round-tab {
    background: #fff;
    border: 2px solid #1273eb;
}

.wizard li.active span.round-tab i {
    color: #1273eb;
}

span.round-tab:hover {
    color: #333;
    border: 2px solid #333;
}

.connecting-line {
    height: 2px;
    background: #e0e0e0;
    position: absolute;
    width: 100%;
    top: 50%;
    left: 0;
    right: 0;
    z-index: 1;
}

.wizard li:after {
    content: " ";
    position: absolute;
    left: 50%;
    transform: translateX(-50%);
    opacity: 0;
    bottom: 0;
    border: 5px solid transparent;
    border-bottom-color: #1273eb;
    transition: 0.1s ease-in-out;
}

/* .wizard li.active:after {
    content: " ";
    opacity: 1;
    border: 10px solid transparent;
    border-bottom-color: #1273eb;
} */

.wizard li.active:after {
    content: " ";
    opacity: 1;
    border: 10px solid transparent;
    border-bottom-color: #1273eb; 
}


.wizard .tab-pane {
    position: relative;
    padding-top: 50px;
}

.wizard h3 {
    margin-top: 0;
}

/* .nav-tabs>li.active>a, .nav-tabs>li.active>a:hover, .nav-tabs>li.active>a:focus {
    color: #555;
    cursor: default;
    background-color: #fff;
    border: 1px solid transparent !important;
    border-bottom-color: transparent;
} */


/* .nav-tabs>li.active>a, .nav-tabs>li.active>a:hover, .nav-tabs>li.active>a:focus:hover {
    color: #555;
    cursor: default;
    background-color: #fff;
    border: transparent !important;
    border-bottom-color: transparent;
} */
/* Responsive styles */
@media (max-width: 585px) {
    .wizard {
        width: 100%;
    }

    span.round-tab {
        font-size: 16px;
        width: 50px;
        height: 50px;
        line-height: 50px;
    }

    .wizard .nav-tabs > li a {
        width: 50px;
        height: 50px;
        line-height: 50px;
    }

    .wizard li.active:after {
        left: 35%;
    }
}
.wizard-inner .nav-tabs > li {
        text-align: center;
        width: 20%; /* evenly spaced */
    }

    .round-tab {
        width: 40px;
        height: 40px;
        line-height: 40px;
        border-radius: 50%;
        background: #f1f1f1;
        display: inline-block;
        font-size: 16px;
    }

    .step-title {
        display: block;
        margin-top: 5px;
        font-size: 12px;
        color: #333;
    }

    .nav-tabs > li a {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        text-decoration: none;
    }
   /* Green connecting line */
.step-progress-bar {
    position: absolute;
    height: 2px;
    top: 50%;
    left: 0;
    background-color: #28a745; /* green */
    width: 0%;
    z-index: 2;
    transition: width 0.4s ease-in-out;
}

/* Completed step (green round with original icon) */
.wizard li.completed span.round-tab {
    background: #28a745;
    border-color: #28a745;
    color: #fff;
}

.wizard li.completed span.round-tab i {
    color: #fff;
}
.field-icon {
    z-index: 2;
}

#fktypeDesgnation {
    display: block !important;
    visibility: visible !important;
}

/* Qualification Typeahead uses same styling as Working Type */
.qualification-wrapper {
    position: relative;
}
.typeahead-item {
    padding: 12px 15px;
    cursor: pointer;
    border-bottom: 1px solid #f0f0f0;
    transition: background-color 0.2s;
    font-size: 14px;
}
#qualification_typeahead_dropdown {
    position: absolute;
    top: 100%;
    left: 0;
    right: 0;
    background: white;
    border: 1px solid #ced4da;
    border-top: none;
    border-radius: 0 0 4px 4px;
    max-height: 400px;
    overflow-y: auto;
    z-index: 1050;
    display: none;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    margin-top: -1px;
}

#qualification_typeahead_dropdown.show {
    display: block;
}

#experience_table {
    margin-top: 20px;
}

#experience_table thead th {
    background-color: #f8f9fa;
    font-weight: 600;
    border: 1px solid #dee2e6;
}

#experience_table tbody td {
    vertical-align: middle;
}

.table-responsive {
    overflow-x: auto;
}

#add_experience_btn {
    width: 100%;
    height: 38px;
}

@media (max-width: 768px) {
    #experience_table {
        font-size: 0.875rem;
    }
}
/* Typeahead Dropdown Styles */
.typeahead-dropdown {
    position: absolute;
    top: 100%;
    left: 0;
    right: 0;
    background: white;
    border: 1px solid #ddd;
    border-top: none;
    max-height: 200px;
    overflow-y: auto;
    z-index: 1000;
    display: none;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
}

.typeahead-dropdown.show {
    display: block;
}

.typeahead-item {
    padding: 10px 15px;
    cursor: pointer;
    border-bottom: 1px solid #f0f0f0;
    transition: background-color 0.2s;
}

.typeahead-item:hover,
.typeahead-item.active {
    background-color: #f8f9fa;
}

.typeahead-item .name {
    font-weight: 500;
    color: #333;
}

.typeahead-no-results {
    padding: 10px 15px;
    color: #999;
    font-style: italic;
}

.experience-wrapper {
    position: relative;
}
</style>

<div class="content-wrapper-scroll">

					<!-- Content wrapper start -->
					<div class="content-wrapper"style="padding: 1.5rem 1.5rem 1.5rem 1.5rem !important;
   
    overflow: auto">

						<!-- Row start -->
<div class="row gutters">
	<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

								<!-- Card start -->
		<div class="card">
			<!-- <div class="card-header"> -->
										<!-- <div class="card-title">Form 3</div> -->
									<!-- </div> -->
                                    <div class=" card-body">

<div class="container-fluid">
	<div class="row">
		<section>
        <div class="wizard">
           
<div class="wizard-inner">
    <div class="connecting-line"></div>
    <div class="step-progress-bar" id="stepProgress"></div>
    <ul class="nav nav-tabs" role="tablist">

        <li role="presentation" class="active">
            <a href="#step1" data-toggle="tab" aria-controls="step1" role="tab" title="Personal Details">
                <span class="round-tab">
                    <i class="fa-solid fa-user"></i>
                </span>
                <span class="step-title">Personal</span>
            </a>
        </li>

        <li role="presentation" class="disabled">
            <a href="#step2" data-toggle="tab" aria-controls="step2" role="tab" title="Address Details">
                <span class="round-tab">
                    <i class="fa-solid fa-location-dot"></i>
                </span>
                <span class="step-title">Address</span>
            </a>
        </li>

        <li role="presentation" class="disabled">
            <a href="#step3" data-toggle="tab" aria-controls="step3" role="tab" title="Educational Information">
                <span class="round-tab">
                    <i class="fa-solid fa-user-graduate"></i>
                </span>
                <span class="step-title">Education</span>
            </a>
        </li>

        <li role="presentation" class="disabled">
            <a href="#step4" data-toggle="tab" aria-controls="step4" role="tab" title="Document Information">
                <span class="round-tab">
                    <i class="glyphicon glyphicon-folder-open"></i>
                </span>
                <span class="step-title">Documents</span>
            </a>
        </li>

        <!-- <li role="presentation" class="disabled">
            <a href="#step5" data-toggle="tab" aria-controls="step5" role="tab" title="Department Detail">
                <span class="round-tab">
                    <i class="fa-solid fa-building"></i>
                </span>
                <span class="step-title">Department</span>
            </a>
        </li> -->
    </ul>
</div>




            <!-- <form role="form"> -->
                <div class="tab-content">
                    <div class="tab-pane active" role="tabpanel" id="step1">
                        <!-- <h3>Personal Information</h3> -->
   <form id="Form" enctype="multipart/form-data" autocomplete="off">
     <!-- hidden submenuid -->
<input class="form-control" id="fk_submenuId" name="fk_submenuId" type="hidden"
                           value="<?= isset($subId) ? $subId : '' ?>"  />
    <div class="row gutters">

      <!-- Teaching Type -->
        <div class="col-md-3">
            <div class="field-wrapper">
                <select class="select-single js-states" name="teaching_type" id="teaching_type" data-live-search="true" title="Select Type" required>
                    <option value="">Select Type</option>
                    <option value="Teaching" <?= (!empty($data) && $data[0]->teaching_type == 'Teaching') ? 'selected' : '' ?>>Teaching</option>
                    <option value="Non-Teaching" <?= (!empty($data) && $data[0]->teaching_type == 'Non-Teaching') ? 'selected' : '' ?>>Non-Teaching</option>
                </select>
                <div class="field-placeholder">Employee Type<span class="text-danger">*</span></div>
            </div>
        </div>


            <!-- Type Designation (Dependent on Teaching Type) -->
        <div class="col-md-3">
            <div class="field-wrapper">
                <select class="select-single js-states" name="fktypeDesgnation" id="fktypeDesgnation" data-live-search="true" title="Select Type Designation" required>
                    <option value="">Select Designation</option>
                </select>
                <div class="field-placeholder">Select Designation<span class="text-danger">*</span></div>
            </div>
        </div>

     <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
            <div class="field-wrapper">
                <input type="date" 
                       class="form-control" 
                       name="joining_date" 
                       id="joining_date"
                       value="<?php if(!empty($data)) echo $data[0]->joining_date; ?>" 
                       required />
                <div class="field-placeholder">Joining Date<span class="text-danger">*</span></div>
            </div>
        </div>

           <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
            <div class="field-wrapper">
                <input type="date" 
                       class="form-control" 
                       name="DOB" 
                       id="DOB"
                       value="<?php if(!empty($data)) echo $data[0]->DOB; ?>" 
                       required />
                <div class="field-placeholder">Date of Birth<span class="text-danger">*</span></div>
            </div>
        </div>

          <!-- Employeee ID -->
        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-12 col-12">
            <div class="field-wrapper">
                <input class="form-control" type="text" name="fac_EmpID" id="fac_EmpID"
       style="text-transform: uppercase;"
       onKeyPress="if(this.value.length==10) return false;"
       value="<?php if (!empty($data)) echo $data[0]->fac_EmpID; ?>" required>

                <!-- <input class="form-control" type="text" name="fac_EmpID" id="fac_EmpID"
                    onKeyPress="if(this.value.length==10) return false;"
                    value="<?php if (!empty($data)) echo $data[0]->fac_EmpID; ?>" required> -->
                <div class="field-placeholder">Employee/Thumb ID<span class="text-danger">*</span></div>
                <div class="form-text">Please Enter Your Employee ID.</div>
            </div>
        </div>

        <!-- Title -->
        <div class="col-xl-1 col-lg-1 col-md-1 col-sm-1 col-6">
            <div class="field-wrapper">
                <select class="select-single js-states" name="fkTitle_id" id="fkTitle_id"
                    title="Select Title" data-live-search="true">
                    <?php if (!empty($Title)): ?>
                        <?php foreach ($Title as $tit): ?>
                            <option value="<?= $tit->Title_id ?>"><?= $tit->Title_name ?></option>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <option value="">No Title found</option>
                    <?php endif; ?>
                </select>
                <div class="field-placeholder">Title</div>
            </div>
        </div>

         <!-- First Name -->
        <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
            <div class="field-wrapper">
                <input class="form-control" type="text" name="fac_Fname" id="fac_Fname"
                     style="color: #FF007F;" value="<?php if (!empty($data)) echo $data[0]->fac_Fname; ?>" required>
                <div class="field-placeholder">First Name<span class="text-danger">*</span></div>
                <div class="form-text">Please Enter Your First Name.</div>
            </div>
        </div>

        <!-- Middle Name -->
        <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
            <div class="field-wrapper">
                <input class="form-control" type="text" name="fac_Mname" id="fac_Mname"
                   style="color: #FF007F;"  value="<?php if (!empty($data)) echo $data[0]->fac_Mname; ?>" required>
                <div class="field-placeholder">Middle Name<span class="text-danger">*</span></div>
                <div class="form-text">Please Enter Your Middle Name.</div>
            </div>
        </div>

        <!-- Last Name -->
        <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
            <div class="field-wrapper">
                <input class="form-control" type="text" name="fac_Lname" id="fac_Lname"
                  style="color: #FF007F;"   value="<?php if (!empty($data)) echo $data[0]->fac_Lname; ?>" required>
                <div class="field-placeholder">Last Name<span class="text-danger">*</span></div>
                <div class="form-text">Please Enter Your Last Name.</div>
            </div>
        </div>


        <!-- Gender -->
        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
            <div class="field-wrapper">
                <div class="checkbox-container">
                    <?php if (!empty($genders)): ?>
                        <?php $index = 0; ?>
                        <?php foreach ($genders as $gender): ?>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="fkgender"
                                    id="fkgender<?= $gender->gender_id ?>" value="<?= $gender->gender_id ?>"
                                    <?= $index === 0 ? 'checked' : '' ?>>
                                <label class="form-check-label" for="fkgender<?= $gender->gender_id ?>">
                                    <?= $gender->gender_name ?>
                                </label>
                            </div>
                            <?php $index++; ?>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <p>No gender options found.</p>
                    <?php endif; ?>
                    <div class="field-placeholder">Gender</div>
                </div>
            </div>
        </div>




        <!-- Full Name -->
        <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-10">
            <div class="field-wrapper">
                <input class="form-control" type="text" name="fac_Fullname" id="fac_Fullname"
                   style="color: #FF007F;" value="<?php if (!empty($data)) echo $data[0]->fac_Fullname; ?>" readonly required>
                <div class="field-placeholder">Full Name<span class="text-danger">*</span></div>
                <div class="form-text">Please Enter Your Full Name.</div>
            </div>
        </div>


        <!-- Mobile Number -->
        <div class="col-xl-2 col-lg-2 col-md-2 col-sm-12 col-12">
            <div class="field-wrapper">
                <input class="form-control" type="number" name="fac_mobileNo" id="fac_mobileNo"
                    onKeyPress="if(this.value.length==10) return false;"
                    value="<?php if (!empty($data)) echo $data[0]->fac_mobileNo; ?>" required>
                <div class="field-placeholder">Mobile NO.<span class="text-danger">*</span></div>
                <div class="form-text">Please Enter Your Mobile Number.</div>
            </div>
        </div>

          <!-- Whatsup Number -->
        <div class="col-xl-2 col-lg-2 col-md-2 col-sm-12 col-12">
            <div class="field-wrapper">
                <input class="form-control" type="number" name="fac_WpNo" id="fac_WpNo"
                    onKeyPress="if(this.value.length==10) return false;"
                    value="<?php if (!empty($data)) echo $data[0]->fac_WpNo; ?>" required>
                <div class="field-placeholder">Whatsup NO.<span class="text-danger">*</span></div>
                <div class="form-text">Please Enter Your Whatsup Number.</div>
            </div>
        </div>

         <!-- Email -->
        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
            <div class="field-wrapper">
                <input class="form-control" type="email" name="fac_mailId" id="fac_mailId"
                    value="<?php if (!empty($data)) echo $data[0]->fac_mailId; ?>" required>
                <div class="field-placeholder">Email ID<span class="text-danger">*</span></div>
                <div class="form-text">We'll never share your email with anyone.</div>
            </div>
        </div>

   <!-- Religion -->
        <!-- <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
            <div class="field-wrapper">
                <select class="select-single js-states" name="fkReligion_id" id="fkReligion_id"
                    title="Select Religion" data-live-search="true">
                    <?php if (!empty($Religion)): ?>
                        <?php foreach ($Religion as $rel): ?>
                            <option value="<?= $rel->Religion_id ?>"><?= $rel->Religion_name ?></option>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <option value="">No Religion found</option>
                    <?php endif; ?>
                </select>
                <div class="field-placeholder">Religion</div>
            </div>
        </div> -->
        <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
    <div class="field-wrapper">
        <select class="select-single js-states" name="fkReligion_id" id="fkReligion_id"
            title="Select Religion" data-live-search="true" required>
            <?php if (!empty($Religion)): ?>
                <?php foreach ($Religion as $rel): ?>
                    <option value="<?= $rel->Religion_id ?>"><?= $rel->Religion_name ?></option>
                <?php endforeach; ?>
            <?php else: ?>
                <option value="">No Religion found</option>
            <?php endif; ?>
        </select>
        <div class="field-placeholder">Religion <span style="color:red;">*</span></div>
    </div>
</div>


        <!-- Caste -->
        <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
            <div class="field-wrapper">
                <select class="select-single js-states" name="fkCaste_id" id="fkCaste_id"
                    title="Select Caste" data-live-search="true" required>
                    <?php if (!empty($Caste)): ?>
                        <?php foreach ($Caste as $cas): ?>
                            <option value="<?= $cas->Caste_id ?>"><?= $cas->Caste_name ?></option>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <option value="">No Caste found</option>
                    <?php endif; ?>
                </select>
                <div class="field-placeholder">Select Caste<span style="color:red;">*</span></div>
            </div>
        </div>

        <!-- Caste Category -->
        <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
            <div class="field-wrapper">
                <select class="select-single js-states" name="fkCasteCateg_id" id="fkCasteCateg_id"
                    title="Select Caste Category" data-live-search="true" required>
                    <?php if (!empty($CasteCate)): ?>
                        <?php foreach ($CasteCate as $cat): ?>
                            <option value="<?= $cat->Category_id ?>"><?= $cat->Category_name ?></option>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <option value="">No Caste categories found</option>
                    <?php endif; ?>
                </select>
                <div class="field-placeholder">Caste Category<span class="text-danger">*</span></div>
            </div>
        </div>

        <!-- Sub-Caste -->
        <!-- <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
            <div class="field-wrapper">
                <select class="select-single js-states" name="fkSubCaste_id" id="fkSubCaste_id"
                    title="Select Sub-Caste Category" data-live-search="true"required>
                    <?php if (!empty($SubCaste)): ?>
                        <?php foreach ($SubCaste as $sub): ?>
                            <option value="<?= $sub->SubCaste_id ?>"><?= $sub->SubCaste_name ?></option>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <option value="">No Sub-Caste categories found</option>
                    <?php endif; ?>
                </select>
                <div class="field-placeholder">Sub-Caste Category<span class="text-danger">*</span></div>
            </div>
        </div> -->

        <!-- Sub-Caste -->
<div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
    <div class="field-wrapper">
        <div class="input-group">
            <select class="select-single js-states" name="fkSubCaste_id" id="fkSubCaste_id"
                title="Select Sub-Caste Category" data-live-search="true" required>
                <?php if (!empty($SubCaste)): ?>
                    <?php foreach ($SubCaste as $sub): ?>
                        <option value="<?= $sub->SubCaste_id ?>"><?= $sub->SubCaste_name ?></option>
                    <?php endforeach; ?>
                <?php else: ?>
                    <option value="">No Sub-Caste categories found</option>
                <?php endif; ?>
            </select>
            
        </div>
        <div class="field-placeholder">Sub-Caste Category<span class="text-danger">*</span></div>
    </div>
</div>

<div class="col-xl-1 col-lg-1 col-md-1 col-sm-1 col-12 mt-2">
<button class="btn btn-success" type="button" id="add_subcaste_btn" title="Add New Sub-Caste">
                <i class="fa fa-plus"></i>
            </button>
                </div>


<!-- Add Sub-Caste Modal -->
<div class="modal fade" id="addSubCasteModal" tabindex="-1" role="dialog" aria-labelledby="addSubCasteModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addSubCasteModalLabel">Add New Sub-Caste</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="addSubCasteForm">
                    <div class="form-group">
                        <label for="new_subcaste_name">Sub-Caste Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="new_subcaste_name" name="new_subcaste_name" 
                               placeholder="Enter Sub-Caste Name" required>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" id="save_subcaste_btn">
                    <i class="fa fa-save"></i> Save Sub-Caste
                </button>
            </div>
        </div>
    </div>
</div>


        <!-- Caste Number -->
        <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
            <div class="field-wrapper">
                <input class="form-control" type="number" name="CasteNo" id="CasteNo"
                    value="<?php if (!empty($data)) echo $data[0]->CasteNo; ?>">
                <div class="field-placeholder">Caste Number</div>
            </div>
        </div>


         <!-- Qualification -->
        <!-- <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
            <div class="field-wrapper">
          
                    <input class="form-control" type="text" 
                          name="fkQualify_id" id="fkQualify_id"
                          autocomplete="off"
                         value="<?php if (!empty($data)) echo $data[0]->fkQualify_id; ?>" required>

                <div class="field-placeholder">Qualification<span class="text-danger">*</span></div>
            </div>
        </div> -->
        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
    <div class="field-wrapper">
        <div class="qualification-wrapper" style="position: relative;">
            <input class="form-control" 
                   type="text" 
                   name="fkQualify_id" 
                   id="fkQualify_id"
                   autocomplete="off"
                   value="<?php if (!empty($data)) echo $data[0]->fkQualify_id; ?>" 
                   required>
            
            <!-- ✨ Typeahead Dropdown -->
            <div class="typeahead-dropdown" id="qualification_typeahead_dropdown"></div>
        </div>
        <div class="field-placeholder">Qualification<span class="text-danger">*</span></div>
    </div>
</div>

        <!-- Blood Group -->
        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
            <div class="field-wrapper">
                <select class="select-single js-states" name="fkBloodgrp" id="fkBloodgrp"
                    title="Select Blood Group" data-live-search="true"required>
                    <?php if (!empty($Blood)): ?>
                        <?php foreach ($Blood as $bld): ?>
                            <option value="<?= $bld->Bloodgrp_id ?>"><?= $bld->Bloodgrp_name ?></option>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <option value="">No Blood Group found</option>
                    <?php endif; ?>
                </select>
                <div class="field-placeholder">Select Blood Group<span class="text-danger">*</span></div>
            </div>
        </div>

        <!-- Handicap Checkbox -->
        <div class="col-md-2 mt-4">
            <div class="form-check mt-2">
                <input class="form-check-input" type="checkbox" id="is_handikaped" name="is_handikaped" value="1">
                <label class="form-check-label" for="is_handikaped">Handicap</label>
            </div>
        </div>

        <!-- Handicap Type -->
        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
            <div class="field-wrapper">
                <select class="select-single js-states" name="fkhandikap_type" id="fkhandikap_type"
                    title="Select Handicap Type" data-live-search="true">
                    <?php if (!empty($Handi)): ?>
                        <?php foreach ($Handi as $hand): ?>
                            <option value="<?= $hand->handikap_id ?>"><?= $hand->handikap_name ?></option>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <option value="">No Handicap Type found</option>
                    <?php endif; ?>
                </select>
                <div class="field-placeholder">Handicap Type</div>
            </div>
        </div>

        <!-- Active/Deactive -->
        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
            <div class="field-wrapper">
                <label class="form-label">Active/Deactive</label>
                <div class="form-check form-check-inline">
                    <input class="form-check-input" type="radio" name="Active_Deactive" value="1" id="active" checked>
                    <label class="form-check-label" for="active">Active</label>
                </div>
                <div class="form-check form-check-inline">
                    <input class="form-check-input" type="radio" name="Active_Deactive" value="0" id="deactive">
                    <label class="form-check-label" for="deactive">Deactive</label>
                </div>
            </div>
        </div>

       
        <!-- File Upload -->
        <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
            <div class="field-wrapper">
                <div class="input-group">
                    <input type="file" class="form-control" id="fac_Photo" name="fac_Photo">
                    <button class="btn btn-outline-primary" type="button">Photo Upload</button>
                </div>
            </div>
            <?php if (!empty($data[0]->Photo_1)) { ?>
                <a href="<?= base_url(); ?>upload/<?= $data[0]->Photo_1; ?>" target="_blank">
                    <img src="<?= base_url(); ?>upload/<?= $data[0]->Photo_1; ?>" id="fac_Photo_img_preview"
                        class="img-thumbnail" style="height: 86px; margin: 10px 32px;">
                </a>
            <?php } else { ?>
                <img src="" id="fac_Photo_img_preview" class="img-thumbnail"
                    style="margin: 10px 32px; height: 86px; display: none;">
            <?php } ?>
            <input type="hidden" name="hidden_photo" id="hidden_photo"
                value="<?php if (!empty($data[0]->Photo_1)) echo $data[0]->Photo_1; ?>">
        </div>

        <!-- Password -->
       <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
    <div class="field-wrapper position-relative">
        <input class="form-control" type="password"
            id="Password" name="Password"
            autocomplete="new-password"
            value="<?php if (!empty($data)) echo $data[0]->Password; ?>">

        <div class="field-placeholder">Password<span class="text-danger">*</span></div>

        <!-- Eye Icon -->
        <span toggle="#Password" class="fa fa-fw fa-eye field-icon toggle-password"
              style="position: absolute; top: 50%; right: 15px; transform: translateY(-50%); cursor: pointer;"></span>
    </div>
</div>


        <!-- Branch -->
         <div class="col-md-4">
                <div class="field-wrapper">
                    <select class="select-single js-states" name="fkbranch_id" id="fkbranch_id" data-live-search="true" title="Select Branch Name">
                        <option value="">Select Branch</option>
                        <?php foreach ($Branch ?? [] as $bran): ?>
                            <option value="<?= $bran->branch_id ?>"><?= $bran->branch_name ?></option>
                        <?php endforeach; ?>
                    </select>
                    <div class="field-placeholder">Select Branch<span class="text-danger">*</span></div>
                </div>
            </div>
 
</form>
		
										</div>

                                          <ul class="list-inline pull-right">
                            <li><button type="button" class="btn mb-md-0 mb-2 btn-quarternary next-step"  name="btn_save" id="btn_save">Save and continue</button></li>
                        <li>
    <button type="button" class="btn mb-md-0 mb-2 btn-quarternary1" onclick="window.location.href='<?= base_url('admin/Faculty/index') ?>'">
        <i class="fas fa-list"></i> View List
    </button>
</li>
<li>
     <button class="btn mb-md-0 mb-2 btn-quarternaryhome" type="button"  onclick="window.location.href='<?= base_url() ?>admin/Faculty/dashboard'" ><a href="" class="text-decoration-none text-white "><i class="fa-solid fa-home"></i>&nbsp;&nbsp;</a>Home</button><br>
</li>


                        </ul>
                        
                        <!-- <ul class="list-inline pull-right">
                            <li><button type="button" class="btn btn-primary next-step"  name="btn_save" id="btn_save">Save and continue</button></li>
                        <li>
    <button type="button" class="btn btn-outline-primary" onclick="window.location.href='<?= base_url('Faculty/index') ?>'">
        <i class="fas fa-list"></i> View List
    </button>
</li>

                        </ul> -->
                    </div>

                    <!-- Educational Information -->
                    <div class="tab-pane" role="tabpanel" id="step3">
                        <!-- <h3>Educational Information</h3> -->
                  <!-- All content inside one accordion body -->
        <form id="Form1" enctype="multipart/form-data">
<input type="hidden" id="base_path" value="<?= base_url(); ?>">
   <input type="hidden" id="fk_submenuId" name="fk_submenuId" 
           value="<?= isset($subId) ? $subId : '' ?>">
 <input type="hidden" id="fac_id" name="fac_id" value="<?= !empty($data) ? $data[0]->fac_id : '' ?>">
          <div class="row gutters">
              <h5>HSC/Diploma Information</h5>
            <!-- Highest Qualification -->
             <div class="col-md-3">
    <div class="field-wrapper">
        <input class="form-control" 
               type="text" 
               name="fkfac_HighestQualify" 
               id="fkfac_HighestQualify"
               value="<?php if (!empty($data)) echo $data[0]->fkfac_HighestQualify; ?>" 
               required>
        <div class="field-placeholder">HSC/Diploma<span class="text-danger">*</span></div>
        <div class="form-text">Please Enter Qualification.</div>
    </div>
</div>

            <!-- <div class="col-md-3">
               <div class="field-wrapper">
          <select class="select-single js-states" name="fkfac_HighestQualify" id="fkfac_HighestQualify"
                title="Select Qualification" data-live-search="true">
                <?php if (!empty($Qualification)): ?>
                    <?php foreach ($Qualification as $Qualify): ?>
                        <option value="<?= $Qualify->Qualify_id ?>"><?= $Qualify->Qualify_name ?></option>
                    <?php endforeach; ?>
                <?php else: ?>
                    <option value="">No Branch found</option>
                <?php endif; ?>
            </select>
            <div class="field-placeholder">HSC</div>
        </div>
            </div> -->

            <!-- Board Name -->
             <div class="col-md-3">
    <div class="field-wrapper">
        <input class="form-control" 
               type="text" 
               name="Board" 
               id="Board"
               value="<?php if (!empty($data)) echo $data[0]->Board; ?>" 
               required>
        <div class="field-placeholder">Board<span class="text-danger">*</span></div>
        <div class="form-text">Please Enter Board.</div>
    </div>
</div>

            <!-- <div class="col-md-4">
                 <div class="field-wrapper">
            <select class="select-single js-states" name="fkInstitu_id" id="fkInstitu_id"
                title="Select Institute Name" data-live-search="true">
                <?php if (!empty($Institute)): ?>
                    <?php foreach ($Institute as $Insti): ?>
                        <option value="<?= $Insti->Institu_id ?>"><?= $Insti->Institu_name ?></option>
                    <?php endforeach; ?>
                <?php else: ?>
                    <option value="">No Institute Name found</option>
                <?php endif; ?>
            </select>
            <div class="field-placeholder">Select Institue</div>
        </div>
            </div> -->

            <!-- Stream -->
             <div class="col-md-3">
    <div class="field-wrapper">
        <input class="form-control" 
               type="text" 
               name="Stream" 
               id="Stream"
               value="<?php if (!empty($data)) echo $data[0]->Stream; ?>" 
               required>
        <div class="field-placeholder">Stream<span class="text-danger">*</span></div>
        <div class="form-text">Please Enter Stream.</div>
    </div>
</div>

<div class="col-md-3">
    <div class="field-wrapper">
        <input class="form-control" 
               type="number" 
               name="HSCDipMarks" 
               id="HSCDipMarks"
               value="<?php if (!empty($data)) echo $data[0]->HSCDipMarks; ?>" 
               required>
        <div class="field-placeholder">HSC/Diploma Marks<span class="text-danger">*</span></div>
        <div class="form-text">Please Enter Marks.</div>
    </div>
</div>


<!-- HSC/Diploma Passing Year -->
    <div class="col-md-3">
  <div class="field-wrapper">
    <input type="text" class="form-control month-year-format" placeholder="MM-YYYY" name="HSCDip_CompliYear" id="HSCDip_CompliYear"
           value="<?php if(!empty($data)) echo $data[0]->HSCDip_CompliYear; ?>" maxlength="7" required>
    <div class="field-placeholder">HSC/Diploma Completed Year</div>
  </div>
</div>

            <!-- <div class="col-md-3">
                     <div class="field-wrapper">
            <select class="select-single js-states" name="fkDepartment" id="fkDepartment"
                title="Select Department Name" data-live-search="true">
                <?php if (!empty($Department)): ?>
                    <?php foreach ($Department as $dep): ?>
                        <option value="<?= $dep->dep_id ?>"><?= $dep->dep_name ?></option>
                    <?php endforeach; ?>
                <?php else: ?>
                    <option value="">No Department found</option>
                <?php endif; ?>
            </select>
            <div class="field-placeholder">Select Department</div>
        </div>
            </div> -->

            <!-- Branch -->
            <!-- <div class="col-md-3 mt-3">
              <div class="field-wrapper">
            <select class="select-single js-states" name="fkBrach" id="fkBrach"
                title="Select Branch Name" data-live-search="true">
                <?php if (!empty($Branch)): ?>
                    <?php foreach ($Branch as $bran): ?>
                        <option value="<?= $bran->branch_id ?>"><?= $bran->branch_name ?></option>
                    <?php endforeach; ?>
                <?php else: ?>
                    <option value="">No Branch found</option>
                <?php endif; ?>
            </select>
            <div class="field-placeholder">Select Branch</div>
        </div>
            </div> -->

            <!-- Subject -->
            <!-- <div class="col-md-3 mt-3">
          <div class="field-wrapper">
            <select class="select-single js-states" name="fksub_id" id="fksub_id"
                title="Select Subject Name" data-live-search="true">
                <?php if (!empty($Subject)): ?>
                    <?php foreach ($Subject as $sub): ?>
                        <option value="<?= $sub->sub_id ?>"><?= $sub->sub_name ?></option>
                    <?php endforeach; ?>
                <?php else: ?>
                    <option value="">No Subject found</option>
                <?php endif; ?>
            </select>
            <div class="field-placeholder">Select Subject</div>
        </div>
            </div> -->

            <!-- Designation -->
            <!-- <div class="col-md-3 mt-3">
             <div class="field-wrapper">
            <select class="select-single js-states" name="fkdesig_id" id="fkdesig_id"
                title="Select Designation Name" data-live-search="true">
                <?php if (!empty($Designation)): ?>
                    <?php foreach ($Designation as $desgi): ?>
                        <option value="<?= $desgi->desig_id ?>"><?= $desgi->desig_name ?></option>
                    <?php endforeach; ?>
                <?php else: ?>
                    <option value="">No Designation found</option>
                <?php endif; ?>
            </select>
            <div class="field-placeholder">Select Designation</div>
        </div>
            </div> -->
<hr>
<h5>Bachelor Degree Information</h5>
            <!-- BE/B.Tech Info -->
             <div class="col-md-3">
    <div class="field-wrapper">
        <input class="form-control" 
               type="text" 
               name="Btech_branchID" 
               id="Btech_branchID"
               value="<?php if (!empty($data)) echo $data[0]->Btech_branchID; ?>" 
               required>
        <div class="field-placeholder">Branch<span class="text-danger">*</span></div>
        <div class="form-text">Please Enter Branch.</div>
    </div>
</div>

<!-- Bachelor University Name -->
 <div class="col-md-4">
    <div class="field-wrapper">
        <input class="form-control" 
               type="text" 
               name="Btech_Uni" 
               id="Btech_Uni"
               value="<?php if (!empty($data)) echo $data[0]->Btech_Uni; ?>" 
               required>
        <div class="field-placeholder">University Name<span class="text-danger">*</span></div>
        <div class="form-text">Please Enter Name.</div>
    </div>
</div>

            <!-- <div class="col-md-3 mt-3">
             <div class="field-wrapper">
           <select class="select-single js-states" name="Btech_branchID" id="Btech_branchID"
                title="Select Branch Name" data-live-search="true">
                <?php if (!empty($Branch)): ?>
                    <?php foreach ($Branch as $bran): ?>
                        <option value="<?= $bran->branch_id ?>"><?= $bran->branch_name ?></option>
                    <?php endforeach; ?>
                <?php else: ?>
                    <option value="">No Branch found</option>
                <?php endif; ?>
            </select>
            <div class="field-placeholder">BE/B.Tech Branch</div>
        </div>
            </div> -->

            <div class="col-md-3">
              <div class="field-wrapper">
                <input type="number" class="form-control" name="Btech_Mark" id="Btech_Mark"
                 value="<?php if(!empty($data)) echo $data[0]->Btech_Mark; ?>" required="">
                <div class="field-placeholder">Bachelor Degree Marks</div>
                <!-- <div class="valid-tooltip">Looks good!</div> -->
              </div>
            </div>

        <div class="col-md-3">
  <div class="field-wrapper">
    <input type="text" class="form-control month-year-format" placeholder="MM-YYYY" name="Btech_CompliYear" id="Btech_CompliYear"
           value="<?php if(!empty($data)) echo $data[0]->Btech_CompliYear; ?>" maxlength="7" required>
    <div class="field-placeholder">Bachelor Degree Completed Year</div>
  </div>
</div>

<hr>
<h5>Master Degree Information</h5>
            <!-- M.Tech Info -->
             <div class="col-md-3">
    <div class="field-wrapper">
        <input class="form-control" 
               type="text" 
               name="Mtech_branchID" 
               id="Mtech_branchID"
               value="<?php if (!empty($data)) echo $data[0]->Mtech_branchID; ?>" 
               required>
        <div class="field-placeholder">Branch<span class="text-danger">*</span></div>
        <div class="form-text">Please Enter Branch.</div>
    </div>
</div>

<!-- Master University Name -->
 <div class="col-md-4">
    <div class="field-wrapper">
        <input class="form-control" 
               type="text" 
               name="Mtech_Uni" 
               id="Mtech_Uni"
               value="<?php if (!empty($data)) echo $data[0]->Mtech_Uni; ?>" 
               required>
        <div class="field-placeholder">University Name<span class="text-danger">*</span></div>
        <div class="form-text">Please Enter Name.</div>
    </div>
</div>
            <!-- <div class="col-md-3 mt-3">
             <div class="field-wrapper">
           <select class="select-single js-states" name="Mtech_branchID" id="Mtech_branchID"
                title="Select M.Tech Name" data-live-search="true">
                <?php if (!empty($Branch)): ?>
                    <?php foreach ($Branch as $bran): ?>
                        <option value="<?= $bran->branch_id ?>"><?= $bran->branch_name ?></option>
                    <?php endforeach; ?>
                <?php else: ?>
                    <option value="">No Branch found</option>
                <?php endif; ?>
            </select>
            <div class="field-placeholder">M.Tech Branch</div>
        </div>
            </div> -->

            <div class="col-md-3">
              <div class="field-wrapper">
                <input type="number" class="form-control" name="Mtech_Mark" id="Mtech_Mark"
                 value="<?php if(!empty($data)) echo $data[0]->Mtech_Mark; ?>" required="">
                <div class="field-placeholder">Master Degree Marks</div>
                <!-- <div class="valid-tooltip">Looks good!</div> -->
              </div>
            </div>

           <div class="col-md-3">
  <div class="field-wrapper">
    <input type="text" class="form-control month-year-format" placeholder="MM-YYYY" name="Mtech_CompliYear" id="Mtech_CompliYear"
           value="<?php if(!empty($data)) echo $data[0]->Mtech_CompliYear; ?>" maxlength="7" required>
    <div class="field-placeholder">Master Degree Completed Year</div>
  </div>
</div>
<hr>
<h5>PHD Information</h5>
            <!-- PhD Info -->
            <div class="col-md-2 mt-4">
              <div class="form-check mt-2">
                <input class="form-check-input" type="checkbox" name="PHD_flag" id="PHD_flag" value="1">

                <label class="form-check-label" for="phdCheck">PhD</label>
              </div>
            </div>

            <div class="col-md-3 mt-3">
              <div class="field-wrapper">
          <select class="select-single js-states" name="PHD_branchID" id="PHD_branchID"
                title="Select Branch Name" data-live-search="true">
                <?php if (!empty($Branch)): ?>
                    <?php foreach ($Branch as $bran): ?>
                        <option value="<?= $bran->branch_id ?>"><?= $bran->branch_name ?></option>
                    <?php endforeach; ?>
                <?php else: ?>
                    <option value="">No Branch found</option>
                <?php endif; ?>
            </select>
            <div class="field-placeholder">PHD Branch</div>
        </div>
            </div>

            <div class="col-md-3 mt-3">
              <div class="field-wrapper">
                <input type="text" class="form-control month-year-format" placeholder="MM-YYYY" name="PHD_CompliYear" id="PHD_CompliYear"
                                                value="<?php if(!empty($data)) echo $data[0]->PHD_CompliYear; ?>" required="">
                <div class="field-placeholder">PhD Completed Year</div>
              </div>
            </div>
<hr>

<h5>Experience</h5>

<!-- Experience Input Fields -->
<div class="row gutters" id="experience-input-section">
    <!-- Job Details -->
    <div class="col-xl-2 col-lg-2 col-md-3 col-sm-6 col-12 mt-3">
        <div class="field-wrapper">
            <div class="experience-wrapper" style="position: relative;">
                <input class="form-control" type="text" name="job_details_temp" id="job_details_temp" autocomplete="off">
                <div class="typeahead-dropdown" id="job_details_dropdown"></div>
            </div>
            <div class="field-placeholder">Job Details</div>
        </div>
    </div>
    
    <!-- Company Name with Typeahead -->
    <div class="col-xl-2 col-lg-2 col-md-3 col-sm-6 col-12 mt-3">
        <div class="field-wrapper">
            <div class="experience-wrapper" style="position: relative;">
                <input class="form-control" type="text" name="company_name_temp" id="company_name_temp" autocomplete="off">
                <div class="typeahead-dropdown" id="company_name_dropdown"></div>
            </div>
            <div class="field-placeholder">Company Name</div>
        </div>
    </div>
    
    <!-- Job Type with Typeahead -->
    <div class="col-xl-2 col-lg-2 col-md-3 col-sm-6 col-12 mt-3">
        <div class="field-wrapper">
            <div class="experience-wrapper" style="position: relative;">
                <input class="form-control" type="text" name="job_type_temp" id="job_type_temp" autocomplete="off">
                <div class="typeahead-dropdown" id="job_type_dropdown"></div>
            </div>
            <div class="field-placeholder">Job Type</div>
        </div>
    </div>
    
    <!-- Start Date -->
    <div class="col-xl-2 col-lg-2 col-md-3 col-sm-6 col-12 mt-3">
        <div class="field-wrapper">
            <input class="form-control" type="date" name="start_date_temp" id="start_date_temp">
            <div class="field-placeholder">Start Date</div>
        </div>
    </div>
    
    <!-- End Date -->
    <div class="col-xl-2 col-lg-2 col-md-3 col-sm-6 col-12 mt-3">
        <div class="field-wrapper">
            <input class="form-control" type="date" name="end_date_temp" id="end_date_temp">
            <div class="field-placeholder">End Date</div>
        </div>
    </div>


    
 <!-- Experience Letter Upload -->
<div class="col-xl-2 col-lg-2 col-md-3 col-sm-6 col-12 mt-3">
    <div class="field-wrapper">
        <div class="field-placeholder">Experience Letter</div>
        <input type="file" 
               name="exp_letter_temp" 
               id="exp_letter_temp"
               class="form-control"
               accept=".pdf,.doc,.docx,.jpg,.jpeg,.png">
        <div id="exp_preview_temp" style="margin-top:10px; display:none;">
            <a href="#" target="_blank" id="exp_preview_link">
                <img src="" id="exp_preview_img" style="height: 60px; border:1px solid #ccc; padding:2px;">
            </a>
        </div>
    </div>
</div>
 
<script>
function previewcc(input) {
    const preview = document.getElementById('file_company'); // FIXED
    const file = input.files[0];

    if (file) {
        const fileType = file.type;
        const fileUrl = URL.createObjectURL(file);

        if (fileType.startsWith('image/')) {

            preview.innerHTML = `
                <a href="${fileUrl}" target="_blank">
                    <img src="${fileUrl}" style="height: 100px; border:1px solid #ccc; padding:2px;">
                </a>`;
        } else {

            preview.innerHTML = `
                <a href="${fileUrl}" target="_blank">
                    <img src="<?= base_url('Assets/img/Document_file.png') ?>" style="height: 100px;">
                </a>`;
        }

    } else {
        preview.innerHTML = `
            <img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" style="height: 100px;">`;
    }
}
</script>
    
    <!-- Add Button -->
    <div class="col-xl-2 col-lg-2 col-md-3 col-sm-6 col-12 mt-3">
        <button type="button" class="btn btn-success" id="add_experience_btn">
            <i class="icon-plus"></i> Add
        </button>
    </div>


</div>

<!-- Experience Table -->
<div class="row gutters mt-4">
    <div class="col-12">
        <div class="table-responsive">
            <table class="table table-bordered" id="experience_table">
                <thead class="table-light">
                    <tr>
                        <th>Job Details</th>
                        <th>Company Name</th>
                        <th>Job Type</th>
                        <th>Start Date</th>
                        <th>End Date</th>
                        <th>Experience Letter</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody id="experience_table_body">
                    <!-- Experience rows will be added here dynamically -->
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Hidden input to store experience data as JSON -->
<input type="hidden" name="experience_data" id="experience_data" value="">

          </div>
        </form>

 <ul class="list-inline pull-right">
                            <li><button type="button" class="btn mb-md-0 mb-2 btn-quarternary1 prev-step">Previous</button></li>
                            <li><button type="button" class="btn mb-md-0 mb-2 btn-quarternary next-step"  name="btn_submit" id="btn_submit">Save and continue</button></li>
                
                        </ul>
                        <!-- <ul class="list-inline pull-right">
                            <li><button type="button" class="btn btn-default prev-step">Previous</button></li>
                            <li><button type="button" class="btn btn-primary next-step"  name="btn_submit" id="btn_submit">Save and continue</button></li>
                        </ul> -->
                    </div>


<!-- Address Information -->
  <div class="tab-pane" role="tabpanel" id="step2">
                        <!-- <h3>Educational Information</h3> -->
                  <!-- All content inside one accordion body -->
       <form id="Form3" enctype="multipart/form-data">
           <input type="hidden" id="fk_submenuId" name="fk_submenuId" 
           value="<?= isset($subId) ? $subId : '' ?>">
    <input type="hidden" id="fac_id_add" name="fac_id">

    <!-- Present Address Row -->
    <div class="row gutters">
        <!-- Present Address -->
        <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 col-12">
            <div class="field-wrapper">
                <textarea class="form-control" name="fac_PresentAdd" id="fac_PresentAdd" rows="3" required><?php if(!empty($data)) echo $data[0]->fac_PresentAdd; ?></textarea>
                <div class="field-placeholder">Present Address<span class="text-danger">*</span></div>
            </div>
        </div>

        <!-- Present District -->
        <div class="col-xl-2 col-lg-2 col-md-2 col-sm-12 col-12">
            <div class="field-wrapper">
                <select class="select-single js-states" name="fkPresentDist_id" id="fkPresentDist_id"
                    title="Select District" data-live-search="true" required>
                    <?php if (!empty($District)): ?>
                        <?php foreach ($District as $dis): ?>
                            <option value="<?= $dis->district_id ?>"><?= $dis->district_name ?></option>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <option value="">No District found</option>
                    <?php endif; ?>
                </select>
                <div class="field-placeholder">Select District<span class="text-danger">*</span></div>
            </div>
        </div>

        <!-- Present State -->
        <div class="col-xl-2 col-lg-2 col-md-2 col-sm-12 col-12">
            <div class="field-wrapper">
                <select class="select-single js-states" name="fkPresentState_id" id="fkPresentState_id"
                    title="Select State" data-live-search="true" required>
                    <?php if (!empty($State)): ?>
                        <?php foreach ($State as $sta): ?>
                            <option value="<?= $sta->stateId ?>"><?= $sta->stateName ?></option>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <option value="">No State found</option>
                    <?php endif; ?>
                </select>
                <div class="field-placeholder">Select State<span class="text-danger">*</span></div>
            </div>
        </div>

         <!-- Present Taluka -->
        <div class="col-xl-2 col-lg-2 col-md-2 col-sm-12 col-12">
            <div class="field-wrapper">
                <select class="select-single js-states" name="fkTaluka_id" id="fkTaluka_id"
                    title="Select District" data-live-search="true" required>
                    <?php if (!empty($Taluka)): ?>
                        <?php foreach ($Taluka as $tal): ?>
                            <option value="<?= $tal->taluka_id ?>"><?= $tal->taulkaName ?></option>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <option value="">No Taluka found</option>
                    <?php endif; ?>
                </select>
                <div class="field-placeholder">Select Taluka</div>
            </div>
        </div>

    </div>

    
       
    <!-- Permanent Address Row -->
    <div class="row gutters">
        <!-- Permanent Address -->
        <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
            <div class="field-wrapper">
                <textarea class="form-control" name="fac_PermanantAdd" id="fac_PermanantAdd" rows="3" required><?php if(!empty($data)) echo $data[0]->fac_PermanantAdd; ?></textarea>
                <div class="field-placeholder">Permanent Address<span class="text-danger">*</span></div>
            </div>
        </div>

        <!-- Permanent District -->
        <div class="col-xl-2 col-lg-2 col-md-2 col-sm-12 col-12">
            <div class="field-wrapper">
                <select class="select-single js-states" name="fkPermanantDist_id" id="fkPermanantDist_id"
                    title="Select District" data-live-search="true" required>
                    <?php if (!empty($District)): ?>
                        <?php foreach ($District as $dis): ?>
                            <option value="<?= $dis->district_id ?>"><?= $dis->district_name ?></option>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <option value="">No District found</option>
                    <?php endif; ?>
                </select>
                <div class="field-placeholder">Permanent District<span class="text-danger">*</span></div>
            </div>
        </div>

        <!-- Permanent State -->
        <div class="col-xl-2 col-lg-2 col-md-2 col-sm-12 col-12">
            <div class="field-wrapper">
                <select class="select-single js-states" name="fkPermanantState_id" id="fkPermanantState_id"
                    title="Select State" data-live-search="true" required>
                    <?php if (!empty($State)): ?>
                        <?php foreach ($State as $sta): ?>
                            <option value="<?= $sta->stateId ?>"><?= $sta->stateName ?></option>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <option value="">No State found</option>
                    <?php endif; ?>
                </select>
                <div class="field-placeholder">Permanent State<span class="text-danger">*</span></div>
            </div>
        </div>

          <!-- Permanent Taluka -->
        <div class="col-xl-2 col-lg-2 col-md-2 col-sm-12 col-12">
            <div class="field-wrapper">
                <select class="select-single js-states" name="fkCorrTaluka_id" id="fkCorrTaluka_id"
                    title="Select District" data-live-search="true" required>
                    <?php if (!empty($Taluka)): ?>
                        <?php foreach ($Taluka as $tal): ?>
                            <option value="<?= $tal->taluka_id ?>"><?= $tal->taulkaName ?></option>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <option value="">No Taluka found</option>
                    <?php endif; ?>
                </select>
                <div class="field-placeholder">Permanent Taluka</div>
            </div>
        </div>
    </div>
    
</form>


 <ul class="list-inline pull-right">
                            <li><button type="button" class="btn mb-md-0 mb-2 btn-quarternary1 prev-step">Previous</button></li>
                            <li><button type="button" class="btn mb-md-0 mb-2 btn-quarternary next-step"  name="btn_address_submit" id="btn_address_submit">Save and continue</button></li>
                
                        </ul>

                        <!-- <ul class="list-inline pull-right">
                            <li><button type="button" class="btn btn-default prev-step">Previous</button></li>
                            <li><button type="button" class="btn btn-primary next-step"  name="btn_address_submit" id="btn_address_submit">Save and continue</button></li>
                        </ul> -->
                    </div>
                    <!-- Document Information -->
                    <div class="tab-pane" role="tabpanel" id="step4">
                        <!-- <h3>Document Information</h3> -->
                       <!-- All content inside one accordion body -->
        <form  id="Form2" enctype="multipart/form-data">
               <input type="hidden" id="fk_submenuId" name="fk_submenuId" 
           value="<?= isset($subId) ? $subId : '' ?>">
            <input type="hidden" name="fac_id"  id="fac_id_doc" value="<?php if(!empty($data)) echo $data[0]->fac_id; ?>">
          <div class="row gutters">
            <!-- Aadhar Card Number -->
             <div class="col-xl-3 col-lg-3 col-md-3 col-sm-12 col-12">
                                    <div class="field-wrapper">
                                        <input type="number" class="form-control" name="fac_AadharNo" id="fac_AadharNo"
                                                value="<?php if(!empty($data)) echo $data[0]->fac_AadharNo; ?>"
                                                maxlength="12"  required>
                                        <div class="field-placeholder">Aadhar Card Number<span class="text-danger">*</span></div>
                                        <!-- <div class="valid-feedback">Looks good!</div> -->
                                    </div>
                                </div>

           <div class="col-xl-3 col-lg-3 col-md-12 col-sm-12 col-12">
  <div class="field-wrapper">
    <div class="field-placeholder">Aadhar Card<span class="text-danger">*</span></div>
 
<input type="file" name="fac_AadharPhoto" id="fac_AadharPhoto"
       class="form-control"
       accept=".pdf,.doc,.docx"
       onchange="previewcc(this)"
       <?= empty($data[0]->fac_AadharPhoto) ? 'required' : '' ?>>
 
    <div id="file_company" style="margin-top:10px;">
      <?php
      if (!empty($data[0]->fac_AadharPhoto)) {
          $file = $data[0]->fac_AadharPhoto;
          $ext = pathinfo($file, PATHINFO_EXTENSION);
          $fileUrl = base_url('' . $file);
          $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
          ?>
          <a href="<?= $fileUrl ?>" target="_blank">
            <?php if ($isImage): ?>
              <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
            <?php else: ?>
              <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
            <?php endif; ?>
          </a>
      <?php } else { ?>
          <!-- <img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" alt="No File" style="height: 100px;" /> -->
      <?php } ?>
    </div>
 
    <input type="hidden" name="hidden_fac_AadharPhoto" value="<?= !empty($data[0]->fac_AadharPhoto) ? $data[0]->fac_AadharPhoto : '' ?>">
  </div>
</div>
 
 
<script>
function previewcc(input) {
    const preview = document.getElementById('file_company'); // FIXED
    const file = input.files[0];

    if (file) {
        const fileType = file.type;
        const fileUrl = URL.createObjectURL(file);

        if (fileType.startsWith('image/')) {

            preview.innerHTML = `
                <a href="${fileUrl}" target="_blank">
                    <img src="${fileUrl}" style="height: 100px; border:1px solid #ccc; padding:2px;">
                </a>`;
        } else {

            preview.innerHTML = `
                <a href="${fileUrl}" target="_blank">
                    <img src="<?= base_url('Assets/img/Document_file.png') ?>" style="height: 100px;">
                </a>`;
        }

    } else {
        preview.innerHTML = `
            <img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" style="height: 100px;">`;
    }
}
</script>



            <!-- PAN Card Number -->
              <div class="col-xl-3 col-lg-3 col-md-3 col-sm-12 col-12">
                                    <div class="field-wrapper">
                                        <input type="text" class="form-control" name="fac_PanCardNo" id="fac_PanCardNo"
                                                value="<?php if(!empty($data)) echo $data[0]->fac_PanCardNo; ?>" required>
                                        <div class="field-placeholder">PAN Card Number<span class="text-danger">*</span></div>
                                        <!-- <div class="valid-feedback">Looks good!</div> -->
                                    </div>
                                </div>


                                <!-- PAN Card Photo -->
                                 <div class="col-xl-3 col-lg-3 col-md-12 col-sm-12 col-12">
  <div class="field-wrapper">
    <div class="field-placeholder">PAN Card<span class="text-danger">*</span></div>
 <input type="file" name="fac_PanCardPhoto" id="fac_PanCardPhoto"
       class="form-control"
       accept=".pdf,.doc,.docx"
       onchange="previewpan(this)"
       <?= empty($data[0]->fac_PanCardPhoto) ? 'required' : '' ?>>

    <!-- <input type="file" name="fac_PanCardPhoto" id="fac_PanCardPhoto" class="form-control" accept=".pdf,.doc,.docx" onchange="previewpan(this)"> -->
 
    <div id="Pan" style="margin-top:10px;">
      <?php
      if (!empty($data[0]->fac_PanCardPhoto)) {
          $file = $data[0]->fac_PanCardPhoto;
          $ext = pathinfo($file, PATHINFO_EXTENSION);
          $fileUrl = base_url('' . $file);
          $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
          ?>
          <a href="<?= $fileUrl ?>" target="_blank">
            <?php if ($isImage): ?>
              <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
            <?php else: ?>
              <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
            <?php endif; ?>
          </a>
      <?php } else { ?>
          <!-- <img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" alt="No File" style="height: 100px;" /> -->
      <?php } ?>
    </div>
 
    <input type="hidden" name="hidden_fac_PanCardPhoto" value="<?= !empty($data[0]->fac_PanCardPhoto) ? $data[0]->fac_PanCardPhoto : '' ?>">
  </div>
</div>
 
<script>
function previewpan(input) {
    const preview = document.getElementById('Pan'); // FIXED
    const file = input.files[0];

    if (file) {
        const fileType = file.type;
        const fileUrl = URL.createObjectURL(file);

        if (fileType.startsWith('image/')) {

            preview.innerHTML = `
                <a href="${fileUrl}" target="_blank">
                    <img src="${fileUrl}" style="height: 100px; border:1px solid #ccc; padding:2px;">
                </a>`;
        } else {

            preview.innerHTML = `
                <a href="${fileUrl}" target="_blank">
                    <img src="<?= base_url('Assets/img/Document_file.png') ?>" style="height: 100px;">
                </a>`;
        }

    } else {
        preview.innerHTML = `
            <img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" style="height: 100px;">`;
    }
}
</script>
                                
<!-- SSC Marksheet -->
 <div class="col-xl-3 col-lg-3 col-md-12 col-sm-12 col-12">
  <div class="field-wrapper">
    <div class="field-placeholder">SSC Marksheet<span class="text-danger">*</span></div>
 <input type="file" name="Doc1" id="Doc1"
       class="form-control"
       accept=".pdf,.doc,.docx"
       onchange="previewssc(this)"
       <?= empty($data[0]->Doc1) ? 'required' : '' ?>>

    <!-- <input type="file" name="Doc1" id="Doc1" class="form-control" accept=".pdf,.doc,.docx" onchange="previewssc(this)"> -->
 
    <div id="ssc" style="margin-top:10px;">
      <?php
      if (!empty($data[0]->Doc1)) {
          $file = $data[0]->Doc1;
          $ext = pathinfo($file, PATHINFO_EXTENSION);
          $fileUrl = base_url('' . $file);
          $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
          ?>
          <a href="<?= $fileUrl ?>" target="_blank">
            <?php if ($isImage): ?>
              <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
            <?php else: ?>
              <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
            <?php endif; ?>
          </a>
      <?php } else { ?>
          <!-- <img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" alt="No File" style="height: 100px;" /> -->
      <?php } ?>
    </div>
 
    <input type="hidden" name="hidden_Doc1" value="<?= !empty($data[0]->Doc1) ? $data[0]->Doc1 : '' ?>">
  </div>
</div>
 
 
<script>
 
 
function previewssc(input) {
    const preview = document.getElementById('ssc');
    const file = input.files[0];
 
    if (file) {
        const fileType = file.type;
        const fileUrl = URL.createObjectURL(file);
 
        if (fileType.startsWith('image/')) {
            // Agar image hai to image preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="${fileUrl}" style="height: 100px; border:1px solid #ccc; padding:2px;">
                                 </a>`;
        } else {
            // Agar pdf/doc hai to document icon preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="<?= base_url('Assets/img/Document_file.png') ?>" style="height: 100px;">
                                 </a>`;
        }
 
    } else {
        // Agar koi file select nahi hai
        preview.innerHTML = `<img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" style="height: 100px;">`;
    }
}
 
</script>


                                
<!-- SSC Certificate -->
 <div class="col-xl-3 col-lg-3 col-md-12 col-sm-12 col-12">
  <div class="field-wrapper">
    <div class="field-placeholder">SSC Certificate<span class="text-danger">*</span></div>
 <input type="file" name="SSCCer" id="SSCCer"
       class="form-control"
       accept=".pdf,.doc,.docx"
       onchange="previewssccer(this)"
       <?= empty($data[0]->SSCCer) ? 'required' : '' ?>>

    <!-- <input type="file" name="Doc1" id="Doc1" class="form-control" accept=".pdf,.doc,.docx" onchange="previewssc(this)"> -->
 
    <div id="SSCCer_preview" style="margin-top:10px;">
      <?php
      if (!empty($data[0]->SSCCer)) {
          $file = $data[0]->SSCCer;
          $ext = pathinfo($file, PATHINFO_EXTENSION);
          $fileUrl = base_url('' . $file);
          $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
          ?>
          <a href="<?= $fileUrl ?>" target="_blank">
            <?php if ($isImage): ?>
              <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
            <?php else: ?>
              <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
            <?php endif; ?>
          </a>
      <?php } else { ?>
          <!-- <img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" alt="No File" style="height: 100px;" /> -->
      <?php } ?>
    </div>
 
    <input type="hidden" name="hidden_SSCCer" value="<?= !empty($data[0]->SSCCer) ? $data[0]->SSCCer : '' ?>">
  </div>
</div>
 
 
<script>
 
 
function previewssccer(input) {
    const preview = document.getElementById('SSCCer_preview');
    const file = input.files[0];
 
    if (file) {
        const fileType = file.type;
        const fileUrl = URL.createObjectURL(file);
 
        if (fileType.startsWith('image/')) {
            // Agar image hai to image preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="${fileUrl}" style="height: 100px; border:1px solid #ccc; padding:2px;">
                                 </a>`;
        } else {
            // Agar pdf/doc hai to document icon preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="<?= base_url('Assets/img/Document_file.png') ?>" style="height: 100px;">
                                 </a>`;
        }
 
    } else {
        // Agar koi file select nahi hai
        preview.innerHTML = `<img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" style="height: 100px;">`;
    }
}
 
</script>

<!-- Diploma /HSC -->
<div class="col-xl-3 col-lg-3 col-md-12 col-sm-12 col-12">
  <div class="field-wrapper">
    <div class="field-placeholder">Diploma/HSC Marksheet<span class="text-danger">*</span></div>
 <input type="file" name="Doc2" id="Doc2"
       class="form-control"
       accept=".pdf,.doc,.docx"
       onchange="previewdiploma(this)"
       <?= empty($data[0]->Doc2) ? 'required' : '' ?>>

    <!-- <input type="file" name="Doc2" id="Doc2" class="form-control" accept=".pdf,.doc,.docx" onchange="previewdiploma(this)"> -->
 
    <div id="diploma" style="margin-top:10px;">
      <?php
      if (!empty($data[0]->Doc2)) {
          $file = $data[0]->Doc2;
          $ext = pathinfo($file, PATHINFO_EXTENSION);
          $fileUrl = base_url('' . $file);
          $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
          ?>
          <a href="<?= $fileUrl ?>" target="_blank">
            <?php if ($isImage): ?>
              <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
            <?php else: ?>
              <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
            <?php endif; ?>
          </a>
      <?php } else { ?>
          <!-- <img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" alt="No File" style="height: 100px;" /> -->
      <?php } ?>
    </div>
 
    <input type="hidden" name="hidden_Doc2" value="<?= !empty($data[0]->Doc2) ? $data[0]->Doc2 : '' ?>">
  </div>
</div>
 
 
<script>
 
 
function previewdiploma(input) {
    const preview = document.getElementById('diploma');
    const file = input.files[0];
 
    if (file) {
        const fileType = file.type;
        const fileUrl = URL.createObjectURL(file);
 
        if (fileType.startsWith('image/')) {
            // Agar image hai to image preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="${fileUrl}" style="height: 100px; border:1px solid #ccc; padding:2px;">
                                 </a>`;
        } else {
            // Agar pdf/doc hai to document icon preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="<?= base_url('Assets/img/Document_file.png') ?>" style="height: 100px;">
                                 </a>`;
        }
 
    } else {
        // Agar koi file select nahi hai
        preview.innerHTML = `<img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" style="height: 100px;">`;
    }
}
 
</script>


<!-- Diploma /HSC Certificate -->
<div class="col-xl-3 col-lg-3 col-md-12 col-sm-12 col-12">
  <div class="field-wrapper">
    <div class="field-placeholder">Diploma/HSC Certificate<span class="text-danger">*</span></div>
 <input type="file" name="DiplomaHSC_Cer" id="DiplomaHSC_Cer"
       class="form-control"
       accept=".pdf,.doc,.docx"
       onchange="previewdiplomaCer(this)"
       <?= empty($data[0]->DiplomaHSC_Cer) ? 'required' : '' ?>>

    <!-- <input type="file" name="Doc2" id="Doc2" class="form-control" accept=".pdf,.doc,.docx" onchange="previewdiploma(this)"> -->
 
    <div id="diplomacer" style="margin-top:10px;">
      <?php
      if (!empty($data[0]->DiplomaHSC_Cer)) {
          $file = $data[0]->DiplomaHSC_Cer;
          $ext = pathinfo($file, PATHINFO_EXTENSION);
          $fileUrl = base_url('' . $file);
          $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
          ?>
          <a href="<?= $fileUrl ?>" target="_blank">
            <?php if ($isImage): ?>
              <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
            <?php else: ?>
              <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
            <?php endif; ?>
          </a>
      <?php } else { ?>
          <!-- <img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" alt="No File" style="height: 100px;" /> -->
      <?php } ?>
    </div>
 
    <input type="hidden" name="hidden_DiplomaHSC_Cer" value="<?= !empty($data[0]->DiplomaHSC_Cer) ? $data[0]->DiplomaHSC_Cer : '' ?>">
  </div>
</div>
 
 
<script>
 
 
function previewdiplomaCer(input) {
    const preview = document.getElementById('diplomacer');
    const file = input.files[0];
 
    if (file) {
        const fileType = file.type;
        const fileUrl = URL.createObjectURL(file);
 
        if (fileType.startsWith('image/')) {
            // Agar image hai to image preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="${fileUrl}" style="height: 100px; border:1px solid #ccc; padding:2px;">
                                 </a>`;
        } else {
            // Agar pdf/doc hai to document icon preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="<?= base_url('Assets/img/Document_file.png') ?>" style="height: 100px;">
                                 </a>`;
        }
 
    } else {
        // Agar koi file select nahi hai
        preview.innerHTML = `<img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" style="height: 100px;">`;
    }
}
 
</script>
                                <!-- <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-4">
    
    <div class="field-wrapper">
        <div class="input-group">
            <input type="file" class="form-control" name="Doc2" id="Doc2" required>
            <button class="btn btn-outline-primary" type="button">Document-2</button>
        </div>
        <?php if (!empty($data[0]->Doc2)) { ?>
            <a href="<?= base_url(); ?>upload/<?= $data[0]->Doc2; ?>" target="_blank">
                <img src="<?= base_url(); ?>upload/<?= $data[0]->Doc2; ?>" id="doc2_img_preview"
                     class="img-thumbnail" style="height: 86px; margin: 10px 32px;">
            </a>
        <?php } else { ?>
            <img src="" id="doc2_img_preview" class="img-thumbnail"
                 style="height: 86px; margin: 10px 32px; display: none;">
        <?php } ?>
        <input type="hidden" name="hidden_doc2" value="<?= !empty($data[0]->Doc2) ? $data[0]->Doc2 : ''; ?>">
    </div>
</div> -->


 <!-- BE BSC B.Tech-->
      <div class="col-xl-3 col-lg-3 col-md-12 col-sm-12 col-12">
  <div class="field-wrapper">
    <div class="field-placeholder">BE/BSC/B.Tech Marksheet<span class="text-danger">*</span></div>
 <input type="file" name="Doc3" id="Doc3"
       class="form-control"
       accept=".pdf,.doc,.docx"
       onchange="previewbe(this)"
       <?= empty($data[0]->Doc3) ? 'required' : '' ?>>

    <!-- <input type="file" name="Doc3" id="Doc3" class="form-control" accept=".pdf,.doc,.docx" onchange="previewbe(this)"> -->
 
    <div id="be" style="margin-top:10px;">
      <?php
      if (!empty($data[0]->Doc3)) {
          $file = $data[0]->Doc3;
          $ext = pathinfo($file, PATHINFO_EXTENSION);
          $fileUrl = base_url('' . $file);
          $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
          ?>
          <a href="<?= $fileUrl ?>" target="_blank">
            <?php if ($isImage): ?>
              <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
            <?php else: ?>
              <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
            <?php endif; ?>
          </a>
      <?php } else { ?>
          <!-- <img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" alt="No File" style="height: 100px;" /> -->
      <?php } ?>
    </div>
 
    <input type="hidden" name="hidden_Doc3" value="<?= !empty($data[0]->Doc3) ? $data[0]->Doc3 : '' ?>">
  </div>
</div>
 
 
<script>
 
 
function previewbe(input) {
    const preview = document.getElementById('be');
    const file = input.files[0];
 
    if (file) {
        const fileType = file.type;
        const fileUrl = URL.createObjectURL(file);
 
        if (fileType.startsWith('image/')) {
            // Agar image hai to image preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="${fileUrl}" style="height: 100px; border:1px solid #ccc; padding:2px;">
                                 </a>`;
        } else {
            // Agar pdf/doc hai to document icon preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="<?= base_url('Assets/img/Document_file.png') ?>" style="height: 100px;">
                                 </a>`;
        }
 
    } else {
        // Agar koi file select nahi hai
        preview.innerHTML = `<img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" style="height: 100px;">`;
    }
}
 
</script>


<!-- BE/BSC/B.Tech Certificate -->
<div class="col-xl-3 col-lg-3 col-md-12 col-sm-12 col-12">
  <div class="field-wrapper">
    <div class="field-placeholder">BE/BSC/B.Tech Certificate<span class="text-danger">*</span></div>
 <input type="file" name="BECer" id="BECer"
       class="form-control"
       accept=".pdf,.doc,.docx"
       onchange="previewbecer(this)"
       <?= empty($data[0]->BECer) ? 'required' : '' ?>>

    <!-- <input type="file" name="Doc2" id="Doc2" class="form-control" accept=".pdf,.doc,.docx" onchange="previewdiploma(this)"> -->
 
    <div id="becer" style="margin-top:10px;">
      <?php
      if (!empty($data[0]->BECer)) {
          $file = $data[0]->BECer;
          $ext = pathinfo($file, PATHINFO_EXTENSION);
          $fileUrl = base_url('' . $file);
          $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
          ?>
          <a href="<?= $fileUrl ?>" target="_blank">
            <?php if ($isImage): ?>
              <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
            <?php else: ?>
              <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
            <?php endif; ?>
          </a>
      <?php } else { ?>
          <!-- <img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" alt="No File" style="height: 100px;" /> -->
      <?php } ?>
    </div>
 
    <input type="hidden" name="hidden_BECer" value="<?= !empty($data[0]->BECer) ? $data[0]->BECer : '' ?>">
  </div>
</div>
 
 
<script>
 
 
function previewbecer(input) {
    const preview = document.getElementById('becer');
    const file = input.files[0];
 
    if (file) {
        const fileType = file.type;
        const fileUrl = URL.createObjectURL(file);
 
        if (fileType.startsWith('image/')) {
            // Agar image hai to image preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="${fileUrl}" style="height: 100px; border:1px solid #ccc; padding:2px;">
                                 </a>`;
        } else {
            // Agar pdf/doc hai to document icon preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="<?= base_url('Assets/img/Document_file.png') ?>" style="height: 100px;">
                                 </a>`;
        }
 
    } else {
        // Agar koi file select nahi hai
        preview.innerHTML = `<img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" style="height: 100px;">`;
    }
}
 
</script>


            <!-- ME/MSC/M.Tech Marksheet -->
                <div class="col-xl-3 col-lg-3 col-md-12 col-sm-12 col-12">
  <div class="field-wrapper">
    <div class="field-placeholder">ME/MSC/M.Tech Marksheet<span class="text-danger">*</span></div>
 <input type="file" name="fac_CasteValPhoto" id="fac_CasteValPhoto"
       class="form-control"
       accept=".pdf,.doc,.docx"
       onchange="previewME(this)"
       <?= empty($data[0]->fac_CasteValPhoto) ? 'required' : '' ?>>

    <!-- <input type="file" name="fac_CasteValPhoto" id="fac_CasteValPhoto" class="form-control" accept=".pdf,.doc,.docx" onchange="previewME(this)"> -->
 
    <div id="ME" style="margin-top:10px;">
      <?php
      if (!empty($data[0]->fac_CasteValPhoto)) {
          $file = $data[0]->fac_CasteValPhoto;
          $ext = pathinfo($file, PATHINFO_EXTENSION);
          $fileUrl = base_url('' . $file);
          $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
          ?>
          <a href="<?= $fileUrl ?>" target="_blank">
            <?php if ($isImage): ?>
              <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
            <?php else: ?>
              <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
            <?php endif; ?>
          </a>
      <?php } else { ?>
          <!-- <img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" alt="No File" style="height: 100px;" /> -->
      <?php } ?>
    </div>
 
    <input type="hidden" name="hidden_fac_CasteValPhoto" value="<?= !empty($data[0]->fac_CasteValPhoto) ? $data[0]->fac_CasteValPhoto : '' ?>">
  </div>
</div>
 
 
<script>
 
 
function previewME(input) {
    const preview = document.getElementById('ME');
    const file = input.files[0];
 
    if (file) {
        const fileType = file.type;
        const fileUrl = URL.createObjectURL(file);
 
        if (fileType.startsWith('image/')) {
            // Agar image hai to image preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="${fileUrl}" style="height: 100px; border:1px solid #ccc; padding:2px;">
                                 </a>`;
        } else {
            // Agar pdf/doc hai to document icon preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="<?= base_url('Assets/img/Document_file.png') ?>" style="height: 100px;">
                                 </a>`;
        }
 
    } else {
        // Agar koi file select nahi hai
        preview.innerHTML = `<img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" style="height: 100px;">`;
    }
}
 
</script>
        


            <!-- ME/MSC/M.Tech Certificate -->
                <div class="col-xl-3 col-lg-3 col-md-12 col-sm-12 col-12">
  <div class="field-wrapper">
    <div class="field-placeholder">ME/MSC/M.Tech Certificate<span class="text-danger">*</span></div>
 <input type="file" name="MeCer" id="MeCer"
       class="form-control"
       accept=".pdf,.doc,.docx"
       onchange="previewMECer(this)"
       <?= empty($data[0]->MeCer) ? 'required' : '' ?>>

    <!-- <input type="file" name="fac_CasteValPhoto" id="fac_CasteValPhoto" class="form-control" accept=".pdf,.doc,.docx" onchange="previewME(this)"> -->
 
    <div id="MECer" style="margin-top:10px;">
      <?php
      if (!empty($data[0]->MeCer)) {
          $file = $data[0]->MeCer;
          $ext = pathinfo($file, PATHINFO_EXTENSION);
          $fileUrl = base_url('' . $file);
          $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
          ?>
          <a href="<?= $fileUrl ?>" target="_blank">
            <?php if ($isImage): ?>
              <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
            <?php else: ?>
              <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
            <?php endif; ?>
          </a>
      <?php } else { ?>
          <!-- <img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" alt="No File" style="height: 100px;" /> -->
      <?php } ?>
    </div>
 
    <input type="hidden" name="hidden_MeCer" value="<?= !empty($data[0]->MeCer) ? $data[0]->MeCer : '' ?>">
  </div>
</div>
 
 
<script>
 
 
function previewMECer(input) {
    const preview = document.getElementById('MECer');
    const file = input.files[0];
 
    if (file) {
        const fileType = file.type;
        const fileUrl = URL.createObjectURL(file);
 
        if (fileType.startsWith('image/')) {
            // Agar image hai to image preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="${fileUrl}" style="height: 100px; border:1px solid #ccc; padding:2px;">
                                 </a>`;
        } else {
            // Agar pdf/doc hai to document icon preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="<?= base_url('Assets/img/Document_file.png') ?>" style="height: 100px;">
                                 </a>`;
        }
 
    } else {
        // Agar koi file select nahi hai
        preview.innerHTML = `<img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" style="height: 100px;">`;
    }
}
 
</script>
        
                                
 <!-- Resume-->
  <div class="col-xl-3 col-lg-3 col-md-12 col-sm-12 col-12">
  <div class="field-wrapper">
    <div class="field-placeholder">PHD Marksheet<span class="text-danger">*</span></div>
 <input type="file" name="Resume" id="Resume"
       class="form-control"
       accept=".pdf,.doc,.docx"
       onchange="previewphd(this)"
       <?= empty($data[0]->Resume) ? 'required' : '' ?>>

    <!-- <input type="file" name="Resume" id="Resume" class="form-control" accept=".pdf,.doc,.docx" onchange="previewphd(this)"> -->
 
    <div id="phd" style="margin-top:10px;">
      <?php
      if (!empty($data[0]->Resume)) {
          $file = $data[0]->Resume;
          $ext = pathinfo($file, PATHINFO_EXTENSION);
          $fileUrl = base_url('' . $file);
          $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
          ?>
          <a href="<?= $fileUrl ?>" target="_blank">
            <?php if ($isImage): ?>
              <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
            <?php else: ?>
              <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
            <?php endif; ?>
          </a>
      <?php } else { ?>
          <!-- <img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" alt="No File" style="height: 100px;" /> -->
      <?php } ?>
    </div>
 
    <input type="hidden" name="hidden_Resume" value="<?= !empty($data[0]->Resume) ? $data[0]->Resume : '' ?>">
  </div>
</div>
 
 
<script>
 
 
function previewphd(input) {
    const preview = document.getElementById('phd');
    const file = input.files[0];
 
    if (file) {
        const fileType = file.type;
        const fileUrl = URL.createObjectURL(file);
 
        if (fileType.startsWith('image/')) {
            // Agar image hai to image preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="${fileUrl}" style="height: 100px; border:1px solid #ccc; padding:2px;">
                                 </a>`;
        } else {
            // Agar pdf/doc hai to document icon preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="<?= base_url('Assets/img/Document_file.png') ?>" style="height: 100px;">
                                 </a>`;
        }
 
    } else {
        // Agar koi file select nahi hai
        preview.innerHTML = `<img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" style="height: 100px;">`;
    }
}
 
</script>

<!-- PHD Certificate -->
<div class="col-xl-3 col-lg-3 col-md-12 col-sm-12 col-12">
  <div class="field-wrapper">
    <div class="field-placeholder">PHD Certificate<span class="text-danger">*</span></div>
 <input type="file" name="phdCer" id="phdCer"
       class="form-control"
       accept=".pdf,.doc,.docx"
       onchange="previewphdCer(this)"
       <?= empty($data[0]->phdCer) ? 'required' : '' ?>>

    <!-- <input type="file" name="Doc2" id="Doc2" class="form-control" accept=".pdf,.doc,.docx" onchange="previewdiploma(this)"> -->
 
    <div id="phcer" style="margin-top:10px;">
      <?php
      if (!empty($data[0]->phdCer)) {
          $file = $data[0]->phdCer;
          $ext = pathinfo($file, PATHINFO_EXTENSION);
          $fileUrl = base_url('' . $file);
          $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
          ?>
          <a href="<?= $fileUrl ?>" target="_blank">
            <?php if ($isImage): ?>
              <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
            <?php else: ?>
              <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
            <?php endif; ?>
          </a>
      <?php } else { ?>
          <!-- <img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" alt="No File" style="height: 100px;" /> -->
      <?php } ?>
    </div>
 
    <input type="hidden" name="hidden_phdCer" value="<?= !empty($data[0]->phdCer) ? $data[0]->phdCer : '' ?>">
  </div>
</div>
 
 
<script>
 
 
function previewphdCer(input) {
    const preview = document.getElementById('phcer');
    const file = input.files[0];
 
    if (file) {
        const fileType = file.type;
        const fileUrl = URL.createObjectURL(file);
 
        if (fileType.startsWith('image/')) {
            // Agar image hai to image preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="${fileUrl}" style="height: 100px; border:1px solid #ccc; padding:2px;">
                                 </a>`;
        } else {
            // Agar pdf/doc hai to document icon preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="<?= base_url('Assets/img/Document_file.png') ?>" style="height: 100px;">
                                 </a>`;
        }
 
    } else {
        // Agar koi file select nahi hai
        preview.innerHTML = `<img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" style="height: 100px;">`;
    }
}
 
</script>
  
<!-- Ration Card -->
<div class="col-xl-3 col-lg-3 col-md-12 col-sm-12 col-12">
  <div class="field-wrapper">
    <div class="field-placeholder">Ration Card<span class="text-danger">*</span></div>
 <input type="file" name="RationCard" id="RationCard"
       class="form-control"
       accept=".pdf,.doc,.docx"
       onchange="previewration(this)"
       <?= empty($data[0]->RationCard) ? 'required' : '' ?>>

    <!-- <input type="file" name="RationCard" id="RationCard" class="form-control" accept=".pdf,.doc,.docx" onchange="previewration(this)"> -->
 
    <div id="ration" style="margin-top:10px;">
      <?php
      if (!empty($data[0]->RationCard)) {
          $file = $data[0]->RationCard;
          $ext = pathinfo($file, PATHINFO_EXTENSION);
          $fileUrl = base_url('' . $file);
          $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
          ?>
          <a href="<?= $fileUrl ?>" target="_blank">
            <?php if ($isImage): ?>
              <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
            <?php else: ?>
              <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
            <?php endif; ?>
          </a>
      <?php } else { ?>
          <!-- <img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" alt="No File" style="height: 100px;" /> -->
      <?php } ?>
    </div>
 
    <input type="hidden" name="hidden_RationCard" value="<?= !empty($data[0]->RationCard) ? $data[0]->RationCard : '' ?>">
  </div>
</div>
 
 
<script>
 
 
function previewration(input) {
    const preview = document.getElementById('ration');
    const file = input.files[0];
 
    if (file) {
        const fileType = file.type;
        const fileUrl = URL.createObjectURL(file);
 
        if (fileType.startsWith('image/')) {
            // Agar image hai to image preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="${fileUrl}" style="height: 100px; border:1px solid #ccc; padding:2px;">
                                 </a>`;
        } else {
            // Agar pdf/doc hai to document icon preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="<?= base_url('Assets/img/Document_file.png') ?>" style="height: 100px;">
                                 </a>`;
        }
 
    } else {
        // Agar koi file select nahi hai
        preview.innerHTML = `<img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" style="height: 100px;">`;
    }
}
 
</script>
  	  <!--Job Application Letter  -->
<div class="col-xl-3 col-lg-3 col-md-12 col-sm-12 col-12">
  <div class="field-wrapper">
    <div class="field-placeholder">Job Application Letter<span class="text-danger">*</span></div>
 <input type="file" name="jobApply" id="jobApply"
       class="form-control"
       accept=".pdf,.doc,.docx"
       onchange="previewjob(this)"
       <?= empty($data[0]->jobApply) ? 'required' : '' ?>>

    <!-- <input type="file" name="jobApply" id="jobApply" class="form-control" accept=".pdf,.doc,.docx" onchange="previewjob(this)"> -->
 
    <div id="job" style="margin-top:10px;">
      <?php
      if (!empty($data[0]->jobApply)) {
          $file = $data[0]->jobApply;
          $ext = pathinfo($file, PATHINFO_EXTENSION);
          $fileUrl = base_url('' . $file);
          $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
          ?>
          <a href="<?= $fileUrl ?>" target="_blank">
            <?php if ($isImage): ?>
              <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
            <?php else: ?>
              <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
            <?php endif; ?>
          </a>
      <?php } else { ?>
          <!-- <img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" alt="No File" style="height: 100px;" /> -->
      <?php } ?>
    </div>
 
    <input type="hidden" name="hidden_jobApply" value="<?= !empty($data[0]->jobApply) ? $data[0]->jobApply : '' ?>">
  </div>
</div>
 
 
<script>
 
 
function previewjob(input) {
    const preview = document.getElementById('job');
    const file = input.files[0];
 
    if (file) {
        const fileType = file.type;
        const fileUrl = URL.createObjectURL(file);
 
        if (fileType.startsWith('image/')) {
            // Agar image hai to image preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="${fileUrl}" style="height: 100px; border:1px solid #ccc; padding:2px;">
                                 </a>`;
        } else {
            // Agar pdf/doc hai to document icon preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="<?= base_url('Assets/img/Document_file.png') ?>" style="height: 100px;">
                                 </a>`;
        }
 
    } else {
        // Agar koi file select nahi hai
        preview.innerHTML = `<img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" style="height: 100px;">`;
    }
}
 
</script>
<!-- Bank Passbook Xerox -->
<div class="col-xl-3 col-lg-3 col-md-12 col-sm-12 col-12">
  <div class="field-wrapper">
    <div class="field-placeholder">Bank Passbook Xerox<span class="text-danger">*</span></div>
 <input type="file" name="BankPass" id="BankPass"
       class="form-control"
       accept=".pdf,.doc,.docx"
       onchange="previewbank(this)"
       <?= empty($data[0]->BankPass) ? 'required' : '' ?>>

    <!-- <input type="file" name="BankPass" id="BankPass" class="form-control" accept=".pdf,.doc,.docx" onchange="previewbank(this)"> -->
 
    <div id="bank" style="margin-top:10px;">
      <?php
      if (!empty($data[0]->BankPass)) {
          $file = $data[0]->BankPass;
          $ext = pathinfo($file, PATHINFO_EXTENSION);
          $fileUrl = base_url('' . $file);
          $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
          ?>
          <a href="<?= $fileUrl ?>" target="_blank">
            <?php if ($isImage): ?>
              <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
            <?php else: ?>
              <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
            <?php endif; ?>
          </a>
      <?php } else { ?>
          <!-- <img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" alt="No File" style="height: 100px;" /> -->
      <?php } ?>
    </div>
 
    <input type="hidden" name="hidden_BankPass" value="<?= !empty($data[0]->BankPass) ? $data[0]->BankPass : '' ?>">
  </div>
</div>
 
 
<script>
 
 
function previewbank(input) {
    const preview = document.getElementById('bank');
    const file = input.files[0];
 
    if (file) {
        const fileType = file.type;
        const fileUrl = URL.createObjectURL(file);
 
        if (fileType.startsWith('image/')) {
            // Agar image hai to image preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="${fileUrl}" style="height: 100px; border:1px solid #ccc; padding:2px;">
                                 </a>`;
        } else {
            // Agar pdf/doc hai to document icon preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="<?= base_url('Assets/img/Document_file.png') ?>" style="height: 100px;">
                                 </a>`;
        }
 
    } else {
        // Agar koi file select nahi hai
        preview.innerHTML = `<img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" style="height: 100px;">`;
    }
}
 
</script>
<!-- Gazzette  -->
<div class="col-xl-3 col-lg-3 col-md-12 col-sm-12 col-12">
  <div class="field-wrapper">
    <div class="field-placeholder">Gazzette(if required)</div>
 
    <input type="file" name="Gazzette" id="Gazzette" class="form-control" accept=".pdf,.doc,.docx" onchange="previewgazz(this)">
 
    <div id="gazz" style="margin-top:10px;">
      <?php
      if (!empty($data[0]->Gazzette)) {
          $file = $data[0]->Gazzette;
          $ext = pathinfo($file, PATHINFO_EXTENSION);
          $fileUrl = base_url('' . $file);
          $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
          ?>
          <a href="<?= $fileUrl ?>" target="_blank">
            <?php if ($isImage): ?>
              <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
            <?php else: ?>
              <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
            <?php endif; ?>
          </a>
      <?php } else { ?>
          <!-- <img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" alt="No File" style="height: 100px;" /> -->
      <?php } ?>
    </div>
 
    <input type="hidden" name="hidden_Gazzette" value="<?= !empty($data[0]->Gazzette) ? $data[0]->Gazzette : '' ?>">
  </div>
</div>
 
 
<script>
 
 
function previewgazz(input) {
    const preview = document.getElementById('gazz');
    const file = input.files[0];
 
    if (file) {
        const fileType = file.type;
        const fileUrl = URL.createObjectURL(file);
 
        if (fileType.startsWith('image/')) {
            // Agar image hai to image preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="${fileUrl}" style="height: 100px; border:1px solid #ccc; padding:2px;">
                                 </a>`;
        } else {
            // Agar pdf/doc hai to document icon preview + click par new tab open
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="<?= base_url('Assets/img/Document_file.png') ?>" style="height: 100px;">
                                 </a>`;
        }
 
    } else {
        // Agar koi file select nahi hai
        preview.innerHTML = `<img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" style="height: 100px;">`;
    }
}
 
</script>
          </div>
              <!-- <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <button class="btn btn-primary" type="button" name="btn_doc_submit" id="btn_doc_submit">Submit</button>
                                    </div> -->
        </form>
 <ul class="list-inline pull-right">
                            <li><button type="button" class="btn mb-md-0 mb-2 btn-quarternary1 prev-step">Previous</button></li>
                            <li><button type="button" class="btn mb-md-0 mb-2 btn-quarternary next-step"  name="btn_doc_submit" id="btn_doc_submit">Save and continue</button></li>
                
                        </ul>

                    </div>


                    

                  <!-- Step 5: Department Information -->


            <!-- </form> -->
        </div>
    </section>
   </div>
</div>
                                    </div>		                    
 <!-- end  -->
									
			</div>
								<!-- Card end -->

		</div>
	</div>
						<!-- Row end -->

</div>
					<!-- Content wrapper end -->

					<script  src="<?php echo base_url();?>Assets/js/jquery.min.js"></script>          
 
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
 
<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>
 
<script src="<?php echo base_url();?>Assets/js/CreateJs/admin/Faculty.js"></script>
<script>
    // ✅ ADD THIS LINE AT THE VERY TOP
var baseURL = '<?= base_url() ?>';

$(document).ready(function() {
    $(".toggle-password").click(function() {
        var input = $($(this).attr("toggle"));
        var icon = $(this);

        // Toggle input type
        if (input.attr("type") === "password") {
            input.attr("type", "text");
            icon.removeClass("fa-eye").addClass("fa-eye-slash");
        } else {
            input.attr("type", "password");
            icon.removeClass("fa-eye-slash").addClass("fa-eye");
        }
    });
});

var qualificationTypingTimer;
var qualificationCurrentFocus = -1;

$(document).ready(function() {
    
    // ✨ Qualification Typeahead - Keyup Event
    $("#fkQualify_id").on('keyup', function(e) {
        // Don't trigger on arrow keys or enter
        if (e.keyCode === 38 || e.keyCode === 40 || e.keyCode === 13) {
            return;
        }

        clearTimeout(qualificationTypingTimer);
        
        const searchTerm = $(this).val().trim();

        // Hide dropdown if search term is empty
        if (searchTerm.length === 0) {
            $('#qualification_typeahead_dropdown').removeClass('show').html('');
            return;
        }

        // Show dropdown for 1+ characters
        if (searchTerm.length >= 1) {
            qualificationTypingTimer = setTimeout(function() {
                searchQualifications(searchTerm);
            }, typingInterval); // Reuse existing typingInterval variable
        }
    });

    // Search Qualifications from Database
    function searchQualifications(search) {
        $.ajax({
            url: baseURL + 'admin/Faculty/searchQualifications',
            type: 'POST',
            data: { search: search },
            dataType: 'json',
            beforeSend: function() {
                $('#qualification_typeahead_dropdown')
                    .html('<div class="typeahead-no-results"><i class="fa fa-spinner fa-spin"></i> Searching...</div>')
                    .addClass('show');
            },
            success: function(response) {
                if (response.success && response.data.length > 0) {
                    let html = '';
                    
                    $.each(response.data, function(i, item) {
                        // Assuming your database returns 'Qualification' column
                        html += `
                            <div class="typeahead-item" data-qualification="${item.Qualification}">
                                <span class="name">${item.Qualification}</span>
                            </div>
                        `;
                    });
                    
                    $('#qualification_typeahead_dropdown').html(html).addClass('show');
                } else {
                    $('#qualification_typeahead_dropdown')
                        .html('<div class="typeahead-no-results">No matching qualifications found. Type to create new.</div>')
                        .addClass('show');
                }
            },
            error: function(xhr, status, error) {
                console.error('Qualification search error:', error);
                $('#qualification_typeahead_dropdown').removeClass('show').html('');
            }
        });
    }

    // Select Qualification from Dropdown
    $(document).on('click', '#qualification_typeahead_dropdown .typeahead-item', function() {
        const selectedQualification = $(this).data('qualification');
        
        $('#fkQualify_id').val(selectedQualification);
        $('#qualification_typeahead_dropdown').removeClass('show').html('');
        
        // Move to next field (adjust selector to your next field)
        setTimeout(() => {
            // Example: $('#nextFieldId').focus();
            $('#fkQualify_id').blur();
        }, 100);
    });

    // Hide dropdown when clicking outside
    $(document).on('click', function(e) {
        if (!$(e.target).closest('#fkQualify_id').length &&
            !$(e.target).closest('#qualification_typeahead_dropdown').length) {
            $('#qualification_typeahead_dropdown').removeClass('show').html('');
        }
    });

    // Clear dropdown when field is cleared
    $("#fkQualify_id").on('input', function() {
        if ($(this).val().trim() === '') {
            $('#qualification_typeahead_dropdown').removeClass('show').html('');
        }
    });

    // ✨ Keyboard Navigation for Qualification Typeahead
    $("#fkQualify_id").on('keydown', function(e) {
        var items = $('#qualification_typeahead_dropdown .typeahead-item');
        
        if (e.keyCode === 40) { // Down arrow
            e.preventDefault();
            qualificationCurrentFocus++;
            addActiveQualification(items);
        } else if (e.keyCode === 38) { // Up arrow
            e.preventDefault();
            qualificationCurrentFocus--;
            addActiveQualification(items);
        } else if (e.keyCode === 13) { // Enter
            e.preventDefault();
            if (qualificationCurrentFocus > -1 && items.length > 0) {
                items[qualificationCurrentFocus].click();
            } else {
                // No selection, accept typed value and move to next field
                let qualification = $(this).val().trim();
                
                if (!qualification || qualification === '') {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Qualification Required',
                        text: 'Please enter Qualification!',
                        timer: 2000
                    });
                    return;
                }
                
                $('#qualification_typeahead_dropdown').removeClass('show').html('');
                // Move to next field - update this selector
                // Example: $('#nextFieldId').focus();
            }
        } else if (e.keyCode === 27) { // Escape
            $('#qualification_typeahead_dropdown').removeClass('show').html('');
            qualificationCurrentFocus = -1;
        }
    });

    function addActiveQualification(items) {
        if (!items || items.length === 0) return false;
        removeActiveQualification(items);
        
        if (qualificationCurrentFocus >= items.length) qualificationCurrentFocus = 0;
        if (qualificationCurrentFocus < 0) qualificationCurrentFocus = items.length - 1;
        
        $(items[qualificationCurrentFocus]).addClass('active');
        items[qualificationCurrentFocus].scrollIntoView({ block: 'nearest' });
    }

    function removeActiveQualification(items) {
        $(items).removeClass('active');
    }
});
</script>
<script>
console.log('Script loaded at:', new Date().toISOString());
// ✅ ADD THESE LINES HERE
var qualificationTypingTimer;
var typingInterval = 400; // ADD THIS LINE
var qualificationCurrentFocus = -1;

$(document).ready(function() {
    console.log('=== Document Ready ===');
    console.log('jQuery version:', $.fn.jquery);
    
    // Check if elements exist
    console.log('teaching_type exists:', $('#teaching_type').length);
    console.log('fktypeDesgnation exists:', $('#fktypeDesgnation').length);
    
    // Check which plugin is available
    console.log('selectpicker available:', typeof $('#fktypeDesgnation').selectpicker);
    console.log('select2 available:', typeof $('#fktypeDesgnation').select2);
    
    // Define designation options
    const designationOptions = {
        'Teaching': [
            { value: 'Assistant Professor', text: 'Assistant Professor' },
            { value: 'Associate Professor Working', text: 'Associate Professor Working' },
            { value: 'Professor', text: 'Professor' }
        ],
        'Non-Teaching': [
            { value: 'Clerk', text: 'Clerk' },
            { value: 'Technical Assistant', text: 'Technical Assistant' },
            { value: 'Librarian', text: 'Librarian' },
            { value: 'TPO', text: 'TPO' },
            { value: 'Instructor', text: 'Instructor' },
            { value: 'Lab Attendant', text: 'Lab Attendant' },
            { value: 'Office Section', text: 'Office Section' },
            { value: 'Examination Department', text: 'Examination Department' },
            { value: 'Library Section', text: 'Library Section' },
              { value: 'Rector', text: 'Rector' },
            { value: 'Training and Placement', text: 'Training and Placement' },
            { value: 'Peon', text: 'Peon' },
            { value: 'Driver', text: 'Driver' }
        
        ]
    };
    
    // Function to populate designation dropdown
    function populateDesignations(type, selectedValue) {
        console.log('=== populateDesignations called ===');
        console.log('Type:', type);
        console.log('Selected Value:', selectedValue);
        
        const $designationSelect = $('#fktypeDesgnation');
        
        if ($designationSelect.length === 0) {
            console.error('Designation select not found!');
            return;
        }
        
        // Destroy any existing plugin first
        if (typeof $designationSelect.selectpicker === 'function') {
            try {
                $designationSelect.selectpicker('destroy');
                console.log('Destroyed selectpicker');
            } catch(e) {
                console.log('Error destroying selectpicker:', e);
            }
        }
        
        if (typeof $designationSelect.select2 === 'function') {
            try {
                $designationSelect.select2('destroy');
                console.log('Destroyed select2');
            } catch(e) {
                console.log('Error destroying select2:', e);
            }
        }
        
        // Clear and add default option
        $designationSelect.empty();
        $designationSelect.append('<option value="">Select Designation</option>');
        console.log('Cleared select and added default option');
        
        // Add options based on type
        if (type && designationOptions[type]) {
            console.log('Adding options for:', type);
            
            $.each(designationOptions[type], function(index, item) {
                const option = $('<option></option>')
                    .attr('value', item.value)
                    .text(item.text);
                    
                if (item.value === selectedValue) {
                    option.prop('selected', true);
                }
                
                $designationSelect.append(option);
                console.log('Added option:', item.text);
            });
            
            console.log('Total options now:', $designationSelect.find('option').length);
        } else {
            console.log('No options to add for type:', type);
        }
        
        // Reinitialize plugin
        setTimeout(function() {
            if (typeof $designationSelect.selectpicker === 'function') {
                try {
                    $designationSelect.selectpicker({
                        liveSearch: true,
                        style: 'btn-default'
                    });
                    console.log('Reinitialized selectpicker');
                } catch(e) {
                    console.error('Error initializing selectpicker:', e);
                }
            }
            
            if (typeof $designationSelect.select2 === 'function') {
                try {
                    $designationSelect.select2({
                        placeholder: 'Select Designation',
                        allowClear: true
                    });
                    console.log('Reinitialized select2');
                } catch(e) {
                    console.error('Error initializing select2:', e);
                }
            }
            
            // Manual trigger
            $designationSelect.trigger('change');
            console.log('Triggered change event');
        }, 100);
    }
    
    // Handle teaching type change
    $('#teaching_type').on('change', function() {
        const selectedType = $(this).val();
        console.log('=== Teaching type changed ===');
        console.log('New value:', selectedType);
        
        if (selectedType) {
            populateDesignations(selectedType, '');
        } else {
            console.log('No type selected, clearing designations');
            $('#fktypeDesgnation').empty().append('<option value="">Select Designation</option>');
        }
    });
    
    // Also handle if using selectpicker/select2 change event
    if (typeof $('#teaching_type').selectpicker === 'function') {
        $('#teaching_type').on('changed.bs.select', function() {
            const selectedType = $(this).val();
            console.log('Selectpicker changed event:', selectedType);
            if (selectedType) {
                populateDesignations(selectedType, '');
            }
        });
    }
    
    if (typeof $('#teaching_type').select2 === 'function') {
        $('#teaching_type').on('select2:select', function() {
            const selectedType = $(this).val();
            console.log('Select2 changed event:', selectedType);
            if (selectedType) {
                populateDesignations(selectedType, '');
            }
        });
    }
    
    // Initialize on page load
    setTimeout(function() {
        console.log('=== Initialization after delay ===');
        const currentType = $('#teaching_type').val();
        console.log('Current teaching type value:', currentType);
        
        <?php if (!empty($data) && !empty($data[0]->teaching_type)): ?>
            const teachingType = '<?= $data[0]->teaching_type ?>';
            const typeDesignation = '<?= !empty($data[0]->fktypeDesgnation) ? $data[0]->fktypeDesgnation : '' ?>';
            console.log('Editing mode - Type:', teachingType, 'Designation:', typeDesignation);
            populateDesignations(teachingType, typeDesignation);
        <?php else: ?>
            if (currentType) {
                console.log('New form with type already selected');
                populateDesignations(currentType, '');
            } else {
                console.log('New form, no type selected yet');
            }
        <?php endif; ?>
    }, 800);
    
    console.log('=== Script initialization complete ===');
});
</script>

<!-- JavaScript for Experience Management -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    let experienceArray = [];
    let tempFileData = null; // Store temporary file data
    
    // Preview file on selection
    document.getElementById('exp_letter_temp').addEventListener('change', function(e) {
        const file = e.target.files[0];
        const previewDiv = document.getElementById('exp_preview_temp');
        const previewImg = document.getElementById('exp_preview_img');
        const previewLink = document.getElementById('exp_preview_link');
        
        if (file) {
            const fileType = file.type;
            const fileUrl = URL.createObjectURL(file);
            
            // Read file as base64 for storage
            const reader = new FileReader();
            reader.onload = function(event) {
                tempFileData = {
                    name: file.name,
                    type: fileType,
                    data: event.target.result
                };
            };
            reader.readAsDataURL(file);
            
            // Show preview
            previewLink.href = fileUrl;
            
            if (fileType.startsWith('image/')) {
                previewImg.src = fileUrl;
            } else {
                previewImg.src = '<?= base_url("Assets/img/Document_file.png") ?>';
            }
            
            previewDiv.style.display = 'block';
        } else {
            previewDiv.style.display = 'none';
            tempFileData = null;
        }
    });
    
    // Add Experience Button Click
    document.getElementById('add_experience_btn').addEventListener('click', function() {
        // Get input values
        const jobDetails = document.getElementById('job_details_temp').value.trim();
        const companyName = document.getElementById('company_name_temp').value.trim();
        const jobType = document.getElementById('job_type_temp').value.trim();
        const startDate = document.getElementById('start_date_temp').value;
        const endDate = document.getElementById('end_date_temp').value;
        
        // Validation
        if (!jobDetails || !companyName || !jobType || !startDate || !endDate) {
            Swal.fire({
                icon: 'warning',
                title: 'Validation Error',
                text: 'Please fill all experience fields',
                timer: 2000
            });
            return;
        }
        
        // Check if end date is after start date
        if (new Date(endDate) < new Date(startDate)) {
            Swal.fire({
                icon: 'error',
                title: 'Invalid Date',
                text: 'End date must be after start date',
                timer: 2000
            });
            return;
        }
        
        // Check if file is uploaded
        if (!tempFileData) {
            Swal.fire({
                icon: 'warning',
                title: 'File Required',
                text: 'Please upload experience letter',
                timer: 2000
            });
            return;
        }
        
        // Create experience object with file
        const experience = {
            job_details: jobDetails,
            company_name: companyName,
            job_type: jobType,
            start_date: startDate,
            end_date: endDate,
            exp_letter: tempFileData  // Include file data
        };
        
        // Add to array
        experienceArray.push(experience);
        
        // Update table
        updateExperienceTable();
        
        // Clear input fields
        document.getElementById('job_details_temp').value = '';
        document.getElementById('company_name_temp').value = '';
        document.getElementById('job_type_temp').value = '';
        document.getElementById('start_date_temp').value = '';
        document.getElementById('end_date_temp').value = '';
        document.getElementById('exp_letter_temp').value = '';
        document.getElementById('exp_preview_temp').style.display = 'none';
        tempFileData = null;
        
        Swal.fire({
            icon: 'success',
            title: 'Added!',
            text: 'Experience added successfully',
            timer: 1500,
            showConfirmButton: false
        });
    });
    
    // Update Experience Table
    function updateExperienceTable() {
        const tbody = document.getElementById('experience_table_body');
        tbody.innerHTML = '';
        
        if (experienceArray.length === 0) {
            tbody.innerHTML = '<tr><td colspan="7" class="text-center">No experience added yet</td></tr>';
            document.getElementById('experience_data').value = '';
            return;
        }
        
        experienceArray.forEach((exp, index) => {
            const row = document.createElement('tr');
            
            // Generate file preview
            let filePreview = '<span class="text-muted">No file</span>';
            if (exp.exp_letter) {
                const isImage = exp.exp_letter.type.startsWith('image/');
                const iconSrc = isImage ? exp.exp_letter.data : '<?= base_url("Assets/img/Document_file.png") ?>';
                filePreview = `
                    <a href="${exp.exp_letter.data}" target="_blank" title="${exp.exp_letter.name}">
                        <img src="${iconSrc}" style="height: 50px; border:1px solid #ddd; padding:2px; cursor:pointer;" />
                    </a>
                `;
            }
            
            row.innerHTML = `
                <td>${exp.job_details}</td>
                <td>${exp.company_name}</td>
                <td>${exp.job_type}</td>
                <td>${formatDate(exp.start_date)}</td>
                <td>${formatDate(exp.end_date)}</td>
                <td class="text-center">${filePreview}</td>
                <td>
                    <button type="button" class="btn btn-sm btn-danger" onclick="removeExperience(${index})">
                        <i class="icon-trash"></i> Remove
                    </button>
                </td>
            `;
            tbody.appendChild(row);
        });
        
        // Update hidden input with JSON data
        document.getElementById('experience_data').value = JSON.stringify(experienceArray);
    }
    
    // Format date for display
    function formatDate(dateString) {
        const date = new Date(dateString);
        const options = { year: 'numeric', month: 'short', day: 'numeric' };
        return date.toLocaleDateString('en-US', options);
    }
    
    // Remove Experience (global function)
    window.removeExperience = function(index) {
        Swal.fire({
            title: 'Are you sure?',
            text: "Do you want to remove this experience?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, remove it!'
        }).then((result) => {
            if (result.isConfirmed) {
                experienceArray.splice(index, 1);
                updateExperienceTable();
                Swal.fire({
                    icon: 'success',
                    title: 'Removed!',
                    text: 'Experience has been removed.',
                    timer: 1500,
                    showConfirmButton: false
                });
            }
        });
    };
    
    // Initialize table
    updateExperienceTable();
    
    // Load existing experience data if editing
    <?php if (!empty($data) && isset($data[0]->experience_data)): ?>
        try {
            const existingData = JSON.parse('<?= addslashes($data[0]->experience_data) ?>');
            if (Array.isArray(existingData)) {
                experienceArray = existingData;
                updateExperienceTable();
            }
        } catch (e) {
            console.error('Error loading existing experience data:', e);
        }
    <?php endif; ?>
});
</script>
<script>
// Experience Typeahead Functionality
$(document).ready(function() {
    var jobDetailsTimer, companyNameTimer, jobTypeTimer;
    var typingInterval = 400;
    var currentFocus = { jobDetails: -1, companyName: -1, jobType: -1 };
    
    // ==================== Job Details Typeahead ====================
    $("#job_details_temp").on('keyup', function(e) {
        if (e.keyCode === 38 || e.keyCode === 40 || e.keyCode === 13) return;
        
        clearTimeout(jobDetailsTimer);
        const searchTerm = $(this).val().trim();
        
        if (searchTerm.length === 0) {
            $('#job_details_dropdown').removeClass('show').html('');
            return;
        }
        
        if (searchTerm.length >= 1) {
            jobDetailsTimer = setTimeout(function() {
                searchJobDetails(searchTerm);
            }, typingInterval);
        }
    });
    
    function searchJobDetails(search) {
        $.ajax({
            url: baseURL + 'admin/Faculty/searchJobDetails',
            type: 'POST',
            data: { search: search },
            dataType: 'json',
            beforeSend: function() {
                $('#job_details_dropdown')
                    .html('<div class="typeahead-no-results"><i class="fa fa-spinner fa-spin"></i> Searching...</div>')
                    .addClass('show');
            },
            success: function(response) {
                if (response.success && response.data.length > 0) {
                    let html = '';
                    $.each(response.data, function(i, item) {
                        html += `
                            <div class="typeahead-item" data-value="${item.job_details}">
                                <span class="name">${item.job_details}</span>
                            </div>
                        `;
                    });
                    $('#job_details_dropdown').html(html).addClass('show');
                } else {
                    $('#job_details_dropdown')
                        .html('<div class="typeahead-no-results">No matching job details found. Type to create new.</div>')
                        .addClass('show');
                }
            },
            error: function() {
                $('#job_details_dropdown').removeClass('show').html('');
            }
        });
    }
    
    $(document).on('click', '#job_details_dropdown .typeahead-item', function() {
        const selectedValue = $(this).data('value');
        $('#job_details_temp').val(selectedValue);
        $('#job_details_dropdown').removeClass('show').html('');
        $('#company_name_temp').focus();
    });
    
    $("#job_details_temp").on('keydown', function(e) {
        handleKeyboardNavigation(e, '#job_details_dropdown', 'jobDetails');
    });
    
    // ==================== Company Name Typeahead ====================
    $("#company_name_temp").on('keyup', function(e) {
        if (e.keyCode === 38 || e.keyCode === 40 || e.keyCode === 13) return;
        
        clearTimeout(companyNameTimer);
        const searchTerm = $(this).val().trim();
        
        if (searchTerm.length === 0) {
            $('#company_name_dropdown').removeClass('show').html('');
            return;
        }
        
        if (searchTerm.length >= 1) {
            companyNameTimer = setTimeout(function() {
                searchCompanyName(searchTerm);
            }, typingInterval);
        }
    });
    
    function searchCompanyName(search) {
        $.ajax({
            url: baseURL + 'admin/Faculty/searchCompanyName',
            type: 'POST',
            data: { search: search },
            dataType: 'json',
            beforeSend: function() {
                $('#company_name_dropdown')
                    .html('<div class="typeahead-no-results"><i class="fa fa-spinner fa-spin"></i> Searching...</div>')
                    .addClass('show');
            },
            success: function(response) {
                if (response.success && response.data.length > 0) {
                    let html = '';
                    $.each(response.data, function(i, item) {
                        html += `
                            <div class="typeahead-item" data-value="${item.company_name}">
                                <span class="name">${item.company_name}</span>
                            </div>
                        `;
                    });
                    $('#company_name_dropdown').html(html).addClass('show');
                } else {
                    $('#company_name_dropdown')
                        .html('<div class="typeahead-no-results">No matching company found. Type to create new.</div>')
                        .addClass('show');
                }
            },
            error: function() {
                $('#company_name_dropdown').removeClass('show').html('');
            }
        });
    }
    
    $(document).on('click', '#company_name_dropdown .typeahead-item', function() {
        const selectedValue = $(this).data('value');
        $('#company_name_temp').val(selectedValue);
        $('#company_name_dropdown').removeClass('show').html('');
        $('#job_type_temp').focus();
    });
    
    $("#company_name_temp").on('keydown', function(e) {
        handleKeyboardNavigation(e, '#company_name_dropdown', 'companyName');
    });
    
    // ==================== Job Type Typeahead ====================
    $("#job_type_temp").on('keyup', function(e) {
        if (e.keyCode === 38 || e.keyCode === 40 || e.keyCode === 13) return;
        
        clearTimeout(jobTypeTimer);
        const searchTerm = $(this).val().trim();
        
        if (searchTerm.length === 0) {
            $('#job_type_dropdown').removeClass('show').html('');
            return;
        }
        
        if (searchTerm.length >= 1) {
            jobTypeTimer = setTimeout(function() {
                searchJobType(searchTerm);
            }, typingInterval);
        }
    });
    
    function searchJobType(search) {
        $.ajax({
            url: baseURL + 'admin/Faculty/searchJobType',
            type: 'POST',
            data: { search: search },
            dataType: 'json',
            beforeSend: function() {
                $('#job_type_dropdown')
                    .html('<div class="typeahead-no-results"><i class="fa fa-spinner fa-spin"></i> Searching...</div>')
                    .addClass('show');
            },
            success: function(response) {
                if (response.success && response.data.length > 0) {
                    let html = '';
                    $.each(response.data, function(i, item) {
                        html += `
                            <div class="typeahead-item" data-value="${item.job_type}">
                                <span class="name">${item.job_type}</span>
                            </div>
                        `;
                    });
                    $('#job_type_dropdown').html(html).addClass('show');
                } else {
                    $('#job_type_dropdown')
                        .html('<div class="typeahead-no-results">No matching job type found. Type to create new.</div>')
                        .addClass('show');
                }
            },
            error: function() {
                $('#job_type_dropdown').removeClass('show').html('');
            }
        });
    }
    
    $(document).on('click', '#job_type_dropdown .typeahead-item', function() {
        const selectedValue = $(this).data('value');
        $('#job_type_temp').val(selectedValue);
        $('#job_type_dropdown').removeClass('show').html('');
        $('#start_date_temp').focus();
    });
    
    $("#job_type_temp").on('keydown', function(e) {
        handleKeyboardNavigation(e, '#job_type_dropdown', 'jobType');
    });
    
    // ==================== Common Keyboard Navigation ====================
    function handleKeyboardNavigation(e, dropdownId, focusKey) {
        var items = $(dropdownId + ' .typeahead-item');
        
        if (e.keyCode === 40) { // Down
            e.preventDefault();
            currentFocus[focusKey]++;
            addActive(items, focusKey);
        } else if (e.keyCode === 38) { // Up
            e.preventDefault();
            currentFocus[focusKey]--;
            addActive(items, focusKey);
        } else if (e.keyCode === 13) { // Enter
            e.preventDefault();
            if (currentFocus[focusKey] > -1 && items.length > 0) {
                items[currentFocus[focusKey]].click();
            } else {
                $(dropdownId).removeClass('show').html('');
            }
        } else if (e.keyCode === 27) { // Escape
            $(dropdownId).removeClass('show').html('');
            currentFocus[focusKey] = -1;
        }
    }
    
    function addActive(items, focusKey) {
        if (!items || items.length === 0) return false;
        removeActive(items);
        
        if (currentFocus[focusKey] >= items.length) currentFocus[focusKey] = 0;
        if (currentFocus[focusKey] < 0) currentFocus[focusKey] = items.length - 1;
        
        $(items[currentFocus[focusKey]]).addClass('active');
        items[currentFocus[focusKey]].scrollIntoView({ block: 'nearest' });
    }
    
    function removeActive(items) {
        $(items).removeClass('active');
    }
    
    // Hide dropdowns when clicking outside
    $(document).on('click', function(e) {
        if (!$(e.target).closest('.experience-wrapper').length) {
            $('.typeahead-dropdown').removeClass('show').html('');
        }
    });
    
    // Clear dropdowns when fields are cleared
    $("#job_details_temp, #company_name_temp, #job_type_temp").on('input', function() {
        if ($(this).val().trim() === '') {
            $(this).siblings('.typeahead-dropdown').removeClass('show').html('');
        }
    });
});
</script>

<script>
$(document).ready(function() {
    // Open Add Sub-Caste Modal
    $('#add_subcaste_btn').on('click', function() {
        $('#addSubCasteModal').modal('show');
        $('#new_subcaste_name').val('').focus();
    });
    
    // Save New Sub-Caste
    $('#save_subcaste_btn').on('click', function() {
        const subCasteName = $('#new_subcaste_name').val().trim();
        
        // Validation
        if (!subCasteName) {
            Swal.fire({
                icon: 'warning',
                title: 'Validation Error',
                text: 'Please enter Sub-Caste name!',
                timer: 2000
            });
            return;
        }
        
        // Show loading
        Swal.fire({
            title: 'Saving...',
            text: 'Please wait while we save the Sub-Caste',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });
        
        // AJAX request to save
        $.ajax({
            url: baseURL + 'admin/Faculty/addSubCaste',
            type: 'POST',
            data: {
                subcaste_name: subCasteName
            },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    // Close the modal
                    $('#addSubCasteModal').modal('hide');
                    
                    // Add the new option to dropdown
                    const newOption = new Option(response.data.SubCaste_name, response.data.SubCaste_id, true, true);
                    $('#fkSubCaste_id').append(newOption);
                    
                    // Refresh the selectpicker/select2
                    if (typeof $('#fkSubCaste_id').selectpicker === 'function') {
                        $('#fkSubCaste_id').selectpicker('refresh');
                    }
                    if (typeof $('#fkSubCaste_id').select2 === 'function') {
                        $('#fkSubCaste_id').trigger('change');
                    }
                    
                    // Show success message
                    Swal.fire({
                        icon: 'success',
                        title: 'Success!',
                        text: response.message,
                        timer: 2000,
                        showConfirmButton: false
                    });
                    
                    // Clear form
                    $('#addSubCasteForm')[0].reset();
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: response.message || 'Failed to save Sub-Caste',
                        timer: 3000
                    });
                }
            },
            error: function(xhr, status, error) {
                console.error('Error:', error);
                Swal.fire({
                    icon: 'error',
                    title: 'Server Error',
                    text: 'An error occurred while saving. Please try again.',
                    timer: 3000
                });
            }
        });
    });
    
    // Clear form when modal is closed
    $('#addSubCasteModal').on('hidden.bs.modal', function() {
        $('#addSubCasteForm')[0].reset();
    });
    
    // Submit on Enter key
    $('#new_subcaste_name').on('keypress', function(e) {
        if (e.which === 13) {
            e.preventDefault();
            $('#save_subcaste_btn').click();
        }
    });
});
</script>
