<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Feedback Report - <?= htmlspecialchars($master_data->feedbackforname) ?></title>
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        /* ==================== Basic Styles ==================== */
        * { 
            margin: 0;
            padding: 0;
            box-sizing: border-box; 
        }
        
        body { 
            font-family: Arial, sans-serif;
            background-color: #f5f5f5;
            padding: 20px;
        }
        
        .container {
            max-width: 1400px;
            margin: 0 auto;
            background: white;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }

        /* ==================== Buttons ==================== */
        .action-buttons {
            display: flex;
            justify-content: flex-end;
            gap: 10px;
            margin-bottom: 20px;
        }
        
        .btn {
            padding: 8px 18px;
            border: none;
            border-radius: 5px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            color: white;
            transition: all 0.3s;
        }
        
        .btn:hover {
            opacity: 0.85;
            transform: translateY(-2px);
        }
        
        .btn-print { background-color: #f44336; }
        .btn-excel { background-color: #4CAF50; }
        .btn-pdf { background-color: #2196F3; }
        .btn-home { background-color: #607D8B; }
        
        .btn i {
            font-size: 16px;
        }

        /* ==================== Header ==================== */
        .report-header {
            text-align: center;
            border-bottom: 3px solid #000;
            padding-bottom: 15px;
            margin-bottom: 30px;
        }
        
        .logo {
            width: 80px;
            height: 80px;
            margin-bottom: 10px;
        }
        
        .institute-name {
            font-size: 22px;
            font-weight: bold;
            color: #c62828;
            margin: 8px 0;
            text-transform: uppercase;
        }
        
        .sub-heading {
            font-size: 13px;
            color: #555;
            margin: 3px 0;
        }
        
        .report-title {
            font-size: 16px;
            font-weight: bold;
            margin-top: 12px;
            color: #000;
        }

        /* ==================== Table ==================== */
        .table-wrapper {
            overflow-x: auto;
            margin-top: 20px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            border: 2px solid #000;
        }
        
        thead th {
            background-color: #1976d2;
            color: white;
            padding: 12px 8px;
            text-align: center;
            border: 1px solid #0d47a1;
            font-size: 13px;
            font-weight: bold;
        }
        
        tbody td {
            padding: 10px 8px;
            border: 1px solid black;
            text-align: center;
            font-size: 12px;
        }
        
     
        
       
        
        .question-column {
            text-align: left !important;
            font-weight: 500;
        }

        /* ==================== Print Styles ==================== */
        @media print {
            /* Hide everything first */
            body * {
                visibility: hidden;
            }
            
            /* Show only print content */
            #printContent,
            #printContent * {
                visibility: visible;
            }
            
            /* Position print content at top */
            #printContent {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
            }
            
            body {
                background: white;
                padding: 0;
                margin: 0;
            }
            
            .container {
                box-shadow: none;
                padding: 5px;
                margin: 0;
            }
            
            .action-buttons {
                display: none !important;
            }
            
        .report-header {
    text-align: center;
    margin-bottom: 20px;
    border-bottom: 2px solid #000;
    padding-bottom: 10px;
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.header-left {
    display: flex;
    align-items: center;
}

.header-right {
    text-align: right;
}

.logo {
    width: 60px;
    height: 60px;
    object-fit: contain;
    margin-right: 15px;
}

.institute-name {
    color: #dc143c;
    font-size: 18px;
    font-weight: bold;
    margin: 5px 0;
    text-transform: uppercase;
}

.sub-heading {
    font-size: 11px;
    color: #000;
    margin: 3px 0;
}

.report-title {
    font-size: 14px;
    font-weight: bold;
    margin-top: 10px;
    color: #000;
    width: 100%;
    text-align: center;
}
            
            .logo {
                width: 60px;
                height: 60px;
            }
            
            table {
                border: 1px solid #000;
                page-break-inside: auto;
            }
            
            thead th {
                background-color: #1976d2 !important;
                color: white !important;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            
            tbody tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }
            
            /* Remove browser margins */
            @page {
                margin: 0;
                size: auto;
            }
        }
    </style>
</head>
<body>

<div class="container">
    
    <!-- ==================== Action Buttons (Top) ==================== -->
    <div class="action-buttons">
        <button class="btn btn-print" onclick="handlePrint()">
            <i class="fa fa-print"></i> Print
        </button>
        <button class="btn btn-excel" onclick="handleExcel()">
            <i class="fa fa-file-excel"></i> Excel
        </button>
        <button class="btn btn-pdf" onclick="handlePDF()">
            <i class="fa fa-file-pdf"></i> PDF
        </button>
        <a href="<?= base_url('home') ?>" class="btn btn-home" style="text-decoration: none;">
            <i class="fa fa-home"></i> Home
        </a>
    </div>

    <!-- ==================== Content to Print/Export ==================== -->
    <div id="printContent" style="padding:22px">
        
        <!-- Header -->
        <div class="report-header">
    <div class="header-left">
        <?php if(isset($heading_data) && !empty($heading_data->logo)): ?>
            <img src="<?= base_url(ltrim($heading_data->logo, '/')) ?>" alt="Logo" class="logo">
        <?php endif; ?>
    </div>
    
    <div class="header-right">
         <?php if(isset($heading_data)): ?>
            <div class="sub-heading"><?= htmlspecialchars($heading_data->subHead1) ?></div>
            <!--<div class="sub-heading"><?= htmlspecialchars($heading_data->head) ?></div>-->
        <?php endif; ?>
        <div class="institute-name">
            <?= htmlspecialchars($heading_data->head) ?>
        </div>
        
        <?php if(isset($heading_data)): ?>
            <div class="sub-heading"><?= htmlspecialchars($heading_data->subHead2) ?></div>
            <!--<div class="sub-heading"><?= htmlspecialchars($heading_data->head) ?></div>-->
        <?php endif; ?>
    </div>
</div>

<div class="report-title">
    <?= htmlspecialchars($master_data->feedbackforname) ?> - <?= htmlspecialchars($master_data->fini_Label) ?>
</div>

        <!-- Table -->
        <div class="table-wrapper">
            <table id="feedbackTable">
                <thead>
                    <tr>
                        <th style="width: 60px;">Sr No.</th>
                        <th style="width: 40%;">Question</th>
                        <?php foreach ($answer_options as $option): ?>
                            <?php if($option->answertypeid != 0): ?>
                                <th><?= htmlspecialchars($option->answertypename) ?></th>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $sr_no = 1;
                    foreach ($questions as $question): 
                        $has_text_answer = isset($question_stats[$question->questionid][0]);
                    ?>
                    <tr>
                        <td><?= $sr_no++ ?></td>
                        <td class="question-column"><?= htmlspecialchars($question->question_name) ?></td>
                        
                        <?php if ($has_text_answer): 
                            $colspan = 0;
                            foreach($answer_options as $o) if($o->answertypeid != 0) $colspan++;
                        ?>
                            <td colspan="<?= $colspan ?>" style="text-align:left; padding-left:10px;">
                                <?php 
                                    $CI =& get_instance();
                                    $text_results = $CI->db->select('answer')
                                        ->from('collagefeedback_formmaster')
                                        ->where(['questionid' => $question->questionid, 'answertypeid' => 0, 'url_id' => $url_id])
                                        ->get()->result();
                                    $ans_list = []; 
                                    foreach($text_results as $t) {
                                        if(!empty($t->answer)) {
                                            $ans_list[] = htmlspecialchars($t->answer);
                                        }
                                    }
                                    echo !empty($ans_list) ? implode(', ', $ans_list) : '-';
                                ?>
                            </td>
                        <?php else: ?>
                            <?php foreach ($answer_options as $option): ?>
                                <?php if($option->answertypeid != 0): ?>
                                    <td>
                                        <?= isset($question_stats[$question->questionid][$option->answertypeid]) 
                                            ? $question_stats[$question->questionid][$option->answertypeid]['count'] 
                                            : 0 ?>
                                    </td>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        
    </div><!-- End printContent -->
    
</div><!-- End container -->

<!-- ==================== JavaScript Libraries ==================== -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>

<script>
// ==================== Print Function ====================
function handlePrint() {
    window.print();
}

// ==================== Excel Export Function ====================
function handleExcel() {
    try {
        // Get the table
        const table = document.getElementById('feedbackTable');
        
        // Get header text
        const instituteName = '<?= addslashes($master_data->Institu_name) ?>';
        const subHead1 = '<?= isset($heading_data) ? addslashes($heading_data->subHead1) : "" ?>';
        const head = '<?= isset($heading_data) ? addslashes($heading_data->head) : "" ?>';
        const reportTitle = '<?= addslashes($master_data->feedbackforname) ?> - <?= addslashes($master_data->fini_Label) ?>';
        
        // Create header rows
        const headerRows = [
            [instituteName],
            [subHead1],
            [head],
            [reportTitle],
            [] // Empty row
        ];
        
        // Convert table to worksheet
        const ws = XLSX.utils.table_to_sheet(table);
        
        // Get table data
        const tableData = XLSX.utils.sheet_to_json(ws, { header: 1 });
        
        // Combine headers and table
        const finalData = [...headerRows, ...tableData];
        
        // Create new worksheet with combined data
        const finalWs = XLSX.utils.aoa_to_sheet(finalData);
        
        // Create workbook
        const wb = XLSX.utils.book_new();
        XLSX.utils.book_append_sheet(wb, finalWs, 'Feedback Report');
        
        // Generate filename
        const filename = 'Feedback_Report_' + new Date().toISOString().slice(0,10) + '.xlsx';
        
        // Download
        XLSX.writeFile(wb, filename);
        
        console.log('Excel file generated successfully');
    } catch (error) {
        console.error('Excel generation error:', error);
        alert('Error generating Excel file. Please try again.');
    }
}

// ==================== PDF Export Function ====================
function handlePDF() {
    try {
        const element = document.getElementById('printContent');
        
        const opt = {
            margin: 10,
            filename: 'Feedback_Report_' + new Date().toISOString().slice(0,10) + '.pdf',
            image: { type: 'jpeg', quality: 0.98 },
            html2canvas: { scale: 2, useCORS: true },
            jsPDF: { unit: 'mm', format: 'a4', orientation: 'landscape' }
        };
        
        html2pdf().set(opt).from(element).save();
        
        console.log('PDF generation started');
    } catch (error) {
        console.error('PDF generation error:', error);
        alert('Error generating PDF. Please try again.');
    }
}

// ==================== Document Ready ====================
$(document).ready(function() {
    console.log('Feedback Report loaded successfully');
});
</script>

</body>
</html>