<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1">
                            Download Files by Date Range
                        </div>
                    </div>

                    <div class="card-body">
                        <form id="downloadForm" method="post">
                            <div class="row gutters">
                                <!-- Start Date -->
                                <div class="col-md-5 col-12">
                                    <div class="field-wrapper">
                                        <input class="form-control" type="date" name="start_date" id="start_date" required>
                                        <div class="field-placeholder">Start Date<span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <!-- End Date -->
                                <div class="col-md-5 col-12">
                                    <div class="field-wrapper">
                                        <input class="form-control" type="date" name="end_date" id="end_date" required>
                                        <div class="field-placeholder">End Date<span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <!-- Button -->
                                <div class="col-md-2 col-12">
                                    <button class="btn btn-primary btn-sm w-100" type="button" id="btnSearch">
                                        <i class="fa-solid fa-search"></i> Search Files
                                    </button>
                                </div>
                            </div>
                        </form>

                        <!-- Preview Section -->
                        <div class="row mt-4" id="previewSection" style="display: none;">
                            <div class="col-12">
                                <div class="alert alert-success d-flex justify-content-between align-items-center">
                                    <h5 class="mb-0">
                                        <i class="fa-solid fa-file"></i> 
                                        Files Found: <span id="fileCount" class="badge bg-primary">0</span>
                                    </h5>
                                    <button class="btn btn-sm btn-danger" id="btnDownloadAll">
                                        <i class="fa-solid fa-download"></i> Download All Files
                                    </button>
                                </div>
                                
                                <div class="table-responsive">
                                    <table class="table table-bordered table-hover">
                                        <thead style="background-color: #0d40a9; color: white;">
                                            <tr>
                                                <th width="5%">Sr.No.</th>
                                                <th width="15%">Folder Name</th>
                                                <th width="30%">File Path</th>
                                                <th width="20%">File Name</th>
                                                <th width="10%">Size</th>
                                                <th width="12%">Modified Date</th>
                                                <th width="8%">Action</th>
                                            </tr>
                                        </thead>
                                        <tbody id="fileTableBody">
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- Loading Indicator -->
                        <div class="row mt-4" id="loadingIndicator" style="display: none;">
                            <div class="col-12 text-center">
                                <div class="spinner-border text-primary" role="status" style="width: 3rem; height: 3rem;">
                                    <span class="visually-hidden">Loading...</span>
                                </div>
                                <p class="mt-3 fw-bold">Processing files, please wait...</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Hidden form for POST download -->
<form id="downloadForm_hidden" method="POST" action="<?php echo base_url('admin/File_Download/download_single_file_post'); ?>" style="display:none;">
    <input type="hidden" name="file_path" id="hidden_file_path">
</form>

<script src="<?php echo base_url();?>Assets/js/jquery.min.js"></script>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
$(document).ready(function() {
    
    // Set default dates (TODAY to TODAY)
    const today = new Date();
    const todayStr = today.toISOString().split('T')[0];
    
    $('#end_date').val(todayStr);
    $('#start_date').val(todayStr);

    let filesData = [];

    // Validate date range
    function validateDates() {
        const startDate = new Date($('#start_date').val());
        const endDate = new Date($('#end_date').val());
        
        if (!$('#start_date').val() || !$('#end_date').val()) {
            Swal.fire({
                icon: 'warning',
                title: 'Missing Dates',
                text: 'Please select both start and end dates!'
            });
            return false;
        }
        
        if (startDate > endDate) {
            Swal.fire({
                icon: 'error',
                title: 'Invalid Date Range',
                text: 'Start date cannot be after end date!'
            });
            return false;
        }
        return true;
    }

    // Search Files
    $('#btnSearch').click(function() {
        if (!validateDates()) return;
        
        const formData = {
            start_date: $('#start_date').val(),
            end_date: $('#end_date').val()
        };

        $('#loadingIndicator').show();
        $('#previewSection').hide();

        $.ajax({
            url: '<?= base_url("admin/File_Download/get_files_list") ?>',
            type: 'POST',
            data: formData,
            dataType: 'json',
            cache: false,
            success: function(response) {
                $('#loadingIndicator').hide();
                
                if (response.status === 'success') {
                    filesData = response.files;
                    $('#fileCount').text(response.file_count);
                    $('#fileTableBody').empty();
                    
                    if (response.file_count > 0) {
                        $.each(response.files, function(index, file) {
                            let row = '<tr>';
                            row += '<td>' + (index + 1) + '</td>';
                            row += '<td><span class="badge bg-info">' + file.folder_name + '</span></td>';
                            row += '<td><small class="text-muted">' + file.path + '</small></td>';
                            row += '<td><strong>' + file.name + '</strong></td>';
                            row += '<td>' + file.size + '</td>';
                            row += '<td>' + file.modified + '</td>';
                            row += '<td>';
                            row += '<button class="btn btn-sm btn-success download-btn" data-path="' + file.path + '" data-name="' + file.name + '" title="Download">';
                            row += '<i class="fa-solid fa-download"></i>';
                            row += '</button>';
                            row += '</td>';
                            row += '</tr>';
                            
                            $('#fileTableBody').append(row);
                        });
                        
                        $('#previewSection').show();
                    }
                } else {
                    Swal.fire({
                        icon: 'warning',
                        title: 'No Files Found',
                        text: response.message
                    });
                }
            },
            error: function(xhr, status, error) {
                $('#loadingIndicator').hide();
                console.error('Error:', error);
                console.error('Response:', xhr.responseText);
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Failed to fetch files. Please check console for details.'
                });
            }
        });
    });

    // Handle individual file download using POST
    $(document).on('click', '.download-btn', function(e) {
        e.preventDefault();
        e.stopPropagation();
        
        const filePath = $(this).data('path');
        const fileName = $(this).data('name');
        
        console.log('Downloading:', fileName);
        console.log('Path:', filePath);
        
        // Use POST method to download
        $.ajax({
            url: '<?= base_url("admin/File_Download/download_single_file_post") ?>',
            type: 'POST',
            data: { file_path: filePath },
            xhrFields: {
                responseType: 'blob'
            },
            success: function(data, status, xhr) {
                // Create blob link to download
                const blob = new Blob([data]);
                const link = document.createElement('a');
                link.href = window.URL.createObjectURL(blob);
                link.download = fileName;
                link.click();
                
                Swal.fire({
                    icon: 'success',
                    title: 'Downloaded!',
                    text: fileName,
                    timer: 2000,
                    showConfirmButton: false
                });
            },
            error: function(xhr, status, error) {
                console.error('Download error:', error);
                Swal.fire({
                    icon: 'error',
                    title: 'Download Failed',
                    text: 'Could not download: ' + fileName
                });
            }
        });
    });

    // Download All Files (one by one)
    $('#btnDownloadAll').click(function() {
        if (filesData.length === 0) {
            Swal.fire({
                icon: 'warning',
                title: 'No Files',
                text: 'No files to download!'
            });
            return;
        }

        Swal.fire({
            title: 'Download All Files?',
            html: 'This will download <b>' + filesData.length + '</b> files one by one.',
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: '#28a745',
            cancelButtonColor: '#d33',
            confirmButtonText: '<i class="fa-solid fa-download"></i> Yes, Download All!'
        }).then((result) => {
            if (result.isConfirmed) {
                let downloadCount = 0;
                
                Swal.fire({
                    title: 'Downloading Files...',
                    html: 'Please wait. Downloaded: <b>0</b> / <b>' + filesData.length + '</b>',
                    allowOutsideClick: false,
                    allowEscapeKey: false,
                    showConfirmButton: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });
                
                // Download files one by one with delay
                filesData.forEach(function(file, index) {
                    setTimeout(function() {
                        $.ajax({
                            url: '<?= base_url("admin/File_Download/download_single_file_post") ?>',
                            type: 'POST',
                            data: { file_path: file.path },
                            xhrFields: {
                                responseType: 'blob'
                            },
                            success: function(data) {
                                const blob = new Blob([data]);
                                const link = document.createElement('a');
                                link.href = window.URL.createObjectURL(blob);
                                link.download = file.name;
                                link.click();
                                
                                downloadCount++;
                                
                                Swal.update({
                                    html: 'Please wait. Downloaded: <b>' + downloadCount + '</b> / <b>' + filesData.length + '</b>'
                                });
                                
                                if (downloadCount === filesData.length) {
                                    setTimeout(() => {
                                        Swal.fire({
                                            icon: 'success',
                                            title: 'Download Complete!',
                                            text: 'All ' + downloadCount + ' files have been downloaded.',
                                            timer: 3000,
                                            showConfirmButton: true
                                        });
                                    }, 1000);
                                }
                            }
                        });
                    }, index * 1500); // 1.5 second delay
                });
            }
        });
    });

    // Clear files when dates change
    $('#start_date, #end_date').change(function() {
        $('#previewSection').hide();
        filesData = [];
    });
});
</script>

<style>
.field-wrapper {
    position: relative;
    margin-bottom: 1.5rem;
}

.field-placeholder {
    position: absolute;
    top: -10px;
    left: 10px;
    background: white;
    padding: 0 5px;
    font-size: 12px;
    color: #666;
    font-weight: 500;
}

.table-responsive {
    max-height: 500px;
    overflow-y: auto;
}



.table-hover tbody tr:hover {
    background-color: #f5f5f5;
}

.gap-2 {
    gap: 10px;
}
</style>