
    <style>
        .file-upload-cell {
            position: relative;
            width: 120px;
        }
        .file-input {
            position: absolute;
            opacity: 0;
            width: 100%;
            height: 100%;
            cursor: pointer;
        }
        .file-label {
            display: inline-block;
            background: #007bff;
            color: white;
            padding: 5px 10px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 12px;
            text-align: center;
            width: 100px;
        }
        .file-label:hover {
            background: #0056b3;
        }
        .file-name {
            font-size: 10px;
            color: #666;
            margin-top: 2px;
            word-break: break-word;
        }
        .file-remove {
            color: red;
            cursor: pointer;
            font-size: 10px;
            margin-left: 5px;
        }
        .wide-th {
        width: 200px !important;  
    }
    .total-row {
    background-color: #f8f9fa;
    font-weight: bold;
    border-top: 2px solid #dee2e6;
}

.total-row td {
    padding: 12px 8px !important;
    font-size: 14px;
}

.total-amount {
    color: #28a745;
    font-size: 16px;
    font-weight: 600;
}
/* Select2 ko normal dropdown jaisa banao */
.select2-container .select2-selection--single {
    height: 38px !important;
    border: 1px solid #ced4da !important;
    border-radius: 4px !important;
}
 
.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 36px !important;
    padding-left: 12px !important;
    color: #495057 !important;
    padding: 2px;
}
 
.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 36px !important;
    right: 8px !important;
}
 
.select2-container--default .select2-selection--single .select2-selection__arrow b {
    border-color: #495057 transparent transparent transparent !important;
}
 
/* Dropdown menu styling */
.select2-dropdown {
        border: 1px solid #f89450 !important;
            border-radius: 4px !important;
            
    background-color: #edfff2 !important;
}
 
.select2-container--default .select2-results__option--highlighted[aria-selected] {
    background-color: #007bff !important;
    color: white !important;
}
 
.select2-search--dropdown .select2-search__field {
    border: 1px solid #ced4da !important;
    border-radius: 4px !important;
    padding: 6px 12px !important;
}
 
/* Focus state */
.select2-container--default.select2-container--focus .select2-selection--single {
    border-color: #80bdff !important;
    outline: 0 !important;
    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25) !important;
}

/* Select2 container width */
.select2-container {
    width: 100% !important;
}
 
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
</head>
<body>

<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1">ICT Tools  </div>
                    </div>
                    <div class="card-body">
                        <form role="form" id="Form" action="" method="post" enctype="multipart/form-data">
                        <div class="row gutters">
                            <!-- Ye line view file mein check karein -->
<input type="hidden" id="ict_id" name="ict_id" class="hiddenId" 
       value="<?php echo isset($record->ict_id) ? $record->ict_id : ''; ?>">

<!-- hidden submenuid -->
<input class="form-control" id="fk_submenuId" name="fk_submenuId" type="hidden"
                           value="<?= isset($subId) ? $subId : '' ?>"  />

                                <?php if(empty($record)): ?>  
                            <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                <label for="excel_file" class="form-label">Import Excel</label>
                                <div class="card" id="studentCard"
                                     style="height: 120px; width: 60%; cursor: pointer; padding: 10px;
                                            border: 2px dashed black; text-align: center; display: flex;
                                            flex-direction: column; justify-content: flex-start; align-items: center;
                                            position: relative; overflow: hidden;"
                                     onclick="document.getElementById('excel_file').click();">
                                    <img src="<?= base_url('Assets/img/excel.png'); ?>" id="studentImg"
                                         style="max-height: 50px; object-fit: contain; margin-bottom: 5px;">
                                    <span id="studentFileText" style="font-size: 11px; color: black; font-weight:600;">
                                        (<span class="text-danger">*</span>File extension allowed: .xls .xlsx)
                                    </span>
                                    <input type="file" accept=".xls,.xlsx" style="display: none;"
                                           class="form-control form-control-sm"
                                           id="excel_file" name="excel_file">
                                </div>
                                <?php if (!empty($mainData->excel_file)): ?>
                                    <p class="mt-2">Uploaded File: <b><?= $mainData->excel_file ?></b></p>
                                <?php endif; ?>
                                <button class="btn btn-success btn-sm m-1" type="button" id="btnShow" style="padding: px 10px;font-size: 13px;"><i class="fas fa-search"></i> Show Excel Data</button>
                            </div>

                            <div class="row">
                                <div class="col-md-12 text-end mt-3">
                                   <a href="<?= base_url('uploads/formatexcel/ICTtools.xlsx'); ?>"
                                   download
                                   style="color: #0b0a0aff; text-decoration: underline; font-weight: 600; font-size:14px;">
                                   <i class="fas fa-file-excel" style="color: green; margin-right: 6px; font-size:16px;"></i>
                                   Download Excel Format
                                   </a>
                                </div>
                            </div>
                            <?php endif; ?>

                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-3 col-12">
                                <div class="table-responsive mt-3" id="printableTable">
                                   <div class="float-end mb-2">
                                     <?php if (!empty($mainData)): ?>
                                        <button class="btn btn-danger btn-sm m-1" type="button" id="btnClearAll" style="padding: px 10px;font-size: 13px;">
                                            <i class="fas fa-times"></i> Clear All
                                        </button>
                                     <?php endif; ?>
                                   </div>

                                    <table id="leavetable" class="table custom-table">
                                        <thead style="background-color: #1273eb;">
                                            <tr>
                                                <th class=".w-auto">Sr.No.</th>
                                                <th style=" min-width:270px;">Branch/Department</th>
                                                <th style=" min-width:270px;">Faculty Name</th>
                                                
                                                
                                                
                                           
                                                <th style=" min-width:300px;">Name Of ICT Tool</th>
                                                <th style=" min-width:300px;">Link</th>
                                                <th style=" min-width:150px;">Publish Date</th>
                                                <th style=" min-width:170px;">Year</th>
                                                <th style=" min-width:300px;">Other Document</th>

                                                
                                                
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody id="tableBody">
    <?php if(isset($record)): ?>
    <tr>
        <td>1</td>
        <td>
            <select name="fkbranch_id[]" class="form-control branch-select" required>
                <option value="">Select Branch</option>
                <?php foreach($branchdata as $branch): ?>
                    <option value="<?= $branch->branch_id ?>" 
                        <?= ($branch->branch_id == $record->fkbranch_id) ? 'selected' : '' ?>>
                        <?= $branch->branch_name ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </td>
        <td>
            <select name="fkfac_id[]" class="form-control faculty-select">
                <option value="">Select Faculty</option>
                <?php foreach($facultydata as $faculty): ?>
                    <option value="<?= $faculty->fac_id ?>" 
                        <?= ($faculty->fac_id == $record->fkfac_id) ? 'selected' : '' ?>>
                        <?= $faculty->fac_Fullname ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </td>
        
        <td>
            <input type="text" name="description[]" class="form-control" 
                   value="<?= $record->Desscription ?>">
        </td>
        <td>
            <input type="text" name="ict_link[]" class="form-control" 
                   value="<?= $record->ict_link ?>">
        </td>
        <td>
            <input type="date" name="publish_date[]" class="form-control" 
                   value="<?= $record->Publish_date ?>">
        </td>
        <td>
            <select name="finicial_Year[]" class="form-control year-select">
                <option value="">Select Year</option>
                <?php foreach($yeardata as $year): ?>
                    <option value="<?= $year->finiYear_id ?>" 
                        <?= ($year->finiYear_id == $record->finicial_Year) ? 'selected' : '' ?>>
                        <?= $year->fini_Label ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </td>

        <!-- CORRECTED: Other Document Upload -->
<td>
    <div class="file-upload-cell">
        <input type="hidden" name="existing_Other_doc[]" value="<?= $record->Other_doc ?? '' ?>">
        <!-- ADD THIS CLASS: other-file -->
        <input type="file" name="Other_doc[]" class="file-input other-file" accept=".pdf,.doc,.docx" onchange="showFileName(this, 'other_name_0')">
        <label class="file-label">Choose File</label>
        <div class="file-name" id="other_name_0"></div>
    </div>
    <?php if(!empty($record->Other_doc)): ?>
        <a href="<?= base_url('uploads/ict_tools/Other_doc/' . $record->Other_doc) ?>" target="_blank">
            <span style="color: #007bff; font-size: 12px;">
                <i class="fas fa-file-pdf text-danger"></i> <?= substr($record->Other_doc, 0, 15) ?>...
            </span>
        </a>
    <?php endif; ?>
</td>





        <td><button type="button" class="btn text-danger btn-sm removeRow"><i class="fa-solid fa-trash"></i></button></td>
    </tr>
    <?php endif; ?>
</tbody>
                                    </table>
                                   <div class="float-end">
                                     <?php if(empty($record)): ?>
                                     <button type="button" class="btn btn-success btn-sm p-2 rounded-3" id="addRowBtn"style="font-size:13px; font-weight:600;"><i class="fa-solid fa-plus  bg-white p-1 rounded-circle text-success shadow-lg me-2" style=" box-shadow: 4px 6px 12px rgba(0, 0, 0, 0.5) !important;"></i>Add Row</button>
                                     <?php endif; ?>
                                   </div>
                                </div>
                            </div>

                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 mt-3">
                                <button type="button" class="btn mb-md-0 mb-2 btn-quarternary" id="submit" name="submit" type="button"><i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save</button>
                                <a class="btn mb-md-0 mb-2 btn-quarternary1" href="<?=base_url()?>admin/ICTtools/index" type="button"><i class="fa-solid fa-list"></i>&nbsp;&nbsp;List</a>
                                <button class="btn mb-md-0 mb-2 btn-quarternaryhome" type="button"  onclick="window.location.href='<?= base_url() ?>admin/ICTtools/Dashboard'" ><a href="" class="text-decoration-none text-white "><i class="fa-solid fa-home"></i>&nbsp;&nbsp;</a>Home</button><br>
                            </div>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Hidden data for JavaScript -->
<script type="text/javascript">
var branchOptions = <?= json_encode($branchdata ?? []) ?>;
var facultyOptions = <?= json_encode($facultydata ?? []) ?>;
var yearOptions = <?= json_encode($yeardata ?? []) ?>;
</script>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- Add Select2 JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>

<script>
$(document).ready(function() {
    $(document).on('select2:open', () => {
        setTimeout(() => {
            document.querySelector('.select2-search__field').focus();
        }, 0);
    });
});
</script>


<script>
$(document).ready(function () {
    // Select2 focus functionality
    $(document).on('select2:open', () => {
        setTimeout(() => {
            document.querySelector('.select2-search__field').focus();
        }, 0);
    });

    // Initialize Select2 for all dropdowns
    function initializeSelect2() {
        $('.select2-dropdown').select2({
            placeholder: "Select an option",
            allowClear: false,
            width: '100%'
        });
    }

    // Page load par initialize karein
    initializeSelect2();

    let rowCount = 0;

    // Show one empty row on page load if no data exists
    if ($("#tableBody tr").length === 0) {
        addRow();
    }

    // Add Row Function with support for new entries
    function addRow(
        branch_id = "",
        branch_name = "",
        fac_id = "",
        faculty_name = "",
        description = "",
        ict_link = "",
        publish_date = "",
        finicial_Year = "",
        year_name = ""
    ) {
        rowCount++;
        
        // Build branch dropdown
        let branchDropdown = '<option value="">Select Branch</option>';
        if (typeof branchOptions !== 'undefined' && branchOptions.length > 0) {
            branchOptions.forEach(function(branch) {
                let selected = (branch.branch_id == branch_id) ? 'selected' : '';
                branchDropdown += `<option value="${branch.branch_id}" ${selected}>${branch.branch_name}</option>`;
            });
        }
        // Add new branch option if not found
        if (branch_name && !branch_id) {
            branchDropdown += `<option value="NEW::${branch_name}" selected>${branch_name}</option>`;
        }
        
        // Build faculty dropdown
        let facultyDropdown = '<option value="">Select Faculty</option>';
        if (typeof facultyOptions !== 'undefined' && facultyOptions.length > 0) {
            facultyOptions.forEach(function(faculty) {
                let selected = (faculty.fac_id == fac_id) ? 'selected' : '';
                facultyDropdown += `<option value="${faculty.fac_id}" ${selected}>${faculty.fac_Fullname}</option>`;
            });
        }
        // Add new faculty option if not found
        if (faculty_name && !fac_id) {
            facultyDropdown += `<option value="NEW::${faculty_name}" selected>${faculty_name}</option>`;
        }
        
        // Build year dropdown
        let yearDropdown = '<option value="">Select Year</option>';
        if (typeof yearOptions !== 'undefined' && yearOptions.length > 0) {
            yearOptions.forEach(function(year) {
                let selected = (year.finiYear_id == finicial_Year) ? 'selected' : '';
                yearDropdown += `<option value="${year.finiYear_id}" ${selected}>${year.fini_Label}</option>`;
            });
        }
        // Add new year option if not found
        if (year_name && !finicial_Year) {
            yearDropdown += `<option value="NEW::${year_name}" selected>${year_name}</option>`;
        }
        
        let newRow = `
            <tr>
                <td>${rowCount}</td>
                <td>
                    <select name="fkbranch_id[]" class="form-control select2-dropdown" required>
                        ${branchDropdown}
                    </select>
                </td>
                <td>
                    <select name="fkfac_id[]" class="form-control select2-dropdown">
                        ${facultyDropdown}
                    </select>
                </td>
                <td>
                    <input type="text" name="description[]" class="form-control" value="${description}">
                </td>
                <td>
                    <input type="text" name="ict_link[]" class="form-control" value="${ict_link}">
                </td>
                <td>
                    <input type="date" name="publish_date[]" class="form-control" value="${publish_date}">
                </td>
                <td>
                    <select name="finicial_Year[]" class="form-control select2-dropdown">
                        ${yearDropdown}
                    </select>
                </td>
                <td>
                    <div class="file-upload-cell">
                        <input type="file" name="Other_doc[]" class="file-input other-file" accept=".pdf,.doc,.docx" onchange="showFileName(this, 'other_name_${rowCount-1}')">
                        <label class="file-label">Choose File</label>
                        <div class="file-name" id="other_name_${rowCount-1}"></div>
                    </div>
                </td>
                <td>
                    <button type="button" class="btn text-danger btn-sm removeRow">
                        <i class="fa-solid fa-trash"></i>
                    </button>
                </td>
            </tr>`;
        $("#tableBody").append(newRow);
        
        // Naye dropdowns ke liye Select2 initialize karein
        initializeSelect2();
    }

    // Manual Add Row
    $("#addRowBtn").click(function () {
        addRow();
    });

    // Remove Row
    $(document).on("click", ".removeRow", function () {
        if ($("#tableBody tr").length <= 1) {
            Swal.fire("Warning", "At least one row is required!", "warning");
            return;
        }
        $(this).closest("tr").remove();
        updateSerialNumbers();
    });

    // Update serial numbers
    function updateSerialNumbers() {
        rowCount = 0;
        $("#tableBody tr").each(function () {
            rowCount++;
            $(this).find("td:first").text(rowCount);
        });
    }

    // Clear All Rows
    $("#btnClearAll").click(function () {
        Swal.fire({
            title: 'Are you sure?',
            text: 'This will clear all table data!',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, clear all!'
        }).then((result) => {
            if (result.isConfirmed) {
                $("#tableBody").empty();
                rowCount = 0;
                addRow();
                Swal.fire('Cleared!', 'All table data has been cleared.', 'success');
            }
        });
    });

    // Format Excel Date
    function formatExcelDate(dateValue) {
        if (!dateValue) return "";
        
        try {
            let date;
            
            if (dateValue instanceof Date) {
                date = dateValue;
            } 
            else if (typeof dateValue === 'number' && dateValue > 0) {
                date = new Date((dateValue - 25569) * 86400 * 1000);
            } 
            else if (typeof dateValue === 'string') {
                let cleanDate = dateValue.trim();
                
                if (cleanDate.match(/^\d{1,2}[\/\-]\d{1,2}[\/\-]\d{4}$/)) {
                    let parts = cleanDate.split(/[\/\-]/);
                    date = new Date(parts[2], parts[1] - 1, parts[0]);
                }
                else if (cleanDate.match(/^\d{4}[\/\-]\d{1,2}[\/\-]\d{1,2}$/)) {
                    date = new Date(cleanDate);
                }
                else {
                    date = new Date(cleanDate);
                }
            } 
            else {
                return "";
            }
            
            if (!isNaN(date.getTime())) {
                let year = date.getFullYear();
                let month = String(date.getMonth() + 1).padStart(2, '0');
                let day = String(date.getDate()).padStart(2, '0');
                return `${year}-${month}-${day}`;
            }
        } catch (e) {
            console.warn("Date conversion error:", e, "for value:", dateValue);
        }
        
        return "";
    }

    // Find ID by Name - Returns object with id and name
    function findBranchByName(branchName) {
        if (!branchName || typeof branchOptions === 'undefined') return { id: '', name: branchName };
        let name = branchName.toString().trim().toLowerCase();
        for (let i = 0; i < branchOptions.length; i++) {
            if (branchOptions[i].branch_name.toLowerCase() === name) {
                return { id: branchOptions[i].branch_id, name: branchOptions[i].branch_name };
            }
        }
        console.log("Branch not found in master, will be created:", branchName);
        return { id: '', name: branchName.toString().trim() };
    }

    function findFacultyByName(facultyName) {
        if (!facultyName || typeof facultyOptions === 'undefined') return { id: '', name: facultyName };
        let name = facultyName.toString().trim().toLowerCase();
        for (let i = 0; i < facultyOptions.length; i++) {
            if (facultyOptions[i].fac_Fullname.toLowerCase() === name) {
                return { id: facultyOptions[i].fac_id, name: facultyOptions[i].fac_Fullname };
            }
        }
        console.log("Faculty not found in master, will be created:", facultyName);
        return { id: '', name: facultyName.toString().trim() };
    }

    function findYearByName(yearName) {
        if (!yearName || typeof yearOptions === 'undefined') return { id: '', name: yearName };
        let name = yearName.toString().trim().toLowerCase();
        for (let i = 0; i < yearOptions.length; i++) {
            if (yearOptions[i].fini_Label.toLowerCase() === name) {
                return { id: yearOptions[i].finiYear_id, name: yearOptions[i].fini_Label };
            }
        }
        console.log("Year not found in master, will be created:", yearName);
        return { id: '', name: yearName.toString().trim() };
    }

    // Show Excel Data
    $("#btnShow").click(function () {
        if (typeof XLSX === 'undefined') {
            Swal.fire("Error", "Excel processing library not loaded. Please refresh the page.", "error");
            return;
        }

        let file = $("#excel_file")[0].files[0];
        if (!file) {
            Swal.fire("Error", "Please select an Excel file first!", "error");
            return;
        }

        if (!file.name.toLowerCase().match(/\.(xlsx|xls)$/)) {
            Swal.fire("Error", "Please select a valid Excel file (.xlsx or .xls)", "error");
            return;
        }

        let reader = new FileReader();
        reader.onload = function (e) {
            try {
                let data = e.target.result;
                let workbook = XLSX.read(data, { 
                    type: "binary",
                    cellText: false,
                    cellDates: true,
                    dateNF: 'dd/mm/yyyy'
                });
                
                let firstSheet = workbook.Sheets[workbook.SheetNames[0]];
                let jsonData = XLSX.utils.sheet_to_json(firstSheet, { 
                    header: 1,
                    defval: "",
                    blankrows: false,
                    raw: false
                });

                console.log("Excel data loaded:", jsonData);
                console.log("Total rows (including header):", jsonData.length);

                if (jsonData.length < 2) {
                    Swal.fire("Error", "Excel file must contain header row and at least one data row!", "error");
                    return;
                }

                // Clear existing rows
                $("#tableBody").empty();
                rowCount = 0;

                let rowsData = [];
                let newBranchesCount = 0;
                let newFacultiesCount = 0;
                let newYearsCount = 0;
                
                // Excel Column Mapping:
                // Column 0 (A): Branch Name
                // Column 1 (B): Faculty Name
                // Column 2 (C): Description
                // Column 3 (D): ICT Link
                // Column 4 (E): Publish Date
                // Column 5 (F): Financial Year

                for (let i = 1; i < jsonData.length; i++) {
                    let row = jsonData[i];
                    
                    if (!row || row.length < 1 || !row[0]) {
                        console.warn(`Row ${i} skipped: Empty or invalid`);
                        continue;
                    }

                    let branch_name = (row[0] || "").toString().trim();
                    let faculty_name = (row[1] || "").toString().trim();
                    let description = (row[2] || "").toString().trim();
                    let ict_link = (row[3] || "").toString().trim();
                    let publish_date = formatExcelDate(row[4]);
                    let year_name = (row[5] || "").toString().trim();

                    console.log(`Processing Row ${i}:`, {
                        branch_name, 
                        faculty_name, 
                        description, 
                        ict_link,
                        publish_date, 
                        year_name
                    });

                    // Find IDs from names (or mark as new)
                    let branch = findBranchByName(branch_name);
                    let faculty = findFacultyByName(faculty_name);
                    let year = findYearByName(year_name);

                    // Count new entries
                    if (!branch.id && branch.name) newBranchesCount++;
                    if (!faculty.id && faculty.name) newFacultiesCount++;
                    if (!year.id && year.name) newYearsCount++;

                    console.log(`Row ${i} Data:`, { branch, faculty, year });

                    rowsData.push({
                        branch_id: branch.id,
                        branch_name: branch.name,
                        fac_id: faculty.id,
                        faculty_name: faculty.name,
                        description: description,
                        ict_link: ict_link,
                        publish_date: publish_date,
                        finicial_Year: year.id,
                        year_name: year.name
                    });
                }

                console.log("Total valid rows to insert:", rowsData.length);

                if (rowsData.length === 0) {
                    Swal.fire("Warning", "No valid records found in the Excel file!", "warning");
                    addRow();
                    return;
                }

                // Add all rows to table
                rowsData.forEach((rowData) => {
                    addRow(
                        rowData.branch_id,
                        rowData.branch_name,
                        rowData.fac_id,
                        rowData.faculty_name,
                        rowData.description,
                        rowData.ict_link,
                        rowData.publish_date,
                        rowData.finicial_Year,
                        rowData.year_name
                    );
                });

            } catch (error) {
                console.error("Excel processing error:", error);
                Swal.fire("Error", "Failed to process Excel file: " + error.message, "error");
            }
        };
        
        reader.onerror = function(error) {
            console.error("File reading error:", error);
            Swal.fire("Error", "Failed to read Excel file!", "error");
        };
        
        reader.readAsBinaryString(file);
    });

    // Save Form Data
    $("#submit").click(function(e) {
        e.preventDefault();

        // Check if table has rows
        if ($("#tableBody tr").length === 0) {
            Swal.fire('Validation Error', 'Please add at least one ICT tool record!', 'error');
            return;
        }

        // Collect new entries
        let newBranches = [];
        let newFaculties = [];
        let newYears = [];

        $('select[name="fkbranch_id[]"]').each(function() {
            let val = $(this).val();
            if (val && val.startsWith('NEW::')) {
                let newName = val.replace('NEW::', '');
                if (newName && newBranches.indexOf(newName) === -1) {
                    newBranches.push(newName);
                }
            }
        });

        $('select[name="fkfac_id[]"]').each(function() {
            let val = $(this).val();
            if (val && val.startsWith('NEW::')) {
                let newName = val.replace('NEW::', '');
                if (newName && newFaculties.indexOf(newName) === -1) {
                    newFaculties.push(newName);
                }
            }
        });

        $('select[name="finicial_Year[]"]').each(function() {
            let val = $(this).val();
            if (val && val.startsWith('NEW::')) {
                let newName = val.replace('NEW::', '');
                if (newName && newYears.indexOf(newName) === -1) {
                    newYears.push(newName);
                }
            }
        });

        // Serialize form data
        let formData = new FormData($('#Form')[0]);
        
        // Add new master data
        formData.append('new_branches', JSON.stringify(newBranches));
        formData.append('new_faculties', JSON.stringify(newFaculties));
        formData.append('new_years', JSON.stringify(newYears));

        // Check if it's update or insert mode
        let ict_id = $('#ict_id').val();
        let isUpdateMode = (ict_id && ict_id.trim() !== '');
        
        console.log("ICT ID:", ict_id);
        console.log("Is Update Mode:", isUpdateMode);
        
        // Set correct URL
        let ajaxUrl = isUpdateMode 
            ? '<?= base_url() ?>admin/ICTtools/updateICTTools' 
            : '<?= base_url() ?>admin/ICTtools/insertICTTools';
        
        console.log("AJAX URL:", ajaxUrl);

        $.ajax({
            url: ajaxUrl,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function() {
                $("#submit").prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');
            },
            success: function(response) {
                console.log("Server response:", response);
                
                try {
                    let result = typeof response === 'string' ? JSON.parse(response) : response;
                    
                    if (result.status === 'success') {
                         Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: '<strong>Success!</strong>',
                        html: 'Data Submitted Successfully',
                        showConfirmButton: false,
                        timer: 2000,
                        customClass: {
                            popup: 'custom-swal-popup',
                            icon: 'custom-swal-icon',
                            title: 'custom-swal-title',
                            htmlContainer: 'custom-swal-text'
                        }
                    }).then(() => { 
                            window.location.href = '<?= base_url() ?>admin/ICTtools/index';
                        });
                    } else {
                        Swal.fire('Error!', result.message || 'Failed to save data!', 'error');
                    }
                } catch (e) {
                    console.error("JSON parse error:", e);
                    Swal.fire('Error!', 'Server returned invalid response.', 'error');
                }
            },
            error: function(xhr, status, error) {
                console.error("AJAX Error:");
                console.error("Status:", status);
                console.error("Response:", xhr.responseText);
                
                let errorMessage = 'Something went wrong!';
                if (xhr.status === 404) {
                    errorMessage = 'Controller method not found (404)';
                } else if (xhr.status === 500) {
                    errorMessage = 'Server error (500)';
                }
                Swal.fire('Error!', errorMessage, 'error');
            },
            complete: function() {
                $("#submit").prop('disabled', false).html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
            }
        });
    });

    // Helper functions
    window.showFileName = function(input, divId) {
        let fileName = input.files[0] ? input.files[0].name : '';
        $('#' + divId).html(fileName ? fileName + ' <span style="color:red;cursor:pointer" onclick="clearFile(this, \'' + divId + '\')">✕</span>' : '');
    };

    window.clearFile = function(btn, divId) {
        // Clear the display
        $('#' + divId).html('');
        
        // Clear the actual file input
        let $fileInput = $('#' + divId).closest('.file-upload-cell').find('input[type="file"]');
        if ($fileInput.length) {
            $fileInput.val('');
        }
    };
});
</script>

