<style>
    .table-spinner {
        border: 4px solid #f3f3f3;
        border-top: 4px solid #3498db;
        border-radius: 50%;
        width: 40px;
        height: 40px;
        animation: spin 1s linear infinite;
        margin: 0 auto;
    }
    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
</style>

<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1">Best Practiced Excel Import</div>
                    </div>
                    <div class="card-body">
                        <form role="form" id="Form" method="post" enctype="multipart/form-data">
                            <!-- Loader -->
                            <div id="loader" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(255, 255, 255, 0.7); z-index: 9999; text-align: center; padding-top: 20%; font-size: 20px; color: #333;">
                                <div id="loading-wrapper">
                                    <div class="spinner-border"></div>
                                    Loading...
                                </div>
                            </div>

                            <div class="row gutters">
                                <input class="form-control" id="cit_id" name="cit_id" type="hidden" value="<?= !empty($data) ? $data[0]->cit_id : '' ?>" />
                                <input class="form-control" id="fk_submenuId" name="fk_submenuId" type="hidden" value="<?= isset($subId) ? $subId : '' ?>" />

                               

                                <div class="col-md-2 m-2">
                                    <label for="excel_file" class="form-label">Choose Excel File</label>
                                    <div class="card" id="cardBox" style="height: 120px; width: 70%; cursor: pointer; padding: 10px; border: 2px dashed black; text-align: center; display: flex; flex-direction: column; justify-content: flex-start; align-items: center; position: relative; overflow: hidden;" onclick="document.getElementById('excel_file').click();">
                                        <img src="<?= base_url('Assets/img/excel.png'); ?>" id="defaultImg" style="max-height: 50px; object-fit: contain; margin-bottom: 5px;">
                                        <span id="fileText" style="font-size: 11px; color: black; font-weight:600;">
                                            (<span class="text-danger">*</span>File extension allowed: .xls .xlsx)
                                        </span>
                                        <input type="file" accept=".xls,.xlsx" style="display: none;" class="form-control form-control-sm" id="excel_file" name="excel_file">
                                    </div>
                                </div>

                                 <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                <div class="field-wrapper">
                                    <select class="select-single js-states" name="fkmainuser_id" id="fkmainuser_id" required>
                                                <option value="">Select Applicants</option>
                                                <?php foreach($mainuserdata as $value): ?>
                                                    <option value="<?= $value->mainuser_id ?>" <?= (!empty($data[0]->fkmainuser_id) && $data[0]->fkmainuser_id == $value->mainuser_id) ? "selected ='selected'" : '' ?>>
                                                        <?= $value->mainuser_name ?>
                                                    </option>
                                                <?php endforeach; ?>
                                            </select>
                                    <div class="field-placeholder">Applicants Type</div>
                                </div>
                            </div>


                              <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                <div class="field-wrapper">
                                    <select class="select-single js-states" name="fkPlatform_id" id="fkPlatform_id" >
                                                <option value="">Select Platform type</option>
                                                <?php foreach($Platformtdata as $value): ?>
                                                    <option value="<?= $value->Platform_id ?>" <?= (!empty($data[0]->fkPlatform_id) && $data[0]->fkPlatform_id == $value->Platform_id) ? "selected ='selected'" : '' ?>>
                                                        <?= $value->Platform_name ?>
                                                    </option>
                                                <?php endforeach; ?>
                                            </select>
                                    <div class="field-placeholder">Platform </div>
                                </div>
                            </div>

                              <div class="col-md-2">
    <div class="field-wrapper">
        <select name="finicial_Year" id="finicial_Year" class="select-single js-states form-control">
 
  <?php
   
    $savedYear = '';
 
    if (!empty($data) && isset($data[0]->finicial_Year)) {
       
        $savedYear = $data[0]->finicial_Year;
    } elseif (!empty($childData) && isset($childData[0]->finicial_Year)) {
       
        $savedYear = $childData[0]->finicial_Year;
    }
 
    if (empty($savedYear) && !empty($activeYear)) {
        $savedYear = $activeYear->finiYear_id;
    }
?>
 
            <option value="">Select year</option>
 
            <?php foreach($yeardata as $year): ?>
                <option value="<?= $year->finiYear_id ?>"
                    <?= ($year->finiYear_id == $savedYear) ? 'selected' : '' ?>>
                    <?= $year->fini_Label ?>
                </option>
            <?php endforeach; ?>
 
        </select>
        <div class="field-placeholder">Academic Year</div>
    </div>
</div>


                                <div class="row">
                                    <div class="col-md-6 mt-2">
                                        <a href="<?= base_url('uploads/formatexcel/Practiced.xlsx'); ?>" download style="color: #0b0a0aff; text-decoration: underline; font-weight: 600; font-size:14px;">
                                            <i class="fas fa-file-excel" style="color: green; margin-right: 6px; font-size:16px;"></i>
                                            Download Excel Format
                                        </a>
                                    </div>
                                </div>

                                

                                <div class="card-body">
                                    <div class="text-end">
                                        <button class="btn mb-md-0 mb-2 btn-quarternary" id="submit" name="submit" type="button">
                                            <i class="fa-solid fa-file-excel"></i> Save Data
                                        </button>
                                        <button type="button" class="btn mb-md-0 mb-2 btn-quarternaryhome" onclick="window.location.href='<?= base_url() ?>admin/Practiced/Dashboard'">
                                            <i class="fa-solid fa-home"></i>&nbsp;&nbsp;Home
                                        </button>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <span style="font-size: 12px; color: black; font-weight:600;">
                                        Note <span class="text-danger">*</span>: (Edit And Drag & Drop Functionality Available In Table.)
                                    </span>
                                </div>

                                <table id="leavetable" class="table custom-table">
                                    <thead>
                                        <tr>
                                            <th draggable="true">ID</th>
                                            <th draggable="true" style="min-width:180px;">Name </th>
                                            <th draggable="true" style="min-width:150px;">PRN/Empoye ID</th>
                                            <th draggable="true" style="min-width:150px;">Duration</th>
                                            <th draggable="true" style="min-width:150px;">Course Name</th>
                                            <th draggable="true" style="min-width:100px;">Percentile %</th>
                                            <th draggable="true" style="min-width:100px;">Grade</th>
                                            <th draggable="true" style="min-width:100px;">Start Date</th>
                                            <th draggable="true" style="min-width:100px;">End Date</th>
                                         
                                            <th draggable="true" style="min-width:100px;">Financial Year</th>
                                        </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<script src="<?php echo base_url();?>Assets/js/jquery.min.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>

<script>
// ✅ Excel file upload and display in table
document.getElementById('excel_file').addEventListener('change', function (e) {
    const uploadedFile = e.target.files[0];
    if (!uploadedFile) return;

    let tableBody = document.querySelector("#leavetable tbody");
    tableBody.innerHTML = `
        <tr>
            <td colspan="11" class="text-center">
                <div class="table-spinner"></div>
                <div>Loading data...</div>
            </td>
        </tr>
    `;

    const reader = new FileReader();
    reader.onload = function (event) {
        try {
            const data = new Uint8Array(event.target.result);
            const workbook = XLSX.read(data, { type: 'array' });

            const sheetName = workbook.SheetNames[0];
            const worksheet = workbook.Sheets[sheetName];
            const rows = XLSX.utils.sheet_to_json(worksheet, { header: 1 });

            tableBody.innerHTML = "";

            if (rows.length > 0) {
                rows.forEach((row, i) => {
                    if (!row || row.length === 0) return;

                    let tr = document.createElement("tr");

                    // Add ID column (serial number)
                    let idTd = document.createElement("td");
                    idTd.textContent = i;
                    idTd.style.backgroundColor = "#f0f0f0";
                    tr.appendChild(idTd);

                    // Add remaining 10 columns
                    for (let c = 0; c < 10; c++) {
                        let td = document.createElement("td");
                        let cellValue = row[c] ?? "";

                        // Excel date conversion
                        if (typeof cellValue === "number" && cellValue > 30000 && cellValue < 60000) {
                            let excelDate = XLSX.SSF.parse_date_code(cellValue);
                            if (excelDate) {
                                let jsDate = new Date(excelDate.y, excelDate.m - 1, excelDate.d);
                                let day = String(jsDate.getDate()).padStart(2, '0');
                                let month = String(jsDate.getMonth() + 1).padStart(2, '0');
                                let year = jsDate.getFullYear();
                                cellValue = `${day}-${month}-${year}`;
                            }
                        }

                        td.textContent = cellValue;
                        
                        // Make editable except header row
                        if (i !== 0) {
                            td.setAttribute("contenteditable", "true");
                        }

                        tr.appendChild(td);
                    }
                    tableBody.appendChild(tr);
                });
            } else {
                tableBody.innerHTML = `<tr><td colspan="11" class="text-center text-muted">No data found in sheet</td></tr>`;
            }
        } catch (error) {
            console.error('Error reading Excel:', error);
            tableBody.innerHTML = `<tr><td colspan="11" class="text-center text-danger">Error reading Excel file. Please check the format.</td></tr>`;
        }
    };

    reader.onerror = function() {
        tableBody.innerHTML = `<tr><td colspan="11" class="text-center text-danger">Error loading file</td></tr>`;
    };

    reader.readAsArrayBuffer(uploadedFile);
});
</script>

<script>
// ✅ Drag and drop columns
let draggedColIndex = null;

document.querySelectorAll("#leavetable thead th").forEach((th, index) => {
    th.style.cursor = "move";
    th.addEventListener("dragstart", function (e) {
        draggedColIndex = index;
        e.dataTransfer.effectAllowed = "move";
    });

    th.addEventListener("dragover", function (e) {
        e.preventDefault();
        this.classList.add("over");
    });

    th.addEventListener("dragleave", function () {
        this.classList.remove("over");
    });

    th.addEventListener("drop", function (e) {
        e.preventDefault();
        this.classList.remove("over");

        let targetColIndex = Array.from(this.parentNode.children).indexOf(this);

        if (draggedColIndex === targetColIndex) return;

        swapTableColumns(draggedColIndex, targetColIndex);
    });
});

function swapTableColumns(fromIndex, toIndex) {
    const table = document.getElementById("leavetable");
    const tbody = table.querySelector("tbody");

    for (let row of tbody.rows) {
        let cells = row.cells;
        if (fromIndex < cells.length && toIndex < cells.length) {
            if (fromIndex < toIndex) {
                row.insertBefore(cells[fromIndex], cells[toIndex].nextSibling);
            } else {
                row.insertBefore(cells[fromIndex], cells[toIndex]);
            }
        }
    }
}
</script>

<script>
// ✅ Save button - Send table data to controller
document.getElementById('submit').addEventListener('click', function () {
    console.log('Save button clicked');
    
    // Validate required dropdowns
    let fkmainuser_id = $('#fkmainuser_id').val();
    let fkPlatform_id = $('#fkPlatform_id').val();
    let finicial_Year = $('#finicial_Year').val();
    
    if (!fkmainuser_id) {
        Swal.fire("Required", "Please select Applicant Type!", "warning");
        return;
    }
    
    if (!fkPlatform_id) {
        Swal.fire("Required", "Please select Platform!", "warning");
        return;
    }
    
    if (!finicial_Year) {
        Swal.fire("Required", "Please select Academic Year!", "warning");
        return;
    }
    
    let tableData = [];
    let rows = document.querySelectorAll("#leavetable tbody tr");

    // Skip first row (header row from Excel)
    rows.forEach((tr, index) => {
        if (index === 0) return; // Skip header row
        
        let cells = tr.querySelectorAll("td");
        if (cells.length >= 11) {
            tableData.push({
                Practiced_id: cells[0].innerText.trim(),
                Applicant_name: cells[1].innerText.trim(),
                Applicant_id: cells[2].innerText.trim(),
                fkduration_id: cells[3].innerText.trim(),
                Course_name: cells[4].innerText.trim(),
                Practice_prece: cells[5].innerText.trim(), 
                fkGrade_id: cells[6].innerText.trim(),
                StartDate: cells[7].innerText.trim(),
                EndDate: cells[8].innerText.trim(),
                Financial_Year: cells[9].innerText.trim()
            });
        }
    });

    console.log('Table data:', tableData);

    if (tableData.length === 0) {
        Swal.fire("No Data", "Please upload Excel file first!", "warning");
        return;
    }

    // Create FormData and append all required data
    let formData = new FormData();
    formData.append('tableData', JSON.stringify(tableData));
    formData.append('fkmainuser_id', fkmainuser_id);
    formData.append('fkPlatform_id', fkPlatform_id);
    formData.append('finicial_Year', finicial_Year);
    formData.append('fk_submenuId', $('#fk_submenuId').val());

    let excelFile = document.getElementById('excel_file').files[0];
    if (excelFile) {
        formData.append('excel_file', excelFile);
    } else {
        Swal.fire("No File", "Please select an Excel file!", "warning");
        return;
    }

    console.log('Sending AJAX request...');

    $.ajax({
        url: "<?= base_url('admin/Import_Practiced/import_excel_save') ?>",
        type: "POST",
        data: formData,
        processData: false,
        contentType: false,
        beforeSend: function () {
            console.log('Request started');
            $("#loader").show();
            $('#submit').prop('disabled', true).html('<i class="fa-solid fa-spinner fa-spin"></i> Saving...');
        },
        success: function (response) {
            console.log('Response received:', response);
            $('#submit').prop('disabled', false).html('<i class="fa-solid fa-file-excel"></i> Save Data');
            $('#loader').fadeOut();

            let message = '';
            let icon = '';
            let title = '';

            // Trim response to remove whitespace
            response = response.trim();

            if (response === 'success') {
                message = 'Data Imported Successfully!';
                icon = 'success';
                title = 'Success!';
            } else if (response === 'no_data') {
                message = 'No data found in Excel!';
                icon = 'warning';
                title = 'Notice';
            } else if (response === 'no_file') {
                message = 'No file selected!';
                icon = 'warning';
                title = 'Notice';
            } else if (response === 'file_error') {
                message = 'Error uploading file!';
                icon = 'error';
                title = 'Error';
            } else if (response === 'invalid_data') {
                message = 'Invalid data format!';
                icon = 'error';
                title = 'Error';
            } else if (response === 'db_error') {
                message = 'Database error occurred!';
                icon = 'error';
                title = 'Error';
            } else if (response.startsWith('error:')) {
                message = response.substring(6);
                icon = 'error';
                title = 'Error';
            } else {
                message = 'Unexpected response: ' + response;
                icon = 'error';
                title = 'Error';
            }

            Swal.fire({
                position: 'center',
                icon: icon,
                title: '<strong>' + title + '</strong>',
                html: message,
                showConfirmButton: icon === 'error',
                timer: icon === 'error' ? 0 : 2000,
                customClass: {
                    popup: 'custom-swal-popup',
                    icon: 'custom-swal-icon',
                    title: 'custom-swal-title',
                    htmlContainer: 'custom-swal-text'
                }
            }).then(() => {
                if (response === 'success') {
                    location.reload();
                }
            });
        },
        error: function (xhr, status, error) {
            console.error('AJAX Error:', status, error);
            console.error('Response:', xhr.responseText);
            $('#submit').prop('disabled', false).html('<i class="fa-solid fa-file-excel"></i> Save Data');
            $('#loader').fadeOut();

            Swal.fire({
                position: 'center',
                icon: 'error',
                title: '<strong>Error!</strong>',
                html: 'Something went wrong!<br><small>' + error + '</small>',
                showConfirmButton: true,
                customClass: {
                    popup: 'custom-swal-popup',
                    icon: 'custom-swal-icon',
                    title: 'custom-swal-title',
                    htmlContainer: 'custom-swal-text'
                }
            });
        }
    });
});
</script>

<script>
// ✅ Highlight editable cell while editing
document.addEventListener("DOMContentLoaded", function () {
    const table = document.getElementById("leavetable");

    table.addEventListener("focusin", function (e) {
        if (e.target.tagName === "TD" && e.target.isContentEditable) {
            e.target.style.backgroundColor = "#fffacd";
        }
    });

    table.addEventListener("focusout", function (e) {
        if (e.target.tagName === "TD" && e.target.isContentEditable) {
            e.target.style.backgroundColor = "";
        }
    });
});
</script>