<?php
/* 
 * UPDATED Library IN-OUT View
 * Changes:
 * 1. WorkingType field flow fixed - Enter key now goes: Card → WorkingType → Library Dept
 * 2. WorkingType data now properly saved to database
 * 3. WorkingType displayed in pending entry alerts
 */
?>

<style>
    #btnShow1 {
        background-color: #1273eb;
        color: white !important;
        font-size: 13px !important;
        padding: 8px 14px !important;
        border: none !important;
        border-radius: 5px !important;
        cursor: pointer !important;
        display: inline-flex !important;
        align-items: center !important;
        transition: background 0.3s, transform 0.1s;
        border: 2px solid grey !important;
    }
    
    #btnShow1:hover {
        background: linear-gradient(to right, #deba03fd, #fff75cff) !important;
        color: black !important;
        transform: translateY(-1px);
    }
    
    .saved-entry {
        background-color: #f8f9fa;
    }
    
    .pulse-save {
        animation: pulse 0.5s ease-in-out;
    }
    
    @keyframes pulse {
        0% { background-color: #ffffff; }
        50% { background-color: #d4edda; }
        100% { background-color: #f8f9fa; }
    }
    
    .entry-form-card {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border: none;
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    }
    
    .form-group label {
        font-weight: 600;
        color: #495057;
        margin-bottom: 0.5rem;
        font-size: 0.9rem;
    }
    
    .required-field::after {
        content: " *";
        color: #dc3545;
    }

    #displayTableBody tr.saved-entry {
        cursor: pointer;
        transition: background-color 0.2s;
    }

    #displayTableBody tr.saved-entry:hover {
        background-color: #e8f4ff !important;
    }

    #displayTableBody tr.saved-entry .badge.bg-warning {
        animation: blink 1.5s ease-in-out infinite;
    }

    @keyframes blink {
        0%, 100% { opacity: 1; }
        50% { opacity: 0.6; }
    }

    /* Search highlight styling */
    .search-highlight {
        background-color: #fff3cd;
        padding: 2px 4px;
        border-radius: 3px;
        font-weight: 600;
    }

    .no-match {
        display: none !important;
    }

    #tableSearchInput {
        border-left: none;
    }

    #tableSearchInput:focus {
        box-shadow: none;
        border-color: #ced4da;
    }

    .input-group-text {
        border-right: none;
    }

    #clearSearch {
        border-left: none;
    }

    /* Animation for search */
    @keyframes searchPulse {
        0%, 100% { background-color: #fff3cd; }
        50% { background-color: #ffeaa7; }
    }

    /* ✨ TYPEAHEAD DROPDOWN STYLING */
.working-type-wrapper {
    position: relative;
}

.typeahead-dropdown {
    position: absolute;
    top: 100%;
    left: 0;
    right: 0;
    background: white;
    border: 1px solid #ced4da;
    border-top: none;
    border-radius: 0 0 4px 4px;
    max-height: 300px;
    overflow-y: auto;
    z-index: 1050;
    display: none;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    margin-top: -1px;
}

.typeahead-dropdown.show {
    display: block;
}

.typeahead-item {
    padding: 12px 15px;
    cursor: pointer;
    border-bottom: 1px solid #f0f0f0;
    transition: background-color 0.2s;
    font-size: 14px;
}

.typeahead-item:hover,
.typeahead-item.active {
    background-color: #e9ecef;
}

.typeahead-item:last-child {
    border-bottom: none;
    border-radius: 0 0 4px 4px;
}

.typeahead-item .name {
    display: block;
    font-weight: 500;
    color: #333;
}

.typeahead-no-results {
    padding: 15px;
    text-align: center;
    color: #999;
    font-style: italic;
    font-size: 13px;
}

/* Scrollbar styling for dropdown */
.typeahead-dropdown::-webkit-scrollbar {
    width: 8px;
}

.typeahead-dropdown::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 0 0 4px 0;
}

.typeahead-dropdown::-webkit-scrollbar-thumb {
    background: #888;
    border-radius: 4px;
}

.typeahead-dropdown::-webkit-scrollbar-thumb:hover {
    background: #555;
}

    .search-active {
        animation: searchPulse 0.5s ease-in-out;
    }
</style>

<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="card-title" style="text-decoration: underline;">Library IN-OUT</div>
                    </div>
                    <div class="card-body">
                        <form role="form" id="Form" method="post" enctype="multipart/form-data">
                            
                            <input type="hidden" id="main_excel_id" name="main_excel_id" value="" />
                            <input class="form-control" id="library_ID" name="library_ID" type="hidden" value="" />
                            
                            <!-- hidden submenuid -->
<input class="form-control" id="fk_submenuId" name="fk_submenuId" type="hidden"
                           value="<?= isset($subId) ? $subId : '' ?>"  />
                            
                            <div class="row gutters">
                                <!-- Date -->
                                <div class="col-xl-3 col-lg-3 col-md-4 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label class="required-field">Date</label>
                                        <input type="date"
                                               name="Date[]"
                                               id="Date"
                                               class="form-control"
                                               autocomplete="off">
                                    </div>
                                </div>

                                <!-- Card Number -->
                                <div class="col-xl-3 col-lg-3 col-md-4 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label class="required-field">Card Number</label>
                                        <input type="hidden" name="library_ID[]" value="">
                                        <input type="text" name="CardNo[]" id="cardNoInput" 
                                               class="form-control card-input" 
                                               placeholder="Scan or Enter Card No" 
                                               autocomplete="off">
                                    </div>
                                </div>

                                <!-- Name -->
                                <div class="col-xl-3 col-lg-3 col-md-4 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Name</label>
                                        <input type="text" name="Name[]" 
                                               class="form-control name-input" 
                                               placeholder="Name" readonly>
                                    </div>
                                </div>

                                <!-- Class -->
                                <div class="col-xl-2 col-lg-2 col-md-4 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Class</label>
                                        <input type="text" name="Class[]" 
                                               class="form-control class-input" 
                                               placeholder="Class" readonly>
                                    </div>
                                </div>

                                <!-- Department -->
                                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <div class="form-group">
                                        <label>Department</label>
                                        <input type="text" name="Department[]" 
                                               class="form-control dept-input" 
                                               placeholder="Department" readonly>
                                    </div>
                                </div>

                                <!-- Working Type -->
                               <div class="col-xl-2 col-lg-2 col-md-2 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label class="required-field">Working Type</label>
                                        <div class="working-type-wrapper">
                                            <input type="text" 
                                                   name="WorkingType[]" 
                                                   id="WorkingType"  
                                                   class="form-control working-type-input"
                                                   placeholder="Type to search..."
                                                   autocomplete="off">
                                            <!-- ✨ Typeahead Dropdown -->
                                            <div class="typeahead-dropdown" id="workingtype_typeahead_dropdown"></div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Library Department -->
                                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <div class="form-group">
                                        <label class="required-field">Library Department</label>
                                        <select name="fkLibDept_id[]" class="form-control libdept-dropdown" required>
                                            <option value="">-- Select Library Dept --</option>
                                        </select>
                                    </div>
                                </div>

                                <!-- In-Time -->
                                <div class="col-xl-2 col-lg-2 col-md-4 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label class="required-field">In-Time</label>
                                        <input type="time" name="In_Time[]" 
                                               class="form-control in-time-input">
                                    </div>
                                </div>

                                <!-- Out-Time -->
                                <div class="col-xl-2 col-lg-2 col-md-4 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label class="required-field">Out-Time</label>
                                        <input type="time" name="Out_Time[]" 
                                               class="form-control out-time-input">
                                    </div>
                                </div>

                                <!-- Hours -->
                                <div class="col-xl-2 col-lg-2 col-md-4 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Total Hours</label>
                                        <input type="text" name="Hours[]" 
                                               class="form-control hours-input" 
                                               placeholder="Auto-calculated" readonly>
                                    </div>
                                </div>
                            </div>

                            <!-- SAVED ENTRIES DISPLAY TABLE -->
                            <div class="mt-1">
                                <div class="card border-success">
                                    <div class="card-header text-white d-flex justify-content-end">
                                        <div class="row align-items-end">
                                            <div class="col-12">
                                                <div class="input-group">
                                                    <span class="input-group-text bg-white">
                                                        <i class="fa-solid fa-search"></i>
                                                    </span>
                                                    <input type="text" 
                                                           id="tableSearchInput" 
                                                           class="form-control" 
                                                           placeholder="Search"
                                                           autocomplete="off">
                                                    <button class="btn btn-light" type="button" id="clearSearch" title="Clear Search">
                                                        <i class="fa-solid fa-times"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body p-0">
                                        <div class="table-responsive" style="max-height: 800px; overflow-y: auto;">
                                            <table class="table table-bordered table-striped table-hover mb-0">
                                                <thead class="table-dark sticky-top">
                                                    <tr>
                                                        <th class="text-white">Sr.No.</th>
                                                        <th class="text-white">Date</th>
                                                        <th class="text-white">Card No</th>
                                                        <th class="text-white">Name</th>
                                                        <th class="text-white">Class</th>
                                                        <th class="text-white">Department</th>
                                                        <th class="text-white">Working Type</th>
                                                        <th class="text-white">Library Dept</th>
                                                        <th class="text-white">In-Time</th>
                                                        <th class="text-white">Out-Time</th>
                                                        <th class="text-white">Hours</th>
                                                        <th class="text-white">Status</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="displayTableBody">
                                                    <tr class="text-center">
                                                        <td colspan="12" class="text-muted py-4">
                                                            <i class="fa-solid fa-inbox fa-2x mb-2"></i><br>
                                                            <i>No entries saved yet. Start by entering a card number above.</i>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                        <div id="searchResults" class="p-2 bg-light border-top text-muted small" style="display: none;">
                                            <i class="fa-solid fa-info-circle"></i> 
                                            Showing <strong id="matchCount">0</strong> of <strong id="totalCount">0</strong> entries
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="card-body">
                                <div class="">
                                    <a class="btn mb-md-0 mb-2 btn-quarternary1" href="<?=base_url()?>admin/Library_IN_Out/index">
                                        <i class="fa-solid fa-list"></i>&nbsp;&nbsp;View All Records
                                    </a>
                                    <button type="button" class="btn mb-md-0 mb-2 btn-quarternaryhome" 
                                            onclick="window.location.href='<?= base_url('admin/Library/dashboard') ?>'">
                                        <i class="fa-solid fa-home fa-lg"></i>
                                        <span class="fw-semibold">Home</span>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="<?php echo base_url();?>Assets/js/jquery.min.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>

<script>
var workingTypeTypingTimer;
var typingInterval = 400;
var currentFocus = -1;

$(document).ready(function() {
    
    // ✨ Working Type Typeahead - Keyup Event
    $("#WorkingType").on('keyup', function(e) {
        // Don't trigger on arrow keys or enter
        if (e.keyCode === 38 || e.keyCode === 40 || e.keyCode === 13) {
            return;
        }

        clearTimeout(workingTypeTypingTimer);
        
        const searchTerm = $(this).val().trim();

        // Hide dropdown if search term is empty
        if (searchTerm.length === 0) {
            $('#workingtype_typeahead_dropdown').removeClass('show').html('');
            return;
        }

        // Show dropdown immediately for short searches (1+ characters)
        if (searchTerm.length >= 1) {
            workingTypeTypingTimer = setTimeout(function() {
                searchWorkingTypes(searchTerm);
            }, typingInterval);
        }
    });

    // Search Working Types from Database
    function searchWorkingTypes(search) {
        $.ajax({
            url: baseURL + 'admin/Library_IN_Out/searchWorkingTypes',
            type: 'POST',
            data: { search: search },
            dataType: 'json',
            beforeSend: function() {
                $('#workingtype_typeahead_dropdown')
                    .html('<div class="typeahead-no-results"><i class="fa fa-spinner fa-spin"></i> Searching...</div>')
                    .addClass('show');
            },
           success: function(response) {
    if (response.success && response.data.length > 0) {
        let html = '';
        
        $.each(response.data, function(i, item) {
            html += `
                <div class="typeahead-item" data-workingtype="${item.WorkingType}">
                    <span class="name">${item.WorkingType}</span>
                </div>
            `;
        });
        
        $('#workingtype_typeahead_dropdown').html(html).addClass('show');
    } else {
        $('#workingtype_typeahead_dropdown')
            .html('<div class="typeahead-no-results">No matching working types found. Type to create new.</div>')
            .addClass('show');
    }
},
            error: function(xhr, status, error) {
                console.error('Working Type search error:', error);
                $('#workingtype_typeahead_dropdown').removeClass('show').html('');
            }
        });
    }

    // Select Working Type from Dropdown
    $(document).on('click', '.typeahead-item', function() {
        const selectedWorkingType = $(this).data('workingtype');
        
        $('#WorkingType').val(selectedWorkingType);
        $('#workingtype_typeahead_dropdown').removeClass('show').html('');
        
        // Move to next field
        setTimeout(() => {
            $('.libdept-dropdown').focus();
        }, 100);
    });

    // Hide dropdown when clicking outside
    $(document).on('click', function(e) {
        if (!$(e.target).closest('#WorkingType').length &&
            !$(e.target).closest('#workingtype_typeahead_dropdown').length) {
            $('#workingtype_typeahead_dropdown').removeClass('show').html('');
        }
    });

    // Clear dropdown when field is cleared
    $("#WorkingType").on('input', function() {
        if ($(this).val().trim() === '') {
            $('#workingtype_typeahead_dropdown').removeClass('show').html('');
        }
    });

    // ✨ Keyboard Navigation for Typeahead
    $("#WorkingType").on('keydown', function(e) {
        var items = $('#workingtype_typeahead_dropdown .typeahead-item');
        
        if (e.keyCode === 40) { // Down arrow
            e.preventDefault();
            currentFocus++;
            addActive(items);
        } else if (e.keyCode === 38) { // Up arrow
            e.preventDefault();
            currentFocus--;
            addActive(items);
        } else if (e.keyCode === 13) { // Enter
            e.preventDefault();
            if (currentFocus > -1 && items.length > 0) {
                items[currentFocus].click();
            } else {
                // No selection, move to next field
                let workingType = $(this).val().trim();
                
                if (!workingType || workingType === '') {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Working Type Required',
                        text: 'Please enter Working Type!',
                        timer: 2000
                    });
                    return;
                }
                
                $('#workingtype_typeahead_dropdown').removeClass('show').html('');
                setTimeout(() => {
                    $('.libdept-dropdown').focus();
                }, 100);
            }
        } else if (e.keyCode === 27) { // Escape
            $('#workingtype_typeahead_dropdown').removeClass('show').html('');
            currentFocus = -1;
        }
    });

    function addActive(items) {
        if (!items || items.length === 0) return false;
        removeActive(items);
        
        if (currentFocus >= items.length) currentFocus = 0;
        if (currentFocus < 0) currentFocus = items.length - 1;
        
        $(items[currentFocus]).addClass('active');
        items[currentFocus].scrollIntoView({ block: 'nearest' });
    }

    function removeActive(items) {
        $(items).removeClass('active');
    }
});
// ==================== TABLE SEARCH FUNCTIONALITY ====================
function initializeTableSearch() {
    let searchTimeout;
    
    // Search input handler
    $('#tableSearchInput').on('keyup', function() {
        clearTimeout(searchTimeout);
        const searchTerm = $(this).val().toLowerCase().trim();
        
        searchTimeout = setTimeout(function() {
            filterTable(searchTerm);
        }, 300);
    });
    
    // Clear search button
    $('#clearSearch').on('click', function() {
        $('#tableSearchInput').val('');
        filterTable('');
        $('#tableSearchInput').focus();
    });
    
    // Enter key to search
    $('#tableSearchInput').on('keydown', function(e) {
        if (e.key === 'Enter') {
            e.preventDefault();
            const searchTerm = $(this).val().toLowerCase().trim();
            filterTable(searchTerm);
        }
    });
}

function filterTable(searchTerm) {
    const $rows = $('#displayTableBody tr.saved-entry');
    const totalRows = $rows.length;
    let matchCount = 0;
    
    if (searchTerm === '') {
        $rows.removeClass('no-match search-active').show();
        $('mark.search-highlight').contents().unwrap();
        $('#searchResults').hide();
        updateDisplaySerialNumbers();
        return;
    }
    
    $rows.each(function() {
        const $row = $(this);
        $row.find('mark.search-highlight').contents().unwrap();
        
        const cardNo = $row.find('td:eq(2)').text().toLowerCase();
        const name = $row.find('td:eq(3)').text().toLowerCase();
        const className = $row.find('td:eq(4)').text().toLowerCase();
        const department = $row.find('td:eq(5)').text().toLowerCase();
        const workingType = $row.find('td:eq(6)').text().toLowerCase();
        const libDept = $row.find('td:eq(7)').text().toLowerCase();
        
        const rowText = `${cardNo} ${name} ${className} ${department} ${workingType} ${libDept}`;
        
        if (rowText.includes(searchTerm)) {
            $row.removeClass('no-match').addClass('search-active').show();
            matchCount++;
            highlightText($row, searchTerm);
            setTimeout(function() {
                $row.removeClass('search-active');
            }, 500);
        } else {
            $row.addClass('no-match').hide();
        }
    });
    
    $('#matchCount').text(matchCount);
    $('#totalCount').text(totalRows);
    $('#searchResults').show();
    updateDisplaySerialNumbers();
    
    if (matchCount === 0) {
        if ($('#displayTableBody tr.no-results-row').length === 0) {
            $('#displayTableBody').append(`
                <tr class="no-results-row text-center">
                    <td colspan="12" class="text-muted py-4">
                        <i class="fa-solid fa-search fa-2x mb-2"></i><br>
                        <i>No entries found matching "${searchTerm}"</i>
                    </td>
                </tr>
            `);
        }
    } else {
        $('#displayTableBody tr.no-results-row').remove();
    }
}

function highlightText($row, searchTerm) {
    const columnsToHighlight = [2, 3, 4, 5, 6, 7];
    
    columnsToHighlight.forEach(function(colIndex) {
        const $cell = $row.find(`td:eq(${colIndex})`);
        let cellHtml = $cell.html();
        const $temp = $('<div>').html(cellHtml);
        highlightInElement($temp[0], searchTerm);
        $cell.html($temp.html());
    });
}

function highlightInElement(element, searchTerm) {
    const walker = document.createTreeWalker(
        element,
        NodeFilter.SHOW_TEXT,
        null,
        false
    );
    
    const nodesToReplace = [];
    let node;
    
    while (node = walker.nextNode()) {
        if (node.nodeValue.toLowerCase().includes(searchTerm)) {
            nodesToReplace.push(node);
        }
    }
    
    nodesToReplace.forEach(function(node) {
        const text = node.nodeValue;
        const lowerText = text.toLowerCase();
        const index = lowerText.indexOf(searchTerm);
        
        if (index !== -1) {
            const before = text.substring(0, index);
            const match = text.substring(index, index + searchTerm.length);
            const after = text.substring(index + searchTerm.length);
            
            const fragment = document.createDocumentFragment();
            
            if (before) fragment.appendChild(document.createTextNode(before));
            
            const mark = document.createElement('mark');
            mark.className = 'search-highlight';
            mark.textContent = match;
            fragment.appendChild(mark);
            
            if (after) fragment.appendChild(document.createTextNode(after));
            
            node.parentNode.replaceChild(fragment, node);
        }
    });
}

function updateDisplaySerialNumbers() {
    const $visibleRows = $("#displayTableBody tr.saved-entry:visible");
    const totalVisible = $visibleRows.length;
    
    $visibleRows.each(function(index) {
        const serialNo = totalVisible - index;
        $(this).find("td:first").text(serialNo);
    });
}

$(document).ready(function() {
    initializeTableSearch();
});

// ==================== GLOBAL VARIABLES ====================
var baseURL = '<?= base_url() ?>';
var libraryDepartments = [];
var isSaving = false;

// ==================== GLOBAL HELPER FUNCTIONS ====================
function getCurrentTime() {
    const now = new Date();
    const hours = String(now.getHours()).padStart(2, '0');
    const minutes = String(now.getMinutes()).padStart(2, '0');
    return `${hours}:${minutes}`;
}

function convertTo12Hour(time24) {
    if (!time24 || time24 === '-' || time24 === '') return '-';
    
    const [hours, minutes] = time24.split(':');
    let hour = parseInt(hours);
    const ampm = hour >= 12 ? 'PM' : 'AM';
    
    hour = hour % 12;
    hour = hour ? hour : 12;
    
    return `${hour}:${minutes} ${ampm}`;
}

function formatDate(dateStr) {
    if (!dateStr) return '-';
    
    const date = new Date(dateStr);
    const day = String(date.getDate()).padStart(2, '0');
    const month = String(date.getMonth() + 1).padStart(2, '0');
    const year = date.getFullYear();
    
    return `${day}/${month}/${year}`;
}

function calculateHoursDiff(inTime, outTime) {
    if (!inTime || !outTime) return null;
    
    const [inHour, inMin] = inTime.split(':').map(Number);
    const [outHour, outMin] = outTime.split(':').map(Number);
    
    const inMinutes = inHour * 60 + inMin;
    let outMinutes = outHour * 60 + outMin;
    
    if (outMinutes < inMinutes) {
        outMinutes += 24 * 60;
    }
    
    const diffMinutes = outMinutes - inMinutes;
    
    if (diffMinutes < 0) return null;
    
    let displayValue = '';
    
    if (diffMinutes < 1) {
        displayValue = 'Less than a minute';
    } else if (diffMinutes < 60) {
        displayValue = diffMinutes + (diffMinutes === 1 ? ' minute' : ' minutes');
    } else {
        const hours = (diffMinutes / 60).toFixed(2);
        displayValue = hours + (hours < 2 ? ' hour' : ' hours');
    }
    
    return displayValue;
}

function calculateHours() {
    const inTime = $('.in-time-input').val();
    const outTime = $('.out-time-input').val();
    
    if (inTime && outTime) {
        const hours = calculateHoursDiff(inTime, outTime);
        
        if (hours !== null) {
            $('.hours-input').val(hours);
            return true;
        } else {
            $('.hours-input').val('');
            Swal.fire({
                icon: 'error',
                title: 'Invalid Time',
                text: 'Out-Time must be after In-Time',
                timer: 2000
            });
            return false;
        }
    }
    return false;
}

function resetForm() {
    $("input[name='CardNo[]']").val('');
    $("input[name='Name[]']").val('');
    $("input[name='Class[]']").val('');
    $("input[name='Department[]']").val('');
    $("#WorkingType").val('');
    $("select[name='fkLibDept_id[]']").val('');
    $("input[name='In_Time[]']").val('');
    $("input[name='Out_Time[]']").val('');
    $("input[name='Hours[]']").val('');
    $("input[name='library_ID[]']").val('');
    
    $('.entry-form-card input, .entry-form-card select').prop('disabled', false);
    $("input[name='In_Time[]']").prop('readonly', false);
    $("select[name='fkLibDept_id[]']").prop('disabled', false);
    
    $('.entry-form-card').css({
        'opacity': '1',
        'background-color': ''
    });
}

function updateSavedCount() {
    const totalCount = $("#displayTableBody tr.saved-entry").length;
    const completeCount = $("#displayTableBody .badge.bg-success").length;
    const pendingCount = $("#displayTableBody .badge.bg-warning").length;
    
    $("#savedCount").html(`${totalCount} <small>(${completeCount} complete, ${pendingCount} pending)</small>`);
}

function addToDisplayTable(entryData, serialNo = null) {
    $("#displayTableBody tr.text-center").remove();
    
    const srNo = serialNo || 1;
    
    let libDeptName = entryData.LibDep_Name || '';
    if (!libDeptName && entryData.fkLibDept_id && libraryDepartments.length > 0) {
        const dept = libraryDepartments.find(d => d.Libdep_id == entryData.fkLibDept_id);
        if (dept) {
            libDeptName = dept.LibDep_Name;
        }
    }
    
    let statusBadge = '';
    let outTimeDisplay = entryData.Out_Time || '-';
    let hoursDisplay = entryData.Hours || '-';
    
    const inTime12 = convertTo12Hour(entryData.In_Time);
    const outTime12 = convertTo12Hour(entryData.Out_Time);
    const dateFormatted = formatDate(entryData.Date);
    
    if (entryData.Out_Time && entryData.Out_Time !== '' && entryData.Out_Time !== null) {
        statusBadge = '<span class="badge bg-success"><i class="fa-solid fa-check"></i> Complete</span>';
    } else {
        statusBadge = '<span class="badge bg-warning text-dark"><i class="fa-solid fa-clock"></i> In Progress</span>';
        outTimeDisplay = '<span class="text-muted fst-italic">Pending</span>';
        hoursDisplay = '<span class="text-muted fst-italic">-</span>';
    }
    
    const displayRow = `
        <tr class="saved-entry pulse-save" 
            data-card="${entryData.CardNo || entryData.Cardnumber}" 
            data-libdept="${entryData.fkLibDept_id}"
            data-intime="${entryData.In_Time}">
            <td>${srNo}</td>
            <td><span class="badge bg-secondary">${dateFormatted}</span></td>
            <td><strong>${entryData.CardNo || entryData.Cardnumber || ''}</strong></td>
            <td>${entryData.Name || ''}</td>
            <td>${entryData.Class || ''}</td>
            <td>${entryData.Department || ''}</td>
            <td><span class="badge bg-primary">${entryData.WorkingType || '-'}</span></td>
            <td><span class="badge bg-info">${libDeptName}</span></td>
            <td><span class="badge bg-primary">${inTime12}</span></td>
            <td>${entryData.Out_Time ? '<span class="badge bg-success">'+outTime12+'</span>' : outTimeDisplay}</td>
            <td>${hoursDisplay}</td>
            <td>${statusBadge}</td>
        </tr>`;
    
    $("#displayTableBody").prepend(displayRow);
    updateDisplaySerialNumbers();
}

function loadTodayEntries() {
    const selectedDate = $("#Date").val();
    
    $.ajax({
        url: baseURL + 'admin/Library_IN_Out/getTodayEntries',
        type: 'POST',
        data: { date: selectedDate },
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success' && response.data.length > 0) {
                $("#displayTableBody").empty();
                
                response.data.forEach(function(entry, index) {
                    const displayRow = createDisplayRow(entry);
                    $("#displayTableBody").append(displayRow);
                });
                
                updateDisplaySerialNumbers();
                updateSavedCount();
                
            } else {
                $("#displayTableBody").html(`
                    <tr class="text-center">
                        <td colspan="12" class="text-muted py-4">
                            <i class="fa-solid fa-inbox fa-2x mb-2"></i><br>
                            <i>No entries saved yet for this date.</i>
                        </td>
                    </tr>
                `);
                $("#savedCount").text('0');
            }
        },
        error: function() {
            console.error('Failed to load today entries');
        }
    });
}

function createDisplayRow(entryData) {
    let libDeptName = entryData.LibDep_Name || '';
    if (!libDeptName && entryData.fkLibDept_id && libraryDepartments.length > 0) {
        const dept = libraryDepartments.find(d => d.Libdep_id == entryData.fkLibDept_id);
        if (dept) {
            libDeptName = dept.LibDep_Name;
        }
    }
    
    let statusBadge = '';
    let outTimeDisplay = entryData.Out_Time || '-';
    let hoursDisplay = entryData.Hours || '-';
    
    const inTime12 = convertTo12Hour(entryData.In_Time);
    const outTime12 = convertTo12Hour(entryData.Out_Time);
    const dateFormatted = formatDate(entryData.Date);
    
    if (entryData.Out_Time && entryData.Out_Time !== '' && entryData.Out_Time !== null) {
        statusBadge = '<span class="badge bg-success"><i class="fa-solid fa-check"></i> Complete</span>';
    } else {
        statusBadge = '<span class="badge bg-warning text-dark"><i class="fa-solid fa-clock"></i> In Progress</span>';
        outTimeDisplay = '<span class="text-muted fst-italic">Pending</span>';
        hoursDisplay = '<span class="text-muted fst-italic">-</span>';
    }
    
    return `
        <tr class="saved-entry" 
            data-card="${entryData.CardNo || entryData.Cardnumber}" 
            data-libdept="${entryData.fkLibDept_id}"
            data-intime="${entryData.In_Time}">
            <td>1</td>
            <td><span class="badge bg-secondary">${dateFormatted}</span></td>
            <td><strong>${entryData.CardNo || entryData.Cardnumber || ''}</strong></td>
            <td>${entryData.Name || ''}</td>
            <td>${entryData.Class || ''}</td>
            <td>${entryData.Department || ''}</td>
            <td><span class="badge bg-primary">${entryData.WorkingType || '-'}</span></td>
            <td><span class="badge bg-info">${libDeptName}</span></td>
            <td><span class="badge bg-primary">${inTime12}</span></td>
            <td>${entryData.Out_Time ? '<span class="badge bg-success">'+outTime12+'</span>' : outTimeDisplay}</td>
            <td>${hoursDisplay}</td>
            <td>${statusBadge}</td>
        </tr>`;
}

// ==================== SAVE ENTRY WITH CUSTOM SWAL ====================
function saveEntry(saveType) {
    if (isSaving) {
        console.log('⚠️ Save already in progress, skipping...');
        return;
    }
    
    isSaving = true;
    
    const date = $("#Date").val();
    const cardNo = $("input[name='CardNo[]']").val();
    const name = $("input[name='Name[]']").val();
    const classValue = $("input[name='Class[]']").val();
    const department = $("input[name='Department[]']").val();
    const workingType = $("#WorkingType").val();
    const libDeptId = $("select[name='fkLibDept_id[]']").val();
    const inTime = $("input[name='In_Time[]']").val();
    const outTime = $("input[name='Out_Time[]']").val();
    const hours = $("input[name='Hours[]']").val();
    const libraryID = $("input[name='library_ID[]']").val();
    
    console.log('💾 Saving entry - Type:', saveType, 'Library ID:', libraryID);
    console.log('Working Type:', workingType);
    
    if (!date) {
        isSaving = false;
        Swal.fire("Error", "Please select date!", "error");
        return;
    }
    
    if (!cardNo || cardNo.trim() === '') {
        isSaving = false;
        Swal.fire("Error", "Card Number is required!", "error");
        return;
    }
    
    if (!workingType || workingType.trim() === '') {
        isSaving = false;
        Swal.fire("Error", "Working Type is required!", "error");
        return;
    }
    
    if (!libDeptId || libDeptId === '') {
        isSaving = false;
        Swal.fire("Error", "Please select Library Department!", "error");
        return;
    }
    
    if (!inTime) {
        isSaving = false;
        Swal.fire("Error", "In-Time is required!", "error");
        return;
    }
    
    const formData = new FormData();
    formData.append('Date', date);
    formData.append('CardNo', cardNo);
    formData.append('Name', name);
    formData.append('Class', classValue);
    formData.append('Department', department);
    formData.append('WorkingType', workingType);
    formData.append('fkLibDept_id', libDeptId);
    formData.append('In_Time', inTime);
    formData.append('Out_Time', outTime || '');
    formData.append('Hours', hours || '');
    formData.append('save_type', saveType);
     // for submenu id code
formData.append('fk_submenuId', $('#fk_submenuId').val());
    
    if (libraryID) {
        formData.append('library_ID', libraryID);
    }
    
    $('.entry-form-card input, .entry-form-card select').prop('disabled', true);
    $('.entry-form-card').css('opacity', '0.6');
    
    $.ajax({
        url: baseURL + 'admin/Library_IN_Out/smartSaveEntry',
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        dataType: 'json',
        timeout: 15000,
        success: function(response) {
            console.log('✅ Save Response:', response);
            
            if (response.status === 'success') {
                let message = '';
                if (saveType === 'in_only' || response.action === 'inserted') {
                    message = 'Entry Saved Successfully!';
                } else if (saveType === 'complete' || response.action === 'updated') {
                    message = 'Entry Completed Successfully!';
                }
                
                // ✨ CUSTOM SWAL DESIGN - MATCHING YOUR STYLE
                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: '<strong>Success!</strong>',
                    html: message,
                    showConfirmButton: false,
                    timer: 2000,
                    customClass: {
                        popup: 'custom-swal-popup',
                        icon: 'custom-swal-icon',
                        title: 'custom-swal-title',
                        htmlContainer: 'custom-swal-text'
                    }
                });
                
                loadTodayEntries();
                
                setTimeout(() => {
                    resetForm();
                    $('#cardNoInput').focus();
                    isSaving = false;
                }, 500);
                
            } else {
                isSaving = false;
                $('.entry-form-card input, .entry-form-card select').prop('disabled', false);
                $('.entry-form-card').css('opacity', '1');
                Swal.fire('Error', response.message || 'Failed to save', 'error');
            }
        },
        error: function(xhr, status, error) {
            console.error('❌ Save Error:', error);
            isSaving = false;
            $('.entry-form-card input, .entry-form-card select').prop('disabled', false);
            $('.entry-form-card').css('opacity', '1');
            Swal.fire('Error', 'Failed to save data. Please try again.', 'error');
        }
    });
}

function updateExistingEntry(cardNo, libDeptId, inTime, outTime, hours) {
    const date = $("#Date").val();
    
    const formData = new FormData();
    formData.append('Date', date);
    formData.append('CardNo', cardNo);
    formData.append('fkLibDept_id', libDeptId);
    formData.append('In_Time', inTime);
    formData.append('Out_Time', outTime);
    formData.append('Hours', hours);
    formData.append('save_type', 'update_out');
    // for submenu id code
formData.append('fk_submenuId', $('#fk_submenuId').val());

    $.ajax({
        url: baseURL + 'admin/Library_IN_Out/smartSaveEntry',
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                // ✨ CUSTOM SWAL DESIGN FOR UPDATE
                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: '<strong>Updated!</strong>',
                    html: 'Out-Time Updated Successfully',
                    showConfirmButton: false,
                    timer: 2000,
                    customClass: {
                        popup: 'custom-swal-popup',
                        icon: 'custom-swal-icon',
                        title: 'custom-swal-title',
                        htmlContainer: 'custom-swal-text'
                    }
                });
                
                loadTodayEntries();
            } else {
                Swal.fire('Error', response.message || 'Failed to update', 'error');
            }
        },
        error: function() {
            Swal.fire('Error', 'Failed to update Out-Time', 'error');
        }
    });
}

// ==================== DOCUMENT READY ====================
$(document).ready(function() {
    const today = new Date().toISOString().split('T')[0];
    
    if (!$("#Date").val()) {
        $("#Date").val(today);
    }

    function loadLibraryDepartments() {
        return $.ajax({
            url: baseURL + 'admin/Library_IN_Out/getLibraryDepartments',
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    libraryDepartments = response.data;
                    console.log('✅ Library Departments loaded:', libraryDepartments);
                    
                    let dropdownOptions = '<option value="">-- Select Library Dept --</option>';
                    if (libraryDepartments && libraryDepartments.length > 0) {
                        libraryDepartments.forEach(dept => {
                            dropdownOptions += `<option value="${dept.Libdep_id}">${dept.LibDep_Name}</option>`;
                        });
                    }
                    $('.libdept-dropdown').html(dropdownOptions);
                } else {
                    console.error('❌ Error loading departments:', response.message);
                    libraryDepartments = [];
                }
            },
            error: function(xhr, status, error) {
                console.error('❌ Failed to load library departments:', error);
                libraryDepartments = [];
            }
        });
    }

    loadLibraryDepartments().done(function() {
        loadTodayEntries();
        setTimeout(function() {
            $("#cardNoInput").focus();
        }, 100);
    });

    $("#Date").on('change', function() {
        loadTodayEntries();
    });

    // ==================== CARD INPUT HANDLER ====================
    $(document).on('keypress', '.card-input', function (e) {
        if (e.key === 'Enter' || e.keyCode === 13 || e.which === 13) {
            e.preventDefault();
            e.stopPropagation();

            let $input = $(this);
            let cardNo = $input.val().trim();

            if (cardNo === "") {
                $input.blur();
                Swal.fire({
                    icon: 'warning',
                    title: 'Empty Field',
                    text: 'Please enter card number first!',
                    timer: 2000
                });
                return;
            }

            const currentDate = $("#Date").val();
            
            if (!currentDate) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Date Missing',
                    text: 'Please select date first!',
                    timer: 2000
                });
                return;
            }

            $input.css('border-color', '#007bff');
            $input.prop('disabled', true);

            $.ajax({
                url: baseURL + 'admin/Library_IN_Out/getStudentByCard',
                type: 'POST',
                data: { 
                    card_no: cardNo,
                    date: currentDate
                },
                dataType: 'json',
                timeout: 10000,
                success: function (res) {
                    if (res.status === "success" && res.data) {
                        
                        $("input[name='Name[]']").val(res.data.Name || '');
                        $("input[name='Class[]']").val(res.data.Class || '');
                        $("input[name='Department[]']").val(res.data.Department || '');
                        
                        if (res.has_pending === true) {
                            console.log('🟡 Pending entry detected:', res.data);
                            
                            $("#WorkingType").val(res.data.WorkingType || '');
                            $("select[name='fkLibDept_id[]']").val(res.data.fkLibDept_id || '');
                            $("select[name='fkLibDept_id[]']").prop('disabled', true);
                            $("input[name='In_Time[]']").val(res.data.In_Time || '');
                            $("input[name='In_Time[]']").prop('readonly', true);
                            $("input[name='library_ID[]']").val(res.data.library_ID || '');
                            $('.out-time-input').val(getCurrentTime());
                            
                            $input.css('border-color', '#ffc107');
                            
                            Swal.fire({
                                icon: 'info',
                                title: '⏳ Pending Out-Time Found!',
                                html: `
                                    <div class="text-start">
                                        <p><strong>Name:</strong> ${res.data.Name}</p>
                                        <p><strong>Working Type:</strong> ${res.data.WorkingType || 'N/A'}</p>
                                        <p><strong>Library Dept:</strong> ${res.data.LibDep_Name}</p>
                                        <p><strong>In-Time:</strong> ${convertTo12Hour(res.data.In_Time)}</p>
                                        <hr>
                                        <p class="text-warning"><i class="fa-solid fa-clock"></i> Out-Time is pending for this entry.</p>
                                        <p class="text-success">Please enter Out-Time now.</p>
                                    </div>
                                `,
                                showConfirmButton: true,
                                confirmButtonText: 'OK, Enter Out-Time',
                                allowOutsideClick: false
                            }).then(() => {
                                setTimeout(() => {
                                    $('.out-time-input').focus().select();
                                }, 200);
                            });
                            
                        } else {
                            console.log('✅ No pending entry - new entry mode');
                            
                            $("input[name='library_ID[]']").val('');
                            $("select[name='fkLibDept_id[]']").prop('disabled', false);
                            $("input[name='In_Time[]']").prop('readonly', false);
                            
                            $input.css('border-color', '#28a745');
                            
                            setTimeout(() => {
                                $("#WorkingType").focus().select();
                                $input.css('border-color', '');
                            }, 500);
                        }
                        
                    } else {
                        $("input[name='Name[]']").val('');
                        $("input[name='Class[]']").val('');
                        $("input[name='Department[]']").val('');
                        $("#WorkingType").val('');
                        $("select[name='fkLibDept_id[]']").val('');
                        $("input[name='library_ID[]']").val('');
                        
                        $input.css('border-color', '#ffc107');
                        $input.blur();
                        
                        Swal.fire({
                            icon: 'warning',
                            title: 'Not Found',
                            text: res.message || 'Card number not found',
                            timer: 2000
                        }).then(() => {
                            $input.focus();
                        });

                        setTimeout(() => {
                            $input.css('border-color', '');
                        }, 2000);
                    }
                },
                error: function (xhr, status, err) {
                    $input.css('border-color', '#dc3545');
                    $input.blur();
                    
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Failed to fetch data',
                        timer: 2000
                    }).then(() => {
                        $input.focus();
                    });

                    setTimeout(() => {
                        $input.css('border-color', '');
                    }, 2000);
                },
                complete: function () {
                    $input.prop('disabled', false);
                }
            });
        }
    });

    // ==================== WORKING TYPE INPUT HANDLER ====================
    $(document).on('keydown', '#WorkingType', function(e) {
        if (e.key === 'Enter' || e.keyCode === 13 || e.which === 13) {
            e.preventDefault();
            
            let workingType = $(this).val().trim();
            
            if (!workingType || workingType === '') {
                Swal.fire({
                    icon: 'warning',
                    title: 'Working Type Required',
                    text: 'Please enter Working Type!',
                    timer: 2000
                });
                return;
            }
            
            setTimeout(() => {
                $('.libdept-dropdown').focus();
            }, 100);
        }
    });

    // ==================== LIBRARY DEPARTMENT HANDLERS ====================
    $(document).on('focus', '.libdept-dropdown', function() {
        const dropdown = this;
        if (dropdown.showPicker) {
            dropdown.showPicker();
        } else {
            $(dropdown).trigger('mousedown');
        }
    });

    $(document).on('keydown', '.libdept-dropdown', function(e) {
        if (e.key === 'Enter' || e.keyCode === 13 || e.which === 13) {
            e.preventDefault();
            
            let selectedValue = $(this).val();
            
            if (!selectedValue || selectedValue === '') {
                Swal.fire({
                    icon: 'warning',
                    title: 'Selection Required',
                    text: 'Please select a Library Department!',
                    timer: 2000
                });
                return;
            }
            
            $('.in-time-input').val(getCurrentTime());
            
            setTimeout(() => {
                $('.in-time-input').focus();
            }, 100);
        }
    });

    // ==================== IN-TIME HANDLER ====================
    $(document).on('keydown', '.in-time-input', function(e) {
        if (e.key === 'Enter' || e.keyCode === 13 || e.which === 13) {
            e.preventDefault();
            e.stopPropagation();
            
            let inTime = $(this).val();
            
            if (!inTime || inTime === '') {
                Swal.fire({
                    icon: 'warning',
                    title: 'Time Required',
                    text: 'Please enter In-Time!',
                    timer: 2000
                });
                return;
            }
            
            $('.in-time-input').blur();
            
            Swal.fire({
                title: 'Save Entry?',
                text: 'Do you want to save In-Time now?',
                icon: 'question',
                showCancelButton: true,
                showDenyButton: true,
                confirmButtonText: 'Enter Out-Time First',
                denyButtonText: 'Yes, Save In-Time',
                cancelButtonText: 'Cancel',
                reverseButtons: false
            }).then((result) => {
                if (result.isConfirmed) {
                    $('.out-time-input').val(getCurrentTime());
                    setTimeout(() => {
                        $('.out-time-input').focus().select();
                    }, 200);
                } else if (result.isDenied) {
                    saveEntry('in_only');
                } else {
                    setTimeout(() => {
                        $('.in-time-input').focus();
                    }, 200);
                }
            });
        }
    });

    // ==================== OUT-TIME HANDLER ====================
    $(document).on('keydown', '.out-time-input', function(e) {
        if (e.key === 'Enter' || e.keyCode === 13 || e.which === 13) {
            e.preventDefault();
            
            let outTime = $(this).val();
            
            if (!outTime || outTime === '') {
                Swal.fire({
                    icon: 'warning',
                    title: 'Time Required',
                    text: 'Please enter Out-Time!',
                    timer: 2000
                });
                return;
            }
            
            const calculated = calculateHours();
            
            if (!calculated) {
                $('.out-time-input').focus().select();
                return;
            }
            
            setTimeout(() => {
                saveEntry('complete');
            }, 300);
        }
    });

    $(document).on('change', '.in-time-input, .out-time-input', function() {
        calculateHours();
    });

    $(document).on("click", ".clearRow", function() {
        Swal.fire({
            title: 'Clear Current Entry?',
            text: 'This will clear all fields in the form',
            icon: 'question',
            showCancelButton: true,
            confirmButtonText: 'Yes, clear it',
            cancelButtonText: 'No, keep it'
        }).then((result) => {
            if (result.isConfirmed) {
                resetForm();
                $('#cardNoInput').focus();
            }
        });
    });

    // ==================== CLICK ON SAVED ENTRY ====================
    $(document).on('click', '#displayTableBody tr.saved-entry', function() {
        const row = $(this);
        const statusBadge = row.find('.badge.bg-warning');
        
        if (statusBadge.length === 0) {
            Swal.fire({
                icon: 'info',
                title: 'Already Complete',
                text: 'This entry already has Out-Time recorded',
                timer: 2000
            });
            return;
        }
        
        const cardNo = row.find('td:eq(2) strong').text().trim();
        const name = row.find('td:eq(3)').text().trim();
        const dateFormatted = row.find('td:eq(1) .badge').text().trim();
        const workingType = row.find('td:eq(6) .badge').text().trim();
        const libDeptText = row.find('td:eq(7) .badge').text().trim();
        const inTime12 = row.find('td:eq(8) .badge').text().trim();
        const inTime24 = row.data('intime');
        const libDeptId = row.data('libdept');
        
        Swal.fire({
            title: 'Update Out-Time',
            html: `
                <div class="text-start">
                    <p><strong>Date:</strong> ${dateFormatted}</p>
                    <p><strong>Card:</strong> ${cardNo}</p>
                    <p><strong>Name:</strong> ${name}</p>
                    <p><strong>Working Type:</strong> ${workingType}</p>
                    <p><strong>Library Dept:</strong> ${libDeptText}</p>
                    <p><strong>In-Time:</strong> ${inTime12}</p>
                    <hr>
                    <label class="form-label">Enter Out-Time:</label>
                    <input type="time" id="swal-out-time" class="form-control" value="${getCurrentTime()}">
                </div>
            `,
            icon: 'question',
            showCancelButton: true,
            confirmButtonText: 'Update Out-Time',
            cancelButtonText: 'Cancel',
            didOpen: () => {
                setTimeout(() => {
                    const outTimeInput = document.getElementById('swal-out-time');
                    if (outTimeInput) {
                        outTimeInput.focus();
                        outTimeInput.select();
                    }
                }, 100);
            },
            preConfirm: () => {
                const outTime = document.getElementById('swal-out-time').value;
                if (!outTime) {
                    Swal.showValidationMessage('Please enter Out-Time');
                    return false;
                }
                return outTime;
            }
        }).then((result) => {
            if (result.isConfirmed) {
                const outTime = result.value;
                const hours = calculateHoursDiff(inTime24, outTime);
                
                if (hours === null) {
                    Swal.fire('Error', 'Out-Time must be after In-Time', 'error');
                    return;
                }
                
                updateExistingEntry(cardNo, libDeptId, inTime24, outTime, hours);
            }
        });
    });
});
</script>