<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<!-- <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css"> -->

<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1">Library Report</div>
                    </div>
                    <div class="card-body">
                        <form role="form" id="scholarshipFilterForm">
                            <div class="row gutters">
                                <!-- Branch Filter -->
                               <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
    <div class="field-wrapper">
        <select class="select-single js-states" id="fkbranch_id" name="fkbranch_id[]" multiple="multiple">
            <?php foreach($branchList as $branch): ?>
                <option value="<?= $branch->branch_name ?>"><?= $branch->branch_name ?></option>
            <?php endforeach; ?>
        </select>
        <div class="field-placeholder">Department</div>
    </div>
</div>

                                <!-- Scholarship Level Filter -->
                                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <div class="field-wrapper">
                                        <select class="select-single js-states" id="fkCardType" name="fkCardType[]" multiple="multiple">
                                            <?php foreach($CardList as $level): ?>
                                                <option value="<?= $level->mainuser_id ?>"><?= $level->mainuser_name ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Card Type</div>
                                    </div>
                                </div>

                                <!-- Caste Filter -->
                                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <div class="field-wrapper">
                                        <select class="select-single js-states" id="fkLibDept_id" name="fkLibDept_id[]" multiple="multiple">
                                            <?php foreach($LibDeptList as $caste): ?>
                                                <option value="<?= $caste->Libdep_id ?>"><?= $caste->LibDep_Name ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Library Department</div>
                                    </div>
                                </div>

                                <!-- Year Filter -->
                                <div class="col-md-3">
                                    <div class="field-wrapper">
                                        <select class="select-single js-states" name="year_id[]" id="year_id" multiple="multiple">
                                            <?php foreach($yearList as $year): ?>
                                                <option value="<?= $year->finiYear_id ?>"><?= $year->fini_Label ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Financial Year</div>
                                    </div>
                                </div>

                                <!-- Search Button -->
                               
                            </div>
<div class="row">
                            

                            
                                         <div class="col-md-9 d-flex">
    <a class="mx-4" href="javascript:void(0)" onclick="toggleSection('datewise')" style="text-decoration:underline !important; color: #0d6efd;font-size: 14px;">
        <i class="fa-solid fa-calendar-days me-2"></i>DateWise
    </a>
 
    <div id="datewise_section" class=" row d-none mt-2">
        <div class="col-md-6 mb-3">
            <!-- <label>From Date</label> -->
            <div class="field-wrapper">
                <div class="field-placeholder">From Date</div>
            <input type="date" class="form-control" id="startdate" name="startdate">
            </div>
        </div>
        <div class="col-md-6 mb-3">
           <div class="field-wrapper">
            <div class="field-placeholder">To Date</div>
            <input type="date" class="form-control" id="enddate" name="enddate">
           </div>
             
        </div>
    </div>
        <div class="col-md-3 mt-2">
 <button class="btn btn-success btn-sm m-1 " type="button" id="btnShow" style="padding: px 10px;font-size: 13px; font-weight:600;">
    <i class="fas fa-search"></i> Show Data
</button>
 <!-- <button class="btn btn-danger btn-sm" onclick="printTable()"><i class="fas fa-print"></i> Print</button>
<button class="btn btn-warning btn-sm" onclick="exportToExcel()"><i class="fas fa-file-excel"></i>Excel</button> -->
        </div>
 </div>

 <script>
function toggleSection(type) {
    if (type === 'datewise') {
        document.getElementById('datewise_section').classList.toggle('d-none');
    }
}
</script>
                                <!-- Action Buttons -->
                               
                                <div class="row">
                                            <div class="col-md-12 text-right">
                                                <button class="btn btn-danger btn-sm rounded-3" type="button" onclick="printTable()"><i class="fas fa-print bg-white p-1 rounded-circle text-danger shadow-lg" style=" box-shadow: 4px 6px 12px rgba(0, 0, 0, 0.5) !important;"></i> Print</button>
                                                 <!-- <button type="button" class="btn btn-danger btn-sm mx-1" onclick="printTable()" ><i class="fas fa-print"></i>Print</button> -->
<button type="button" class="btn btn-success btn-sm rounded-3" onclick="exportToExcel()"><i class="fas fa-file-excel bg-white p-1 rounded-circle text-success shadow-lg" style=" box-shadow: 4px 6px 12px rgba(0, 0, 0, 0.5) !important;"></i>Excel</button>
 <button type="button" class="btn btn-dark btn-sm rounded-3" type="button" onclick="window.location.href='<?= base_url() ?>admin/Library/dashboard'"><i class="fa-solid fa-home bg-white p-1 rounded-circle text-dark shadow-lg" ></i>Home</button>
                                            </div>
                                        </div>

                                           

                            <!-- Data Table -->
                            <div class="table-responsive mt-3" id="printableTable">
                                <table id="leavetable" class="table custom-table">
                                    <thead style="background-color: #0d40a9;">
    <tr>
        <th>Sr.No.</th>
        <th>Student/Faculty</th>
        <th>Card Number</th>
        <th>Department</th>
        <th>Class</th>
        <th>Card Type</th>
        <th>Library Department</th>
        <th>Date</th>
        <th>In Time</th>
        <th>Out Time</th>
        <th>Hours</th>
        <th>Year</th>
    </tr>
</thead>
<tbody>
    <tr>
        <td colspan="12" class="text-center">Please select filters and click Search</td>
    </tr>
</tbody>

                                </table>
                            </div>

                            <hr>

                            <!-- Graphical Report Section -->
                            <div class="row mb-3">
                                <div class="col-md-12 d-flex align-items-center">
                                    <button type="button" class="btn btn-sm btn-primary me-2" onclick="toggleFilterSection()">
                                        <i class="fas fa-filter shadow-lg"></i> Graphical Report
                                    </button>
                                </div>
                            </div>

                            <!-- Charts Filter Section -->
                             <div id="filterSectionNew">
                  <div id="filterSection" class="card mb-3 p-3" style="display:none;">
    <div class="row align-items-center">
        <div class="col-md-4">
            <div class="field-wrapper">
                <select class="select-single js-states" id="branchwise_dropdown" name="branchwise_dropdown[]" multiple="multiple">
                    <?php foreach($branchList as $branch): ?>
                        <option value="<?= $branch->branch_name ?>"><?= $branch->branch_name ?></option>
                    <?php endforeach; ?>
                </select>
                <div class="field-placeholder">Department</div>
            </div>
        </div>

                                    <div class="col-md-4">
                                        <div class="field-wrapper">
                                            <select class="select-single js-states" id="year_chart_id" name="year_chart_id[]" multiple="multiple">
                                                <?php foreach($yearList as $year): ?>
                                                    <option value="<?= $year->finiYear_id ?>"><?= $year->fini_Label ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <div class="field-placeholder">Year</div>
                                        </div>
                                    </div>

                                    <div class="col-md-4 d-flex mb-2 align-items-center">
                                        <button type="button" class="btn btn-success me-2 custom-gradient-btn" id="searchChartBtn">
                                            <i class="fas fa-search me-1"></i> Search
                                        </button>
                                        <button type="button" class="btn btn-danger custom-gradient-btn bg-danger" onclick="printCombinedChart()">
                                            <i class="fas fa-print me-1 bg-white p-1 rounded-circle text-danger shadow-lg"></i> Print
                                        </button>
                                    </div>
                                </div>
                            </div>

                            <!-- Charts Row -->

                            <div id="chartLoader" style="display:none; text-align:center; margin:20px 0;">
    <div class="spinner-border text-primary"></div>
    <p>Loading charts...</p>
</div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="card p-3 text-center">
                                        <h5>Branchwise Chart</h5>
                                        <div style="height:250px; width:100%;">
                                            <canvas id="branchChart"></canvas>
                                            <div id="branchDetails"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="card p-3 text-center">
                                        <h5>Yearwise Chart</h5>
                                        <div style="height:250px;">
                                            <canvas id="yearChart"></canvas>
                                            <div id="yearDetails"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="<?php echo base_url();?>Assets/js/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    $(document).ready(function() {
    // Initialize Select2 for all dropdowns
    $('.js-states').select2({
        placeholder: "Select options",
        allowClear: true
    });

    // Set default active year (but don't auto-load data)
    <?php if(isset($activeYear) && $activeYear): ?>
    var activeYearId = '<?= $activeYear->finiYear_id ?>';
    
    // Pre-select active year in both year dropdowns
    $('#year_id').val([activeYearId]).trigger('change');
    $('#year_chart_id').val([activeYearId]).trigger('change');
    <?php endif; ?>

    // Clear date fields when year is changed
    $('#year_id').on('change', function() {
        // Clear the date input fields
        $('#startdate').val('');
        $('#enddate').val('');
    });

    // Also clear dates when chart year changes
    $('#year_chart_id').on('change', function() {
        $('#startdate').val('');
        $('#enddate').val('');
    });

    // Search button click handler
    $("#btnShow").click(function() {
        loadLibraryData();
    });

    // Chart search button
    $("#searchChartBtn").click(function() {
        loadChartData();
    });
});

// Alternative: If you want to clear dates AND show a message
$('#year_id').on('select2:select select2:unselect', function() {
    $('#startdate').val('');
    $('#enddate').val('');
    console.log('Date fields cleared due to year selection change');
});


// Load library data based on filters
// Convert date from yyyy-mm-dd to dd-mm-yyyy format
function formatDate(dateString) {
    if (!dateString || dateString === '-') return '-';
    
    // Check if date is already in dd-mm-yyyy format
    if (dateString.includes('-') && dateString.split('-')[0].length <= 2) {
        return dateString;
    }
    
    const date = new Date(dateString);
    if (isNaN(date.getTime())) return dateString; // Return original if invalid
    
    const day = String(date.getDate()).padStart(2, '0');
    const month = String(date.getMonth() + 1).padStart(2, '0');
    const year = date.getFullYear();
    
    return `${day}-${month}-${year}`;
}

// Convert time from 24-hour to 12-hour format
function formatTime(timeString) {
    if (!timeString || timeString === '-' || timeString === '00:00:00') return '-';
    
    // Extract hours and minutes from time string (HH:MM:SS or HH:MM)
    const timeParts = timeString.split(':');
    if (timeParts.length < 2) return timeString;
    
    let hours = parseInt(timeParts[0]);
    const minutes = timeParts[1];
    
    if (isNaN(hours)) return timeString;
    
    const period = hours >= 12 ? 'PM' : 'AM';
    hours = hours % 12 || 12; // Convert to 12-hour format, 0 becomes 12
    
    return `${hours}:${minutes} ${period}`;
}

// Update the loadLibraryData function tbody generation section:
function loadLibraryData() {
    var yearIds = $("#year_id").val();
    var startDate = $("#startdate").val();
    var endDate = $("#enddate").val();
    
    if (startDate && endDate && startDate > endDate) {
        Swal.fire("Validation Error", "Start date cannot be after end date!", "error");
        return;
    }
    
    var formData = {
        branch_ids: $("#fkbranch_id").val(),
        card_type_ids: $("#fkCardType").val(),
        dept_ids: $("#fkLibDept_id").val(),
        year_ids: yearIds,
        startdate: startDate,
        enddate: endDate
    };

    $("#leavetable tbody").html(
        '<tr><td colspan="12" class="text-center"><div class="spinner-border text-primary"></div><p>Loading data...</p></td></tr>'
    );

    $.ajax({
        url: "<?= base_url('admin/Library_Report/getLibraryData') ?>",
        type: "POST",
        data: formData,
        dataType: "json",
        success: function(response) {
            var tbody = "";
            if (response.length > 0) {
                $.each(response, function(index, row) {
                    tbody += `
                        <tr>
                            <td>${index + 1}</td>
                            <td>${row.student_name || '-'}</td>
                            <td>${row.card_number || '-'}</td>
                            <td>${row.branch_name || '-'}</td>
                            <td>${row.Class || '-'}</td>
                            <td>${row.card_type || '-'}</td>
                            <td>${row.LibDep_Name || '-'}</td>
                            <td>${formatDate(row.latest_library_date || row.Date)}</td>
                            <td>${formatTime(row.In_Time)}</td>
                            <td>${formatTime(row.Out_Time)}</td>
                            <td>${row.Hours || '-'}</td>
                            <td>${row.year_label || '-'}</td>
                        </tr>
                    `;
                });
            } else {
                tbody = '<tr><td colspan="12" class="text-center text-warning">No data found for selected filters</td></tr>';
            }
            $("#leavetable tbody").html(tbody);
        },
        error: function(xhr, status, error) {
            console.error('AJAX Error:', error);
            Swal.fire("Error", "Failed to load data!", "error");
            $("#leavetable tbody").html(
                '<tr><td colspan="12" class="text-center text-danger">Error loading data</td></tr>'
            );
        }
    });
}

// Toggle filter section
function toggleFilterSection() {
    $("#filterSection").slideToggle();
}

// Chart variables
let branchChart = null;
let yearChart = null;

// Load chart data
function loadChartData() {
    let selectedDepts = $("#branchwise_dropdown").val();
    let selectedYears = $("#year_chart_id").val();
    
    console.log('Chart Filters - Depts:', selectedDepts, 'Years:', selectedYears);

    $.ajax({
        url: "<?= base_url('admin/Library_Report/getCombinedChartData') ?>",
        type: "POST",
        data: {
            branches: selectedDepts,  // Using branches param but it's actually departments
            years: selectedYears
        },
        dataType: "json",
        success: function(response) {
            console.log('Chart Response:', response);
            
            if (response.status === "success") {
                renderBranchChart({
                    labels: response.branchData.map(b => b.dept_name),
                    values: response.branchData.map(b => b.library_count),
                    ids: response.branchData.map(b => b.dept_id)
                });

                renderYearChart({
                    labels: response.yearData.map(y => y.year),
                    values: response.yearData.map(y => y.count),
                    ids: response.yearData.map(y => y.year_id)
                });

                $("#branchDetails").html("");
                $("#yearDetails").html("");
            }
        },
        error: function(xhr, status, error) {
            console.error("Chart AJAX Error:", error);
            console.error('Response:', xhr.responseText);
            Swal.fire("Error", "Failed to load chart data!", "error");
        }
    });
}

// Render branch chart
function renderBranchChart(data) {
    const ctx = document.getElementById("branchChart").getContext("2d");
    
    if (branchChart) {
        branchChart.destroy();
    }

    branchChart = new Chart(ctx, {
        type: "pie",
        data: {
            labels: data.labels,
            datasets: [{
                data: data.values,
                backgroundColor: [
                    '#FF6384', '#36A2EB', '#FFCE56', '#4BC0C0',
                    '#9966FF', '#FF9F40', '#FF6384', '#C9CBCF',
                    '#E7E9ED', '#4BC0C0'
                ],
                borderWidth: 1,
                borderColor: '#fff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 10,
                        font: {
                            size: 11
                        }
                    }
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return context.label + ': ' + context.parsed + ' records';
                        }
                    }
                }
            },
            onClick: function(event, elements) {
                if (elements.length > 0) {
                    const idx = elements[0].index;
                    const branchName = data.labels[idx];
                    const recordCount = data.values[idx];
                    console.log('Clicked:', branchName, 'Count:', recordCount);
                    loadBranchDetails(branchName, branchName);
                }
            }
        }
    });
}


// Render year chart
function renderYearChart(data) {
    const ctx = document.getElementById("yearChart").getContext("2d");
    
    if (yearChart) {
        yearChart.destroy();
    }

    yearChart = new Chart(ctx, {
        type: "bar",
        data: {
            labels: data.labels,
            datasets: [{
                label: 'Library Records',
                data: data.values,
                backgroundColor: "rgba(18,115,235,0.7)",
                borderColor: "rgba(18,115,235,1)",
                borderWidth: 2,
                borderRadius: 5
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: true,
                    position: 'top'
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return 'Records: ' + context.parsed.y;
                        }
                    }
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        stepSize: 1,
                        callback: function(value) {
                            return Number.isInteger(value) ? value : '';
                        }
                    }
                },
                x: {
                    ticks: {
                        font: {
                            size: 11
                        }
                    }
                }
            },
            onClick: function(event, elements) {
                if (elements.length > 0) {
                    const idx = elements[0].index;
                    const yearId = data.ids[idx];
                    const yearLabel = data.labels[idx];
                    loadYearDetails(yearId, yearLabel);
                }
            }
        }
    });
}

// Updated render branch chart to pass department name instead of ID
function renderBranchChart(data) {
    const ctx = document.getElementById("branchChart").getContext("2d");
    if (branchChart) branchChart.destroy();

    branchChart = new Chart(ctx, {
        type: "pie",
        data: {
            labels: data.labels,
            datasets: [{
                data: data.values,
                backgroundColor: [
                    '#FF6384', '#36A2EB', '#FFCE56', '#4BC0C0',
                    '#9966FF', '#FF9F40', '#FF6384', '#C9CBCF'
                ],
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return context.label + ': ' + context.parsed + ' records';
                        }
                    }
                }
            },
            onClick: function(event, elements) {
                if (elements.length > 0) {
                    const idx = elements[0].index;
                    const branchName = data.labels[idx];  // Use department name directly
                    const recordCount = data.values[idx];
                    console.log('Clicked:', branchName, 'Count:', recordCount);
                    loadBranchDetails(branchName, branchName);
                }
            }
        }
    });
}

function loadChartData() {
    let selectedDepts = $("#branchwise_dropdown").val();
    let selectedYears = $("#year_chart_id").val();
    
    // Show loader and hide charts
    $("#chartLoader").show();
    $("#branchChart").parent().parent().hide();
    $("#yearChart").parent().parent().hide();
    $("#branchDetails").html("");
    $("#yearDetails").html("");
    
    console.log('=== CHART DATA REQUEST ===');
    console.log('Selected Departments:', selectedDepts);
    console.log('Selected Years:', selectedYears);

    $.ajax({
        url: "<?= base_url('admin/Library_Report/getCombinedChartData') ?>",
        type: "POST",
        data: {
            branches: selectedDepts,
            years: selectedYears
        },
        dataType: "json",
        
        beforeSend: function() {
            $("#chartLoader").html(`
                <div class="spinner-border text-primary"></div>
                <p>Please wait, loading charts...</p>
            `);
        },
        
        success: function(response) {
            console.log('=== CHART RESPONSE ===');
            console.log('Full Response:', response);
            
            if (response.status === "success") {
                // Log each branch data
                response.branchData.forEach((branch, idx) => {
                    console.log(`Branch ${idx}: ${branch.dept_name} = ${branch.library_count} records`);
                });
                
                renderBranchChart({
                    labels: response.branchData.map(b => b.dept_name),
                    values: response.branchData.map(b => b.library_count),
                    ids: response.branchData.map(b => b.dept_name)
                });

                renderYearChart({
                    labels: response.yearData.map(y => y.year),
                    values: response.yearData.map(y => y.count),
                    ids: response.yearData.map(y => y.year_id)
                });

                // Show charts after rendering
                $("#branchChart").parent().parent().show();
                $("#yearChart").parent().parent().show();
                
                $("#branchDetails").html("");
                $("#yearDetails").html("");
            } else {
                Swal.fire("No Data", "No data found for selected filters!", "info");
            }
        },
        
        error: function(xhr, status, error) {
            console.error("Chart AJAX Error:", error);
            console.error('Response:', xhr.responseText);
            Swal.fire("Error", "Failed to load chart data!", "error");
        },
        
        complete: function() {
            // Hide loader after everything is done
            $("#chartLoader").hide();
        }
    });
}
// Enhanced branch details loading with debugging
function loadBranchDetails(branchId, branchName) {
    var selectedYears = $("#year_chart_id").val();
    
    console.log('=== BRANCH DETAILS REQUEST ===');
    console.log('Branch Name:', branchName);
    console.log('Years Filter:', selectedYears);
    
    $.ajax({
        url: "<?= base_url('admin/Library_Report/getBranchDetailsData') ?>",
        type: "POST",
        data: {
            branch_id: branchId,
            years: selectedYears
        },
        dataType: "json",
        beforeSend: function() {
            $("#branchDetails").html(`<div class="text-center"><div class="spinner-border text-primary"></div><p>Loading ${branchName} details...</p></div>`);
        },
        success: function(data) {
            console.log('=== BRANCH DETAILS RESPONSE ===');
            console.log('Records Received:', data.length);
            console.log('Data:', data);
            
            // Log each record's year
            data.forEach((record, idx) => {
                console.log(`Record ${idx + 1}: ${record.student_name} - Year: ${record.year_label}`);
            });
            
            populateBranchTable(data, branchName);
        },
        error: function(xhr, status, error) {
            console.error('Error:', error);
            console.error('Response:', xhr.responseText);
            $("#branchDetails").html(`<p class="text-danger">Error loading ${branchName} data.</p>`);
        }
    });
}

// Populate branch table
function populateBranchTable(data, branchName) {
    let html = `
        <div class="card mt-3">
            <div class="card-header bg-primary text-white"><h5>${branchName} - Library Details</h5></div>
            <div class="card-body year">
                <table class="table table-bordered">
                    <thead>
                        <tr class="head">
                            <th style="color:black !important;">Sr.No</th>
                            <th style="color:black !important;">Student Name</th>
                            <th style="color:black !important;">Card No</th>
                            <th style="color:black !important;">Class</th>
                            <th style="color:black !important;">Department</th>
                            <th style="color:black !important;">Card Type</th>
                            <th style="color:black !important;">In Time</th>
                            <th style="color:black !important;">Out Time</th>
                            <th style="color:black !important;">Hours</th>
                            <th style="color:black !important;">Year</th>
                        </tr>
                    </thead>
                    <tbody>`;
    
    if (data.length > 0) {
        data.forEach((row, i) => {
            html += `<tr>
                        <td>${i + 1}</td>
                        <td>${row.student_name || '-'}</td>
                        <td>${row.CardNo || '-'}</td>
                        <td>${row.Class || '-'}</td>
                        <td>${row.Department || '-'}</td>
                        <td>${row.card_type || '-'}</td>
                        <td>${formatTime(row.In_Time)}</td>
                        <td>${formatTime(row.Out_Time)}</td>
                        <td>${row.Hours || '-'}</td>
                        <td>${row.year_label || '-'}</td>
                     </tr>`;
        });
    } else {
        html += `<tr><td colspan="10" class="text-center">No records found</td></tr>`;
    }
    
    html += `</tbody></table></div></div>`;
    $("#branchDetails").html(html);
}
// // Load year details
function loadYearDetails(yearId, yearLabel) {
    $.ajax({
        url: "<?= base_url('admin/Library_Report/getYearDetailsData') ?>",
        type: "POST",
        data: {
            year_id: yearId,
            branches: $("#branchwise_dropdown").val()
        },
        dataType: "json",
        beforeSend: function() {
            $("#yearDetails").html(`<div class="text-center"><div class="spinner-border text-success"></div><p>Loading ${yearLabel} details...</p></div>`);
        },
        success: function(response) {
            if (response.status === "success") {
                populateYearTable(response.data, yearLabel);
            } else {
                $("#yearDetails").html(`<p class="text-danger">No data for ${yearLabel}</p>`);
            }
        },
        error: function() {
            $("#yearDetails").html(`<p class="text-danger">Error loading ${yearLabel} data.</p>`);
        }
    });
}

// Populate year table
function populateYearTable(data, yearLabel) {
    let html = `
        <div class="card mt-3">
            <div class="card-header bg-success text-white"><h5>${yearLabel} - Library Details</h5></div>
            <div class="card-body year">
                <table class="table table-bordered">
                    <thead>
                        <tr class="head">
                            <th style="color:black !important;">Sr.No</th>
                            <th style="color:black !important;">Student Name</th>
                            <th style="color:black !important;">Card No</th>
                            <th style="color:black !important;">Class</th>
                            <th style="color:black !important;">Department</th>
                            <th style="color:black !important;">Card Type</th>
                            <th style="color:black !important;">In Time</th>
                            <th style="color:black !important;">Out Time</th>
                            <th style="color:black !important;">Hours</th>
                        </tr>
                    </thead>
                    <tbody>`;
    
    if (data.length > 0) {
        data.forEach((row, i) => {
            html += `<tr>
                        <td>${i + 1}</td>
                        <td>${row.student_name || '-'}</td>
                        <td>${row.CardNo || '-'}</td>
                        <td>${row.Class || '-'}</td>
                        <td>${row.Department || '-'}</td>
                        <td>${row.card_type || '-'}</td>
                        <td>${formatTime(row.In_Time)}</td>
                        <td>${formatTime(row.Out_Time)}</td>
                        <td>${row.Hours || '-'}</td>
                     </tr>`;
        });
    } else {
        html += `<tr><td colspan="9" class="text-center">No records found</td></tr>`;
    }
    
    html += `</tbody></table></div></div>`;
    $("#yearDetails").html(html);
}

// Print table function
function printTable() {
    const printElement = document.getElementById('printableTable');
    
    $.ajax({
        url: '<?= base_url("admin/Library_Report/getPrintHeadings") ?>',
        method: 'GET',
        dataType: 'json',
        success: function(heading) {
            const iframe = document.createElement('iframe');
            iframe.style.position = 'fixed';
            iframe.style.right = '0';
            iframe.style.bottom = '0';
            iframe.style.width = '0';
            iframe.style.height = '0';
            iframe.style.border = '0';
            document.body.appendChild(iframe);

            const doc = iframe.contentWindow.document;
            const baseUrl = '<?= base_url() ?>';
            let logoPath = heading.logo || 'Assets/images/sit_logo.png';
            logoPath = logoPath.replace(/^\/+/, '');
            const fullLogoPath = baseUrl + logoPath;

            doc.open();
            doc.write(`
                <html>
                <head>
                    <title>Print Library Report</title>
                    <style>
                        body { font-family: sans-serif; margin: 10px 5px; padding: 0; }
                        .header-section { display: flex; align-items: center; justify-content: center; gap: 10px; margin-bottom: 5px; }
                        .logo-container img { max-height: 80px; max-width: 80px; }
                        .heading-content { text-align: center; }
                        h4, h6 { margin: 0; padding: 0; }
                        h4 { font-size: 20px; font-weight: bold; color: #d32f2f; }
                        h6 { font-size: 14px; font-weight: normal; }
                        table { width: 100%; border-collapse: collapse; margin-top: 5px; table-layout: fixed; }
                        th, td { border: 1px solid black; padding: 6px 4px; text-align: center; vertical-align: middle; word-wrap: break-word; font-size: 12px; color:black; }
                        th { background-color: #1273eb !important; color: white !important; }
                    </style>
                </head>
                <body>
                    <div class="header-section">
                        <div class="logo-container">
                            <img src="${fullLogoPath}" alt="Logo" onerror="this.style.display='none';">
                        </div>
                        <div class="heading-content">
                            <h6>${heading.subHead1 || ''}</h6>
                            <h4>${heading.head || 'Library Report'}</h4>
                            <div>${heading.subHead2 || ''}</div>
                            <div>${heading.subHead3 || ''}</div>
                        </div>
                    </div>
                    <br>
                    ${printElement.outerHTML}
                </body>
                </html>
            `);
            doc.close();

            iframe.contentWindow.onload = function() {
                setTimeout(function() {
                    iframe.contentWindow.focus();
                    iframe.contentWindow.print();
                }, 500);
            };

            setTimeout(() => {
                document.body.removeChild(iframe);
            }, 3000);
        },
        error: function(xhr, status, error) {
            console.error('AJAX Error:', error);
            alert('Error loading print data: ' + error);
        }
    });
}

// Export to Excel function
function exportToExcel() {
    $.ajax({
        url: '<?= base_url("admin/Library_Report/getPrintHeadings") ?>',
        method: 'GET',
        dataType: 'json',
        success: function(heading) {
            var wb = XLSX.utils.book_new();
            var header = [
                [heading.subHead1 || ''],
                [heading.head || 'Library Report'],
                [heading.subHead2 || ''],
                [heading.subHead3 || ''],
                ['']
            ];
            
            var table = document.getElementById('printableTable');
            var wsTable = XLSX.utils.table_to_sheet(table);
            var tableData = XLSX.utils.sheet_to_json(wsTable, { header: 1 });
            var fullData = header.concat(tableData);
            var ws = XLSX.utils.aoa_to_sheet(fullData);
            
            XLSX.utils.book_append_sheet(wb, ws, 'Library Data');
            XLSX.writeFile(wb, 'Library_Report_' + new Date().toISOString().slice(0,10) + '.xlsx');
        }
    });
}

// Print combined chart
function printCombinedChart() {
    if (!branchChart || !yearChart) {
        Swal.fire("Warning", "Please generate charts first!", "warning");
        return;
    }

    const branchChartImg = branchChart.toBase64Image();
    const yearChartImg = yearChart.toBase64Image();
    const branchTable = document.getElementById("branchDetails").innerHTML;
    const yearTable = document.getElementById("yearDetails").innerHTML;

    let printFrame = document.getElementById('printFrame');
    if (printFrame) {
        printFrame.remove();
    }
    
    printFrame = document.createElement('iframe');
    printFrame.id = 'printFrame';
    printFrame.style.position = 'absolute';
    printFrame.style.width = '0';
    printFrame.style.height = '0';
    printFrame.style.border = 'none';
    
    document.body.appendChild(printFrame);
    
    const frameDoc = printFrame.contentWindow.document;
    frameDoc.open();
    frameDoc.write(`
        <!DOCTYPE html>
        <html>
        <head>
            <title>Library Charts & Tables Print</title>
            <style>
                @page { size: A4; margin: 15mm; }
                body { font-family: Arial, sans-serif; margin: 0; padding: 20px; }
                .chart-section { margin-bottom: 20px; }
                .chart-section h2 { font-size: 18px; margin-bottom: 15px; color: #000; }
                .table-section h3 { font-size: 14px; margin: 15px 0 10px 0; color: #000; }
                img { max-width: 100%; height: auto; display: block; margin-bottom: 15px; }
                table { width: 100%; border-collapse: collapse; margin-bottom: 20px; font-size: 11px; }
                th, td { border: 1px solid #333; padding: 6px 8px; text-align: left; color:black; }
                th { background: #f2f2f2; color: #000; font-weight: bold; }
                .page-break { page-break-before: always; }
            </style>
        </head>
        <body>
            <div class="chart-section">
                <h2>Branchwise Chart</h2>
                <img src="${branchChartImg}" alt="Branch Chart">
            </div>
            <div class="table-section">
                <h3>Library Details</h3>
                ${branchTable}
            </div>
            <div class="chart-section page-break">
                <h2>Yearwise Chart</h2>
                <img src="${yearChartImg}" alt="Year Chart">
            </div>
            <div class="table-section">
                <h3>Library Details</h3>
                ${yearTable}
            </div>
        </body>
        </html>
    `);
    frameDoc.close();
    
    setTimeout(() => {
        printFrame.contentWindow.focus();
        printFrame.contentWindow.print();
        setTimeout(() => {
            if (printFrame) {
                printFrame.remove();
            }
        }, 100);
    }, 500);
}

</script>
