
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">
    
    <style>
        /* General */
        body {
            font-family: 'Inter', 'Segoe UI', sans-serif;
            color: #1e293b;
            padding: 15px 0;
        }

        /* Floating particles background */
        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: radial-gradient(circle at 20% 50%, rgba(255,255,255,0.1) 0%, transparent 50%),
                        radial-gradient(circle at 80% 80%, rgba(255,255,255,0.1) 0%, transparent 50%);
            pointer-events: none;
            z-index: 0;
        }

        .container-fluid {
            position: relative;
            z-index: 1;
            /*max-width: 1400px; */
            margin: 0 auto;
        }

        /* Main Card */
        .main-card {
            border-radius: 20px;
            border: none;
            box-shadow: 0 20px 40px rgba(0,0,0,0.2);
            overflow: hidden;
            backdrop-filter: blur(10px);
            background: rgba(255,255,255,0.95);
            animation: slideUp 0.6s ease-out;
        }

        @keyframes slideUp {
            from { 
                opacity: 0; 
                transform: translateY(40px); 
            }
            to { 
                opacity: 1; 
                transform: translateY(0); 
            }
        }

        /* Header - Compact */
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: #fff;
            padding: 15px 20px;
            position: relative;
            overflow: hidden;
        }

        .header::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
            animation: rotate 20s linear infinite;
        }

        @keyframes rotate {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        .header-content {
            display: flex;
            align-items: center;
            gap: 15px;
            position: relative;
            z-index: 1;
        }

        .header-icon {
            width: 50px;
            height: 50px;
            background: rgba(255,255,255,0.2);
            border-radius: 14px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            backdrop-filter: blur(10px);
            animation: pulse 2s ease-in-out infinite;
        }

        @keyframes pulse {
            0%, 100% { 
                transform: scale(1);
                box-shadow: 0 0 0 0 rgba(255,255,255,0.4);
            }
            50% { 
                transform: scale(1.05);
                box-shadow: 0 0 0 10px rgba(255,255,255,0);
            }
        }

        .header h3 {
            font-size: 22px;
            font-weight: 700;
            margin: 0;
            letter-spacing: -0.5px;
        }

        .header p {
            margin: 0;
            opacity: 0.9;
            font-size: 13px;
        }

        /* Card Body - Compact */
        .card-body {
            padding: 15px 20px;
        }

        /* Top Section - Filter & Stats Side by Side */
        .top-section {
            display: grid;
            grid-template-columns: 500px 1fr;
            gap: 15px;
            margin-bottom: 15px;
            align-items: start;
        }

        /* Filter Card - Horizontal Compact */
        .filter-card {
            background: linear-gradient(135deg, rgba(102,126,234,0.05) 0%, rgba(118,75,162,0.05) 100%);
            border-radius: 14px;
            padding: 12px;
            border: 2px solid rgba(102,126,234,0.1);
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 8px;
            position: relative;
            overflow: hidden;
            height: 100%;
        }

        .filter-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(45deg, transparent 30%, rgba(255,255,255,0.3) 50%, transparent 70%);
            transform: translateX(-100%);
            transition: transform 0.6s;
        }

        .filter-card:hover::before {
            transform: translateX(100%);
        }

        .filter-group {
            flex: 1;
            width: 100%;
            position: relative;
            z-index: 1;
        }

        .button-group {
            display: flex;
            float: end;
            gap: 8px;
            margin-top: 5px;
        }

        .button-group button {
            flex: 1;
        }

        .filter-card label {
            font-size: 11px;
            font-weight: 600;
            color: #64748b;
            margin-bottom: 5px;
            display: block;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .filter-card .form-control {
            border-radius: 9px;
            height: 38px;
            font-size: 13px;
            border: 2px solid #e2e8f0;
            padding: 0 12px;
            transition: all 0.3s ease;
            background: white;
        }

        .filter-card .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102,126,234,0.1);
            transform: translateY(-2px);
        }

        /* Buttons - Compact */
        .btn-search, .btn-reset {
            height: 42px;
            border-radius: 10px;
            font-weight: 600;
            font-size: 14px;
            padding: 0 22px;
            border: none;
            display: flex;
            align-items: center;
            gap: 8px;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }

        .btn-search {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }

        .btn-search::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            border-radius: 50%;
            background: rgba(255,255,255,0.3);
            transform: translate(-50%, -50%);
            transition: width 0.6s, height 0.6s;
        }

        .btn-search:hover::before {
            width: 300px;
            height: 300px;
        }

        .btn-search:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(102,126,234,0.4);
        }

        .btn-search span, .btn-reset span {
            position: relative;
            z-index: 1;
        }

        .btn-reset {
            background: linear-gradient(135deg, #f1f5f9 0%, #e2e8f0 100%);
            color: #475569;
        }

        .btn-reset:hover {
            background: linear-gradient(135deg, #e2e8f0 0%, #cbd5e1 100%);
            transform: translateY(-3px);
            box-shadow: 0 6px 16px rgba(0,0,0,0.1);
        }

        /* Stats Cards - Compact */
        .stats-container {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 12px;
        }

        .stat-card {
            background: white;
            border-radius: 14px;
            padding: 12px 14px;
            box-shadow: 0 6px 16px rgba(0,0,0,0.08);
            display: flex;
            align-items: center;
            justify-content:center;
            gap: 12px;
            transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            border: 2px solid transparent;
            position: relative;
            overflow: hidden;
        }

        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(135deg, transparent 0%, rgba(102,126,234,0.03) 100%);
            opacity: 0;
            transition: opacity 0.3s;
        }

        .stat-card:hover {
            transform: translateY(-6px) scale(1.02);
            box-shadow: 0 12px 28px rgba(0,0,0,0.15);
            border-color: rgba(102,126,234,0.2);
        }

        .stat-card:hover::before {
            opacity: 1;
        }

        .stat-icon {
            width: 45px;
            height: 45px;
            border-radius: 11px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
            transition: all 0.3s ease;
            position: relative;
            z-index: 1;
        }

        .stat-card:hover .stat-icon {
            transform: rotate(360deg) scale(1.1);
        }

        .stat-icon.inserted {
            background: linear-gradient(135deg, #10b981, #059669);
            color: white;
        }

        .stat-icon.updated {
            background: linear-gradient(135deg, #3b82f6, #2563eb);
            color: white;
        }

        .stat-icon.uploaded {
            background: linear-gradient(135deg, #a855f7, #9333ea);
            color: white;
        }

        .stat-icon.excel {
            background: linear-gradient(135deg, #f59e0b, #d97706);
            color: white;
        }

        .stat-details {
            flex: 1;
            position: relative;
            z-index: 1;
        }

        .stat-details h4 {
            margin: 0;
            font-size: 24px;
            font-weight: 700;
            background: linear-gradient(135deg, #667eea, #764ba2);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            line-height: 1;
        }

        .stat-details p {
            margin: 3px 0 0 0;
            font-size: 11px;
            color: #64748b;
            font-weight: 500;
        }

        /* Table Container - Compact */
        .table-container {
            background: white;
            border-radius: 16px;
            padding: 15px;
            box-shadow: 0 6px 16px rgba(0,0,0,0.08);
        }

        .table-responsive {
            position: relative;
            overflow-y: auto;
            max-height: 500px;
            border-radius: 12px;
        }

        .table-responsive::-webkit-scrollbar {
            width: 6px;
        }

        .table-responsive::-webkit-scrollbar-track {
            background: #f1f5f9;
            border-radius: 10px;
        }

        .table-responsive::-webkit-scrollbar-thumb {
            background: linear-gradient(135deg, #667eea, #764ba2);
            border-radius: 10px;
        }

        /* Table - Compact */
        .table {
            border-collapse: separate;
            border-spacing: 0 8px;
            font-size: 14px;
            margin-bottom: 0;
        }

        .table thead th {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            font-weight: 600;
            text-transform: uppercase;
            font-size: 11px;
            letter-spacing: 0.8px;
            text-align: center;
            border: none;
            padding: 12px 10px;
            position: sticky;
            top: 0;
            z-index: 10;
            box-shadow: 0 3px 10px rgba(102,126,234,0.3);
        }

        .table thead th:first-child {
            border-top-left-radius: 10px;
            border-bottom-left-radius: 10px;
        }

        .table thead th:last-child {
            border-top-right-radius: 10px;
            border-bottom-right-radius: 10px;
        }

        .table tbody tr {
            background: white;
            box-shadow: 0 2px 6px rgba(0,0,0,0.06);
            border-radius: 10px;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .table tbody tr:hover {
            transform: translateX(6px);
            box-shadow: 0 6px 16px rgba(102,126,234,0.15);
        }

        .table tbody tr.new-entry {
            background: linear-gradient(135deg, rgba(102,126,234,0.1), rgba(118,75,162,0.1));
            box-shadow: 0 6px 20px rgba(102,126,234,0.3);
            animation: slideFromTop 0.8s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        }

        @keyframes slideFromTop {
            0% {
                transform: translateY(-80px) scale(0.9);
                opacity: 0;
            }
            60% {
                transform: translateY(8px) scale(1.02);
            }
            100% {
                transform: translateY(0) scale(1);
                opacity: 1;
            }
        }

        .table td {
            border: none;
            padding: 10px 10px;
            text-align: center;
            vertical-align: middle;
            background: transparent;
            font-size: 13px;
        }

        .table td:first-child {
            font-weight: 600;
            color: #667eea;
            text-align: center;
            padding-left: 16px;
            border-top-left-radius: 10px;
            border-bottom-left-radius: 10px;
        }

        .table td:last-child {
            border-top-right-radius: 10px;
            border-bottom-right-radius: 10px;
            padding-right: 16px;
        }

        .table td:nth-child(2),
        .table td:nth-child(3),
        .table td:nth-child(4) {
            color: #334155;
            font-weight: 500;
        }

        .table td:nth-child(5),
        .table td:nth-child(6) {
            font-family: 'Courier New', monospace;
            color: #64748b;
            font-size: 12px;
        }

        /* Badge - Compact */
        .badge-action {
            padding: 5px 14px;
            border-radius: 16px;
            font-size: 11px;
            font-weight: 600;
            display: inline-flex;
            align-items: center;
            gap: 5px;
            transition: all 0.3s ease;
        }

        .badge-action.inserted {
            background: linear-gradient(135deg, #10b981, #059669);
            color: white;
        }

        .badge-action.updated {
            background: linear-gradient(135deg, #3b82f6, #2563eb);
            color: white;
        }

        .badge-action.uploaded {
            background: linear-gradient(135deg, #a855f7, #9333ea);
            color: white;
        }

        .badge-action.excel {
            background: linear-gradient(135deg, #f59e0b, #d97706);
            color: white;
        }

        .badge-action:hover {
            transform: scale(1.08);
            box-shadow: 0 3px 10px rgba(0,0,0,0.2);
        }

        /* Empty State */
        .empty-state {
            padding: 50px 20px;
            text-align: center;
        }

        .empty-state i {
            font-size: 56px;
            color: #cbd5e1;
            margin-bottom: 16px;
            animation: float 3s ease-in-out infinite;
        }

        @keyframes float {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-15px); }
        }

        .empty-state p {
            font-size: 14px;
            color: #64748b;
            margin: 0;
        }

        /* Loading State */
        .loading-state {
            padding: 50px 20px;
            text-align: center;
        }

        .loading-state i {
            font-size: 42px;
            color: #667eea;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        .loading-state p {
            font-size: 14px;
            color: #64748b;
            margin-top: 12px;
        }

        /* Responsive */
        @media (max-width: 768px) {
            body {
                padding: 10px 0;
            }

            .card-body {
                padding: 15px 20px;
            }

            .header {
                padding: 16px 20px;
            }

            .header h3 {
                font-size: 18px;
            }

            .header p {
                font-size: 12px;
            }

            .top-section {
                grid-template-columns: 1fr;
                gap: 12px;
            }

            .filter-card {
                padding: 15px;
                gap: 10px;
            }

            .stats-container {
                grid-template-columns: 1fr 1fr;
                gap: 10px;
            }

            .table-responsive {
                max-height: 400px;
            }

            .table td:first-child {
                padding-left: 10px;
            }

            .table td:last-child {
                padding-right: 10px;
            }
        }

        .main-container {
            height: auto;
        }
    </style>

<div class="container-fluid">
    <div class="card main-card">
        <div class="header">
            <div class="header-content">
                <div class="header-icon">
                    <i class="fa-solid fa-clock-rotate-left"></i>
                </div>
                <div>
                    <h3>System Activity Logs</h3>
                    <p>Monitor and track all system activities in real-time</p>
                </div>
            </div>
        </div>

        <div class="card-body">
            <!-- Filter and Stats Combined Row -->
            <div class="top-section">
                <div class="filter-card">
                    <div class="filter-group">
                        <label><i class="fa fa-calendar-alt"></i> Start Date</label>
                       
                        <input type="date" id="start_date" class="form-control" value="<?php echo $current_date; ?>">
                    </div>
                    <div class="filter-group">
                        <label><i class="fa fa-calendar-check"></i> End Date</label>
                    <input type="date" id="end_date" class="form-control" value="<?php echo $current_date; ?>">
                    </div>
                    <div class="button-group">
                        <button id="search_btn" class="btn-search">
                            <span><i class="fa fa-search"></i> Search</span>
                        </button>
                        <button id="refresh_btn" class="btn-reset">
                            <span><i class="fa fa-refresh"></i> Reset</span>
                        </button>
                    </div>
                </div>

                <div class="stats-container">
                    <div class="stat-card">
                        <div class="stat-icon inserted">
                            <i class="fa fa-plus"></i>
                        </div>
                        <div class="stat-details">
                            <h4 id="inserted-count">0</h4>
                            <p>Inserted</p>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon updated">
                            <i class="fa fa-edit"></i>
                        </div>
                        <div class="stat-details">
                            <h4 id="updated-count">0</h4>
                            <p>Updated</p>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon uploaded">
                            <i class="fa fa-image"></i>
                        </div>
                        <div class="stat-details">
                            <h4 id="uploaded-count">0</h4>
                            <p>Photos</p>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon excel">
                            <i class="fa fa-file-excel"></i>
                        </div>
                        <div class="stat-details">
                            <h4 id="excel-count">0</h4>
                            <p>Excel Files</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="table-container">
                <div class="table-responsive">
                    <table class="table align-middle">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>User</th>
                                <th>Module Name</th>
                                <th>Sub Module</th>
                                
                                <th>Date</th>
                                <th>Time</th>
                                <th>Branch</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody id="filter_result">
                            <tr>
                                <td colspan="7" class="loading-state">
                                    <i class="fa fa-spinner fa-spin"></i>
                                    <p>Loading system logs...</p>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script>
$(document).ready(function() {
    // Load all logs on page load
    loadLogs();

    function setCurrentDate() {
        var today = new Date();
        var year = today.getFullYear();
        var month = String(today.getMonth() + 1).padStart(2, '0');
        var day = String(today.getDate()).padStart(2, '0');
        var currentDate = year + '-' + month + '-' + day;
        
        $('#start_date').val(currentDate);
        $('#end_date').val(currentDate);
    }
    
    // Search button click
    $('#search_btn').on('click', function() {
        loadLogs();
    });
    
    // Refresh button click
    $('#refresh_btn').on('click', function() {
        $('#start_date').val('');
        $('#end_date').val('');
        loadLogs();
    });
    
    // Function to load logs
    function loadLogs() {
        var start_date = $('#start_date').val();
        var end_date = $('#end_date').val();
        
        $.ajax({
            url: '<?php echo base_url("admin/logfile/get_logs"); ?>',
            method: 'POST',
            data: {
                start_date: start_date,
                end_date: end_date
            },
            beforeSend: function() {
                $('#filter_result').html('<tr><td colspan="7" class="loading-state"><i class="fa fa-spinner fa-spin"></i><p>Loading system logs...</p></td></tr>');
            },
            success: function(response) {
                if (response.trim() === '') {
                    $('#filter_result').html('<tr><td colspan="7" class="empty-state"><i class="fa fa-inbox"></i><p>No logs found for the selected period</p></td></tr>');
                } else {
                    $('#filter_result').html(response);
                    
                    // Add animation to first row
                    $('#filter_result tr:first').addClass('new-entry');
                    setTimeout(function() {
                        $('#filter_result tr:first').removeClass('new-entry');
                    }, 800);
                }
                
                // Update stats
                updateStats();
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error:', error);
                $('#filter_result').html('<tr><td colspan="7" class="empty-state"><i class="fa fa-exclamation-triangle"></i><p>Error loading data. Please try again.</p></td></tr>');
            }
        });
    }
    
    // Function to update statistics
    function updateStats() {
        var insertedCount = 0;
        var updatedCount = 0;
        var uploadedCount = 0;
        var excelCount = 0;
        
        $('#filter_result tr').each(function() {
            var $badge = $(this).find('.badge-action');
            if ($badge.length > 0) {
                if ($badge.hasClass('inserted')) {
                    insertedCount++;
                } else if ($badge.hasClass('updated')) {
                    updatedCount++;
                } else if ($badge.hasClass('uploaded')) {
                    uploadedCount++;
                } else if ($badge.hasClass('excel')) {
                    excelCount++;
                }
            }
        });
        
        // Animate counter updates
        animateCounter('inserted-count', insertedCount);
        animateCounter('updated-count', updatedCount);
        animateCounter('uploaded-count', uploadedCount);
        animateCounter('excel-count', excelCount);
    }
    
    // Function to animate counter
    function animateCounter(id, target) {
        var element = document.getElementById(id);
        var current = parseInt(element.textContent) || 0;
        var increment = target > current ? 1 : -1;
        var steps = 20;
        var stepValue = Math.abs(target - current) / steps;
        
        if (current !== target) {
            var counter = 0;
            var timer = setInterval(function() {
                counter++;
                current += increment * Math.ceil(stepValue);
                
                if ((increment > 0 && current >= target) || (increment < 0 && current <= target)) {
                    element.textContent = target;
                    clearInterval(timer);
                } else if (counter >= steps) {
                    element.textContent = target;
                    clearInterval(timer);
                } else {
                    element.textContent = Math.round(current);
                }
            }, 30);
        }
    }
    
    // Auto-refresh every 30 seconds
    setInterval(loadLogs, 30000);
});
</script>
