<style>
body{
    background:#f5f6fb;
    font-family:'Segoe UI',sans-serif;
}

/* main card */
.dashboard-card{
    background:#fff;
    border-radius:12px;
    align-items:center;
    gap:14px;
    box-shadow:0 4px 14px rgba(0,0,0,0.08);
    transition:0.25s;
    text-decoration:none;
    color:#000;
    height:100%;
}

.dashboard-card:hover{
    transform:translateY(-4px);
    box-shadow:0 10px 20px rgba(0,0,0,0.15);
    text-decoration:none;
    color:#000;
}

/* round icon */
.dashboard-icon{
    width:38px;
    height:38px;
    border-radius:50%;
    background:white;
    display:flex;
    align-items:center;
    justify-content:center;
    flex-shrink:0;
    box-shadow: 2px 2px 4px #7e8c8d;
    margin-top: 6px;
}

.dashboard-icon img{
    width:26px;
    height:26px;
}

/* text section */
.dashboard-text{
    font-size:15px;
    font-weight:bold;
    padding: 10px;
    background:white;
    box-shadow: 3px 3px 4px 2px darkgrey;
    border-radius: 5px;
    font-family: 'Open Sans';
    color: #000;
}

.mt-2 {
    margin-top: .7rem !important;
}

.mx-2 {
    margin-right: .7rem !important;
}

/* Welcome message style */
.welcome-banner {
    background: white;
    color: #333;
    border: none;
    border-radius: 15px;
    padding: 10px;
    margin-bottom: 25px;
    box-shadow: 0 4px 20px rgba(102, 126, 234, 0.15);
    display: flex;
    align-items: center;
    gap: 20px;
    position: relative;
    overflow: hidden;
}

.welcome-banner::before {
    content: '';
    position: absolute;
    left: 0;
    top: 0;
    height: 100%;
    width: 5px;
    background: linear-gradient(180deg, #667eea 0%, #764ba2 100%);
}

.welcome-banner .welcome-icon {
    width: 60px;
    height: 60px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 30px;
    flex-shrink: 0;
}

.welcome-banner h4 {
    margin: 0;
    font-weight: 600;
    font-size: 1.5rem;
    color: #333;
    flex: 1;
}

.welcome-banner .welcome-time {
    font-size: 0.9rem;
    color: #666;
    font-weight: normal;
}
</style>

<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header">
                        <div class="card-title"></div>
                    </div>
                    <div class="card-body">
                        <!-- Welcome Message -->
                        <?php if (!empty($user_data) && !empty($user_data->UserName)): ?>
                            <div class="welcome-banner">
                                <div class="welcome-icon">
    <img src="<?= base_url() ?>Assets/images/sit_logo.png" 
         alt="SIT Logo" 
         style="width:40px; height:auto;">
</div>

    <!-- <div class="welcome-icon">👋</div> -->
    <div>
        <h4>Welcome back, <?= htmlspecialchars($user_data->UserName) ?>!</h4>
        <div class="welcome-time"><?= date('l, F j, Y') ?></div>
    </div>
</div>
                        <!-- <div class="welcome-banner">
                            <h4>
                                👋 Welcome back, <?= htmlspecialchars($user_data->UserName) ?>!
                            </h4>
                        </div> -->
                        <?php endif; ?>
                        
                        <form role="form" id="Form" method="post">
                            <div class="container py-4">
                                <?php
                                if (!empty($menu_items)) {
                                    $total_items = count($menu_items);
                                    $items_per_row = 3;
                                    $current_row = 0;
                                    
                                    for ($i = 0; $i < $total_items; $i += $items_per_row) {
                                        $row_class = ($current_row > 0) ? 'row mt-2' : 'row';
                                        echo '<div class="' . $row_class . '">';
                                        
                                        for ($j = $i; $j < min($i + $items_per_row, $total_items); $j++) {
                                            $menu = $menu_items[$j];
                                            $menu_url = !empty($menu->MenuURL) ? $menu->MenuURL.'/'.$menu->MenuID : '#';
                                            $menu_icon = !empty($menu->MenuIcon) ? $menu->MenuIcon : 'default-icon.png';
                                            ?>
                                            <div class="col-md-4">
                                                <div class="col-md-2 dashboard-icon mx-2">
                                                    <img src="<?= base_url() ?>Assets/images/<?= $menu_icon ?>" alt="<?= htmlspecialchars($menu->MenuName) ?>">
                                                </div>
                                                <a href="<?= base_url() . $menu_url ?>" target="_blank" class="dashboard-card">
                                                    <div class="col-md-10 dashboard-text mt-1">
                                                        <?= htmlspecialchars($menu->MenuName) ?>
                                                    </div>
                                                </a>
                                            </div>
                                            <?php
                                        }
                                        
                                        echo '</div>';
                                        $current_row++;
                                    }
                                } else {
                                    echo '<div class="alert alert-info">No menu items found.</div>';
                                }
                                ?>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="<?php echo base_url();?>Assets/js/jquery.min.js"></script>           
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>