<style>
 /* Add New Department Button Style */
.typeahead-add-new {
    padding: 10px 16px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    cursor: pointer;
    border-bottom: 1px solid #f0f0f0;
    font-weight: 600;
    text-align: center;
    transition: all 0.3s ease;
    border-radius: 8px;
    margin: 8px;
    box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
    position: relative;
    overflow: hidden;
}

.typeahead-add-new::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
    transition: left 0.5s;
}

.typeahead-add-new:hover::before {
    left: 100%;
}

.typeahead-add-new:hover {
    background: linear-gradient(135deg, #764ba2 0%, #667eea 100%);
    transform: translateY(-3px) scale(1.02);
    box-shadow: 0 8px 25px rgba(102, 126, 234, 0.6);
}

.typeahead-add-new:active {
    transform: translateY(-1px) scale(0.98);
}

.typeahead-add-new i {
    margin-right: 8px;
    font-size: 16px;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% {
        transform: scale(1);
    }
    50% {
        transform: scale(1.1);
    }
}
/* Typeahead Dropdown Styles */
.department-wrapper {
    position: relative;
}

.typeahead-dropdown {
    position: absolute;
    top: 100%;
    left: 0;
    right: 0;
    background: white;
    border: 1px solid #ddd;
    border-radius: 4px;
    max-height: 300px;
    overflow-y: auto;
    z-index: 9999;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    display: none;
}

.typeahead-dropdown.show {
    display: block;
}

.typeahead-item {
    padding: 10px 15px;
    cursor: pointer;
    border-bottom: 1px solid #f0f0f0;
    transition: background 0.2s;
}

.typeahead-item:hover,
.typeahead-item.active {
    background-color: #f0f8ff;
    color: #007bff;
}

.typeahead-item .name {
    font-weight: 500;
    color: #333;
}

.typeahead-no-results {
    padding: 15px;
    text-align: center;
    color: #999;
    font-style: italic;
}


    .technical-menu {
            position: relative;
        }
        
        .legend-header {
            position: absolute;
            top: -12px;
            left: 20px;
            background: white;
            padding: 0 10px;
        }
        
        .legend-header h4 {
            color: #df0a7b;
            font-weight: 600;
            margin: 0;
            font-size: 19px !important;
        }
        /* Technical Menu Styles */
        .technical-menu {
            background: #f8f9fa00;
            border-radius: 10px;
            padding: 20px;
            margin-top: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }


.department-wrapper {
    position: relative;
}
</style>

<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1"> Maintenance Form </div>
                    </div>
                    <div class="card-body">
                        <form role="form" id="Form" action="" method="post">
                        <div class="row gutters">
                            <input type="hidden" id="Maintance_id" name="Maintance_id"
                                   class="hiddenId" style="width: 40px !important;height: 40px;"
                                   value="<?php if(!empty($data)) echo $data[0]->Maintance_id; ?>">

                            <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                <div class="field-wrapper">
                                    <?php $isEdit = isset($data[0]); ?>
                                    <select name="fkbranch_id" id="fkbranch_id" class="select-single js-states form-control" <?= $isEdit ? 'disabled' : '' ?>>
                                        <option value="">Select Branch</option>
                                        <?php foreach($branchdata as $branch): ?>
                                            <option value="<?= $branch->branch_id ?>" 
                                                <?= ($isEdit && $branch->branch_id == $data[0]->fkbranch_id) ? 'selected' : '' ?>>
                                                <?= $branch->branch_name ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                    <?php if ($isEdit): ?>
                                        <input type="hidden" name="fkbranch_id" value="<?= $data[0]->fkbranch_id ?>">
                                    <?php endif; ?>
                                    <div class="field-placeholder">Department/Branch</div>
                                </div>
                            </div>

                            <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
                                <div class="field-wrapper">
                                    <input type="date" name="Maintance_date" id="Maintance_date" class="form-control" 
                                    value="<?php if(!empty($data)) echo $data[0]->Maintance_date; ?>">
                                    <div class="field-placeholder">Maintenance Date</div>
                                </div>
                            </div>

                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                <div class="field-wrapper">
                                    <input class="form-control" type="text" name="person_name" id="person_name" required 
                                    value="<?php if(!empty($data)) echo $data[0]->person_name; ?>">
                                    <div class="field-placeholder">Person Name <span class="text-danger">*</span></div>
                                </div>
                            </div>

                            <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                <div class="field-wrapper">
                                    <input type="number" name="person_contact" id="person_contact" 
                                    class="form-control" maxlength="16" pattern="\d{10}"
                                    oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 10)"
                                    value="<?php if(!empty($data)) echo $data[0]->person_contact; ?>">
                                    <div class="field-placeholder">Person Phone Number</div>
                                </div>
                            </div>

                            <!-- Maintenance Type Typeahead -->
                            <div class="col-xl-3 col-lg-3 col-md-3 col-sm-6 col-12">
                                <div class="field-wrapper">
                                    <label class="field-placeholder">Maintenance Type <span class="text-danger">*</span></label>
                                    <div class="department-wrapper">
                                        <input type="text" 
                                               name="Maintype_name"   
                                               id="Maintype_name"  
                                               class="form-control"
                                               placeholder="Type to search..."
                                               autocomplete="off"
                                               required
                                               value="<?php if(!empty($data) && isset($data[0]->Maintype_name)) echo $data[0]->Maintype_name; ?>">
                                        
                                        <input type="hidden" 
                                               name="fkMaintype_id" 
                                               id="fkMaintype_id" 
                                               value="<?php if(!empty($data) && isset($data[0]->fkMaintype_id)) echo $data[0]->fkMaintype_id; ?>">
                                        
                                        <div class="typeahead-dropdown" id="maintype_typeahead_dropdown"></div>
                                    </div>
                                </div>
                            </div>

                            <!-- Maintenance Sub Type Typeahead -->
                            <div class="col-xl-3 col-lg-3 col-md-3 col-sm-6 col-12">
                                <div class="field-wrapper">
                                    <label class="field-placeholder">Maintenance Sub Type</label>
                                    <div class="department-wrapper">
                                        <input type="text" 
                                               name="Mainsub_name"   
                                               id="Mainsub_name"  
                                               class="form-control"
                                               placeholder="Type to search..."
                                               autocomplete="off"
                                               value="<?php if(!empty($data) && isset($data[0]->Mainsub_name)) echo $data[0]->Mainsub_name; ?>">
                                        
                                        <input type="hidden" 
                                               name="fkMainsub_id" 
                                               id="fkMainsub_id" 
                                               value="<?php if(!empty($data) && isset($data[0]->fkMainsub_id)) echo $data[0]->fkMainsub_id; ?>">
                                        
                                        <div class="typeahead-dropdown" id="mainsub_typeahead_dropdown"></div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-12 col-12">
                                <div class="field-wrapper">
                                    <textarea class="form-control" name="Maintance_details" id="Maintance_details"><?= !empty($data) ? $data[0]->Maintance_details : '' ?></textarea>
                                    <div class="field-placeholder">Maintenance Details</div>
                                </div>
                            </div>

                            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-12 col-12">
                                <div class="field-wrapper">
                                    <textarea class="form-control" name="Photo_url" id="Photo_url"><?= !empty($data) ? $data[0]->Photo_url : '' ?></textarea>
                                    <div class="field-placeholder">Photo URL</div>
                                </div>
                            </div>

                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 col-12">
                                <div class="field-wrapper">
                                    <div class="field-placeholder">Document (PDF/DOC only)</div>
                                    <input type="file" name="Document" id="Document" class="form-control" 
                                           accept=".pdf,.doc,.docx" onchange="previewDocument(this)">
                                    
                                    <div class="form-text">Only PDF and DOC files are allowed</div>
                                    
                                    <div id="file_Document" style="margin-top:10px;">
                                        <?php
                                        if (!empty($data[0]->Document)) {
                                            $file = $data[0]->Document;
                                            $ext = pathinfo($file, PATHINFO_EXTENSION);
                                            $fileUrl = base_url('' . $file);
                                            $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
                                            ?>
                                            <a href="<?= $fileUrl ?>" target="_blank">
                                                <?php if ($isImage): ?>
                                                    <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
                                                <?php else: ?>
                                                    <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
                                                <?php endif; ?>
                                            </a>
                                        <?php } ?>
                                    </div>
                                    
                                    <input type="hidden" name="hidden_Document" value="<?= !empty($data[0]->Document) ? $data[0]->Document : '' ?>">
                                </div>
                            </div>

                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 mt-3">
                                <button type="button" class="btn mb-md-0 mb-2 btn-quarternary" id="submit" name="submit">
                                    <i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save
                                </button>
                                <a class="btn mb-md-0 mb-2 btn-quarternary1" href="<?=base_url()?>admin/Maintance/index" type="button">
                                    <i class="fa-solid fa-list"></i>&nbsp;&nbsp;List
                                </a>
                                <button class="btn mb-md-0 mb-2 btn-quarternaryhome" type="button" onclick="window.location.href='<?= base_url() ?>admin/Maintance/Dashboard'">
                                    <i class="fa-solid fa-home"></i>&nbsp;&nbsp;Home
                                </button>
                            </div>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="<?php echo base_url();?>Assets/js/CreateJs/admin/Maintance.js"></script> 

<script>
$(document).ready(function() {
    
    // ============================================
    // MAINTENANCE TYPE TYPEAHEAD
    // ============================================
    
    let maintypeTypingTimer;
    let maintypeTypingInterval = 300;
    let maintypeCurrentFocus = -1;
    
    // ============ MAINTENANCE TYPE - KEYUP EVENT ============
    $('#Maintype_name').on('keyup', function(e) {
        if (e.keyCode === 38 || e.keyCode === 40 || e.keyCode === 13) {
            return;
        }

        clearTimeout(maintypeTypingTimer);
        const searchTerm = $(this).val().trim();

        if (searchTerm.length === 0) {
            $('#maintype_typeahead_dropdown').removeClass('show').html('');
            return;
        }

        if (searchTerm.length >= 1) {
            maintypeTypingTimer = setTimeout(function() {
                searchMaintenanceTypesWithAddNew(searchTerm);
            }, maintypeTypingInterval);
        }
    });
    
    // ============ SEARCH MAINTENANCE TYPES WITH ADD NEW OPTION ============
    function searchMaintenanceTypesWithAddNew(search) {
        $.ajax({
            url: base_path + 'admin/Maintance/searchMaintenanceType',
            type: 'POST',
            data: { query: search },
            dataType: 'json',
            beforeSend: function() {
                $('#maintype_typeahead_dropdown')
                    .html('<div class="typeahead-no-results"><i class="fa fa-spinner fa-spin"></i> Searching...</div>')
                    .addClass('show');
            },
            success: function(response) {
                let html = '';
                
                if (response.length > 0) {
                    // Show existing maintenance types
                    $.each(response, function(i, item) {
                        html += `
                            <div class="typeahead-item" data-maintype-id="${item.Maintype_id}" data-maintype-name="${item.Maintype_name}">
                                <span class="name">${item.Maintype_name}</span>
                            </div>
                        `;
                    });
                } else {
                    // No results - show "not found" message
                    html += `<div class="typeahead-no-results">No matching maintenance types found.</div>`;
                }
                
                // Always show "Add New" option at the bottom
                html += `
                    <div class="typeahead-add-new" data-new-maintype="${search}">
                        <i class="fa fa-square-plus"></i> Add New: "${search}"
                    </div>
                `;
                
                $('#maintype_typeahead_dropdown').html(html).addClass('show');
            },
            error: function(xhr, status, error) {
                console.error('Maintenance Type search error:', error);
                $('#maintype_typeahead_dropdown').removeClass('show').html('');
            }
        });
    }
    
    // ============ SELECT EXISTING MAINTENANCE TYPE ============
    $(document).on('click', '#maintype_typeahead_dropdown .typeahead-item', function() {
        const selectedMaintypeId = $(this).data('maintype-id');
        const selectedMaintypeName = $(this).data('maintype-name');
        
        $('#Maintype_name').val(selectedMaintypeName);
        $('#fkMaintype_id').val(selectedMaintypeId);
        
        $('#maintype_typeahead_dropdown').removeClass('show').html('');
        
        // Move to next field
        setTimeout(() => {
            $('#Mainsub_name').focus();
        }, 100);
    });
    
    // ============ ADD NEW MAINTENANCE TYPE ============
    $(document).on('click', '#maintype_typeahead_dropdown .typeahead-add-new', function() {
        const newMaintypeName = $(this).data('new-maintype');
        addNewMaintenanceType(newMaintypeName);
    });
    
    // ============ AJAX CALL TO ADD NEW MAINTENANCE TYPE ============
    function addNewMaintenanceType(maintypeName) {
        Swal.fire({
            title: 'Adding Maintenance Type...',
            text: 'Please wait',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        $.ajax({
            url: base_path + 'admin/Maintance/addMaintenanceType',
            type: 'POST',
            data: { Maintype_name: maintypeName },
            dataType: 'json',
            success: function(response) {
                Swal.close();
                
                console.log('Response:', response);
                
                if (response.success) {
                    // Set the new maintenance type in the field
                    $('#Maintype_name').val(response.data.Maintype_name);
                    $('#fkMaintype_id').val(response.data.Maintype_id);
                    
                    $('#maintype_typeahead_dropdown').removeClass('show').html('');
                    
                    // Move to next field directly without success message
                    setTimeout(() => {
                        $('#Mainsub_name').focus();
                    }, 100);
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: response.message || 'Failed to add maintenance type',
                        customClass: {
                            popup: 'custom-swal-popup',
                            icon: 'custom-swal-icon',
                            title: 'custom-swal-title',
                            htmlContainer: 'custom-swal-text'
                        }
                    });
                }
            },
            error: function(xhr, status, error) {
                Swal.close();
                
                console.error('XHR Status:', xhr.status);
                console.error('Response Text:', xhr.responseText);
                console.error('Error:', error);
                
                let errorMessage = 'Failed to add new maintenance type. Please try again.';
                
                try {
                    let errorResponse = JSON.parse(xhr.responseText);
                    if (errorResponse.message) {
                        errorMessage = errorResponse.message;
                    }
                } catch(e) {
                    if (xhr.responseText) {
                        console.error('Server returned HTML instead of JSON:', xhr.responseText);
                        errorMessage = 'Server error occurred. Check console for details.';
                    }
                }
                
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: errorMessage,
                    customClass: {
                        popup: 'custom-swal-popup',
                        icon: 'custom-swal-icon',
                        title: 'custom-swal-title',
                        htmlContainer: 'custom-swal-text'
                    }
                });
            }
        });
    }
    
    // ============ KEYBOARD NAVIGATION FOR MAINTENANCE TYPE ============
    $('#Maintype_name').on('keydown', function(e) {
        var items = $('#maintype_typeahead_dropdown .typeahead-item, #maintype_typeahead_dropdown .typeahead-add-new');
        
        if (e.keyCode === 40) { // Down arrow
            e.preventDefault();
            maintypeCurrentFocus++;
            addActiveMainttype(items);
        } else if (e.keyCode === 38) { // Up arrow
            e.preventDefault();
            maintypeCurrentFocus--;
            addActiveMainttype(items);
        } else if (e.keyCode === 13) { // Enter key
            e.preventDefault();
            if (maintypeCurrentFocus > -1 && items.length > 0) {
                items[maintypeCurrentFocus].click();
            } else {
                let maintype = $(this).val().trim();
                
                if (!maintype || maintype === '') {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Maintenance Type Required',
                        text: 'Please enter Maintenance Type!',
                        timer: 2000,
                        customClass: {
                            popup: 'custom-swal-popup',
                            icon: 'custom-swal-icon',
                            title: 'custom-swal-title',
                            htmlContainer: 'custom-swal-text'
                        }
                    });
                    return;
                }
                
                // If dropdown is showing "Add New", trigger it
                if ($('#maintype_typeahead_dropdown .typeahead-add-new').length > 0) {
                    $('#maintype_typeahead_dropdown .typeahead-add-new').click();
                } else {
                    $('#maintype_typeahead_dropdown').removeClass('show').html('');
                    setTimeout(() => {
                        $('#Mainsub_name').focus();
                    }, 100);
                }
            }
        } else if (e.keyCode === 27) { // Escape
            $('#maintype_typeahead_dropdown').removeClass('show').html('');
            maintypeCurrentFocus = -1;
        }
    });

    // Helper function for Maintenance Type
    function addActiveMainttype(items) {
        if (!items || items.length === 0) return false;
        removeActiveMainttype(items);
        if (maintypeCurrentFocus >= items.length) maintypeCurrentFocus = 0;
        if (maintypeCurrentFocus < 0) maintypeCurrentFocus = (items.length - 1);
        $(items[maintypeCurrentFocus]).addClass('active');
    }

    function removeActiveMainttype(items) {
        $(items).removeClass('active');
    }
    
    
    // ============================================
    // MAINTENANCE SUB TYPE TYPEAHEAD
    // ============================================
    
    let mainsubTypingTimer;
    let mainsubTypingInterval = 300;
    let mainsubCurrentFocus = -1;
    
    // ============ MAINTENANCE SUB TYPE - KEYUP EVENT ============
    $('#Mainsub_name').on('keyup', function(e) {
        if (e.keyCode === 38 || e.keyCode === 40 || e.keyCode === 13) {
            return;
        }

        clearTimeout(mainsubTypingTimer);
        const searchTerm = $(this).val().trim();

        if (searchTerm.length === 0) {
            $('#mainsub_typeahead_dropdown').removeClass('show').html('');
            return;
        }

        if (searchTerm.length >= 1) {
            mainsubTypingTimer = setTimeout(function() {
                searchMaintenanceSubTypesWithAddNew(searchTerm);
            }, mainsubTypingInterval);
        }
    });
    
    // ============ SEARCH MAINTENANCE SUB TYPES WITH ADD NEW OPTION ============
    function searchMaintenanceSubTypesWithAddNew(search) {
        $.ajax({
            url: base_path + 'admin/Maintance/searchMaintenanceSubType',
            type: 'POST',
            data: { query: search },
            dataType: 'json',
            beforeSend: function() {
                $('#mainsub_typeahead_dropdown')
                    .html('<div class="typeahead-no-results"><i class="fa fa-spinner fa-spin"></i> Searching...</div>')
                    .addClass('show');
            },
            success: function(response) {
                let html = '';
                
                if (response.length > 0) {
                    // Show existing maintenance sub types
                    $.each(response, function(i, item) {
                        html += `
                            <div class="typeahead-item" data-mainsub-id="${item.Mainsub_id}" data-mainsub-name="${item.Mainsub_name}">
                                <span class="name">${item.Mainsub_name}</span>
                            </div>
                        `;
                    });
                } else {
                    // No results - show "not found" message
                    html += `<div class="typeahead-no-results">No matching maintenance sub types found.</div>`;
                }
                
                // Always show "Add New" option at the bottom
                html += `
                    <div class="typeahead-add-new" data-new-mainsub="${search}">
                        <i class="fa fa-square-plus"></i> Add New: "${search}"
                    </div>
                `;
                
                $('#mainsub_typeahead_dropdown').html(html).addClass('show');
            },
            error: function(xhr, status, error) {
                console.error('Maintenance Sub Type search error:', error);
                $('#mainsub_typeahead_dropdown').removeClass('show').html('');
            }
        });
    }
    
    // ============ SELECT EXISTING MAINTENANCE SUB TYPE ============
    $(document).on('click', '#mainsub_typeahead_dropdown .typeahead-item', function() {
        const selectedMainsubId = $(this).data('mainsub-id');
        const selectedMainsubName = $(this).data('mainsub-name');
        
        $('#Mainsub_name').val(selectedMainsubName);
        $('#fkMainsub_id').val(selectedMainsubId);
        
        $('#mainsub_typeahead_dropdown').removeClass('show').html('');
        
        // Move to next field
        setTimeout(() => {
            $('#Maintance_details').focus();
        }, 100);
    });
    
    // ============ ADD NEW MAINTENANCE SUB TYPE ============
    $(document).on('click', '#mainsub_typeahead_dropdown .typeahead-add-new', function() {
        const newMainsubName = $(this).data('new-mainsub');
        addNewMaintenanceSubType(newMainsubName);
    });
    
    // ============ AJAX CALL TO ADD NEW MAINTENANCE SUB TYPE ============
    function addNewMaintenanceSubType(mainsubName) {
        Swal.fire({
            title: 'Adding Maintenance Sub Type...',
            text: 'Please wait',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        $.ajax({
            url: base_path + 'admin/Maintance/addMaintenanceSubType',
            type: 'POST',
            data: { Mainsub_name: mainsubName },
            dataType: 'json',
            success: function(response) {
                Swal.close();
                
                console.log('Response:', response);
                
                if (response.success) {
                    // Set the new maintenance sub type in the field
                    $('#Mainsub_name').val(response.data.Mainsub_name);
                    $('#fkMainsub_id').val(response.data.Mainsub_id);
                    
                    $('#mainsub_typeahead_dropdown').removeClass('show').html('');
                    
                    // Move to next field directly without success message
                    setTimeout(() => {
                        $('#Maintance_details').focus();
                    }, 100);
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: response.message || 'Failed to add maintenance sub type',
                        customClass: {
                            popup: 'custom-swal-popup',
                            icon: 'custom-swal-icon',
                            title: 'custom-swal-title',
                            htmlContainer: 'custom-swal-text'
                        }
                    });
                }
            },
            error: function(xhr, status, error) {
                Swal.close();
                
                console.error('XHR Status:', xhr.status);
                console.error('Response Text:', xhr.responseText);
                console.error('Error:', error);
                
                let errorMessage = 'Failed to add new maintenance sub type. Please try again.';
                
                try {
                    let errorResponse = JSON.parse(xhr.responseText);
                    if (errorResponse.message) {
                        errorMessage = errorResponse.message;
                    }
                } catch(e) {
                    if (xhr.responseText) {
                        console.error('Server returned HTML instead of JSON:', xhr.responseText);
                        errorMessage = 'Server error occurred. Check console for details.';
                    }
                }
                
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: errorMessage,
                    customClass: {
                        popup: 'custom-swal-popup',
                        icon: 'custom-swal-icon',
                        title: 'custom-swal-title',
                        htmlContainer: 'custom-swal-text'
                    }
                });
            }
        });
    }
    
    // ============ KEYBOARD NAVIGATION FOR MAINTENANCE SUB TYPE ============
    $('#Mainsub_name').on('keydown', function(e) {
        var items = $('#mainsub_typeahead_dropdown .typeahead-item, #mainsub_typeahead_dropdown .typeahead-add-new');
        
        if (e.keyCode === 40) { // Down arrow
            e.preventDefault();
            mainsubCurrentFocus++;
            addActiveMainsub(items);
        } else if (e.keyCode === 38) { // Up arrow
            e.preventDefault();
            mainsubCurrentFocus--;
            addActiveMainsub(items);
        } else if (e.keyCode === 13) { // Enter key
            e.preventDefault();
            if (mainsubCurrentFocus > -1 && items.length > 0) {
                items[mainsubCurrentFocus].click();
            } else {
                let mainsub = $(this).val().trim();
                
                if (!mainsub || mainsub === '') {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Maintenance Sub Type Required',
                        text: 'Please enter Maintenance Sub Type!',
                        timer: 2000,
                        customClass: {
                            popup: 'custom-swal-popup',
                            icon: 'custom-swal-icon',
                            title: 'custom-swal-title',
                            htmlContainer: 'custom-swal-text'
                        }
                    });
                    return;
                }
                
                // If dropdown is showing "Add New", trigger it
                if ($('#mainsub_typeahead_dropdown .typeahead-add-new').length > 0) {
                    $('#mainsub_typeahead_dropdown .typeahead-add-new').click();
                } else {
                    $('#mainsub_typeahead_dropdown').removeClass('show').html('');
                    setTimeout(() => {
                        $('#Maintance_details').focus();
                    }, 100);
                }
            }
        } else if (e.keyCode === 27) { // Escape
            $('#mainsub_typeahead_dropdown').removeClass('show').html('');
            mainsubCurrentFocus = -1;
        }
    });

    // Helper function for Maintenance Sub Type
    function addActiveMainsub(items) {
        if (!items || items.length === 0) return false;
        removeActiveMainsub(items);
        if (mainsubCurrentFocus >= items.length) mainsubCurrentFocus = 0;
        if (mainsubCurrentFocus < 0) mainsubCurrentFocus = (items.length - 1);
        $(items[mainsubCurrentFocus]).addClass('active');
    }

    function removeActiveMainsub(items) {
        $(items).removeClass('active');
    }
    
    
    // ============================================
    // COMMON FUNCTIONS
    // ============================================
    
    // Hide dropdown when clicking outside
    $(document).on('click', function(e) {
        if (!$(e.target).closest('#Maintype_name').length &&
            !$(e.target).closest('#maintype_typeahead_dropdown').length) {
            $('#maintype_typeahead_dropdown').removeClass('show').html('');
        }
        
        if (!$(e.target).closest('#Mainsub_name').length &&
            !$(e.target).closest('#mainsub_typeahead_dropdown').length) {
            $('#mainsub_typeahead_dropdown').removeClass('show').html('');
        }
    });

    // Clear dropdown when field is cleared
    $('#Maintype_name').on('input', function() {
        if ($(this).val().trim() === '') {
            $('#maintype_typeahead_dropdown').removeClass('show').html('');
            $('#fkMaintype_id').val('');
        }
    });
    
    $('#Mainsub_name').on('input', function() {
        if ($(this).val().trim() === '') {
            $('#mainsub_typeahead_dropdown').removeClass('show').html('');
            $('#fkMainsub_id').val('');
        }
    });
    
});

function previewDocument(input) {
    const preview = document.getElementById('file_Document');
    const file = input.files[0];
    
    if (file) {
        const fileName = file.name;
        const fileExt = fileName.split('.').pop().toLowerCase();
        
        if (fileExt === 'pdf' || fileExt === 'doc' || fileExt === 'docx') {
            preview.innerHTML = `<img src="<?= base_url('Assets/img/Document_file.png') ?>" style="height: 100px;">`;
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Invalid File Type',
                text: 'Only PDF and DOC files are allowed for this field.'
            });
            input.value = '';
            preview.innerHTML = '';
        }
    } else {
        preview.innerHTML = '';
    }
}
</script>