<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Login - Sharad ERP</title>
<link rel="shortcut icon" href="<?=base_url()?>Assets/images/sit_logo.png">
<link rel="stylesheet" href="<?=base_url()?>Assets/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700&display=swap" rel="stylesheet">

<style>
/* BACKGROUND */
body.authentication{
    font-family:'Inter',sans-serif;
    background:
        linear-gradient(135deg,
            rgba(18,115,235,.85),
            rgba(120,170,245,.75),
            rgba(200,220,255,.9)
        ),
        url("<?=base_url()?>");
    background-size:cover;
    background-position:center;
    background-attachment:fixed;
    min-height:100vh;
    display:flex;
    align-items:center;
    justify-content:center;
    padding:20px 15px;
    overflow-x:hidden;
}

/* MAIN CARD */
.login-container{
    max-width:1200px;
    width:100%;
    background:linear-gradient(145deg,#ffffff,#f2f7ff);
    border-radius:18px;
    box-shadow:0 35px 80px rgba(0,0,0,.25);
    overflow:hidden;
}

/* LOGIN */
.login-wrapper{
    padding:60px;
    display:flex;
    justify-content:center;
    align-items:center;
}

.login-box{
    max-width:360px;
    width:100%;
    background:rgba(255,255,255,.65);
    backdrop-filter:blur(16px);
    border-radius:22px;
    padding:38px 32px;
    border:1px solid rgba(18,115,235,.35);
    box-shadow:0 20px 45px rgba(0,0,0,.18);
    text-align:center;
}

.login-box img.logo{
    max-width:150px;
    height:100px;
    object-fit:contain;
}

.field-wrapper{
    position:relative;
    margin-bottom:14px;
}

.field-wrapper i{
    position:absolute;
    top:50%;
    left:16px;
    transform:translateY(-50%);
    color:#1273eb;
}

.field-wrapper input{
    width:100%;
    height:42px;
    padding-left:42px;
    border-radius:25px;
    border:1px solid #ccc;
}

.forgot-pass{
    text-align:right;
    margin-bottom:18px;
}

.forgot-pass a{
    font-size:12px;
    color:#1273eb;
    font-weight:600;
    text-decoration:none;
}

.btn-primary{
    width:100%;
    border:none;
    border-radius:25px;
    background:#1273eb;
    padding:10px;
}

/* ERP TEXT */
.erp-text{
    font-size:14px;
    font-weight:600;
    color:#1273eb;
    margin-top:15px;
    letter-spacing:0.5px;
}

.erp-text span{
    opacity:0;
    display:inline-block;
    animation:letterType 0.15s ease forwards;
}

/* RIGHT PANEL */
.login-about{
    background:linear-gradient(145deg,#f2f7ff,#e6efff);
    padding:50px;
    text-align:center;
    display:flex;
    flex-direction:column;
    justify-content:center;
}

/* IMAGE SLIDER */
.college-slider{
    width:100%;
    max-width:510px;
    height:250px;
    margin:0 auto 30px;
    border-radius:18px;
    overflow:hidden;
    background:#fff;
    box-shadow:0 25px 50px rgba(0,0,0,.25);
}

.college-slider img{
    width:100%;
    height:250px;
    object-fit:cover;
}

/* RED TYPING WORD ANIMATION */
.flash-text{
    font-size:22px;
    font-weight:800;
    color:#d90429;
    line-height:1.6;
    letter-spacing:1px;
    word-break:break-word;
}

.flash-text span{
    opacity:0;
    display:inline-block;
    animation:letterType 0.15s ease forwards;
}

@keyframes letterType{
    from{
        opacity:0;
        transform:translateY(8px);
    }
    to{
        opacity:1;
        transform:translateY(0);
    }
}

.footer-text{
    font-size:12px;
    margin-top:20px;
}

.alert{
    margin-bottom:15px;
    border-radius:25px;
}

/* RESPONSIVE - BOOTSTRAP BREAKPOINTS */
@media (min-width: 1200px) and (max-width: 1399px) {
    .login-wrapper{padding:50px 40px;}
    .login-about{padding:50px 40px;}
}

@media (min-width: 992px) and (max-width: 1199px) {
    .login-wrapper{padding:40px 30px;}
    .login-about{padding:40px 30px;}
    .college-slider{max-width:450px; height:220px;}
    .college-slider img{height:220px;}
}

@media (min-width: 768px) and (max-width: 991px) {
    .login-wrapper{padding:40px 25px;}
    .login-about{padding:40px 25px;}
    .login-box{padding:35px 28px;}
    .college-slider{max-width:400px; height:200px;}
    .college-slider img{height:200px;}
    .flash-text{font-size:20px;}
}

@media (max-width: 767px) {
    body.authentication{padding:20px 10px; align-items:flex-start;}
    .login-container{border-radius:12px; margin-top:20px;}
    .login-wrapper{padding:40px 20px;}
    .login-box{padding:35px 25px; max-width:100%;}
    .login-about{padding:40px 20px;}
    .college-slider{height:200px; border-radius:12px;}
    .college-slider img{height:200px;}
    .flash-text{font-size:18px;}
}

@media (max-width: 575px) {
    body.authentication{padding:15px 8px;}
    .login-container{margin-top:15px;}
    .login-wrapper{padding:30px 15px;}
    .login-box{padding:30px 20px; border-radius:18px;}
    .login-about{padding:30px 15px;}
    .college-slider{height:180px;}
    .college-slider img{height:180px;}
    .flash-text{font-size:16px; letter-spacing:0.5px;}
    .footer-text{font-size:11px;}
    .field-wrapper input{height:40px; font-size:14px;}
    .erp-text{font-size:12px;}
}

@media (max-width: 399px) {
    .login-box{padding:25px 15px;}
    .college-slider{height:160px;}
    .college-slider img{height:160px;}
    .flash-text{font-size:14px;}
}
</style>
</head>

<body class="authentication">

<div class="login-container">
    <div class="row g-0">

        <!-- LOGIN SECTION -->
        <div class="col-12 col-md-6">
            <div class="login-wrapper">
                <div class="login-box">
                    <!-- Logo from Database -->
                    <?php if(isset($heading_data->logo) && !empty($heading_data->logo)): ?>
                        <img src="<?=base_url()?>Assets/images/<?=$heading_data->logo?>" alt="Logo" class="logo">
                
                    <?php endif; ?>
                    
                    <h4 style="color:#1273eb;font-weight:700;">Login</h4><br>

                    <!-- Error Message -->
                    <?php if($this->session->flashdata('error')): ?>
                        <div class="alert alert-danger" role="alert">
                            <?=$this->session->flashdata('error')?>
                        </div>
                    <?php endif; ?>

                    <!-- Login Form -->
                    <?=form_open('admin/MenuLogin/login_validation')?>
                        <div class="field-wrapper">
                            <i class="fa fa-user"></i>
                            <input type="text" name="userName" placeholder="User ID" value="<?=set_value('userName')?>" required>
                        </div>
                        <?=form_error('userName', '<div class="text-danger small">', '</div>')?>

                        <div class="field-wrapper">
                            <i class="fa fa-lock"></i>
                            <input type="password" name="password" placeholder="Password" required>
                        </div>
                        <?=form_error('password', '<div class="text-danger small">', '</div>')?>



                   <div class="forgot-pass">
    <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#forgotPasswordModal">Forgot Password?</a>
</div>

                        <button type="submit" class="btn btn-primary">LOGIN</button>
                    <?=form_close()?>
                    
 <div class="erp-text" id="erpText">SHARAD ERP SOFTWARE</div>
                </div>
            </div>
        </div>
        

        <!-- RIGHT PANEL -->
        <div class="col-12 col-md-6 login-about">

            <!-- Slider with Database Images -->
            <div id="collegeSlider" class="carousel slide college-slider" data-bs-ride="carousel">
                <div class="carousel-inner">
                    <?php if(!empty($slider_images)): ?>
                        <?php foreach($slider_images as $index => $image): ?>
                            <div class="carousel-item <?=$index === 0 ? 'active' : ''?>">
                                <img src="<?=base_url()?>Assets/images/<?=$image?>" alt="Slide <?=$index + 1?>">
                            </div>
                        <?php endforeach; ?>
                    
                    <?php endif; ?>
                </div>
            </div>

            <!-- Heading Text -->
            <!--<h5 class="flash-text" id="typeText">-->
            <!--    <?=isset($heading_data->head) ? $heading_data->head : 'Welcome to Sharad '?>-->
            <!--</h5>-->
            
                 <h5 class="flash-text" id="typeText">
     <?= isset($heading_data->head) ? $heading_data->head : '' ?>
</h5>

            <!-- Subheading 2 -->
            <p><?=isset($heading_data->subHead2) ? $heading_data->subHead2 : ''?></p>

            <!-- Footer Text -->
            <div class="footer-text">
                <?=isset($heading_data->subHead3) ? $heading_data->subHead3 : ''?>
            </div>

        </div>

    </div>
</div>
<style>
/* Modal Header Blue */
.modal-header.bg-blue {
    background-color: #1273eb !important;
    color: white !important;
}

/* Close icon (X) ko white karne ke liye */
.modal-header .btn-close {
    filter: invert(1) grayscale(100%) brightness(200%);
}

/* Screenshot jaisa Dark Close Button */
.btn-dark-custom {
    background-color: #2c3e50 !important;
    color: white !important;
    border: none;
    padding: 8px 25px;
    border-radius: 5px;
}

.modal-content {
    border: none;
    box-shadow: 0 10px 30px rgba(0,0,0,0.2);
}
</style>
<div class="modal fade" id="forgotPasswordModal" tabindex="-1" aria-labelledby="forgotPasswordModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content" style="border-radius: 12px; overflow: hidden;">
            <div class="modal-header bg-blue">
                <h5 class="modal-title" id="forgotPasswordModalLabel" style="font-size: 1.1rem;">Forgot Password</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center" style="padding: 50px 30px;">
                <h4 class="fw-bold mb-3" style="color: #333;">Need Help?</h4>
                <p class="text-muted" style="font-size: 0.95rem;">If you've forgotten your password, please contact the administrator for assistance.</p>
                <h5 class="fw-bold mt-4" style="color: #000;">Helpline: 1800-233-1419</h5>
            </div>
            <div class="modal-footer" style="border-top: none; padding-bottom: 20px; padding-right: 20px;">
                <button type="button" class="btn btn-dark-custom" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="<?=base_url()?>Assets/js/bootstrap.bundle.min.js"></script>
<script>
// Main heading animation
const textElement = document.getElementById("typeText");
if(textElement && textElement.innerHTML.trim() !== '') {
    const text = textElement.innerHTML;
    textElement.innerHTML = "";
    let delay = 0;
    for (let char of text) {
        if (char === "<") {
            textElement.innerHTML += char;
            continue;
        }
        const span = document.createElement("span");
        span.innerHTML = char === " " ? "&nbsp;" : char;
        span.style.animationDelay = delay + "s";
        textElement.appendChild(span);
        delay += 0.30;
    }
}

// ERP text animation
const erpElement = document.getElementById("erpText");
if(erpElement) {
    const erpText = erpElement.innerHTML;
    erpElement.innerHTML = "";
    let delay = 0;
    for (let char of erpText) {
        const span = document.createElement("span");
        span.innerHTML = char === " " ? "&nbsp;" : char;
        span.style.animationDelay = delay + "s";
        erpElement.appendChild(span);
        delay += 0.50;
    }
}
</script>

</body>
</html>