<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Login - Sharad ERP</title>
<link rel="shortcut icon" href="<?=base_url()?>Assets/images/sit_logo.png">
<link rel="stylesheet" href="<?=base_url()?>Assets/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@700;800;900&family=Inter:wght@400;500;600;700;800&family=JetBrains+Mono:wght@700&display=swap" rel="stylesheet">

<style>
/* ==================== COLOR VARIABLES FROM LOGO ==================== */
:root {
    --primary-orange: #ff6f3c;
    --vibrant-orange: #ff8534;
    --golden-yellow: #ffc107;
    --deep-orange: #e85d2c;
    --soft-cream: #fff8f0;
    --warm-gray: #f5f5f5;
    --text-charcoal: #2d3436;
    --text-muted: #636e72;
    --white: #ffffff;
    --shadow-color: rgba(255, 111, 60, 0.15);
}

/* ==================== BASE STYLES ==================== */
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body.authentication {
    font-family: 'Inter', sans-serif;
    background: 
        linear-gradient(135deg, 
            rgba(255, 193, 7, 0.08),
            rgba(255, 143, 52, 0.05),
            rgba(245, 245, 245, 0.95)
        );
    min-height: 100vh;
    display: flex;
    flex-direction: column;
    overflow-x: hidden;
    
    
}

/* ==================== HEADER IMAGE STRIP ==================== */
.header-image-strip {
    width: 100%;
   background: linear-gradient(135deg, #efeff7, #efeff7);
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
    position: relative;
    overflow: hidden;
}

.header-image-strip::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: url('data:image/svg+xml,<svg width="60" height="60" xmlns="http://www.w3.org/2000/svg"><defs><pattern id="dots" width="60" height="60" patternUnits="userSpaceOnUse"><circle cx="30" cy="30" r="1.5" fill="rgba(255,255,255,0.1)"/></pattern></defs><rect width="100%" height="100%" fill="url(%23dots)"/></svg>');
    opacity: 0.4;
}

.header-image-container {
    position: relative;
    max-width: 1400px;
    margin: 0 auto;
    padding: 15px 20px;
}

.header-image-container img {
    width: 100%;
    height: auto;
    display: block;
    position: relative;
    z-index: 1;
}

/* ==================== MAIN CONTENT CONTAINER ==================== */
.main-content {
    flex: 1;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 40px 20px;
    position: relative;
    background: linear-gradient(135deg, #b0e2ea, #ee7319);
}

.main-content::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: 
        radial-gradient(circle at 20% 30%, rgba(255, 193, 7, 0.06), transparent 60%),
        radial-gradient(circle at 80% 70%, rgba(255, 111, 60, 0.04), transparent 50%);
    pointer-events: none;
}

/* ==================== LOGIN CONTAINER ==================== */
.login-card {
    max-width: 1100px;
    width: 100%;
    background: var(--white);
    border-radius: 24px;
    box-shadow: 
        0 20px 60px rgba(0, 0, 0, 0.08),
        0 8px 24px rgba(0, 0, 0, 0.04);
    overflow: hidden;
    position: relative;
    z-index: 1;
}

/* Decorative top accent */
.login-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 6px;
    background: linear-gradient(90deg, 
        var(--primary-orange) 0%, 
        var(--golden-yellow) 50%, 
        var(--vibrant-orange) 100%
    );
}

/* ==================== LEFT SIDE - LOGIN FORM ==================== */
.login-section {
    padding: 20px 50px;
    background: linear-gradient(135deg, #ffffff 0%, #fefefe 100%);
    position: relative;
}

.login-section::after {
    content: '';
    position: absolute;
    top: 20%;
    right: -100px;
    width: 300px;
    height: 300px;
    background: radial-gradient(circle, rgba(255, 193, 7, 0.08), transparent 70%);
    border-radius: 50%;
    pointer-events: none;
}

.login-form-wrapper {
   /* max-width: 360px; */
    width: 100%;
    background: rgba(255, 255, 255, .65);
    backdrop-filter: blur(16px);
    border-radius: 22px;
    padding: 28px 28px;
    border: 1px solid rgba(18, 115, 235, .35);
    box-shadow: 0 20px 45px rgba(0, 0, 0, .18);
    text-align: center;
}

/* Logo Section */
.logo-section {
    text-align: center;
    margin-bottom: 35px;
}

.logo-section img {
    max-width: 110px;
    height: 95px;
    object-fit: contain;
    filter: drop-shadow(0 6px 16px rgba(0, 0, 0, 0.1));
    transition: transform 0.3s ease;
}

.logo-section img:hover {
    transform: scale(1.05);
}

/* Heading Styles */
.login-heading {
    text-align: center;
    margin-bottom: 40px;
}

.login-heading h2 {
    font-family: 'Playfair Display', serif;
    font-size: 36px;
    font-weight: 800;
    color: var(--text-charcoal);
    margin-bottom: 10px;
    letter-spacing: -0.5px;
    position: relative;
    display: inline-block;
}

.login-heading h2::after {
    content: '';
    position: absolute;
    bottom: -8px;
    left: 50%;
    transform: translateX(-50%);
    width: 80px;
    height: 4px;
    background: linear-gradient(90deg, var(--primary-orange), var(--golden-yellow));
    border-radius: 2px;
}

.login-heading p {
    color: var(--text-muted);
    font-size: 15px;
    font-weight: 500;
    margin-top: 15px;
    letter-spacing: 0.3px;
}

/* Form Fields */
.input-group {
    position: relative;
    margin-bottom: 20px;
}

.input-group i {
    position: absolute;
    top: 50%;
    left: 20px;
    transform: translateY(-50%);
    color: var(--primary-orange);
    font-size: 18px;
    z-index: 2;
    transition: all 0.3s ease;
}

.input-group input {
    width: 100%;
    height: 45px;
    padding: 0 20px 0 56px;
    border: 2px solid #e8e8e8;
    border-radius: 14px;
    font-size: 15px;
    font-weight: 500;
    color: var(--text-charcoal);
    background: var(--white);
    transition: all 0.3s ease;
    font-family: 'Inter', sans-serif;
}

.input-group input:focus {
    outline: none;
    border-color: var(--primary-orange);
    background: var(--soft-cream);
    box-shadow: 0 4px 16px var(--shadow-color);
    transform: translateY(-2px);
}

.input-group input:focus + i {
    color: var(--deep-orange);
    transform: translateY(-50%) scale(1.1);
}

.input-group input::placeholder {
    color: #b2b2b2;
    font-weight: 400;
}

/* Forgot Password */
.forgot-password {
    text-align: right;
    margin-bottom: 28px;
}

.forgot-password a {
    color: var(--text-muted);
    font-size: 13px;
    font-weight: 600;
    text-decoration: none;
    transition: all 0.3s ease;
    position: relative;
}

.forgot-password a::after {
    content: '';
    position: absolute;
    bottom: -2px;
    left: 0;
    width: 0;
    height: 2px;
    background: var(--primary-orange);
    transition: width 0.3s ease;
}

.forgot-password a:hover {
    color: var(--primary-orange);
}

.forgot-password a:hover::after {
    width: 100%;
}

/* Login Button */
.login-button {
    width: 90%;
    height: 40px;
    border: none;
    border-radius: 14px;
    background: linear-gradient(135deg, var(--primary-orange) 0%, var(--vibrant-orange) 100%);
    color: var(--white);
    font-size: 16px;
    font-weight: 700;
    text-transform: uppercase;
    letter-spacing: 2px;
    cursor: pointer;
    box-shadow: 
        0 8px 24px var(--shadow-color),
        0 4px 12px rgba(0, 0, 0, 0.08);
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    position: relative;
    overflow: hidden;
}

.login-button::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
    transition: left 0.6s ease;
}

.login-button:hover::before {
    left: 100%;
}

.login-button:hover {
    transform: translateY(-2px);
    box-shadow: 
        0 12px 32px var(--shadow-color),
        0 6px 16px rgba(0, 0, 0, 0.1);
}

.login-button:active {
    transform: translateY(0);
}

/* ERP Badge */
.erp-badge {
    /* text-align: center;
    margin-top: 30px; */
     font-size: 13px;
        font-weight: 700;
        margin: 8px;
        letter-spacing: 2px;
        font-family: 'Inter', sans-serif;
        margin: 12px auto;
        display: table;
        /* margin-bottom: 40px; */
        text-align: center;
        padding: 10px 10px;
        border-radius: 50px;
        /* background: linear-gradient(135deg, #1273eb 0%, #0d5ec4 100%); */
       color: #f58634;
        box-shadow: 
            0 8px 20px rgba(18, 115, 235, 0.4),
            inset 0 1px 0 rgba(255, 255, 255, 0.3);
        position: relative;
        overflow: hidden;
        text-transform: uppercase;
        animation: erpGlow 2s ease-in-out infinite;
}

.erp-badge span {
    display: inline-block;
    font-family: 'Inter', sans-serif;
    font-size: 13px;
    /* font-weight: 600; */
    color: #d1110c;
    letter-spacing: 2px;
    text-transform: uppercase;
    opacity: 0;
    animation: fadeInUp 0.15s ease forwards;
}

/* ==================== RIGHT SIDE - INFO PANEL ==================== */
.info-section {
    padding: 35px 38px;
    background: linear-gradient(135deg, var(--soft-cream) 0%, #fff9f0 100%);
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    position: relative;
    overflow: hidden;
}

.info-section::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 100%;
    background: radial-gradient(circle, rgba(255, 193, 7, 0.08), transparent 60%);
    animation: rotate 30s linear infinite;
}

@keyframes rotate {
    from { transform: rotate(0deg); }
    to { transform: rotate(360deg); }
}

/* Image Slider */
.image-carousel {
    width: 100%;
    max-width: 560px;
    height: 240px;
    border-radius: 20px;
    overflow: hidden;
    margin-bottom: 20px;
    box-shadow: 
        0 20px 50px rgba(0, 0, 0, 0.12),
        0 0 0 1px rgba(255, 111, 60, 0.1);
    position: relative;
    z-index: 1;
    border: 3px solid rgba(255, 193, 7, 0.3);
}

 

.carousel-inner {
    height: 100%;
}

.carousel-item {
    height: 100%;
}

.carousel-item img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

/* Info Text */
.info-content {
    text-align: center;
    position: relative;
    z-index: 1;
    max-width: 500px;
}

.info-title {
    font-size: 19px;
        font-weight: 800;
        color: #d90429;
        line-height: 1.4;
        letter-spacing: 0.5px;
        word-break: break-word;
        margin-bottom: 12px;
        margin-top: 0;
}

.info-title span {
    opacity: 0;
    display: inline-block;
    animation: fadeInUp 0.15s ease forwards;
}

.info-description {
    font-size: 14px;
    line-height: 1.8;
    color: var(--text-charcoal);
    /* margin-bottom: 20px; */
    font-weight: 500;
}

.info-footer {
      font-size: 13px;
        font-family: math;
        margin-top: 12px;
}

/* ==================== ANIMATIONS ==================== */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px) scale(0.95);
        filter: blur(3px);
    }
    to {
        opacity: 1;
        transform: translateY(0) scale(1);
        filter: blur(0);
    }
}

/* ==================== ALERT STYLES ==================== */
.alert {
    border-radius: 12px;
    border: none;
    margin-bottom: 24px;
    font-size: 14px;
    font-weight: 600;
    padding: 14px 18px;
}

.alert-danger {
    background: linear-gradient(135deg, #fff5f5, #ffe8e8);
    color: #c92a2a;
    border-left: 4px solid #fa5252;
}

/* ==================== MODAL STYLES ==================== */
.modal-content {
    border: none;
    border-radius: 20px;
    box-shadow: 0 20px 60px rgba(0, 0, 0, 0.2);
    overflow: hidden;
}

.modal-header.custom-header {
    background: linear-gradient(135deg, var(--primary-orange), var(--vibrant-orange));
    color: var(--white);
    border: none;
    padding: 24px;
}

.modal-header .btn-close {
    filter: invert(1) brightness(200%);
    opacity: 1;
}

.modal-body {
    padding: 50px 35px;
}

.btn-close-custom {
    background: linear-gradient(135deg, var(--text-charcoal), #1a1a1a);
    color: var(--white);
    border: none;
    padding: 12px 32px;
    border-radius: 10px;
    font-weight: 700;
    transition: all 0.3s ease;
}

.btn-close-custom:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2);
}


/* ==================== HEADER BANNER STRIP - Add to your CSS ==================== */
.header-banner-strip {
    width: 100%;
    background: linear-gradient(135deg, #e8e8e8, #f5f5f5);
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
    position: relative;
    overflow: hidden;
    padding: 20px 0;
}

.header-banner-strip::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(90deg, transparent 0%, rgba(255, 215, 0, 0.1) 50%, transparent 100%);
    animation: shimmer 3s ease-in-out infinite;
}

@keyframes shimmer {
    0%, 100% { opacity: 0.3; }
    50% { opacity: 0.6; }
}

.header-banner-container {
    position: relative;
    max-width: 1400px;
    margin: 0 auto;
    padding: 0 30px;
    z-index: 1;
}

.banner-content {
    text-align: center;
}

.trust-name {
    font-size: 14px;
    font-weight: 600;
    color: #2d3436;
   
   
    text-transform: uppercase;
}



.institute-main-name {
    font-size: 22px;
    font-weight: 900;
    color: #e93939 !important;
   text-align: center;
    text-transform: uppercase;
    
    
}

.institute-type {
    font-family: revert;
    display: inline-block;
    background-color:yellow;
    color: #0a0a0a;
    font-size: 14px;
    font-weight: 600;
    padding: 4px 8px;

    border-radius: 12px;
    text-transform: uppercase;
    letter-spacing: 1.5px;
    position:absolute;
    right: 100px;
    bottom: 6px;
 
    
   
}

/* Responsive Design */
@media (max-width: 768px) {
    .institute-main-name {
        font-size: 22px;
    }
    
    .trust-name {
        font-size: 14px;
    }
    
    .institute-type {
        font-size: 11px;
        padding: 6px 18px;
    }
}

</style>
</head>

<body class="authentication">

<!-- HEADER IMAGE STRIP -->
<!-- HEADER BANNER STRIP - Database Driven -->
<div class="header-banner-strip">
    <div class="header-banner-container">
        <div class="banner-content">
            <?php if(isset($heading_data->subHead4) && !empty($heading_data->subHead4)): ?>
                <div class="trust-name"><?= $heading_data->subHead4 ?></div>
            <?php endif; ?>
            
            <?php if(isset($heading_data->head) && !empty($heading_data->head)): ?>
                <div class="institute-main-name"><?= $heading_data->head ?></div>
            <?php endif; ?>
            
            <?php if(isset($heading_data->subhead5) && !empty($heading_data->subhead5)): ?>
                <div class="institute-type"><?= $heading_data->subhead5 ?></div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- MAIN CONTENT -->
<div class="main-content">
    <div class="login-card">
        <div class="row g-0">
            
            <!-- LEFT SIDE - LOGIN FORM -->
            <div class="col-12 col-md-6">
                <div class="login-section">
                    <div class="login-form-wrapper">
                        
                        <!-- Logo -->
                        <div class="logo-section">
                            <?php if(isset($heading_data->logo) && !empty($heading_data->logo)): ?>
                                <img src="<?=base_url()?>Assets/images/<?=$heading_data->logo?>" alt="Institute Logo">
                            <?php endif; ?>
                        </div>

                        <!-- Heading -->
                        <!-- <div class="login-heading">
                            <h2>Welcome Back</h2>
                            <p>Sign in to access your ERP Portal</p>
                        </div> -->

                        <!-- Error Message -->
                        <?php if($this->session->flashdata('error')): ?>
                            <div class="alert alert-danger" role="alert">
                                <i class="fas fa-exclamation-circle me-2"></i>
                                <?=$this->session->flashdata('error')?>
                            </div>
                        <?php endif; ?>

                        <!-- Login Form -->
                        <?=form_open('admin/MenuLogin/login_validation')?>
                            
                            <div class="input-group">
                                <input type="text" name="userName" placeholder="Enter User ID" value="<?=set_value('userName')?>" required>
                                <i class="fa fa-user"></i>
                            </div>
                            <?=form_error('userName', '<div class="text-danger small">', '</div>')?>

                            <div class="input-group">
                                <input type="password" name="password" placeholder="Enter Password" required>
                                <i class="fa fa-lock"></i>
                            </div>
                            <?=form_error('password', '<div class="text-danger small">', '</div>')?>

                            <div class="forgot-password">
                                <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#forgotPasswordModal">
                                    <i class="fas fa-question-circle me-1"></i>Forgot Password?
                                </a>
                            </div>

                            <button type="submit" class="login-button">
                                <i class="fas fa-sign-in-alt me-2"></i>Login
                            </button>
                            
                        <?=form_close()?>

                        <!-- ERP Badge -->
                        <!-- ERP Badge -->
<div class="erp-badge">
    <span id="erpText"><?= isset($heading_data->erpText) ? $heading_data->erpText : 'SHARAD ERP SOFTWARE' ?></span>
</div>
                    </div>
                </div>
            </div>

            <!-- RIGHT SIDE - INFO PANEL -->
            <div class="col-12 col-md-6">
                <div class="info-section">
                    
                    <!-- Image Slider -->
                    <div id="collegeSlider" class="carousel slide image-carousel" data-bs-ride="carousel">
                        <div class="carousel-inner">
                            <?php if(!empty($slider_images)): ?>
                                <?php foreach($slider_images as $index => $image): ?>
                                    <div class="carousel-item <?=$index === 0 ? 'active' : ''?>">
                                        <img src="<?=base_url()?>Assets/images/<?=$image?>" alt="Campus View <?=$index + 1?>">
                                    </div>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Info Content -->
                    <div class="info-content">
                        <h3 class="info-title" id="infoTitle">
                            <?= isset($heading_data->head) ? $heading_data->head : '' ?>
                        </h3>
                        
                        <p class="info-description">
                            <?= isset($heading_data->subHead2) ? $heading_data->subHead2 : '' ?>
                        </p>
                        
                        <div class="info-footer">
                            <?= isset($heading_data->subHead3) ? $heading_data->subHead3 : '' ?>
                        </div>
                    </div>

                </div>
            </div>

        </div>
    </div>
</div>

<!-- FORGOT PASSWORD MODAL -->
<div class="modal fade" id="forgotPasswordModal" tabindex="-1" aria-labelledby="forgotPasswordModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header custom-header">
                <h5 class="modal-title" id="forgotPasswordModalLabel">
                    <i class="fas fa-lock me-2"></i>Forgot Password
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center">
                <i class="fas fa-headset" style="font-size: 54px; color: var(--primary-orange); margin-bottom: 24px;"></i>
                <h4 class="fw-bold mb-3" style="color: var(--text-charcoal);">Need Help?</h4>
                <p class="text-muted" style="font-size: 15px; line-height: 1.7;">
                    If you've forgotten your password, please contact the administrator for assistance.
                </p>
                <h5 class="fw-bold mt-4" style="color: var(--text-charcoal);">
                    <i class="fas fa-phone-alt me-2" style="color: var(--primary-orange);"></i>
                    Helpline: 1800-233-1419
                </h5>
            </div>
            <div class="modal-footer" style="border-top: none; padding: 20px 24px;">
                <button type="button" class="btn-close-custom" data-bs-dismiss="modal">
                    <i class="fas fa-times me-2"></i>Close
                </button>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="<?=base_url()?>Assets/js/bootstrap.bundle.min.js"></script>
<script>
// Animate heading text
// Animate heading text
const titleElement = document.getElementById("infoTitle");
if(titleElement && titleElement.innerHTML.trim() !== '') {
    const text = titleElement.innerHTML.trim();  // .trim() add kiya
    titleElement.innerHTML = "";
    let delay = 0;
    for (let char of text) {
        if (char === "<") {
            titleElement.innerHTML += char;
            continue;
        }
        const span = document.createElement("span");
        span.innerHTML = char === " " ? "&nbsp;" : char;
        span.style.animationDelay = delay + "s";
        titleElement.appendChild(span);
        delay += 0.09;
    }
}

// Animate ERP badge
const erpElement = document.getElementById("erpText");
if(erpElement) {
    const erpText = erpElement.innerHTML;
    erpElement.innerHTML = "";
    let delay = 0;
    for (let char of erpText) {
        const span = document.createElement("span");
        span.innerHTML = char === " " ? "&nbsp;" : char;
        span.style.animationDelay = delay + "s";
        erpElement.appendChild(span);
        delay += 0.09;
    }
}
</script>

</body>
</html>