<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="shortcut icon" href="<?= base_url() ?>Assets/images/sit_logo.png">
<link rel="stylesheet" href="<?= base_url() ?>Assets/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700&display=swap" rel="stylesheet">

<style>
    /* BACKGROUND */
    body.authentication {
        font-family: 'Inter', sans-serif;
        background: linear-gradient(135deg,
                rgba(255, 255, 255, 0.95),
                rgba(245, 245, 245, 0.9),
                rgba(230, 230, 230, 0.95));
        background-size: cover;
        background-position: center;
        background-attachment: fixed;
        min-height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 20px 10px;
        overflow-x: hidden;
    }

    /* MAIN CONTAINER - Header + Content ek saath */
    .login-container {
        max-width: 1200px;
        width: 100%;
        background: linear-gradient(145deg, #ffffff, #f2f7ff);
        border-radius: 18px;
        box-shadow: 0 35px 80px rgba(0, 0, 0, .25);
        overflow: hidden;
    }

    /* HEADER SECTION - Container ke andar */
    .header-banner {
        width: 100%;
        text-align: center;
        padding: 20px 20px 15px 20px;
        background: linear-gradient(145deg, #ffffff, #f8f9fa);
        border-bottom: 2px solid rgba(215, 204, 187, 0.9);
    }

    .header-banner img {
        max-width: 1400px;
        width: 100%;
        height: auto;
        object-fit: contain;
        filter: drop-shadow(0 4px 12px rgba(0, 0, 0, 0.15));
    }

    /* LOGIN SECTION */
    .login-wrapper {
        padding: 30px 40px 40px 40px;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .login-box {
        max-width: 360px;
        width: 100%;
        background: rgba(255, 255, 255, .65);
        backdrop-filter: blur(16px);
        border-radius: 22px;
        padding: 28px 28px;
        border: 1px solid rgba(18, 115, 235, .35);
        box-shadow: 0 20px 45px rgba(0, 0, 0, .18);
        text-align: center;
    }

    .login-box img {
        max-width: 100%;
        height: auto;
    }

    .field-wrapper {
        position: relative;
        margin-bottom: 14px;
    }

    .field-wrapper i {
        position: absolute;
        top: 50%;
        left: 16px;
        transform: translateY(-50%);
        color: #1273eb;
    }

    .field-wrapper input {
        width: 100%;
        height: 42px;
        padding-left: 42px;
        border-radius: 25px;
        border: 1px solid #ccc;
    }

    .field-wrapper input:focus {
        outline: none;
        border-color: #1273eb;
        box-shadow: 0 0 0 3px rgba(18, 115, 235, 0.1);
    }

    .forgot-pass {
        text-align: right;
        margin-bottom: 18px;
    }

    .forgot-pass a {
        font-size: 12px;
        color: #1273eb;
        font-weight: 600;
        text-decoration: none;
    }

    .forgot-pass a:hover {
        text-decoration: underline;
    }

    .btn-primary {
        width: 100%;
        border: none;
        border-radius: 25px;
        background: #1273eb;
        padding: 10px;
        color: #ffffff;
        font-weight: 600;
        transition: all 0.3s ease;
    }

    .btn-primary:hover {
        background: #0d5ec4;
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(18, 115, 235, 0.3);
    }

    /* ERP TEXT - IMPROVED DESIGN */
    .erp-text {
        font-size: 18px;
        font-weight: 700;
        margin: 8px;
        letter-spacing: 2px;
        font-family: 'Inter', sans-serif;
        margin: 12px auto;
        display: table;
        margin-bottom: 40px;
        text-align: center;
        padding: 12px 30px;
        border-radius: 50px;
        /* background: linear-gradient(135deg, #1273eb 0%, #0d5ec4 100%); */
       color: #f58634;
        box-shadow: 
            0 8px 20px rgba(18, 115, 235, 0.4),
            inset 0 1px 0 rgba(255, 255, 255, 0.3);
        position: relative;
        overflow: hidden;
        text-transform: uppercase;
        animation: erpGlow 2s ease-in-out infinite;
    }

    .erp-text::before {
        content: '';
        position: absolute;
        top: -50%;
        left: -50%;
        width: 200%;
        height: 200%;
        /* background: linear-gradient(45deg, transparent, rgba(255, 255, 255, 0.1), transparent); */
        transform: rotate(45deg);
        animation: erpShine 3s linear infinite;
    }

    .erp-text span {
        position: relative;
        z-index: 1;
    }

    /* @keyframes erpGlow {
        0%, 100% {
            box-shadow: 
                0 8px 20px rgba(210, 94, 94, 0.4),
                inset 0 1px 0 rgba(194, 68, 79, 0.89);
        }
        50% {
            box-shadow: 
                0 8px 30px rgba(183, 121, 121, 0.93),
                0 0 40px rgba(204, 121, 121, 0.82),
                inset 0 1px 0 rgba(172, 125, 128, 0.99);
        }
    } */

    @keyframes erpShine {
        0% {
            transform: translateX(-100%) translateY(-100%) rotate(45deg);
        }
        100% {
            transform: translateX(100%) translateY(100%) rotate(45deg);
        }
    }

    /* RIGHT PANEL */
    .login-about {
        background: linear-gradient(145deg, #f2f7ff, #e6efff);
        padding: 30px 35px;
        text-align: center;
        display: flex;
        flex-direction: column;
        justify-content: center;
    }

    /* IMAGE SLIDER - Reduced bottom margin */
    .college-slider {
        width: 100%;
        max-width: 480px;
        height: 200px;
        margin: 0 auto 8px;
        border-radius: 18px;
        overflow: hidden;
        background: #fff;
        box-shadow: 0 25px 50px rgba(0, 0, 0, .25);
    }

    .college-slider img {
        width: 100%;
        height: 200px;
        object-fit: cover;
    }

    /* TYPING ANIMATION */
    .flash-text {
        font-size: 18px;
        font-weight: 800;
        color: #d90429;
        line-height: 1.4;
        letter-spacing: 0.5px;
        word-break: break-word;
        margin-bottom: 12px;
        margin-top: 0;
    }

    .flash-text span {
        opacity: 0;
        display: inline-block;
        animation: letterType 0.15s ease forwards;
    }

    @keyframes letterType {
        from {
            opacity: 0;
            transform: translateY(8px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .footer-text {
        font-size: 13px;
        font-family: math;
        margin-top: 12px;
    }

    /* RESPONSIVE */

    /* Extra Large devices (large desktops, 1200px and up) */
    @media (min-width: 1200px) and (max-width: 1399px) {
        .header-banner img {
            max-width: 1150px;
        }

        .login-wrapper {
            padding: 10px 35px 40px 35px;
        }

        .login-about {
            padding: 30px 35px;
        }
    }

    /* Large devices (desktops, 992px and up) */
    @media (min-width: 992px) and (max-width: 1199px) {
        .header-banner {
            padding: 18px 20px 12px 20px;
        }

        .header-banner img {
            max-width: 680px;
        }

        .login-wrapper {
            padding: 25px 25px 35px 25px;
        }

        .login-about {
            padding: 30px 25px;
        }

        .college-slider {
            max-width: 420px;
            height: 180px;
            margin-bottom: 8px;
        }

        .college-slider img {
            height: 180px;
        }
    }

    /* Medium devices (tablets, 768px and up) */
    @media (min-width: 768px) and (max-width: 991px) {
        .header-banner {
            padding: 15px 20px 12px 20px;
        }

        .header-banner img {
            max-width: 650px;
        }

        .login-wrapper {
            padding: 35px 25px 40px 25px;
        }

        .login-about {
            padding: 40px 25px;
        }

        .login-box {
            padding: 35px 28px;
        }

        .college-slider {
            max-width: 400px;
            height: 200px;
            margin-bottom: 8px;
        }

        .college-slider img {
            height: 200px;
        }

        .flash-text {
            font-size: 20px;
        }
    }

    /* Small devices (landscape phones, less than 768px) */
    @media (max-width: 767px) {
        body.authentication {
            padding: 15px 10px;
        }

        .login-container {
            border-radius: 12px;
        }

        .header-banner {
            padding: 15px 15px 12px 15px;
        }

        .header-banner img {
            max-width: 500px;
            width: 95%;
        }

        .login-wrapper {
            padding: 35px 20px 40px 20px;
        }

        .login-box {
            padding: 35px 25px;
            max-width: 100%;
        }

        .login-about {
            padding: 40px 20px;
        }

        .college-slider {
            height: 200px;
            border-radius: 12px;
            margin-bottom: 8px;
        }

        .college-slider img {
            height: 200px;
        }

        .flash-text {
            font-size: 18px;
        }

        .erp-text {
            font-size: 14px;
            padding: 10px 24px;
            letter-spacing: 1.5px;
        }
    }

    /* Extra small devices (portrait phones, less than 576px) */
    @media (max-width: 575px) {
        body.authentication {
            padding: 10px 8px;
        }

        .header-banner {
            padding: 12px 10px 10px 10px;
        }

        .header-banner img {
            max-width: 380px;
        }

        .login-wrapper {
            padding: 25px 15px 30px 15px;
        }

        .login-box {
            padding: 30px 20px;
            border-radius: 18px;
        }

        .login-about {
            padding: 30px 15px;
        }

        .college-slider {
            height: 180px;
            margin-bottom: 8px;
        }

        .college-slider img {
            height: 180px;
        }

        .flash-text {
            font-size: 16px;
            letter-spacing: 0.5px;
        }

        .footer-text {
            font-size: 11px;
        }

        .field-wrapper input {
            height: 40px;
            font-size: 14px;
        }

        .erp-text {
            font-size: 11px;
            padding: 8px 18px;
            letter-spacing: 1.2px;
        }
    }

    /* Very small devices (less than 400px) */
    @media (max-width: 399px) {
        .header-banner img {
            max-width: 320px;
        }

        .login-box {
            padding: 25px 15px;
        }

        .college-slider {
            height: 160px;
            margin-bottom: 8px;
        }

        .college-slider img {
            height: 160px;
        }

        .flash-text {
            font-size: 20px;
        }

        .erp-text {
            font-size: 10px;
            padding: 7px 15px;
        }
    }
</style>
</head>

<body class="authentication">

    <!-- MAIN CONTAINER - Header + Content ek saath -->
    <div class="login-container">
        
        <!-- HEADER BANNER - Container ke andar -->
        <div class="header-banner">
            <img src="<?= base_url() ?>Assets\images\upimage-removebg-preview.png" alt="Header Banner">
        </div>

        <!-- LOGIN + RIGHT PANEL -->
        <div class="row g-0">

            <!-- LOGIN -->
            <div class="col-12 col-md-6">
                <div class="login-wrapper">
                    <div class="login-box">
                        <span><img src="<?= base_url() ?>Assets/images/sit_logo.png" alt="Logo"
                                style="height: 100px; width: 150px;"></span>
                        <h4 style="color:#1273eb;font-weight:700;"></h4><br>

                        <div class="field-wrapper">
                            <i class="fa fa-user"></i>
                            <input type="text" placeholder="User ID">
                        </div>

                        <div class="field-wrapper">
                            <i class="fa fa-lock"></i>
                            <input type="password" placeholder="Password">
                        </div>

                        <div class="forgot-pass">
                            <a href="https://www.google.com/">Forgot Password?</a>
                        </div>

                        <button class="btn btn-primary">LOGIN</button>
                    </div>
                </div>
                <div class="erp-text text-center mt-0">
                    <span id="erpText">Sharad Pattern Erp Software</span>
                </div>
            </div>

            <!-- RIGHT -->
            <div class="col-12 col-md-6 login-about">

                <div id="collegeSlider" class="carousel slide college-slider" data-bs-ride="carousel">
                    <div class="carousel-inner">
                        <div class="carousel-item active">
                            <img src="<?= base_url() ?>Assets/images/s1.png">
                        </div>
                        <div class="carousel-item">
                            <img src="<?= base_url() ?>Assets/images/s3.png">
                        </div>
                        <div class="carousel-item">
                            <img src="<?= base_url() ?>Assets/images/s6.png">
                        </div>
                        <div class="carousel-item">
                            <img src="<?= base_url() ?>Assets/images/s1.png">
                        </div>
                        <div class="carousel-item">
                            <img src="<?= base_url() ?>Assets/images/s6.png">
                        </div>
                    </div>
                </div>

                <h5 class="flash-text" id="typeText">
                   <?= isset($heading_data->head) ? $heading_data->head : '' ?>
                </h5>

                <p>
                    <?= isset($heading_data->subHead2) ? $heading_data->subHead2 : '' ?>
                </p>

                <div class="footer-text">
                      <?= isset($heading_data->subHead3) ? $heading_data->subHead3 : '' ?>
                </div>

            </div>

        </div>
    </div>

    <script>
        // Main heading animation - START FROM BEGINNING
        const textElement = document.getElementById("typeText");
        if (textElement && textElement.innerHTML.trim() !== '') {
            const text = textElement.innerHTML;
            textElement.innerHTML = "";
            let delay = 0;
            for (let char of text) {
                if (char === "<") {
                    textElement.innerHTML += char;
                    continue;
                }
                const span = document.createElement("span");
                span.innerHTML = char === " " ? "&nbsp;" : char;
                span.style.animationDelay = delay + "s";
                textElement.appendChild(span);
                delay += 0.05;
            }
        }

        // ERP text animation
        const erpElement = document.getElementById("erpText");
        if (erpElement) {
            const text = erpElement.innerText;
            erpElement.innerHTML = "";

            for (let char of text) {
                const span = document.createElement("span");
                span.innerHTML = char === " " ? "&nbsp;&nbsp;" : char;
                erpElement.appendChild(span);
            }
        }
    </script>
    <script src="<?= base_url() ?>Assets/js/bootstrap.bundle.min.js"></script>
</body>
</html>