<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        font-family: 'Inter', sans-serif;
        overflow-x: hidden;
    }
    .content-wrapper {
    padding: 0 1.5rem 0 1.5rem;
    height: calc(200vh - 150px) !important;
    overflow: auto;
    background-color: white;
    }

    /* ============ YOUR EXISTING HEADER - DON'T TOUCH ============ */
    /* Header should have higher z-index (like 1100 or 1200) */
    /* We assume header height is around 70-80px */
    
    /* ============ MENU REPORT CONTAINER ============ */
    .menu-report-container {
        font-family: 'Inter', sans-serif;
        background:white;
        background-size: cover;
        min-height: calc(100vh - 80px);
        padding: 10px;
        position: relative;
    }
    
    .menu-report-container::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(255, 255, 255, 0.85);
        z-index: 0;
    }

    .menu-report-inner {
        margin: 0 auto;
        position: relative;
        z-index: 1;
        height: calc(100vh - 120px);
        display: flex;
        flex-direction: column;
    }

    /* Main Content Row */
    .content-row {
        display: flex;
        gap: 0;
        position: relative;
        flex: 1;
        overflow: hidden;
        border-radius: 18px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
    }

    /* ============ TOGGLE BUTTON - ALWAYS VISIBLE ============ */
    .sidebar-toggle-btn {
        position: absolute;
        left: 15px;
        top: 15px;
        z-index: 1001;
        background: linear-gradient(135deg, #ff6b9d 0%, #ff8fb3 100%);
        border: none;
        border-radius: 12px;
        width: 40px;
        height: 40px;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        box-shadow: 0 4px 15px rgba(255, 107, 157, 0.4);
        transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .sidebar-toggle-btn:hover {
        transform: scale(1.1);
        box-shadow: 0 6px 20px rgba(255, 107, 157, 0.6);
    }

    .sidebar-toggle-btn i {
        font-size: 1.3rem;
        color: white;
        transition: all 0.3s ease;
    }

    /* Icon transition */
    .sidebar-toggle-btn .fa-bars {
        display: block;
    }

    .sidebar-toggle-btn .fa-times {
        display: none;
    }

    .sidebar-toggle-btn.active .fa-bars {
        display: none;
    }

    .sidebar-toggle-btn.active .fa-times {
        display: block;
    }

    /* Button moves with sidebar */
    .sidebar-toggle-btn.active {
        left: 265px; /* Sidebar width + 15px */
    }

    /* ============ OVERLAY - CONTAINED IN REPORT CONTAINER ============ */
    .sidebar-overlay {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0, 0, 0, 0.5);
        z-index: 999;
        opacity: 0;
        visibility: hidden;
        transition: all 0.3s ease;
        pointer-events: none;
    }

    .sidebar-overlay.active {
        opacity: 1;
        visibility: visible;
        pointer-events: all;
    }

    /* ============ LEFT SIDEBAR ============ */
    .menu-sidebar {
        position: absolute;
        left: -280px;
        top: 0;
        bottom: 0;
        width: 250px;
        background: white;
        box-shadow: 2px 0 15px rgba(0, 0, 0, 0.1);
        display: flex;
        flex-direction: column;
        z-index: 1000;
        transition: left 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        overflow: hidden;
    }

    .menu-sidebar.active {
        left: 0;
    }

    /* Menu Header Section */
    .menu-header {
        padding: 15px 10px 10px 10px;
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        border-bottom: 1px solid #dee2e6;
        flex-shrink: 0;
    }

    /* Menu Report Title */
    .menu-report-title {
        margin-bottom: 12px;
        text-align: center;
    }

    .menu-report-title h3 {
        color: #495057;
        font-size: 1.1rem;
        font-weight: 600;
        letter-spacing: 0.5px;
        margin: 0;
        text-transform: uppercase;
        background: linear-gradient(135deg, #ff6b9d 0%, #ff8fb3 100%);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
    }

    .menu-search-input {
        width: 100%;
        padding: 10px 15px;
        border: 1px solid #ced4da;
        border-radius: 20px;
        font-family: 'Inter', sans-serif;
        font-size: 0.9rem;
        transition: all 0.3s ease;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
        color: #495057;
    }

    .menu-search-input::placeholder {
        color: #adb5bd;
    }

    .menu-search-input:focus {
        outline: none;
        border-color: #ff8fb3;
        box-shadow: 0 0 0 3px rgba(255, 107, 157, 0.1);
    }

    /* Menu List Container with Scroll */
    .menu-list-scroll {
        flex: 1;
        overflow-y: auto;
        overflow-x: hidden;
        padding: 10px;
        height: 100%;
        -webkit-overflow-scrolling: touch;
    }

    /* Custom Scrollbar */
    .menu-list-scroll::-webkit-scrollbar {
        width: 6px;
        display: block !important;
    }

    .menu-list-scroll::-webkit-scrollbar-track {
        background: #f8f9fa;
        border-radius: 10px;
        margin: 3px;
    }

    .menu-list-scroll::-webkit-scrollbar-thumb {
        background: linear-gradient(135deg, #ff6b9d 0%, #ff8fb3 100%);
        border-radius: 10px;
        border: 1px solid #f8f9fa;
    }

    .menu-list-scroll::-webkit-scrollbar-thumb:hover {
        background: linear-gradient(135deg, #ff8fb3 0%, #ff6b9d 100%);
    }

    .menu-list-scroll {
        scrollbar-width: thin;
        scrollbar-color: #ff6b9d #f8f9fa;
    }

    /* Menu Items */
    .menu-item {
        padding: 12px 14px;
        margin-bottom: 10px;
        border-radius: 10px;
        cursor: pointer;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.05);
        border: 1px solid transparent;
        user-select: none;
        -webkit-user-select: none;
    }

    .menu-item:hover {
        transform: translateX(3px);
        box-shadow: 0 3px 10px rgba(0, 0, 0, 0.1);
        border-color: #ff8fb3;
    }

    .menu-item.active {
        background: linear-gradient(135deg, #ff6b9d 0%, #ff8fb3 100%) !important;
        color: white;
        transform: translateX(3px);
        box-shadow: 0 3px 15px rgba(255, 107, 157, 0.3);
    }

    .menu-item-text {
        font-size: 13px;
        font-weight: 600;
        color: #495057;
        line-height: 1.4;
        pointer-events: none;
    }

    .menu-item.active .menu-item-text {
        color: white;
    }

    /* Pastel Colors */
   .menu-item:nth-child(5n+1) {
        background: linear-gradient(135deg, #e69cb6 0%, #fff2f6 100%);
    }

    .menu-item:nth-child(5n+2) {
        background: linear-gradient(135deg, #9bc9f4 0%, #f0f7ff 100%);
    }

    .menu-item:nth-child(5n+3) {
        background: linear-gradient(135deg, #c690f0 0%, #faf2ff 100%);
    }

    .menu-item:nth-child(5n+4) {
        background: linear-gradient(135deg, #f5c572 0%, #fffaf0 100%);
    }

    .menu-item:nth-child(5n+5) {
        background: linear-gradient(135deg, #fe80c7 0%, #fff5fa 100%);
    }

    .menu-item.active:nth-child(n) {
        background: linear-gradient(135deg, #ff6b9d 0%, #ff8fb3 100%) !important;
    }


    /* ============ RIGHT CONTENT - FULL WIDTH ============ */
    .graph-content {
        flex: 1;
        width: 100%;
        background: white;
        padding: 15px;
        overflow: visible;
        height: 100%;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        position: relative;
    }

    /* Welcome Screen */
    .welcome-screen {
        text-align: center;
        padding: 60px 20px;
        color: #6c757d;
        height: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
    }

    .welcome-screen i {
        font-size: 4rem;
        margin-bottom: 20px;
        opacity: 0.3;
        color: #ff6b9d;
    }

    .welcome-screen h2 {
        font-size: 1.8rem;
        margin-bottom: 15px;
        color: #495057;
    }

    .welcome-screen p {
        font-size: 1rem;
        color: #6c757d;
    }

    /* ============ HEADER CONTAINER FOR BUTTON AND MENU NAME ============ */
    .report-header {
        display: flex;
        align-items: center;
        gap: 15px;
        margin-bottom: 10px;
        padding: 0 15px;
        margin-top: 0px; /* Space for the toggle button */
        margin-left: 40px;
    }

    /* Menu Name Label */
    .menu-name-label {
        flex: 1;
        padding: 12px 20px;
        background: linear-gradient(135deg, #5d52eb 0%, #3e61db 100%);
        border-radius: 12px;
        color: white;
    }

    .menu-name-label h5 {
        margin: 0;
        font-size: 1.1rem;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .menu-name-label i {
        font-size: 1.2rem;
    }

    /* Iframe Styles */
    .iframe-container {
        width: 100%;
        /*height: calc(100% - 150px);  */
        height: calc(100%);/
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 2px 15px rgba(0, 0, 0, 0.08);
        background: #f8f9fa;
    }

    .report-iframe {
        width: 100%;
        height: 100%;
        border: none;
        background: white;
    }

    .iframe-loader {
        text-align: center;
        padding: 60px 20px;
        color: #adb5bd;
        height: calc(100% - 150px); /* Adjusted for header */
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
    }

    .iframe-loader i {
        font-size: 2.5rem;
        margin-bottom: 15px;
        animation: spin 1s linear infinite;
        color: #ff6b9d;
    }

    .iframe-loader p {
        font-size: 1rem;
        font-weight: 500;
        color: #6c757d;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    /* No Data State */
    .menu-no-data {
        text-align: center;
        padding: 60px 20px;
        color: #adb5bd;
    }

    .menu-no-data i {
        font-size: 2.5rem;
        margin-bottom: 15px;
        opacity: 0.5;
    }

    .menu-no-data p {
        font-size: 1rem;
        font-weight: 500;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .menu-sidebar {
            width: 220px;
            left: -240px;
        }

        .sidebar-toggle-btn {
            left: 10px;
            top: 10px;
            width: 45px;
            height: 45px;
        }

        .sidebar-toggle-btn.active {
            left: 230px;
        }

        .menu-report-container {
            padding: 10px;
        }

        .report-header {
            gap: 10px;
        }
    }
   
</style>

<!-- Menu Report Container -->
<div class="menu-report-container">
    <div class="menu-report-inner">
        <!-- Main Content Row -->
        <div class="content-row">
            <!-- Sidebar Toggle/Close Button (Always Visible) -->
            <button class="sidebar-toggle-btn active" id="sidebarToggleBtn">
                <i class="fas fa-bars"></i>
                <i class="fas fa-times"></i>
            </button>

            <!-- Sidebar Overlay (Contained in Report Container) -->
            <div class="sidebar-overlay active" id="sidebarOverlay"></div>

            <!-- Left Sidebar - Menu List -->
            <div class="menu-sidebar active" id="menuSidebar">
                <!-- Menu Header with Title -->
                <div class="menu-header">
                    <!-- Menu Report Title -->
                    
                    
                    <!-- Search Input -->
                    <input type="text" class="menu-search-input" id="searchInput" placeholder="Search report...">
                </div>

                <!-- Menu List with Scroll -->
                <div class="menu-list-scroll" id="menuListScroll">
                    <?php if(!empty($menudata)): ?>
                        <?php foreach($menudata as $menu): ?>
                            <div class="menu-item"
                                 data-id="<?= $menu->MenuID ?>"
                                 data-url="<?= $menu->MenuURL ?>"
                                 data-name="<?= $menu->MenuName ?>">
                                <div class="menu-item-text"><?= htmlspecialchars($menu->MenuName) ?></div>
                            </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <div class="menu-no-data">
                            <i class="fas fa-folder-open"></i>
                            <p>No menu items available</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Right Content Area - Graph Section (Full Width) -->
            <div class="graph-content" id="graphContent">
                <!-- Welcome Screen (Default) -->
                <div class="welcome-screen" id="welcomeScreen">
                    <i class="fas fa-chart-pie"></i>
                    <h2>Select a Report</h2>
                    <p>Choose a report from the menu to view analysis</p>
                </div>

                <!-- Iframe Report Section -->
                <div id="iframeReportWrapper" style="display:none; height: 100%; overflow: hidden;">
                    <!-- Header Container with Menu Name -->
                    <div class="report-header">
                        <!-- Menu Name Label -->
                        <div class="menu-name-label" id="iframeMenuNameLabel">
                            <h5>
                                <i class="fas fa-file-alt"></i>
                                <span id="iframeMenuName"></span>
                            </h5>
                        </div>
                    </div>

                    <!-- Iframe Loader -->
                    <div class="iframe-loader" id="iframeLoader">
                        <i class="fas fa-spinner fa-spin"></i>
                        <p>Loading report...</p>
                    </div>

                    <!-- Iframe Container -->
                    <div class="iframe-container" id="iframeContainer" style="display:none;">
                        <iframe id="reportIframe" class="report-iframe" src=""></iframe>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
let currentMenuId = null;
let currentMenuName = null;

// Menu configuration mapping
const menuConfig = {
    1: {
        name: 'Student Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/StudentReg/TotalStudent') ?>',
        controllerName: 'StudentReg'
    },
    2: {
        name: 'Student Placement Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/TotalPlace/create') ?>',
        controllerName: 'TotalPlace'
    },
    3: {
        name: 'Entrepreneurship Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/Enter/Report') ?>',
        controllerName: 'Enter'
    },
    4: {
        name: 'Internship Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/InternshipReport/Report') ?>',
        controllerName: 'InternshipReport'
    },
    5: {
        name: 'Guest Lecture Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/GuestReport/Report') ?>',
        controllerName: 'GuestReport'
    },
    6: {
        name: 'Industry Visit Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/Industry_report/create') ?>',
        controllerName: 'Industry_report'
    },
    7: {
        name: 'Annual Sports Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/AnnualSports/Report') ?>',
        controllerName: 'AnnualSports'
    },
    8: {
        name: 'Institute Award Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/Award/Report') ?>',
        controllerName: 'Award'
    },
    9: {
        name: 'Earn and Learn Data Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/JobStudentReport/Report') ?>',
        controllerName: 'JobStudentReport'
    },
    10: {
        name: 'Software Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/Soft_report/create') ?>',
        controllerName: 'Soft_report'
    },
    11: {
        name: 'Institute Technical Magzines & Newsletters Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/Companypub_report/create') ?>',
        controllerName: 'Companypub_report'
    },
    12: {
        name: 'Student Club Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/StudentClub/Report') ?>',
        controllerName: 'StudentClub'
    },
    13: {
        name: 'Student/Faculty Publication Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/Studentpub_report/create') ?>',
        controllerName: 'Studentpub_report'
    },
    14: {
        name: 'Technical Event Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/Tech_report/create') ?>',
        controllerName: 'Tech_report'
    },
    15: {
        name: 'Industrial Trainer Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/IndustrialtranReport/Report') ?>',
        controllerName: 'IndustrialtranReport'
    },
    16: {
        name: 'Value Addition Program (VAP) Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/VAPReport/Report') ?>',
        controllerName: 'VAPReport'
    },
     17: {
       name: 'Patent Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/PatentReport/Report') ?>',
        controllerName: 'PatentReport'
    },
     18: {
        name: 'Parent Meeting Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/ParentMeet/Report') ?>',
        controllerName: 'ParentMeet'
    },
     19: {
        name: 'NSS Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/NSS/Report') ?>',
        controllerName: 'NSS'
    },
   20: {
        name: 'Mentorship Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/Proctor/Report') ?>',
        controllerName: 'Proctor'
    },
     21: {
        name: 'Mini & Mega Project Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/MiniAdd/Report') ?>',
        controllerName: 'MiniAdd'
    },
     22: {
        name: 'First Year Induction Programme Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/Firstinduct_report/create') ?>',
        controllerName: 'Firstinduct_report'
    },
     23: {
        name: 'Budget Utilazation Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/BudgetutiReport/Report') ?>',
        controllerName: 'BudgetutiReport'
    },
     24: {
        name: 'ICT Tools Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/ICTtoolsReport/Report') ?>',
        controllerName: 'ICTtoolsReport'
    },
       25: {
        name: 'UG Fellowship Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/UGfellowReport/Report') ?>',
        controllerName: 'UGfellowReport'
    },
       26: {
        name: 'MOU Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/Mou/Report') ?>',
        controllerName: 'Mou'
    },
       27: {
        name: 'Scholarship Data Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/ScholershipReport/Report') ?>',
        controllerName: 'ScholershipReport'
    },
       28: {
        name: 'Cultural Events Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/Conf_cultReport/create') ?>',
        controllerName: 'Conf_cultReport'
    },
       29: {
        name: 'Student Association Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/StudnewAssociation/Report') ?>',
        controllerName: 'StudnewAssociation'
    },

       31: {
        name: 'Consultancy Data Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/Consultancy_report/create') ?>',
        controllerName: 'Consultancy_report'
    },
       33: {
        name: 'Library Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/Library_Report/Report') ?>',
        controllerName: 'Library_Report'
    },
    34: {
        name: 'Industrial Problem Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/Industrial_problereport/create') ?>',
        controllerName: 'Industrial_problereport'
    },
      35: {
        name: 'STTP/FDP attended by Faculty Reports',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/Sttp_Fdp_report/create') ?>',
        controllerName: 'Sttp_Fdp_report'
    },
      36: {
        name: 'Best Practice Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/PracticedReport/Report') ?>',
        controllerName: 'PracticedReport'
    },
      37: {
        name: 'NPTL Reports',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/NPTLReport/create') ?>',
        controllerName: 'NPTLReport'
    },
 
      39: {
        name: 'Student Counseling Reports',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/Student_Counseling_report/create') ?>',
        controllerName: 'Student_Counseling_report'
    },
      40: {
        name: 'Honor & Minor Reports',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/Honor_MinorReport/create') ?>',
        controllerName: 'Honor_MinorReport'
    },
      41: {
        name: 'Academic Audit Reports',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/Academic_report/create') ?>',
        controllerName: 'Academic_report'
    },
      42: {
        name: 'Number of Citations of Individual Faculty Member Reports',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/Citation_report/create') ?>',
        controllerName: 'Citation_report'
    },
    43: {
        name: 'Grants Received Form Government and Non-Government Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/GrantrecReport/Report') ?>',
        controllerName: 'GrantrecReport'
    },
     46: {
        name: 'Institute Academic Audit Reports',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/Academicau_institutereport/create') ?>',
        controllerName: 'Academicau_institutereport'
    },
     47: {
        name: 'Maintenance Report',
        type: 'iframe',
        iframeUrl: '<?= base_url('admin/MaintanceReport/Report') ?>',
        controllerName: 'MaintanceReport'
    }
};

 $(document).ready(function() {
    console.log('Page initialized');
    console.log('Total menu items:', $('.menu-item').length);
    
    const sidebarToggleBtn = $('#sidebarToggleBtn');
    const menuSidebar = $('#menuSidebar');
    const sidebarOverlay = $('#sidebarOverlay');
    const graphContent = $('#graphContent');

    // Toggle Sidebar
    sidebarToggleBtn.on('click', function(e) {
        e.preventDefault();
        e.stopPropagation();
        toggleSidebar();
    });

    // Close sidebar when clicking overlay
    sidebarOverlay.on('click', function(e) {
        e.preventDefault();
        closeSidebar();
    });

    function toggleSidebar() {
        const isActive = menuSidebar.hasClass('active');
        
        if (isActive) {
            closeSidebar();
        } else {
            openSidebar();
        }
    }

    function openSidebar() {
        console.log('Opening sidebar');
        menuSidebar.addClass('active');
        sidebarOverlay.addClass('active');
        sidebarToggleBtn.addClass('active');
    }

    function closeSidebar() {
        console.log('Closing sidebar');
        menuSidebar.removeClass('active');
        sidebarOverlay.removeClass('active');
        sidebarToggleBtn.removeClass('active');
    }

    // Menu item click handler
    $('.menu-item').on('click', function(e) {
        e.preventDefault();
        e.stopPropagation();
        
        const menuId = $(this).data('id');
        const menuName = $(this).data('name');
        const menuUrl = $(this).data('url');
        
        console.log('Menu clicked:', menuId, menuName);
        
        // Set active menu item
        $('.menu-item').removeClass('active');
        $(this).addClass('active');
        
        // Hide welcome screen
        $('#welcomeScreen').hide();
        
        // Close sidebar automatically
        closeSidebar();
        
        // Load report
        if (menuConfig[menuId]) {
            const config = menuConfig[menuId];
            currentMenuId = menuId;
            currentMenuName = config.name;
            showIframeReport(config);
        } else {
            showIframeReport({
                name: menuName,
                iframeUrl: menuUrl
            });
        }
    });
    
    // Search functionality
    $('#searchInput').on('keyup', function(e) {
        e.stopPropagation();
        const searchTerm = $(this).val().toLowerCase();
        
        $('.menu-item').each(function() {
            const menuText = $(this).find('.menu-item-text').text().toLowerCase();
            
            if (menuText.includes(searchTerm)) {
                $(this).show();
            } else {
                $(this).hide();
            }
        });
    });

    // Close sidebar on ESC key
    $(document).on('keydown', function(e) {
        if (e.key === 'Escape') {
            closeSidebar();
        }
    });

    // Prevent sidebar from closing when clicking inside
    menuSidebar.on('click', function(e) {
        e.stopPropagation();
    });

    // Force scrollbar visibility
    setTimeout(function() {
        const scrollContainer = document.getElementById('menuListScroll');
        if (scrollContainer) {
            scrollContainer.scrollTop = 1;
            setTimeout(() => scrollContainer.scrollTop = 0, 100);
        }
    }, 500);
});

function showIframeReport(config) {
    console.log('Loading report:', config.name);
    
    $('#iframeReportWrapper').show();
    $('#iframeMenuName').text(config.name);
    $('#iframeLoader').show();
    $('#iframeContainer').hide();

    const iframe = document.getElementById('reportIframe');
    const timestamp = new Date().getTime();

    iframe.src = config.iframeUrl + '?showFilterSectionOnly=true&t=' + timestamp;

    iframe.onload = function () {
        console.log('Iframe loaded');
        $('#iframeLoader').hide();
        $('#iframeContainer').show();

        try {
            const iframeDoc = iframe.contentDocument || iframe.contentWindow.document;
            const mainContainer = iframeDoc.querySelector('.main-container');
            const filterSection = iframeDoc.querySelector('#filterSectionNew');

            const pageWrapper = iframeDoc.querySelector('.page-wrapper');
            if (pageWrapper) {
                pageWrapper.style.setProperty('padding', '0px', 'important');
                pageWrapper.style.setProperty('background', 'none', 'important');
            }
            
            const mainContainerEl = iframeDoc.querySelector('.main-container');
if (mainContainerEl) {
    mainContainerEl.style.setProperty('height', 'auto', 'important');
    mainContainerEl.style.setProperty('min-height', 'auto', 'important');
}

const contentWrapperEl = iframeDoc.querySelector('.content-wrapper');
if (contentWrapperEl) {
    contentWrapperEl.style.setProperty('height', 'auto', 'important');
    contentWrapperEl.style.setProperty('min-height', 'auto', 'important');
}

            const hideChartLoaderInterval = setInterval(() => {
                const chartLoader = iframeDoc.getElementById('chartLoader');
                if (chartLoader) {
                    chartLoader.style.setProperty('display', 'none', 'important');
                    clearInterval(hideChartLoaderInterval);
                }
            }, 100);

            if (mainContainer && filterSection) {
                Array.from(mainContainer.querySelectorAll('*')).forEach(el => {
                    const isModal = el.classList.contains('modal') || el.classList.contains('modal-backdrop');
                    const isInsideModal = el.closest('.modal') !== null;

                    if (!isModal && !isInsideModal && el !== filterSection && !filterSection.contains(el)) {
                        el.style.display = 'none';
                    }
                });

                function unhideAll(el) {
                    const style = window.getComputedStyle(el);
                    const isFlex = style.display === 'flex';
                    const hasDFlex = el.classList.contains('d-flex');

                    if (!isFlex && !hasDFlex) {
                        el.style.setProperty('display', 'block', 'important');
                    }

                    Array.from(el.children).forEach(child => unhideAll(child));
                }
                unhideAll(filterSection);

                let ancestor = filterSection.parentElement;
                while (ancestor && ancestor !== mainContainer.parentElement) {
                    ancestor.style.setProperty('display', 'block', 'important');
                    ancestor = ancestor.parentElement;
                }

                const tables = filterSection.querySelectorAll('table.table.table-bordered');
                tables.forEach(table => {
                    if (!table.parentElement.classList.contains('table-scroll-wrapper')) {
                        const wrapper = iframeDoc.createElement('div');
                        wrapper.classList.add('table-scroll-wrapper');
                        wrapper.style.overflowX = 'auto';
                        wrapper.style.width = '100%';
                        wrapper.style.display = 'block';

                        table.parentNode.insertBefore(wrapper, table);
                        wrapper.appendChild(table);
                    }
                });

                setTimeout(() => {

    const searchBtn = iframeDoc.querySelector('#searchBtn, .searchBtn');

    if (searchBtn) {
        console.log('Auto-loading graph');
        searchBtn.click();
    } else {
        console.log('Button not found');
    }
}, 500);

                const branchDropdown = iframeDoc.getElementById('branchwise_dropdown');
                if (branchDropdown) {
                    $(branchDropdown).on('change', function() {
                        setTimeout(() => {
                            const searchBtn = iframeDoc.getElementById('searchBtn');
                            if (searchBtn) searchBtn.click();
                        }, 300);
                    });
                }

                const yearDropdown = iframeDoc.getElementById('year_id');
                if (yearDropdown) {
                    $(yearDropdown).on('change', function() {
                        setTimeout(() => {
                            const searchBtn = iframeDoc.getElementById('searchBtn');
                            if (searchBtn) searchBtn.click();
                        }, 300);
                    });
                }
            }
        } catch (err) {
            console.error('Iframe access error:', err);
        }
    };

    iframe.onerror = function () {
        console.error('Iframe load failed');
        $('#iframeLoader').hide();
        $('#iframeContainer').html(
            '<div class="text-center p-5">' +
            '<p class="text-danger">Failed to load report. Please try again.</p>' +
            '</div>'
        );
    };
}
</script>