<style>
    th {
        background-color: #0d40a9 !important;
        color: white !important;
        font-weight: bold;
        padding: 10px;
        letter-spacing: 0.5px;
        border: 1px solid black; 
    }
    
    .form-section {
        background-color: #f8f9fa;
        padding: 20px;
        border-radius: 8px;
        margin-bottom: 20px;
        border: 1px solid #dee2e6;
    }
    
    .form-section h5 {
        color: #0d40a9;
        margin-bottom: 15px;
        font-weight: bold;
    }
    
.file-upload-cell {
            position: relative;
            width: 120px;
            padding: 3px;
        }
        .file-input {
            position: absolute;
            opacity: 0;
            width: 100%;
            height: 100%;
            cursor: pointer;
        }

         .file-input1 {
            position: absolute;
            opacity: 0;
            width: 100%;
            height: 100%;
            cursor: pointer;
        }

        .file-label {
            display: inline-block;
            background: #007bff;
            color: white;
            padding: 5px 10px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 12px;
            text-align: center;
            width: 100px;
        }
        .file-label:hover {
            background: #0056b3;
        }
        .file-name {
            font-size: 10px;
            color: #666;
            margin-top: 2px;
            word-break: break-word;
        }
        .file-remove {
            color: red;
            cursor: pointer;
            font-size: 10px;
            margin-left: 5px;
        }
        .wide-th {
        width: 200px !important;  
    }


    /* Add this to your existing CSS */
    .typeahead-suggestions {
        position: absolute;
        background-color:#c2fffe;
        border: 1px solid #aba4a4;
        border-top: none;
        z-index: 1000;
        width: 100%;
        max-height: 200px;
        overflow-y: auto;
        display: none;
    }
    
    .typeahead-suggestion {
        padding: 8px 12px;
        cursor: pointer;
    }
    
    .typeahead-suggestion:hover {
        background-color: #cbced2;
    }
    
    .typeahead-suggestion.active {
        background-color: #cbced2;
    }
    
    .field-wrapper {
        position: relative;
}

#groupPreviewContainer {
    background-color: #f0f8ff;
    padding: 15px;
    border-radius: 8px;
    border: 2px solid #17a2b8;
    margin-bottom: 20px;
}

#groupPreviewTable {
    font-size: 13px;
}

#groupPreviewTable th {
    background-color: #17a2b8 !important;
    color: white !important;
    font-weight: bold;
    text-align: center;
}

#groupPreviewTable td {
    text-align: center;
    vertical-align: middle;
}


/* Add these styles to your existing CSS */

/* Container for the main table */
/* Legend-style header for Student Info section */

/* Container for the entire section with border */
#tableContainer {
    position: relative;
    padding: 25px 15px 15px;
    border-radius: 8px;
    border: 2px solid #031618;
    margin-bottom: 20px;
    margin-top: 10px;
}

/* Legend header styling */
.legend-header {
    position: absolute;
    top: -15px;
    left: 20px;
    background-color: white;
    padding: 0 10px;
    z-index: 1;
}

.legend-header h5 {
    color: #df0a7b;
    font-weight: 600;
    margin: 0;
    font-size: 18px;
    letter-spacing: 0.5px;
}

/* Alternative style with background box */
.legend-header-alt {
    position: absolute;
    top: -15px;
    left: 20px;
    background: linear-gradient(135deg, #df0a7b 0%, #ff1493 100%);
    padding: 5px 15px;
    border-radius: 5px;
    box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
    z-index: 1;
}

.legend-header-alt h5 {
    color: white;
    font-weight: 600;
    margin: 0;
    font-size: 14px;
    letter-spacing: 0.5px;
}

/* Another style option - simple border box */
.legend-header-bordered {
    position: absolute;
    top: -12px;
    left: 20px;
    background-color: white;
    padding: 2px 12px;
    border: 2px solid #df0a7b;
    border-radius: 4px;
    z-index: 1;
}

.legend-header-bordered h5 {
    color: #df0a7b;
    font-weight: 600;
    margin: 0;
    font-size: 14px;
    letter-spacing: 0.3px;
}

/* Style for the main table */
#leavetable {
    font-size: 13px;
    border-collapse: collapse;
    width: 100%;
}

#leavetable th {
    background-color: #292b2d !important;
    color: white !important;
    font-weight: bold;
    text-align: center;
    padding: 10px;
    border: 1px solid #f5f6f8;
}

#leavetable td {
    text-align: center;
    vertical-align: middle;
    padding: 8px;
    border: 1px solid #f5f6f8;
}

/* Alternating row colors for better readability */
#leavetable tbody tr:nth-child(even) {
    background-color: #f8f9fa;
}

#leavetable tbody tr:hover {
    background-color: #e9f7fe;
}

/* Style for input fields in the table */
#leavetable input.form-control,
#leavetable select.form-control {
    border: 1px solid #ced4da;
    border-radius: 4px;
    padding: 5px;
    font-size: 12px;
}

#leavetable input.form-control:focus,
#leavetable select.form-control:focus {
    border-color: #17a2b8;
    box-shadow: 0 0 0 0.2rem rgba(23, 162, 184, 0.25);
}

</style>

<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1">Mega Project Details</div>
                    </div>
                    <div class="card-body">
                        <form role="form" id="Form" method="post">
                            <!-- Hidden field for main excel ID -->
                            <input type="hidden" id="main_excel_id" name="main_excel_id" 
                                   value="<?= !empty($childData) && isset($childData[0]->excel_upload_id) ? $childData[0]->excel_upload_id : '' ?>" />

<input type="hidden" name="ProjectType" value="2">

<!-- hidden submenuid -->
<input class="form-control" id="fk_submenuId" name="fk_submenuId" type="hidden"
                           value="<?= isset($subId) ? $subId : '' ?>"  />

                            <!-- Main Dropdown Section -->
                            <div class="row gutters mb-3">
                                <!-- Project Type Selection -->

<!-- <div class="col-md-3">
    <div class="field-wrapper">

        <?php 
            $savedType = isset($mainData->ProjectType) ? $mainData->ProjectType : 2;
            $isMega = ($savedType == 2); // Mega Project
        ?>

        <select name="ProjectType_disabled"
                id="ProjectType"
                class="select-single js-states form-control"
                <?= $isMega ? 'disabled' : '' ?>
                required>

            <?php foreach($projectTypeList as $type): ?>
                <option value="<?= $type->MiMe_ID ?>"
                    <?= ($type->MiMe_ID == $savedType) ? 'selected' : '' ?>>
                    <?= $type->MiMe_Name ?>
                </option>
            <?php endforeach; ?>

        </select>

        
        <?php if ($isMega): ?>
            <input type="hidden" name="ProjectType" value="2">
        <?php endif; ?>

        <div class="field-placeholder">
            Mega Project <span class="text-danger">*</span>
        </div>
    </div>
</div> -->


                                <!-- <div class="col-md-3">
                                    <div class="field-wrapper">
                                        <select name="ProjectType" id="ProjectType" class="select-single js-states form-control" required>
                                            <option value="">Mega Project</option>
                                            <?php foreach($projectTypeList as $type): ?>
                                                <?php $savedType = isset($mainData->ProjectType) ? $mainData->ProjectType : ''; ?>
                                                <option value="<?= $type->MiMe_ID ?>"
                                                    <?= ($type->MiMe_ID == $savedType) ? 'selected' : '' ?>>
                                                    <?= $type->MiMe_Name ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Mega Project <span class="text-danger">*</span></div>
                                    </div>
                                </div> -->

                                <!-- Academic Year Selection -->
                                <div class="col-md-3">
                                    <div class="field-wrapper">
                                        <select name="FiniYear" id="FiniYear" class="select-single js-states form-control" required>
                                            <option value="">Select year</option>
                                            <?php foreach($yearList as $year): ?>
                                                <?php 
                                                    $savedYear = '';
                                                    if (isset($mainData) && isset($mainData->FiniYear)) {
                                                        $savedYear = $mainData->FiniYear;
                                                    } elseif (!empty($childData) && isset($childData[0]->Financial_Year)) {
                                                        $savedYear = $childData[0]->Financial_Year;
                                                    }
                                                ?>
                                                <option value="<?= $year->finiYear_id ?>"
                                                    <?= ($year->finiYear_id == $savedYear) ? 'selected' : '' ?>>
                                                    <?= $year->fini_Label ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Academic Year <span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <!-- Branch/Department Selection -->
                                <div class="col-md-3">
                                    <div class="field-wrapper">
                                        <select name="BranchID" id="BranchID" class="select-single js-states form-control" required>
                                            <option value="">Select Branch/Department</option>
                                            <?php foreach($branchList as $branch): ?>
                                                <?php $savedBranch = isset($mainData->BranchID) ? $mainData->BranchID : ''; ?>
                                                <option value="<?= $branch->branch_id ?>"
                                                    <?= ($branch->branch_id == $savedBranch) ? 'selected' : '' ?>>
                                                    <?= $branch->branch_name ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Branch/Department <span class="text-danger">*</span></div>
                                    </div>
                                </div>

<div class="col-md-2">
                                        <div class="field-wrapper">
                                            <input type="text" id="input_group_no" class="form-control" placeholder="">
                                            <div class="field-placeholder">Group No.<span class="text-danger">*</span></div>			
                                       
                                        </div>
                                    </div>

                            </div>




                            <!-- Data Entry Form Section -->
                            <div id="tableContainer">
                                <div class="legend-header">
                     <h5 class="mb-2" style="color: #df0a7b; font-weight: 600;">Student Info</h5>
                </div>
                                <div class="row gutters">
                                    
                                    <div class="col-md-2">
                                        <div class="field-wrapper">
                                            
                                            <input type="text" id="input_roll_no" class="form-control" placeholder="">
                                            <div class="field-placeholder">Roll No.</div>
													
                                        </div>
                                    </div>

                                    
                                    <div class="col-md-2">
                                     
                                            <div class="field-wrapper">
                                             <input
    type="text"
    id="input_prn"
    class="form-control"
    maxlength="16"
    pattern="\d{16}"
 
    oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 16)">
 
                                            <div class="field-placeholder">PRN No.</div>
													
                                        </div>
                                    </div>

 <!-- MODIFIED: Student Dropdown -->
                                    <div class="col-md-4">
                                          <div class="field-wrapper">
                                            <input type="text" id="input_student_name" class="form-control" placeholder="" autocomplete="off">
                                                <div class="field-placeholder">Student Name<span class="text-danger">*</span></div>
												<!-- Add a div to show typeahead suggestions -->
    <div id="student_name_suggestions" class="typeahead-suggestions"></div>
                                        </div>
                                        <!-- <div class="field-wrapper">
                                            <select id="input_student_name" class="select-single js-states form-control">
                                                <option value="">Select Student</option>
                                                <?php foreach($studentList as $student): ?>
                                                    <option value="<?= $student->Student_id ?>"><?= $student->FullName ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <div class="field-placeholder">Student Name <span class="text-danger">*</span></div>
                                        </div> -->
                                    </div>
                                


                                    <!-- MODIFIED: Class Dropdown -->
                                    <div class="col-md-2">
                                        <div class="field-wrapper">
                                            <select id="input_class" class="select-single js-states form-control">
                                                <option value="">Select Class</option>
                                                <?php foreach($classList as $class): ?>
                                                    <option value="<?= $class->class_id ?>"><?= $class->classname ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <div class="field-placeholder">Class</div>
                                        </div>
                                    </div>
                                    <!-- MODIFIED: Division Dropdown -->
                                    <!-- <div class="col-md-2">
                                        <div class="field-wrapper">
                                            <select id="input_division" class="select-single js-states form-control">
                                                <option value="">Select Division</option>
                                                <?php foreach($divisionList as $division): ?>
                                                    <option value="<?= $division->div_id ?>"><?= $division->div_name ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <div class="field-placeholder">Division</div>
                                        </div>
                                    </div> -->

                                   </div>


                                <div class="row gutters mt-3">
                                    <div class="col-md-4">
<div class="field-wrapper">
    <input type="text" id="input_guide_name" class="form-control" placeholder="" autocomplete="off">
    <div class="field-placeholder">Guide Name</div>
    <!-- Add a div to show typeahead suggestions -->
    <div id="guide_name_suggestions" class="typeahead-suggestions"></div>
</div>

                                        <!-- <div class="field-wrapper">
                                            
                                            <input type="text" id="input_guide_name" class="form-control" placeholder="Guide Name">
                                            <div class="field-placeholder">Guide Name</div>
													
                                        </div> -->
                                    </div>
                                    <div class="col-md-4">

<!-- Replace this line: -->
<!-- <input type="text" id="input_project_title" class="form-control" placeholder="Project Title"> -->

<!-- With this: -->
<div class="field-wrapper">
    <input type="text" id="input_project_title" class="form-control" placeholder="" autocomplete="off">
    <div class="field-placeholder">Project Title<span class="text-danger">*</span></div>
    <!-- Add a div to show typeahead suggestions -->
    <div id="project_title_suggestions" class="typeahead-suggestions"></div>
</div>

                                        <!-- <div class="field-wrapper">
                                            <input type="text" id="input_project_title" class="form-control" placeholder="Project Title">
                                                <div class="field-placeholder">Project Title<span class="text-danger">*</span></div>
												
                                        </div> -->
                                    </div>
                                    <!-- MODIFIED: Sponsorship Dropdown -->
                                    <div class="col-md-2">
                                        <div class="field-wrapper">
                                            <select id="input_sponsorship" class="select-single js-states form-control">
                                                <option value="">Select Sponsorship</option>
                                                <?php foreach($sponsorList as $sponsor): ?>
                                                    <option value="<?= $sponsor->type_id ?>"><?= $sponsor->type_name ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <div class="field-placeholder">Sponsorship</div>
                                        </div>
                                    </div>


                                    <div class="col-md-4 col-12" id="input_details" style="display:none;">
    <div class="field-wrapper">
        <textarea class="form-control" name="spon_details" id="spon_details">
            <?php if(!empty($data)) echo $data[0]->spon_details; ?>
        </textarea>
        <div class="field-placeholder">Sponsorship Details</div>
        <div class="form-text"></div>
    </div>
</div>



                                    <!-- MODIFIED: Rank Dropdown -->
                                    <!-- <div class="col-md-2">
                                        <div class="field-wrapper">
                                            <select id="input_rank" class="select-single js-states form-control">
                                                <option value="">Select Rank</option>
                                                <?php foreach($rankList as $rank): ?>
                                                    <option value="<?= $rank->rank_id ?>"><?= $rank->rank_name ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <div class="field-placeholder">Rank</div>
                                        </div>
                                    </div> -->
                                    
                                
                           
                            
                                    <!-- <div class="col-md-2">
                                        <div class="field-wrapper">
                                            <select id="fk_status" class="select-single js-states form-control">
                                                <option value="">Select Status</option>
                                                <?php foreach($statuslist as $status): ?>
                                                    <option value="<?= $status->Status_id ?>"><?= $status->Status_name ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <div class="field-placeholder">Status</div>
                                        </div>
                                    </div> -->


<div class="col-md-1 mt-1">
                                        
                                            
                                            <button type="button" class="btn btn-primary btn-block" id="addEntryBtn" style="border-radius:5px; background-color:#17a2b8;">
                                                <i class="fa fa-plus"></i> Add
                                            </button>
                                    </div>

                                

                            <!-- Data Table -->
                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 mt-4">
                                
                                <div class="table-responsive" id="printableTable">
                                    <!-- <div class="float-end mb-2">
                                        <?php if (!empty($childData)): ?>
                                            <button class="btn btn-danger btn-sm m-1" type="button" id="btnClearAll">
                                                <i class="fas fa-times"></i> Clear All
                                            </button>
                                        <?php endif; ?>
                                    </div> -->

                                    <table id="leavetable" class="table custom-table">
                                        <thead>
                                            <tr>
                                                <th class="text-white">Sr.No</th>
                                                <th style=" min-width:150px;" class="text-white">Group No</th>
                                                <th style=" min-width:150px;" class="text-white">Roll No.</th>
                                                <th style=" min-width:150px;" class="text-white">PRN No.</th>
                                                <th style=" min-width:240px;" class="text-white">Student Name</th>
                                                <th style=" min-width:150px;" class="text-white">Class</th>
                                                <!-- <th style=" min-width:150px;" class="text-white">Division</th> -->
                                                <th style=" min-width:240px;" class="text-white">Guide Name</th>
                                                <th style=" min-width:240px;" class="text-white">Project Title</th>
                                                <th style=" min-width:200px;" class="text-white">Department/Branch</th>
                                                <!-- <th style=" min-width:200px;" class="text-white">Project Type</th> -->
                                                <th style=" min-width:200px;" class="text-white">Academic Year</th>
                                                <th style=" min-width:180px;" class="text-white">Sponsorship</th>
                                                <th style=" min-width:180px;" class="text-white">Sponsorship Details</th>
                                                <!-- <th style=" min-width:200px;" class="text-white">Rank</th> -->
                                                <!-- <th style="min-width:150px;" class="text-white">Status</th> -->
                                                <!-- <th style="min-width:200px;" class="text-white">Project Report</th> -->
                                                <!-- <th style="min-width:200px;" class="text-white">Project ppt</th> -->
                                                <th style=" min-width:150px;" class="text-white">Action</th>
                                            </tr>
                                        </thead>
                                        <tbody id="tableBody">
                                            <?php if(!empty($childData)): 
                                                $i = 1;
                                                $selectedProjectTypeText = '';
                                                $selectedYearText = '';
                                                if(isset($mainData->ProjectType)) {
                                                    foreach($projectTypeList as $type) {
                                                        if($type->MiMe_ID == $mainData->ProjectType) {
                                                            $selectedProjectTypeText = $type->MiMe_Name;
                                                            break;
                                                        }
                                                    }
                                                }
                                                if(isset($mainData->FiniYear)) {
                                                    foreach($yearList as $year) {
                                                        if($year->finiYear_id == $mainData->FiniYear) {
                                                            $selectedYearText = $year->fini_Label;
                                                            break;
                                                        }
                                                    }
                                                }

                                                foreach($childData as $row): ?>
                                                <tr>
                                                    <td><?= $i++ ?></td>
                                                    <td>
                                                        <input type="hidden" name="project_id[]" value="<?= $row->project_id ?>">
                                                        <input type="text" name="group_no[]" class="form-control" placeholder="Group No" value="<?= $row->group_no ?? '' ?>">
                                                    </td>
                                                    <td><input type="text" name="roll_no[]" class="form-control" placeholder="Roll No" value="<?= $row->roll_no ?>"></td>
                                                    <td><input type="text" name="prn[]" class="form-control" placeholder="PRN" value="<?= $row->prn ?>"></td>
                                                    <td><input type="text" name="student_name[]" class="form-control" placeholder="Student Name" value="<?= $row->student_name ?>"></td>
                                                    <!-- MODIFIED: Student Dropdown in Table -->
                                                    <!-- <td>
                                                        <select name="student_name[]" class="form-control">
                                                            <?php foreach($studentList as $student): ?>
                                                                <option value="<?= $student->Student_id ?>" <?= ($student->Student_id == $row->student_name) ? 'selected' : '' ?>><?= $student->FullName ?></option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td> -->
                                                    <!-- MODIFIED: Class Dropdown in Table -->
                                                    <td>
                                                        <select name="class[]" class="form-control">
                                                            <?php foreach($classList as $class): ?>
                                                                <option value="<?= $class->class_id ?>" <?= ($class->class_id == $row->class) ? 'selected' : '' ?>><?= $class->classname ?></option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                    <!-- MODIFIED: Division Dropdown in Table -->
                                                    <!-- <td>
                                                        <select name="division[]" class="form-control">
                                                            <?php foreach($divisionList as $division): ?>
                                                                <option value="<?= $division->div_id ?>" <?= ($division->div_id == $row->division) ? 'selected' : '' ?>><?= $division->div_name ?></option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td> -->
                                                    
                                                    <td><input type="text" name="guide_name[]" class="form-control" placeholder="Guide Name" value="<?= $row->guide_name ?>"></td>
                                                    <td><input type="text" name="project_title[]" class="form-control" placeholder="Project Title" value="<?= $row->project_title ?>"></td>
                                                    <td><input type="text" name="department[]" class="form-control" value="<?= $row->department ?? '' ?>"></td>
                                                    <!-- <td><input type="text" name="project_type[]" class="form-control" value="<?= $selectedProjectTypeText ?>" readonly></td> -->
                                                    <td><input type="text" name="academic_year[]" class="form-control" value="<?= $selectedYearText ?>"></td>
                                                    <!-- MODIFIED: Sponsorship Dropdown in Table -->
                                                    <td>
                                                        <select name="fk_sponser[]" class="form-control">
                                                            <?php foreach($sponsorList as $sponsor): ?>
                                                                <option value="<?= $sponsor->type_id ?>" <?= ($sponsor->type_id == $row->fk_sponser) ? 'selected' : '' ?>><?= $sponsor->type_name ?></option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                    <td><input type="text" name="spon_details[]" class="form-control" placeholder="Details" value="<?= $row->spon_details ?>"></td>
                                                    <!-- MODIFIED: Rank Dropdown in Table -->
                                                    <!-- <td>
                                                        <select name="rank[]" class="form-control">
                                                            <?php foreach($rankList as $rank): ?>
                                                                <option value="<?= $rank->rank_id ?>" <?= ($rank->rank_id == $row->rank) ? 'selected' : '' ?>><?= $rank->rank_name ?></option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td> -->
                                                    <!-- ✅ NEW: Status Column -->
        <!-- <td>
            <select name="fk_status[]" class="form-control">
                <option value="">Select</option>
                <?php foreach($statuslist as $status): ?>
                    <option value="<?= $status->Status_id ?>" <?= ($status->Status_id == $row->fk_status) ? 'selected' : '' ?>><?= $status->Status_name ?></option>
                <?php endforeach; ?>
            </select>
        </td> -->
         <!-- ✅ Document 1 with Choose File Design -->
            <!-- <td>
                <div class="file-upload-cell">
                    <input type="file" 
                           name="document[]" 
                           class="file-input" 
                           id="document_<?= $i ?>"
                           onchange="window.handleFileSelectExisting(this, 'document', <?= $i ?>)" 
                           accept=".pdf,.doc,.docx">
                    <label for="document_<?= $i ?>" class="file-label">Choose File</label>
                   
                </div>
 <div class="file-name" id="document_name_<?= $i ?>">
                        <?php if (!empty($row->document)): ?>
                            <?= basename($row->document) ?>
                            <br><a href="<?= base_url($row->document) ?>" target="_blank" style="font-size:20px;"><i class="fas fa-file-pdf text-danger"></i></a>
                        <?php endif; ?>
                    </div>

            </td> -->

            <!-- ✅ Document 2 with Choose File Design -->
            <!-- <td>
                <div class="file-upload-cell">
                    <input type="file" 
                           name="document2[]" 
                           class="file-input1" 
                           id="document2_<?= $i ?>"
                           onchange="window.handleFileSelectExisting(this, 'document2', <?= $i ?>)" 
                           accept=".ppt,.pptx">
                    <label for="document2_<?= $i ?>" class="file-label">Choose File</label>
                   
                </div>
 <div class="file-name" id="document2_name_<?= $i ?>">
                        <?php if (!empty($row->document2)): ?>
                            <?= basename($row->document2) ?>
                            <br><a href="<?= base_url($row->document2) ?>" target="_blank" style="font-size:20px;"><i class="fas fa-file-pdf text-danger"></i></a>
                        <?php endif; ?>
                    </div>

            </td> -->

                                                    <td>
                                                        <button type="button" class="btn text-danger btn-sm removeRow">
                                                            <i class="fa-solid fa-trash"></i>
                                                        </button>
                                                    </td>
                                                </tr>
                                            <?php endforeach; endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                        </div>
                            
                            </div>

</div>

</div>
                           

                            <!-- Action Buttons -->
                            <div class="card-body">
                                <div class="">
                                    <button type="button" class="btn mb-md-0 mb-2 btn-quarternary" id="btn_save">
                                        <i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save
                                    </button>
                                    <a class="btn mb-md-0 mb-2 btn-quarternary1" href="<?=base_url()?>admin/MiniAdd/index" type="button">
                                        <i class="fa-solid fa-list"></i>&nbsp;&nbsp;List
                                    </a>
                                    <!-- <button class="btn mb-md-0 mb-2 btn-quarternaryhome" type="button" onclick="window.location.href='<?= base_url() ?>admin/MiniAdd/dashboard'">
                                        <i class="fa-solid fa-home"></i>&nbsp;&nbsp;Home
                                    </button> -->

                                    <button type="button"
    class="btn mb-md-0 mb-2 btn-quarternaryhome"
    onclick="window.location.href='<?= base_url('admin/MiniAdd/dashboard') ?>'">
    
    <i class="fa-solid fa-home fa-lg"></i>
    <span class="fw-semibold">Home</span>

</button>

                                </div>
                            </div>

 <!-- Group No Input ke baad ye add karo -->
<div class="col-md-12 mt-3">
    <div id="groupPreviewContainer" style="display:none;">
        <h6 class="text-primary">📋 Existing Records for this Group:</h6>
        <div class="table-responsive">
            <table class="table table-bordered table-sm" id="groupPreviewTable">
                <thead style="background-color: #17a2b8; color: white;">
                    <tr>
                        <th>Sr.No</th>
                        <th>Group No</th>
                        <th>Roll No</th>
                        <th>PRN</th>
                        <th>Student Name</th>
                        <th>Class</th>
                        <!-- <th>Division</th> -->
                        <th>Project Title</th>
                        <th>Guide Name</th>
                        <th>Sponsorship</th>
                        
                    </tr>
                </thead>
                <tbody id="groupPreviewBody">
                </tbody>
            </table>
        </div>
    </div>
</div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Scripts -->
<script src="<?php echo base_url();?>Assets/js/jquery.min.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>

<script>
$(document).ready(function () {

    function toggleDetails() {
        let val = $('#input_sponsorship').val();

        if (val == "1") {
            $('#input_details').show();
        } else {
            $('#input_details').hide();
            $('#details').val(''); 
        }
    }

    $('#input_sponsorship').on('change', function () {
        toggleDetails();
    });

    toggleDetails();
});
</script>

<script>
var baseURL = '<?= base_url() ?>';
var childDataCount = <?= !empty($childData) ? count($childData) : 0 ?>;

// Pass PHP arrays to JavaScript
var classList = <?= json_encode($classList) ?>;
var sponsorList = <?= json_encode($sponsorList) ?>;
var rankList = <?= json_encode($rankList) ?>;
var statusList = <?= json_encode($statuslist) ?>;

 $(document).ready(function () {
    const uniqueId = $('#tableBody tr').length;

    // ✅ Safe dropdown value setter
    function setSelectValue(selector, value) {
        if (value && value !== "0") {
            $(selector).val(value).trigger("change");
        } else {
            $(selector).val("").trigger("change");
        }
    }

    // ✅ Reset all inputs after adding row
    function resetInputs() {
        // $("#input_group_no").val("");
        // $("#input_roll_no").val("");
        // $("#input_prn").val("");

        // $("#input_class").val("").trigger("change");
        // $("#input_division").val("").trigger("change");
        $("#input_student_name").val(""); // ✅ TEXT field hai ab
        // $("#input_sponsorship").val("").trigger("change");
        // $("#spon_details").val(""); // ✅ NEW field
        
        // $("#input_guide_name").val("");
        // $("#input_project_title").val("");
        // $("#input_details").hide(); // ✅ Hide details field
    }

    let rowCount = typeof childDataCount !== 'undefined' ? childDataCount : 0;
    let isEditMode = rowCount > 0;
    
    if (isEditMode) {
        $("#btnClearAll").hide();
        $("#addEntryBtn").hide();
        $(".removeRow").hide();
    }
    
    // Initialize Select2
    $('.select-single').select2({
        width: '100%'
    });
    
    /**
     * Helper function to create a dropdown HTML string
     */
    function createDropdown(options, selectedValue, name, includeEmpty = true) {
        let dropdownHtml = `<select name="${name}" class="form-control select2-table">`;
        if (includeEmpty) {
            dropdownHtml += '<option value="">Select</option>';
        }
        options.forEach(item => {
            const itemValue = item.class_id || item.div_id || item.type_id || item.rank_id || item.Status_id;
            const itemText = item.classname || item.div_name || item.type_name || item.rank_name || item.Status_name;
            const isSelected = itemValue == selectedValue ? 'selected' : '';
            dropdownHtml += `<option value="${itemValue}" ${isSelected}>${itemText}</option>`;
        });
        dropdownHtml += '</select>';
        return dropdownHtml;
    }

    /**
     * Initialize Select2 for table dropdowns
     */
    function initTableSelect2() {
        $('.select2-table').select2({
            width: '100%',
            dropdownAutoWidth: true
        });
    }

    /**
     * Adds a new row to the table with the given data.
     */
    function addRow(groupNo = "", rollNo = "", prn = "", classId = "", student_name = "", guideName = "", projectTitle = "", department = "", academicYear = "", sponsorshipId = "", spon_details = "", projectId = "") {
        rowCount++;
        
        // Generate unique IDs for this row
        const documentId = 'document_' + rowCount;
        const document2Id = 'document2_' + rowCount;
        const documentNameId = 'document_name_' + rowCount;
        const document2NameId = 'document2_name_' + rowCount;
        
        let newRow = `
            <tr>
                <td>${rowCount}</td>
                <td>
                    <input type="hidden" name="project_id[]" value="${projectId}">
                    <input type="text" name="group_no[]" class="form-control group-input" placeholder="Group No" value="${groupNo}">
                </td>
                <td><input type="text" name="roll_no[]" class="form-control roll-input" placeholder="Roll No" value="${rollNo}"></td>
                <td><input type="text" name="prn[]" class="form-control prn-input" placeholder="PRN" value="${prn}"></td>
                <td><input type="text" name="student_name[]" class="form-control student-input" placeholder="Student Name" value="${student_name}"></td>
                <td>${createDropdown(classList, classId, 'class[]', false)}</td>
                <td><input type="text" name="guide_name[]" class="form-control guide-input" placeholder="Guide Name" value="${guideName}"></td>
                <td><input type="text" name="project_title[]" class="form-control title-input" placeholder="Project Title" value="${projectTitle}"></td>
                <td><input type="text" name="department[]" class="form-control" value="${department}" readonly></td>
                <td><input type="text" name="academic_year[]" class="form-control" value="${academicYear}" readonly></td>
                <td>${createDropdown(sponsorList, sponsorshipId, 'fk_sponser[]', false)}</td>
                <td><input type="text" name="spon_details[]" class="form-control details-input" placeholder="Details" value="${spon_details}"></td>
                <td>
                    <button type="button" class="btn text-danger btn-sm removeRow">
                        <i class="fa-solid fa-trash"></i>
                    </button>
                </td>
            </tr>`;
        $("#tableBody").append(newRow);
        updateSerialNumbers();
        
        // Initialize Select2 for new row
        initTableSelect2();
    }

    // ✅ When table values change, update input fields (for first row in edit mode)
    $(document).on('input change', '#tableBody tr:first input, #tableBody tr:first select', function() {
        if (!isEditMode) return;
        
        let $row = $(this).closest('tr');
        
        // Update input fields from first row
        $('#input_group_no').val($row.find('input[name="group_no[]"]').val());
        $('#input_roll_no').val($row.find('input[name="roll_no[]"]').val());
        $('#input_prn').val($row.find('input[name="prn[]"]').val());
        $('#input_student_name').val($row.find('input[name="student_name[]"]').val()); // ✅ TEXT field
        
        // Update Select2 dropdowns properly
        $('#input_class').val($row.find('select[name="class[]"]').val()).trigger('change');
        // $('#input_division').val($row.find('select[name="division[]"]').val()).trigger('change');
        $('#input_sponsorship').val($row.find('select[name="fk_sponser[]"]').val()).trigger('change');
        
        // ✅ Update sponsorship details
        let sponDetails = $row.find('input[name="spon_details[]"]').val();
        $('#spon_details').val(sponDetails);
        
        // ✅ Show/hide details field based on sponsorship value
        let sponValue = $row.find('select[name="fk_sponser[]"]').val();
        if (sponValue == "1") {
            $('#input_details').show();
        } else {
            $('#input_details').hide();
        }
        
        $('#input_guide_name').val($row.find('input[name="guide_name[]"]').val());
        $('#input_project_title').val($row.find('input[name="project_title[]"]').val());
    });

    // ✅ When input fields change, update first row of table
    $('#input_group_no, #input_roll_no, #input_prn, #input_student_name, #input_guide_name, #input_project_title').on('input', function() {
        if (!isEditMode || $("#tableBody tr").length === 0) return;
        
        let $firstRow = $("#tableBody tr:first");
        let fieldName = $(this).attr('id').replace('input_', '');
        
        if (fieldName === 'group_no') {
            $firstRow.find('input[name="group_no[]"]').val($(this).val());
        } else if (fieldName === 'roll_no') {
            $firstRow.find('input[name="roll_no[]"]').val($(this).val());
        } else if (fieldName === 'prn') {
            $firstRow.find('input[name="prn[]"]').val($(this).val());
        } else if (fieldName === 'student_name') { // ✅ TEXT field
            $firstRow.find('input[name="student_name[]"]').val($(this).val());
        } else if (fieldName === 'guide_name') {
            $firstRow.find('input[name="guide_name[]"]').val($(this).val());
        } else if (fieldName === 'project_title') {
            $firstRow.find('input[name="project_title[]"]').val($(this).val());
        }
    });

    // ✅ Sponsorship details update
    $('#spon_details').on('input', function() {
        if (!isEditMode || $("#tableBody tr").length === 0) return;
        
        let $firstRow = $("#tableBody tr:first");
        $firstRow.find('input[name="spon_details[]"]').val($(this).val());
    });

    // ✅ When dropdown inputs change, update first row
    $('#input_class, #input_sponsorship').on('change', function() {
        if (!isEditMode || $("#tableBody tr").length === 0) return;
        
        let $firstRow = $("#tableBody tr:first");
        let fieldName = $(this).attr('id').replace('input_', '');
        
        if (fieldName === 'class') {
            $firstRow.find('select[name="class[]"]').val($(this).val());
        }
        //  else if (fieldName === 'division') {
        //     $firstRow.find('select[name="division[]"]').val($(this).val());
        // }
         else if (fieldName === 'sponsorship') {
            $firstRow.find('select[name="fk_sponser[]"]').val($(this).val());
        }
    });

    // ✅ When main dropdowns change (Branch, Year), update all table rows
    $('#BranchID, #FiniYear').on('change', function() {
        if (!isEditMode || $("#tableBody tr").length === 0) return;
        
        let fieldName = $(this).attr('id');
        let selectedText = $(this).find('option:selected').text().trim();
        
        $("#tableBody tr").each(function() {
            if (fieldName === 'BranchID') {
                $(this).find('input[name="department[]"]').val(selectedText);
            } else if (fieldName === 'FiniYear') {
                $(this).find('input[name="academic_year[]"]').val(selectedText);
            }
        });
    });

    // ✅ Populate input fields from existing data on page load (Edit Mode)
    if (isEditMode && $("#tableBody tr").length > 0) {
        let $firstRow = $("#tableBody tr:first");
        
        $('#input_group_no').val($firstRow.find('input[name="group_no[]"]').val());
        $('#input_roll_no').val($firstRow.find('input[name="roll_no[]"]').val());
        $('#input_prn').val($firstRow.find('input[name="prn[]"]').val());
        $('#input_student_name').val($firstRow.find('input[name="student_name[]"]').val()); // ✅ TEXT field
        
        setSelectValue('#input_class', $firstRow.find('select[name="class[]"]').val());
        // setSelectValue('#input_division', $firstRow.find('select[name="division[]"]').val());
        setSelectValue('#input_sponsorship', $firstRow.find('select[name="fk_sponser[]"]').val());
        
        // ✅ Set sponsorship details
        $('#spon_details').val($firstRow.find('input[name="spon_details[]"]').val());
        
        // ✅ Show/hide details based on sponsorship
        let sponValue = $firstRow.find('select[name="fk_sponser[]"]').val();
        if (sponValue == "1") {
            $('#input_details').show();
        }
        
        $('#input_guide_name').val($firstRow.find('input[name="guide_name[]"]').val());
        $('#input_project_title').val($firstRow.find('input[name="project_title[]"]').val());
        
        // Initialize Select2 for table dropdowns
        initTableSelect2();
    }

    // Add this function to check for duplicates
function checkForDuplicate(prn, studentName) {
    let isDuplicate = false;
    let duplicateFields = [];
    
    $("#tableBody tr").each(function() {
        const existingPrn = $(this).find('input[name="prn[]"]').val().trim();
        const existingStudentName = $(this).find('input[name="student_name[]"]').val().trim();
        
        if (prn && existingPrn === prn) {
            isDuplicate = true;
            duplicateFields.push("PRN");
        }
        
        if (studentName && existingStudentName.toLowerCase() === studentName.toLowerCase()) {
            isDuplicate = true;
            if (!duplicateFields.includes("Student Name")) {
                duplicateFields.push("Student Name");
            }
        }
    });
    
    return { isDuplicate, duplicateFields };
}

// Modify the "Add Entry Button Click" function
 $("#addEntryBtn").click(function () {
    // Get input values
    let groupNo = $("#input_group_no").val().trim();
    let rollNo = $("#input_roll_no").val().trim();
    let prn = $("#input_prn").val().trim();
    let studentName = $("#input_student_name").val().trim();
    let classId = $("#input_class").val();
    // let divisionId = $("#input_division").val();
    let guideName = $("#input_guide_name").val().trim();
    let projectTitle = $("#input_project_title").val().trim();
    let sponsorshipId = $("#input_sponsorship").val();
    let spon_details = $("#spon_details").val().trim();
    
    // Validate required fields
    let finiYear = $("#FiniYear").val();
    let branchId = $("#BranchID").val();
    
    if (!finiYear || !branchId) {
        Swal.fire("Error", "Please select Academic Year and Branch/Department first!", "error");
        return;
    }

    if (!groupNo) {
        Swal.fire("Error", "Group No is required!", "error");
        return;
    }

    if (!studentName) {
        Swal.fire("Error", "Student Name is required!", "error");
        return;
    }

    if (!projectTitle) {
        Swal.fire("Error", "Project Title is required!", "error");
        return;
    }
    
    // Check for duplicates
    const { isDuplicate, duplicateFields } = checkForDuplicate(prn, studentName);
    
    if (isDuplicate) {
        const fieldsText = duplicateFields.join(" and ");
        Swal.fire("Error", `This ${fieldsText} already exists in the table!`, "error");
        return;
    }

    // Get dropdown text values for readonly fields
    let selectedBranch = $("#BranchID option:selected").text().trim();
    let selectedAcademicYear = $("#FiniYear option:selected").text().trim();

    // Add row to table
    addRow(
        groupNo,
        rollNo,
        prn,
        classId,
        // divisionId,
        studentName,
        guideName,
        projectTitle,
        selectedBranch,
        selectedAcademicYear,
        sponsorshipId,
        spon_details,
        ""
    );

    resetInputs();
    $("#input_student_name").focus();
});
    // ✅ Add Entry Button Click
    // $("#addEntryBtn").click(function () {
    //     // Validate required fields
    //     let finiYear = $("#FiniYear").val();
    //     let branchId = $("#BranchID").val();
    //     let groupNo = $("#input_group_no").val().trim();
    //     let studentName = $("#input_student_name").val().trim(); // ✅ TEXT field
    //     let projectTitle = $("#input_project_title").val().trim();

    //     if (!finiYear || !branchId) {
    //         Swal.fire("Error", "Please select Academic Year and Branch/Department first!", "error");
    //         return;
    //     }

    //     if (!groupNo) {
    //         Swal.fire("Error", "Group No is required!", "error");
    //         return;
    //     }

    //     if (!studentName) {
    //         Swal.fire("Error", "Student Name is required!", "error");
    //         return;
    //     }

    //     if (!projectTitle) {
    //         Swal.fire("Error", "Project Title is required!", "error");
    //         return;
    //     }

    //     // Get dropdown text values for readonly fields
    //     let selectedBranch = $("#BranchID option:selected").text().trim();
    //     let selectedAcademicYear = $("#FiniYear option:selected").text().trim();

    //     // Get input values
    //     let rollNo = $("#input_roll_no").val().trim();
    //     let prn = $("#input_prn").val().trim();
    //     let classId = $("#input_class").val();
    //     let divisionId = $("#input_division").val();
    //     let guideName = $("#input_guide_name").val().trim();
    //     let sponsorshipId = $("#input_sponsorship").val();
    //     let spon_details = $("#spon_details").val().trim(); // ✅ NEW field

    //     // Add row to table
    //     addRow(
    //         groupNo,
    //         rollNo,
    //         prn,
    //         classId,
    //         divisionId,
    //         studentName, // ✅ TEXT value
    //         guideName,
    //         projectTitle,
    //         selectedBranch,
    //         selectedAcademicYear,
    //         sponsorshipId,
    //         spon_details, // ✅ NEW parameter
    //         ""
    //     );

    //     resetInputs();
    //     $("#input_group_no").focus();
    // });

    // ✅ Remove Row Button
    $(document).on("click", ".removeRow", function () {
        let projectId = $(this).closest('tr').find("input[name='project_id[]']").val();
        
        if (projectId && projectId !== '') {
            Swal.fire({
                title: 'Are you sure?',
                text: 'Do you want to delete this project from database?',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: baseURL + 'admin/MiniAdd/deleteProject',
                        type: 'POST',
                        data: { project_id: projectId },
                        dataType: 'json',
                        success: function(response) {
                            if (response.status === 'success') {
                                $(this).closest("tr").remove();
                                updateSerialNumbers();
                                Swal.fire('Deleted!', 'Project has been deleted.', 'success');
                                
                                if ($("#tableBody tr").length === 0) {
                                    window.location.href = baseURL + 'admin/MiniAdd/index';
                                }
                            } else {
                                Swal.fire('Error', response.message || 'Failed to delete', 'error');
                            }
                        }.bind(this),
                        error: function() {
                            Swal.fire('Error', 'Failed to delete. Please try again.', 'error');
                        }
                    });
                }
            });
        } else {
            $(this).closest("tr").remove();
            updateSerialNumbers();
        }
    });

    // ✅ Save Button
    $("#btn_save").click(function (e) {
        e.preventDefault();

        if ($("#tableBody tr").length === 0) {
            Swal.fire("Error", "Please add at least one project!", "error");
            return;
        }

        let formData = new FormData($("#Form")[0]);

        let hasProjectIds = $("input[name='project_id[]']").filter(function() {
            return $(this).val() !== '';
        }).length > 0;
        
        let saveUrl = hasProjectIds ? 
            baseURL + 'admin/MiniAdd/updateMiniProject' : 
            baseURL + 'admin/MiniAdd/insertMiniProject';

        $.ajax({
            url: saveUrl,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            beforeSend: function() {
                $("#btn_save").prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');
            },
            success: function (response) {
                $("#btn_save").prop('disabled', false).html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
                
                if (response.status === 'success') {
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: '<strong>Success!</strong>',
                        html: response.message,
                        showConfirmButton: false,
                        timer: 2000,
                        customClass: {
                            popup: 'custom-swal-popup',
                            icon: 'custom-swal-icon',
                            title: 'custom-swal-title',
                            htmlContainer: 'custom-swal-text'
                        }
                    }).then(() => {
                        window.location.href = baseURL + 'admin/MiniAdd/index';
                    });
                } else {
                    Swal.fire('Error', response.message || 'Failed to save', 'error');
                }
            },
            error: function (xhr, status, error) {
                $("#btn_save").prop('disabled', false).html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
                console.error('Save Error:', error);
                Swal.fire('Error', 'Failed to save data. Please try again.', 'error');
            }
        });
    });

    // ✅ Helper function to update serial numbers
    function updateSerialNumbers() {
        $("#tableBody tr").each(function(index) {
            $(this).find("td:first").text(index + 1);
        });
        rowCount = $("#tableBody tr").length;
    }
});
</script>


<script>
    window.handleFileSelectExisting = function(input, type, rowIndex) {
        let fileName = input.files[0] ? input.files[0].name : '';
        let nameDiv = document.getElementById(type + '_name_' + rowIndex);
       
        if (nameDiv) {
            nameDiv.innerHTML = fileName;
        }
    };
</script>

<script>
    // File handling for dynamically added rows
    window.handleFileSelectNew = function(input, type, rowIndex) {
        let fileName = input.files[0] ? input.files[0].name : '';
        let nameDiv = document.getElementById(type + '_name_' + rowIndex);

        if (nameDiv && fileName) {
            nameDiv.innerHTML = fileName;
        }
    };
</script>

<script>
 $(document).ready(function() {
    // Generic typeahead function that can be reused for multiple fields
    function initializeTypeahead(inputId, suggestionsId, url) {
        let timeout;
        let selectedIndex = -1;
        
        $(inputId).on('input', function() {
            const query = $(this).val().trim();
            const $suggestionsDiv = $(suggestionsId);
            
            // Clear previous timeout
            clearTimeout(timeout);
            
            if (query.length < 1) {
                $suggestionsDiv.hide().empty();
                return;
            }
            
            // Set a new timeout to avoid too many requests
            timeout = setTimeout(function() {
                $.ajax({
                    url: url,
                    type: 'GET',
                    data: { q: query },
                    dataType: 'json',
                    success: function(response) {
                        $suggestionsDiv.empty();
                        selectedIndex = -1;
                        
                        if (response.results && response.results.length > 0) {
                            response.results.forEach(function(item, index) {
                                const $suggestion = $('<div class="typeahead-suggestion">' + item.text + '</div>');
                                $suggestion.data('value', item.text);
                                $suggestionsDiv.append($suggestion);
                            });
                            $suggestionsDiv.show();
                        } else {
                            $suggestionsDiv.hide();
                        }
                    },
                    error: function() {
                        $suggestionsDiv.hide().empty();
                    }
                });
            }, 300); // 300ms delay
        });
        
        // Handle click on suggestion
        $(document).on('click', suggestionsId + ' .typeahead-suggestion', function() {
            $(inputId).val($(this).data('value'));
            $(suggestionsId).hide().empty();
        });
        
        // Handle keyboard navigation
        $(inputId).on('keydown', function(e) {
            const $suggestions = $(suggestionsId + ' .typeahead-suggestion');
            const $suggestionsDiv = $(suggestionsId);
            
            if (e.keyCode === 38) { // Up arrow
                e.preventDefault();
                if (selectedIndex > 0) {
                    $suggestions.removeClass('active');
                    selectedIndex--;
                    $suggestions.eq(selectedIndex).addClass('active');
                }
            } else if (e.keyCode === 40) { // Down arrow
                e.preventDefault();
                if (selectedIndex < $suggestions.length - 1) {
                    $suggestions.removeClass('active');
                    selectedIndex++;
                    $suggestions.eq(selectedIndex).addClass('active');
                }
            } else if (e.keyCode === 13) { // Enter
                e.preventDefault();
                if (selectedIndex >= 0) {
                    const $selectedSuggestion = $suggestions.eq(selectedIndex);
                    $(inputId).val($selectedSuggestion.data('value'));
                    $suggestionsDiv.hide().empty();
                    selectedIndex = -1;
                }
            } else if (e.keyCode === 27) { // Escape
                $suggestionsDiv.hide().empty();
                selectedIndex = -1;
            }
        });
        
        // Hide suggestions when clicking outside
        $(document).on('click', function(e) {
            if (!$(e.target).closest('.field-wrapper').length) {
                $(suggestionsId).hide().empty();
                selectedIndex = -1;
            }
        });
    }
    
    // ✅ Initialize typeahead for project title
    initializeTypeahead(
        '#input_project_title', 
        '#project_title_suggestions', 
        baseURL + 'admin/MiniAdd/getProjectTitles'
    );
    
    // ✅ Initialize typeahead for guide name
    initializeTypeahead(
        '#input_guide_name', 
        '#guide_name_suggestions', 
        baseURL + 'admin/MiniAdd/getFacultyNames'
    );

    // ✅ Initialize typeahead for student name
    initializeTypeahead(
        '#input_student_name', 
        '#student_name_suggestions', 
        baseURL + 'admin/MiniAdd/getStudentNames'
    );

});
</script>

<script>
$(document).ready(function() {
    
    // ✅ Group No input pe event listener
    $('#input_group_no').on('input', function() {
        let groupNo = $(this).val().trim();
        let branchId = $('#BranchID').val();
        let year = $('#FiniYear').val();
        
        // Clear timeout to avoid multiple requests
        clearTimeout(window.groupNoTimeout);
        
        if (groupNo.length >= 1 && branchId && year) {
            window.groupNoTimeout = setTimeout(function() {
                fetchGroupPreview(groupNo, branchId, year);
            }, 500);
        } else {
            $('#groupPreviewContainer').hide();
        }
    });
    
    // ✅ Function to fetch group preview
    function fetchGroupPreview(groupNo, branchId, year) {
        $.ajax({
            url: baseURL + 'admin/MiniAdd/getGroupPreview',
            type: 'POST',
            data: {
                group_no: groupNo,
                branch_id: branchId,
                year: year
            },
            dataType: 'json',
            success: function(response) {
                console.log('Group Preview Response:', response); // ✅ Debug ke liye
                
                if (response.status === 'success' && response.count > 0) {
                    displayGroupPreview(response.data);
                    $('#groupPreviewContainer').slideDown(300);
                } else {
                    $('#groupPreviewContainer').slideUp(300);
                }
            },
            error: function(xhr, status, error) {
                console.error('Group Preview Error:', error);
                $('#groupPreviewContainer').hide();
            }
        });
    }
    
    
// ✅ Function to display preview data
function displayGroupPreview(data) {
    let html = '';
    data.forEach(function(row, index) {
        html += `
            <tr>
                <td>${index + 1}</td>
                 <td>${row.group_no || '-'}</td>
                <td>${row.roll_no || '-'}</td>
                <td>${row.prn || '-'}</td>
                <td>${row.student_name_text || row.student_name || '-'}</td>
                <td>${row.class_name || row.classname || '-'}</td>
                <td>${row.project_title || '-'}</td>
                <td>${row.guide_name || '-'}</td>
                <td>${row.sponsorship_name || row.type_name || '-'}</td>
               
            </tr>
        `;
    });
    
    $('#groupPreviewBody').html(html);
}

    // function displayGroupPreview(data) {
    //     let html = '';
    //     data.forEach(function(row, index) {
    //         html += `
    //             <tr>
    //                 <td>${index + 1}</td>
    //                 <td>${row.roll_no || '-'}</td>
    //                 <td>${row.prn || '-'}</td>
    //                 <td>${row.student_name || row.FullName || '-'}</td>
    //                 <td>${row.class_name || row.classname || '-'}</td>
    //                 <td>${row.division_name || row.div_name || '-'}</td>
    //                 <td>${row.project_title || '-'}</td>
    //                 <td>${row.guide_name || '-'}</td>
    //                 <td>${row.sponsorship_name || row.type_name || '-'}</td>
    //                 <td>${row.rank_name || '-'}</td>
    //             </tr>
    //         `;
    //     });
        
    //     $('#groupPreviewBody').html(html);
    // }
    
    // ✅ When main dropdowns change, clear preview
    $('#BranchID, #FiniYear').on('change', function() {
        $('#groupPreviewContainer').slideUp(300);
        $('#input_group_no').val('');
    });
    
});
</script>

<script>
document.addEventListener("DOMContentLoaded", function () {
    const textarea = document.getElementById("spon_details");

    function moveCursorToStart() {
        textarea.focus();
        textarea.setSelectionRange(0, 0);
    }

    // Jab bhi click kare, cursor start pe chala jaye
    textarea.addEventListener("click", moveCursorToStart);
    textarea.addEventListener("focus", moveCursorToStart);
});
</script>
