<style>
    .section-header { display: flex; align-items: center; gap: 10px; margin: 16px 0 10px; padding-bottom: 10px; border-bottom: 3px solid #667eea; }
    .section-header i { font-size: 24px; color: #667eea; }
    .section-header h5 {     font-family: math; font-size: 21px; font-weight: 800; color: #2c3e50; margin: 0;  }

    .tbl-toolbar { display: flex; align-items: center; justify-content: space-between; gap: 10px; margin-bottom: 10px; flex-wrap: wrap; }
    .tbl-search { display: flex; align-items: center; gap: 8px; background: #f4f6ff; border: 1.5px solid #c9d1fd; border-radius: 8px; padding: 7px 12px; flex: 1; max-width: 380px; }
    .tbl-search i { color: #667eea; font-size: 15px; }
    .tbl-search input { border: none; background: transparent; outline: none; font-size: 14px; width: 100%; color: #333; }
    .tbl-search input::placeholder { color: #bbb; }
    .tbl-btns { display: flex; gap: 8px; }
    .btn-modern { border-radius: 6px; padding: 8px 16px; font-weight: 600; font-size: 13px; }
</style>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-start mt-5">
                        <h4>Q.M 3.4.3.1: Total number of Patents published/awarded year wise during the last five years</h4>
                    </div>
                    <div class="card-body">

                        <form role="form" id="Form">
                            <div class="row gutters">
                               
                                <div class="col-xl-5 col-lg-5 col-md-5 col-sm-4 col-12">
                                    <div class="field-wrapper">
                                        <select class="select-single js-states" id="fkbranch_id" name="fkbranch_id" multiple="multiple" 
                                            value="<?php if(!empty($data)) echo $data[0]->fk_branch; ?>">
                                            <option value="">Select Branch</option>
                                            <?php 
                                            foreach($branchdata as $rw=>$value){
                                            $selected = "";
                                            if (!empty($data[0]->fk_branch)) {
                                                if ($value->branch_id == $data[0]->fk_branch) {
                                                    $selected = "selected='selected'";
                                                 } 
                                                }
                                                echo '<option value="'.$value->branch_id.'"'.$selected.' >'.$value->branch_name.'</option>';
                                            }
                                            ?>
                                        </select>
                                        <div class="field-placeholder">Branch</div>
                                    </div>
                                </div>
                                   
                                <div class="col-md-5">
                                    <div class="field-wrapper">
                                        <select class="select-single js-states" id="year_dropdown" name="year" multiple="multiple" 
                                            value="<?php if(!empty($data)) echo $data[0]->finicial_Year; ?>">
                                            <option value="">Select Financial Year</option>
                                            <?php 
                                            foreach($yeardata as $rw=>$value){
                                            $selected = "";
                                            if (!empty($data[0]->finicial_Year)) {
                                                if ($value->finiYear_id == $data[0]->finicial_Year) {
                                                    $selected = "selected='selected'";
                                                 } 
                                                }
                                                echo '<option value="'.$value->finiYear_id.'"'.$selected.' >'.$value->fini_Label.'</option>';
                                            }
                                            ?>
                                        </select>
                                        <div class="field-placeholder">Select Year</div>
                                    </div>
                                </div>

                                <div class="col-md-2 ">
                                    <button class="btn btn-success btn-sm m-1" type="button" id="btnShow" style="padding: 8px 20px;font-size: 13px; font-weight:600;">
                                        <i class="fas fa-search"></i> Show Data
                                    </button>
                                </div>
                            </div>

                            <!-- Year-wise Summary Table -->
                            <div class="table-responsive mt-4" id="yearWiseTableContainer">
                                <div id="yearSummarySection">
                                    <div class="tbl-toolbar no-print">
                                        <div class="tbl-btns" style="margin-left:auto;">
                                            <button type="button" class="btn btn-danger btn-modern" onclick="printSummaryTable()"><i class="fas fa-print"></i> Print</button>
                                            <button type="button" class="btn btn-success btn-modern" onclick="exportSummaryToExcel()"><i class="fas fa-file-excel"></i> Excel</button>
                                        </div>
                                    </div>

                                    <table id="yearTable" class="table custom-table modern-table horizontal-year-table" style="font-family: math; ">
                                        <tbody>
                                            <tr id="yearHeaderRow">
                                                <td class="year-label-cell"><strong>Year</strong></td>
                                            </tr>
                                            <tr id="yearDataRow">
                                                <td class="year-label-cell"><strong>Number</strong></td>
                                            </tr>
                                            <tr id="emptyStateRow">
                                                <td colspan="10" class="text-center text-muted py-5">
                                                    <i class="fas fa-info-circle fa-2x mb-2"></i>
                                                    <p>Please select filters and click "Show Data" to view results</p>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <div class=" note float-end no-print " >
                                        <p style="color:#00acf3;"> Note :</p>
                                        <p style="color:grey;">   Click Any Column for view results</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Detailed Patent Table (Shows all data on Show button click) -->
                            <div class="table-responsive mt-4" id="detailTableContainer" style="display: none;">
                                <div id="detailsSection">
                                    <div class="section-header mt-4">
                                        <i class="fas fa-list-alt"></i>
                                        <h5>Detailed Patent Records  </h5>
                                    </div>

                                    <div class="tbl-toolbar no-print">
                                        <div class="tbl-search">
                                            <i class="fas fa-search"></i>
                                            <input type="text" id="detailsSearch" placeholder="Search faculty, branch, patent name...">
                                        </div>
                                        <div class="tbl-btns">
                                            <button type="button" class="btn btn-danger btn-modern" onclick="printDetailsTable()"><i class="fas fa-print"></i> Print</button>
                                            <button type="button" class="btn btn-success btn-modern" onclick="exportDetailsToExcel()"><i class="fas fa-file-excel"></i> Excel</button>
                                            <button type="button" class="btn btn-dark btn-modern" id="closeDetailTable"><i class="fas fa-times"></i> Close</button>
                                        </div>
                                    </div>

                                    <div id="printableTable">
                                       <table id="Detailstable" class="table custom-table modern-table">
    <thead>
        <tr>
            <th>Sr.No.</th>
            <th>Industry Name</th>
            <th>Department</th>
            <th>Sign Date</th>
            <th>Start Date</th>
            <th>End Date</th>
            <th>Highlight Details</th>
            <th>Certificate</th>
            <th>Training</th>
            <th>Internship</th>
            <th>Guest Lecture</th>
            <th>Industry Visit</th>
            <th>VAP</th>
            <th>Consultancy</th>
            <th>Financial Year</th>
        </tr>
    </thead>
    <tbody>
        <!-- Data will be loaded here -->
    </tbody>
</table>
                                    </div>
                                </div>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="<?php echo base_url();?>Assets/js/jquery.min.js"></script>           
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script> 
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>

<script>
$(document).ready(function () {
    var currentFilters = {};
    var currentYearData = [];
    var allDetailedData = [];

    // Show Data button click
    $("#btnShow").click(function () {
        var yearValues = $("#year_dropdown").val();
        
        var yearFilter = null;
        if (yearValues && yearValues.length > 0) {
            yearFilter = yearValues.filter(function(val) {
                return val != "0" && val != "" && val !== null;
            });
            
            if (yearFilter.length === 0) {
                yearFilter = null;
            }
        }
        
        var branchValues = $("#fkbranch_id").val();
        var branchFilter = null;
        if (branchValues && branchValues.length > 0) {
            branchFilter = branchValues.filter(function(val) {
                return val != "" && val != "0" && val !== null;
            });
            
            if (branchFilter.length === 0) {
                branchFilter = null;
            }
        }

        currentFilters = {
            fk_institu: $("#fk_institu").val() || null,
            fkbranch_id: branchFilter,
            year: yearFilter
        };

        console.log('Filters being sent:', currentFilters);
        
        loadYearWiseData();
        loadAllDetailedData();
    });

    // Function to load year-wise count
    function loadYearWiseData() {
        $("#emptyStateRow").show();
        $("#emptyStateRow td").html(`
            <div class="table-loader">
                <div class="loader-spinner"></div>
                <div class="loader-text">Loading...</div>
            </div>
        `);
        $("#yearHeaderRow td:not(:first)").remove();
        $("#yearDataRow td:not(:first)").remove();

        $.ajax({
            url: "<?= base_url('admin/Ni_Report1/getYearWiseCount') ?>",
            type: "POST",
            data: currentFilters,
            dataType: "json",
            success: function (response) {
                console.log('Year-wise response:', response);
                
                currentYearData = response;
                
                if (response.length > 0) {
                    $("#emptyStateRow").hide();
                    $("#yearHeaderRow td:not(:first)").remove();
                    $("#yearDataRow td:not(:first)").remove();
                    
                    $.each(response, function (index, row) {
                        $("#yearHeaderRow").append(`
                            <td class="year-cell clickable-year" data-year-id="${row.finiYear_id}" data-year-label="${row.year}">
                                <strong>${row.year || 'N/A'}</strong>
                            </td>
                        `);
                        
                        $("#yearDataRow").append(`
                            <td class="count-cell clickable-year" data-year-id="${row.finiYear_id}" data-year-label="${row.year}">
                                <span>${row.count || 0}</span>
                            </td>
                        `);
                    });
                } else {
                    $("#emptyStateRow").show();
                    $("#emptyStateRow td").html(`
                        <div class="text-center text-danger py-5">
                            <i class="fas fa-exclamation-circle fa-2x mb-2"></i>
                            <p>No data found for the selected filters</p>
                        </div>
                    `);
                }
            },
            error: function (xhr, status, error) {
                console.error('Error:', error);
                console.error('Response:', xhr.responseText);
                $("#emptyStateRow").show();
                $("#emptyStateRow td").html(`
                    <div class="text-center text-danger py-5">
                        <i class="fas fa-exclamation-circle fa-2x mb-2"></i>
                        <p>Error loading data. Please try again.</p>
                    </div>
                `);
                Swal.fire("Error", "Something went wrong!", "error");
            }
        });
    }

    // Function to load ALL detailed data
    function loadAllDetailedData() {
        $("#detailTableContainer").slideDown(400);
        
        $("#Detailstable tbody").html(`
            <tr>
                <td colspan="15">
                    <div class="table-loader">
                        <div class="loader-spinner"></div>
                        <div class="loader-text">Loading...</div>
                    </div>
                </td>
            </tr>
        `);

        var detailFilters = Object.assign({}, currentFilters);
        delete detailFilters.specific_year_id;

        console.log('Loading all detail filters:', detailFilters);

        $.ajax({
            url: "<?= base_url('admin/Ni_Report1/getMOUData') ?>",
            type: "POST",
            data: detailFilters,
            dataType: "json",
            success: function (response) {
                console.log('All Detailed response:', response);
                console.log('Number of records:', response.length);
                
                allDetailedData = response;
                renderDetailedTable(response);
            },
            error: function (xhr, status, error) {
                console.error('Detail Error:', error);
                console.error('Detail Response:', xhr.responseText);
                $("#Detailstable tbody").html(`
                    <tr>
                        <td colspan="15" class="text-center text-danger py-5">
                            <i class="fas fa-exclamation-circle fa-2x mb-2"></i>
                            <p>Error loading detailed data. Please try again.</p>
                        </td>
                    </tr>
                `);
                Swal.fire("Error", "Failed to load detailed data!", "error");
            }
        });
    }

    // Click on year cell to filter
    $(document).on('click', '.clickable-year', function() {
        var selectedYearId = $(this).data('year-id');
        var selectedYearLabel = $(this).data('year-label');
        
        console.log('Clicked year ID:', selectedYearId);
        console.log('Clicked year Label:', selectedYearLabel);
        
        $('.clickable-year').removeClass('table-active');
        $(`.clickable-year[data-year-id="${selectedYearId}"]`).addClass('table-active');
        
        $("#detailTableContainer").slideDown(400);
        
        $('html, body').animate({
            scrollTop: $("#detailTableContainer").offset().top - 100
        }, 500);
        
        filterDetailedDataByYear(selectedYearId);
    });

    // Filter detailed data by year
    function filterDetailedDataByYear(yearId) {
        console.log('Filtering by year ID:', yearId);
        console.log('Total records available:', allDetailedData.length);
        
        $("#Detailstable tbody").html(`
            <tr>
                <td colspan="15">
                    <div class="table-loader">
                        <div class="loader-spinner"></div>
                        <div class="loader-text">Filtering...</div>
                    </div>
                </td>
            </tr>
        `);
        
        setTimeout(function() {
            var filteredData = allDetailedData.filter(function(item) {
                return item.fkYear_id == yearId;
            });
            
            console.log('Filtered records:', filteredData.length);
            renderDetailedTable(filteredData);
        }, 300);
    }

    // Render detailed table
    function renderDetailedTable(data) {
        var tbody = "";
        if (data.length > 0) {
            $.each(data, function (index, row) {
                tbody += `
                    <tr class="detail-row">
                        <td class="text-center">${index + 1}</td>
                        <td>${row.Indu_Name || '-'}</td>
                        <td>${row.branch_name || '-'}</td>
                        <td class="text-center">${formatDate(row.SignDate) || '-'}</td>
                        <td class="text-center">${formatDate(row.StartDate) || '-'}</td>
                        <td class="text-center">${formatDate(row.EndDate) || '-'}</td>
                        <td>${row.Highlight_Detail || '-'}</td>
                        <td class="text-center">
                            ${row.Certificate == '1' ? '<span class="badge badge-success"><i class="fas fa-check"></i> Yes</span>' : '<span class="badge badge-secondary">No</span>'}
                        </td>
                        <td class="text-center">
                            ${row.Training == '1' ? '<span class="badge badge-success"><i class="fas fa-check"></i> Yes</span>' : '<span class="badge badge-secondary">No</span>'}
                        </td>
                        <td class="text-center">
                            ${row.Intership == '1' ? '<span class="badge badge-success"><i class="fas fa-check"></i> Yes</span>' : '<span class="badge badge-secondary">No</span>'}
                        </td>
                        <td class="text-center">
                            ${row.Guest_Lec == '1' ? '<span class="badge badge-success"><i class="fas fa-check"></i> Yes</span>' : '<span class="badge badge-secondary">No</span>'}
                        </td>
                        <td class="text-center">
                            ${row.Industry_visit == '1' ? '<span class="badge badge-success"><i class="fas fa-check"></i> Yes</span>' : '<span class="badge badge-secondary">No</span>'}
                        </td>
                        <td class="text-center">
                            ${row.VAP == '1' ? '<span class="badge badge-success"><i class="fas fa-check"></i> Yes</span>' : '<span class="badge badge-secondary">No</span>'}
                        </td>
                        <td class="text-center">
                            ${row.Consultancy == '1' ? '<span class="badge badge-success"><i class="fas fa-check"></i> Yes</span>' : '<span class="badge badge-secondary">No</span>'}
                        </td>
                        <td class="text-center">${row.fini_Label || '-'}</td>
                    </tr>
                `;
            });
        } else {
            tbody = `
                <tr>
                    <td colspan="15" class="text-center text-danger py-5">
                        <i class="fas fa-folder-open fa-2x mb-2"></i>
                        <p>No MOUs found for the selected filters</p>
                    </td>
                </tr>
            `;
        }
        $("#Detailstable tbody").html(tbody);
    }

    // Close detail table button
    $("#closeDetailTable").click(function() {
        $("#detailTableContainer").slideUp();
        $('.clickable-year').removeClass('table-active');
        renderDetailedTable(allDetailedData);
    });

    // Search functionality
    $("#detailsSearch").on("keyup", function() {
        var value = $(this).val().toLowerCase();
        $("#Detailstable tbody tr").filter(function() {
            $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
        });
    });

    // Format date helper
    function formatDate(dateString) {
        if (!dateString) return '';
        const date = new Date(dateString);
        const day = String(date.getDate()).padStart(2, '0');
        const month = String(date.getMonth() + 1).padStart(2, '0');
        const year = date.getFullYear();
        return `${day}-${month}-${year}`;
    }
});

// Print & Export functions remain same...
</script>

<style>
/* ========================================
   PATENT REPORT - SIMPLE & CLEAN STYLES
   ======================================== */

/* Reset & Base */
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: Arial, sans-serif;
    background: #f5f5f5;
    color: #333;
}

/* Card Styling */
.card {
    background: white;
    border-radius: 8px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    border: none;
}
/* Loader Styles */
.table-loader {
    display: flex;
    justify-content: center;
    align-items: center;
    padding: 40px 20px;
    flex-direction: column;
    gap: 15px;
}
.note{
        font-family: math;
        display: flex;
        /* float:end; */
    font-weight:600;
}

.loader-spinner {
    width: 50px;
    height: 50px;
    border: 4px solid #f3f3f3;
    border-top: 4px solid #3498db;
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

.loader-text {
    color: #7f8c8d;
    font-size: 14px;
    font-weight: 500;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

.card-header {
    background: #2c3e50;
    padding: 20px;
    text-align: center;
}

.card-body {
    padding: 25px;
}

/* Form Fields */
.field-wrapper {
    position: relative;
    margin-bottom: 20px;
}

.field-wrapper select {
    width: 100%;
    padding: 10px 12px;
    border: 1px solid #ddd;
    border-radius: 4px;
    font-size: 14px;
    background: white;
}

.field-wrapper select:focus {
    outline: none;
    border-color: #3498db;
}

.field-placeholder {
    position: absolute;
    top: -10px;
    left: 10px;
    background: white;
    padding: 0 5px;
    font-size: 12px;
    color: #3498db;
    font-weight: 600;
}

/* Buttons */
.btn {
    padding: 8px 16px;
    border-radius: 4px;
    font-size: 13px;
    font-weight: 600;
    border: none;
    cursor: pointer;
}

.btn-success {
    background: #27ae60;
    color: white;
}

.btn-danger {
    background: #e74c3c;
    color: white;
}

.btn-secondary {
    background: #95a5a6;
    color: white;
}

.btn-dark {
    background: #34495e;
    color: white;
}

.btn:hover {
    opacity: 0.9;
}

/* Table Container */
.table-responsive {
    background: white;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    margin-top: 20px;
}
h4 {
    font-size: 1.25rem;
    margin-bottom: .4rem;
    font-family: math;
}
/* ========================================
   YEAR-WISE TABLE (BLUE THEME)
   ======================================== */

.table-header-card {
    background: #3498db;
    padding: 15px 20px;
    color: white;
}

.table-title {
    color: white;
    margin: 0;
    font-size: 18px;
    font-weight: 600;
}

.table-title i {
    margin-right: 8px;
}

/* Year Table - Horizontal Layout */
.horizontal-year-table {
    width: 100%;
    border-collapse: collapse;
}

.horizontal-year-table tbody tr td {
    border: 1px solid #0c0c0c;
    padding: 12px 15px;
    text-align: center;
    font-size: 16px;
}

.year-label-cell {
    background: #3498db;
    color: white;
    font-weight: 700;
    font-size: 14px;
    width: 100px;
}

.year-cell {
    background: #e3f2fd;
    color: #1565c0;
    font-weight: 600;
    cursor: pointer;
    transition: background 0.3s;
}

.year-cell:hover {
    background: #bbdefb;
}

.count-cell {
    background: #f5f5f5;
    cursor: pointer;
    transition: background 0.3s;
}

.count-cell:hover {
    background: #e3f2fd;
}

.clickable-year.table-active {
    background: #2196f3 !important;
    color: white !important;
    font-weight: 700;
}

.clickable-year.table-active .badge-patent-count {
    background: white;
    color: #2196f3;
}

.badge-patent-count {
    background: #fefefe;
    color: black;
    padding: 6px 16px;
    border-radius: 20px;
    font-size: 14px;
    font-weight: 700;
    display: inline-block;
}

/* ========================================
   DETAILED TABLE (GREEN THEME)
   ======================================== */

.table {
    background-color: #ffffff;
}

.table-header-card.detailed-header {
    background: #27ae60;
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: nowrap;
}

.table-title {
    color: white;
    margin: 0;
    font-size: 18px;
    font-weight: 600;
    display: flex;
    align-items: center;
    flex: 1;
}

.table-title i {
    margin-right: 8px;
}

.selected-year-badge {
    background: rgba(255, 255, 255, 0.3);
    padding: 4px 12px;
    border-radius: 15px;
    font-size: 13px;
    margin-left: 10px;
    display: inline-block;
}

/* Detailed Table Styling */
#Detailstable {
    width: 100%;
    border-collapse: collapse;
}





#Detailstable thead th  {
    font-family: revert;
    background: darkorange;
    padding: 12px 10px;
    color: #000;
    font-weight: 600;
  border: 1px solid #000;
    font-size: 13px;
    text-align: center;
  
}

#Detailstable tbody tr {
    border-bottom: 1px solid #050505 !important;
    transition: background 0.2s;
}

#Detailstable tbody tr:hover {
    background: #f9f9f9;
}

#Detailstable tbody td {
    padding: 12px 10px;
    font-size: 14px;
    color: #555;
    text-align: center;
}

.detail-row {
    background: white;
}

.patent-name-cell {
    text-align: left;
    font-weight: 500;
    color: #333;
    max-width: 250px;
}

/* Badges */
.badge {
    padding: 4px 10px;
    border-radius: 12px;
    font-size: 12px;
    font-weight: 600;
}

.badge-success {
    background: #27ae60;
    color: white;
}

.badge-secondary {
    background: #95a5a6;
    color: white;
}

/* Loading Spinner */
.table-spinner {
    display: inline-block;
    width: 35px;
    height: 35px;
    border: 3px solid #f0f0f0;
    border-top: 3px solid #3498db;
    border-radius: 50%;
    animation: spin 0.8s linear infinite;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

/* Empty State */
.text-center {
    text-align: center;
}

.text-muted {
    color: #7f8c8d !important;
}

.text-danger {
    color: #e74c3c !important;
}

.fa-2x {
    font-size: 2em;
}

/* Slide Animation */
#detailTableContainer {
    overflow: hidden;
}

/* Utility Classes */
.mt-2 { margin-top: 0.5rem; }
.mt-4 { margin-top: 1.5rem; }
.m-1 { margin: 0.25rem; }
.py-4 { padding-top: 1.5rem; padding-bottom: 1.5rem; }
.py-5 { padding-top: 3rem; padding-bottom: 3rem; }
.mb-2 { margin-bottom: 0.5rem; }
.text-right { text-align: right; }

/* Button Icon Styling */
.btn i {
    margin-right: 5px;
}

/* Responsive Design */
@media (max-width: 768px) {
    .card-body {
        padding: 15px;
    }
    
    .table-title {
        font-size: 16px;
        flex-wrap: wrap;
    }
    
    .selected-year-badge {
        display: block;
        margin-left: 0;
        margin-top: 5px;
        width: fit-content;
    }
    
    .table-header-card.detailed-header {
        flex-wrap: wrap;
        gap: 10px;
    }
    
    #Detailstable thead th {
        font-size: 11px;
        padding: 10px 6px;
    }
    
    #Detailstable tbody td {
        font-size: 12px;
        padding: 10px 6px;
    }
   #Detailstable th {
    background-color: #cdd7eb !important;
    color: black !important;
    font-weight: bold;
    padding: 10px;
    letter-spacing: 0.5px;
    border: 1px solid black;
}
    
    .year-label-cell {
        width: 80px;
        font-size: 12px;
    }
    
    .badge-patent-count {
        font-size: 12px;
        padding: 4px 12px;
    }
}

@media (max-width: 576px) {
    .horizontal-year-table {
        font-size: 12px;
    }
    
    .year-cell,
    .count-cell {
        padding: 10px;
    }
}

/* Print Styles */
@media print {
    .btn, .table-header-card, .field-wrapper, .no-print {
        display: none !important;
    }
    
    .card {
        box-shadow: none;
    }
    
    #Detailstable thead {
        background: #333 !important;
        -webkit-print-color-adjust: exact;
    }
}
</style>