 <style>

   /* Add New Department Button Style */
.typeahead-add-new {
    padding: 10px 16px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    cursor: pointer;
    border-bottom: 1px solid #f0f0f0;
    font-weight: 600;
    text-align: center;
    transition: all 0.3s ease;
    border-radius: 8px;
    margin: 8px;
    box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
    position: relative;
    overflow: hidden;
}

.typeahead-add-new::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
    transition: left 0.5s;
}

.typeahead-add-new:hover::before {
    left: 100%;
}

.typeahead-add-new:hover {
    background: linear-gradient(135deg, #764ba2 0%, #667eea 100%);
    transform: translateY(-3px) scale(1.02);
    box-shadow: 0 8px 25px rgba(102, 126, 234, 0.6);
}

.typeahead-add-new:active {
    transform: translateY(-1px) scale(0.98);
}

.typeahead-add-new i {
    margin-right: 8px;
    font-size: 16px;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% {
        transform: scale(1);
    }
    50% {
        transform: scale(1.1);
    }
}
/* Typeahead Dropdown Styles */
.department-wrapper {
    position: relative;
}

.typeahead-dropdown {
    position: absolute;
    top: 100%;
    left: 0;
    right: 0;
    background: white;
    border: 1px solid #ddd;
    border-radius: 4px;
    max-height: 300px;
    overflow-y: auto;
    z-index: 9999;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    display: none;
}

.typeahead-dropdown.show {
    display: block;
}

.typeahead-item {
    padding: 10px 15px;
    cursor: pointer;
    border-bottom: 1px solid #f0f0f0;
    transition: background 0.2s;
}

.typeahead-item:hover,
.typeahead-item.active {
    background-color: #f0f8ff;
    color: #007bff;
}

.typeahead-item .name {
    font-weight: 500;
    color: #333;
}

.typeahead-no-results {
    padding: 15px;
    text-align: center;
    color: #999;
    font-style: italic;
}


    .technical-menu {
            position: relative;
        }
        
        .legend-header {
            position: absolute;
            top: -12px;
            left: 20px;
            background: white;
            padding: 0 10px;
        }
        
        .legend-header h4 {
            color: #df0a7b;
            font-weight: 600;
            margin: 0;
            font-size: 19px !important;
        }
        /* Technical Menu Styles */
        .technical-menu {
            background: #f8f9fa00;
            border-radius: 10px;
            padding: 20px;
            margin-top: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

    /* Select2 container width - FIXED */
.select2-container {
    width: 100% !important;
    max-width: 100% !important;
}

/* Prevent Select2 from expanding beyond parent */
.field-wrapper .select2-container {
    display: block !important;
    width: 100% !important;
}

/* Dropdown positioning fix */
.select2-dropdown {
    max-width: 400px !important;
    width: auto !important;
}

/* Prevent container shift on open */
.select2-container--open {
    width: 100% !important;
}

.select2-container--open .select2-selection {
    width: 100% !important;
}

/* Custom classes for fixed behavior */
.select2-container-fixed {
    max-width: 100%;
    overflow: hidden;
}

.select2-dropdown-fixed {
    max-width: 400px;
    width: max-content !important;
    min-width: 200px;
}




        .file-upload-cell {
            position: relative;
            width: 120px;
        }
        .file-input {
            position: absolute;
            opacity: 0;
            width: 100%;
            height: 100%;
            cursor: pointer;
        }
        .file-label {
            display: inline-block;
            background: #007bff;
            color: white;
            padding: 5px 10px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 12px;
            text-align: center;
            width: 100px;
        }
        .file-label:hover {
            background: #0056b3;
        }
        .file-name {
            font-size: 10px;
            color: #666;
            margin-top: 2px;
            word-break: break-word;
        }
        .file-remove {
            color: red;
            cursor: pointer;
            font-size: 10px;
            margin-left: 5px;
        }
        .wide-th {
        width: 200px !important;  
    }
    .total-row {
    background-color: #f8f9fa;
    font-weight: bold;
    border-top: 2px solid #dee2e6;
}

.total-row td {
    padding: 12px 8px !important;
    font-size: 14px;
}

.total-amount {
    color: #28a745;
    font-size: 16px;
    font-weight: 600;
}
/* Select2 ko normal dropdown jaisa banao */
.select2-container .select2-selection--single {
    height: 38px !important;
    border: 1px solid #ced4da !important;
    border-radius: 4px !important;
}
 
.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 36px !important;
    padding-left: 12px !important;
    color: #495057 !important;
    padding: 2px;
}
 
.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 36px !important;
    right: 8px !important;
}
 
.select2-container--default .select2-selection--single .select2-selection__arrow b {
    border-color: #49574fff transparent transparent transparent !important;
}
 
/* Dropdown menu styling */
.select2-dropdown {
        border: 1px solid #f89450 !important;
            border-radius: 4px !important;
            
    background-color: #edfff2 !important;
}
 
.select2-container--default .select2-results__option--highlighted[aria-selected] {
    background-color: #007bff !important;
    color: white !important;
}
 
.select2-search--dropdown .select2-search__field {
    border: 1px solid #ced4da !important;
    border-radius: 4px !important;
    padding: 6px 12px !important;
}
 
/* Focus state */
.select2-container--default.select2-container--focus .select2-selection--single {
    border-color: #80bdff !important;
    outline: 0 !important;
    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25) !important;
}

/* Select2 container width */
.select2-container {
    width: 100% !important;
}
 
    </style>

    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<div class="content-wrapper-scroll">
    <!-- Content wrapper start -->
    <div class="content-wrapper">
        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <!-- Card start -->
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1">Outward Form </div>
                    </div>
                    <div class="card-body">
                        <form role="form" id="Form" action="" method="post">
                        <!-- Row start -->
                        <div class="row gutters">
                           <input type="hidden" id="Outward_main_id" name="Outward_main_id"
       class="hiddenId" style="width: 40px !important;height: 40px;"
       value="<?php if(!empty($data)) echo $data[0]->Outward_main_id; ?>">

<!-- hidden submenuid -->
<input class="form-control" id="fk_submenuId" name="fk_submenuId" type="hidden"
                           value="<?= isset($subId) ? $subId : '' ?>"  />


                           <div class="col-xl-3 col-lg-3 col-md-3 col-sm-6 col-12">
    <div class="field-wrapper">
        <label class="field-placeholder">Department</label>
        <div class="department-wrapper">
            <input type="text" 
                   name="Department"   
                   id="Department"  
                   class="form-control department-input"
                   placeholder="Type to search..."
                   autocomplete="off"
                   value="<?php if(!empty($data) && isset($data[0]->Department_name)) echo $data[0]->Department_name; ?>">
            
            <!-- Hidden field for department ID -->
            <input type="hidden" 
                   name="fkdepartment_id" 
                   id="fkdepartment_id" 
                   value="<?php if(!empty($data) && isset($data[0]->fkdepartment_id)) echo $data[0]->fkdepartment_id; ?>">
            
            <!-- Typeahead Dropdown -->
            <div class="typeahead-dropdown" id="department_typeahead_dropdown"></div>
        </div>
    </div>
</div>

    <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
    <div class="field-wrapper">
        <input type="date" name="Date" id="Date" class="form-control" min="0" 
        value="<?php echo !empty($data) ? $data[0]->Date : date('Y-m-d'); ?>">
        <div class="field-placeholder">Outward Date</div>
    </div>
</div>



                      <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                <div class="field-wrapper">
                                    <select class="select-single js-states" name="fkmainuser_id" id="fkmainuser_id" required>
                                                <option value="">Select Applicants</option>
                                                <?php foreach($mainuserdata as $value): ?>
                                                    <option value="<?= $value->mainuser_id ?>" <?= (!empty($data[0]->fkmainuser_id) && $data[0]->fkmainuser_id == $value->mainuser_id) ? "selected ='selected'" : '' ?>>
                                                        <?= $value->mainuser_name ?>
                                                    </option>
                                                <?php endforeach; ?>
                                            </select>
                                    <div class="field-placeholder">Applicants Type</div>
                                </div>
                            </div>



                            <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12"  >
    <div class="field-wrapper">
        <input type="text" name="Applicant_name" id="Applicant_name" class="form-control" min="0" 
        value="<?php if(!empty($data)) echo $data[0]->Applicant_name; ?>">
        <div class="field-placeholder" id="name_label"> Name of</div>
      
    </div>
</div>
                            


                           
                             <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12"  >
    <div class="field-wrapper">
        <input type="number" name="Applicant_id" id="Applicant_id" class="form-control" min="0" 
        value="<?php if(!empty($data)) echo $data[0]->Applicant_id; ?>">
        <div class="field-placeholder" id="id_label"> ID </div>
      
    </div>
</div>





                            
                      

<!-- <p style="color:#ba5656; font-size:16px; font-weight:600;" class="mb-3">Item Details</p> -->

                            
<div class="col-xl-12 col-lg-12 col-md-12 col-sm-3 col-12">

<div class="technical-menu">

<div class="legend-header">
                     <h4 class="mb-2" style="color: #df0a7b; font-weight: 600;">Item Details</h4>
                </div>


            
                <div class="row mt-3">

                   <!-- Item Selection Fields - These should be EMPTY for adding new items -->
<div class="col-xl-4 col-lg-4 col-md-4 col-sm-3 col-12">
    <div class="field-wrapper">
        <select name="fkCategory_ID" id="fkCategory_ID" class="select-single js-states form-control">
            <option value="">Select category</option>
            <?php foreach($categorydata as $category): ?>
                <option value="<?= $category->Category_ID ?>">
                    <?= $category->Category_Name ?>
                </option>
            <?php endforeach; ?>
        </select>
        <div class="field-placeholder">Item Category</div>
    </div>
</div>

<div class="col-xl-4 col-lg-4 col-md-4 col-sm-3 col-12">
    <div class="field-wrapper">
        <select name="fkItem_id" id="fkItem_id" class="select-single js-states form-control">
            <option value="">Select Item</option>
            <?php foreach($itemdata as $item): ?>
                <option value="<?= $item->Item_id ?>">
                    <?= $item->Item_name ?>
                </option>
            <?php endforeach; ?>
        </select>
        <div class="field-placeholder">Item Name</div>
    </div>
</div>

<!-- Add this NEW field to show stock quantity -->
<div class="col-xl-2 col-lg-2 col-md-2 col-sm-3 col-12">
    <div class="field-wrapper">
        <input type="text" id="stock_qty_display" class="form-control" 
               style="font-weight: bold; color: #28a745; background-color: #f8f9fa;" 
               readonly>
        <div class="field-placeholder">Available Stock</div>
    </div>
</div>

<div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
    <div class="field-wrapper">
        <select name="fkUnit_ID" id="fkUnit_ID" class="select-single js-states form-control" >
            <option value="">Select Unit</option>
            <?php foreach($unitdata as $unit): ?>
                <option value="<?= $unit->Unit_ID ?>">
                    <?= $unit->Unit_Name ?>
                </option>
            <?php endforeach; ?>
        </select>
        <div class="field-placeholder">Unit</div>
    </div>
</div>

<!-- Quantity Field - EMPTY for new entries -->
<div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
    <div class="field-wrapper">
        <input type="number" name="Quantity" id="Quantity" class="form-control" min="0" value="">
        <div class="field-placeholder">Quantity</div>
    </div>
</div>

<!-- Rate Field - EMPTY for new entries -->
<div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
    <div class="field-wrapper">
        <input type="number" name="Rate" id="Rate" class="form-control" min="0" step="0.01" value="">
        <div class="field-placeholder">Rate</div>
    </div>
</div>

<!-- Total Field - EMPTY, will be auto-calculated -->
<div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
    <div class="field-wrapper">
        <input type="number" name="Total" id="Total" class="form-control" min="0" step="0.01" value="" readonly>
        <div class="field-placeholder">Total</div>
    </div>
</div>

            </div>
                
<div class="table-responsive" style="max-height: 800px; overflow-y: auto;">
           
                <table class="table table-bordered table-striped table-hover mb-0">
                    <thead class="table-dark sticky-top">
                        <tr>
                            <th class="text-white">Sr.No.</th>
                            <th class="text-white">Item Category</th>
                            <th class="text-white">Item Name</th>
                            <th class="text-white">Unit</th>
                            <th class="text-white">Quantity</th>
                            <th class="text-white">Rate</th>
                            <th class="text-white">Total</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody id="displayTableBody">
                        <tr class="text-center">
                            <td colspan="11" class="text-muted py-4">
                                <i class="fa-solid fa-inbox fa-2x mb-2"></i><br>
                                <i>No entries saved yet.</i>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div id="searchResults" class="p-2 bg-light border-top text-muted small" style="display: none;">
                <i class="fa-solid fa-info-circle"></i> 
                Showing <strong id="matchCount">0</strong> of <strong id="totalCount">0</strong> entries
            </div>
        </div>

    
</div>

                                               
                             
                        
                       
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 mt-3">
                                              <button type="button" class="btn mb-md-0 mb-2 btn-quarternary" id="submit" name="submit" type="button"><i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save</button>
                                                <a class="btn mb-md-0 mb-2 btn-quarternary1" href="<?=base_url()?>admin/Outward/index" type="button"><i class="fa-solid fa-list"></i>&nbsp;&nbsp;List</a>
                                                      <button class="btn mb-md-0 mb-2 btn-quarternaryhome" type="button"  onclick="window.location.href='<?= base_url() ?>admin/Storeitem/Dashboard'" ><i class="fa-solid fa-home"></i>&nbsp;&nbsp;Home</button><br>
                                        </div>



                     
                        
                        <!-- Row end -->
                        </form>
                        
                    </div>
                </div>
                <!-- Card end -->
            </div>
        </div>
        <!-- Row end -->-
    </div>
    <!-- Content wrapper end -->
</div>

<!-- jQuery (required) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- <script src="<?php echo base_url();?>Assets/js/CreateJs/admin/Outward.js"></script>  -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>


<script>
$(document).ready(function () {

    function updateFields() {
        const applicantType = $("#fkmainuser_id option:selected").text().trim();

        if (applicantType === "Student") {
            $("#name_label").text("Name of Student");
            $("#id_label").text("PRN");
        }
        else if (applicantType === "Faculty") {
            $("#name_label").text("Name of Faculty");
            $("#id_label").text("Faculty ID");
        }
        else {
            $("#name_label").text("Name Of");
            $("#id_label").text("ID");
        }
    }

    // On change
    $("#fkmainuser_id").on("change", updateFields);

    // For edit mode / page reload
    updateFields();
});
</script>
<script>
    // ============ CASCADING DROPDOWN LOGIC ============

$(document).ready(function() {
    
    // Store all items data in JavaScript array for filtering
    let allItems = [
        <?php foreach($itemdata as $item): ?>
        {
            itemId: '<?= $item->Item_id ?>',
            itemName: '<?= $item->Item_name ?>',
            categoryId: '<?= $item->fkCategory_ID ?>'
        },
        <?php endforeach; ?>
    ];

    // Store all units data
    let allUnits = [
        <?php foreach($unitdata as $unit): ?>
        {
            unitId: '<?= $unit->Unit_ID ?>',
            unitName: '<?= $unit->Unit_Name ?>'
        },
        <?php endforeach; ?>
    ];

    // When Category is selected, filter and populate Items
    $('#fkCategory_ID').on('change', function() {
        let selectedCategory = $(this).val();
        
        // Clear item and unit fields
        $('#fkItem_id').empty().append('<option value="">Select Item</option>');
        $('#fkUnit_ID').val('').prop('readonly', true).trigger('change');
        
        if (selectedCategory) {
            // Filter items by selected category
            let filteredItems = allItems.filter(item => item.categoryId === selectedCategory);
            
            // Populate Item dropdown with filtered items
            filteredItems.forEach(function(item) {
                $('#fkItem_id').append(
                    `<option value="${item.itemId}">${item.itemName}</option>`
                );
            });
            
            // Reinitialize Select2 for Item dropdown
            $('#fkItem_id').select2('destroy').select2({
                width: '100%',
                placeholder: 'Select Item',
                dropdownAutoWidth: true
            });
        } else {
            // Reset Item dropdown to show all items
            $('#fkItem_id').select2('destroy');
            $('#fkItem_id').empty().append('<option value="">Select Item</option>');
            <?php foreach($itemdata as $item): ?>
            $('#fkItem_id').append(
                `<option value="<?= $item->Item_id ?>"><?= $item->Item_name ?></option>`
            );
            <?php endforeach; ?>
            $('#fkItem_id').select2({
                width: '100%',
                placeholder: 'Select Item',
                dropdownAutoWidth: true
            });
        }
    });

    // When Item is selected, auto-fill Unit (read-only)
    $('#fkItem_id').on('change', function() {
        let selectedItem = $(this).val();
        
        if (selectedItem) {
            // AJAX call to get unit for selected item
            $.ajax({
                url: '<?= base_url() ?>admin/Outward/getItemUnit',
                type: 'POST',
                data: { item_id: selectedItem },
                dataType: 'json',
                success: function(response) {
                    if (response.success && response.unit_id) {
                        // Set unit value and make it readonly
                        $('#fkUnit_ID').val(response.unit_id).prop('readonly', true).trigger('change');
                    } else {
                        // If no unit found, allow manual selection
                        $('#fkUnit_ID').val('').prop('readonly', false).trigger('change');
                    }
                },
                error: function() {
                    // On error, allow manual selection
                    $('#fkUnit_ID').val('').prop('readonly', false).trigger('change');
                }
            });
        } else {
            // Clear and lock unit field
            $('#fkUnit_ID').val('').prop('readonly', true).trigger('change');
        }
    });

    // Prevent manual editing of Unit field
    $('#fkUnit_ID').on('select2:opening', function(e) {
        if ($(this).prop('readonly')) {
            e.preventDefault();
        }
    });
});
</script>






<script>

$(document).ready(function() {
    // Initialize Select2 for all dropdowns with keyboard navigation
    $('.select-single.js-states').select2({
        width: '100%',
        placeholder: 'Select an option',
        // allowClear: true, 
        dropdownAutoWidth: true
    });

    // Storage for table entries
    let tableEntries = [];

    // ============ LOAD EXISTING DATA FOR UPDATE ============
    <?php if (!empty($childData)): ?>
        // Pre-populate table with existing child data
        <?php foreach($childData as $child): ?>
            tableEntries.push({
                OutwardId: '<?= isset($child->Outward_id) ? $child->Outward_id : '' ?>',
                categoryId: '<?= isset($child->fkCategory_ID) ? $child->fkCategory_ID : '' ?>',
                categoryText: '<?= isset($child->Category_Name) ? $child->Category_Name : 'N/A' ?>',
                itemId: '<?= isset($child->fkItem_id) ? $child->fkItem_id : '' ?>',
                itemText: '<?= isset($child->Item_name) ? $child->Item_name : 'N/A' ?>',
                unitId: '<?= isset($child->fkUnit_ID) ? $child->fkUnit_ID : '' ?>',
                unitText: '<?= isset($child->Unit_Name) ? $child->Unit_Name : 'N/A' ?>',
                quantity: '<?= isset($child->Quantity) ? $child->Quantity : '0' ?>',
                rate: '<?= isset($child->Rate) ? $child->Rate : '0' ?>',
                total: '<?= isset($child->Total) ? $child->Total : '0' ?>'
            });
        <?php endforeach; ?>
        
        // Display pre-loaded data
        updateTableDisplay();
    <?php endif; ?>

    // Page load par Date field par FORCE focus
    // setTimeout(function() {
    //     $('#Date').focus().select();
    // }, 500);

    // ============ KEYBOARD NAVIGATION ============
    

   

   
   let departmentTypingTimer;
    let departmentTypingInterval = 300;
    let currentFocus = -1;

    // PAGE REFRESH → FORCE DEPARTMENT FIELD
    setTimeout(function() {
        $('#Department').focus();
    }, 500);

    // ============ DEPARTMENT TYPEAHEAD - KEYUP EVENT ============
   // ============ DEPARTMENT TYPEAHEAD - KEYUP EVENT ============
$("#Department").on('keyup', function(e) {
    if (e.keyCode === 38 || e.keyCode === 40 || e.keyCode === 13) {
        return;
    }

    clearTimeout(departmentTypingTimer);
    const searchTerm = $(this).val().trim();

    if (searchTerm.length === 0) {
        $('#department_typeahead_dropdown').removeClass('show').html('');
        return;
    }

    if (searchTerm.length >= 1) {
        departmentTypingTimer = setTimeout(function() {
            searchDepartmentsWithAddNew(searchTerm);
        }, departmentTypingInterval);
    }
});

// ============ SEARCH DEPARTMENTS WITH ADD NEW OPTION ============
function searchDepartmentsWithAddNew(search) {
    $.ajax({
        url: '<?= base_url() ?>admin/Outward/searchDepartments',
        type: 'POST',
        data: { search: search },
        dataType: 'json',
        beforeSend: function() {
            $('#department_typeahead_dropdown')
                .html('<div class="typeahead-no-results"><i class="fa fa-spinner fa-spin"></i> Searching...</div>')
                .addClass('show');
        },
        success: function(response) {
            let html = '';
            
            if (response.success && response.data.length > 0) {
                // Show existing departments
                $.each(response.data, function(i, item) {
                    html += `
                        <div class="typeahead-item" data-department-id="${item.department_id}" data-department-name="${item.Department_name}">
                            <span class="name">${item.Department_name}</span>
                        </div>
                    `;
                });
            } else {
                // No results - show "not found" message
                html += `<div class="typeahead-no-results">No matching departments found.</div>`;
            }
            
            // Always show "Add New" option at the bottom
            html += `
               <div class="typeahead-add-new" data-new-department="${search}">
    <i class="fa fa-square-plus"></i> Add New: "${search}"
</div>
            `;
            
            $('#department_typeahead_dropdown').html(html).addClass('show');
        },
        error: function(xhr, status, error) {
            console.error('Department search error:', error);
            $('#department_typeahead_dropdown').removeClass('show').html('');
        }
    });
}

// ============ SELECT EXISTING DEPARTMENT ============
$(document).on('click', '.typeahead-item', function() {
    const selectedDepartmentId = $(this).data('department-id');
    const selectedDepartmentName = $(this).data('department-name');
    
    $('#Department').val(selectedDepartmentName);
    
    if ($('#fkdepartment_id').length === 0) {
        $('#Department').after('<input type="hidden" name="fkdepartment_id" id="fkdepartment_id">');
    }
    $('#fkdepartment_id').val(selectedDepartmentId);
    
    $('#department_typeahead_dropdown').removeClass('show').html('');
    
    // Move to Date field
    setTimeout(() => {
        $('#Date').focus().select();
    }, 100);
});

// ============ ADD NEW DEPARTMENT - NO CONFIRMATION ============
$(document).on('click', '.typeahead-add-new', function() {
    const newDepartmentName = $(this).data('new-department');
    
    // Directly add department without confirmation
    addNewDepartment(newDepartmentName);
});

// ============ AJAX CALL TO ADD NEW DEPARTMENT ============
function addNewDepartment(departmentName) {
    Swal.fire({
        title: 'Adding Department...',
        text: 'Please wait',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    $.ajax({
        url: '<?= base_url() ?>admin/Outward/addNewDepartment',
        type: 'POST',
        data: { department_name: departmentName },
        dataType: 'json',
        success: function(response) {
            Swal.close();
            
            console.log('Response:', response); // Debug
            
            if (response.success) {
                // Set the new department in the field
                $('#Department').val(response.department_name);
                
                if ($('#fkdepartment_id').length === 0) {
                    $('#Department').after('<input type="hidden" name="fkdepartment_id" id="fkdepartment_id">');
                }
                $('#fkdepartment_id').val(response.department_id);
                
                $('#department_typeahead_dropdown').removeClass('show').html('');
                
                // Move to Date field directly without success message
                setTimeout(() => {
                    $('#Date').focus().select();
                }, 100);
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: response.message || 'Failed to add department',
                    customClass: {
                        popup: 'custom-swal-popup',
                        icon: 'custom-swal-icon',
                        title: 'custom-swal-title',
                        htmlContainer: 'custom-swal-text'
                    }
                });
            }
        },
        error: function(xhr, status, error) {
            Swal.close();
            
            console.error('XHR Status:', xhr.status);
            console.error('Response Text:', xhr.responseText);
            console.error('Error:', error);
            
            let errorMessage = 'Failed to add new department. Please try again.';
            
            try {
                let errorResponse = JSON.parse(xhr.responseText);
                if (errorResponse.message) {
                    errorMessage = errorResponse.message;
                }
            } catch(e) {
                if (xhr.responseText) {
                    console.error('Server returned HTML instead of JSON:', xhr.responseText);
                    errorMessage = 'Server error occurred. Check console for details.';
                }
            }
            
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: errorMessage,
                customClass: {
                    popup: 'custom-swal-popup',
                    icon: 'custom-swal-icon',
                    title: 'custom-swal-title',
                    htmlContainer: 'custom-swal-text'
                }
            });
        }
    });
}
    // ============ KEYBOARD NAVIGATION ============
    $("#Department").on('keydown', function(e) {
        var items = $('#department_typeahead_dropdown .typeahead-item');
        
        if (e.keyCode === 40) { // Down arrow
            e.preventDefault();
            currentFocus++;
            addActive(items);
        } else if (e.keyCode === 38) { // Up arrow
            e.preventDefault();
            currentFocus--;
            addActive(items);
        } else if (e.keyCode === 13) { // Enter key
            e.preventDefault();
            if (currentFocus > -1 && items.length > 0) {
                items[currentFocus].click();
            } else {
                let department = $(this).val().trim();
                
                if (!department || department === '') {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Department Required',
                        text: 'Please enter Department!',
                        timer: 2000,
                        customClass: {
                            popup: 'custom-swal-popup',
                            icon: 'custom-swal-icon',
                            title: 'custom-swal-title',
                            htmlContainer: 'custom-swal-text'
                        }
                    });
                    return;
                }
                
                // If dropdown is showing "Add New", trigger it
                if ($('.typeahead-add-new').length > 0) {
                    $('.typeahead-add-new').click();
                } else {
                    $('#department_typeahead_dropdown').removeClass('show').html('');
                    setTimeout(() => {
                        $('#Date').focus().select();
                    }, 100);
                }
            }
        } else if (e.keyCode === 27) { // Escape
            $('#department_typeahead_dropdown').removeClass('show').html('');
            currentFocus = -1;
        }
    });

    // Helper functions
    function addActive(items) {
        if (!items || items.length === 0) return false;
        removeActive(items);
        if (currentFocus >= items.length) currentFocus = 0;
        if (currentFocus < 0) currentFocus = (items.length - 1);
        $(items[currentFocus]).addClass('active');
    }

    function removeActive(items) {
        $(items).removeClass('active');
    }

    // Hide dropdown when clicking outside
    $(document).on('click', function(e) {
        if (!$(e.target).closest('#Department').length &&
            !$(e.target).closest('#department_typeahead_dropdown').length) {
            $('#department_typeahead_dropdown').removeClass('show').html('');
        }
    });

    // Clear dropdown when field is cleared
    $("#Department").on('input', function() {
        if ($(this).val().trim() === '') {
            $('#department_typeahead_dropdown').removeClass('show').html('');
            $('#fkdepartment_id').val('');
        }
    });


    

   // 1. DATE → APPLICANTS TYPE (with search)
    $('#Date').on('keydown', function(e) {
        if (e.key === 'Enter' || e.keyCode === 13) {
            e.preventDefault();
            $('#fkmainuser_id').select2('open');
            setTimeout(function() {
                let searchField = $('.select2-container--open .select2-search__field');
                if (searchField.length > 0) {
                    searchField[0].focus();
                }
            }, 150);
        }
    });

    // Open search when dropdown opens
    $('#fkmainuser_id').on('select2:open', function() {
        setTimeout(function() {
            $('.select2-container--open .select2-search__field').focus();
        }, 200);
    });

    // 2. APPLICANTS TYPE → APPLICANT NAME
    $('#fkmainuser_id').on('select2:closing', function(e) {
        if ($('#fkmainuser_id').val()) {
            setTimeout(function() {
                $('#Applicant_name').focus().select();
            }, 100);
        }
    });

    // 3. APPLICANT NAME → APPLICANT ID (on Enter)
    $('#Applicant_name').on('keydown', function(e) {
        if (e.key === 'Enter' || e.keyCode === 13) {
            e.preventDefault();
            $('#Applicant_id').focus().select();
        }
    });

    // 4. APPLICANT ID → ITEM CATEGORY (with search)
    $('#Applicant_id').on('keydown', function(e) {
        if (e.key === 'Enter' || e.keyCode === 13) {
            e.preventDefault();
            $('#fkCategory_ID').select2('open');
            setTimeout(function() {
                $('.select2-container--open .select2-search__field').focus();
            }, 100);
        }
    });

    $('#fkCategory_ID').on('select2:open', function() {
        setTimeout(function() {
            document.querySelector('.select2-container--open .select2-search__field').focus();
        }, 200);
    });

    // Category select hone ke baad Item dropdown
    $('#fkCategory_ID').on('select2:closing', function(e) {
        if ($('#fkCategory_ID').val()) {
            setTimeout(function() {
                $('#fkItem_id').select2('open');
                setTimeout(function() {
                    $('.select2-search__field').focus();
                }, 100);
            }, 100);
        }
    });

    $('#fkItem_id').on('select2:open', function() {
        setTimeout(function() {
            document.querySelector('.select2-container--open .select2-search__field').focus();
        }, 200);
    });

    // ============ NEW: STOCK QUANTITY DISPLAY ON ITEM SELECTION ============
    $('#fkItem_id').on('change', function() {
        let selectedItem = $(this).val();
        
        if (selectedItem) {
            // Get unit first
            $.ajax({
                url: '<?= base_url() ?>admin/Outward/getItemUnit',
                type: 'POST',
                data: { item_id: selectedItem },
                dataType: 'json',
                success: function(response) {
                    if (response.success && response.unit_id) {
                        $('#fkUnit_ID').val(response.unit_id).prop('readonly', true).trigger('change');
                    } else {
                        $('#fkUnit_ID').val('').prop('readonly', false).trigger('change');
                    }
                }
            });
            
            // ============ GET STOCK QUANTITY ============
            $.ajax({
                url: '<?= base_url() ?>admin/Outward/getItemStockQty',
                type: 'POST',
                data: { item_id: selectedItem },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        // Display stock quantity with color coding
                        let stockQty = parseFloat(response.stock_qty);
                        let displayText = stockQty.toFixed(2);
                        
                        // Color coding based on stock level
                        let color = '#28a745'; // Green for good stock
                        let bgColor = '#d4edda'; // Light green background
                        
                        if (stockQty <= 0) {
                            color = '#dc3545'; // Red for out of stock
                            bgColor = '#f8d7da'; // Light red background
                            displayText = '0.00 (Out of Stock)';
                        } else if (stockQty <= 10) {
                            color = '#ffc107'; // Yellow for low stock
                            bgColor = '#fff3cd'; // Light yellow background
                            displayText = stockQty.toFixed(2) + ' (Low Stock)';
                        }
                        
                        $('#stock_qty_display').val(displayText)
                            .css({
                                'color': color,
                                'font-weight': 'bold',
                                'background-color': bgColor
                            });
                    } else {
                        $('#stock_qty_display').val('N/A')
                            .css({
                                'color': '#6c757d',
                                'background-color': '#f8f9fa'
                            });
                    }
                },
                error: function() {
                    $('#stock_qty_display').val('Error')
                        .css({
                            'color': '#dc3545',
                            'background-color': '#f8d7da'
                        });
                }
            });
            
            // Move to Quantity field
            setTimeout(function() {
                $('#Quantity').focus().select();
            }, 100);
        } else {
            // Clear stock quantity display when no item selected
            $('#stock_qty_display').val('')
                .css({
                    'color': '#28a745',
                    'background-color': '#f8f9fa'
                });
            $('#fkUnit_ID').val('').prop('readonly', true).trigger('change');
        }
    });


  //  $('#fkUnit_ID').on('select2:open', function() {
    //     setTimeout(function() {
    //         document.querySelector('.select2-container--open .select2-search__field').focus();
    //     }, 200);
    // });

    // // Unit select hone ke baad Quantity
    // $('#fkUnit_ID').on('select2:closing', function(e) {
    //     if ($('#fkUnit_ID').val()) {
    //         setTimeout(function() {
    //             $('#Quantity').focus().select();
    //         }, 100);
    //     }
    // });

    // Quantity - Enter key se Rate par
    $('#Quantity').on('keydown', function(e) {
        if (e.key === 'Enter' || e.keyCode === 13) {
            e.preventDefault();
            $('#Rate').focus().select();
        }
        if (e.key === 'ArrowUp') {
            e.preventDefault();
            let val = parseFloat($(this).val()) || 0;
            $(this).val(val + 1);
            calculateTotal();
        }
        if (e.key === 'ArrowDown') {
            e.preventDefault();
            let val = parseFloat($(this).val()) || 0;
            if (val > 0) {
                $(this).val(val - 1);
                calculateTotal();
            }
        }
    });

    // Rate - Enter key se Add to table
    $('#Rate').on('keydown', function(e) {
        if (e.key === 'Enter' || e.keyCode === 13) {
            e.preventDefault();
            addItemToTable();
        }
        if (e.key === 'ArrowUp') {
            e.preventDefault();
            let val = parseFloat($(this).val()) || 0;
            $(this).val(val + 1);
            calculateTotal();
        }
        if (e.key === 'ArrowDown') {
            e.preventDefault();
            let val = parseFloat($(this).val()) || 0;
            if (val > 0) {
                $(this).val(val - 1);
                calculateTotal();
            }
        }
    });

    // ============ AUTO CALCULATION ============
    $('#Quantity, #Rate').on('input', function() {
        calculateTotal();
    });

    function calculateTotal() {
        let quantity = parseFloat($('#Quantity').val()) || 0;
        let rate = parseFloat($('#Rate').val()) || 0;
        let total = quantity * rate;
        $('#Total').val(total.toFixed(2));
    }

    // ============ ADD ITEM TO TABLE ============
    function addItemToTable() {
        // Get values
        let categoryId = $('#fkCategory_ID').val();
        let categoryText = $('#fkCategory_ID option:selected').text();
        let itemId = $('#fkItem_id').val();
        let itemText = $('#fkItem_id option:selected').text();
        let unitId = $('#fkUnit_ID').val();
        let unitText = $('#fkUnit_ID option:selected').text();
        let quantity = $('#Quantity').val();
        let rate = $('#Rate').val();
        let total = $('#Total').val();

        // Validation
        if (!categoryId || categoryId === '' || categoryText === 'Select category') {
            Swal.fire({
                icon: 'warning',
                title: 'Category Missing',
                text: 'Please select Item Category',
                timer: 1500,
                showConfirmButton: false,
                 customClass: {
                                popup: 'custom-swal-popup',
                                icon: 'custom-swal-icon',
                                title: 'custom-swal-title',
                                htmlContainer: 'custom-swal-text'
                            }
            });
            setTimeout(function() {
                $('#fkCategory_ID').select2('open');
                setTimeout(function() {
                    $('.select2-search__field').focus();
                }, 100);
            }, 1600);
            return;
        }

        if (!itemId || itemId === '' || itemText === 'Select Item') {
            Swal.fire({
                icon: 'warning',
                title: 'Item Missing',
                text: 'Please select Item Name',
                timer: 1500,
                showConfirmButton: false,
                 customClass: {
                                popup: 'custom-swal-popup',
                                icon: 'custom-swal-icon',
                                title: 'custom-swal-title',
                                htmlContainer: 'custom-swal-text'
                            }
            });
            setTimeout(function() {
                $('#fkItem_id').select2('open');
                setTimeout(function() {
                    $('.select2-search__field').focus();
                }, 100);
            }, 1600);
            return;
        }

        if (!unitId || unitId === '' || unitText === 'Select Unit') {
            Swal.fire({
                icon: 'warning',
                title: 'Unit Missing',
                text: 'Please select Unit',
                timer: 1500,
                showConfirmButton: false,
                 customClass: {
                                popup: 'custom-swal-popup',
                                icon: 'custom-swal-icon',
                                title: 'custom-swal-title',
                                htmlContainer: 'custom-swal-text'
                            }
            });
            setTimeout(function() {
                $('#fkUnit_ID').select2('open');
                setTimeout(function() {
                    $('.select2-search__field').focus();
                }, 100);
            }, 1600);
            return;
        }

        if (!quantity || quantity <= 0) {
            Swal.fire({
                icon: 'warning',
                title: 'Quantity Missing',
                text: 'Please enter valid Quantity',
                timer: 1500,
                showConfirmButton: false,
                 customClass: {
                                popup: 'custom-swal-popup',
                                icon: 'custom-swal-icon',
                                title: 'custom-swal-title',
                                htmlContainer: 'custom-swal-text'
                            }
            });
            setTimeout(function() {
                $('#Quantity').focus().select();
            }, 1600);
            return;
        }

        if (!rate || rate <= 0) {
            Swal.fire({
                icon: 'warning',
                title: 'Rate Missing',
                text: 'Please enter valid Rate',
                timer: 1500,
                showConfirmButton: false,
                 customClass: {
                                popup: 'custom-swal-popup',
                                icon: 'custom-swal-icon',
                                title: 'custom-swal-title',
                                htmlContainer: 'custom-swal-text'
                            }
            });
            setTimeout(function() {
                $('#Rate').focus().select();
            }, 1600);
            return;
        }

        // Create entry object
        let entry = {
            OutwardId: '', // Empty for new entries
            categoryId: categoryId,
            categoryText: categoryText,
            itemId: itemId,
            itemText: itemText,
            unitId: unitId,
            unitText: unitText,
            quantity: quantity,
            rate: rate,
            total: total
        };

        // Add to array
        tableEntries.push(entry);

        // Success message
        Swal.fire({
            position: 'center',
            icon: 'success',
            title: 'Added!',
            text: 'Item added to table',
            timer: 800,
            showConfirmButton: false,
             customClass: {
                                popup: 'custom-swal-popup',
                                icon: 'custom-swal-icon',
                                title: 'custom-swal-title',
                                htmlContainer: 'custom-swal-text'
                            }
        });

        // Update table display
        updateTableDisplay();

        // Clear item fields
        clearItemFields();

        // FORCE wapas Category SEARCH me jaaye
        setTimeout(function() {
            $('#fkCategory_ID').select2('open');
            setTimeout(function() {
                $('.select2-search__field').focus();
            }, 100);
        }, 900);
    }

    // ============ UPDATE TABLE DISPLAY ============
    function updateTableDisplay() {
        let tbody = $('#displayTableBody');
        tbody.empty();

        if (tableEntries.length === 0) {
            tbody.html(`
                <tr class="text-center">
                    <td colspan="8" class="text-muted py-4">
                        <i class="fa-solid fa-inbox fa-2x mb-2"></i><br>
                        <i>No entries saved yet.</i>
                    </td>
                </tr>
            `);
            return;
        }

        tableEntries.forEach(function(entry, index) {
            let row = `
                <tr>
                    <td class="text-center">${index + 1}</td>
                    <td>${entry.categoryText}
                        <input type="hidden" name="fkCategory_ID[]" value="${entry.categoryId}">
                        <input type="hidden" name="Outward_id[]" value="${entry.OutwardId || ''}">
                    </td>
                    <td>${entry.itemText}
                        <input type="hidden" name="fkItem_id[]" value="${entry.itemId}">
                    </td>
                    <td class="text-center">${entry.unitText}
                        <input type="hidden" name="fkUnit_ID[]" value="${entry.unitId}">
                    </td>
                    <td class="text-right">${entry.quantity}
                        <input type="hidden" name="Quantity[]" value="${entry.quantity}">
                    </td>
                    <td class="text-right">${entry.rate}
                        <input type="hidden" name="Rate[]" value="${entry.rate}">
                    </td>
                    <td class="text-right"><strong>${entry.total}</strong>
                        <input type="hidden" name="Total[]" value="${entry.total}">
                    </td>
                    <td class="text-center">
                        <button type="button" class="btn btn-sm btn-danger removeTableRow" data-index="${index}" tabindex="-1">
                            <i class="fa-solid fa-trash"></i>
                        </button>
                    </td>
                </tr>
            `;
            tbody.append(row);
        });

        // Add total row
        let grandTotal = tableEntries.reduce((sum, entry) => sum + parseFloat(entry.total), 0);
        tbody.append(`
            <tr class="total-row">
                <td colspan="6" class="text-right"><strong>Grand Total:</strong></td>
                <td class="text-right total-amount"><strong>${grandTotal.toFixed(2)}</strong></td>
                <td></td>
            </tr>
        `);
    }

    // ============ CLEAR ITEM FIELDS ============
    function clearItemFields() {
        $('#fkCategory_ID').val('').trigger('change');
        $('#fkItem_id').val('').trigger('change');
        $('#fkUnit_ID').val('').trigger('change');
        $('#Quantity').val('');
        $('#Rate').val('');
        $('#Total').val('');
    }

    // ============ REMOVE ROW FROM TABLE ============
    $(document).on('click', '.removeTableRow', function() {
        let index = $(this).data('index');
        
        Swal.fire({
            title: 'Remove Item?',
            text: "Do you want to remove this item from the table?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, Remove!',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                tableEntries.splice(index, 1);
                updateTableDisplay();
                Swal.fire({
                    icon: 'success',
                    title: 'Removed!',
                    text: 'Item has been removed.',
                    timer: 1500,
                    showConfirmButton: false,
                     customClass: {
                                popup: 'custom-swal-popup',
                                icon: 'custom-swal-icon',
                                title: 'custom-swal-title',
                                htmlContainer: 'custom-swal-text'
                            }
                });
            }
        });
    });

    // ============ EDIT ROW FROM TABLE ============
    $(document).on('click', '.editTableRow', function() {
        let index = $(this).data('index');
        let entry = tableEntries[index];
        
        // Populate fields with existing data
        $('#fkCategory_ID').val(entry.categoryId).trigger('change');
        $('#fkItem_id').val(entry.itemId).trigger('change');
        $('#fkUnit_ID').val(entry.unitId).trigger('change');
        $('#Quantity').val(entry.quantity);
        $('#Rate').val(entry.rate);
        $('#Total').val(entry.total);
        
        // Remove from array (will be re-added when user presses Enter on Rate)
        tableEntries.splice(index, 1);
        updateTableDisplay();
        
        // Focus on Category
        $('#fkCategory_ID').select2('open');
        
        Swal.fire({
            icon: 'info',
            title: 'Edit Mode',
            text: 'Modify the item and press Enter on Rate field to update',
            timer: 2000,
            showConfirmButton: false,
             customClass: {
                                popup: 'custom-swal-popup',
                                icon: 'custom-swal-icon',
                                title: 'custom-swal-title',
                                htmlContainer: 'custom-swal-text'
                            }
        });
    });

   

    // ============ FORM SUBMIT ============
    // ============ FORM SUBMIT ============
$('#submit').on('click', function(e) {
    e.preventDefault();

    // Validation
    if (!$('#Department').val() || !$('#fkdepartment_id').val()) {
        Swal.fire({
            icon: 'warning',
            title: 'Department Missing',
            text: 'Please select Department',
            customClass: {
                popup: 'custom-swal-popup',
                icon: 'custom-swal-icon',
                title: 'custom-swal-title',
                htmlContainer: 'custom-swal-text'
            }
        });
        $('#Department').focus();
        return;
    }

    if (!$('#Date').val()) {
        Swal.fire({
            icon: 'warning',
            title: 'Date Missing',
            text: 'Please select Outward Date',
            customClass: {
                popup: 'custom-swal-popup',
                icon: 'custom-swal-icon',
                title: 'custom-swal-title',
                htmlContainer: 'custom-swal-text'
            }
        });
        $('#Date').focus();
        return;
    }

    if (!$('#fkmainuser_id').val()) {
        Swal.fire({
            icon: 'warning',
            title: 'Applicant Type Missing',
            text: 'Please select Applicant Type',
            customClass: {
                popup: 'custom-swal-popup',
                icon: 'custom-swal-icon',
                title: 'custom-swal-title',
                htmlContainer: 'custom-swal-text'
            }
        });
        $('#fkmainuser_id').select2('open');
        return;
    }

    if (tableEntries.length === 0) {
        Swal.fire({
            icon: 'warning',
            title: 'No Items',
            text: 'Please add at least one item to the table',
            customClass: {
                popup: 'custom-swal-popup',
                icon: 'custom-swal-icon',
                title: 'custom-swal-title',
                htmlContainer: 'custom-swal-text'
            }
        });
        $('#fkCategory_ID').select2('open');
        return;
    }

    // Show loading
    Swal.fire({
        title: 'Saving...',
        text: 'Please wait',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    // Determine if it's insert or update
    let mainId = $('#Outward_main_id').val();
    let actionUrl = mainId ? 
        '<?= base_url() ?>admin/Outward/updateOutward' : 
        '<?= base_url() ?>admin/Outward/insertOutward';

    // Submit form
    let formData = $('#Form').serialize();

    $.ajax({
        url: actionUrl,
        type: 'POST',
        data: formData,
        dataType: 'json',
        success: function(response) {
            Swal.close();
            if (response.success) {
                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: '<strong>Success!</strong>',
                    html: response.message,
                    showConfirmButton: false,
                    timer: 2000,
                    customClass: {
                        popup: 'custom-swal-popup',
                        icon: 'custom-swal-icon',
                        title: 'custom-swal-title',
                        htmlContainer: 'custom-swal-text'
                    }
                }).then(function() {
                    window.location.href = '<?= base_url() ?>admin/Outward/index';
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: response.message,
                    customClass: {
                        popup: 'custom-swal-popup',
                        icon: 'custom-swal-icon',
                        title: 'custom-swal-title',
                        htmlContainer: 'custom-swal-text'
                    }
                });
            }
        },
        error: function(xhr, status, error) {
            Swal.close();
            
            console.log('XHR Status:', xhr.status);
            console.log('Response Text:', xhr.responseText);
            console.log('Error:', error);
            
            // Try to parse error response
            let errorMessage = 'Failed to save Outward. Please try again.';
            
            try {
                let errorResponse = JSON.parse(xhr.responseText);
                if (errorResponse.message) {
                    errorMessage = errorResponse.message;
                }
            } catch(e) {
                // If response is not JSON, show generic error
                if (xhr.responseText) {
                    // Show HTML error in console for debugging
                    console.error('Server returned HTML instead of JSON:', xhr.responseText);
                    errorMessage = 'Server error occurred. Check console for details.';
                }
            }
            
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: errorMessage,
                customClass: {
                    popup: 'custom-swal-popup',
                    icon: 'custom-swal-icon',
                    title: 'custom-swal-title',
                    htmlContainer: 'custom-swal-text'
                }
            });
        }
    });
});

    // ============ CTRL+S SAVE FUNCTIONALITY ============
// Ye script apne existing script ke neeche add karo

$(document).ready(function() {
    
    // Ctrl+S keypress handler
    $(document).on('keydown', function(e) {
        // Check if Ctrl+S or Cmd+S (for Mac)
        if ((e.ctrlKey || e.metaKey) && e.key === 's') {
            e.preventDefault(); // Browser ka default Save dialog band karo
            
            // Submit button ko trigger karo
            $('#submit').trigger('click');
            
            // Optional: User ko feedback do
            console.log('Ctrl+S pressed - Saving form...');
        }
    });
    
    // Optional: Save ka shortcut info show karo (agar chahiye to)
    // $('#submit').attr('title', 'Click or press Ctrl+S to save');
    
});

});

</script>