<?php
// CSS
?>
<style>
    #groupPreviewContainer {
        background-color: #f0f8ff;
        padding: 15px;
        border-radius: 8px;
        border: 2px solid #17a2b8;
        margin-bottom: 20px;
    }

    #groupPreviewTable {
        font-size: 13px;
    }

    #groupPreviewTable th {
        background-color: #17a2b8 !important;
        color: white !important;
        font-weight: bold;
        text-align: center;
    }

    #groupPreviewTable td {
        text-align: center;
        vertical-align: middle;
    }

    .po-input:focus {
        border-color: #17a2b8;
        box-shadow: 0 0 0 0.2rem rgba(23, 162, 184, 0.25);
    }
</style>

<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1"> CO PO Mapping Form </div>
                    </div>
                    <div class="card-body">
                        <form role="form" id="Form" action="" method="post">
                            <div class="row gutters">

                                <input type="hidden" id="Item_id" name="Item_id" class="hiddenId"
                                       style="width:40px !important; height:40px;"
                                       value="<?php if(!empty($data)) echo $data[0]->Item_id; ?>">

                                <input class="form-control" id="fk_submenuId" name="fk_submenuId" type="hidden"
                                       value="<?= isset($subId) ? $subId : '' ?>">

                                <!-- Branch Selection -->
                                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <div class="field-wrapper">
                                        <select name="fkbranch_id" id="fkbranch_id" class="select-single js-states form-control">
                                            <option value="">Select branch</option>
                                            <?php foreach($branchdata as $branch): ?>
                                                <option value="<?= $branch->branch_id ?>">
                                                    <?= $branch->branch_name ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Department <span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <!-- Academic Year Selection -->
                                <div class="col-md-3">
                                    <div class="field-wrapper">
                                        <select name="finicial_Year" id="finicial_Year" class="select-single js-states form-control">
                                            <?php
                                            $selectedYear = '';
                                            if (!empty($activeYear)) {
                                                $selectedYear = $activeYear->finiYear_id;
                                            }
                                            ?>
                                            <option value="">Select year</option>
                                            <?php foreach($yeardata as $year): ?>
                                                <option value="<?= $year->finiYear_id ?>"
                                                    <?= ($year->finiYear_id == $selectedYear) ? 'selected' : '' ?>>
                                                    <?= $year->fini_Label ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Academic Year <span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <!-- Table -->
                                <div class="col-md-12 mt-3">
                                    <div id="groupPreviewContainer">
                                        <h4 class="text-primary">📋 Articulate CO-PO Mapping</h4>
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-sm" id="groupPreviewTable">
                                                <thead style="background-color: #17a2b8; color: white;">
                                                    <tr>
                                                        <th>Sr.No</th>
                                                        <th>Course Code</th>
                                                        <th>Course Title</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="groupPreviewBody">
                                                    <tr>
                                                        <td colspan="3" class="text-center">
                                                            Please select Department and Academic Year
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <!-- Buttons -->
                                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 mt-3">
                                    <button type="button" class="btn mb-md-0 mb-2 btn-quarternary" id="submit" name="submit">
                                        <i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save
                                    </button>
                                    <a class="btn mb-md-0 mb-2 btn-quarternary1" href="<?=base_url()?>admin/PO_Mapping/index" type="button">
                                        <i class="fa-solid fa-list"></i>&nbsp;&nbsp;List
                                    </a>
                                    <button class="btn mb-md-0 mb-2 btn-quarternaryhome" type="button"
                                            onclick="window.location.href='<?= base_url() ?>admin/PO/Dashboard'">
                                        <i class="fa-solid fa-home"></i>&nbsp;&nbsp;Home
                                    </button>
                                </div>

                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script type="text/javascript">
    var base_url = '<?php echo base_url(); ?>';
</script>

<script>
$(document).ready(function () {

    // Select2 init
    $('.select-single').select2();

    // =====================================================
    // Branch ya Year change hone pe courses + PO labels load
    // =====================================================
    $('#fkbranch_id, #finicial_Year').on('change', function () {
        loadCourses();
    });

    function loadCourses() {
        var branchId = $('#fkbranch_id').val();
        var yearId   = $('#finicial_Year').val();

        if (branchId && yearId) {
            $.ajax({
                url:        base_url + 'admin/PO_Mapping/getCourses',
                type:       'POST',
                data:       { branchId: branchId, yearId: yearId },
                dataType:   'json',
                beforeSend: function () {
                    $('#groupPreviewBody').html(
                        '<tr><td colspan="20" class="text-center"><i class="fa fa-spinner fa-spin"></i> Loading...</td></tr>'
                    );
                },
                success: function (response) {
                    if (response.status === 'success') {
                        // 1. Table headers update karo PO labels se
                        updateTableHeaders(response.poLabels);

                        // 2. Courses display karo
                        displayCourses(response.data, response.poLabels);

                        // 3. Agar edit mode hai to existing values load karo
                        loadExistingMappings(branchId, yearId);
                    } else {
                        // Reset headers
                        $('#groupPreviewTable thead').html(
                            '<tr><th>Sr.No</th><th>Course Code</th><th>Course Title</th></tr>'
                        );
                        $('#groupPreviewBody').html(
                            '<tr><td colspan="3" class="text-center text-danger">' + response.message + '</td></tr>'
                        );
                    }
                },
                error: function (xhr, status, error) {
                    console.error('Error:', error);
                    Swal.fire({ icon: 'error', title: 'Error', text: 'Failed to load courses.' });
                    $('#groupPreviewBody').html(
                        '<tr><td colspan="20" class="text-center text-danger">Error loading data</td></tr>'
                    );
                }
            });
        } else {
            // Dono select nahi hue — default headers dikao
            $('#groupPreviewTable thead').html(
                '<tr><th>Sr.No</th><th>Course Code</th><th>Course Title</th></tr>'
            );
            $('#groupPreviewBody').html(
                '<tr><td colspan="3" class="text-center">Please select both Department and Academic Year</td></tr>'
            );
        }
    }

    // =====================================================
    // Table headers update — PO labels dynamically add
    // e.g. PO1, PO2, ... PO12, PSO1, PSO2, PSO3
    // =====================================================
    function updateTableHeaders(poLabels) {
        var headerHtml = '<tr>';
        headerHtml += '<th>Sr.No</th>';
        headerHtml += '<th>Course Code</th>';
        headerHtml += '<th>Course Title</th>';

        if (poLabels && poLabels.length > 0) {
            $.each(poLabels, function (index, label) {
                headerHtml += '<th>' + label.Po_lable_name + '</th>';
            });
        }

        headerHtml += '</tr>';
        $('#groupPreviewTable thead').html(headerHtml);
    }

    // =====================================================
    // Courses display with PO input fields
    // =====================================================
    function displayCourses(courses, poLabels) {
        if (courses && courses.length > 0) {
            var html = '';
            $.each(courses, function (index, course) {
                html += '<tr>';
                html += '<td>' + (index + 1) + '</td>';
                html += '<td>' + course.Course_code + '</td>';
                html += '<td style="text-align:left; padding-left:10px;">' + course.Course_title + '</td>';

                // Har PO label ke liye ek input field
                if (poLabels && poLabels.length > 0) {
                    $.each(poLabels, function (i, label) {
                        html += '<td>';
                        html += '<input type="number" step="0.01" class="form-control form-control-sm po-input" ';
                        html += 'name="po_' + label.PO_lable_id + '[]" ';
                        html += 'data-course-id="' + course.Course_id + '" ';
                        html += 'data-po-label-id="' + label.PO_lable_id + '" ';
                        html += 'style="width: 70px; text-align: center;">';
                        html += '</td>';
                    });
                }

                html += '</tr>';
            });
            $('#groupPreviewBody').html(html);
        } else {
            // var colspan = (poLabels && poLabels.length > 0) ? poLabels.length + 3 : 3;
            $('#groupPreviewBody').html(
                '<tr><td colspan="' + colspan + '" class="text-center">No courses available for selected Department and Year</td></tr>'
            );
        }
    }

    // =====================================================
    // Existing mappings load (edit mode — purane values fill)
    // =====================================================
    function loadExistingMappings(branchId, yearId) {
    $.ajax({
        url:      base_url + 'admin/PO_Mapping/getExistingMappings',
        type:     'POST',
        data:     { branchId: branchId, yearId: yearId },
        dataType: 'json',
        success: function (response) {
            if (response.status === 'success' && response.data.length > 0) {
                $.each(response.data, function (index, mapping) {
                    $('input[data-course-id="' + mapping.fkCourse_id + '"]'
                      + '[data-po-label-id="' + mapping.fkPO_lable_id + '"]')
                      .val(mapping.mapping_value);
                });
            }
        }
    });
}

    // =====================================================
    // Save button click
    // =====================================================
    $('#submit').on('click', function (e) {
        e.preventDefault();

        var branchId = $('#fkbranch_id').val();
        var yearId   = $('#finicial_Year').val();

        // Validation
        if (!branchId) {
            Swal.fire({ icon: 'warning', title: 'Validation Error', text: 'Please select Department' });
            return false;
        }
        if (!yearId) {
            Swal.fire({ icon: 'warning', title: 'Validation Error', text: 'Please select Academic Year' });
            return false;
        }

        // Mapping data collect
        var mappingData = [];
        $('#groupPreviewBody tr').each(function () {
            var row     = $(this);
            var courseId = row.find('.po-input').first().data('course-id');

            if (courseId) {
                var mappings = [];
                row.find('.po-input').each(function () {
                    var value      = $(this).val();
                    var poLabelId  = $(this).data('po-label-id');

                    if (value && value !== '') {
                        mappings.push({
                            poLabelId: poLabelId,
                            value:     parseFloat(value)
                        });
                    }
                });

                if (mappings.length > 0) {
                    mappingData.push({
                        courseId:  courseId,
                        mappings: mappings
                    });
                }
            }
        });

        if (mappingData.length === 0) {
            Swal.fire({ icon: 'warning', title: 'No Data', text: 'Please enter at least one PO mapping value' });
            return false;
        }

        // Confirm + Save
        Swal.fire({
            title:            'Confirm Save',
            text:             'Do you want to save CO-PO Mapping?',
            icon:             'question',
            showCancelButton: true,
            confirmButtonText:'Yes, Save it!',
            cancelButtonText: 'Cancel'
        }).then(function (result) {
            if (result.isConfirmed) {
                saveMappingData(branchId, yearId, mappingData);
            }
        });
    });

    // =====================================================
    // Save AJAX call
    // =====================================================
    function saveMappingData(branchId, yearId, mappingData) {
        $.ajax({
            // url:      base_url + 'admin/PO_Mapping/save',
            // saveMappingData function mein yeh badlo:
url: base_url + 'admin/PO_Mapping/insertPO_Mapping',
            type:     'POST',
            data:     {
                branchId:     branchId,
                yearId:       yearId,
                mappingData:  JSON.stringify(mappingData),
                fk_submenuId: $('#fk_submenuId').val()
            },
            dataType:   'json',
            beforeSend: function () {
                $('#submit').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');
            },
            success: function (response) {
                $('#submit').prop('disabled', false).html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');

                if (response.status === 'success') {
                        Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: '<strong>Success!</strong>',
                        html: 'CO-PO Mapping saved Successfully!',
                        showConfirmButton: false,
                        timer: 2000,
                        customClass: {
                            popup: 'custom-swal-popup',
                            icon: 'custom-swal-icon',
                            title: 'custom-swal-title',
                            htmlContainer: 'custom-swal-text'
                        }
                    })
                    .then(() => { location.reload();
                    });
                } else {
                    Swal.fire({ icon: 'error', title: 'Error', text: response.message || 'Failed to save data' });
                }
            },
            error: function (xhr, status, error) {
                $('#submit').prop('disabled', false).html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
                console.error('Error:', error);
                Swal.fire({ icon: 'error', title: 'Error', text: 'Failed to save data. Please try again.' });
            }
        });
    }

});
</script>