<style>
   
</style>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1">Patent Report</div>
                    </div>
                    <div class="card-body">

                        <form role="form" id="Form">
                            <div class="row gutters">
                               
                                <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                    <div class="field-wrapper">
                                        <select class="select-single js-states" id="fkbranch_id" name="fkbranch_id" multiple="multiple" 
                                            value="<?php if(!empty($data)) echo $data[0]->fk_branch; ?>">
                                            <option value="">Select Branch</option>
                                            <?php 
                                            foreach($branchdata as $rw=>$value){
                                            $selected = "";
                                            if (!empty($data[0]->fk_branch)) {
                                                if ($value->branch_id == $data[0]->fk_branch) {
                                                    $selected = "selected='selected'";
                                                 } 
                                                }
                                                echo '<option value="'.$value->branch_id.'"'.$selected.' >'.$value->branch_name.'</option>';
                                            }
                                            ?>
                                        </select>
                                        <div class="field-placeholder">Branch</div>
                                    </div>
                                </div>
                                   
                                <div class="col-md-3">
                                    <div class="field-wrapper">
                                       

                                        <select class="select-single js-states" id="year_dropdown" name="year" multiple="multiple" 
                                            value="<?php if(!empty($data)) echo $data[0]->finicial_Year; ?>">
                                            <option value="">>Select Financial Year</option>
                                            <?php 
                                            foreach($yeardata as $rw=>$value){
                                            $selected = "";
                                            if (!empty($data[0]->finicial_Year)) {
                                                if ($value->finiYear_id == $data[0]->finicial_Year) {
                                                    $selected = "selected='selected'";
                                                 } 
                                                }
                                                echo '<option value="'.$value->finiYear_id.'"'.$selected.' >'.$value->fini_Label.'</option>';
                                            }
                                            ?>
                                        </select>
                                        <div class="field-placeholder">Select Year</div>
                                    </div>
                                </div>

                                <div class="col-md-3 mt-2">
                                    <button class="btn btn-success btn-sm m-1" type="button" id="btnShow" style="padding: 8px 20px;font-size: 13px; font-weight:600;">
                                        <i class="fas fa-search"></i> Show Data
                                    </button>
                                </div>

                                <div class="row">
                                    <div class="col-md-12 text-right">
                                        <button class="btn btn-danger btn-sm rounded-3" type="button" onclick="printTable()">
                                            <i class="fas fa-print bg-white p-1 rounded-circle text-danger shadow-lg" style="box-shadow: 4px 6px 12px rgba(0, 0, 0, 0.5) !important;"></i> Print
                                        </button>
                                        <button type="button" class="btn btn-success btn-sm rounded-3" onclick="exportToExcel()">
                                            <i class="fas fa-file-excel bg-white p-1 rounded-circle text-success shadow-lg" style="box-shadow: 4px 6px 12px rgba(0, 0, 0, 0.5) !important;"></i> Excel
                                        </button>
                                        <button type="button" class="btn btn-dark btn-sm rounded-3" onclick="window.location.href='<?= base_url() ?>admin/Patent/Dashboard'">
                                            <i class="fa-solid fa-home bg-white p-1 rounded-circle text-dark shadow-lg"></i> Home
                                        </button>
                                    </div>
                                </div>
                            </div>

                            <!-- Year-wise Summary Table - HORIZONTAL FORMAT -->
                            <div class="table-responsive mt-4" id="yearWiseTableContainer">
                                <div class="table-header-card">
                                    <h5 class="table-title">
                                        <i class="fas fa-calendar-alt"></i> Year-wise Patent Summary
                                    </h5>
                                </div>
                                <table id="yearTable" class="table custom-table modern-table horizontal-year-table">
                                    <tbody>
                                        <tr id="yearHeaderRow">
                                            <td class="year-label-cell"><strong>Year</strong></td>
                                        </tr>
                                        <tr id="yearDataRow">
                                            <td class="year-label-cell"><strong>Number</strong></td>
                                        </tr>
                                        <tr id="emptyStateRow">
                                            <td colspan="10" class="text-center text-muted py-5">
                                                <i class="fas fa-info-circle fa-2x mb-2"></i>
                                                <p>Please select filters and click "Show Data" to view results</p>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <!-- Detailed Patent Table (Initially Hidden) -->
                            <div class="table-responsive mt-4" id="detailTableContainer" style="display: none;">
                                <div class="table-header-card detailed-header">
                                    <h5 class="table-title">
                                        <i class="fas fa-list-alt"></i> Detailed Patent Information
                                        <span class="selected-year-badge" id="selectedYearBadge"></span>
                                    </h5>
                                    <button type="button" class="btn btn-sm btn-outline-secondary" id="closeDetailTable">
                                        <i class="fas fa-times"></i> Close
                                    </button>
                                </div>
                                <div id="printableTable">
                                    <table id="leavetable" class="table custom-table modern-table">
                                        <thead>
                                            <tr>
                                                <th>Sr.No.</th>
                                                <th>Applicant Type</th>
                                                <th>Name of Applicant</th>
                                                <th>Patent Name</th>
                                                <th>Department</th>
                                                <th>Patent Type</th>
                                                <th>Published</th>
                                                <th>Granted</th>
                                                <th>Application No</th>
                                                <th>Publication Date</th>
                                                <th>Grant Date</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <!-- Detailed data will be loaded here -->
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="<?php echo base_url();?>Assets/js/jquery.min.js"></script>           
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script> 
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
function printTable() {
    const printElement = document.getElementById('printableTable');
 
    $.ajax({
        url: '<?= base_url("admin/Report_Patent/getPrintHeadings") ?>',
        method: 'GET',
        dataType: 'json',
        success: function (heading) {
            const iframe = document.createElement('iframe');
            iframe.style.position = 'fixed';
            iframe.style.right = '0';
            iframe.style.bottom = '0';
            iframe.style.width = '0';
            iframe.style.height = '0';
            iframe.style.border = '0';
            document.body.appendChild(iframe);
 
            const doc = iframe.contentWindow.document;
 
            const baseUrl = '<?= base_url() ?>';
            let logoPath = heading.logo || 'Assets/images/sit_logo.png';
            logoPath = logoPath.replace(/^\/+/, '');
            const fullLogoPath = baseUrl + logoPath;
 
            doc.open();
            doc.write(`
                <html>
                <head>
                    <title>Print</title>
                    <style>
                        body {
                            font-family: sans-serif;
                            margin: 10px 5px;
                            padding: 0;
                        }
                        .header-section {
                            display: flex;
                            align-items: center;
                            justify-content: center;
                            gap: 10px;
                            margin-bottom: 5px;
                        }
                        .logo-container img {
                            max-height: 80px;
                            max-width: 80px;
                            width: auto;
                            height: auto;
                        }
                        .heading-content {
                            text-align: center;
                        }
                        h4, h6, .sub-heading, .autonomous-badge {
                            margin: 0;
                            padding: 0;
                        }
                        h4 {
                            font-size: 20px;
                            font-weight: bold;
                            color: #d32f2f;
                        }
                        h6 {
                            font-size: 14px;
                            font-weight: normal;
                        }
                        .sub-heading, .autonomous-badge {
                            font-size: 14px;
                        }
                        table {
                            width: 100%;
                            border-collapse: collapse;
                            margin-top: 5px;
                            table-layout: fixed;
                        }
                        th, td {
                            border: 1px solid black;
                            padding: 6px 4px;
                            text-align: center;
                            vertical-align: middle;
                            word-wrap: break-word;
                            font-size: 12px;
                        }
                    </style>
                </head>
                <body>
                    <div class="header-section">
                        <div class="logo-container">
                            <img src="${fullLogoPath}" alt="Logo"
                                 onerror="this.style.display='none'; this.parentElement.innerHTML='<div style=\\'color:red; font-size:12px;\\'>Logo Not Found</div>';">
                        </div>
                        <div class="heading-content">
                            <h6>${heading.subHead1 || ''}</h6>
                            <h4>${heading.head || ''}</h4>
                            <div class="autonomous-badge">${heading.subHead2 || ''}</div>
                            <div class="sub-heading">${heading.subHead3 || ''}</div>
                        </div>
                    </div>
                    <br>
                    ${printElement.outerHTML}
                </body>
                </html>
            `);
            doc.close();
 
            iframe.contentWindow.onload = function() {
                setTimeout(function() {
                    iframe.contentWindow.focus();
                    iframe.contentWindow.print();
                }, 500);
            };
 
            setTimeout(() => {
                document.body.removeChild(iframe);
            }, 3000);
        },
        error: function(xhr, status, error) {
            console.error('AJAX Error:', error);
            alert('Error loading print data: ' + error);
        }
    });
}

function exportToExcel() {
    $.ajax({
        url: '<?= base_url("admin/Report_Patent/getPrintHeadings") ?>',
        method: 'GET',
        dataType: 'json',
        success: function (heading) {
            var wb = XLSX.utils.book_new();
            var header = [
                [heading.subHead1 || ''],
                [heading.head || ''],
                [heading.subHead2 || ''],
                [heading.subHead3 || ''],
                ['']
            ];
            
            var table = document.getElementById('printableTable');
            var wsTable = XLSX.utils.table_to_sheet(table);
            var tableData = XLSX.utils.sheet_to_json(wsTable, { header: 1 });
            var fullData = header.concat(tableData);
            
            var ws = XLSX.utils.aoa_to_sheet(fullData);
            XLSX.utils.book_append_sheet(wb, ws, 'Patent Data');
            XLSX.writeFile(wb, 'Patent Data Report.xlsx');
        }
    });
}
</script>

<script>
$(document).ready(function () {
    var currentFilters = {};

    // Show Data button click
    $("#btnShow").click(function () {
        // Get year dropdown values
        var yearValues = $("#year_dropdown").val();
        
        // Convert to proper format
        var yearFilter = null;
        if (yearValues && yearValues.length > 0) {
            // Remove "0" (Select Financial Year option) if present
            yearFilter = yearValues.filter(function(val) {
                return val != "0" && val != "";
            });
            
            // If no valid years selected, set to null
            if (yearFilter.length === 0) {
                yearFilter = null;
            }
        }
        
        // Get branch values
        var branchValues = $("#fkbranch_id").val();
        var branchFilter = null;
        if (branchValues && branchValues.length > 0) {
            branchFilter = branchValues.filter(function(val) {
                return val != "" && val != "0";
            });
            
            if (branchFilter.length === 0) {
                branchFilter = null;
            }
        }

        currentFilters = {
            fk_institu: $("#fk_institu").val() || null,
            fkbranch_id: branchFilter,
            year: yearFilter,
            startdate: $("#startdate").val() || null,
            enddate: $("#enddate").val() || null
        };

        console.log('Filters being sent:', currentFilters);
        console.log('Year filter:', yearFilter);
        console.log('Branch filter:', branchFilter);
        
        // Hide detail table when new search
        $("#detailTableContainer").slideUp();
        loadYearWiseData();
    });

    // Function to load year-wise count - HORIZONTAL FORMAT
    function loadYearWiseData() {
        // Show loading state
        $("#emptyStateRow").show();
        $("#yearHeaderRow td:not(:first)").remove();
        $("#yearDataRow td:not(:first)").remove();

        $.ajax({
            url: "<?= base_url('admin/Report_Patent/getYearWiseCount') ?>",
            type: "POST",
            data: currentFilters,
            dataType: "json",
            success: function (response) {
                console.log('Year-wise response:', response);
                
                if (response.length > 0) {
                    // Hide empty state
                    $("#emptyStateRow").hide();
                    
                    // Clear existing data (except first cell)
                    $("#yearHeaderRow td:not(:first)").remove();
                    $("#yearDataRow td:not(:first)").remove();
                    
                    // Add year columns horizontally
                    $.each(response, function (index, row) {
                        // Add year header cell
                        $("#yearHeaderRow").append(`
                            <td class="year-cell clickable-year" data-year="${row.year}">
                                <strong>${row.year || 'N/A'}</strong>
                            </td>
                        `);
                        
                        // Add count data cell
                        $("#yearDataRow").append(`
                            <td class="count-cell clickable-year" data-year="${row.year}">
                                <span class="badge badge-patent-count">${row.count || 0}</span>
                            </td>
                        `);
                    });
                } else {
                    // Show empty state
                    $("#emptyStateRow").show();
                    $("#emptyStateRow td").html(`
                        <div class="text-center text-danger py-5">
                            <i class="fas fa-exclamation-circle fa-2x mb-2"></i>
                            <p>No data found for the selected filters</p>
                        </div>
                    `);
                }
            },
            error: function (xhr, status, error) {
                console.error('Error:', error);
                console.error('Response:', xhr.responseText);
                Swal.fire("Error", "Something went wrong!", "error");
            }
        });
    }

    // Click on year cell to load detailed data
    $(document).on('click', '.clickable-year', function() {
        var selectedYear = $(this).data('year');
        
        console.log('Clicked year:', selectedYear);
        
        // Highlight selected column
        $('.clickable-year').removeClass('table-active');
        $(`.clickable-year[data-year="${selectedYear}"]`).addClass('table-active');
        
        // Update badge with selected year
        $("#selectedYearBadge").text('Year: ' + selectedYear);
        
        // Show detail table with animation
        $("#detailTableContainer").slideDown(400);
        
        // Scroll to detail table
        $('html, body').animate({
            scrollTop: $("#detailTableContainer").offset().top - 100
        }, 500);
        
        loadDetailedData(selectedYear);
    });

    // Close detail table button
    $("#closeDetailTable").click(function() {
        $("#detailTableContainer").slideUp();
        $('.clickable-year').removeClass('table-active');
    });

    // Function to load detailed patent data
    function loadDetailedData(specificYear) {
        $("#leavetable tbody").html(
            '<tr><td colspan="11" class="text-center py-4"><div class="table-spinner"></div></td></tr>'
        );

        var detailFilters = Object.assign({}, currentFilters);
        detailFilters.specific_year = specificYear;

        console.log('Detail filters:', detailFilters);

        $.ajax({
            url: "<?= base_url('admin/Report_Patent/getPatentData') ?>",
            type: "POST",
            data: detailFilters,
            dataType: "json",
            success: function (response) {
                console.log('Detailed response:', response);
                console.log('Number of records:', response.length);
                
                var tbody = "";
                if (response.length > 0) {
                    $.each(response, function (index, row) {
                        tbody += `
                            <tr class="detail-row">
                                <td class="text-center">${index + 1}</td>
                                <td>${row.applicant_type || '-'}</td>
                                <td>${row.applicant_name || '-'}</td>
                                <td class="patent-name-cell">${row.patent_name || '-'}</td>
                                <td>${row.branch_name || '-'}</td>
                                <td>${row.patenttpye_name || '-'}</td>
                                <td class="text-center">
                                    ${row.Published ? '<span class="badge badge-success"><i class="fas fa-check"></i> Yes</span>' : '<span class="badge badge-secondary">No</span>'}
                                </td>
                                <td class="text-center">
                                    ${row.Granted ? '<span class="badge badge-success"><i class="fas fa-check"></i> Yes</span>' : '<span class="badge badge-secondary">No</span>'}
                                </td>
                                <td>${row.ApplicNo || '-'}</td>
                                <td class="text-center">${formatDate(row.PublicDate) || '-'}</td>
                                <td class="text-center">${formatDate(row.GrantDate) || '-'}</td>
                            </tr>
                        `;
                    });
                } else {
                    tbody = `
                        <tr>
                            <td colspan="11" class="text-center text-danger py-5">
                                <i class="fas fa-folder-open fa-2x mb-2"></i>
                                <p>No patents found for year ${specificYear}</p>
                            </td>
                        </tr>
                    `;
                }
                $("#leavetable tbody").html(tbody);
            },
            error: function (xhr, status, error) {
                console.error('Detail Error:', error);
                console.error('Detail Response:', xhr.responseText);
                Swal.fire("Error", "Failed to load detailed data!", "error");
            }
        });
    }
});

function formatDate(dateString) {
    if (!dateString) return '';
    const date = new Date(dateString);
    const day = String(date.getDate()).padStart(2, '0');
    const month = String(date.getMonth() + 1).padStart(2, '0');
    const year = date.getFullYear();
    return `${day}-${month}-${year}`;
}
</script>

<style>
/* ========================================
   PATENT REPORT - SIMPLE & CLEAN STYLES
   ======================================== */

/* Reset & Base */
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: Arial, sans-serif;
    background: #f5f5f5;
    color: #333;
}

/* Card Styling */
.card {
    background: white;
    border-radius: 8px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    border: none;
}

.card-header {
    background: #2c3e50;
    padding: 20px;
    text-align: center;
}

.card-body {
    padding: 25px;
}

/* Form Fields */
.field-wrapper {
    position: relative;
    margin-bottom: 20px;
}

.field-wrapper select {
    width: 100%;
    padding: 10px 12px;
    border: 1px solid #ddd;
    border-radius: 4px;
    font-size: 14px;
    background: white;
}

.field-wrapper select:focus {
    outline: none;
    border-color: #3498db;
}

.field-placeholder {
    position: absolute;
    top: -10px;
    left: 10px;
    background: white;
    padding: 0 5px;
    font-size: 12px;
    color: #3498db;
    font-weight: 600;
}

/* Buttons */
.btn {
    padding: 8px 16px;
    border-radius: 4px;
    font-size: 13px;
    font-weight: 600;
    border: none;
    cursor: pointer;
}

.btn-success {
    background: #27ae60;
    color: white;
}

.btn-danger {
    background: #e74c3c;
    color: white;
}

.btn-dark {
    background: #34495e;
    color: white;
}

.btn:hover {
    opacity: 0.9;
}

/* Table Container */
.table-responsive {
    background: white;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    margin-top: 20px;
}

/* ========================================
   YEAR-WISE TABLE (BLUE THEME)
   ======================================== */

.table-header-card {
    background: #3498db;
    padding: 15px 20px;
    color: white;
}

.table-title {
    color: white;
    margin: 0;
    font-size: 18px;
    font-weight: 600;
}

.table-title i {
    margin-right: 8px;
}

/* Year Table - Horizontal Layout */
.horizontal-year-table {
    width: 100%;
    border-collapse: collapse;
}

.horizontal-year-table tbody tr td {
    border: 1px solid #ddd;
    padding: 12px 15px;
    text-align: center;
}

.year-label-cell {
    background: #3498db;
    color: white;
    font-weight: 700;
    font-size: 14px;
    width: 100px;
}

.year-cell {
    background: #e3f2fd;
    color: #1565c0;
    font-weight: 600;
    cursor: pointer;
    transition: background 0.3s;
}

.year-cell:hover {
    background: #bbdefb;
}

.count-cell {
    background: #f5f5f5;
    cursor: pointer;
    transition: background 0.3s;
}

.count-cell:hover {
    background: #e3f2fd;
}

.clickable-year.table-active {
    background: #2196f3 !important;
    color: white !important;
    font-weight: 700;
}

.clickable-year.table-active .badge-patent-count {
    background: white;
    color: #2196f3;
}

.badge-patent-count {
    background: #3498db;
    color: white;
    padding: 6px 16px;
    border-radius: 20px;
    font-size: 14px;
    font-weight: 700;
    display: inline-block;
}

/* ========================================
   DETAILED TABLE (GREEN THEME)
   ======================================== */

.table-header-card.detailed-header {
    background: #27ae60;
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: nowrap;
}

.table-title {
    color: white;
    margin: 0;
    font-size: 18px;
    font-weight: 600;
    display: flex;
    align-items: center;
    flex: 1;
}

.table-title i {
    margin-right: 8px;
}

.selected-year-badge {
    background: rgba(255, 255, 255, 0.3);
    padding: 4px 12px;
    border-radius: 15px;
    font-size: 13px;
    margin-left: 10px;
    display: inline-block;
}

#closeDetailTable {
    background: white;
    color: #27ae60;
    padding: 8px 16px;
    border-radius: 4px;
    border: 2px solid white;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    display: inline-flex;
    align-items: center;
    gap: 6px;
    font-size: 13px;
    white-space: nowrap;
    flex-shrink: 0;
    margin-left: 15px;
}

#closeDetailTable:hover {
    background: #e74c3c;
    color: white;
    border-color: white;
    transform: scale(1.05);
}

#closeDetailTable i {
    font-size: 14px;
}

/* Detailed Table Styling */
#leavetable {
    width: 100%;
    border-collapse: collapse;
}

#leavetable thead {
    background: #27ae60;
}

#leavetable thead th {
    padding: 12px 10px;
    color: white;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 13px;
    text-align: center;
    border: none;
}

#leavetable tbody tr {
    border-bottom: 1px solid #f0f0f0;
    transition: background 0.2s;
}

#leavetable tbody tr:hover {
    background: #f9f9f9;
}

#leavetable tbody td {
    padding: 12px 10px;
    font-size: 14px;
    color: #555;
    text-align: center;
}

.detail-row {
    background: white;
}

.patent-name-cell {
    text-align: left;
    font-weight: 500;
    color: #333;
    max-width: 250px;
}

/* Badges */
.badge {
    padding: 4px 10px;
    border-radius: 12px;
    font-size: 12px;
    font-weight: 600;
}

.badge-success {
    background: #27ae60;
    color: white;
}

.badge-secondary {
    background: #95a5a6;
    color: white;
}

/* Loading Spinner */
.table-spinner {
    display: inline-block;
    width: 35px;
    height: 35px;
    border: 3px solid #f0f0f0;
    border-top: 3px solid #3498db;
    border-radius: 50%;
    animation: spin 0.8s linear infinite;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

/* Empty State */
.text-center {
    text-align: center;
}

.text-muted {
    color: #7f8c8d !important;
}

.text-danger {
    color: #e74c3c !important;
}

.fa-2x {
    font-size: 2em;
}

/* Slide Animation */
#detailTableContainer {
    overflow: hidden;
}

/* Utility Classes */
.mt-2 { margin-top: 0.5rem; }
.mt-4 { margin-top: 1.5rem; }
.m-1 { margin: 0.25rem; }
.py-4 { padding-top: 1.5rem; padding-bottom: 1.5rem; }
.py-5 { padding-top: 3rem; padding-bottom: 3rem; }
.mb-2 { margin-bottom: 0.5rem; }
.text-right { text-align: right; }

/* Button Icon Styling */
.btn i {
    margin-right: 5px;
}

/* Responsive Design */
@media (max-width: 768px) {
    .card-body {
        padding: 15px;
    }
    
    .table-title {
        font-size: 16px;
        flex-wrap: wrap;
    }
    
    .selected-year-badge {
        display: block;
        margin-left: 0;
        margin-top: 5px;
        width: fit-content;
    }
    
    .table-header-card.detailed-header {
        flex-wrap: wrap;
        gap: 10px;
    }
    
    #closeDetailTable {
        margin-left: 0;
        width: 100%;
        justify-content: center;
    }
    
    #leavetable thead th {
        font-size: 11px;
        padding: 10px 6px;
    }
    
    #leavetable tbody td {
        font-size: 12px;
        padding: 10px 6px;
    }
    
    .year-label-cell {
        width: 80px;
        font-size: 12px;
    }
    
    .badge-patent-count {
        font-size: 12px;
        padding: 4px 12px;
    }
}

@media (max-width: 576px) {
    .horizontal-year-table {
        font-size: 12px;
    }
    
    .year-cell,
    .count-cell {
        padding: 10px;
    }
}

/* Print Styles */
@media print {
    .btn, .table-header-card, .field-wrapper, #yearWiseTableContainer {
        display: none !important;
    }
    
    .card {
        box-shadow: none;
    }
    
    #leavetable thead {
        background: #333 !important;
        -webkit-print-color-adjust: exact;
    }
}
</style>