  <style>
        .file-upload-cell {
            position: relative;
            width: 120px;
        }
        .file-input {
            position: absolute;
            opacity: 0;
            width: 100%;
            height: 100%;
            cursor: pointer;
        }
        .file-label {
            display: inline-block;
            background: #007bff;
            color: white;
            padding: 5px 10px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 12px;
            text-align: center;
            width: 100px;
        }
        .file-label:hover {
            background: #0056b3;
        }
        .file-name {
            font-size: 10px;
            color: #666;
            margin-top: 2px;
            word-break: break-word;
        }
        .file-remove {
            color: red;
            cursor: pointer;
            font-size: 10px;
            margin-left: 5px;
        }
        .wide-th {
        width: 200px !important;  
    }
    .total-row {
    background-color: #f8f9fa;
    font-weight: bold;
    border-top: 2px solid #dee2e6;
}

.total-row td {
    padding: 12px 8px !important;
    font-size: 14px;
}

.total-amount {
    color: #28a745;
    font-size: 16px;
    font-weight: 600;
}

/* Loader Overlay Styles */
.loader-overlay {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.7);
    z-index: 9999;
    justify-content: center;
    align-items: center;
}

.loader-overlay.active {
    display: flex;
}

.loader-content {
    text-align: center;
    background: white;
    padding: 40px 50px;
    border-radius: 10px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
    min-width: 300px;
}

.spinner {
    font-size: 50px;
    color: #1273eb;
    animation: spin 1s linear infinite;
    margin: 0 auto 20px;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

.loader-text {
    font-size: 18px;
    color: #333;
    font-weight: 600;
    margin-bottom: 10px;
}

.loader-subtext {
    font-size: 14px;
    color: #666;
    font-weight: 400;
}
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
</head>
<body>

<div class="content-wrapper-scroll">
    
        <!-- Loader Overlay -->
<div class="loader-overlay" id="loaderOverlay">
    <div class="loader-content">
        <div class="spinner">
            <i class="fas fa-spinner fa-spin"></i>
        </div>
        <div class="loader-text">Processing Excel File...</div>
        <div class="loader-subtext" id="loaderSubtext">Please wait...</div>
    </div>
</div>
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1 mb-3">Scholership Data</div>
                    </div>
                    <div class="card-body">
                        <form role="form" id="Form" action="" method="post" enctype="multipart/form-data">
                        <div class="row gutters">
                       <!-- Add hidden field for Main_id -->
<input type="hidden" id="Main_id" name="Main_id" 
       value="<?php echo isset($mainData->Main_id) ? $mainData->Main_id : ''; ?>">
       
           <!-- hidden submenuid -->
<input class="form-control" id="fk_submenuId" name="fk_submenuId" type="hidden"
                           value="<?= isset($subId) ? $subId : '' ?>"  />

                               

<div class="col-md-3">
    <div class="field-wrapper">
        <select name="FiniYear" id="FiniYear" class="select-single js-states form-control">

    <?php
        $savedYear = isset($mainData->FiniYear) ? $mainData->FiniYear : '';
    ?>

    <!-- Always show Active Year on top -->
    <option value="<?= $activeYear->finiYear_id ?>"
        <?= ($savedYear == $activeYear->finiYear_id) ? 'selected' : '' ?>>
        <?= $activeYear->fini_Label ?>
    </option>

    <!-- Show all years below -->
    <?php foreach($yearList as $year): ?>
        <option value="<?= $year->finiYear_id ?>"
            <?= ($savedYear == $year->finiYear_id) ? 'selected' : '' ?>>
            <?= $year->fini_Label ?>
        </option>
    <?php endforeach; ?>

</select>
<div class="field-placeholder">Academic Year</div>


        <!-- <div class="field-placeholder">Academic Year</div> -->
    </div>
</div>

<hr>
<div class="row">
                            <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                <label for="excel_file" class="form-label">Import Excel</label>
                                <div class="card" id="studentCard"
                                     style="height: 120px; width: 60%; cursor: pointer; padding: 10px;
                                            border: 2px dashed black; text-align: center; display: flex;
                                            flex-direction: column; justify-content: flex-start; align-items: center;
                                            position: relative; overflow: hidden;"
                                     onclick="document.getElementById('excel_file').click();">
                                    <img src="<?= base_url('Assets/img/excel.png'); ?>" id="studentImg"
                                         style="max-height: 50px; object-fit: contain; margin-bottom: 5px;">
                                    <span id="studentFileText" style="font-size: 11px; color: black; font-weight:600;">
                                        (<span class="text-danger">*</span>File extension allowed: .xls .xlsx)
                                    </span>
                                    <input type="file" accept=".xls,.xlsx" style="display: none;"
                                           class="form-control form-control-sm"
                                           id="excel_file" name="excel_file">
                                </div>
                                <?php if (!empty($mainData->excel_file)): ?>
                                    <p class="mt-2">Uploaded File: <b><?= $mainData->excel_file ?></b></p>
                                <?php endif; ?>
                                <button class="btn btn-success btn-sm m-1" type="button" id="btnShow" style="padding: px 10px;font-size: 13px;"><i class="fas fa-search"></i> Show Excel Data</button>
                            </div>

                                </div>

                            <div class="row">
                                <div class="col-md-12 text-end mt-3">
                                   <a href="<?= base_url('uploads/formatexcel/Scholership_Data.xlsx'); ?>"
                                   download
                                   style="color: #0b0a0aff; text-decoration: underline; font-weight: 600; font-size:14px;">
                                   <i class="fas fa-file-excel" style="color: green; margin-right: 6px; font-size:16px;"></i>
                                   Download Excel Format
                                   </a>
                                </div>
                            </div>

                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-3 col-12">
                                <div class="table-responsive mt-3" id="printableTable">
                                   <div class="float-end mb-2">
                                     <?php if (!empty($mainData)): ?>
                                        <button class="btn btn-danger btn-sm m-1" type="button" id="btnClearAll" style="padding: px 10px;font-size: 13px;">
                                            <i class="fas fa-times"></i> Clear All
                                        </button>
                                     <?php endif; ?>
                                   </div>

                                    <table id="leavetable" class="table custom-table">
                                        <thead style="background-color: #1273eb;">
                                            <tr>
                                                <th class=".w-auto">Sr.No.</th>
                                                <th style=" min-width:300px;">Student Name</th>
                                                <th style=" min-width:180px;">PRN</th>
                                                 <th style=" min-width:180px;">Mobile No</th>
                                                <th style=" min-width:180px;">Branch</th>
                                                <th style=" min-width:180px;">Scholership Level</th>
                                                <th style=" min-width:180px;">Scholership Name</th>
                                                <th style=" min-width:180px;">Caste</th>
                                                <!-- <th style=" min-width:150px;">Year</th> -->
                                                
                                                
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <!-- Update tbody to show existing data -->
<tbody id="tableBody">

</tbody>

                                    </table>
                                   <div class="float-end">
                                     <button type="button" class="btn btn-success btn-sm p-2 rounded-3" id="addRowBtn"style="font-size:13px; font-weight:600;"><i class="fa-solid fa-plus  bg-white p-1 rounded-circle text-success shadow-lg me-2" style=" box-shadow: 4px 6px 12px rgba(0, 0, 0, 0.5) !important;"></i>Add Row</button>
                                   </div>
                                </div>
                            </div>

                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 mt-3">
                                <button type="button" class="btn mb-md-0 mb-2 btn-quarternary" id="submit" name="submit" type="button"><i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save</button>
                                <a class="btn mb-md-0 mb-2 btn-quarternary1" href="<?=base_url()?>admin/Scholership/index" type="button"><i class="fa-solid fa-list"></i>&nbsp;&nbsp;List</a>
                                <button type="button"
    class="btn mb-md-0 mb-2 btn-quarternaryhome"
    onclick="window.location.href='<?= base_url('admin/Scholership/dashboard') ?>'">
   
    <i class="fa-solid fa-home fa-lg"></i>
    <span class="fw-semibold">Home</span>
 
</button>
                                <!--<button class="btn mb-md-0 mb-2 btn-quarternaryhome" type="button"  onclick="window.location.href='<?= base_url() ?>admin/Scholership/dashboard'" ><a href="" class="text-decoration-none text-white "><i class="fa-solid fa-home"></i>&nbsp;&nbsp;</a>Home</button>-->
                                <br>
                            </div>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- Add Select2 JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<!-- <script src="<?php echo base_url();?>Assets/js/CreateJs/admin/Scholership.js"></script>  -->

<script>
    var a = false;
let excelData = []; // Store Excel data globally
let rowCounter = 1; // For serial numbers

$(document).ready(function () {
    // Initialize Select2
    $('.select-single').select2();

    // Check if we're in edit mode
    let isUpdateMode = $("#Main_id").val() && $("#Main_id").val() > 0;
    
    // Add one default row only in add mode (when no existing data)
    if (!isUpdateMode && $("#tableBody tr").length === 0) {
        addTableRow({
            student_name: '',
            prn: '',
            mobile_no: '',
            branch_name: '',
            scholer_level: '',
            scholership_name: '',
            caste: ''
        });
    }
    
    // Show Excel Data Button Click
    $('#btnShow').click(function () {
        const fileInput = $('#excel_file')[0];
        
        if (!fileInput.files.length) {
            Swal.fire({
                icon: 'warning',
                title: 'No File Selected',
                text: 'Please select an Excel file first'
            });
            return;
        }

        const file = fileInput.files[0];
        const fileExtension = file.name.split('.').pop().toLowerCase();
        
        if (fileExtension !== 'xls' && fileExtension !== 'xlsx') {
            Swal.fire({
                icon: 'error',
                title: 'Invalid File',
                text: 'Please select a valid Excel file (.xls or .xlsx)'
            });
            return;
        }

        // Show loader
        $('#loaderOverlay').addClass('active');
        $('#loaderSubtext').text('Reading Excel file...');

        const reader = new FileReader();
        
        reader.onload = function (e) {
            try {
                const data = new Uint8Array(e.target.result);
                const workbook = XLSX.read(data, { type: 'array' });
                const firstSheet = workbook.Sheets[workbook.SheetNames[0]];
                const jsonData = XLSX.utils.sheet_to_json(firstSheet, { header: 1 });

                // Remove header row and process data
                const headers = jsonData[0];
                excelData = [];
                
                for (let i = 1; i < jsonData.length; i++) {
                    const row = jsonData[i];
                    
                    // Skip empty rows
                    if (!row || row.every(cell => !cell)) continue;
                    
                    excelData.push({
                        student_name: row[0] || '',
                        prn: row[1] || '',
                        mobile_no: row[2] || '',
                        branch_name: row[3] || '',
                        scholer_level: row[4] || '',
                        scholership_name: row[5] || '',
                        caste: row[6] || ''
                    });
                }

                if (excelData.length === 0) {
                    $('#loaderOverlay').removeClass('active');
                    Swal.fire({
                        icon: 'warning',
                        title: 'No Data Found',
                        text: 'The Excel file does not contain any data'
                    });
                    return;
                }

                // Clear existing table
                $('#tableBody').empty();
                rowCounter = 1;

                // Populate table with Excel data
                excelData.forEach(function (item) {
                    addTableRow(item);
                });

                $('#loaderOverlay').removeClass('active');
                
                Swal.fire({
                    icon: 'success',
                    title: '<strong>Success!</strong>',
                    text: `${excelData.length} records loaded successfully`,
                    timer: 2000,
                    showConfirmButton: false,
                    customClass: {
                        popup: 'custom-swal-popup',
                        icon: 'custom-swal-icon',
                        title: 'custom-swal-title',
                        htmlContainer: 'custom-swal-text'
                    }
                });

            } catch (error) {
                $('#loaderOverlay').removeClass('active');
                console.error('Error reading Excel:', error);
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: 'Failed to read Excel file. Please check the format.'
                });
            }
        };

        reader.onerror = function () {
            $('#loaderOverlay').removeClass('active');
            Swal.fire({
                icon: 'error',
                title: 'Error!',
                text: 'Failed to read the file'
            });
        };

        reader.readAsArrayBuffer(file);
    });

    // Add Row Button
    $('#addRowBtn').click(function () {
        addTableRow({
            student_name: '',
            prn: '',
            mobile_no: '',
            branch_name: '',
            scholer_level: '',
            scholership_name: '',
            caste: ''
        });
    });

    // Clear All Button
    $('#btnClearAll').click(function () {
        Swal.fire({
            title: 'Are you sure?',
            text: "This will clear all data from the table!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, clear it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $('#tableBody').empty();
                excelData = [];
                rowCounter = 1;
                $('#excel_file').val('');
                
                Swal.fire({
                    icon: 'success',
                    title: 'Cleared!',
                    text: 'All data has been cleared.',
                    timer: 1500,
                    showConfirmButton: false
                });
            }
        });
    });

    // Submit Button - Save Data
    // Submit Button - Save Data
$('#submit').click(function () {
    if (a === true) return;

    // Validate financial year
    const finiYear = $('#FiniYear').val();
    if (!finiYear) {
        Swal.fire({
            icon: 'warning',
            title: 'Validation Error',
            text: 'Please select Academic Year'
        });
        return;
    }

    // Get all table data
    const tableData = [];
    let isValid = true;

    $('#tableBody tr').each(function () {
        const row = $(this);
        const student_name = row.find('input[name="student_name[]"]').val().trim();
        const prn = row.find('input[name="prn[]"]').val().trim();
        const mobile_no = row.find('input[name="mobile_no[]"]').val().trim();
        const branch_name = row.find('input[name="branch_name[]"]').val().trim();
        const scholer_level = row.find('input[name="scholer_level[]"]').val().trim();
        const scholership_name = row.find('input[name="scholership_name[]"]').val().trim();
        const caste = row.find('input[name="caste[]"]').val().trim();

        // Basic validation - only student_name required
        if (!student_name) {
            isValid = false;
            row.find('input[name="student_name[]"]').addClass('custom-invalid');
        }

        if (student_name) {
            tableData.push({
                student_name: student_name,
                prn: prn,
                mobile_no: mobile_no,
                branch_name: branch_name,
                scholer_level: scholer_level,
                scholership_name: scholership_name,
                caste: caste
            });
        }
    });

    if (!isValid) {
        Swal.fire({
            icon: 'warning',
            title: 'Validation Error',
            text: 'Please fill Student Name for all rows'
        });
        return;
    }

    if (tableData.length === 0) {
        Swal.fire({
            icon: 'warning',
            title: 'No Data',
            text: 'Please add at least one record to save'
        });
        return;
    }

    // Check if update or insert
    const mainId = $('#Main_id').val();
    const isUpdate = mainId && mainId > 0;

    // Prepare form data
    const formData = new FormData();
    formData.append('Main_id', mainId || '');
    formData.append('FiniYear', finiYear);
    formData.append('fk_submenuId', $('#fk_submenuId').val());
    formData.append('tableData', JSON.stringify(tableData));

    // Append Excel file if exists
    const excelFile = $('#excel_file')[0].files[0];
    if (excelFile) {
        formData.append('excel_file', excelFile);
    }

    // Determine URL
    const url = isUpdate 
        ? base_path + "admin/Scholership/updateScholership"
        : base_path + "admin/Scholership/insertScholership";

    a = true;

    $.ajax({
        url: url,
        type: "POST",
        data: formData,
        processData: false,
        contentType: false,
        beforeSend: function () {
            $('#submit').prop('disabled', true).html('Saving...');
        },
        success: function (response) {
            console.log(response);
            $('#submit').prop('disabled', false).html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');

            const successMessage = isUpdate 
                ? 'Data Updated Successfully' 
                : 'Data Submitted Successfully';

            Swal.fire({
                position: 'center',
                icon: 'success',
                title: '<strong>Success!</strong>',
                html: successMessage,
                showConfirmButton: false,
                timer: 2000,
                customClass: {
                    popup: 'custom-swal-popup',
                    icon: 'custom-swal-icon',
                    title: 'custom-swal-title',
                    htmlContainer: 'custom-swal-text'
                }
            }).then(() => {
                window.location.href = base_path + 'admin/Scholership/index';
            });
            a = false;
        },
        error: function (xhr, status, error) {
            console.error(error);
            $('#submit').prop('disabled', false).html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
            
            Swal.fire({
                icon: 'error',
                title: 'Error!',
                text: 'Failed to save data. Please try again.'
            });
            a = false;
        }
    });
});

    // Remove custom-invalid class on input
    $(document).on('input change', 'input, textarea, select', function () {
        if ($(this).val().trim() !== '') {
            $(this).removeClass('custom-invalid');
        }
    });

    // Delete Row
    $(document).on('click', '.delete-row', function () {
        $(this).closest('tr').remove();
        updateSerialNumbers();
    });
});

// Function to add table row
function addTableRow(data) {
    const newRow = `
        <tr>
            <td class="text-center">${rowCounter}</td>
            <td><input type="text" class="form-control form-control-sm" name="student_name[]" value="${data.student_name}" /></td>
            <td><input type="text" class="form-control form-control-sm" name="prn[]" value="${data.prn}" /></td>
            <td><input type="text" class="form-control form-control-sm" name="mobile_no[]" value="${data.mobile_no}" /></td>
            <td><input type="text" class="form-control form-control-sm" name="branch_name[]" value="${data.branch_name}" /></td>
            <td><input type="text" class="form-control form-control-sm" name="scholer_level[]" value="${data.scholer_level}" /></td>
            <td><input type="text" class="form-control form-control-sm" name="scholership_name[]" value="${data.scholership_name}" /></td>
            <td><input type="text" class="form-control form-control-sm" name="caste[]" value="${data.caste}" /></td>
            <td class="text-center">
                <button type="button" class="btn btn-danger btn-sm delete-row">
                    <i class="fa fa-trash"></i>
                </button>
            </td>
        </tr>
    `;
    
    $('#tableBody').append(newRow);
    rowCounter++;
}

// Function to update serial numbers
function updateSerialNumbers() {
    rowCounter = 1;
    $('#tableBody tr').each(function () {
        $(this).find('td:first').text(rowCounter);
        rowCounter++;
    });
}

// Add this at the end of your Scholership.js file or in a separate script in the view

$(document).ready(function() {
    // Check if we're in edit mode and load existing data
    <?php if (isset($childData) && !empty($childData)): ?>
        // Load existing data into table
        const existingData = <?php echo json_encode($childData); ?>;
        
        existingData.forEach(function(item) {
            addTableRow({
                student_name: item.Student_name || '',
                prn: item.PRN || '',
                mobile_no: item.mobile_no || '',
                branch_name: item.branch_name || '',
                scholer_level: item.Scholer_Level || '',
                scholership_name: item.ScholershipName || '',
                caste: item.Caste || ''
            });
        });
    <?php endif; ?>
});
</script>