<style>
    .section-header { display: flex; align-items: center; gap: 10px; margin: 16px 0 10px; padding-bottom: 10px; border-bottom: 3px solid #667eea; }
    .section-header i { font-size: 24px; color: #667eea; }
    .section-header h5 {     font-family: math; font-size: 21px; font-weight: 800; color: #2c3e50; margin: 0;  }

    .tbl-toolbar { display: flex; align-items: center; justify-content: space-between; gap: 10px; margin-bottom: 10px; flex-wrap: wrap; }
    .tbl-search { display: flex; align-items: center; gap: 8px; background: #f4f6ff; border: 1.5px solid #c9d1fd; border-radius: 8px; padding: 7px 12px; flex: 1; max-width: 380px; }
    .tbl-search i { color: #667eea; font-size: 15px; }
    .tbl-search input { border: none; background: transparent; outline: none; font-size: 14px; width: 100%; color: #333; }
    .tbl-search input::placeholder { color: #bbb; }
    .tbl-btns { display: flex; gap: 8px; }
    .btn-modern { border-radius: 6px; padding: 8px 16px; font-weight: 600; font-size: 13px; }
</style>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-start mt-5">
                        <h4>Q.M 3.4.3.1: Total number of NSS published/awarded year wise during the last five years</h4>
                    </div>
                    <div class="card-body">

                        <form role="form" id="Form">
                            <div class="row gutters">
                               
                                <div class="col-md-10">
            <div class="field-wrapper">
                <select class="select-single js-states" id="year_dropdown" name="year" multiple="multiple" 
                    value="<?php if(!empty($data)) echo $data[0]->finicial_Year; ?>">
                    <option value="">Select Financial Year</option>
                    <?php 
                    foreach($yeardata as $rw=>$value){
                    $selected = "";
                    if (!empty($data[0]->finicial_Year)) {
                        if ($value->finiYear_id == $data[0]->finicial_Year) {
                            $selected = "selected='selected'";
                         } 
                        }
                        echo '<option value="'.$value->finiYear_id.'"'.$selected.' >'.$value->fini_Label.'</option>';
                    }
                    ?>
                </select>
                <div class="field-placeholder">Select Year</div>
            </div>
        </div>

                                <div class="col-md-2 ">
                                    <button class="btn btn-success btn-sm m-1" type="button" id="btnShow" style="padding: 8px 20px;font-size: 13px; font-weight:600;">
                                        <i class="fas fa-search"></i> Show Data
                                    </button>
                                </div>
                            </div>

                            <!-- Year-wise Summary Table -->
                            <div class="table-responsive mt-4" id="yearWiseTableContainer">
                                <div id="yearSummarySection">
                                    <div class="tbl-toolbar no-print">
                                        <div class="tbl-btns" style="margin-left:auto;">
                                            <button type="button" class="btn btn-danger btn-modern" onclick="printSummaryTable()"><i class="fas fa-print"></i> Print</button>
                                            <button type="button" class="btn btn-success btn-modern" onclick="exportSummaryToExcel()"><i class="fas fa-file-excel"></i> Excel</button>
                                        </div>
                                    </div>

                                    <table id="yearTable" class="table custom-table modern-table horizontal-year-table" style="font-family: math; ">
                                        <tbody>
                                            <tr id="yearHeaderRow">
                                                <td class="year-label-cell"><strong>Year</strong></td>
                                            </tr>
                                            <tr id="yearDataRow">
                                                <td class="year-label-cell"><strong>Number</strong></td>
                                            </tr>
                                            <tr id="emptyStateRow">
                                                <td colspan="10" class="text-center text-muted py-5">
                                                    <i class="fas fa-info-circle fa-2x mb-2"></i>
                                                    <p>Please select filters and click "Show Data" to view results</p>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <div class=" note float-end no-print " >
                                        <p style="color:#00acf3;"> Note :</p>
                                        <p style="color:grey;">   Click Any Column for view results</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Detailed  Table (Shows all data on Show button click) -->
                            <div class="table-responsive mt-4" id="detailTableContainer" style="display: none;">
                                <div id="detailsSection">
                                    <div class="section-header mt-4">
                                        <i class="fas fa-list-alt"></i>
                                        <h5>Detailed NSS Records  </h5>
                                    </div>

                                    <div class="tbl-toolbar no-print">
                                        <div class="tbl-search">
                                            <i class="fas fa-search"></i>
                                            <input type="text" id="detailsSearch" placeholder="Search faculty, branch, patent name...">
                                        </div>
                                        <div class="tbl-btns">
                                            <button type="button" class="btn btn-danger btn-modern" onclick="printDetailsTable()"><i class="fas fa-print"></i> Print</button>
                                            <button type="button" class="btn btn-success btn-modern" onclick="exportDetailsToExcel()"><i class="fas fa-file-excel"></i> Excel</button>
                                            <button type="button" class="btn btn-dark btn-modern" id="closeDetailTable"><i class="fas fa-times"></i> Close</button>
                                        </div>
                                    </div>

                                    <div id="printableTable">
                                        <table id="Detailstable" class="table custom-table modern-table">
                                            <thead>
                                                 <tr>
                                                    <th>Sr.No.</th>
                                                    <th>Activity Name</th>
                                                    <th>Place of Act</th>
                                                    <th>Act Date</th>
                                                    <th>Month</th>
                                                    <th>SPOC Name</th>
                                                    <th>Department</th>
                                                    <th>Student Participated</th>
                                                    <th>Report PDF</th>
                                                    <th>Activity Status</th>
                                                    <th>Financial Year</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <!-- Detailed data will be loaded here -->
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="<?php echo base_url();?>Assets/js/jquery.min.js"></script>           
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script> 
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>

<script>
$(document).ready(function () {
    var currentFilters = {};
    var currentYearData = [];
    var allDetailedData = [];

    // Show Data button click
    $("#btnShow").click(function () {
        // Get year dropdown values
        var yearValues = $("#year_dropdown").val();
        
        // Convert to proper format
        var yearFilter = null;
        if (yearValues && yearValues.length > 0) {
            yearFilter = yearValues.filter(function(val) {
                return val != "0" && val != "" && val !== null;
            });
            
            if (yearFilter.length === 0) {
                yearFilter = null;
            }
        }

        currentFilters = {
            fk_institu: $("#fk_institu").val() || null,
            year: yearFilter
        };

        console.log('Filters being sent:', currentFilters);
        
        // Load both tables when Show button is clicked
        loadYearWiseData();
        loadAllDetailedData();
    });

    // Function to load year-wise count - HORIZONTAL FORMAT
    function loadYearWiseData() {
        $("#emptyStateRow").show();
        $("#emptyStateRow td").html(`
            <div class="table-loader">
                <div class="loader-spinner"></div>
                <div class="loader-text">Loading data...</div>
            </div>
        `);
        $("#yearHeaderRow td:not(:first)").remove();
        $("#yearDataRow td:not(:first)").remove();

        $.ajax({
            url: "<?= base_url('admin/Si_Report4/getYearWiseCount') ?>",
            type: "POST",
            data: currentFilters,
            dataType: "json",
            success: function (response) {
                console.log('Year-wise response:', response);
                
                currentYearData = response;
                
                if (response.length > 0) {
                    $("#emptyStateRow").hide();
                    $("#yearHeaderRow td:not(:first)").remove();
                    $("#yearDataRow td:not(:first)").remove();
                    
                    $.each(response, function (index, row) {
                        $("#yearHeaderRow").append(`
                            <td class="year-cell clickable-year" data-year-id="${row.finiYear_id}" data-year-label="${row.year}">
                                <strong>${row.year || 'N/A'}</strong>
                            </td>
                        `);
                        
                        $("#yearDataRow").append(`
                            <td class="count-cell clickable-year" data-year-id="${row.finiYear_id}" data-year-label="${row.year}">
                                <span>${row.count || 0}</span>
                            </td>
                        `);
                    });
                } else {
                    $("#emptyStateRow").show();
                    $("#emptyStateRow td").html(`
                        <div class="text-center text-danger py-5">
                            <i class="fas fa-exclamation-circle fa-2x mb-2"></i>
                            <p>No data found for the selected filters</p>
                        </div>
                    `);
                }
            },
            error: function (xhr, status, error) {
                console.error('Error:', error);
                $("#emptyStateRow").show();
                $("#emptyStateRow td").html(`
                    <div class="text-center text-danger py-5">
                        <i class="fas fa-exclamation-circle fa-2x mb-2"></i>
                        <p>Error loading data. Please try again.</p>
                    </div>
                `);
                Swal.fire("Error", "Something went wrong!", "error");
            }
        });
    }

    // Function to load ALL detailed data
    function loadAllDetailedData() {
        $("#detailTableContainer").slideDown(400);
        $("#detailsYearLabel").text("All Selected Data");
        
        $("#Detailstable tbody").html(`
            <tr>
                <td colspan="11">
                    <div class="table-loader">
                        <div class="loader-spinner"></div>
                        <div class="loader-text">Loading detailed data...</div>
                    </div>
                </td>
            </tr>
        `);

        var detailFilters = Object.assign({}, currentFilters);
        delete detailFilters.specific_year_id;

        console.log('Loading all detail filters:', detailFilters);

        $.ajax({
            url: "<?= base_url('admin/Si_Report4/getData') ?>",
            type: "POST",
            data: detailFilters,
            dataType: "json",
            success: function (response) {
                console.log('Detailed response:', response);
                console.log('Number of records:', response.length);
                
                allDetailedData = response;
                renderDetailedTable(response);
            },
            error: function (xhr, status, error) {
                console.error('Detail Error:', error);
                $("#Detailstable tbody").html(`
                    <tr>
                        <td colspan="11" class="text-center text-danger py-5">
                            <i class="fas fa-exclamation-circle fa-2x mb-2"></i>
                            <p>Error loading detailed data. Please try again.</p>
                        </td>
                    </tr>
                `);
                Swal.fire("Error", "Failed to load detailed data!", "error");
            }
        });
    }

    // Click on year cell to filter detailed data by that year
    $(document).on('click', '.clickable-year', function() {
        var selectedYearId = $(this).data('year-id');
        var selectedYearLabel = $(this).data('year-label');
        
        console.log('Clicked year ID:', selectedYearId);
        console.log('Clicked year Label:', selectedYearLabel);
        
        // Highlight selected column
        $('.clickable-year').removeClass('table-active');
        $(`.clickable-year[data-year-id="${selectedYearId}"]`).addClass('table-active');
        
        // Update year label
        $("#detailsYearLabel").text(selectedYearLabel);
        
        // Show detail table
        $("#detailTableContainer").slideDown(400);
        
        // Scroll to detail table
        $('html, body').animate({
            scrollTop: $("#detailTableContainer").offset().top - 100
        }, 500);
        
        // Filter data by year
        filterDetailedDataByYear(selectedYearId);
    });

    // Filter detailed data by year
    function filterDetailedDataByYear(yearId) {
        console.log('Filtering by year ID:', yearId);
        console.log('Total records available:', allDetailedData.length);
        
        $("#Detailstable tbody").html(`
            <tr>
                <td colspan="11">
                    <div class="table-loader">
                        <div class="loader-spinner"></div>
                        <div class="loader-text">Filtering data...</div>
                    </div>
                </td>
            </tr>
        `);
        
        setTimeout(function() {
            var filteredData = allDetailedData.filter(function(item) {
                return item.Financial_Year == yearId;
            });
            
            console.log('Filtered records:', filteredData.length);
            renderDetailedTable(filteredData);
        }, 300);
    }

    // Render detailed table
    function renderDetailedTable(data) {
        var tbody = "";
        if (data.length > 0) {
            $.each(data, function (index, row) {
                tbody += `
                    <tr class="detail-row">
                        <td class="text-center">${index + 1}</td>
                        <td>${row.NssActName || '-'}</td>
                        <td>${row.PlaceOFAct || '-'}</td>
                        <td class="text-center">${formatDate(row.ActDate) || '-'}</td>
                        <td class="text-center">${row.Month || '-'}</td>
                        <td>${row.SPOCName || '-'}</td>
                        <td>${row.branch_name || '-'}</td>
                        <td class="text-center">${row.StudPart || '0'}</td>
                        <td class="text-center">
                            ${row.Report_pdf ? '<a href="' + row.Report_pdf + '" target="_blank" class="badge badge-success"><i class="fas fa-file-pdf"></i> View</a>' : '<span class="badge badge-secondary">N/A</span>'}
                        </td>
                        <td class="text-center">
                            ${row.Activity_Status ? '<span class="badge badge-success">' + row.Activity_Status + '</span>' : '<span class="badge badge-secondary">-</span>'}
                        </td>
                        <td class="text-center">${row.fini_Label || '-'}</td>
                    </tr>
                `;
            });
        } else {
            tbody = `
                <tr>
                    <td colspan="11" class="text-center text-danger py-5">
                        <i class="fas fa-folder-open fa-2x mb-2"></i>
                        <p>No NSS activities found for the selected year</p>
                    </td>
                </tr>
            `;
        }
        $("#Detailstable tbody").html(tbody);
    }

    // Close detail table button
    $("#closeDetailTable").click(function() {
        $("#detailTableContainer").slideUp();
        $('.clickable-year').removeClass('table-active');
        $("#detailsYearLabel").text("All Selected Data");
        renderDetailedTable(allDetailedData);
    });

    // Search functionality
    $("#detailsSearch").on("keyup", function() {
        var value = $(this).val().toLowerCase();
        $("#Detailstable tbody tr").filter(function() {
            $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
        });
    });

    // Format date helper
    function formatDate(dateString) {
        if (!dateString) return '';
        const date = new Date(dateString);
        const day = String(date.getDate()).padStart(2, '0');
        const month = String(date.getMonth() + 1).padStart(2, '0');
        const year = date.getFullYear();
        return `${day}-${month}-${year}`;
    }
});

// Print/Export functions remain the same...


// Print Summary Table
function printSummaryTable() {
    getPrintHeadings(function(h) { 
        openPrint(h, document.getElementById('yearWiseTableContainer').innerHTML, false); 
    });
}

// Print Details Table
function printDetailsTable() {
    getPrintHeadings(function(h) { 
        openPrint(h, document.getElementById('printableTable').innerHTML, true); 
    });
}

// Get Print Headings
function getPrintHeadings(cb) {
    $.ajax({ 
        url: '<?= base_url("admin/Si_Report4/getPrintHeadings") ?>', 
        method: 'GET', 
        dataType: 'json', 
        success: cb,
        error: function(xhr, status, error) {
            console.error('Error loading headings:', error);
            // Use default values if fetch fails
            cb({
                logo: 'Assets/images/sit_logo.png',
                subHead1: '',
                head: 'NSS Report',
                subHead2: '',
                subHead3: ''
            });
        }
    });
}

// Open Print Window
function openPrint(h, bodyContent, fixedLayout) {
    var base = '<?= base_url() ?>';
    var logo = base + (h.logo || 'Assets/images/sit_logo.png').replace(/^\/+/, '');
    var tl = fixedLayout ? 'table-layout:fixed;' : '';
    var ifrm = document.createElement('iframe');
    ifrm.style.cssText = 'position:fixed;right:0;bottom:0;width:0;height:0;border:0';
    document.body.appendChild(ifrm);
    var d = ifrm.contentWindow.document;
    d.open();
    d.write('<html><head><title>Print</title><style>body{font-family:sans-serif;margin:10px 5px;padding:0}.header-section{display:flex;align-items:center;justify-content:center;gap:10px;margin-bottom:6px}.logo-container img{max-height:75px;max-width:75px}.heading-content{text-align:center}h4,h6{margin:0;padding:0}h4{font-size:18px;font-weight:bold;color:#d32f2f}h6{font-size:13px}table{width:100%;border-collapse:collapse;margin-top:4px;' + tl + 'border:2px solid #000}th,td{border:2px solid #000;padding:6px 4px;text-align:center;font-size:11px;word-wrap:break-word}th{background:#fff !important;color:#000 !important;font-weight:bold}.no-print{display:none !important}.badge{padding:2px 6px;border-radius:3px;font-size:10px}.badge-success{background:#27ae60;color:#fff}.badge-secondary{background:#95a5a6;color:#fff}</style></head><body><div class="header-section"><div class="logo-container"><img src="' + logo + '" alt="Logo"></div><div class="heading-content"><h6>' + (h.subHead1||'') + '</h6><h4>' + (h.head||'') + '</h4><div>' + (h.subHead2||'') + '</div><div>' + (h.subHead3||'') + '</div></div></div><br>' + bodyContent + '</body></html>');
    d.close();
    setTimeout(function() { ifrm.contentWindow.focus(); ifrm.contentWindow.print(); }, 500);
    setTimeout(function() { document.body.removeChild(ifrm); }, 3000);
}

// Export Summary to Excel
function exportSummaryToExcel() {
    getPrintHeadings(function(h) {
        var wb = XLSX.utils.book_new();
        var header = [
            [h.subHead1 || ''],
            [h.head || 'NSS Activity Report'],
            [h.subHead2 || ''],
            [h.subHead3 || ''],
            ['Year-wise NSS Activity Summary'],
            ['']
        ];
        
        // Get data from currentYearData
        var yearRow = ['Year'];
        var countRow = ['Count'];
        
        if (typeof currentYearData !== 'undefined' && currentYearData.length > 0) {
            currentYearData.forEach(function(item) {
                yearRow.push(item.year || '-');
                countRow.push(parseInt(item.count || 0));
            });
        }
        
        var fullData = header.concat([yearRow, countRow]);
        var ws = XLSX.utils.aoa_to_sheet(fullData);
        XLSX.utils.book_append_sheet(wb, ws, 'Summary');
        XLSX.writeFile(wb, 'NSS_Activity_Summary_Report.xlsx');
    });
}

// Export Details to Excel
function exportDetailsToExcel() {
    getPrintHeadings(function(h) {
        var wb = XLSX.utils.book_new();
        var tbl = document.getElementById('Detailstable');
        var td = XLSX.utils.sheet_to_json(XLSX.utils.table_to_sheet(tbl), { header: 1 });
        var hdr = [
            [h.subHead1 || ''],
            [h.head || 'NSS Activity Report'],
            [h.subHead2 || ''],
            [h.subHead3 || ''],
            ['NSS Activity Details'],
            ['']
        ];
        var ws = XLSX.utils.aoa_to_sheet(hdr.concat(td));
        XLSX.utils.book_append_sheet(wb, ws, 'Details');
        XLSX.writeFile(wb, 'NSS_Activity_Details.xlsx');
    });
}
</script>

<style>
/* ========================================
   PATENT REPORT - SIMPLE & CLEAN STYLES
   ======================================== */

/* Reset & Base */
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: Arial, sans-serif;
    background: #f5f5f5;
    color: #333;
}

/* Card Styling */
.card {
    background: white;
    border-radius: 8px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    border: none;
}
/* Loader Styles */
.table-loader {
    display: flex;
    justify-content: center;
    align-items: center;
    padding: 40px 20px;
    flex-direction: column;
    gap: 15px;
}
.note{
        font-family: math;
        display: flex;
        /* float:end; */
    font-weight:600;
}

.loader-spinner {
    width: 50px;
    height: 50px;
    border: 4px solid #f3f3f3;
    border-top: 4px solid #3498db;
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

.loader-text {
    color: #7f8c8d;
    font-size: 14px;
    font-weight: 500;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

.card-header {
    background: #2c3e50;
    padding: 20px;
    text-align: center;
}

.card-body {
    padding: 25px;
}

/* Form Fields */
.field-wrapper {
    position: relative;
    margin-bottom: 20px;
}

.field-wrapper select {
    width: 100%;
    padding: 10px 12px;
    border: 1px solid #ddd;
    border-radius: 4px;
    font-size: 14px;
    background: white;
}

.field-wrapper select:focus {
    outline: none;
    border-color: #3498db;
}

.field-placeholder {
    position: absolute;
    top: -10px;
    left: 10px;
    background: white;
    padding: 0 5px;
    font-size: 12px;
    color: #3498db;
    font-weight: 600;
}

/* Buttons */
.btn {
    padding: 8px 16px;
    border-radius: 4px;
    font-size: 13px;
    font-weight: 600;
    border: none;
    cursor: pointer;
}

.btn-success {
    background: #27ae60;
    color: white;
}

.btn-danger {
    background: #e74c3c;
    color: white;
}

.btn-secondary {
    background: #95a5a6;
    color: white;
}

.btn-dark {
    background: #34495e;
    color: white;
}

.btn:hover {
    opacity: 0.9;
}

/* Table Container */
.table-responsive {
    background: white;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    margin-top: 20px;
}
h4 {
    font-size: 1.25rem;
    margin-bottom: .4rem;
    font-family: math;
}
/* ========================================
   YEAR-WISE TABLE (BLUE THEME)
   ======================================== */

.table-header-card {
    background: #3498db;
    padding: 15px 20px;
    color: white;
}

.table-title {
    color: white;
    margin: 0;
    font-size: 18px;
    font-weight: 600;
}

.table-title i {
    margin-right: 8px;
}

/* Year Table - Horizontal Layout */
.horizontal-year-table {
    width: 100%;
    border-collapse: collapse;
}

.horizontal-year-table tbody tr td {
    border: 1px solid #0c0c0c;
    padding: 12px 15px;
    text-align: center;
    font-size: 16px;
}

.year-label-cell {
    background: #3498db;
    color: white;
    font-weight: 700;
    font-size: 14px;
    width: 100px;
}

.year-cell {
    background: #e3f2fd;
    color: #1565c0;
    font-weight: 600;
    cursor: pointer;
    transition: background 0.3s;
}

.year-cell:hover {
    background: #bbdefb;
}

.count-cell {
    background: #f5f5f5;
    cursor: pointer;
    transition: background 0.3s;
}

.count-cell:hover {
    background: #e3f2fd;
}

.clickable-year.table-active {
    background: #2196f3 !important;
    color: white !important;
    font-weight: 700;
}

.clickable-year.table-active .badge-patent-count {
    background: white;
    color: #2196f3;
}

.badge-patent-count {
    background: #fefefe;
    color: black;
    padding: 6px 16px;
    border-radius: 20px;
    font-size: 14px;
    font-weight: 700;
    display: inline-block;
}

/* ========================================
   DETAILED TABLE (GREEN THEME)
   ======================================== */

.table {
    background-color: #ffffff;
}

.table-header-card.detailed-header {
    background: #27ae60;
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: nowrap;
}

.table-title {
    color: white;
    margin: 0;
    font-size: 18px;
    font-weight: 600;
    display: flex;
    align-items: center;
    flex: 1;
}

.table-title i {
    margin-right: 8px;
}

.selected-year-badge {
    background: rgba(255, 255, 255, 0.3);
    padding: 4px 12px;
    border-radius: 15px;
    font-size: 13px;
    margin-left: 10px;
    display: inline-block;
}

/* Detailed Table Styling */
#Detailstable {
    width: 100%;
    border-collapse: collapse;
}

#Detailstable thead th  {
    font-family: revert;
    background: darkorange;
    padding: 12px 10px;
    color: #000;
    font-weight: 600;
  border: 1px solid #000;
    font-size: 13px;
    text-align: center;
  
}

#Detailstable tbody tr {
    border-bottom: 1px solid #050505 !important;
    transition: background 0.2s;
}

#Detailstable tbody tr:hover {
    background: #f9f9f9;
}

#Detailstable tbody td {
    padding: 12px 10px;
    font-size: 14px;
    color: #555;
    text-align: center;
}

.detail-row {
    background: white;
}

.patent-name-cell {
    text-align: left;
    font-weight: 500;
    color: #333;
    max-width: 250px;
}

/* Badges */
.badge {
    padding: 4px 10px;
    border-radius: 12px;
    font-size: 12px;
    font-weight: 600;
}

.badge-success {
    background: #27ae60;
    color: white;
}

.badge-secondary {
    background: #95a5a6;
    color: white;
}

/* Loading Spinner */
.table-spinner {
    display: inline-block;
    width: 35px;
    height: 35px;
    border: 3px solid #f0f0f0;
    border-top: 3px solid #3498db;
    border-radius: 50%;
    animation: spin 0.8s linear infinite;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

/* Empty State */
.text-center {
    text-align: center;
}

.text-muted {
    color: #7f8c8d !important;
}

.text-danger {
    color: #e74c3c !important;
}

.fa-2x {
    font-size: 2em;
}

/* Slide Animation */
#detailTableContainer {
    overflow: hidden;
}

/* Utility Classes */
.mt-2 { margin-top: 0.5rem; }
.mt-4 { margin-top: 1.5rem; }
.m-1 { margin: 0.25rem; }
.py-4 { padding-top: 1.5rem; padding-bottom: 1.5rem; }
.py-5 { padding-top: 3rem; padding-bottom: 3rem; }
.mb-2 { margin-bottom: 0.5rem; }
.text-right { text-align: right; }

/* Button Icon Styling */
.btn i {
    margin-right: 5px;
}

/* Responsive Design */
@media (max-width: 768px) {
    .card-body {
        padding: 15px;
    }
    
    .table-title {
        font-size: 16px;
        flex-wrap: wrap;
    }
    
    .selected-year-badge {
        display: block;
        margin-left: 0;
        margin-top: 5px;
        width: fit-content;
    }
    
    .table-header-card.detailed-header {
        flex-wrap: wrap;
        gap: 10px;
    }
    
    #Detailstable thead th {
        font-size: 11px;
        padding: 10px 6px;
    }
    
    #Detailstable tbody td {
        font-size: 12px;
        padding: 10px 6px;
    }
   #Detailstable th {
    background-color: #cdd7eb !important;
    color: black !important;
    font-weight: bold;
    padding: 10px;
    letter-spacing: 0.5px;
    border: 1px solid black;
}
    
    .year-label-cell {
        width: 80px;
        font-size: 12px;
    }
    
    .badge-patent-count {
        font-size: 12px;
        padding: 4px 12px;
    }
}

@media (max-width: 576px) {
    .horizontal-year-table {
        font-size: 12px;
    }
    
    .year-cell,
    .count-cell {
        padding: 10px;
    }
}

/* Print Styles */
@media print {
    .btn, .table-header-card, .field-wrapper, .no-print {
        display: none !important;
    }
    
    .card {
        box-shadow: none;
    }
    
    #Detailstable thead {
        background: #333 !important;
        -webkit-print-color-adjust: exact;
    }
}
</style>