<!DOCTYPE html>
<html>
<head>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <style>
        p {
            margin-bottom: 0.2rem;
            line-height: 273%;
        }

        .ribbon {
            display: inline-block;
            background-color: #17a2b8;
            color: white;
            font-size: 27px;
            font-weight: 600;
            font-family: 'Times New Roman', serif;
            padding: 4px 20px;
            position: relative;
            margin: 0px;
        }

        .ribbon::after {
            content: '';
            position: absolute;
            top: 0;
            right: -20px;
            width: 0;
            height: 0;
            border-left: 21px solid #17a2b8;
            border-top: 18px solid transparent;
            border-bottom: 23px solid transparent;
        }

        .ribbon::before {
            content: '';
            position: absolute;
            top: 0;
            left: -20px;
            width: 0;
            height: 0;
            border-right: 21px solid #17a2b8;
            border-top: 18px solid transparent;
            border-bottom: 23px solid transparent;
        }

        .technical-menu {
            position: relative;
            background: #f8f9fa00;
            border-radius: 10px;
            padding: 20px;
            margin-top: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .legend-header {
            position: absolute;
            top: -12px;
            left: 20px;
            background: white;
            padding: 0 10px;
        }
        
        .legend-header h5 {
            color: #df0a7b;
            font-weight: 600;
            margin: 0;
            font-size: 1.2rem;
        }

        .menu-item {
            background: white;
            border: none;
            border-radius: 8px;
            padding: 10px 14px;
            margin: 1px 0;
            width: 100%;
            text-align: left;
            transition: all 0.3s ease;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            cursor: pointer;
        }

        .menu-item:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(0,0,0,0.15);
        }

        .menu-item i {
            width: 20px;
            margin-right: 10px;
        }

        .menu-item a {
            text-decoration: none;
            color: #333;
            display: block;
            width: 100%;
            height: 100%;
        }
    </style>
</head>
<body>
    <div class="content-wrapper">
        <div class="container-fluid">
            <div class="card p-4 shadow">
                <div class="col-12 mx-auto">
                    <div class="col-12 mx-auto mt-1">
                        <div class="row" style="justify-content:center;">
                            <div class="col-4">
                                <h4 class="ribbon">
                                    Student Counseling Dashboard
                                </h4>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Menu Section -->
                <div class="col-12 mx-auto">
                    <div class="row">
                        <!-- Main Menu -->
                        <div class="col-6">
                            <div class="technical-menu" style="border:2px solid black">
                                <div class="legend-header">
                                    <h5>Counseling Menu</h5>
                                </div>
                                
                                <div class="row">
                                

                                    <div class="col-12">
                                        <button class="menu-item">
                                            <a href="<?=base_url()?>admin/Student_Counseling/create">
                                                <i class="fas fa-clipboard-list"></i>
                                                Add Student Counseling
                                            </a>
                                        </button>
                                    </div>

                                    <div class="col-12">
                                        <button class="menu-item">
                                            <a href="<?=base_url()?>admin/Student_Counseling/index">
                                                <i class="fas fa-table"></i>
                                                Student Counseling Details
                                            </a>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Reports Section -->
                        <div class="col-6">
                            <div class="technical-menu" style="border:2px solid black">
                                <div class="legend-header">
                                    <h5>Reports</h5>
                                </div>
                                
                                <div class="row">
                                    <div class="col-12">
                                        <button class="menu-item">
                                            <a href="<?=base_url()?>admin/Student_Counseling_report/create">
                                                <i class="fas fa-file-alt"></i>
                                                Counseling Reports
                                                <div class="form-text">(Institutewise,Departmentwise,Counseling Typewise,Yearwise,Datewise With Graphical Reports)</div>
                                            </a>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>