<?php
// Update mode check: $alldata[0] available ho toh update, nahi toh create
$record = (!empty($alldata) && isset($alldata[0])) ? $alldata[0] : null;
?>
<style>
    .loader-overlay {
        display: none;
        position: fixed;
        top: 0; left: 0;
        width: 100%; height: 100%;
        background: rgba(0, 0, 0, 0.7);
        z-index: 9999;
        justify-content: center;
        align-items: center;
    }
    .loader-overlay.active { display: flex; }
    .loader-content {
        text-align: center;
        background: white;
        padding: 30px;
        border-radius: 10px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
    }
    .spinner {
        border: 4px solid #f3f3f3;
        border-top: 4px solid #007bff;
        border-radius: 50%;
        width: 50px; height: 50px;
        animation: spin 1s linear infinite;
        margin: 0 auto 15px;
    }
    @keyframes spin {
        0%   { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
    .loader-text {
        font-size: 16px;
        color: #333;
        font-weight: 600;
    }
</style>

<div class="content-wrapper-scroll">

    <!-- LOADER -->
    <div class="loader-overlay" id="loaderOverlay">
        <div class="loader-content">
            <div class="spinner"></div>
            <div class="loader-text">Processing Excel File...</div>
        </div>
    </div>

    <!-- Content wrapper start -->
    <div class="content-wrapper">

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

                <!-- Card start -->
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1">Student Transport Form - <?= $record !== null ? 'Update' : 'Create' ?></div>
                    </div>

                    <div class="card-body">
                        <form role="form" id="Form" method="post" enctype="multipart/form-data">

                            <!-- Row start -->
                            <div class="row gutters">
                                <!-- Hidden: id -->
                                <input class="form-control" id="id" name="id" type="hidden"
                                       value="<?= $record !== null ? $record->id : '' ?>" />

                                <!-- Route name Dropdown -->
                                <div class="col-xl-2 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <div class="field-wrapper">
                                        <select class="select-single js-states" id="fk_rootmaster" name="fk_rootmaster">
                                            <option value="">Route name</option>
                                            <?php foreach ($rootdata as $value): ?>
                                                <option value="<?= $value->Route_masterid ?>"
                                                    <?= ($record !== null && $record->fk_rootmaster == $value->Route_masterid) ? 'selected' : '' ?>>
                                                    <?= $value->Route_name ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Route<span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <!-- Route stop name -->
                                <div class="col-xl-2 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <div class="field-wrapper">
                                        <select class="select-single js-states" id="fk_stopname" name="fk_stopname">
                                            <option value="">Route stop name</option>
                                            <?php foreach ($rootstopdata as $value): ?>
                                                <option value="<?= $value->routestop_id ?>"
                                                    <?= ($record !== null && $record->fk_stopname == $value->routestop_id) ? 'selected' : '' ?>>
                                                    <?= $value->stop_name ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Route stop name<span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <!-- Vehicle name Dropdown -->
                                <div class="col-xl-2 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <div class="field-wrapper">
                                        <select class="select-single js-states" id="fk_vehiclenames" name="fk_vehiclenames">
                                            <option value="">Vehicle name</option>
                                            <?php foreach ($vehicledata as $value): ?>
                                                <option value="<?= $value->vehicle_id ?>"
                                                    <?= ($record !== null && $record->fk_vehiclenames == $value->vehicle_id) ? 'selected' : '' ?>>
                                                    <?= $value->vehi_name ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Vehicle name<span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <!-- User type dropdown -->
                                <div class="col-xl-2 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <div class="field-wrapper">
                                        <select class="select-single js-states" id="fk_usertype" name="fk_usertype">
                                            <option value="">User type</option>
                                            <?php foreach ($usertypedata as $value): ?>
                                                <option value="<?= $value->mainuser_id ?>"
                                                    <?= ($record !== null && $record->fk_usertype == $value->mainuser_id) ? 'selected' : '' ?>>
                                                    <?= $value->mainuser_name ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">User type<span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <!-- year dropdown -->
                                <div class="col-xl-2 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <div class="field-wrapper">
                                        <select class="select-single js-states" id="fk_finalyear" name="fk_finalyear">
                                            <option value="">Select Year</option>
                                            <?php foreach ($yeardata as $value): ?>
                                                <option value="<?= $value->finiYear_id ?>"
                                                    <?= ($record !== null && $record->fk_finalyear == $value->finiYear_id) ? 'selected' : '' ?>>
                                                    <?= $value->fini_Label ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Year<span class="text-danger">*</span></div>
                                    </div>
                                </div>

                            </div>
                            <!-- Row end -->

                            <hr>

                            <!-- Excel Upload (Only show in CREATE mode) -->
                            <?php if ($record === null): ?>
                            <div class="col-md-2 m-2">
                                <label for="excel_file" class="form-label">Choose Transform Excel File</label>

                                <div class="card" id="cardBox"
                                     style="height: 120px; width: 70%; cursor: pointer; padding: 10px;
                                            border: 2px dashed black; text-align: center; display: flex;
                                            flex-direction: column; justify-content: flex-start; align-items: center;
                                            position: relative; overflow: hidden;"
                                     onclick="document.getElementById('StudParListFile').click();">

                                    <img src="<?= base_url('Assets/img/excel.png'); ?>" id="defaultImg"
                                         style="max-height: 50px; object-fit: contain; margin-bottom: 5px;">

                                    <span id="fileText" style="font-size: 11px; color: black; font-weight:600;">
                                        (<span class="text-danger">*</span>File extension allowed: .xls .xlsx)
                                    </span>

                                    <input type="file" accept=".xls,.xlsx" style="display: none;"
                                           class="form-control form-control-sm"
                                           id="StudParListFile" name="StudParListFile">
                                </div>
                            </div>

                            <br>

                            <div class="row">
                                <div class="mb-2 text-end">
                                    <a href="<?= base_url("uploads/formatexcel/Student_Transform_ Excel.xlsx"); ?>"
                                       download
                                       style="color: #0b0a0aff; text-decoration: underline; font-weight: 600; font-size:14px;">
                                        <i class="fas fa-file-excel" style="color: green; margin-right: 6px; font-size:16px;"></i>
                                        Download Excel Format
                                    </a>
                                </div>
                            </div>
                            <?php endif; ?>

                        </div>

                        <!-- Student List Table -->
                       <!-- Student List Table -->
<div class="table-responsive">
    <table id="studentParentTable" class="table custom-table">
        <thead>
            <tr>
                <th>Prn no/Employee id</th>
                <th>Student/faculty Name</th>
                <th>Branch</th>
                <th>Class</th>
                <th>Division</th>
                <th>Contact No</th>
                <th>Address</th>
                <th>Aadhar No</th>
                <th>Parent Mobile</th>
                <th>Action</th> <!-- Action column hamesha show hoga -->
            </tr>
        </thead>

        <tbody id="studentParentTbody">
            <?php if ($record !== null): ?>
                <!-- UPDATE MODE: Show existing data -->
                <tr>
                    <td>
                        <input type="text" name="prn[]" maxlength="16"
                            oninput="this.value=this.value.replace(/[^0-9]/g,'').slice(0,16);"
                            value="<?= htmlspecialchars($record->prn ?? '') ?>" class="form-control">
                    </td>
                    <td>
                        <input type="text" name="student_name[]"
                            value="<?= htmlspecialchars($record->student_name ?? '') ?>" class="form-control">
                    </td>
                    <td>
                        <input type="text" name="branch[]"
                            value="<?= htmlspecialchars($record->branch ?? '') ?>" class="form-control">
                    </td>
                    <td>
                        <input type="text" name="class[]"
                            value="<?= htmlspecialchars($record->class ?? '') ?>" class="form-control">
                    </td>
                    <td>
                        <input type="text" name="division[]"
                            value="<?= htmlspecialchars($record->division ?? '') ?>" class="form-control">
                    </td>
                    <td>
                        <input type="text" name="contact_no[]" maxlength="10"
                            oninput="this.value=this.value.replace(/[^0-9]/g,'').slice(0,10);"
                            value="<?= htmlspecialchars($record->contact_no ?? '') ?>" class="form-control">
                    </td>
                    <td>
                        <input type="text" name="address[]"
                            value="<?= htmlspecialchars($record->address ?? '') ?>" class="form-control">
                    </td>
                    <td>
                        <input type="text" name="aadhar_no[]" maxlength="12"
                            oninput="this.value=this.value.replace(/[^0-9]/g,'').slice(0,12);"
                            value="<?= htmlspecialchars($record->aadhar_no ?? '') ?>" class="form-control">
                    </td>
                    <td>
                        <input type="text" name="portal_mobile[]" maxlength="10"
                            oninput="this.value=this.value.replace(/[^0-9]/g,'').slice(0,10);"
                            value="<?= htmlspecialchars($record->portal_mobile ?? '') ?>" class="form-control">
                    </td>
                    <td class="text-center">
                        <button type="button" class="btn btn-sm text-danger removeRow">
                            <i class="fa-solid fa-trash"></i>
                        </button>
                    </td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <!-- Add Row button dono modes mein show hoga -->
    <div class="float-end mt-2">
        <button type="button" class="btn btn-success btn-sm" id="addRow">
            <i class="fa-solid fa-plus"></i> Add Row
        </button>
    </div>
</div>

                        <hr>

                    </div><!-- card-body end -->

                    <!-- Buttons -->
                    <div class="card-body">
                        <div class="">
                            <button type="button" class="btn mb-md-0 mb-2 btn-quarternary" id="btn_save" name="submit">
                                <i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;<?= $record !== null ? 'Update' : 'Save' ?>
                            </button>
                            <a class="btn mb-md-0 mb-2 btn-quarternary1" href="<?= base_url() ?>admin/Student_transfortfrom/index" type="button">
                                <i class="fa-solid fa-list"></i>&nbsp;&nbsp;List
                            </a>
                            <button type="button" class="btn mb-md-0 mb-2 btn-quarternaryhome"
                                    onclick="window.location.href='<?= base_url('admin/Student_transfortfrom/dashboard') ?>'">
                                <i class="fa-solid fa-home fa-lg"></i>
                                <span class="fw-semibold">Home</span>
                            </button>
                            <br>
                        </div>
                    </div>

                    </form>
                </div><!-- card end -->
            </div>
        </div>

    </div><!-- content-wrapper end -->
</div><!-- content-wrapper-scroll end -->

<!-- Scripts -->
<script src="<?php echo base_url(); ?>Assets/js/jquery.min.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<script src="<?php echo base_url(); ?>Assets/js/CreateJs/admin/Student_transfortfrom.js"></script>

<script>
// Add Row functionality - CREATE aur UPDATE dono ke liye
document.getElementById('addRow').addEventListener('click', function () {
    var tbody = document.getElementById('studentParentTbody');
    var tr = document.createElement('tr');
    tr.innerHTML =
        '<td><input type="text" name="prn[]" maxlength="16" oninput="this.value=this.value.replace(/[^0-9]/g,\'\').slice(0,16);" class="form-control"></td>' +
        '<td><input type="text" name="student_name[]" class="form-control"></td>' +
        '<td><input type="text" name="branch[]" class="form-control"></td>' +
        '<td><input type="text" name="class[]" class="form-control"></td>' +
        '<td><input type="text" name="division[]" class="form-control"></td>' +
        '<td><input type="text" name="contact_no[]" maxlength="10" oninput="this.value=this.value.replace(/[^0-9]/g,\'\').slice(0,10);" class="form-control"></td>' +
        '<td><input type="text" name="address[]" class="form-control"></td>' +
        '<td><input type="text" name="aadhar_no[]" maxlength="12" oninput="this.value=this.value.replace(/[^0-9]/g,\'\').slice(0,12);" class="form-control"></td>' +
        '<td><input type="text" name="portal_mobile[]" maxlength="10" oninput="this.value=this.value.replace(/[^0-9]/g,\'\').slice(0,10);" class="form-control"></td>' +
        '<td class="text-center"><button type="button" class="btn btn-sm text-danger removeRow"><i class="fa-solid fa-trash"></i></button></td>';
    tbody.appendChild(tr);
});

// Remove Row functionality - dono modes ke liye
document.getElementById('studentParentTbody').addEventListener('click', function (e) {
    var btn = e.target.closest('.removeRow');
    if (!btn) return;

    var tbody = document.getElementById('studentParentTbody');
    var rows = tbody.querySelectorAll('tr');

    if (rows.length <= 1) {
        Swal.fire({ 
            icon: 'warning', 
            title: 'At least one row required', 
            showConfirmButton: false, 
            timer: 1500 
        });
        return;
    }

    btn.closest('tr').remove();
});

<?php if ($record === null): ?>
// CREATE MODE: Default empty row add karo
window.addEventListener("load", function () {
    document.getElementById("addRow").click();
});
<?php endif; ?>
</script>