<style>
.menu-access-section {
    margin-top: 30px;
    padding: 15px;
    background: #ffffff;
    border: 1px solid #e0e0e0;
    border-radius: 6px;
}

.menu-section-title {
    font-size: 16px;
    font-weight: 600;
    margin-bottom: 15px;
    color: #2c3e50;
    padding-bottom: 8px;
    border-bottom: 2px solid #3498db;
    display: flex;
    align-items: center;
    gap: 8px;
}

.select-all-wrapper {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 4px 10px;
    background: #f8f9fa;
    border-radius: 4px;
    border: 1px solid #dee2e6;
    cursor: pointer;
    transition: all 0.2s ease;
}

.select-all-wrapper:hover {
    background: #e9ecef;
}

.select-all-wrapper input[type="checkbox"] {
    width: 18px;
    height: 18px;
    cursor: pointer;
}

.select-all-wrapper label {
    margin: 0;
    cursor: pointer;
    font-size: 13px;
    font-weight: 500;
    color: #495057;
}

.menus-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
    gap: 12px;
    max-height: 500px;
    overflow-y: auto;
    padding: 5px;
}

.menu-card {
    border: 1px solid #e0e0e0;
    border-radius: 6px;
    background: #fafafa;
    transition: all 0.2s ease;
}

.menu-card:hover {
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    border-color: #3498db;
}

.menu-card.selected {
    background: #f0f8ff;
    border-color: #3498db;
}

.menu-header {
    padding: 10px 12px;
    background: #f5f5f5;
    border-bottom: 1px solid #e0e0e0;
    border-radius: 6px 6px 0 0;
    display: flex;
    align-items: center;
    gap: 8px;
    cursor: pointer;
    user-select: none;
}

.menu-header:hover {
    background: #ebebeb;
}

.menu-header input[type="checkbox"] {
    width: 18px;
    height: 18px;
    cursor: pointer;
    flex-shrink: 0;
}

.menu-header label {
    margin: 0;
    cursor: pointer;
    font-size: 14px;
    font-weight: 600;
    color: #2c3e50;
    flex: 1;
    display: flex;
    align-items: center;
    gap: 6px;
}

.menu-header label i {
    font-size: 14px;
    color: #3498db;
}

.submenu-list {
    padding: 8px 10px;
    max-height: 200px;
    overflow-y: auto;
}

.submenu-item {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 6px 8px;
    margin-bottom: 4px;
    border-radius: 4px;
    transition: background 0.2s ease;
}

.submenu-item:hover {
    background: #f0f0f0;
}

.submenu-item:last-child {
    margin-bottom: 0;
}

.submenu-item input[type="checkbox"] {
    width: 16px;
    height: 16px;
    cursor: pointer;
    flex-shrink: 0;
}

.submenu-item label {
    margin: 0;
    cursor: pointer;
    font-size: 13px;
    color:black;
    flex: 1;
    line-height: 1.3;
}

.submenu-item label small {
    color: black;
    font-style: italic;
    display: block;
    font-size: 12px;
    font-weight: 700;
}

.no-submenus {
    padding: 8px 10px;
    text-align: center;
    color: #999;
    font-size: 12px;
    font-style: italic;
}

.no-menus-message {
    text-align: center;
    padding: 40px;
    color: #adb5bd;
}

.no-menus-message i {
    margin-bottom: 10px;
}

/* Custom scrollbar for menus grid */
.menus-grid::-webkit-scrollbar {
    width: 8px;
}

.menus-grid::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 4px;
}

.menus-grid::-webkit-scrollbar-thumb {
    background: #c1c1c1;
    border-radius: 4px;
}

.menus-grid::-webkit-scrollbar-thumb:hover {
    background: #a8a8a8;
}

/* Custom scrollbar for submenu list */
.submenu-list::-webkit-scrollbar {
    width: 6px;
}

.submenu-list::-webkit-scrollbar-track {
    background: #f9f9f9;
    border-radius: 3px;
}

.submenu-list::-webkit-scrollbar-thumb {
    background: #d0d0d0;
    border-radius: 3px;
}

.submenu-list::-webkit-scrollbar-thumb:hover {
    background: #b0b0b0;
}

/* Selection counter badge */
.selection-badge {
    display: inline-flex;
    align-items: center;
    gap: 5px;
    background: #3498db;
    color: white;
    padding: 4px 10px;
    border-radius: 12px;
    font-size: 12px;
    font-weight: 600;
    margin-left: auto;
}
</style>

<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1">User Form</div>
                    </div>
                    <div class="card-body">
                        <form role="form" id="UserForm" action="" method="post">
                            <div class="row gutters">
                                <!-- Hidden User ID -->
                                <input type="hidden" id="UserID" name="UserID" class="hiddenId" 
                                       value="<?php if(!empty($data)) echo $data[0]->UserID; ?>">

                                <!-- Username -->
                                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <div class="field-wrapper">
                                        <input class="form-control" type="text" id="UserName" required name="UserName" 
                                               value="<?php if(!empty($data)) echo $data[0]->UserName; ?>">
                                        <div class="field-placeholder">UserName<span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <!-- Password -->
                                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <div class="field-wrapper">
                                        <input class="form-control" type="password" id="Password" name="Password" 
                                               <?php if(empty($data)) echo 'required'; ?>
                                               placeholder="<?php if(!empty($data)) echo 'Leave blank to keep current password'; ?>">
                                        <div class="field-placeholder">Password<span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <!-- Faculty -->
                                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <div class="field-wrapper">
                                        <?php $isEdit = isset($data[0]); ?>
                                        <select name="fkfaculty_ID" id="fkfaculty_ID" class="select-single js-states form-control" required>
                                            <option value="">Select Faculty</option>
                                            <?php foreach($facultydata as $Fac): ?>
                                                <option value="<?= $Fac->fac_id ?>" 
                                                    <?= ($isEdit && $Fac->fac_id == $data[0]->fkfaculty_ID) ? 'selected' : '' ?>>
                                                    <?= $Fac->fac_Fullname ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Faculty<span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <!-- Role -->
                                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <div class="field-wrapper">
                                        <select name="fkRole_id" id="fkRole_id" 
                                                class="select-single js-states form-control" required>
                                            <?php foreach ($roledata as $index => $role): ?>
                                                <option value="<?= $role->Role_id ?>"
                                                    <?= ($isEdit && $role->Role_id == $data[0]->fkRole_id) 
                                                        || (!$isEdit && $index == 0) ? 'selected' : '' ?>>
                                                    <?= $role->Role_Name ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Role<span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <!-- Branch - MULTISELECT -->
                                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <div class="field-wrapper">
                                        <select name="fkBranch_Id[]" id="fkBranch_Id" class="select-multiple js-states form-control" multiple="multiple">
                                            <option value="select_all" > Select All </option>
                                            <?php 
                                            // Get selected branches for edit mode
                                            $selectedBranches = [];
                                            if($isEdit && !empty($data[0]->fkBranch_Id)) {
                                                $selectedBranches = explode(',', $data[0]->fkBranch_Id);
                                            }
                                            
                                            foreach($branchdata as $branch): 
                                            ?>
                                                <option value="<?= $branch->branch_id ?>" 
                                                    <?= (in_array($branch->branch_id, $selectedBranches)) ? 'selected' : '' ?>>
                                                    <?= $branch->branch_name ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Branch<span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <!-- Recovery Email -->
                                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <div class="field-wrapper">
                                        <input class="form-control" type="email" id="RecoveryMail_ID" name="RecoveryMail_ID" 
                                               value="<?php if(!empty($data)) echo $data[0]->RecoveryMail_ID; ?>">
                                        <div class="field-placeholder">Recovery Email ID</div>
                                    </div>
                                </div>

                                <!-- Menu and Submenu Access Section -->
                                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                    <div class="menu-access-section">
                                        <div class="menu-section-title">
                                            <i class="fa fa-list"></i>
                                            <span>Menu & Submenu Access Control</span>
                                            <div class="select-all-wrapper">
                                                <input type="checkbox" id="selectAllCheckbox">
                                                <label for="selectAllCheckbox">Select All</label>
                                            </div>
                                            <span class="selection-badge" id="selectionCounter">
                                                <i class="fa fa-check-circle"></i>
                                                <span id="selectedCount">0</span> selected
                                            </span>
                                        </div>

                                        <?php 
                                        // Get selected menus and submenus if editing
                                        $selectedMenus = isset($user_access['menus']) ? $user_access['menus'] : [];
                                        $selectedSubmenus = isset($user_access['submenus']) ? $user_access['submenus'] : [];
                                        
                                        if (!empty($menudata)): 
                                        ?>
                                            <div class="menus-grid">
                                                <?php foreach($menudata as $menu): ?>
                                                    <div class="menu-card <?= in_array($menu->MenuID, $selectedMenus) ? 'selected' : '' ?>" 
                                                         data-menu-id="<?= $menu->MenuID ?>">
                                                        <div class="menu-header">
                                                            <input type="checkbox" 
                                                                   class="menu-checkbox" 
                                                                   name="menu_ids[]" 
                                                                   value="<?= $menu->MenuID ?>" 
                                                                   id="menu_<?= $menu->MenuID ?>"
                                                                   data-menu-id="<?= $menu->MenuID ?>"
                                                                   <?= in_array($menu->MenuID, $selectedMenus) ? 'checked' : '' ?>>
                                                            <label for="menu_<?= $menu->MenuID ?>">
                                                                <?php if(!empty($menu->MenuIcon)): ?>
                                                                    <i class="<?= $menu->MenuIcon ?>"></i>
                                                                <?php endif; ?>
                                                                <span><?= $menu->MenuName ?></span>
                                                            </label>
                                                        </div>

                                                        <?php if (!empty($menu->submenus)): ?>
                                                            <div class="submenu-list">
                                                                <?php foreach($menu->submenus as $submenu): ?>
                                                                    <div class="submenu-item">
                                                                        <input type="checkbox" 
                                                                               class="submenu-checkbox" 
                                                                               name="submenu_ids[]" 
                                                                               value="<?= $submenu->SubID ?>" 
                                                                               id="submenu_<?= $submenu->SubID ?>"
                                                                               data-parent-menu="<?= $menu->MenuID ?>"
                                                                               <?= in_array($submenu->SubID, $selectedSubmenus) ? 'checked' : '' ?>>
                                                                        <label for="submenu_<?= $submenu->SubID ?>">
                                                                            <?= $submenu->SubName ?>
                                                                            <?php if(!empty($submenu->Name)): ?>
                                                                                <small><?= $submenu->Name ?></small>
                                                                            <?php endif; ?>
                                                                        </label>
                                                                    </div>
                                                                <?php endforeach; ?>
                                                            </div>
                                                        <?php else: ?>
                                                            <div class="no-submenus">No submenus available</div>
                                                        <?php endif; ?>
                                                    </div>
                                                <?php endforeach; ?>
                                            </div>
                                        <?php 
                                        else: 
                                        ?>
                                            <div class="no-menus-message">
                                                <i class="fa fa-info-circle fa-3x"></i>
                                                <p>No menus available in the system</p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <!-- Action Buttons -->
                                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 mt-3">
                                    <button type="button" class="btn mb-md-0 mb-2 btn-quarternary" id="submit" name="submit">
                                        <i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save
                                    </button>
                                    <a class="btn mb-md-0 mb-2 btn-quarternary1" href="<?=base_url()?>admin/User/index" type="button">
                                        <i class="fa-solid fa-list"></i>&nbsp;&nbsp;List
                                    </a>
                                    <button class="btn mb-md-0 mb-2 btn-quarternaryhome" type="button" 
                                            onclick="window.location.href='<?= base_url() ?>admin/User/Dashboard'">
                                        <i class="fa-solid fa-home"></i>&nbsp;&nbsp;Home
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
$(document).ready(function () {
    $('#fkBranch_Id').on('change', function () {
        let selectedValues = $(this).val();

        if (selectedValues && selectedValues.includes('select_all')) {
            let allValues = [];

            $('#fkBranch_Id option').each(function () {
                if ($(this).val() !== 'select_all') {
                    allValues.push($(this).val());
                }
            });

            $('#fkBranch_Id').val(allValues).trigger('change');
        }
    });
});
</script>

<script>
$(document).ready(function() {
    // Initialize Select2 for multiselect branch dropdown
    $('#fkBranch_Id').select2({
        placeholder: 'Select Branches',
        allowClear: true,
        width: '100%'
    });

    // Function to update selection counter
    function updateSelectionCounter() {
        const menuCount = $('.menu-checkbox:checked').length;
        const submenuCount = $('.submenu-checkbox:checked').length;
        const totalCount = menuCount + submenuCount;
        $('#selectedCount').text(totalCount);
    }

    // Function to update card styling
    function updateCardStyling(menuId) {
        const isChecked = $(`#menu_${menuId}`).is(':checked');
        $(`.menu-card[data-menu-id="${menuId}"]`).toggleClass('selected', isChecked);
    }

    // Function to update "Select All" checkbox state
    function updateSelectAllState() {
        const totalCheckboxes = $('.menu-checkbox, .submenu-checkbox').length;
        const checkedCheckboxes = $('.menu-checkbox:checked, .submenu-checkbox:checked').length;
        
        if (checkedCheckboxes === 0) {
            $('#selectAllCheckbox').prop('checked', false);
            $('#selectAllCheckbox').prop('indeterminate', false);
        } else if (checkedCheckboxes === totalCheckboxes) {
            $('#selectAllCheckbox').prop('checked', true);
            $('#selectAllCheckbox').prop('indeterminate', false);
        } else {
            $('#selectAllCheckbox').prop('checked', false);
            $('#selectAllCheckbox').prop('indeterminate', true);
        }
    }

    // Handle "Select All" checkbox
    $('#selectAllCheckbox').on('change', function() {
        const isChecked = $(this).is(':checked');
        
        // Check/uncheck all menu and submenu checkboxes
        $('.menu-checkbox, .submenu-checkbox').prop('checked', isChecked);
        
        // Update all card styling
        $('.menu-checkbox').each(function() {
            const menuId = $(this).data('menu-id');
            updateCardStyling(menuId);
        });
        
        // Update counter
        updateSelectionCounter();
    });

    // Handle menu checkbox click - check/uncheck all submenus
    $('.menu-checkbox').on('change', function() {
        const menuId = $(this).data('menu-id');
        const isChecked = $(this).is(':checked');
        
        // Check/uncheck all submenus under this menu
        $(`.submenu-checkbox[data-parent-menu="${menuId}"]`).prop('checked', isChecked);
        
        // Update card styling
        updateCardStyling(menuId);
        
        // Update counter
        updateSelectionCounter();
        
        // Update "Select All" state
        updateSelectAllState();
    });

    // Handle submenu checkbox click - auto-check parent menu if any submenu is checked
    $('.submenu-checkbox').on('change', function() {
        const menuId = $(this).data('parent-menu');
        const anySubMenuChecked = $(`.submenu-checkbox[data-parent-menu="${menuId}"]:checked`).length > 0;
        
        // Check parent menu if at least one submenu is checked
        // Uncheck parent menu if no submenus are checked
        $(`#menu_${menuId}`).prop('checked', anySubMenuChecked);
        
        // Update card styling
        updateCardStyling(menuId);
        
        // Update counter
        updateSelectionCounter();
        
        // Update "Select All" state
        updateSelectAllState();
    });

    // Form submission
    $('#submit').on('click', function(e) {
        e.preventDefault();
        
        // Validate required fields
        const userName = $('#UserName').val().trim();
        const password = $('#Password').val().trim();
        const faculty = $('#fkfaculty_ID').val();
        const role = $('#fkRole_id').val();
        const branches = $('#fkBranch_Id').val();
        const userId = $('#UserID').val();

        // Check required fields
        if (!userName) {
            Swal.fire('Error!', 'Username is required', 'error');
            return;
        }

        if (!userId && !password) {
            Swal.fire('Error!', 'Password is required for new user', 'error');
            return;
        }

        if (!faculty) {
            Swal.fire('Error!', 'Please select a faculty', 'error');
            return;
        }

        if (!role) {
            Swal.fire('Error!', 'Please select a role', 'error');
            return;
        }

        if (!branches || branches.length === 0) {
            Swal.fire('Error!', 'Please select at least one branch', 'error');
            return;
        }

        // Check if at least one menu or submenu is selected
        const menuSelected = $('.menu-checkbox:checked').length > 0;
        const submenuSelected = $('.submenu-checkbox:checked').length > 0;

        if (!menuSelected && !submenuSelected) {
            Swal.fire({
                icon: 'warning',
                title: 'No Access Selected',
                text: 'Please select at least one menu or submenu for user access',
                confirmButtonText: 'OK'
            });
            return;
        }

        // Serialize form data
        const formData = $('#UserForm').serialize();
        const url = userId ? '<?= base_url() ?>admin/User/updateUser' : '<?= base_url() ?>admin/User/insertUser';

        // Show loading
        Swal.fire({
            title: 'Processing...',
            text: 'Please wait',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        // AJAX request
        $.ajax({
            url: url,
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success!',
                        text: response.message,
                        showConfirmButton: false,
                        timer: 1500
                    }).then(() => {
                        window.location.href = '<?= base_url() ?>admin/User/index';
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: response.message || 'Something went wrong'
                    });
                }
            },
            error: function(xhr, status, error) {
                console.error('Error:', error);
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: 'Something went wrong. Please try again.'
                });
            }
        });
    });

    // Initialize on page load - check parent menus if submenus are already checked
    $('.submenu-checkbox:checked').each(function() {
        const menuId = $(this).data('parent-menu');
        $(`#menu_${menuId}`).prop('checked', true);
        updateCardStyling(menuId);
    });

    // Initialize selection counter and "Select All" state
    updateSelectionCounter();
    updateSelectAllState();
});
</script>