<style>
    .file-upload-cell {
        position: relative;
        width: 120px;
    }
    .file-input {
        position: absolute;
        opacity: 0;
        width: 100%;
        height: 100%;
        cursor: pointer;
    }
    .file-label {
        display: inline-block;
        background: #007bff;
        color: white;
        padding: 5px 10px;
        border-radius: 4px;
        cursor: pointer;
        font-size: 12px;
        text-align: center;
        width: 100px;
    }
    .file-label:hover {
        background: #0056b3;
    }
    .file-name {
        font-size: 10px;
        color: #666;
        margin-top: 2px;
        word-break: break-word;
    }
    .file-remove {
        color: red;
        cursor: pointer;
        font-size: 10px;
        margin-left: 5px;
    }
    .wide-th {
        width: 200px !important;  
    }
    .total-row {
        background-color: #f8f9fa;
        font-weight: bold;
        border-top: 2px solid #dee2e6;
    }
    .total-row td {
        padding: 12px 8px !important;
        font-size: 14px;
    }
    .total-amount {
        color: #28a745;
        font-size: 16px;
        font-weight: 600;
    }

    
   /* Select2 ko normal dropdown jaisa banao */
.select2-container .select2-selection--single {
    height: 38px !important;
    border: 1px solid #ced4da !important;
    border-radius: 4px !important;
}
 
.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 36px !important;
    padding-left: 12px !important;
    color: #495057 !important;
    padding: 2px;
}
 
.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 36px !important;
    right: 8px !important;
}
 
.select2-container--default .select2-selection--single .select2-selection__arrow b {
    border-color: #495057 transparent transparent transparent !important;
}
 
/* Dropdown menu styling */
.select2-dropdown {
    border: 1px solid #ced4da !important;
    border-radius: 4px !important;
}
 
.select2-container--default .select2-results__option--highlighted[aria-selected] {
    background-color: #007bff !important;
    color: white !important;
}
 
.select2-search--dropdown .select2-search__field {
    border: 1px solid #ced4da !important;
    border-radius: 4px !important;
    padding: 6px 12px !important;
}
 
/* Focus state */
.select2-container--default.select2-container--focus .select2-selection--single {
    border-color: #80bdff !important;
    outline: 0 !important;
    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25) !important;
}

/* Select2 container width */
.select2-container {
    width: 100% !important;
}
</style>
</style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>

<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1" >Value Addition Program (VAP)</div>
                    </div>
                    <div class="card-body">
                        <form role="form" id="Form" action="" method="post" enctype="multipart/form-data">
                        <div class="row gutters">
                            <input type="hidden" id="vap_id" name="vap_id"
                                   class="hiddenId" style="width: 40px !important;height: 40px;"
                                   value="<?php echo isset($mainData->vap_id) ? $mainData->vap_id : ''; ?>">
                                   
                                   <!-- hidden submenuid -->
<input class="form-control" id="fk_submenuId" name="fk_submenuId" type="hidden"
                           value="<?= isset($subId) ? $subId : '' ?>"  />
                           
                            <?php if(empty($record)): ?>
                            <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                <label for="excel_file" class="form-label">Import Excel</label>
                                <div class="card" id="studentCard"
                                     style="height: 120px; width: 60%; cursor: pointer; padding: 10px;
                                            border: 2px dashed black; text-align: center; display: flex;
                                            flex-direction: column; justify-content: flex-start; align-items: center;
                                            position: relative; overflow: hidden;"
                                     onclick="document.getElementById('excel_file').click();">
                                    <img src="<?= base_url('Assets/img/excel.png'); ?>" id="studentImg"
                                         style="max-height: 50px; object-fit: contain; margin-bottom: 5px;">
                                    <span id="studentFileText" style="font-size: 11px; color: black; font-weight:600;">
                                        (<span class="text-danger">*</span>File extension allowed: .xls .xlsx)
                                    </span>
                                    <input type="file" accept=".xls,.xlsx" style="display: none;"
                                           class="form-control form-control-sm"
                                           id="excel_file" name="excel_file">
                                </div>
                                <?php if (!empty($mainData->excel_file)): ?>
                                    <p class="mt-2">Uploaded File: <b><?= $mainData->excel_file ?></b></p>
                                <?php endif; ?>
                                <button class="btn btn-success btn-sm m-1" type="button" id="btnShow" style="padding: px 10px;font-size: 13px;"><i class="fas fa-search"></i> Show Excel Data</button>
                            </div>

                            <div class="row">
                                <div class="col-md-12 text-end mt-3">
                                   <a href="<?= base_url('uploads/formatexcel/VAP.xlsx'); ?>"
                                   download
                                   style="color: #0b0a0aff; text-decoration: underline; font-weight: 600; font-size:14px;">
                                   <i class="fas fa-file-excel" style="color: green; margin-right: 6px; font-size:16px;"></i>
                                   Download Excel Format
                                   </a>
                                </div>
                            </div>
                            <?php endif; ?>

                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-3 col-12">
                                <div class="table-responsive mt-3" id="printableTable">
                                   <div class="float-end mb-2">
                                     <?php if (!empty($mainData) && empty($record)): ?>
                                        <button class="btn btn-danger btn-sm m-1" type="button" id="btnClearAll" style="padding: px 10px;font-size: 13px;">
                                            <i class="fas fa-times"></i> Clear All
                                        </button>
                                     <?php endif; ?>
                                   </div>

                                    <table id="leavetable" class="table custom-table">
                                        <thead style="background-color: #1273eb;">
                                            <tr>
                                                <th class=".w-auto">Sr.No.</th>
                                                <th style=" min-width:200px;">PRN</th>
                                                <th style=" min-width:280px;">Student Name</th>
                                                <th style=" min-width:250px;">Branch</th>
                                                <th style=" min-width:200px;">Class</th>
                                                <th style=" min-width:180px;">Divsion</th>
                                                <th style=" min-width:260px;">VAP Title</th>
                                                <th style=" min-width:260px;">Resoure Of Person Name</th>
                                                <th style=" min-width:250px;">Resoure Of Person Contact</th>
                                                <th style=" min-width:200px;">Company</th>
                                                <th style=" min-width:200px;">Address</th>
                                                <th style=" min-width:150px;">Year</th>
                                                <th style=" min-width:180px;">VAP Start Date</th>
                                                <th style=" min-width:180px;">VAP End Date</th>
                                                <th style=" min-width:300px;">Photo URL</th>
                                                <th style=" min-width:200px;">Feedback</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                       <?php
// VAP_view.php में tbody section को replace करें
$isUpdate = isset($record) && !empty($record);
?>

<tbody id="tableBody">
<?php if($isUpdate): ?>
    <tr>
        <td>1</td>
        <td><input type="text" name="prn" class="form-control" value="<?= $record->prn ?? '' ?>"></td>
        <td><input type="text" name="student_name" class="form-control" value="<?= $record->Student_name ?? '' ?>"></td>
        
        <td>
            <select name="branch_id" class="form-control select2-dropdown">
                <option value="">Select Department/Branch</option>
                <?php foreach($branchdata as $branch): ?>
                    <option value="<?= $branch->branch_id ?>" 
                        <?= ($branch->branch_id == $record->fkbranch_id) ? 'selected' : '' ?>>
                        <?= $branch->branch_name ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </td>
        
        <td>
            <select name="class_id" class="form-control select2-dropdown">
                <option value="">Select Class</option>
                <?php foreach($classdata as $class): ?>
                    <option value="<?= $class->class_id ?>" 
                        <?= ($class->class_id == $record->fkclass_id) ? 'selected' : '' ?>>
                        <?= $class->classname ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </td>

        <td><input type="text" name="division" class="form-control" value="<?= $record->Division ?? '' ?>"></td>
        <td><input type="text" name="vap_title" class="form-control" value="<?= $record->Vap_tittle ?? '' ?>"></td>
        <td><input type="text" name="resource_person_name" class="form-control" value="<?= $record->resource_person_name ?? '' ?>"></td>
        <td><input type="text" name="resource_person_contact" class="form-control" value="<?= $record->resource_person_contact ?? '' ?>"></td>
        
        <td>
            <select name="company_id" class="form-control select2-dropdown">
                <option value="">Select Company</option>
                <?php foreach($companydata as $company): ?>
                    <option value="<?= $company->ID ?>" 
                        <?= ($company->ID == $record->Company_name) ? 'selected' : '' ?>>
                        <?= $company->comp_name ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </td>
        
        <td><input type="text" name="address" class="form-control" value="<?= $record->Address ?? '' ?>"></td>
        
        <td>
            <select name="year" class="form-control select2-dropdown">
                <option value="">Select Year</option>
                <?php foreach($yeardata as $year): ?>
                    <option value="<?= $year->finiYear_id ?>" 
                        <?= ($year->finiYear_id == $record->finicial_Year) ? 'selected' : '' ?>>
                        <?= $year->fini_Label ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </td>
        
        <td><input type="date" name="vap_start_date" class="form-control" value="<?= $record->Vap_Start ?? '' ?>"></td>
        <td><input type="date" name="vap_end_date" class="form-control" value="<?= $record->Vap_End ?? '' ?>"></td>
        <td><input type="text" name="photo_url" class="form-control" value="<?= $record->Photo_Url ?? '' ?>"></td>
        
        <!-- Feedback Column -->
        <td>
            <div class="file-upload-cell">
                <input type="hidden" name="existing_feedback" value="<?= $record->Feedback ?? '' ?>">
                <input type="file" name="feedback" class="file-input" accept=".pdf,.doc,.docx,.jpg,.jpeg,.png" onchange="handleFileSelectUpdate(this)">
                <label class="file-label">Choose File</label>
                <div class="file-name" id="feedback_name_update"></div>
            </div>
            <?php if(!empty($record->Feedback)): ?>
                <a href="<?= base_url('uploads/feedback/' . $record->Feedback) ?>" target="_blank">
                    <span style="color: #007bff; font-size: 12px;">
                        <i class="fas fa-file-pdf text-danger"></i> <?= substr($record->Feedback, 0, 15) ?>...
                    </span>
                </a>
            <?php endif; ?>
        </td>

        <td>
            <button type="button" class="btn text-danger btn-sm removeRow" disabled>
                <i class="fa-solid fa-trash"></i>
            </button>
        </td>
    </tr>
<?php endif; ?>
</tbody>
                                    </table>
                                   <div class="float-end">
                                    <?php if(empty($record)): ?>
                                     <button type="button" class="btn btn-success btn-sm p-2 rounded-3" id="addRowBtn" style="font-size:13px; font-weight:600;"><i class="fa-solid fa-plus  bg-white p-1 rounded-circle text-success shadow-lg me-2" style=" box-shadow: 4px 6px 12px rgba(0, 0, 0, 0.5) !important;"></i>Add Row</button>
                                      <?php endif; ?>
                                   </div>
                                </div>
                            </div>

                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 mt-3">
                                <button type="button" class="btn mb-md-0 mb-2 btn-quarternary" id="submit" name="submit" type="button"><i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save</button>
                                <a class="btn mb-md-0 mb-2 btn-quarternary1" href="<?=base_url()?>admin/VAP/index" type="button"><i class="fa-solid fa-list"></i>&nbsp;&nbsp;List</a>
                                <button class="btn mb-md-0 mb-2 btn-quarternaryhome" type="button"  onclick="window.location.href='<?= base_url() ?>admin/VAP/Dashboard'" ><i class="fa-solid fa-home"></i>&nbsp;&nbsp;Home</button><br>
                            </div>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Hidden data for JavaScript -->
<script type="text/javascript">
var branchOptions = <?= json_encode($branchdata ?? []) ?>;
var classOptions = <?= json_encode($classdata ?? []) ?>;
var companyOptions = <?= json_encode($companydata ?? []) ?>;
var yearOptions = <?= json_encode($yeardata ?? []) ?>;
</script>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<!-- Select2 JS -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
// Select2 ko open karne par search field par focus
$(document).ready(function() {
    $(document).on('select2:open', () => {
        setTimeout(() => {
            document.querySelector('.select2-search__field').focus();
        }, 0);
    });
});
</script>

<script>
$(document).ready(function () {
    let rowCount = <?= !empty($childData) ? count($childData) : 0 ?>;
    
    // Track new master data
    let newBranches = [];
    let newClasses = [];
    let newCompanies = [];
    let newYears = [];
    let excelData = [];

    // Initialize Select2 for all existing dropdowns
    function initializeSelect2() {
        $('.select2-dropdown').select2({
            placeholder: "Select an option",
            allowClear: false,
            width: '100%'
        });
    }
    
     initializeSelect2();

    // ✅ FIX: Add one default row ONLY in add mode (when no record exists for update)
    <?php if(empty($record)): ?>
    if ($("#tableBody tr").length === 0) {
        let newRowHtml = addRow();
        $("#tableBody").html(newRowHtml);
        initializeSelect2();
    }
    <?php endif; ?>

    // initializeSelect2();

    // if (rowCount === 0 && $("#tableBody tr").length === 0) {
    //     addRow();
    // }

    window.handleFileSelectExisting = function(input, type, rowIndex) {
        let fileName = input.files[0] ? input.files[0].name : '';
        let nameDiv = document.getElementById(type + '_name_' + rowIndex);
        if (nameDiv && fileName) {
            nameDiv.innerHTML = fileName;
        }
    };

    window.handleFileSelectNew = function(input, type, uniqueId) {
        let fileName = input.files[0] ? input.files[0].name : '';
        let nameDiv = document.getElementById(type + '_name_' + uniqueId);
        if (nameDiv && fileName) {
            nameDiv.innerHTML = fileName + '<span class="file-remove" onclick="removeFileNew(this, \'' + type + '\', \'' + uniqueId + '\')">✕</span>';
        }
    };

    window.removeFileNew = function(element, type, uniqueId) {
        let row = element.closest('tr');
        let fileInput = row.querySelector('input[name="' + type + '[]"]');
        let nameDiv = document.getElementById(type + '_name_' + uniqueId);
        if (fileInput) fileInput.value = '';
        if (nameDiv) nameDiv.innerHTML = '';
    };

    function formatExcelDate(dateValue) {
        if (!dateValue) return "";
        
        try {
            let date;
            
            if (dateValue instanceof Date) {
                date = dateValue;
            } else if (typeof dateValue === 'number' && dateValue > 0) {
                date = new Date((dateValue - 25569) * 86400 * 1000);
            } else if (typeof dateValue === 'string') {
                let cleanDate = dateValue.trim();
                
                if (cleanDate.match(/^\d{1,2}[\/\-]\d{1,2}[\/\-]\d{4}$/)) {
                    let parts = cleanDate.split(/[\/\-]/);
                    date = new Date(parts[2], parts[1] - 1, parts[0]);
                } else if (cleanDate.match(/^\d{4}[\/\-]\d{1,2}[\/\-]\d{1,2}$/)) {
                    date = new Date(cleanDate);
                } else {
                    date = new Date(cleanDate);
                }
            } else {
                return "";
            }
            
            if (!isNaN(date.getTime())) {
                let year = date.getFullYear();
                let month = String(date.getMonth() + 1).padStart(2, '0');
                let day = String(date.getDate()).padStart(2, '0');
                return `${year}-${month}-${day}`;
            }
        } catch (e) {
            console.warn("Date conversion error:", e, "for value:", dateValue);
        }
        
        return "";
    }

    function findBranchByName(branchName) {
        if (!branchName || typeof branchOptions === 'undefined') return { id: '', name: branchName };
        let name = branchName.toString().trim().toLowerCase();
        for (let i = 0; i < branchOptions.length; i++) {
            if (branchOptions[i].branch_name.toLowerCase() === name) {
                return { id: branchOptions[i].branch_id, name: branchOptions[i].branch_name };
            }
        }
        return { id: '', name: branchName.toString().trim() };
    }

    function findClassByName(className) {
        if (!className || typeof classOptions === 'undefined') return { id: '', name: className };
        let name = className.toString().trim().toLowerCase();
        for (let i = 0; i < classOptions.length; i++) {
            if (classOptions[i].classname.toLowerCase() === name) {
                return { id: classOptions[i].class_id, name: classOptions[i].classname };
            }
        }
        return { id: '', name: className.toString().trim() };
    }

    function findCompanyByName(companyName) {
        if (!companyName || typeof companyOptions === 'undefined') return { id: '', name: companyName };
        let name = companyName.toString().trim().toLowerCase();
        for (let i = 0; i < companyOptions.length; i++) {
            if (companyOptions[i].comp_name.toLowerCase() === name) {
                return { id: companyOptions[i].ID, name: companyOptions[i].comp_name };
            }
        }
        return { id: '', name: companyName.toString().trim() };
    }

    function findYearByName(yearName) {
        if (!yearName || typeof yearOptions === 'undefined') return { id: '', name: yearName };
        let name = yearName.toString().trim().toLowerCase();
        for (let i = 0; i < yearOptions.length; i++) {
            if (yearOptions[i].fini_Label.toLowerCase() === name) {
                return { id: yearOptions[i].finiyear_id, name: yearOptions[i].fini_Label };
            }
        }
        return { id: '', name: yearName.toString().trim() };
    }

    function addRow(
        prn = "", 
        student_name = "", 
        branch_id = "",
        branch_name = "",
        class_id = "",
        classname = "",
        division = "", 
        vap_title = "", 
        resource_person_name = "", 
        resource_person_contact = "", 
        company_id = "",
        company_name = "",
        address = "", 
        year_id = "",
        year_name = "",
        vap_start_date = "", 
        vap_end_date = "", 
        photo_url = ""
    ) {
        rowCount++;
        let uniqueId = Date.now() + '_' + rowCount;
        
        let branchDropdown = '<option value="">Select Branch</option>';
        if (branchOptions && branchOptions.length > 0) {
            branchOptions.forEach(function(branch) {
                let selected = (branch.branch_id == branch_id) ? 'selected' : '';
                branchDropdown += `<option value="${branch.branch_id}" ${selected}>${branch.branch_name}</option>`;
            });
        }
        if (branch_name && !branch_id) {
            branchDropdown += `<option value="NEW::${branch_name}" selected>${branch_name}</option>`;
        }
        
        let classDropdown = '<option value="">Select Class</option>';
        if (classOptions && classOptions.length > 0) {
            classOptions.forEach(function(cls) {
                let selected = (cls.class_id == class_id) ? 'selected' : '';
                classDropdown += `<option value="${cls.class_id}" ${selected}>${cls.classname}</option>`;
            });
        }
        if (classname && !class_id) {
            classDropdown += `<option value="NEW::${classname}" selected>${classname}</option>`;
        }
        
        let companyDropdown = '<option value="">Select Company</option>';
        if (companyOptions && companyOptions.length > 0) {
            companyOptions.forEach(function(company) {
                let selected = (company.ID == company_id) ? 'selected' : '';
                companyDropdown += `<option value="${company.ID}" ${selected}>${company.comp_name}</option>`;
            });
        }
        if (company_name && !company_id) {
            companyDropdown += `<option value="NEW::${company_name}" selected>${company_name}</option>`;
        }
        
        let yearDropdown = '<option value="">Select Year</option>';
        if (yearOptions && yearOptions.length > 0) {
            yearOptions.forEach(function(yr) {
                let selected = (yr.finiyear_id == year_id) ? 'selected' : '';
                yearDropdown += `<option value="${yr.finiyear_id}" ${selected}>${yr.fini_Label}</option>`;
            });
        }
        if (year_name && !year_id) {
            yearDropdown += `<option value="NEW::${year_name}" selected>${year_name}</option>`;
        }
        
        return `
            <tr data-row-id="${uniqueId}">
                <td>${rowCount}</td>
                <td><input type="text" name="prn[]" class="form-control" value="${prn}"></td>
                <td><input type="text" name="student_name[]" class="form-control" value="${student_name}"></td>
                <td><select name="branch_id[]" class="form-control select2-dropdown">${branchDropdown}</select></td>
                <td><select name="class_id[]" class="form-control select2-dropdown">${classDropdown}</select></td>
                <td><input type="text" name="division[]" class="form-control" value="${division}"></td>
                <td><input type="text" name="vap_title[]" class="form-control" value="${vap_title}"></td>
                <td><input type="text" name="resource_person_name[]" class="form-control" value="${resource_person_name}"></td>
                <td><input type="text" name="resource_person_contact[]" class="form-control" value="${resource_person_contact}"></td>
                <td><select name="company_id[]" class="form-control select2-dropdown">${companyDropdown}</select></td>
                <td><input type="text" name="address[]" class="form-control" value="${address}"></td>
                <td><select name="year[]" class="form-control select2-dropdown">${yearDropdown}</select></td>
                <td><input type="date" name="vap_start_date[]" class="form-control" value="${vap_start_date}"></td>
                <td><input type="date" name="vap_end_date[]" class="form-control" value="${vap_end_date}"></td>
                <td><input type="text" name="photo_url[]" class="form-control" value="${photo_url}"></td>
                <td>
                    <div class="file-upload-cell">
                        <input type="hidden" name="existing_feedback[]" value="">
                        <input type="file" name="feedback[]" class="file-input" accept=".pdf,.doc,.docx,.jpg,.jpeg,.png" onchange="handleFileSelectNew(this, 'feedback', '${uniqueId}')">
                        <label class="file-label">Choose File</label>
                        <div class="file-name" id="feedback_name_${uniqueId}"></div>
                    </div>
                </td>
                <td>
                    <button type="button" class="btn text-danger btn-sm removeRow">
                        <i class="fa-solid fa-trash"></i>
                    </button>
                </td>
            </tr>`;
    }

    function batchRenderRows(rowsHtml) {
        $("#tableBody").html(rowsHtml);
        initializeSelect2();
    }

    $("#addRowBtn").click(function () {
        let newRowHtml = addRow();
        $("#tableBody").append(newRowHtml);
        initializeSelect2();
    });

    $(document).on('click', '.removeRow', function() {
        if ($("#tableBody tr").length > 1) {
            $(this).closest('tr').remove();
            updateRowNumbers();
        } else {
            Swal.fire('Warning', 'At least one row is required!', 'warning');
        }
    });

    function updateRowNumbers() {
        $("#tableBody tr").each(function(index) {
            $(this).find('td:first').text(index + 1);
        });
        rowCount = $("#tableBody tr").length;
    }

    $("#btnClearAll").click(function () {
        Swal.fire({
            title: 'Are you sure?',
            text: 'This will clear all table data!',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, clear all!'
        }).then((result) => {
            if (result.isConfirmed) {
                $("#tableBody").empty();
                rowCount = 0;
                newBranches = [];
                newClasses = [];
                newCompanies = [];
                newYears = [];
                excelData = [];
                let newRowHtml = addRow();
                $("#tableBody").html(newRowHtml);
                initializeSelect2();
                Swal.fire('Cleared!', 'All table data has been cleared.', 'success');
            }
        });
    });

    $("#btnShow").click(function () {
        if (typeof XLSX === 'undefined') {
            Swal.fire("Error", "Excel processing library not loaded.", "error");
            return;
        }

        let file = $("#excel_file")[0].files[0];
        if (!file) {
            Swal.fire("Error", "Please select an Excel file first!", "error");
            return;
        }

        if (!file.name.toLowerCase().match(/\.(xlsx|xls)$/)) {
            Swal.fire("Error", "Please select a valid Excel file (.xls or .xlsx)", "error");
            return;
        }

        Swal.fire({
            title: 'Processing Excel...',
            html: 'Please wait while we load your data',
            allowOutsideClick: false,
            allowEscapeKey: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        let reader = new FileReader();
        reader.onload = function (e) {
            try {
                let data = e.target.result;
                let workbook = XLSX.read(data, { 
                    type: "binary",
                    cellText: false,
                    cellDates: true,
                    dateNF: 'dd/mm/yyyy'
                });
                
                let firstSheet = workbook.Sheets[workbook.SheetNames[0]];
                let jsonData = XLSX.utils.sheet_to_json(firstSheet, { 
                    header: 1,
                    defval: "",
                    blankrows: false,
                    raw: false
                });

                console.log("Excel Data:", jsonData);

                if (jsonData.length < 2) {
                    Swal.fire("Error", "Excel file must contain data rows!", "error");
                    return;
                }

                $("#tableBody").empty();
                rowCount = 0;
                newBranches = [];
                newClasses = [];
                newCompanies = [];
                newYears = [];
                excelData = [];

                let rowsHtmlArray = [];

                for (let i = 1; i < jsonData.length; i++) {
                    let row = jsonData[i];
                    
                    if (!row || row.length === 0) continue;

                    let prn = (row[0] || "").toString().trim();
                    
                    if (!prn || prn === '') {
                        console.log(`Row ${i}: Skipping - No PRN`);
                        continue;
                    }
                    
                    let student_name = (row[1] || "").toString().trim();
                    let branch_name_excel = (row[2] || "").toString().trim();
                    let classname_excel = (row[3] || "").toString().trim();
                    let division = (row[4] || "").toString().trim();
                    let vap_title = (row[5] || "").toString().trim();
                    let resource_person_name = (row[6] || "").toString().trim();
                    let resource_person_contact = (row[7] || "").toString().trim();
                    let company_name_excel = (row[8] || "").toString().trim();
                    let address = (row[9] || "").toString().trim();
                    let year_name_excel = (row[10] || "").toString().trim();
                    let vap_start_date = formatExcelDate(row[11]);
                    let vap_end_date = formatExcelDate(row[12]);
                    let photo_url = (row[13] || "").toString().trim();
                    
                    let branch = findBranchByName(branch_name_excel);
                    let cls = findClassByName(classname_excel);
                    let company = findCompanyByName(company_name_excel);
                    let year = findYearByName(year_name_excel);
                    
                    if (!branch.id && branch.name && newBranches.indexOf(branch.name) === -1) {
                        newBranches.push(branch.name);
                    }
                    if (!cls.id && cls.name && newClasses.indexOf(cls.name) === -1) {
                        newClasses.push(cls.name);
                    }
                    if (!company.id && company.name && newCompanies.indexOf(company.name) === -1) {
                        newCompanies.push(company.name);
                    }
                    if (!year.id && year.name && newYears.indexOf(year.name) === -1) {
                        newYears.push(year.name);
                    }
                    
                    excelData.push({
                        prn: prn,
                        student_name: student_name,
                        branch_id: branch.id,
                        branch_name: branch.name,
                        class_id: cls.id,
                        classname: cls.name,
                        division: division,
                        vap_title: vap_title,
                        resource_person_name: resource_person_name,
                        resource_person_contact: resource_person_contact,
                        company_id: company.id,
                        company_name: company.name,
                        address: address,
                        year_id: year.id,
                        year_name: year.name,
                        vap_start_date: vap_start_date,
                        vap_end_date: vap_end_date,
                        photo_url: photo_url
                    });
                    
                    let rowHtml = addRow(
                        prn,
                        student_name,
                        branch.id,
                        branch.name,
                        cls.id,
                        cls.name,
                        division,
                        vap_title,
                        resource_person_name,
                        resource_person_contact,
                        company.id,
                        company.name,
                        address,
                        year.id,
                        year.name,
                        vap_start_date,
                        vap_end_date,
                        photo_url
                    );
                    
                    rowsHtmlArray.push(rowHtml);
                }

                if (rowsHtmlArray.length === 0) {
                    Swal.fire("Warning", "No valid data found!", "warning");
                    let newRowHtml = addRow();
                    $("#tableBody").html(newRowHtml);
                    initializeSelect2();
                    return;
                }

                batchRenderRows(rowsHtmlArray.join(''));

                let message = `Excel data imported successfully! ${rowsHtmlArray.length} rows added.`;
                if (newBranches.length > 0 || newClasses.length > 0 || newCompanies.length > 0 || newYears.length > 0) {
                    message += `<br><br><b>New master data will be created:</b>`;
                    if (newBranches.length > 0) message += `<br>- Branches: ${newBranches.join(', ')}`;
                    if (newClasses.length > 0) message += `<br>- Classes: ${newClasses.join(', ')}`;
                    if (newCompanies.length > 0) message += `<br>- Companies: ${newCompanies.join(', ')}`;
                    if (newYears.length > 0) message += `<br>- Years: ${newYears.join(', ')}`;
                }
                
                Swal.fire({
                    icon: 'success',
                    title: 'Success',
                    html: message
                });

            } catch (error) {
                console.error("Excel processing error:", error);
                Swal.fire("Error", "Failed to process Excel file: " + error.message, "error");
            }
        };
        
        reader.onerror = function(error) {
            console.error("File reading error:", error);
            Swal.fire("Error", "Failed to read Excel file!", "error");
        };
        
        reader.readAsBinaryString(file);
    });

    // ✅ OPTIMIZED SUBMIT - Send data as JSON instead of FormData
    $("#submit").click(function(e) {
    e.preventDefault();
    
    let vap_id = $("#vap_id").val();
    let isUpdate = vap_id && vap_id.trim() !== '';
    
    if ($("#tableBody tr").length === 0) {
        Swal.fire('Validation Error', 'Please add at least one record!', 'error');
        return;
    }

    let hasValidRow = false;
    
    if (isUpdate) {
        // Update mode - check single fields
        let prn = $('input[name="prn"]').val();
        if (prn && prn.trim() !== '') {
            hasValidRow = true;
        }
    } else {
        // Insert mode - check array fields
        $("#tableBody tr").each(function() {
            let prn = $(this).find('input[name="prn[]"]').val();
            if (prn && prn.trim() !== '') {
                hasValidRow = true;
                return false;
            }
        });
    }

    if (!hasValidRow) {
        Swal.fire('Validation Error', 'Please enter at least one valid PRN!', 'error');
        return;
    }

    // Collect new master data for both modes
    newBranches = [];
    newClasses = [];
    newCompanies = [];
    newYears = [];

    if (isUpdate) {
        // Update mode - check single select fields
        let branchVal = $('select[name="branch_id"]').val();
        if (branchVal && branchVal.startsWith('NEW::')) {
            let newName = branchVal.replace('NEW::', '');
            if (newName) newBranches.push(newName);
        }

        let classVal = $('select[name="class_id"]').val();
        if (classVal && classVal.startsWith('NEW::')) {
            let newName = classVal.replace('NEW::', '');
            if (newName) newClasses.push(newName);
        }

        let companyVal = $('select[name="company_id"]').val();
        if (companyVal && companyVal.startsWith('NEW::')) {
            let newName = companyVal.replace('NEW::', '');
            if (newName) newCompanies.push(newName);
        }

        let yearVal = $('select[name="year"]').val();
        if (yearVal && yearVal.startsWith('NEW::')) {
            let newName = yearVal.replace('NEW::', '');
            if (newName) newYears.push(newName);
        }
    } else {
        // Insert mode - check array select fields
        $('select[name="branch_id[]"]').each(function() {
            let val = $(this).val();
            if (val && val.startsWith('NEW::')) {
                let newName = val.replace('NEW::', '');
                if (newName && newBranches.indexOf(newName) === -1) {
                    newBranches.push(newName);
                }
            }
        });

        $('select[name="class_id[]"]').each(function() {
            let val = $(this).val();
            if (val && val.startsWith('NEW::')) {
                let newName = val.replace('NEW::', '');
                if (newName && newClasses.indexOf(newName) === -1) {
                    newClasses.push(newName);
                }
            }
        });

        $('select[name="company_id[]"]').each(function() {
            let val = $(this).val();
            if (val && val.startsWith('NEW::')) {
                let newName = val.replace('NEW::', '');
                if (newName && newCompanies.indexOf(newName) === -1) {
                    newCompanies.push(newName);
                }
            }
        });

        $('select[name="year[]"]').each(function() {
            let val = $(this).val();
            if (val && val.startsWith('NEW::')) {
                let newName = val.replace('NEW::', '');
                if (newName && newYears.indexOf(newName) === -1) {
                    newYears.push(newName);
                }
            }
        });
    }

    submitForm(isUpdate);
});

function submitForm(isUpdate = false) {
    let formData = new FormData();
    
    if (isUpdate) {
        // ✅ UPDATE MODE - Single field values
        formData.append('vap_id', $("#vap_id").val());
        formData.append('prn', $('input[name="prn"]').val() || '');
        formData.append('student_name', $('input[name="student_name"]').val() || '');
        formData.append('branch_id', $('select[name="branch_id"]').val() || '');
        formData.append('class_id', $('select[name="class_id"]').val() || '');
        formData.append('division', $('input[name="division"]').val() || '');
        formData.append('vap_title', $('input[name="vap_title"]').val() || '');
        formData.append('resource_person_name', $('input[name="resource_person_name"]').val() || '');
        formData.append('resource_person_contact', $('input[name="resource_person_contact"]').val() || '');
        formData.append('company_id', $('select[name="company_id"]').val() || '');
        formData.append('address', $('input[name="address"]').val() || '');
        formData.append('year', $('select[name="year"]').val() || '');
        formData.append('vap_start_date', $('input[name="vap_start_date"]').val() || '');
        formData.append('vap_end_date', $('input[name="vap_end_date"]').val() || '');
        formData.append('photo_url', $('input[name="photo_url"]').val() || '');
        formData.append('existing_feedback', $('input[name="existing_feedback"]').val() || '');
        
        // Feedback file for update
        let feedbackFile = $('input[name="feedback"]')[0];
        if (feedbackFile && feedbackFile.files.length > 0) {
            formData.append('feedback', feedbackFile.files[0]);
        }
        
    } else {
        // ✅ INSERT MODE - Array values as JSON
        let tableData = [];
        let feedbackFiles = [];
        
        $("#tableBody tr").each(function(index) {
            let $row = $(this);
            
            tableData.push({
                prn: $row.find('input[name="prn[]"]').val() || '',
                student_name: $row.find('input[name="student_name[]"]').val() || '',
                branch_id: $row.find('select[name="branch_id[]"]').val() || '',
                class_id: $row.find('select[name="class_id[]"]').val() || '',
                division: $row.find('input[name="division[]"]').val() || '',
                vap_title: $row.find('input[name="vap_title[]"]').val() || '',
                resource_person_name: $row.find('input[name="resource_person_name[]"]').val() || '',
                resource_person_contact: $row.find('input[name="resource_person_contact[]"]').val() || '',
                company_id: $row.find('select[name="company_id[]"]').val() || '',
                address: $row.find('input[name="address[]"]').val() || '',
                year: $row.find('select[name="year[]"]').val() || '',
                vap_start_date: $row.find('input[name="vap_start_date[]"]').val() || '',
                vap_end_date: $row.find('input[name="vap_end_date[]"]').val() || '',
                photo_url: $row.find('input[name="photo_url[]"]').val() || '',
                existing_feedback: $row.find('input[name="existing_feedback[]"]').val() || ''
            });
            
            let feedbackFile = $row.find('input[name="feedback[]"]')[0];
            if (feedbackFile && feedbackFile.files.length > 0) {
                feedbackFiles.push({index: index, file: feedbackFile.files[0]});
            }
        });

        formData.append('table_data', JSON.stringify(tableData));
        
        // Feedback files with index mapping
        feedbackFiles.forEach(function(item) {
            formData.append('feedback_' + item.index, item.file);
        });
        formData.append('feedback_indices', JSON.stringify(feedbackFiles.map(f => f.index)));
    }

    // Common fields for both modes
    formData.append('new_branches', JSON.stringify(newBranches));
    formData.append('new_classes', JSON.stringify(newClasses));
    formData.append('new_companies', JSON.stringify(newCompanies));
    formData.append('new_years', JSON.stringify(newYears));
    formData.append('fk_submenuId', $("#fk_submenuId").val());
    
    // Excel file
    let excelFileInput = document.getElementById('excel_file');
    if (excelFileInput && excelFileInput.files.length > 0) {
        formData.append('excel_file', excelFileInput.files[0]);
    }

    let submitUrl = isUpdate ? 
        '<?= base_url() ?>admin/VAP/updateVAP' : 
        '<?= base_url() ?>admin/VAP/insertvap';

    Swal.fire({
        title: isUpdate ? 'Updating...' : 'Saving...',
        html: 'Please wait while we process your data',
        allowOutsideClick: false,
        allowEscapeKey: false,
        customClass: {
            popup: 'custom-swal-popup',
            icon: 'custom-swal-icon',
            title: 'custom-swal-title',
            htmlContainer: 'custom-swal-text'
        },
        didOpen: () => {
            Swal.showLoading();
        }
    });

    $.ajax({
        url: submitUrl,
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function(response) {
            console.log("Server response:", response);
            try {
                let result = typeof response === 'string' ? JSON.parse(response) : response;
                
                if (result.status === 'success') {
                    let message = result.message;
                    if (result.masters_created) {
                        let mc = result.masters_created;
                        if (mc.branches > 0 || mc.classes > 0 || mc.companies > 0 || mc.years > 0) {
                            message += '<br><br><b>New master data created:</b>';
                            if (mc.branches > 0) message += `<br>- ${mc.branches} branch(es)`;
                            if (mc.classes > 0) message += `<br>- ${mc.classes} class(es)`;
                            if (mc.companies > 0) message += `<br>- ${mc.companies} company(ies)`;
                            if (mc.years > 0) message += `<br>- ${mc.years} year(s)`;
                        }
                    }
                    
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: '<strong>Success!</strong>',
                        html: message,
                        showConfirmButton: false,
                        timer: 2000,
                        customClass: {
                            popup: 'custom-swal-popup',
                            icon: 'custom-swal-icon',
                            title: 'custom-swal-title',
                            htmlContainer: 'custom-swal-text'
                        }
                    }).then(() => { 
                        window.location.href = '<?= base_url() ?>admin/VAP/index';
                    });
                } else {
                    Swal.fire('Error!', result.message || 'Failed to save data!', 'error');
                }
            } catch (e) {
                console.error("Response parsing error:", e);
                Swal.fire('Error!', 'Server returned invalid response.', 'error');
            }
        },
        error: function(xhr, status, error) {
            console.error("AJAX Error:", xhr.responseText);
            Swal.fire('Error!', 'Something went wrong: ' + error, 'error');
        }
    });
}

// Add file handler for update mode
window.handleFileSelectUpdate = function(input) {
    let fileName = input.files[0] ? input.files[0].name : '';
    let nameDiv = document.getElementById('feedback_name_update');
    if (nameDiv && fileName) {
        nameDiv.innerHTML = fileName + '<span class="file-remove" onclick="removeFileUpdate()">✕</span>';
    }
};

window.removeFileUpdate = function() {
    let fileInput = document.querySelector('input[name="feedback"]');
    let nameDiv = document.getElementById('feedback_name_update');
    if (fileInput) fileInput.value = '';
    if (nameDiv) nameDiv.innerHTML = '';
};
});
</script>