<style>
    .field-wrapper { position: relative; margin-bottom: 20px; }
    .field-wrapper .field-placeholder { position: absolute; top: -12px; left: 16px; background: white; padding: 0 10px; font-size: 13px; color: #667eea; font-weight: 700; z-index: 1; }
    .field-wrapper select { width: 100%; padding: 10px 16px; border: 2px solid #e0e0e0; border-radius: 8px; font-size: 14px; background: #f9f9f9; transition: border-color 0.2s; }
    .field-wrapper select:focus { border-color: #667eea; outline: none; background: white; }

    .tbl-toolbar { display: flex; align-items: center; justify-content: space-between; gap: 10px; margin-bottom: 10px; flex-wrap: wrap; }
    .tbl-search { display: flex; align-items: center; gap: 8px; background: #f4f6ff; border: 1.5px solid #c9d1fd; border-radius: 8px; padding: 7px 12px; flex: 1; max-width: 380px; }
    .tbl-search i { color: #667eea; font-size: 15px; }
    .tbl-search input { border: none; background: transparent; outline: none; font-size: 14px; width: 100%; color: #333; }
    .tbl-search input::placeholder { color: #bbb; }
    .tbl-btns { display: flex; gap: 8px; }

    .btn-modern { padding: 8px 20px; font-weight: 700; border-radius: 8px; border: none; font-size: 14px; cursor: pointer; transition: transform 0.2s, box-shadow 0.2s; box-shadow: 0 3px 8px rgba(0,0,0,0.15); }
    .btn-modern:hover { transform: translateY(-2px); box-shadow: 0 5px 14px rgba(0,0,0,0.2); }
    .btn-modern i { margin-right: 6px; }

    .section-header { display: flex; align-items: center; gap: 10px; margin: 16px 0 10px; padding-bottom: 10px; border-bottom: 3px solid #667eea; }
    .section-header i { font-size: 24px; color: #667eea; }
    .section-header h5 { font-size: 18px; font-weight: 800; color: #2c3e50; margin: 0; text-transform: uppercase; }

    .tbl-container { background: white; border-radius: 10px; padding: 16px; box-shadow: 0 3px 14px rgba(0,0,0,0.08); margin-top: 8px; overflow-x: auto; }

    /* Horizontal Summary Table */
    .horiz-table { width: 100%; border-collapse: collapse; border: 2px solid #000; }
    .horiz-table td { border: 2px solid #000; padding: 12px 14px; text-align: center; font-size: 14px; font-weight: 600; background: #e8f5e9; color: #000; }
    .horiz-table .row-label { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important; color: white !important; font-weight: 800; font-size: 13px; text-transform: uppercase; text-align: left; padding-left: 14px; white-space: nowrap; min-width: 120px; }
    .horiz-table .inr-row td { color: #2e7d32; }
    .horiz-table .grant-cell { cursor: pointer; }
    .horiz-table .grant-cell:hover { background: #c8e6c9 !important; }

    /* Details Table */
    .details-table { width: 100%; border-collapse: collapse; border: 2px solid #000; }
    .details-table thead tr { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; }
    .details-table thead th { padding: 12px 10px; text-align: center; font-weight: 700; font-size: 13px; text-transform: uppercase; border: 2px solid #000; }
    .details-table tbody tr { border: 1px solid #000; }
    .details-table tbody tr:hover { background: #f8f9ff; }
    .details-table tbody td { padding: 10px 8px; text-align: center; font-size: 13px; color: #000; border: 1px solid #000; }

    .loading-container { display: flex; flex-direction: column; align-items: center; justify-content: center; padding: 50px 20px; gap: 16px; }
    .spinner { width: 50px; height: 50px; border: 5px solid #f3f3f3; border-top: 5px solid #667eea; border-radius: 50%; animation: spin 1s linear infinite; }
    @keyframes spin { to { transform: rotate(360deg); } }
    .loading-text { font-size: 16px; color: #6c757d; font-weight: 600; }
    .no-data-message { text-align: center; padding: 50px 20px; background: #f8f9fa; border-radius: 10px; border: 2px dashed #dee2e6; }
    .no-data-message i { font-size: 60px; color: #adb5bd; display: block; margin-bottom: 16px; }
    .no-data-message p { font-size: 17px; color: #6c757d; margin: 0; font-weight: 600; }

    @media print {
        .no-print { display: none !important; }
        .tbl-container { box-shadow: none; padding: 8px; }
        .horiz-table td { border: 2px solid #000 !important; background: #fff !important; color: #000 !important; -webkit-print-color-adjust: exact; print-color-adjust: exact; }
        .horiz-table .row-label { background: #fff !important; color: #000 !important; font-weight: bold; }
        .details-table thead tr { background: #fff !important; }
        .details-table thead th { color: #000 !important; background: #fff !important; border: 2px solid #000 !important; }
    }
</style>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<div class="content-wrapper-scroll">
<div class="content-wrapper">
<div class="row gutters">
<div class="col-xl-12">
<div class="card">
    <div class="card-header d-flex justify-content-center">
        <div class="ribbon1">
            <i class="fas fa-chart-line me-2"></i>Year-wise Grant Amount Report (INR in Lakhs)
        </div>
    </div>

    <div class="card-body">
    <form id="reportForm">
        <div class="row gutters">
            <div class="col-xl-6 col-md-6 col-12">
                <div class="field-wrapper">
                    <select class="select-single js-states" id="fkbranch_id" name="fkbranch_id[]" multiple="multiple">
                        <option value="">All Branches</option>
                        <?php foreach($branchdata as $v): ?>
                            <option value="<?= $v->branch_id ?>"><?= $v->branch_name ?></option>
                        <?php endforeach; ?>
                    </select>
                    <div class="field-placeholder"><i class="fas fa-building me-1"></i> Branch</div>
                </div>
            </div>
            <div class="col-xl-6 col-md-6 col-12">
                <div class="field-wrapper">
                    <select class="select-single js-states" id="year_id" name="year_id[]" multiple="multiple">
                        <?php foreach($yeardata as $v): ?>
                            <option value="<?= $v->finiYear_id ?>"><?= $v->fini_Label ?></option>
                        <?php endforeach; ?>
                    </select>
                    <div class="field-placeholder"><i class="fas fa-calendar-alt me-1"></i> Financial Year</div>
                </div>
            </div>
            <div class="col-12">
                <div class="d-flex justify-content-end mb-2">
                    <button class="btn btn-success btn-modern" type="button" id="btnSearch">
                        <i class="fas fa-search"></i> Show Data
                    </button>
                </div>
            </div>
        </div>

        <!-- SUMMARY SECTION -->
        <div id="yearSummarySection" style="display:none;">
            <div class="section-header mt-2">
                <i class="fas fa-chart-bar"></i>
                <h5>Year-wise Grant Summary</h5>
            </div>

            <div class="tbl-toolbar no-print">
                <div class="tbl-btns" style="margin-left:auto;">
                    <button type="button" class="btn btn-danger btn-modern" onclick="printSummaryTable()"><i class="fas fa-print"></i> Print</button>
                    <button type="button" class="btn btn-success btn-modern" onclick="exportSummaryToExcel()"><i class="fas fa-file-excel"></i> Excel</button>
                </div>
            </div>

            <div class="tbl-container" id="summaryTableContainer">
                <table class="horiz-table" id="summaryTable">
                    <tbody id="horizTableBody"></tbody>
                </table>
            </div>
        </div>

        <!-- DETAILS SECTION -->
        <div id="detailsSection" style="display:none;">
            <div class="section-header mt-4">
                <i class="fas fa-list-alt"></i>
                <h5>Detailed Grant Records &mdash; <span id="detailsYearLabel" style="color:#667eea;"></span></h5>
            </div>

            <div class="tbl-toolbar no-print">
                <div class="tbl-search">
                    <i class="fas fa-search"></i>
                    <input type="text" id="detailsSearch" placeholder="Search faculty, branch, amount, year...">
                </div>
                <div class="tbl-btns">
                    <button type="button" class="btn btn-danger btn-modern" onclick="printDetailsTable()"><i class="fas fa-print"></i> Print</button>
                    <button type="button" class="btn btn-success btn-modern" onclick="exportDetailsToExcel()"><i class="fas fa-file-excel"></i> Excel</button>
                </div>
            </div>

            <div class="tbl-container">
                <table class="details-table" id="detailsTable">
                    <thead>
                        <tr>
                            <th>Sr. No.</th>
                            <th>Faculty Name</th>
                            <th>Branch</th>
                            <th>University</th>
                            <th>Grant Date</th>
                            <th>Description</th>
                            <th>Grant Type</th>
                            <th>Amount (&#8377;)</th>
                            <th>Year</th>
                        </tr>
                    </thead>
                    <tbody id="detailsTableBody"></tbody>
                </table>
            </div>
        </div>
    </form>
    </div>
</div>
</div>
</div>
</div>
</div>

<!-- Modal -->
<div class="modal fade" id="viewModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header" style="background:linear-gradient(135deg,#667eea,#764ba2);color:white;">
                <h5 class="modal-title"><i class="fas fa-file-alt me-2"></i>Grant Details</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div id="printmodal">
                    <div class="card mb-3">
                        <div class="card-header bg-light"><h6 class="mb-0"><i class="fas fa-info-circle me-2"></i>Grant Information</h6></div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6 mb-2"><strong>Grant ID:</strong> <span id="modal_srNo"></span></div>
                                <div class="col-md-6 mb-2"><strong>Faculty Name:</strong> <span id="modal_faculty"></span></div>
                                <div class="col-md-6 mb-2"><strong>Branch:</strong> <span id="modal_branch"></span></div>
                                <div class="col-md-6 mb-2"><strong>University:</strong> <span id="modal_institu"></span></div>
                                <div class="col-md-6 mb-2"><strong>Grant Date:</strong> <span id="modal_Grant_date"></span></div>
                                <div class="col-md-6 mb-2"><strong>Grant Type:</strong> <span id="modal_granttype"></span></div>
                                <div class="col-md-6 mb-2"><strong>Amount:</strong> <span id="modal_Amount_rec" class="text-success fw-bold"></span></div>
                                <div class="col-md-6 mb-2"><strong>Year:</strong> <span id="modal_year"></span></div>
                                <div class="col-12 mb-2"><strong>Description:</strong> <span id="modal_Desscription"></span></div>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header bg-light"><h6 class="mb-0"><i class="fas fa-file-pdf me-2"></i>Documents</h6></div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6"><strong>Approval Letter:</strong> <span id="modal_letter1"></span></div>
                                <div class="col-md-6"><strong>Other Document:</strong> <span id="modal_letter2"></span></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger btn-modern" onclick="printModal()"><i class="fas fa-print me-2"></i>Print</button>
                <button type="button" class="btn btn-secondary btn-modern" data-bs-dismiss="modal"><i class="fas fa-times me-2"></i>Close</button>
            </div>
        </div>
    </div>
</div>

<script src="<?= base_url() ?>Assets/js/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>

<script>
var currentYears = [], currentBranches = [];
var summaryData  = [];

$("#btnSearch").click(function() {
    currentYears    = ($("#year_id").val()     || []).filter(function(v){ return v !== ''; });
    currentBranches = ($("#fkbranch_id").val() || []).filter(function(v){ return v !== ''; });

    $('#horizTableBody').html('<tr><td colspan="20">' + loadingInner() + '</td></tr>');
    $("#yearSummarySection").show();
    $("#detailsSection").hide();

    $.ajax({
        url: "<?= base_url('admin/YearwiseAmountReport/getYearwiseData') ?>",
        type: "POST",
        data: { years: currentYears, branches: currentBranches },
        dataType: "json",
        success: function(r) {
            if (r.status === "success" && r.yearData && r.yearData.length > 0) {
                summaryData = r.yearData;
                displayHorizSummary(r.yearData);
            } else {
                $('#horizTableBody').html('<tr><td colspan="20">' + noDataInner() + '</td></tr>');
            }
        },
        error: function() {
            $('#horizTableBody').html('<tr><td colspan="20">' + errorInner() + '</td></tr>');
        }
    });
});

function displayHorizSummary(data) {
    var totalAmt   = 0, totalGrants = 0;
    var yearCells  = '<td class="row-label">Year</td>';
    var inrCells   = '<td class="row-label">INR in Lakhs</td>';
    var grantCells = '<td class="row-label">No. of Grants</td>';

    for (var i = 0; i < data.length; i++) {
        var item  = data[i];
        var amt   = parseFloat(item.total_amount || 0);
        var lakhs = (amt);
        var fmtL  = lakhs.toLocaleString('en-IN', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
        totalAmt    += amt;
        totalGrants += parseInt(item.grant_count || 0);

        yearCells  += '<td>' + (item.year || '-') + '</td>';
        inrCells   += '<td>&#8377; ' + fmtL + '</td>';
        grantCells += '<td class="grant-cell" data-yearid="' + item.finiYear_id + '" data-yearlabel="' + (item.year || '-') + '" onclick="loadYearDetails(this)">' + item.grant_count + '</td>';
    }

    var totalLakhs = (totalAmt).toLocaleString('en-IN', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
    yearCells  += '<td style="font-weight:900;">TOTAL</td>';
    inrCells   += '<td style="font-weight:900;">&#8377; ' + totalLakhs + '</td>';
    grantCells += '<td style="font-weight:900;">' + totalGrants + '</td>';

    $('#horizTableBody').html(
        '<tr class="year-row">'   + yearCells  + '</tr>' +
        '<tr class="inr-row">'    + inrCells   + '</tr>' +
        '<tr class="grants-row">' + grantCells + '</tr>'
    );
}

function loadYearDetails(cell) {
    var yearId    = $(cell).data('yearid');
    var yearLabel = $(cell).data('yearlabel');

    $('#detailsYearLabel').text(yearLabel);
    $('#detailsTableBody').html(loadingHtml(9));
    $("#detailsSection").show();
    $('html,body').animate({ scrollTop: $("#detailsSection").offset().top - 80 }, 500);

    $.ajax({
        url: "<?= base_url('admin/YearwiseAmountReport/getGrantDetails') ?>",
        type: "POST",
        data: { years: [yearId], branches: currentBranches },
        dataType: "json",
        success: function(r) {
            if (r.status === "success" && r.data && r.data.length > 0) {
                displayGrantDetails(r.data);
            } else {
                $('#detailsTableBody').html(noDataHtml(9));
            }
        },
        error: function() { $('#detailsTableBody').html(errorHtml(9)); }
    });
}

function displayGrantDetails(data) {
    var html = '';
    for (var i = 0; i < data.length; i++) {
        var row = data[i];
        var amt = parseFloat(row.Amount_rec || 0).toLocaleString('en-IN', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
        html += '<tr>';
        html += '<td>' + (i+1) + '</td>';
        html += '<td>' + (row.fac_Fullname   || '-') + '</td>';
        html += '<td>' + (row.branch_name    || '-') + '</td>';
        html += '<td>' + (row.Institu_name   || '-') + '</td>';
        html += '<td>' + formatDate(row.Grant_date) + '</td>';
        html += '<td>' + (row.description    || '-') + '</td>';
        html += '<td>' + (row.granttype_name || '-') + '</td>';
        html += '<td style="font-weight:700;color:#2e7d32;">&#8377; ' + amt + '</td>';
        html += '<td>' + (row.fini_Label     || '-') + '</td>';
        html += '</tr>';
    }
    $('#detailsTableBody').html(html);
}

$(document).on('input', '#detailsSearch', function() {
    var q = $(this).val().toLowerCase();
    $('#detailsTableBody tr').each(function() {
        $(this).toggle($(this).text().toLowerCase().indexOf(q) !== -1);
    });
});

function printSummaryTable() {
    getPrintHeadings(function(h) { openPrint(h, document.getElementById('summaryTableContainer').innerHTML, false); });
}
function printDetailsTable() {
    getPrintHeadings(function(h) { openPrint(h, '<table>' + document.getElementById('detailsTable').innerHTML + '</table>', true); });
}
function getPrintHeadings(cb) {
    $.ajax({ url: '<?= base_url("admin/YearwiseAmountReport/getPrintHeadings") ?>', method: 'GET', dataType: 'json', success: cb });
}
function openPrint(h, bodyContent, fixedLayout) {
    var base = '<?= base_url() ?>';
    var logo = base + (h.logo || 'Assets/images/sit_logo.png').replace(/^\/+/, '');
    var tl   = fixedLayout ? 'table-layout:fixed;' : '';
    var ifrm = document.createElement('iframe');
    ifrm.style.cssText = 'position:fixed;right:0;bottom:0;width:0;height:0;border:0';
    document.body.appendChild(ifrm);
    var d = ifrm.contentWindow.document;
    d.open();
    d.write('<html><head><title>Print</title><style>body{font-family:sans-serif;margin:10px 5px;padding:0}.header-section{display:flex;align-items:center;justify-content:center;gap:10px;margin-bottom:6px}.logo-container img{max-height:75px;max-width:75px}.heading-content{text-align:center}h4,h6{margin:0;padding:0}h4{font-size:18px;font-weight:bold;color:#d32f2f}h6{font-size:13px}table{width:100%;border-collapse:collapse;margin-top:4px;' + tl + 'border:2px solid #000}th,td{border:2px solid #000;padding:6px 4px;text-align:center;font-size:11px;word-wrap:break-word}th{background:#fff !important;color:#000 !important;font-weight:bold}.no-print{display:none !important}</style></head><body><div class="header-section"><div class="logo-container"><img src="' + logo + '" alt="Logo"></div><div class="heading-content"><h6>' + (h.subHead1||'') + '</h6><h4>' + (h.head||'') + '</h4><div>' + (h.subHead2||'') + '</div><div>' + (h.subHead3||'') + '</div></div></div><br>' + bodyContent + '</body></html>');
    d.close();
    setTimeout(function() { ifrm.contentWindow.focus(); ifrm.contentWindow.print(); }, 500);
    setTimeout(function() { document.body.removeChild(ifrm); }, 3000);
}

function exportSummaryToExcel() {
    getPrintHeadings(function(h) {
        var header = [[h.subHead1||''],[h.head||''],[h.subHead2||''],[h.subHead3||''],['Year-wise Grant Amount Report'],['']];
        var yearRow = ['Year'], inrRow = ['INR in Lakhs'], grantRow = ['No. of Grants'];
        var totalAmt = 0, totalGrants = 0;
        for (var i = 0; i < summaryData.length; i++) {
            var item = summaryData[i];
            var amt  = parseFloat(item.total_amount || 0);
            totalAmt    += amt;
            totalGrants += parseInt(item.grant_count || 0);
            yearRow.push(item.year || '-');
            inrRow.push(parseFloat((amt / 100000).toFixed(2)));
            grantRow.push(parseInt(item.grant_count || 0));
        }
        yearRow.push('TOTAL');
        inrRow.push(parseFloat((totalAmt / 100000).toFixed(2)));
        grantRow.push(totalGrants);
        var wb = XLSX.utils.book_new();
        var ws = XLSX.utils.aoa_to_sheet(header.concat([yearRow, inrRow, grantRow]));
        XLSX.utils.book_append_sheet(wb, ws, 'Summary');
        XLSX.writeFile(wb, 'Yearwise_Grant_Summary.xlsx');
    });
}
function exportDetailsToExcel() {
    getPrintHeadings(function(h) {
        var wb = XLSX.utils.book_new();
        var tbl = document.getElementById('detailsTable');
        var td  = XLSX.utils.sheet_to_json(XLSX.utils.table_to_sheet(tbl), { header: 1 });
        var hdr = [[h.subHead1||''],[h.head||''],[h.subHead2||''],[h.subHead3||''],['Grant Details'],['']];
        var ws  = XLSX.utils.aoa_to_sheet(hdr.concat(td));
        XLSX.utils.book_append_sheet(wb, ws, 'Details');
        XLSX.writeFile(wb, 'Grant_Details.xlsx');
    });
}
function printModal() {
    var pc = document.getElementById('printmodal').innerHTML;
    var oc = document.body.innerHTML;
    document.body.innerHTML = pc;
    window.print();
    document.body.innerHTML = oc;
    location.reload();
}
function formatDate(d) {
    if (!d) return '-';
    var dt = new Date(d);
    return ("0"+dt.getDate()).slice(-2)+"-"+("0"+(dt.getMonth()+1)).slice(-2)+"-"+dt.getFullYear();
}
function loadingInner() { return '<div class="loading-container"><div class="spinner"></div><div class="loading-text">Loading...</div></div>'; }
function noDataInner()   { return '<div class="no-data-message"><i class="fas fa-inbox"></i><p>No Data Found</p></div>'; }
function errorInner()    { return '<div class="no-data-message"><i class="fas fa-exclamation-triangle text-danger"></i><p>Error loading data</p></div>'; }
function loadingHtml(c) { return '<tr><td colspan="'+c+'">' + loadingInner() + '</td></tr>'; }
function noDataHtml(c)  { return '<tr><td colspan="'+c+'">' + noDataInner()  + '</td></tr>'; }
function errorHtml(c)   { return '<tr><td colspan="'+c+'">' + errorInner()   + '</td></tr>'; }
</script>