<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Student Complaint Print</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<style>
    body {
        font-family: 'Poppins', sans-serif;
        background-color: #fff;
        margin: 0;
        padding: 10px;
    }

    .print-container {
    max-width: 800px; /* keep it narrow for PDF */
    width: 100%;
    background-color: #fafafa;
    padding: 20px;
    margin: 0 auto;
    color:#000000ad;
}

    .header {
        text-align: center;
        border-bottom: 2px solid #007bff;
        padding-bottom: 10px;
        margin-bottom: 20px;
    }

    .header img {
        height: 87px;
    }

    .header h3 {
        margin-top: 8px;
        font-weight: 600;
        color: #007bff;
    }

    .label {
        font-weight: 600;
        color: #000;
        line-height: 1.2;
    }

    .value {
        /* color: #000; */
        word-wrap: break-word;
        overflow-wrap: break-word;
        line-height: 1.2;
    }

    .section-title {
        font-size: 16px;
        font-weight: 600;
        color: #343a40;
        padding-bottom: 4px;
        margin-bottom: 10px;
        line-height: 1.2;
    }

    .info-row {
        margin-bottom: 6px;
        line-height: 1.2;
    }
    .col-md-3 {
        word-wrap: break-word;
        overflow-wrap: break-word;
        white-space: normal;
        overflow: visible;
    }
    /* .col-md-3 {
        word-wrap: break-word;
        overflow-wrap: break-word;
        white-space: normal;
        overflow: visible;
    } */
    .col-md-5 {
        word-wrap: break-word;
        overflow-wrap: break-word;
        white-space: normal;
        overflow: visible;
    }

    .col-md-6 {
        word-wrap: break-word;
        overflow-wrap: break-word;
        white-space: normal;
        overflow: visible;
    }

    /* .col-md-3 span,
    .col-md-3 div {
        font-size: 14px;
        line-height: 1.2;
        display: inline-block;
        white-space: normal;
        overflow: visible;
    } */

       /* .col-md-5 span,
    .col-md-5 div {
        font-size: 14px;
        line-height: 1.2;
        display: inline-block;
        white-space: normal;
        overflow: visible;
    } */
       .col-md-6 span,
    .col-md-6 div {
        font-size: 14px;
        line-height: 1.2;
        display: inline-block;
        white-space: normal;
        overflow: visible;
    }
    .signature-block {
        margin-top: 30px;
    }

    .signature {
        display: flex;
        justify-content: space-between;
        margin-top: 40px;
    }

    .signature .line {
        border-top: 1px solid #000;
        width: 40%;
        text-align: center;
        padding-top: 5px;
        font-size: 13px;
    }

    .btn-print {
        margin-top: 20px;
        text-align: center;
    }
    .sharad_head{
        color:#e93939;
        font-weight: bold;
font-size: 21px;
    }

    @media print {
        * {
            -webkit-print-color-adjust: exact !important;
            color-adjust: exact !important;
        }

        body {
            padding: 0 !important;
            background-color: #fff !important;
        }

        .print-container {
            border: none !important;
            padding: 0 !important;
            background-color: #fff !important;
        }

        .info-row {
            display: flex !important;
            flex-wrap: wrap !important;
            margin-bottom: 6px;
        }

        .col-md-3 {
            width: 33.33% !important;
            float: left !important;
            box-sizing: border-box;
            padding-right: 10px;
            padding-left: 10px;
            white-space: normal !important;
            overflow: visible !important;
        }

        .col-md-3 span,
        .col-md-3 div {
            white-space: normal !important;
            overflow: visible !important;
            font-size: 14px !important;
            display: inline-block !important;
        }
 .col-md-4 {
            width: 33.33% !important;
            float: left !important;
            box-sizing: border-box;
            padding-right: 10px;
            padding-left: 10px;
            white-space: normal !important;
            overflow: visible !important;
        }

        .col-md-4 span,
        .col-md-4 div {
            white-space: normal !important;
            overflow: visible !important;
            font-size: 14px !important;
            display: inline-block !important;
        }

           .col-md-5 {
            width: 33.33% !important;
            float: left !important;
            box-sizing: border-box;
            padding-right: 10px;
            padding-left: 10px;
            white-space: normal !important;
            overflow: visible !important;
        }
         .col-md-5 span,
        .col-md-5 div {
            white-space: normal !important;
            overflow: visible !important;
            font-size: 14px !important;
            display: inline-block !important;
        }

 

        .col-md-12 {
            width: 100% !important;
            float: left !important;
            box-sizing: border-box;
            padding-right: 10px;
            padding-left: 10px;
        }

        .section-title {
            font-weight: 600;
            font-size: 16px;
            color: #343a40;
            /* border-top: 1px solid #ccc !important; */
            margin-top: 20px;
            margin-bottom: 10px;
            padding-top: 8px;
        }

        .header h3 {
            color: #007bff !important;
        }

       /* Hide elements with class "no-print" in both print and html2pdf */
@media print {
    .no-pdf {
        display: none !important;
    }
}

/* Ensure it's also hidden when html2pdf clones it */
.no-pdf{
    display: none !important;
}

    }
</style>

</head>
<body>

<div class="print-container">
   <div class="header">
    <!-- main header -->
    <div class="d-flex">
        <div class="mt-5">
            <img src="<?= base_url($heading->logo); ?>" alt="Logo" width="100" height="100">
        </div>

        <div class="tb_text_wrap">
            <!-- subHead1 -->
            <h6 style="color:black; font-size:13px; font-weight:bold;">
                <?= $heading->subHead1; ?>&nbsp;&nbsp;
            </h6>

            <!-- head -->
            <h4 class="sharad_head">
                <?= $heading->head; ?>
            </h4>

            <!-- subHead2 + subHead3 -->
            <h6 style="color:black; font-size:14px; font-weight:bold;">
                <span style="background-color:#67d1fc; color:white;border-radius:20px;padding:0px 8px;">
                    <?= $heading->subHead2; ?>
                </span>&nbsp;<br>
                <?= $heading->subHead3; ?>
            </h6>
        </div>
    </div>

    <!-- Optional main form title (if your table has one) -->
          <h3 style="font-family: sans-serif;">Student Graviance Form</h3>

</div>


  <div class="row info-row">
        <div class="col-md-12"><span class="label">Student Full Name:</span><span style="color: black;margin-left: 3px;"> <?= $complaint->Stud_name ?></span></div>
      
    </div>
    
    <div class="row info-row">
        <div class="col-md-3"><span class="label">Application Id:</span><span style="color: black;margin-left: 3px;"><?= $complaint->StudComp_id ?></span></div>
        <div class="col-md-5">
        <span class="label">Complaint Date:</span><span style="color: black;margin-left: 3px;">
<?= !empty($complaint->created_date) ? date('d-m-Y', strtotime($complaint->created_date)) : 'N/A' ?></span>
    </div>
        <div class="col-md-4"><span class="label">PRN No.:</span> <span style="color: black;margin-left: 3px;"><?= $complaint->StudPRN_NO ?></span></div>

</div>
  
   <div class="row info-row">
    <div class="col-md-3"><span class="label">Gender:</span>
    <span style="color: black;margin-left: 3px;"><?php
            if (!empty($genders)) {
                foreach ($genders as $g) {
                    if ($g->gender_id == $complaint->fkgender_id) {
                        echo $g->gender_name;
                        break;
                    }
                }
            }
        ?></span>
    </div>
      <div class="col-md-5"><span class="label">Email:</span> <span style="color: black;margin-left: 3px;"><?= $complaint->Stud_mailId ?></span></div>
        <div class="col-md-4"><span class="label">Mobile No.:</span><span style="color: black;margin-left: 3px;"> <?= $complaint->Stud_mobileNo ?><span></div>
    
</div>


<hr>
<div class="section-title" style="color:black;">Complaint Details</div>
    <div class="row info-row">
        <!-- <div class="col-md-4"><span class="label">Department:</span>
           <span style="color: black;margin-left: 3px;"> <?php foreach ($Department as $d) {
                if ($d->dep_id == $complaint->fkdep_id) echo $d->dep_name;
            } ?></span>
        </div> -->
         <div class="col-md-4"><span class="label">Branch:</span>
           <span style="color: black;margin-left: 3px;"> <?php foreach ($branch as $b) {
                if ($b->branch_id == $complaint->fkbranch_id) echo $b->branch_name;
            } ?></span>
        </div>
       
         <div class="col-md-4"><span class="label">Class:</span>
           <span style="color: black;margin-left: 3px;"> <?php foreach ($Class as $cl) {
                if ($cl->class_id == $complaint->fkclass_id) echo $cl->classname;
            } ?></span>
        </div>
       
         <div class="col-md-4"><span class="label">Category:</span>
           <span style="color: black;margin-left: 3px;"> <?php foreach ($complaint_categories as $c) {
                if ($c->Comp_id == $complaint->fkComp_id) echo $c->Comp_name;
            } ?></span>
        </div>
    </div>
    <div class="row info-row">
        

        <div class="col-md-12">
            <span class="label">Complaint Description:</span>
            <div class="value mt-2"><span style="color: black;margin-left: 3px;"><?= nl2br($complaint->Comp_Desp) ?><span></div>
        </div>
    </div>

    <div class="signature-block">
        <div class="signature">
            <div class="line"><span style="color: black;">Student Signature</span></div>
            <div class="line"><span style="color: black;">Receiving Authority</span></div>
        </div>
    </div>
<div class="btn-print mt-3 no-pdf">
    <button class="btn btn-primary" id="printBtn" onclick="window.print()" style="background-color:black;">
    <i class="fas fa-print me-1"></i> Print
    </button>
    <button class="btn" id="downloadBtn" style="background-color:#eb0c0c; color:white;">
     <i class="fas fa-file-pdf me-1"></i> Download
    </button>
</div>





</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>

<script>
document.getElementById("downloadBtn").addEventListener("click", function () {
    const element = document.querySelector('.print-container');
    const noPdfElements = document.querySelectorAll('.no-pdf');

    // Hide elements before generating PDF
    noPdfElements.forEach(el => el.style.display = 'none');

    const opt = {
        margin: 0,
        filename: 'Student_Complaint.pdf',
        image: { type: 'jpeg', quality: 1 },
        html2canvas: {
            scale: 2,
            useCORS: true,
            scrollX: 0,
            scrollY: 0
        },
        jsPDF: {
            unit: 'pt',
            format: 'a4',
            orientation: 'portrait'
        },
        pagebreak: { mode: ['avoid-all', 'css', 'legacy'] }
    };

    html2pdf().set(opt).from(element).save().then(() => {
        // Show elements back after PDF is generated
        noPdfElements.forEach(el => el.style.display = '');
    });
});
</script>


</body>
</html>
