<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1">Number of Citations of Individual Faculty Member Reports</div>
                    </div>
                    
                    <div class="card-body">
                        <form role="form" id="Form">
                            <div class="row gutters">
                                <!-- Faculty Dropdown -->
                                <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                    <div class="field-wrapper">
                                        <select class="select-single js-states" id="faculty_name" name="faculty_name">
                                            <option value="">All Faculty</option>
                                            <?php 
                                            foreach($facultydata as $faculty){
                                                echo '<option value="'.$faculty->faculty_name.'">'.$faculty->faculty_name.'</option>';
                                            }
                                            ?>
                                        </select>
                                        <div class="field-placeholder">Faculty Name</div>
                                    </div>
                                </div>

                                <!-- Show Button -->
                                <div class="col-md-3">
                                    <button class="btn btn-success btn-sm m-1" type="button" id="btnShow" style="padding: 8px 10px; font-size: 13px; font-weight:600;">
                                        <i class="fas fa-search"></i> Show Data
                                    </button>
                                </div>
                            </div>
                        </form>

                        <!-- Action Buttons -->
                        <div class="row mt-3">
                            <div class="col-md-12 text-right">
                                <button type="button" class="btn btn-danger btn-sm rounded-3" onclick="printTable()">
                                    <i class="fas fa-print bg-white p-1 rounded-circle text-danger shadow-lg"></i> Print
                                </button>
                                <button type="button" class="btn btn-warning btn-sm rounded-3" onclick="exportToExcel()">
                                    <i class="fas fa-file-excel bg-white p-1 rounded-circle text-warning shadow-lg"></i> Excel
                                </button>
                                <button type="button" class="btn btn-dark btn-sm rounded-3" onclick="window.location.href='<?= base_url() ?>admin/Citation/dashboard'">
                                    <i class="fa-solid fa-home bg-white p-1 rounded-circle text-dark shadow-lg"></i> Home
                                </button>
                            </div>
                        </div>

                        <!-- Master Table -->
                        <div class="table-responsive mt-3" id="printableTable">
                            <table id="leavetable" class="table custom-table">
                                <thead style="background-color: #1273eb;">
                                    <tr>
                                        <th>Sr.No.</th>
                                        <th style=" min-width:150px;"  >Faculty Name</th>
                                        <th style=" min-width:150px;">Faculty ID</th>
                                        <th style=" min-width:180px;">Google Sholar Citations</th>
                                        <th style=" min-width:180px;">Google Sholar h-index</th>
                                        <th style=" min-width:180px;">Google Sholar i10-index</th>
                                        <th style=" min-width:150px;">Scopus Citations</th>
                                        <th style=" min-width:150px;">Scopus h-index</th>
                                        <th style=" min-width:200px;" >Web Of Science Citation</th>
                                        <th style=" min-width:200px;" >Web Of Science h-index</th>
                                        <th style=" min-width:130px;">Financial Year</th>
                                        <th class="no-print" style=" min-width:260px;">Action</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>

                        <!-- Chart Section -->
                        <div class="row mt-4" id="chartSection" style="display:none;">
                            <div class="col-md-12">
                                <div class="card p-3">
                                    <h5 class="text-center">
                                        Citation Articles by Year
                                        <span id="chartFacultyName" class="text-primary"></span>
                                    </h5>
                                    <div style="height:300px; position:relative;">
                                        <canvas id="yearBarChart"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Articles Detail Table -->
                        <div class="row mt-3" id="articlesDetailSection" style="display:none;">
                            <div class="col-md-12">
                                <div class="card p-3">
                                    <h5 class="text-center">
                                        Citation Articles Details
                                        <span id="tableFacultyName" class="text-primary"></span>
                                    </h5>
                                    <div class="table-responsive">
                                        <table class="table table-bordered" id="articlesTable">
                                            <thead style="background-color: #28a745;">
                                                <tr>
                                                    <th style="color:white;">Sr.No</th>
                                                    <th style="color:white;">Article Name</th>
                                                    <th style="color:white;">Date</th>
                                                    <th style="color:white;">Year</th>
                                                </tr>
                                            </thead>
                                            <tbody id="articlesTableBody"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Article Details Modal -->
<div class="modal fade" id="articleListModal" tabindex="-1" aria-labelledby="articleListModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title text-center w-100" id="articleListModalLabel">Citation Articles List</h5>
                <button type="button" class="btn-close custom-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="printmodal">
                <div id="facultyInfo" class="mb-3 border p-3 rounded bg-light">
                    <div class="row">
                        <div class="col-md-6 mb-2">
                            <b>Faculty Name:</b> <span id="modal_faculty_name"></span>
                        </div>
                        <div class="col-md-6 mb-2">
                            <b>Faculty ID:</b> <span id="modal_faculty_id"></span>
                        </div>
                        <div class="col-md-6 mb-2">
                            <b>Google Sholar Citations:</b> <span id="modal_citations"></span>
                        </div>
                        <div class="col-md-6 mb-2">
                            <b>Google Sholar h-index:</b> <span id="modal_h_index"></span>
                        </div>
                        <div class="col-md-6 mb-2">
                            <b>Google Sholar i10-index:</b> <span id="modal_i10_index"></span>
                        </div>
                        <div class="col-md-6 mb-2">
                            <b>Scopus Citations:</b> <span id="modal_scopus_Citations"></span>
                        </div>
                        <div class="col-md-6 mb-2">
                            <b>Scopus h-index:</b> <span id="modal_scopus_hindex"></span>
                        </div>
                        <div class="col-md-6 mb-2">
                            <b>Web Of Science Citation:</b> <span id="modal_web_citations"></span>
                        </div>
                        <div class="col-md-6 mb-2">
                            <b>Web Of Science h-index:</b> <span id="modal_web_hindex"></span>
                        </div>
                        <div class="col-md-6 mb-2">
                            <b>Year:</b> <span id="modal_year"></span>
                        </div>
                    </div>
                </div>

                <!-- Articles List in Modal -->
                <div class="mb-3 border p-3 rounded bg-light">
                    <table class="table table-bordered">
                        <thead>
                            <tr class="head">
                                <th class="text-dark">Sr.No</th>
                                <th class="text-dark">Article Name</th>
                                <th class="text-dark">Date</th>
                                <th class="text-dark">Year</th>
                            </tr>
                        </thead>
                        <tbody id="modal_articleTable"></tbody>
                    </table>
                </div>
  
            </div>
            <div class="text-center mb-2">
                    <button type="button" class="btn btn-danger btn-sm rounded-3" onclick="printTablemodal()">
                        <i class="fas fa-print bg-white p-1 rounded-circle text-danger shadow-lg"></i> Print
                    </button>
                </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>

<style>
.no-print {
    display: table-cell;
}

@media print {
    .no-print {
        display: none !important;
    }
}

.table-spinner {
    border: 3px solid #f3f3f3;
    border-top: 3px solid #1273eb;
    border-radius: 50%;
    width: 40px;
    height: 40px;
    animation: spin 1s linear infinite;
    margin: 20px auto;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}
</style>

<script>
let yearBarChart = null;
let currentViewedFaculty = null; // Track currently viewed faculty for chart/table

// Date formatter
function formatDate(dateStr) {
    if (!dateStr) return '-';
    const dateObj = new Date(dateStr);
    const day = String(dateObj.getDate()).padStart(2, '0');
    const month = String(dateObj.getMonth() + 1).padStart(2, '0');
    const year = dateObj.getFullYear();
    return `${day}-${month}-${year}`;
}

// Show Data Button Click
$('#btnShow').click(function () {
    var faculty_name = $('#faculty_name').val();

    // No need to validate - empty means "All Faculty"
    
    // Show spinner
    $('#leavetable tbody').html(`
        <tr>
            <td colspan="12" class="text-center">
                <div class="table-spinner"></div>
                <div>Loading data...</div>
            </td>
        </tr>
    `);

    // Hide charts initially
    $('#chartSection').hide();
    $('#articlesDetailSection').hide();
    currentViewedFaculty = null;

    $.ajax({
        url: '<?= base_url("admin/Citation_report/showDataByFaculty") ?>',
        type: 'POST',
        data: { faculty_name: faculty_name },
        dataType: 'json',
        success: function (response) {
            let html = '';

            if (response.status === 'success' && response.data.length > 0) {
                $.each(response.data, function (index, item) {
                    html += `<tr>
                        <td>${index + 1}</td>
                        <td>${item.faculty_name || '-'}</td>
                        <td>${item.fac_id || '-'}</td>
                        <td>${item.GS_Citations || '-'}</td>
                        <td>${item.GS_h_index || '-'}</td>
                        <td>${item.GS_i10_index || '-'}</td>
                         <td>${item.scopus_citation || '-'}</td>
                          <td>${item.scopus_hindex || '-'}</td>
                           <td>${item.web_scienceCitation || '-'}</td>
                            <td>${item.web_science_hindex || '-'}</td>
                        <td>${item.fini_Label || '-'}</td>
                        <td class="no-print">
                            <button class="btn btn-sm btn-primary btn-view-chart" type="button"
                                data-citid="${item.cit_id}"
                                data-faculty="${item.faculty_name}"
                                data-facid="${item.fac_id}"
                                data-citations="${item.GS_Citations}"
                                data-hindex="${item.GS_h_index}"
                                data-iindex="${item.GS_i10_index}"
                                 data-scopcita="${item.scopus_citation}"
                                  data-scophindex="${item.scopus_hindex}"
                                   data-webcita="${item.web_scienceCitation}"
                                    data-webhindex="${item.web_science_hindex}"
                                data-year="${item.fini_Label}">
                                <i class="fa fa-chart-bar"></i> View Chart
                            </button>
                            <button class="btn btn-sm btn-dark btn-view-articles" type="button"
                                data-citid="${item.cit_id}"
                                data-faculty="${item.faculty_name}"
                                data-facid="${item.fac_id}"
                                data-citations="${item.GS_Citations}"
                                data-hindex="${item.GS_h_index}"
                                data-iindex="${item.GS_i10_index}"
                                data-scopcita="${item.scopus_citation}"
                                data-scophindex="${item.scopus_hindex}"
                                data-webcita="${item.web_scienceCitation}"
                                data-webhindex="${item.web_science_hindex}"
                                data-year="${item.fini_Label}">
                                <i class="fa fa-eye"></i> View Articles
                            </button>
                        </td>
                    </tr>`;
                });
            } else {
                html = `<tr><td colspan="12" class="text-center text-danger">No data found</td></tr>`;
            }

            $('#leavetable tbody').html(html);
        },
        error: function () {
            $('#leavetable tbody').html(`<tr><td colspan="12" class="text-center text-danger">Error loading data</td></tr>`);
        }
    });
});

// View Chart Button Click
$(document).on('click', '.btn-view-chart', function () {
    let cit_id = $(this).data('citid');
    let faculty_name = $(this).data('faculty');

    // Update currently viewed faculty
    currentViewedFaculty = cit_id;

    // Load chart data
    $.ajax({
        url: '<?= base_url("admin/Citation_report/getCitationArticlesByYear") ?>',
        type: 'POST',
        data: { cit_id: cit_id, faculty_name: faculty_name },
        dataType: 'json',
        success: function (response) {
            // Only update if this is still the currently viewed faculty
            if (currentViewedFaculty === cit_id) {
                if (response.status === 'success' && response.data.length > 0) {
                    renderYearBarChart(response.data, faculty_name);
                    $('#chartSection').show();
                    // Scroll to chart
                    $('html, body').animate({
                        scrollTop: $("#chartSection").offset().top - 100
                    }, 500);
                } else {
                    alert('No article data found for this faculty');
                }
            }
        }
    });

    // Load articles detail table
    loadArticlesDetail(cit_id, faculty_name);
});

// Render Year Bar Chart
function renderYearBarChart(data, facultyName) {
    const ctx = document.getElementById('yearBarChart').getContext('2d');
    
    if (yearBarChart) {
        yearBarChart.destroy();
    }

    // Update faculty name in chart heading
    $('#chartFacultyName').text(`- ${facultyName}`);

    const labels = data.map(item => item.year);
    const counts = data.map(item => item.article_count);

    yearBarChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: labels,
            datasets: [{
                label: 'Number of Articles',
                data: counts,
                backgroundColor: 'rgba(18, 115, 235, 0.7)',
                borderColor: 'rgba(18, 115, 235, 1)',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        stepSize: 1
                    }
                }
            },
            plugins: {
                legend: {
                    display: true,
                    position: 'top'
                },
                title: {
                    display: true,
                    text: 'Citation Articles Distribution by Year'
                }
            }
        }
    });
}

// Load Articles Detail Table
function loadArticlesDetail(cit_id, facultyName) {
    $.ajax({
        url: '<?= base_url("admin/Citation_report/getAllArticlesByFaculty") ?>',
        type: 'POST',
        data: { cit_id: cit_id },
        dataType: 'json',
        success: function (data) {
            // Only update if this is still the currently viewed faculty
            if (currentViewedFaculty === cit_id) {
                let html = '';
                
                // Update faculty name in table heading
                $('#tableFacultyName').text(`- ${facultyName}`);
                
                if (data.length > 0) {
                    data.forEach((article, index) => {
                        html += `<tr>
                            <td>${index + 1}</td>
                            <td>${article.article_name || '-'}</td>
                            <td>${formatDate(article.date)}</td>
                            <td>${article.year || '-'}</td>
                        </tr>`;
                    });
                } else {
                    html = `<tr><td colspan="4" class="text-center text-muted">No articles found</td></tr>`;
                }
                $('#articlesTableBody').html(html);
                $('#articlesDetailSection').show();
            }
        }
    });
}

// View Articles in Modal
$(document).on('click', '.btn-view-articles', function () {
    let cit_id = $(this).data('citid');
    let faculty_name = $(this).data('faculty');
    let fac_id = $(this).data('facid');
    let citations = $(this).data('citations');
    let h_index = $(this).data('hindex');
    let i_index = $(this).data('iindex');
    let scop_cita = $(this).data('scopcita');
    let scop_hindex = $(this).data('scophindex');
    let web_cita = $(this).data('webcita');
    let web_hindex = $(this).data('webhindex');
    let year = $(this).data('year');

    // Fill modal info
    $("#modal_faculty_name").text(faculty_name);
    $("#modal_faculty_id").text(fac_id);
    $("#modal_citations").text(citations);
    $("#modal_h_index").text(h_index);
    $("#modal_i10_index").text(i_index);
    $("#modal_scopus_Citations").text(scop_cita);
    $("#modal_scopus_hindex").text(scop_hindex);
    $("#modal_web_citations").text(web_cita);
    $("#modal_web_hindex").text(web_hindex);
    $("#modal_year").text(year);

    // Load articles in modal
    $.ajax({
        url: "<?= base_url('admin/Citation_report/getAllArticlesByFaculty') ?>",
        type: "POST",
        data: { cit_id: cit_id },
        dataType: "json",
        success: function (data) {
            let html = "";
            if (data.length > 0) {
                data.forEach((article, index) => {
                    html += `<tr>
                        <td>${index + 1}</td>
                        <td>${article.article_name || '-'}</td>
                        <td>${formatDate(article.date)}</td>
                        <td>${article.year || '-'}</td>
                    </tr>`;
                });
            } else {
                html = `<tr><td colspan="4" class="text-center text-muted">No articles found</td></tr>`;
            }
            $("#modal_articleTable").html(html);
        }
    });

    // Show modal
    // $('#articleListModal').modal('show');
  // 🔹 Show modal
    $('#articleListModal').modal({
        backdrop: 'static',
        keyboard: false
    }).modal('show');

});

// Print Table Function
function printTable() {
    const printElement = document.getElementById('printableTable');

    $.ajax({
        url: '<?= base_url("admin/Citation_report/getPrintHeadings") ?>',
        method: 'GET',
        dataType: 'json',
        success: function (heading) {
            const iframe = document.createElement('iframe');
            iframe.style.position = 'fixed';
            iframe.style.right = '0';
            iframe.style.bottom = '0';
            iframe.style.width = '0';
            iframe.style.height = '0';
            iframe.style.border = '0';
            document.body.appendChild(iframe);

            const doc = iframe.contentWindow.document;
            const baseUrl = '<?= base_url() ?>';
            let logoPath = heading.logo || 'Assets/images/sit_logo.png';
            logoPath = logoPath.replace(/^\/+/, '');
            const fullLogoPath = baseUrl + logoPath;

            doc.open();
            doc.write(`
                <html>
                <head>
                    <title>Print Citation Report</title>
                    <style>
                        body { font-family: sans-serif; margin: 10px 5px; padding: 0; }
                        .header-section { display: flex; align-items: center; justify-content: center; gap: 10px; margin-bottom: 5px; }
                        .logo-container img { max-height: 80px; max-width: 80px; width: auto; height: auto; }
                        .heading-content { text-align: center; }
                        h4, h6 { margin: 0; padding: 0; }
                        h4 { font-size: 20px; font-weight: bold; color: #d32f2f; }
                        h6 { font-size: 14px; font-weight: normal; }
                        table { width: 100%; border-collapse: collapse; margin-top: 5px; }
                        th, td { border: 1px solid black; padding: 6px 4px; text-align: center; word-wrap: break-word; font-size: 12px; }
                        .no-print { display: none; }
                    </style>
                </head>
                <body>
                    <div class="header-section">
                        <div class="logo-container">
                            <img src="${fullLogoPath}" alt="Logo" onerror="this.style.display='none';">
                        </div>
                        <div class="heading-content">
                            <h6>${heading.subHead1 || ''}</h6>
                            <h4>${heading.head || ''}</h4>
                            <div>${heading.subHead2 || ''}</div>
                            <div>${heading.subHead3 || ''}</div>
                        </div>
                    </div>
                    <br>
                    ${printElement.outerHTML}
                </body>
                </html>
            `);
            doc.close();

            iframe.contentWindow.onload = function() {
                setTimeout(function() {
                    iframe.contentWindow.focus();
                    iframe.contentWindow.print();
                }, 500);
            };

            setTimeout(() => { document.body.removeChild(iframe); }, 3000);
        }
    });
}

// Print Modal Function
function printTablemodal() {
    const printElement = document.getElementById('printmodal');

    $.ajax({
        url: '<?= base_url("admin/Citation_report/getPrintHeadings") ?>',
        method: 'GET',
        dataType: 'json',
        success: function (heading) {

            const iframe = document.createElement('iframe');
            iframe.style.position = 'fixed';
            iframe.style.right = '0';
            iframe.style.bottom = '0';
            iframe.style.width = '0';
            iframe.style.height = '0';
            iframe.style.border = '0';
            document.body.appendChild(iframe);

            const doc = iframe.contentWindow.document;

            const baseUrl = '<?= base_url() ?>';
            let logoPath = heading.logo || 'Assets/images/sit_logo.png';
            logoPath = logoPath.replace(/^\/+/, '');
            const fullLogoPath = baseUrl + logoPath;

            doc.open();
            doc.write(`
                <html>
                <head>
                    <title>Print Citation Report</title>
                    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
                    <style>
                        body {
                            font-family: sans-serif;
                            margin: 10px 5px;
                            padding: 0;
                        }
                        .header-section {
                            display: flex;
                            align-items: center;
                            justify-content: center;
                            gap: 10px;
                            margin-bottom: 5px;
                        }
                        .logo-container img {
                            max-height: 80px;
                            max-width: 80px;
                        }
                        .heading-content {
                            text-align: center;
                        }
                        h4, h6, .sub-heading, .autonomous-badge {
                            margin: 0;
                            padding: 0;
                        }
                        h4 {
                            font-size: 20px;
                            font-weight: bold;
                            color: #d32f2f;
                        }
                        h6 {
                            font-size: 14px;
                        }
                        .sub-heading,
                        .autonomous-badge {
                            font-size: 14px;
                        }
                        table {
                            width: 100%;
                            border-collapse: collapse;
                            margin-top: 5px;
                        }
                        th, td {
                            border: 1px solid black;
                            padding: 4px;
                            text-align: center;
                            word-break: break-word;
                        }
                        .no-print {
                            display: none !important;
                        }
                    </style>
                </head>
                <body>
                    <div class="header-section">
                        <div class="logo-container">
                            <img src="${fullLogoPath}" alt="Logo"
                                 onerror="this.style.display='none';
                                 this.parentElement.innerHTML='<div style=\\'color:red;font-size:12px;\\'>Logo Not Found</div>';">
                        </div>
                        <div class="heading-content">
                            <h6>${heading.subHead1 || ''}</h6>
                            <h4>${heading.head || ''}</h4>
                            <div class="autonomous-badge">${heading.subHead2 || ''}</div>
                            <div class="sub-heading">${heading.subHead3 || ''}</div>
                        </div>
                    </div>
                    <br>
                    ${printElement.outerHTML}
                </body>
                </html>
            `);

            doc.close();

            iframe.onload = function () {
                setTimeout(function () {
                    iframe.contentWindow.focus();
                    iframe.contentWindow.print();
                }, 500);
            };

            setTimeout(() => {
                document.body.removeChild(iframe);
            }, 3000);
        }
    });
}


// Export to Excel
function exportToExcel() {
    $.ajax({
        url: '<?= base_url("admin/Citation_report/getPrintHeadings") ?>',
        method: 'GET',
        dataType: 'json',
        success: function (heading) {
            var wb = XLSX.utils.book_new();
            var header = [
                [heading.subHead1 || ''],
                [heading.head || ''],
                [heading.subHead2 || ''],
                [heading.subHead3 || ''],
                ['']
            ];

            var table = document.getElementById('printableTable');
            var wsTable = XLSX.utils.table_to_sheet(table);
            var tableData = XLSX.utils.sheet_to_json(wsTable, { header: 1 });
            var fullData = header.concat(tableData);
            var ws = XLSX.utils.aoa_to_sheet(fullData);
            
            XLSX.utils.book_append_sheet(wb, ws, 'Citation Report');
            XLSX.writeFile(wb, 'Citation_Report.xlsx');
        }
    });
}
</script>