<style>
    /* Modern Accordion Styling */
    .accordion {
        margin-top: 20px;
    }
    
    .accordion-card {
        border: none !important;
        border-radius: 12px !important;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        overflow: hidden;
        transition: all 0.3s ease;
        background: #fff;
    }
    
    .accordion-card:hover {
        box-shadow: 0 4px 16px rgba(0,0,0,0.12);
        transform: translateY(-2px);
    }
    
    .accordion-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
        padding: 0 !important;
        border: none !important;
    }
    
    .accordion-button {
        color: #fff !important;
        text-decoration: none !important;
        display: flex !important;
        align-items: center;
        justify-content: space-between;
        font-weight: 600;
        font-size: 15px;
        transition: all 0.3s ease;
        border: none !important;
        outline: none !important;
        box-shadow: none !important;
    }
    
    .accordion-button:hover {
        background: rgba(255,255,255,0.1) !important;
    }
    
    .accordion-button:focus {
        box-shadow: none !important;
    }
    
    .accordion-icon {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        width: 40px;
        height: 40px;
        background: rgba(255,255,255,0.2);
        border-radius: 10px;
        margin-right: 15px;
        font-size: 18px;
    }
    
    .accordion-title {
        flex: 1;
        text-align: left;
    }
    
    .accordion-arrow {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        width: 30px;
        height: 30px;
        background: rgba(255,255,255,0.2);
        border-radius: 50%;
        transition: transform 0.3s ease;
    }
    
    .accordion-arrow i {
        transition: transform 0.3s ease;
        font-size: 14px;
    }
    
    .accordion-button[aria-expanded="true"] .accordion-arrow i {
        transform: rotate(180deg);
    }
    
    .accordion-body {
        padding: 25px !important;
        background: #f8f9fa;
        visibility: visible !important;
    }
    
    .form-group {
        display: block !important;
        visibility: visible !important;
        margin-bottom: 0;
    }
    
    .collapse.show .card-body {
        display: block !important;
    }
    
    .collapse.show .form-group,
    .collapse.show .form-control-file,
    .collapse.show label,
    .collapse.show small {
        display: block !important;
        visibility: visible !important;
        opacity: 1 !important;
    }
    
    /* Smooth Collapse Animation */
    .collapse {
        transition: height 0.35s ease;
    }

    /* Collapsed state - Purple gradient (default) */
    .accordion-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
    }

    .accordion-button {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
    }

    /* Opened state - Blue gradient */
    .accordion-button[aria-expanded="true"] {
        background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%) !important;
    }

    /* Hover state - Purple with opacity */
    .accordion-button:hover {
        background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%) !important;
        opacity: 0.9;
    }
    
    /* Responsive Design */
    @media (max-width: 768px) {
        .accordion-button {
            padding: 15px 18px !important;
            font-size: 14px;
        }
        
        .accordion-icon {
            width: 35px;
            height: 35px;
            font-size: 16px;
            margin-right: 10px;
        }
        
        .accordion-body {
            padding: 20px !important;
        }
    }
    
    /* Table styling */
    .custom-table {
        background-color: #fff;
        border-radius: 8px;
        overflow: hidden;
        box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
    }
    
    .custom-table thead {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    }
    
    .custom-table th {
        color: #fff;
        font-weight: 600;
        padding: 12px 15px;
        text-align: left;
    }
    
    .custom-table td {
        padding: 10px 15px;
        border-bottom: 1px solid #f1f1f1;
    }
    
    .custom-table tr:last-child td {
        border-bottom: none;
    }
    
    /* File upload styling */
    .file-upload-cell {
        position: relative;
        display: flex;
        align-items: center;
    }
    
    .file-input {
        position: absolute;
        opacity: 0;
        width: 100%;
        height: 100%;
        cursor: pointer;
    }
    
    .file-name {
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        max-width: 150px;
        font-size: 12px;
        color: #6c757d;
    }
    
    /* Button styling */
    .btn-quarternary {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: #fff;
        border: none;
        padding: 8px 16px;
        border-radius: 4px;
        transition: all 0.3s ease;
    }
    
    .btn-quarternary:hover {
        background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
        color: #fff;
    }
    
    .btn-quarternary1 {
        background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
        color: #fff;
        border: none;
        padding: 8px 16px;
        border-radius: 4px;
        transition: all 0.3s ease;
    }
    
    .btn-quarternary1:hover {
        background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);
        color: #fff;
    }
    
    .btn-quarternaryhome {
        background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
        color: #fff;
        border: none;
        padding: 8px 16px;
        border-radius: 4px;
        transition: all 0.3s ease;
    }
    
    .btn-quarternaryhome:hover {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: #fff;
    }
  
        .file-upload-cell {
            position: relative;
            width: 120px;
        }
        .file-input {
            position: absolute;
            opacity: 0;
            width: 100%;
            height: 100%;
            cursor: pointer;
        }
        .file-label {
            display: inline-block;
            background: #007bff;
            color: white;
            padding: 5px 10px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 12px;
            text-align: center;
            width: 100px;
        }
        .file-label:hover {
            background: #0056b3;
        }
        .file-name {
            font-size: 10px;
            color: #666;
            margin-top: 2px;
            word-break: break-word;
        }
        .file-remove {
            color: red;
            cursor: pointer;
            font-size: 10px;
            margin-left: 5px;
        }
        .wide-th {
        width: 200px !important;  
    }
    .total-row {
    background-color: #f8f9fa;
    font-weight: bold;
    border-top: 2px solid #dee2e6;
}

.total-row td {
    padding: 12px 8px !important;
    font-size: 14px;
}

.total-amount {
    color: #28a745;
    font-size: 16px;
    font-weight: 600;
}
    
</style>

<div class="content-wrapper-scroll">
    <!-- Content wrapper start -->
    <div class="content-wrapper">
        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <!-- Card start -->
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1">First Year Induction Form </div>
                    </div>
                    <div class="card-body">
                        <form role="form" id="Form" action="" method="post" enctype="multipart/form-data">
                        <!-- Row start -->
                        <div class="row gutters">
                            <input type="hidden" id="Main_id" name="Main_id"
                                   class="hiddenId" style="width: 40px !important;height: 40px;"
                                   value="<?php if(!empty($data)) echo $data[0]->Main_id; ?>">

                            <div class="col-md-2">
                                <div class="field-wrapper">
                                    <select name="finicial_Year" id="finicial_Year" class="select-single js-states form-control">
                                        <?php
                                        $savedYear = '';
                                        if (!empty($data) && isset($data[0]->finicial_Year)) {
                                            $savedYear = $data[0]->finicial_Year;
                                        } elseif (!empty($childData) && isset($childData[0]->finicial_Year)) {
                                            $savedYear = $childData[0]->finicial_Year;
                                        }
                                        if (empty($savedYear) && !empty($activeYear)) {
                                            $savedYear = $activeYear->finiYear_id;
                                        }
                                        ?>
                                        <option value="">Select year</option>
                                        <?php foreach($yeardata as $year): ?>
                                            <option value="<?= $year->finiYear_id ?>"
                                                <?= ($year->finiYear_id == $savedYear) ? 'selected' : '' ?>>
                                                <?= $year->fini_Label ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                    <div class="field-placeholder">Academic Year</div>
                                </div>
                            </div>

                            <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
                                <div class="field-wrapper">
                                    <input class="form-control" 
                                           type="date" 
                                           id="Start_date" 
                                           name="Start_date" 
                                           value="<?= !empty($data) ? $data[0]->Start_date : date('Y-m-d') ?>">
                                    <div class="field-placeholder">Start Date</div>
                                </div>
                            </div>

                            <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
                                <div class="field-wrapper">
                                    <input class="form-control" 
                                           type="date" 
                                           id="End_date" 
                                           name="End_date" 
                                           value="<?= !empty($data) ? $data[0]->End_date : date('Y-m-d') ?>">
                                    <div class="field-placeholder">End Date</div>
                                </div>
                            </div>

                            <!-- Collapsible Tabs Section -->
                            <div class="col-md-12 mt-4">
                                <div class="accordion" id="accordionInduction">
                                    
                                    <!-- Tab 1 -->
                                    <div class="card accordion-card mb-3">
                                        <div class="card-header accordion-header" id="heading1">
                                            <button class="btn btn-link accordion-button w-100 text-left" type="button" data-toggle="collapse" data-target="#collapse1" aria-expanded="false" aria-controls="collapse1">
                                                <span class="accordion-icon"><i class="fa-solid fa-info-circle"></i></span>
                                                <span class="accordion-title">Tab 1 - ALCTE Guidelines For Induction Program</span>
                                                <span class="accordion-arrow"><i class="fas fa-chevron-down"></i></span>
                                            </button>
                                        </div>
                                        <div id="collapse1" class="collapse" aria-labelledby="heading1" data-parent="#accordionInduction">
                                            <div class="card-body accordion-body">
                                                <div class="row">
                                                    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 col-12">
                                                        <div class="field-wrapper">
                                                            <div class="field-placeholder">ALCTE program </div>
                                                            <input type="file" name="ALCTE_program" id="ALCTE_program" class="form-control" accept=".pdf,.doc,.docx" onchange="previewRemuneration(this)">
                                                            <div class="form-text">Only PDF and DOC files are allowed</div>
                                                            <div id="file_Remuneration" style="margin-top:10px;">
                                                                <?php
                                                                if (!empty($data[0]->ALCTE_program)) {
                                                                    $file = $data[0]->ALCTE_program;
                                                                    $ext = pathinfo($file, PATHINFO_EXTENSION);
                                                                    $fileUrl = base_url('' . $file);
                                                                    $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
                                                                    ?>
                                                                    <a href="<?= $fileUrl ?>" target="_blank">
                                                                        <?php if ($isImage): ?>
                                                                            <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
                                                                            <?php else: ?>
                                                                                <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
                                                                        <?php endif; ?>
                                                                    </a>
                                                                    <?php } ?>
                                                            </div>
                                                            <input type="hidden" name="hidden_ALCTE_program" value="<?= !empty($data[0]->ALCTE_program) ? $data[0]->ALCTE_program : '' ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Tab 2 -->
                                    <div class="card accordion-card mb-3">
                                        <div class="card-header accordion-header" id="heading2">
                                            <button class="btn btn-link accordion-button w-100 text-left collapsed" type="button" data-toggle="collapse" data-target="#collapse2" aria-expanded="false" aria-controls="collapse2">
                                                <span class="accordion-icon"><i class="fa-solid fa-user-graduate"></i></span>
                                                <span class="accordion-title">Tab 2 - Faculty Training Letter For Conducting Induction Activity</span>
                                                <span class="accordion-arrow"><i class="fas fa-chevron-down"></i></span>
                                            </button>
                                        </div>
                                        <div id="collapse2" class="collapse" aria-labelledby="heading2" data-parent="#accordionInduction">
                                            <div class="card-body accordion-body">
                                                
                                                <div class="row">

                                                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                <label for="excel_file" class="form-label">Import Excel</label>
                                <div class="card" id="studentCard"
                                     style="height: 120px; width: 60%; cursor: pointer; padding: 10px;
                                            border: 2px dashed black; text-align: center; display: flex;
                                            flex-direction: column; justify-content: flex-start; align-items: center;
                                            position: relative; overflow: hidden;"
                                     onclick="document.getElementById('excel_file').click();">
                                    <img src="<?= base_url('Assets/img/excel.png'); ?>" id="studentImg"
                                         style="max-height: 50px; object-fit: contain; margin-bottom: 5px;">
                                    <span id="studentFileText" style="font-size: 11px; color: black; font-weight:600;">
                                        (<span class="text-danger">*</span>File extension allowed: .xls .xlsx)
                                    </span>
                                    <input type="file" accept=".xls,.xlsx" style="display: none;"
                                           class="form-control form-control-sm"
                                           id="excel_file" name="excel_file">
                                </div>
                                <?php if (!empty($mainData->excel_file)): ?>
                                    <p class="mt-2">Uploaded File: <b><?= $mainData->excel_file ?></b></p>
                                <?php endif; ?>
                                <button class="btn btn-success btn-sm m-1" type="button" id="btnShow" style="padding: px 10px;font-size: 13px;"><i class="fas fa-search"></i> Show Excel Data</button>
                            </div>

                            <div class="row">
                                <div class="col-md-12 text-end mt-3">
                                   <a href="<?= base_url('uploads/formatexcel/Firstinduction_Tab2.xlsx'); ?>"
                                   download
                                   style="color: #0b0a0aff; text-decoration: underline; font-weight: 600; font-size:14px;">
                                   <i class="fas fa-file-excel" style="color: green; margin-right: 6px; font-size:16px;"></i>
                                   Download Excel Format
                                   </a>
                                </div>
                            </div>




                                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-3 col-12">
                                                        <div class="table-responsive mt-3 mb-3" id="printableTable">
                                                            <div class="float-end mb-2">
                                                                <?php if (!empty($data)): ?>
                                                                    <button class="btn btn-danger btn-sm m-1" type="button" id="btnClearAll" style="padding: px 10px;font-size: 13px;">
                                                                        <i class="fas fa-times"></i> Clear All
                                                                    </button>
                                                                    <?php endif; ?>
                                                            </div>
                                                            <table id="leavetable" class="table custom-table" >
                                                                <thead>
                                                                    <tr>
                                                                        <th class="text-white">Sr.No.</th>
                                                                        <th class="text-white">Date</th>
                                                                        <th class="text-white">Start Time</th>
                                                                        <th class="text-white">End Time</th>
                                                                        <th class="text-white">Activity</th>
                                                                        <th class="text-white">Resort Person</th>
                                                                        <th class="text-white">Venue Location</th>
                                                                        <th class="text-white">Photo URL</th>
                                                                        <th class="text-white">Action</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody id="tableBody">
                                                                    <?php if(!empty($childData['sec'])):
                                                                        $i=1;
                                                                    foreach($childData['sec'] as $row): ?>
                                                                    <tr>
                                                                        <td><?= $i++ ?></td>
                                                                        <td>
                                                                            <input type="hidden" name="Sec_id[]" value="<?= $row->Sec_id ?>">
                                                                            <input type="date" name="Date[]" class="form-control" value="<?= $row->Date ?>">
                                                                        </td>
                                                                        <td>
                                                                            <input type="time" name="Start_time[]" class="form-control" value="<?= $row->Start_time ?>">
                                                                        </td>
                                                                       
                                                                        <td>
                                                                            <input type="time" name="End_time[]" class="form-control" value="<?= $row->End_time ?>">
                                                                        </td>
                                                                        <td>
                                                                            <input type="text" name="Activity[]" class="form-control" value="<?= $row->Activity ?>">
                                                                        </td>
                                                                        <td>
                                                                            <input type="text" name="Res_person[]" class="form-control" value="<?= $row->Res_person ?>">
                                                                        </td>
                                                                        <td>
                                                                            <input type="text" name="Venue_location[]" class="form-control" value="<?= $row->Venue_location ?>">
                                                                        </td>
                                                                        <td>
                                                                            <input type="text" name="Photo_url[]" class="form-control" value="<?= $row->Photo_url ?>">
                                                                        </td>
                                                                        <td><button type="button" class="btn text-danger btn-sm removeRow"><i class="fa-solid fa-trash"></i></button></td>
                                                                    </tr>
                                                                    <?php endforeach; endif; ?>
                                                                </tbody>
                                                            </table>
                                                            <div class="float-end">
                                                                <button type="button" class="btn btn-success btn-sm p-2 rounded-3 mb-2" id="addRowBtn"><i class="fa-solid fa-plus  bg-white p-1 rounded-circle text-success shadow-lg" style=" box-shadow: 4px 6px 12px rgba(0, 0, 0, 0.5) !important;"></i>Add Row</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Tab 3 -->
                                    <div class="card accordion-card mb-3">
                                        <div class="card-header accordion-header" id="heading3">
                                            <button class="btn btn-link accordion-button w-100 text-left collapsed" type="button" data-toggle="collapse" data-target="#collapse3" aria-expanded="false" aria-controls="collapse3">
                                                <span class="accordion-icon"><i class="fa-solid fa-book"></i></span>
                                                <span class="accordion-title">Tab 3 - Institute Academic Celendar</span>
                                                <span class="accordion-arrow"><i class="fas fa-chevron-down"></i></span>
                                            </button>
                                        </div>
                                        <div id="collapse3" class="collapse" aria-labelledby="heading3" data-parent="#accordionInduction">
                                            <div class="card-body accordion-body">
                                                <div class="row">
                                                    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 col-12">
                                                        <div class="field-wrapper">
                                                            <div class="field-placeholder">Institute Calander</div>
                                                            <input type="file" name="Insti_cal" id="Insti_cal" class="form-control" accept=".pdf,.doc,.docx" onchange="previewInstituteCalendar(this)">
                                                            <div class="form-text">Only PDF and DOC files are allowed</div>
                                                            <div id="file_InstituteCalendar" style="margin-top:10px;">
                                                                <?php
                                                                if (!empty($data[0]->Insti_cal)) {
                                                                    $file = $data[0]->Insti_cal;
                                                                    $ext = pathinfo($file, PATHINFO_EXTENSION);
                                                                    $fileUrl = base_url('' . $file);
                                                                    $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
                                                                    ?>
                                                                    <a href="<?= $fileUrl ?>" target="_blank">
                                                                        <?php if ($isImage): ?>
                                                                            <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
                                                                            <?php else: ?>
                                                                                <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
                                                                        <?php endif; ?>
                                                                    </a>
                                                                    <?php } ?>
                                                            </div>
                                                            <input type="hidden" name="hidden_Insti_cal" value="<?= !empty($data[0]->Insti_cal) ? $data[0]->Insti_cal : '' ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Tab 4 -->
                                    <div class="card accordion-card mb-3">
                                        <div class="card-header accordion-header" id="heading4">
                                            <button class="btn btn-link accordion-button w-100 text-left collapsed" type="button" data-toggle="collapse" data-target="#collapse4" aria-expanded="false" aria-controls="collapse4">
                                                <span class="accordion-icon"><i class="fa-solid fa-chalkboard-teacher"></i></span>
                                                <span class="accordion-title">Tab 4 - Department Academic Calender</span>
                                                <span class="accordion-arrow"><i class="fas fa-chevron-down"></i></span>
                                            </button>
                                        </div>
                                        <div id="collapse4" class="collapse" aria-labelledby="heading4" data-parent="#accordionInduction">
                                            <div class="card-body accordion-body">
                                                <div class="row">
                                                    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 col-12">
                                                        <div class="field-wrapper">
                                                            <div class="field-placeholder">Department Calender</div>
                                                            <input type="file" name="Dep_cal" id="Dep_cal" class="form-control" accept=".pdf,.doc,.docx" onchange="previewDepartmentCalendar(this)">
                                                            <div class="form-text">Only PDF and DOC files are allowed</div>
                                                            <div id="file_DepartmentCalendar" style="margin-top:10px;">
                                                                <?php
                                                                if (!empty($data[0]->Dep_cal)) {
                                                                    $file = $data[0]->Dep_cal;
                                                                    $ext = pathinfo($file, PATHINFO_EXTENSION);
                                                                    $fileUrl = base_url('' . $file);
                                                                    $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
                                                                    ?>
                                                                    <a href="<?= $fileUrl ?>" target="_blank">
                                                                        <?php if ($isImage): ?>
                                                                            <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
                                                                            <?php else: ?>
                                                                                <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
                                                                        <?php endif; ?>
                                                                    </a>
                                                                    <?php } ?>
                                                            </div>
                                                            <input type="hidden" name="hidden_Dep_cal" value="<?= !empty($data[0]->Dep_cal) ? $data[0]->Dep_cal : '' ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Tab 5 -->
                                    <div class="card accordion-card mb-3">
                                        <div class="card-header accordion-header" id="heading5">
                                            <button class="btn btn-link accordion-button w-100 text-left collapsed" type="button" data-toggle="collapse" data-target="#collapse5" aria-expanded="false" aria-controls="collapse5">
                                                <span class="accordion-icon"><i class="fa-solid fa-calendar-alt"></i></span>
                                                <span class="accordion-title">Tab 5 - Induction Notice And Time table</span>
                                                <span class="accordion-arrow"><i class="fas fa-chevron-down"></i></span>
                                            </button>
                                        </div>
                                        <div id="collapse5" class="collapse" aria-labelledby="heading5" data-parent="#accordionInduction">
                                            <div class="card-body accordion-body">
                                                <div class="row">
                                                    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 col-12">
                                                        <div class="field-wrapper">
                                                            <div class="field-placeholder">Notice time Table </div>
                                                            <input type="file" name="Notice_table" id="Notice_table" class="form-control" accept=".pdf,.doc,.docx" onchange="previewInductionNotice(this)">
                                                            <div class="form-text">Only PDF and DOC files are allowed</div>
                                                            <div id="file_InductionNotice" style="margin-top:10px;">
                                                                <?php
                                                                if (!empty($data[0]->Notice_table)) {
                                                                    $file = $data[0]->Notice_table;
                                                                    $ext = pathinfo($file, PATHINFO_EXTENSION);
                                                                    $fileUrl = base_url('' . $file);
                                                                    $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
                                                                    ?>
                                                                    <a href="<?= $fileUrl ?>" target="_blank">
                                                                        <?php if ($isImage): ?>
                                                                            <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
                                                                            <?php else: ?>
                                                                                <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
                                                                        <?php endif; ?>
                                                                    </a>
                                                                    <?php } ?>
                                                            </div>
                                                            <input type="hidden" name="hidden_Notice_table" value="<?= !empty($data[0]->Notice_table) ? $data[0]->Notice_table : '' ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Tab 6 -->
                                    <div class="card accordion-card mb-3">
                                        <div class="card-header accordion-header" id="heading6">
                                            <button class="btn btn-link accordion-button w-100 text-left collapsed" type="button" data-toggle="collapse" data-target="#collapse6" aria-expanded="false" aria-controls="collapse6">
                                                <span class="accordion-icon"><i class="fa-solid fa-folder-open"></i></span>
                                                <span class="accordion-title"> Tab 6 - Photographs Of Activities </span>
                                                <span class="accordion-arrow"><i class="fas fa-chevron-down"></i></span>
                                            </button>
                                        </div>
                                        <div id="collapse6" class="collapse" aria-labelledby="heading6" data-parent="#accordionInduction">
                                            <div class="card-body accordion-body">
                                                <div class="row">
                                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-3 col-12">
                                                        <div class="table-responsive mt-3 mb-3" id="printableTable">
                                                            <div class="float-end mb-2">
                                                                <?php if (!empty($data)): ?>
                                                                    <button class="btn btn-danger btn-sm m-1" type="button" id="btnClearAll" style="padding: px 10px;font-size: 13px;">
                                                                        <i class="fas fa-times"></i> Clear All
                                                                    </button>
                                                                    <?php endif; ?>
                                                            </div>
                                                            <table id="leavetable" class="table custom-table" >
                                                                <thead>
                                                                    <tr>
                                                                        <th class="text-white">Sr.No.</th>
                                                                        <th class="text-white">Photo URL</th>
                                                                        <th class="text-white">Action</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody id="tableBody">
                                                                    <?php if(!empty($childData['third'])):
                                                                        $i=1;
                                                                    foreach($childData['third'] as $row): ?>
                                                                    <tr>
                                                                        <td><?= $i++ ?></td>
                                                                        <td>
                                                                            <input type="hidden" name="Third_id[]" value="<?= $row->Third_id ?>">
                                                                            <input type="text" name="Photos_URL[]" class="form-control" value="<?= $row->Photos_URL ?>">
                                                                        </td>
                                                                        <td><button type="button" class="btn text-danger btn-sm removeRow"><i class="fa-solid fa-trash"></i></button></td>
                                                                    </tr>
                                                                    <?php endforeach; endif; ?>
                                                                </tbody>
                                                            </table>
                                                            <div class="float-end">
                                                                <button type="button" class="btn btn-success btn-sm p-2 rounded-3 mb-2" id="addRowBtn"><i class="fa-solid fa-plus  bg-white p-1 rounded-circle text-success shadow-lg" style=" box-shadow: 4px 6px 12px rgba(0, 0, 0, 0.5) !important;"></i>Add Row</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                   <!-- Tab 7 - Invitation And Thanking Letter -->
<div class="card accordion-card mb-3">
    <div class="card-header accordion-header" id="heading7">
        <button class="btn btn-link accordion-button w-100 text-left collapsed" type="button" data-toggle="collapse" data-target="#collapse7" aria-expanded="false" aria-controls="collapse7">
            <span class="accordion-icon"><i class="fa-solid fa-clipboard-check"></i></span>
            <span class="accordion-title">Tab 7 - Invitation And Thanking Letter</span>
            <span class="accordion-arrow"><i class="fas fa-chevron-down"></i></span>
        </button>
    </div>
    <div id="collapse7" class="collapse" aria-labelledby="heading7" data-parent="#accordionInduction">
        <div class="card-body accordion-body">
            <div class="row">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-3 col-12">
                    <div class="table-responsive mt-3 mb-3">
                        <div class="float-end mb-2">
                            <?php if (!empty($data)): ?>
                                <button class="btn btn-danger btn-sm m-1" type="button" id="btnClearAll7" style="padding: 5px 10px;font-size: 13px;">
                                    <i class="fas fa-times"></i> Clear All
                                </button>
                            <?php endif; ?>
                        </div>
                        <table class="table custom-table">
                            <thead>
                                <tr>
                                    <th class="text-white">Sr.No.</th>
                                    <th class="text-white wide-th">Document/Letter</th>
                                    <th class="text-white wide-th">Guest Name</th>
                                    <th class="text-white">Action</th>
                                </tr>
                            </thead>
                            <tbody id="tableBody7">
                                <?php if(!empty($childData['fourth'])):
                                    $i=1;
                                foreach($childData['fourth'] as $row): ?>
                                <tr>
                                    <td><?= $i ?></td>
                                    <td>
                                        <input type="hidden" name="Fourth_id[]" value="<?= $row->Fourth_id ?>">
                                        <div class="file-upload-cell">
                                            <input type="hidden" name="existing_Doc_letter[]" value="<?= $row->Doc_letter ?? '' ?>">
                                            <input type="file" name="Doc_letter[]" class="file-input" accept=".pdf,.doc,.docx,.jpg,.jpeg,.png" onchange="handleFileSelectExisting(this, 'Doc_letter', <?= $i ?>)">
                                            <label class="file-label">Choose File</label>
                                            <div class="file-name" id="Doc_letter_name_<?= $i ?>"></div>
                                        </div>
                                        <?php if(!empty($row->Doc_letter)): ?>
                                            <?php
                                            $file_path = base_url($row->Doc_letter);
                                            $filename = basename($row->Doc_letter);
                                            ?>
                                            <a href="<?= $file_path ?>" target="_blank">
                                                <span style="color: #007bff; font-size: 12px;">
                                                    <i class="fas fa-file text-danger"></i> <?= substr($filename, 0, 15) ?>...
                                                </span>
                                            </a>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <input type="text" name="Guest_name[]" class="form-control" value="<?= $row->Guest_name ?? '' ?>" placeholder="Enter Gueast Name">
                                    </td>

                                    <td>
                                        <button type="button" class="btn text-danger btn-sm removeRow7">
                                            <i class="fa-solid fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                <?php $i++; endforeach; endif; ?>
                            </tbody>
                        </table>
                        <div class="float-end">
                            <button type="button" class="btn btn-success btn-sm p-2 rounded-3 mb-2" id="addRowBtn7">
                                <i class="fa-solid fa-plus bg-white p-1 rounded-circle text-success shadow-lg" style="box-shadow: 4px 6px 12px rgba(0, 0, 0, 0.5) !important;"></i>Add Row
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Tab 8 - Feedback Analysis -->
<div class="card accordion-card mb-3">
    <div class="card-header accordion-header" id="heading8">
        <button class="btn btn-link accordion-button w-100 text-left collapsed" type="button" data-toggle="collapse" data-target="#collapse8" aria-expanded="false" aria-controls="collapse8">
            <span class="accordion-icon"><i class="fa-solid fa-comments"></i></span>
            <span class="accordion-title">Tab 8 - Feedback Analysis</span>
            <span class="accordion-arrow"><i class="fas fa-chevron-down"></i></span>
        </button>
    </div>
    <div id="collapse8" class="collapse" aria-labelledby="heading8" data-parent="#accordionInduction">
        <div class="card-body accordion-body">
            <div class="row">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-3 col-12">
                    <div class="table-responsive mt-3 mb-3">
                        <div class="float-end mb-2">
                            <?php if (!empty($data)): ?>
                                <button class="btn btn-danger btn-sm m-1" type="button" id="btnClearAll8" style="padding: 5px 10px;font-size: 13px;">
                                    <i class="fas fa-times"></i> Clear All
                                </button>
                            <?php endif; ?>
                        </div>
                        <table class="table custom-table">
                            <thead>
                                <tr>
                                    <th class="text-white">Sr.No.</th>
                                    <th class="text-white wide-th">Feedback Document</th>
                                    <th class="text-white">Action</th>
                                </tr>
                            </thead>
                            <tbody id="tableBody8">
                                <?php if(!empty($childData['fifth'])):
                                    $j=1;
                                foreach($childData['fifth'] as $row): ?>
                                <tr>
                                    <td><?= $j ?></td>
                                    <td>
                                        <input type="hidden" name="Fifth_id[]" value="<?= $row->Fifth_id ?>">
                                        <div class="file-upload-cell">
                                            <input type="hidden" name="existing_Doc_feedback[]" value="<?= $row->Doc_feedback ?? '' ?>">
                                            <input type="file" name="Doc_feedback[]" class="file-input" accept=".pdf,.doc,.docx,.jpg,.jpeg,.png,.xls,.xlsx" onchange="handleFileSelectExisting(this, 'Doc_feedback', <?= $j ?>)">
                                            <label class="file-label">Choose File</label>
                                            <div class="file-name" id="Doc_feedback_name_<?= $j ?>"></div>
                                        </div>
                                        <?php if(!empty($row->Doc_feedback)): ?>
                                            <?php
                                            $file_path = base_url($row->Doc_feedback);
                                            $filename = basename($row->Doc_feedback);
                                            ?>
                                            <a href="<?= $file_path ?>" target="_blank">
                                                <span style="color: #007bff; font-size: 12px;">
                                                    <i class="fas fa-file text-danger"></i> <?= substr($filename, 0, 15) ?>...
                                                </span>
                                            </a>
                                        <?php endif; ?>
                                    </td>
                                    
                                    <td>
                                        <button type="button" class="btn text-danger btn-sm removeRow8">
                                            <i class="fa-solid fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                <?php $j++; endforeach; endif; ?>
                            </tbody>
                        </table>
                        <div class="float-end">
                            <button type="button" class="btn btn-success btn-sm p-2 rounded-3 mb-2" id="addRowBtn8">
                                <i class="fa-solid fa-plus bg-white p-1 rounded-circle text-success shadow-lg" style="box-shadow: 4px 6px 12px rgba(0, 0, 0, 0.5) !important;"></i>Add Row
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
        <!-- yyyy -->
                                </div>
                            </div>
                        
                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 mt-3">
                                <button type="button" class="btn mb-md-0 mb-2 btn-quarternary" id="submit" name="submit">
                                    <i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save
                                </button>
                                <a class="btn mb-md-0 mb-2 btn-quarternary1" href="<?=base_url()?>admin/Firstinduction/index" type="button">
                                    <i class="fa-solid fa-list"></i>&nbsp;&nbsp;List
                                </a>
                                <button class="btn mb-md-0 mb-2 btn-quarternaryhome" type="button" onclick="window.location.href='<?= base_url() ?>admin/Firstinduct/Dashboard'">
                                    <i class="fa-solid fa-home"></i>&nbsp;&nbsp;Home
                                </button>
                            </div>
                        </div>
                        <!-- Row end -->
                        </form>
                    </div>
                </div>
                <!-- Card end -->
            </div>
        </div>
        <!-- Row end -->
    </div>
    <!-- Content wrapper end -->
</div>

<!-- jQuery (required) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.bundle.min.js"></script>
<!-- <script src="<?php echo base_url();?>Assets/js/CreateJs/admin/Firstinduction.js"></script>  -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    var base_path = '<?= base_url() ?>';
    
    $(document).ready(function() {
        // Collapse icon rotation
        $('.collapse').on('show.bs.collapse', function() {
            $(this).prev('.accordion-header').find('.accordion-button').attr('aria-expanded', 'true');
        });
        
        $('.collapse').on('hide.bs.collapse', function() {
            $(this).prev('.accordion-header').find('.accordion-button').attr('aria-expanded', 'false');
        });

        
        // Smooth scroll to opened accordion
        $('.accordion-button').on('click', function() {
            const target = $(this).data('target');
            setTimeout(function() {
                if($(target).hasClass('show')) {
                    $('html, body').animate({
                        scrollTop: $(target).offset().top - 100
                    }, 500);
                }
            }, 350);
        });
    });
</script>

<script>
    /**
 * Tab 1 - AICTE Guidelines For Induction Program
 * Handles Expert Remuneration file upload
 */

(function() {
    'use strict';
    
    // File preview function
    window.previewRemuneration = function(input) {
        const preview = document.getElementById('file_Remuneration');
        const file = input.files[0];
        
        if (file) {
            const fileName = file.name;
            const fileExt = fileName.split('.').pop().toLowerCase();
            
            // Check if it's a PDF or DOC file
            if (fileExt === 'pdf' || fileExt === 'doc' || fileExt === 'docx') {
                preview.innerHTML = `<img src="${base_path}Assets/img/Document_file.png" style="height: 100px;">`;
            } else {
                // Show error message
                Swal.fire({
                    icon: 'error',
                    title: 'Invalid File Type',
                    text: 'Only PDF and DOC files are allowed for this field.'
                });
                input.value = ''; 
                preview.innerHTML = '';
            }
        } else {
            preview.innerHTML = '';
        }
    };

    // Initialize on document ready
    $(document).ready(function() {
        console.log('Tab 1 - Remuneration script loaded');
        
        // Add any additional tab 1 specific initialization here
        $('#collapse1').on('shown.bs.collapse', function() {
            console.log('Tab 1 opened');
        });
    });
})();
</script>

<!-- <script>
    /**
 * Tab 2 - Faculty Training Letter For Conducting Induction Activity
 * Handles dynamic table with Date, Start Time, End Time, Activity, Resort Person, Venue Location, Photo URL
 */

(function() {
    'use strict';
    
    let rowCount = 0;
    let isUpdateMode = false;

    // Initialize
    $(document).ready(function() {
        console.log('Tab 2 - Faculty Training script loaded');
        
        // Check if we're in update mode
        isUpdateMode = $("#Practiced_id").val() ? true : false;
        
        // Count existing rows
        rowCount = $("#collapse2 #tableBody tr").length || 0;
        
        // If no existing data, add one blank row
        if (!isUpdateMode && rowCount === 0) {
            addRow();
        }
        
        // Add Row button
        $("#collapse2 #addRowBtn").on('click', function() {
            addRow();
        });
        
        // Clear All button
        $("#collapse2 #btnClearAll").on('click', function() {
            Swal.fire({
                title: 'Are you sure?',
                text: 'This will clear all table data!',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, clear all!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $("#collapse2 #tableBody").empty();
                    rowCount = 0;
                    addRow();
                    Swal.fire('Cleared!', 'All table data has been cleared.', 'success');
                }
            });
        });
        
        // Remove Row
        $(document).on("click", "#collapse2 .removeRow", function() {
            if ($("#collapse2 #tableBody tr").length > 1) {
                $(this).closest("tr").remove();
                updateSerialNumbers();
            } else {
                Swal.fire('Warning', 'At least one row is required!', 'warning');
            }
        });
    });
    
    // Add new row function
    function addRow(date = "", startTime = "", endTime = "", activity = "", resortPerson = "", venue = "", photoUrl = "", recordId = "") {
        rowCount++;
        
        let newRow = `
            <tr>
                <td>${rowCount}</td>
                <td>
                    <input type="hidden" name="Sec_id[]" value="${recordId}">
                    <input type="date" name="Date[]" class="form-control" value="${date}">
                </td>
                <td>
                    <input type="time" name="Start_time[]" class="form-control" value="${startTime}">
                </td>
                <td>
                    <input type="time" name="End_time[]" class="form-control" value="${endTime}">
                </td>
                <td>
                    <input type="text" name="Activity[]" class="form-control" value="${activity}" placeholder="Activity name">
                </td>
                <td>
                    <input type="text" name="Res_person[]" class="form-control" value="${resortPerson}" placeholder="Person name">
                </td>
                <td>
                    <input type="text" name="Venue_location[]" class="form-control" value="${venue}" placeholder="Venue location">
                </td>
                <td>
                    <input type="url" name="Photo_url[]" class="form-control" value="${photoUrl}" placeholder="https://...">
                </td>
                <td>
                    <button type="button" class="btn text-danger btn-sm removeRow">
                        <i class="fa-solid fa-trash"></i>
                    </button>
                </td>
            </tr>`;
        
        $("#collapse2 #tableBody").append(newRow);
    }
    
    // Update serial numbers
    function updateSerialNumbers() {
        rowCount = 0;
        $("#collapse2 #tableBody tr").each(function() {
            rowCount++;
            $(this).find("td:first").text(rowCount);
        });
    }
    
    // Export function for external use
    window.Tab2Functions = {
        addRow: addRow,
        updateSerialNumbers: updateSerialNumbers
    };
})();
</script> -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<script>
    /**
 * Tab 2 - Faculty Training Letter For Conducting Induction Activity
 * Complete Excel Import and Dynamic Table Management
 */

(function() {
    'use strict';
    
    let rowCount = 0;
    let isUpdateMode = false;

    // Initialize
    $(document).ready(function() {
        console.log('Tab 2 - Faculty Training script loaded');
        
        // Check if we're in update mode
        isUpdateMode = $("#Main_id").val() ? true : false;
        
        // Count existing rows
        rowCount = $("#collapse2 #tableBody tr").length || 0;
        
        // If no existing data, add one blank row
        if (!isUpdateMode && rowCount === 0) {
            addRow();
        }
        
        // Add Row button
        $("#collapse2 #addRowBtn").on('click', function() {
            addRow();
        });
        
        // Clear All button
        $("#collapse2 #btnClearAll").on('click', function() {
            Swal.fire({
                title: 'Are you sure?',
                text: 'This will clear all table data!',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, clear all!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $("#collapse2 #tableBody").empty();
                    rowCount = 0;
                    addRow();
                    Swal.fire('Cleared!', 'All table data has been cleared.', 'success');
                }
            });
        });
        
        // Remove Row
        $(document).on("click", "#collapse2 .removeRow", function() {
            if ($("#collapse2 #tableBody tr").length > 1) {
                $(this).closest("tr").remove();
                updateSerialNumbers();
            } else {
                Swal.fire('Warning', 'At least one row is required!', 'warning');
            }
        });

        // Handle Excel file selection
        $('#excel_file').on('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                $('#studentFileText').html(`Selected: <b>${file.name}</b>`);
            }
        });
        
        // Show Excel Data button click
        $('#btnShow').on('click', function(e) {
            e.preventDefault();
            
            const fileInput = document.getElementById('excel_file');
            const file = fileInput.files[0];
            
            if (!file) {
                Swal.fire({
                    icon: 'warning',
                    title: 'No File Selected',
                    text: 'Please select an Excel file first.'
                });
                return;
            }
            
            // Check file extension
            const fileName = file.name;
            const fileExt = fileName.split('.').pop().toLowerCase();
            
            if (fileExt !== 'xls' && fileExt !== 'xlsx') {
                Swal.fire({
                    icon: 'error',
                    title: 'Invalid File',
                    text: 'Please select a valid Excel file (.xls or .xlsx)'
                });
                return;
            }
            
            // Show loading
            Swal.fire({
                title: 'Reading Excel File...',
                text: 'Please wait',
                allowOutsideClick: false,
                showConfirmButton: false,
                willOpen: () => {
                    Swal.showLoading();
                }
            });
            
            // Read Excel file
            const reader = new FileReader();
            
            reader.onload = function(e) {
                try {
                    // Check if XLSX library is loaded
                    if (typeof XLSX === 'undefined') {
                        throw new Error('XLSX library not loaded. Please include the library in your page.');
                    }
                    
                    const data = new Uint8Array(e.target.result);
                    const workbook = XLSX.read(data, { 
                        type: 'array',
                        cellDates: true,
                        cellNF: false,
                        cellText: false
                    });
                    
                    // Check if workbook has sheets
                    if (!workbook.SheetNames || workbook.SheetNames.length === 0) {
                        throw new Error('No sheets found in Excel file');
                    }
                    
                    // Get first sheet
                    const firstSheetName = workbook.SheetNames[0];
                    const firstSheet = workbook.Sheets[firstSheetName];
                    
                    // Convert to JSON with options
                    const jsonData = XLSX.utils.sheet_to_json(firstSheet, { 
                        header: 1,
                        raw: false,
                        dateNF: 'yyyy-mm-dd',
                        defval: ''
                    });
                    
                    console.log('Excel Data:', jsonData); // Debug log
                    
                    // Check if data exists
                    if (!jsonData || jsonData.length === 0) {
                        throw new Error('Excel file is empty');
                    }
                    
                    if (jsonData.length === 1) {
                        throw new Error('Excel file contains only headers, no data rows found');
                    }
                    
                    // Process and display data
                    processExcelData(jsonData);
                    
                    Swal.close();
                    
                    Swal.fire({
                        icon: 'success',
                        title: 'Success!',
                        text: `Successfully imported ${jsonData.length - 1} rows from Excel`,
                        timer: 2000
                    });
                    
                } catch (error) {
                    console.error('Error reading Excel:', error);
                    Swal.close();
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        html: `Failed to read Excel file.<br><small>${error.message}</small>`,
                        footer: 'Please check console for more details'
                    });
                }
            };
            
            reader.onerror = function(error) {
                console.error('FileReader error:', error);
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: 'Failed to read file. Please try again.'
                });
            };
            
            reader.readAsArrayBuffer(file);
        });
    });
    
    // Add new row function
    function addRow(date = "", startTime = "", endTime = "", activity = "", resortPerson = "", venue = "", photoUrl = "", recordId = "") {
        rowCount++;
        
        let newRow = `
            <tr>
                <td>${rowCount}</td>
                <td>
                    <input type="hidden" name="Sec_id[]" value="${recordId}">
                    <input type="date" name="Date[]" class="form-control" value="${date}">
                </td>
                <td>
                    <input type="time" name="Start_time[]" class="form-control" value="${startTime}">
                </td>
                <td>
                    <input type="time" name="End_time[]" class="form-control" value="${endTime}">
                </td>
                <td>
                    <input type="text" name="Activity[]" class="form-control" value="${activity}" placeholder="Activity name">
                </td>
                <td>
                    <input type="text" name="Res_person[]" class="form-control" value="${resortPerson}" placeholder="Person name">
                </td>
                <td>
                    <input type="text" name="Venue_location[]" class="form-control" value="${venue}" placeholder="Venue location">
                </td>
                <td>
                    <input type="url" name="Photo_url[]" class="form-control" value="${photoUrl}" placeholder="https://...">
                </td>
                <td>
                    <button type="button" class="btn text-danger btn-sm removeRow">
                        <i class="fa-solid fa-trash"></i>
                    </button>
                </td>
            </tr>`;
        
        $("#collapse2 #tableBody").append(newRow);
    }
    
    // Update serial numbers
    function updateSerialNumbers() {
        rowCount = 0;
        $("#collapse2 #tableBody tr").each(function() {
            rowCount++;
            $(this).find("td:first").text(rowCount);
        });
    }

    // Process Excel data and populate table
    function processExcelData(data) {
        try {
            console.log('Processing Excel data:', data);
            
            // Clear existing table rows
            $('#collapse2 #tableBody').empty();
            rowCount = 0;
            
            let addedRows = 0;
            
            // Skip header row (index 0) and process data rows
            for (let i = 1; i < data.length; i++) {
                const row = data[i];
                
                // Skip completely empty rows
                if (!row || row.length === 0 || row.every(cell => !cell)) {
                    console.log('Skipping empty row at index:', i);
                    continue;
                }
                
                console.log('Processing row', i, ':', row);
                
                // Extract data from Excel columns
                // Adjust column indices based on your Excel structure
                const date = row[0] ? formatExcelDate(row[0]) : '';
                const startTime = row[1] ? formatExcelTime(row[1]) : '';
                const endTime = row[2] ? formatExcelTime(row[2]) : '';
                const activity = row[3] ? String(row[3]).trim() : '';
                const resortPerson = row[4] ? String(row[4]).trim() : '';
                const venueLocation = row[5] ? String(row[5]).trim() : '';
                const photoUrl = row[6] ? String(row[6]).trim() : '';
                
                // Add row to table
                addRow(
                    date,
                    startTime,
                    endTime,
                    activity,
                    resortPerson,
                    venueLocation,
                    photoUrl,
                    '' // empty recordId for new rows
                );
                
                addedRows++;
            }
            
            console.log('Total rows added:', addedRows);
            
            // If no rows were added, show message
            if (addedRows === 0) {
                Swal.fire({
                    icon: 'warning',
                    title: 'No Data Found',
                    text: 'No valid data rows found in Excel file'
                });
                // Add one empty row
                addRow();
            }
            
        } catch (error) {
            console.error('Error processing Excel data:', error);
            Swal.fire({
                icon: 'error',
                title: 'Processing Error',
                text: 'Error while processing Excel data: ' + error.message
            });
        }
    }
    
    // Format Excel date to YYYY-MM-DD (Improved version)
    function formatExcelDate(dateValue) {
        if (!dateValue) return "";
        try {
            let date;
            if (dateValue instanceof Date) {
                date = dateValue;
            } else if (typeof dateValue === 'number' && dateValue > 0) {
                // Excel serial date conversion
                date = new Date((dateValue - 25569) * 86400 * 1000);
            } else if (typeof dateValue === 'string') {
                let cleanDate = dateValue.trim();
                // Handle DD/MM/YYYY or DD-MM-YYYY format
                if (cleanDate.match(/^\d{1,2}[\/\-]\d{1,2}[\/\-]\d{4}$/)) {
                    let parts = cleanDate.split(/[\/\-]/);
                    date = new Date(parts[2], parts[1] - 1, parts[0]);
                } 
                // Handle YYYY/MM/DD or YYYY-MM-DD format
                else if (cleanDate.match(/^\d{4}[\/\-]\d{1,2}[\/\-]\d{1,2}$/)) {
                    date = new Date(cleanDate);
                } 
                // Try generic date parsing
                else {
                    date = new Date(cleanDate);
                }
            } else {
                return "";
            }
            
            // Validate and format date
            if (!isNaN(date.getTime())) {
                let year = date.getFullYear();
                let month = String(date.getMonth() + 1).padStart(2, '0');
                let day = String(date.getDate()).padStart(2, '0');
                return `${year}-${month}-${day}`;
            }
        } catch (e) {
            console.warn("Date conversion error:", dateValue, e);
        }
        return "";
    }
    
    // Format Excel time to HH:MM (Enhanced version with multiple format support)
    function formatExcelTime(timeValue) {
        if (!timeValue && timeValue !== 0) return "";
        
        console.log('Formatting time:', timeValue, 'Type:', typeof timeValue);
        
        try {
            // Case 1: Excel decimal format (0.375 = 9:00 AM)
            if (typeof timeValue === 'number') {
                // Handle full date-time numbers (greater than 1)
                if (timeValue > 1) {
                    const date = new Date((timeValue - 25569) * 86400 * 1000);
                    const hours = date.getUTCHours();
                    const minutes = date.getUTCMinutes();
                    return `${String(hours).padStart(2, '0')}:${String(minutes).padStart(2, '0')}`;
                }
                // Handle time only (0 to 1)
                else {
                    const totalMinutes = Math.round(timeValue * 24 * 60);
                    const hours = Math.floor(totalMinutes / 60);
                    const minutes = totalMinutes % 60;
                    return `${String(hours).padStart(2, '0')}:${String(minutes).padStart(2, '0')}`;
                }
            } 
            // Case 2: String format
            else if (typeof timeValue === 'string') {
                let cleanTime = timeValue.trim();
                
                // Already in HH:MM or H:MM format
                if (cleanTime.match(/^\d{1,2}:\d{2}(:\d{2})?$/)) {
                    let parts = cleanTime.split(':');
                    return `${String(parts[0]).padStart(2, '0')}:${parts[1]}`;
                }
                // Handle "9:00 AM" or "9:00 PM" format
                else if (cleanTime.match(/^\d{1,2}:\d{2}\s*(AM|PM)$/i)) {
                    let parts = cleanTime.match(/^(\d{1,2}):(\d{2})\s*(AM|PM)$/i);
                    let hours = parseInt(parts[1]);
                    let minutes = parts[2];
                    let meridiem = parts[3].toUpperCase();
                    
                    if (meridiem === 'PM' && hours !== 12) hours += 12;
                    if (meridiem === 'AM' && hours === 12) hours = 0;
                    
                    return `${String(hours).padStart(2, '0')}:${minutes}`;
                }
                // Try parsing as full date string
                else {
                    let date = new Date(timeValue);
                    if (!isNaN(date.getTime())) {
                        let hours = date.getHours();
                        let minutes = date.getMinutes();
                        return `${String(hours).padStart(2, '0')}:${String(minutes).padStart(2, '0')}`;
                    }
                }
            }
        } catch (e) {
            console.error("Time conversion error:", timeValue, e);
        }
        
        // Return original value if nothing worked
        return String(timeValue);
    }
    
    // Export function for external use
    window.Tab2Functions = {
        addRow: addRow,
        updateSerialNumbers: updateSerialNumbers
    };
})();
</script>


<script>
    /**
 * Tab 3 - Institute Academic Calendar
 * Handles Institute Academic Calendar file upload
 */

(function() {
    'use strict';
    
    // File preview function
    window.previewInstituteCalendar = function(input) {
        const preview = document.getElementById('file_InstituteCalendar');
        const file = input.files[0];
        
        if (file) {
            const fileName = file.name;
            const fileExt = fileName.split('.').pop().toLowerCase();
            
            // Check if it's a PDF or DOC file
            if (fileExt === 'pdf' || fileExt === 'doc' || fileExt === 'docx') {
                preview.innerHTML = `<img src="${base_path}Assets/img/Document_file.png" style="height: 100px;">`;
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Invalid File Type',
                    text: 'Only PDF and DOC files are allowed for this field.'
                });
                input.value = ''; 
                preview.innerHTML = '';
            }
        } else {
            preview.innerHTML = '';
        }
    };

    // Initialize on document ready
    $(document).ready(function() {
        console.log('Tab 3 - Institute Calendar script loaded');
        
        $('#collapse3').on('shown.bs.collapse', function() {
            console.log('Tab 3 opened');
        });
    });
})();
</script>
<script>
    /**
 * Tab 4 - Department Academic Calendar
 * Handles Department Academic Calendar file upload
 */

(function() {
    'use strict';
    
    // File preview function
    window.previewDepartmentCalendar = function(input) {
        const preview = document.getElementById('file_DepartmentCalendar');
        const file = input.files[0];
        
        if (file) {
            const fileName = file.name;
            const fileExt = fileName.split('.').pop().toLowerCase();
            
            // Check if it's a PDF or DOC file
            if (fileExt === 'pdf' || fileExt === 'doc' || fileExt === 'docx') {
                preview.innerHTML = `<img src="${base_path}Assets/img/Document_file.png" style="height: 100px;">`;
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Invalid File Type',
                    text: 'Only PDF and DOC files are allowed for this field.'
                });
                input.value = ''; 
                preview.innerHTML = '';
            }
        } else {
            preview.innerHTML = '';
        }
    };

    // Initialize on document ready
    $(document).ready(function() {
        console.log('Tab 4 - Department Calendar script loaded');
        
        $('#collapse4').on('shown.bs.collapse', function() {
            console.log('Tab 4 opened');
        });
    });
})();
</script>
<script>
    /**
 * Tab 5 - Induction Notice And Time table
 * Handles Induction Notice file upload
 */

(function() {
    'use strict';
    
    // File preview function
    window.previewInductionNotice = function(input) {
        const preview = document.getElementById('file_InductionNotice');
        const file = input.files[0];
        
        if (file) {
            const fileName = file.name;
            const fileExt = fileName.split('.').pop().toLowerCase();
            
            // Check if it's a PDF or DOC file
            if (fileExt === 'pdf' || fileExt === 'doc' || fileExt === 'docx') {
                preview.innerHTML = `<img src="${base_path}Assets/img/Document_file.png" style="height: 100px;">`;
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Invalid File Type',
                    text: 'Only PDF and DOC files are allowed for this field.'
                });
                input.value = ''; 
                preview.innerHTML = '';
            }
        } else {
            preview.innerHTML = '';
        }
    };

    // Initialize on document ready
    $(document).ready(function() {
        console.log('Tab 5 - Induction Notice script loaded');
        
        $('#collapse5').on('shown.bs.collapse', function() {
            console.log('Tab 5 opened');
        });
    });
})();
</script>
 <script>
    /**
 * Tab 6 - Photographs Of Activities
 * Handles dynamic table with Photo URL
 */

(function() {
    'use strict';
    
    let rowCount = 0;
    let isUpdateMode = false;

    // File selection handler
    window.handleTab6PhotoSelect = function(input) {
        let fileName = input.files.length ? input.files[0].name : "";
        let fileNameDiv = input.closest(".file-upload-cell").querySelector(".file-name");
        if (fileNameDiv) {
            fileNameDiv.textContent = fileName.substring(0, 15) + (fileName.length > 15 ? '...' : '');
        }
    };

    // Initialize
    $(document).ready(function() {
        console.log('Tab 6 - Photographs script loaded');
        
        isUpdateMode = $("#Practiced_id").val() ? true : false;
        rowCount = $("#collapse6 #tableBody tr").length || 0;
        
        if (!isUpdateMode && rowCount === 0) {
            addRow();
        }
        
        // Add Row button
        $("#collapse6 #addRowBtn").on('click', function() {
            addRow();
        });
        
        // Clear All button
        $("#collapse6 #btnClearAll").on('click', function() {
            Swal.fire({
                title: 'Are you sure?',
                text: 'This will clear all photographs data!',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, clear all!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $("#collapse6 #tableBody").empty();
                    rowCount = 0;
                    addRow();
                    Swal.fire('Cleared!', 'All photograph data has been cleared.', 'success');
                }
            });
        });
        
        // Remove Row
        $(document).on("click", "#collapse6 .removeRow", function() {
            if ($("#collapse6 #tableBody tr").length > 1) {
                $(this).closest("tr").remove();
                updateSerialNumbers();
            } else {
                Swal.fire('Warning', 'At least one row is required!', 'warning');
            }
        });
    });
    
    // Add new row function
    function addRow(photo = "", recordId = "") {
        rowCount++;
        
        let newRow = `
            <tr>
                <td>${rowCount}</td>
                <td>
                    <input type="hidden" name="Third_id[]" value="${recordId}">
                    <input type="text" name="Photos_URL[]" class="form-control" value="${photo}" placeholder="Enter photo URL">
                </td>
                <td>
                    <button type="button" class="btn text-danger btn-sm removeRow">
                        <i class="fa-solid fa-trash"></i>
                    </button>
                </td>
            </tr>`;
        
        $("#collapse6 #tableBody").append(newRow);
    }
    
    // Update serial numbers
    function updateSerialNumbers() {
        rowCount = 0;
        $("#collapse6 #tableBody tr").each(function() {
            rowCount++;
            $(this).find("td:first").text(rowCount);
        });
    }
    
    // Export functions
    window.Tab6Functions = {
        addRow: addRow,
        updateSerialNumbers: updateSerialNumbers
    };
})();
 </script>
 <script>
/**
 * File Selection Handler for Existing Rows (Edit Mode)
 */
window.handleFileSelectExisting = function(input, fieldName, rowIndex) {
    const file = input.files[0];
    const nameElement = document.getElementById(fieldName + '_name_' + rowIndex);
    
    if (file) {
        // Display the file name
        nameElement.textContent = file.name.substring(0, 20) + (file.name.length > 20 ? '...' : '');
        
        // Validate file type
        const fileExt = file.name.split('.').pop().toLowerCase();
        const allowedExts = ['pdf', 'doc', 'docx', 'jpg', 'jpeg', 'png', 'xls', 'xlsx'];
        
        if (!allowedExts.includes(fileExt)) {
            Swal.fire({
                icon: 'error',
                title: 'Invalid File Type',
                text: 'Please upload only PDF, DOC, DOCX, JPG, PNG, XLS, or XLSX files.'
            });
            input.value = '';
            nameElement.textContent = '';
            return;
        }
        
        // Check file size (max 10MB)
        if (file.size > 10 * 1024 * 1024) {
            Swal.fire({
                icon: 'error',
                title: 'File Too Large',
                text: 'File size must be less than 10MB.'
            });
            input.value = '';
            nameElement.textContent = '';
            return;
        }
    } else {
        nameElement.textContent = '';
    }
};

/**
 * File Selection Handler for New Rows (Add Mode)
 */
window.handleFileSelectNew = function(input, fieldName, uniqueId) {
    const file = input.files[0];
    const nameElement = document.getElementById(fieldName + '_name_' + uniqueId);
    
    if (file) {
        // Display the file name
        nameElement.textContent = file.name.substring(0, 20) + (file.name.length > 20 ? '...' : '');
        
        // Validate file type
        const fileExt = file.name.split('.').pop().toLowerCase();
        const allowedExts = ['pdf', 'doc', 'docx', 'jpg', 'jpeg', 'png', 'xls', 'xlsx'];
        
        if (!allowedExts.includes(fileExt)) {
            Swal.fire({
                icon: 'error',
                title: 'Invalid File Type',
                text: 'Please upload only PDF, DOC, DOCX, JPG, PNG, XLS, or XLSX files.'
            });
            input.value = '';
            nameElement.textContent = '';
            return;
        }
        
        // Check file size (max 10MB)
        if (file.size > 10 * 1024 * 1024) {
            Swal.fire({
                icon: 'error',
                title: 'File Too Large',
                text: 'File size must be less than 10MB.'
            });
            input.value = '';
            nameElement.textContent = '';
            return;
        }
    } else {
        nameElement.textContent = '';
    }
};

/**
 * Tab 7 - Invitation And Thanking Letter
 */
(function() {
    'use strict';
    
    let rowCount7 = 0;
    let isUpdateMode = false;

    $(document).ready(function() {
        console.log('Tab 7 - Invitation Letters script loaded');
        
        isUpdateMode = $("#Main_id").val() ? true : false;
        rowCount7 = $("#tableBody7 tr").length || 0;
        
        if (!isUpdateMode && rowCount7 === 0) {
            addRow7();
        }
        
        // Add Row button
        $("#addRowBtn7").on('click', function() {
            addRow7();
        });
        
        // Clear All button
        $("#btnClearAll7").on('click', function() {
            Swal.fire({
                title: 'Are you sure?',
                text: 'This will clear all invitation letter data!',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, clear all!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $("#tableBody7").empty();
                    rowCount7 = 0;
                    addRow7();
                    Swal.fire('Cleared!', 'All data has been cleared.', 'success');
                }
            });
        });
        
        // Remove Row
        $(document).on("click", ".removeRow7", function() {
            if ($("#tableBody7 tr").length > 1) {
                $(this).closest("tr").remove();
                updateSerialNumbers7();
            } else {
                Swal.fire('Warning', 'At least one row is required!', 'warning');
            }
        });
    });
    
    // Add new row
    function addRow7(file = "", recordId = "", Guest_name = "") {
        rowCount7++;
        const uniqueId = 'new_row_' + rowCount7 + '_' + Date.now();
        
        let newRow = `
            <tr>
                <td>${rowCount7}</td>
                <td>
                    <input type="hidden" name="Fourth_id[]" value="${recordId}">
                    <div class="file-upload-cell">
                        <input type="hidden" name="existing_Doc_letter[]" value="${file}">
                        <input type="file" name="Doc_letter[]" class="file-input" accept=".pdf,.doc,.docx,.jpg,.jpeg,.png" onchange="handleFileSelectNew(this, 'Doc_letter', '${uniqueId}')">
                        <label class="file-label">Choose File</label>
                        <div class="file-name" id="Doc_letter_name_${uniqueId}"></div>
                    </div>
                </td>
                <td>
                    <input type="text" name="Guest_name[]" class="form-control" value="${Guest_name}" placeholder="Enter Gueast Name">
                </td>
                <td>
                    <button type="button" class="btn text-danger btn-sm removeRow7">
                        <i class="fa-solid fa-trash"></i>
                    </button>
                </td>
            </tr>`;
        
        $("#tableBody7").append(newRow);
    }
    
    // Update serial numbers
    function updateSerialNumbers7() {
        rowCount7 = 0;
        $("#tableBody7 tr").each(function() {
            rowCount7++;
            $(this).find("td:first").text(rowCount7);
        });
    }
})();

/**
 * Tab 8 - Feedback Analysis
 */
/**
 * Tab 8 - Feedback Analysis
 */
(function() {
    'use strict';
    
    let rowCount8 = 0;
    let isUpdateMode = false;

    $(document).ready(function() {
        console.log('Tab 8 - Feedback Analysis script loaded');
        
        isUpdateMode = $("#Main_id").val() ? true : false;
        rowCount8 = $("#tableBody8 tr").length || 0;
        
        if (!isUpdateMode && rowCount8 === 0) {
            addRow8();
        }
        
        // Add Row button
        $("#addRowBtn8").on('click', function() {
            addRow8();
        });
        
        // Clear All button
        $("#btnClearAll8").on('click', function() {
            Swal.fire({
                title: 'Are you sure?',
                text: 'This will clear all feedback analysis data!',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, clear all!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $("#tableBody8").empty();
                    rowCount8 = 0;
                    addRow8();
                    Swal.fire('Cleared!', 'All feedback data has been cleared.', 'success');
                }
            });
        });
        
        // Remove Row
        $(document).on("click", ".removeRow8", function() {
            if ($("#tableBody8 tr").length > 1) {
                $(this).closest("tr").remove();
                updateSerialNumbers8();
            } else {
                Swal.fire('Warning', 'At least one row is required!', 'warning');
            }
        });
    });
    
    // Add new row
    function addRow8(file = "", recordId = "") {
        rowCount8++;
        const uniqueId = 'new_row_8_' + rowCount8 + '_' + Date.now();
        
        let newRow = `
            <tr>
                <td>${rowCount8}</td>
                <td>
                    <input type="hidden" name="Fifth_id[]" value="${recordId}">
                    <div class="file-upload-cell">
                        <input type="hidden" name="existing_Doc_feedback[]" value="${file}">
                        <input type="file" name="Doc_feedback[]" class="file-input" accept=".pdf,.doc,.docx,.jpg,.jpeg,.png,.xls,.xlsx" onchange="handleFileSelectNew(this, 'Doc_feedback', '${uniqueId}')">
                        <label class="file-label">Choose File</label>
                        <div class="file-name" id="Doc_feedback_name_${uniqueId}"></div>
                    </div>
                </td>
                <td>
                    <button type="button" class="btn text-danger btn-sm removeRow8">
                        <i class="fa-solid fa-trash"></i>
                    </button>
                </td>
            </tr>`;
        
        $("#tableBody8").append(newRow);
    }
    
    // Update serial numbers
    function updateSerialNumbers8() {
        rowCount8 = 0;
        $("#tableBody8 tr").each(function() {
            rowCount8++;
            $(this).find("td:first").text(rowCount8);
        });
    }
})();
</script>

<script>
    /**
     * File Selection Handler
     * Handles file selection for all file upload cells
     */
    window.handleFileSelectNew = function(input, fieldName, uniqueId) {
        const file = input.files[0];
        const nameElement = document.getElementById(fieldName + '_name_' + uniqueId);
        
        if (file) {
            // Display the file name
            nameElement.textContent = file.name;
            
            // Create a preview if it's an image
            const fileExt = file.name.split('.').pop().toLowerCase();
            const isImage = ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp'].includes(fileExt);
            
            // Check if preview container exists
            let previewContainer = input.parentElement.querySelector('.file-preview');
            
            if (isImage) {
                // Create or update preview container for images
                if (!previewContainer) {
                    previewContainer = document.createElement('div');
                    previewContainer.className = 'file-preview mt-2';
                    input.parentElement.appendChild(previewContainer);
                }
                
                // Create a temporary URL for preview
                const tempUrl = URL.createObjectURL(file);
                previewContainer.innerHTML = `<img src="${tempUrl}" alt="Preview" style="height: 50px; border: 1px solid #ccc; padding: 2px;" />`;
            } else {
                // Remove preview if it exists and file is not an image
                if (previewContainer) {
                    previewContainer.remove();
                }
            }
        } else {
            // Clear file name and preview
            nameElement.textContent = '';
            const previewContainer = input.parentElement.querySelector('.file-preview');
            if (previewContainer) {
                previewContainer.remove();
            }
        }
    };
</script>
  <script>
    /**
 * Main Accordion Controller
 * Handles accordion open/close animations and smooth scrolling
 */

(function() {
    'use strict';
    
    $(document).ready(function() {
        console.log('Main Accordion script loaded');
        
        // Collapse icon rotation and state management
        $('.collapse').on('show.bs.collapse', function() {
            $(this).prev('.accordion-header').find('.accordion-button').attr('aria-expanded', 'true');
        });
        
        $('.collapse').on('hide.bs.collapse', function() {
            $(this).prev('.accordion-header').find('.accordion-button').attr('aria-expanded', 'false');
        });
        
        // Smooth scroll to opened accordion
        $('.accordion-button').on('click', function() {
            const target = $(this).data('target');
            setTimeout(function() {
                if($(target).hasClass('show')) {
                    $('html, body').animate({
                        scrollTop: $(target).offset().top - 100
                    }, 500);
                }
            }, 350);
        });
        
        // Log when tabs are opened
        $('.collapse').on('shown.bs.collapse', function() {
            const tabId = $(this).attr('id');
            console.log('Opened tab:', tabId);
        });
        
        // Log when tabs are closed
        $('.collapse').on('hidden.bs.collapse', function() {
            const tabId = $(this).attr('id');
            console.log('Closed tab:', tabId);
        });
    });
})();
  </script>
<script>
    /**
     * Optimized Form Handler
     * Handles main form submission and validation with improved performance
     */

    (function() {
        'use strict';
        
        $(document).ready(function() {
            console.log('Optimized Form Handler script loaded');
            
            // Form submission
            $("#submit").on('click', function(e) {
                e.preventDefault();
                
                // Validate required fields
                if (!validateForm()) {
                    return false;
                }
                
                // Show confirmation dialog
                Swal.fire({
                    title: 'Are you sure?',
                    text: 'Do you want to save this induction form?',
                    icon: 'question',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, save it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Check if it's an update or save operation
                        const mainId = $("#Main_id").val();
                        if (mainId) {
                            updateForm();
                        } else {
                            submitForm();
                        }
                    }
                });
            });
            
            // Validate form
            function validateForm() {
                let isValid = true;
                let errorMessages = [];
                
                // Validate Academic Year
                if (!$("#finicial_Year").val()) {
                    errorMessages.push('Please select Academic Year');
                    isValid = false;
                }
                
                // Validate Start Date
                if (!$("#Start_date").val()) {
                    errorMessages.push('Please select Start Date');
                    isValid = false;
                }
                
                // Validate End Date
                if (!$("#End_date").val()) {
                    errorMessages.push('Please select End Date');
                    isValid = false;
                }
                
                // Check if End Date is after Start Date
                if ($("#Start_date").val() && $("#End_date").val()) {
                    let Start_date = new Date($("#Start_date").val());
                    let End_date = new Date($("#End_date").val());
                    
                    if (End_date < Start_date) {
                        errorMessages.push('End Date must be after Start Date');
                        isValid = false;
                    }
                }
                
                // Show error messages if any
                if (!isValid) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Validation Error',
                        html: errorMessages.join('<br>')
                    });
                }
                
                return isValid;
            }
            
            // Submit form (for new records)
            function submitForm() {
                // Create FormData object for file uploads
                let formData = new FormData($("#Form")[0]);
                
                // Show loading with progress indicator
                Swal.fire({
                    title: 'Saving...',
                    html: 'Please wait while we save your data<br><div class="progress"><div class="progress-bar" role="progressbar" style="width: 0%" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div></div>',
                    allowOutsideClick: false,
                    showConfirmButton: false,
                    willOpen: () => {
                        Swal.showLoading();
                    }
                });
                
                // Create AJAX request with progress tracking
                let xhr = new XMLHttpRequest();
                
                // Update progress bar
                xhr.upload.addEventListener('progress', function(e) {
                    if (e.lengthComputable) {
                        let percent = Math.round((e.loaded / e.total) * 100);
                        Swal.update({
                            html: `Please wait while we save your data<br><div class="progress"><div class="progress-bar" role="progressbar" style="width: ${percent}%" aria-valuenow="${percent}" aria-valuemin="0" aria-valuemax="100"></div></div>`
                        });
                    }
                });
                
                // Handle response
                xhr.addEventListener('load', function() {
                    if (xhr.status === 200) {
                        try {
                            let result = JSON.parse(xhr.responseText);
                            
                            if (result.status === 'success') {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Success!',
                                    text: result.message || 'Data saved successfully',
                                    showConfirmButton: true
                                }).then(() => {
                                    // Redirect to list page
                                    window.location.href = base_path + 'admin/Firstinduction/index';
                                });
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Error!',
                                    text: result.message || 'Failed to save data'
                                });
                            }
                        } catch (e) {
                            console.error('Parse error:', e);
                            Swal.fire({
                                icon: 'error',
                                title: 'Error!',
                                text: 'An unexpected error occurred'
                            });
                        }
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Failed to save data. Please try again.'
                        });
                    }
                });
                
                // Handle error
                xhr.addEventListener('error', function() {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: 'Failed to save data. Please try again.'
                    });
                });
                
                // Open and send request
                xhr.open('POST', base_path + 'admin/Firstinduction/save', true);
                xhr.send(formData);
            }
            
            // Update form (for existing records)
            function updateForm() {
                // Create FormData object for file uploads
                let formData = new FormData($("#Form")[0]);
                
                // Show loading with progress indicator
                Swal.fire({
                    title: 'Updating...',
                    html: 'Please wait while we update your data<br><div class="progress"><div class="progress-bar" role="progressbar" style="width: 0%" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div></div>',
                    allowOutsideClick: false,
                    showConfirmButton: false,
                    willOpen: () => {
                        Swal.showLoading();
                    }
                });
                
                // Create AJAX request with progress tracking
                let xhr = new XMLHttpRequest();
                
                // Update progress bar
                xhr.upload.addEventListener('progress', function(e) {
                    if (e.lengthComputable) {
                        let percent = Math.round((e.loaded / e.total) * 100);
                        Swal.update({
                            html: `Please wait while we update your data<br><div class="progress"><div class="progress-bar" role="progressbar" style="width: ${percent}%" aria-valuenow="${percent}" aria-valuemin="0" aria-valuemax="100"></div></div>`
                        });
                    }
                });
                
                // Handle response
                xhr.addEventListener('load', function() {
                    if (xhr.status === 200) {
                        try {
                            let result = JSON.parse(xhr.responseText);
                            
                            if (result.status === 'success') {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Success!',
                                    text: result.message || 'Data updated successfully',
                                    showConfirmButton: true
                                }).then(() => {
                                    // Redirect to list page
                                    window.location.href = base_path + 'admin/Firstinduction/index';
                                });
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Error!',
                                    text: result.message || 'Failed to update data'
                                });
                            }
                        } catch (e) {
                            console.error('Parse error:', e);
                            Swal.fire({
                                icon: 'error',
                                title: 'Error!',
                                text: 'An unexpected error occurred'
                            });
                        }
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Failed to update data. Please try again.'
                        });
                    }
                });
                
                // Handle error
                xhr.addEventListener('error', function() {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: 'Failed to update data. Please try again.'
                    });
                });
                
                // Open and send request
                xhr.open('POST', base_path + 'admin/Firstinduction/updateData', true);
                xhr.send(formData);
            }
        });
    })();
</script>