<div class="content-wrapper-scroll">
     <div class="loader-overlay" id="loaderOverlay">
    <div class="loader-content">
        <div class="spinner"></div>
        <div class="loader-text">Processing Excel File...</div>
    </div>
</div>
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1">
                            Student/Faculty Publications Excel Import
                        </div>
                    </div>
                    <div class="card-body">
                        <form role="form" id="Form" method="post" enctype="multipart/form-data">
                            <!-- hidden submenuid -->
<input class="form-control" id="fk_submenuId" name="fk_submenuId" type="hidden"
                           value="<?= isset($subId) ? $subId : '' ?>"  />
                            
                            <!-- Loader -->
                            <div id="loader" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(255, 255, 255, 0.7); z-index: 9999; text-align: center; padding-top: 20%; font-size: 20px; color: #333;">
                                <div id="loading-wrapper">
                                    <div class="spinner-border"></div>
                                    Loading...
                                </div>
                            </div>

                            <div class="row gutters">
                                <!-- File Upload -->
                                <div class="col-md-2">
                                    <label for="excel_file" class="form-label">Choose Excel File</label>
                                    <div class="card" id="cardBox" style="height: 120px; width: 70%; cursor: pointer; padding: 10px; border: 2px dashed black; text-align: center; display: flex; flex-direction: column; justify-content: flex-start; align-items: center; position: relative; overflow: hidden;" onclick="document.getElementById('excel_file').click();">
                                        <img src="<?= base_url('Assets/img/excel.png'); ?>" id="defaultImg" style="max-height: 50px; object-fit: contain; margin-bottom: 5px;">
                                        <span id="fileText" style="font-size: 11px; color: black; font-weight:600;">
                                            (<span class="text-danger">*</span>File extension allowed: .xls .xlsx)
                                        </span>
                                        <input type="file" accept=".xls,.xlsx" style="display: none;" class="form-control form-control-sm" id="excel_file" name="excel_file">
                                    </div>
                                </div>

                                <!-- User Type -->
                                <div class="col-md-2 col-12">
                                    <div class="field-wrapper">
                                        <select class="form-control" id="fk_usertype" name="fk_usertype">
                                            <option value="">Select User type</option>
                                            <?php foreach($maindata as $rw=>$value){ ?>
                                                <option value="<?=$value->mainuser_id?>"><?=$value->mainuser_name?></option>
                                            <?php } ?>
                                        </select>
                                        <div class="field-placeholder">User Type <span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <!-- Publication Type -->
                                <div class="col-md-3 col-12">
                                    <div class="field-wrapper">
                                        <select class="form-control" name="fk_pubtype" id="fk_pubtype">
                                            <option value="">Select Publication</option>
                                            <?php foreach($publidata as $rw=>$value){ ?>
                                                <option value="<?=$value->s_id?>"><?=$value->stud_publishName?></option>
                                            <?php } ?>
                                        </select>
                                        <div class="field-placeholder">Publication Type <span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <!-- Academic Year -->
                                <div class="col-md-3 col-12">
                                    <div class="field-wrapper">
                                        <select class="form-control" name="Financial_Year" id="Financial_Year">
                                            <option value="">Select Year</option>
                                            <?php foreach($yeardata as $rw=>$value){ ?>
                                                <option value="<?=$value->finiYear_id?>"><?=$value->fini_Label?></option>
                                            <?php } ?>
                                        </select>
                                        <div class="field-placeholder">Academic Year <span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <!-- Download Format -->
                                <div class="row">
                                    <div class="col-md-4 mt-2">
                                        <a href="<?= base_url('uploads/formatexcel/Student Book Chapter.xlsx'); ?>" download style="color: #0b0a0aff; text-decoration: underline; font-weight: 600; font-size:14px;">
                                            <i class="fas fa-file-excel" style="color: green; margin-right: 6px; font-size:16px;"></i>
                                            Download Student Book Chapter Format
                                        </a>
                                    </div>

                                    <div class="col-md-3 mt-2">
                                        <a href="<?= base_url('uploads/formatexcel/Faculty Book Chapter.xlsx'); ?>" download style="color: #0b0a0aff; text-decoration: underline; font-weight: 600; font-size:14px;">
                                            <i class="fas fa-file-excel" style="color: green; margin-right: 6px; font-size:16px;"></i>
                                            Download Faculty Book Chapter Format
                                        </a>
                                    </div>

                                    <div class="col-md-3 mt-2">
                                        <a href="<?= base_url('uploads/formatexcel/Student Conference Details.xlsx'); ?>" download style="color: #0b0a0aff; text-decoration: underline; font-weight: 600; font-size:14px;">
                                            <i class="fas fa-file-excel" style="color: green; margin-right: 6px; font-size:16px;"></i>
                                            Download Student Conference Format
                                        </a>
                                    </div>
                                </div>

                                 <div class="row">
                                    <div class="col-md-3 mt-2">
                                        <a href="<?= base_url('uploads/formatexcel/Faculty Conference Details.xlsx'); ?>" download style="color: #0b0a0aff; text-decoration: underline; font-weight: 600; font-size:14px;">
                                            <i class="fas fa-file-excel" style="color: green; margin-right: 6px; font-size:16px;"></i>
                                            Download Faculty Conference Format
                                        </a>
                                    </div>

                                    <div class="col-md-3 mt-2">
                                        <a href="<?= base_url('uploads/formatexcel/Student Journal Details.xlsx'); ?>" download style="color: #0b0a0aff; text-decoration: underline; font-weight: 600; font-size:14px;">
                                            <i class="fas fa-file-excel" style="color: green; margin-right: 6px; font-size:16px;"></i>
                                            Download Student Journal Format
                                        </a>
                                    </div>

                                    <div class="col-md-3 mt-2">
                                        <a href="<?= base_url('uploads/formatexcel/Faculty Journal Details.xlsx'); ?>" download style="color: #0b0a0aff; text-decoration: underline; font-weight: 600; font-size:14px;">
                                            <i class="fas fa-file-excel" style="color: green; margin-right: 6px; font-size:16px;"></i>
                                            Download Faculty Journal Format
                                        </a>
                                    </div>
                                </div>

                                <!-- Buttons -->
                                <div class="card-body">
                                    <div class="text-end">
                                        <button class="btn mb-md-0 mb-2 btn-quarternary" id="submit" name="submit" type="button">
                                            <i class="fa-solid fa-file-excel"></i> Save Data
                                        </button>
                                         <button type="button"
    class="btn mb-md-0 mb-2 btn-quarternaryhome"
    onclick="window.location.href='<?= base_url('admin/Studentpub/dashboard') ?>'">
    
    <i class="fa-solid fa-home fa-lg"></i>
    <span class="fw-semibold">Home</span>

</button>
                                    </div>
                                </div>

                                <!-- Note -->
                                <div class="mb-3">
                                    <span style="font-size: 12px; color: black; font-weight:600;">
                                        Note <span class="text-danger">*</span>: 
                                        (Edit And Drag & Drop Functionality Available In Table.)
                                    </span>
                                </div>

                                <!-- Dynamic Table -->
                                <div style="overflow-x: auto;">
                                    <table id="leavetable" class="table custom-table" style="width: 100%;">
                                        <thead id="tableHeader">
                                            <!-- Dynamic headers will be inserted here -->
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<script src="<?php echo base_url();?>Assets/js/jquery.min.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>

<script>
function showLoader() {
    document.getElementById('loaderOverlay').classList.add('active');
}
function hideLoader() {
    document.getElementById('loaderOverlay').classList.remove('active');
}
</script>


<script>

    let uploadedFile = null;
let currentColumns = [];

// ✅ Column Configuration
const columnConfig = {
    'faculty_book': ['ID', 'Department', 'Name Of Author', 'Title Of Book/Book Chapter', 'Name Of Publisher', 'Date Of Publications', 'ISBN No'],
    'student_book': ['ID', 'Department', 'Name Of Author', 'PRN No.', 'Title Of Book/Book Chapter', 'Name Of Publisher', 'Date Of Publications', 'ISBN No'],
    'faculty_conference': ['ID', 'Department', 'Name Of Author', 'Title of Paper', 'Name of the Conference', 'SCI/ESCI/SCIE/Scopus/UGC care/Other', 'Name Of Publisher','DOI/ Vol. Issue & page no', 'Date & Place of Conference'],
    'student_conference': ['ID', 'Department', 'Name Of Author', 'PRN No.', 'Title of Paper', 'Name of the Conference', 'SCI/ESCI/SCIE/Scopus/UGC care/Other', 'Name Of Publisher', 'DOI/ Vol. Issue & page no', 'Date & Place of Conference'],
    'faculty_journal': ['ID', 'Department', 'Name Of Author', 'Title of Paper', 'Name of the Journal', 'SCI/ESCI/SCIE/Scopus/UGC care/Other', 'Q1/Q2/Q3/Q4', 'Name Of Publisher', 'DOI/ Vol. Issue & page no', 'Date Of Publications', 'Collaborative Publications'],
    'student_journal': ['ID', 'Department', 'Name Of Author', 'PRN No.', 'Title of Paper', 'Name of the Journal', 'SCI/ESCI/SCIE/Scopus/UGC care/Other', 'Q1/Q2/Q3/Q4', 'Name Of Publisher', 'DOI/ Vol. Issue & page no', 'Date Of Publications', 'Collaborative Publications']
};

// ✅ Column to DB field mapping
const fieldMapping = {
    'ID': 'stu_Id',
    'Department': 'fk_branch',
    'Name Of Author': 'authour_name',
    'PRN No.': 'prn_no',
    'Title Of Book/Book Chapter': 'book_title',
    'Title of Paper': 'book_title',
    'Name Of Publisher': 'publisher_name',
    'Date Of Publications': 'pub_date',
    'ISBN No': 'ISBN_NO',
    'Name of the Conference': 'conf_name',
    'SCI/ESCI/SCIE/Scopus/UGC care/Other': 'sci_other',
    'DOI/ Vol. Issue & page no': 'doi_issue',
    'Date & Place of Conference': 'date_place',
    'Name of the Journal': 'journal_name',
    'Q1/Q2/Q3/Q4': 'qurter',
    'Collaborative Publications': 'collaborative'
};

// ✅ Update table headers based on selection
function updateTableHeaders() {
    const usertype = document.getElementById('fk_usertype').value || '1';
    const pubtypeText = document.querySelector('#fk_pubtype option:checked').text.toLowerCase().trim();
    
    let configKey = '';
    
    // Determine config key
    if (usertype === '1') {
        if (pubtypeText.includes('book') || pubtypeText.includes('chapter')) {
            configKey = 'student_book';
        } else if (pubtypeText.includes('conference')) {
            configKey = 'student_conference';
        } else if (pubtypeText.includes('journal')) {
            configKey = 'student_journal';
        } else {
            configKey = 'student_book';
        }
    } else if (usertype === '2') {
        if (pubtypeText.includes('book') || pubtypeText.includes('chapter')) {
            configKey = 'faculty_book';
        } else if (pubtypeText.includes('conference')) {
            configKey = 'faculty_conference';
        } else if (pubtypeText.includes('journal')) {
            configKey = 'faculty_journal';
        } else {
            configKey = 'faculty_book';
        }
    } else {
        configKey = 'student_book';
    }
    
    currentColumns = columnConfig[configKey] || columnConfig['student_book'];
    
    // Update table headers
    let headerHTML = '<tr>';
    currentColumns.forEach(col => {
        headerHTML += `<th draggable="true" style="white-space: nowrap; cursor: move;">${col}</th>`;
    });
    headerHTML += '</tr>';
    document.getElementById('tableHeader').innerHTML = headerHTML;
    
    // ✅ Attach drag events after rendering
    setTimeout(function() {
        attachDragEvents();
    }, 100);
}

// ✅ DRAG & DROP FUNCTIONALITY (Reference code ka exact logic)
let draggedColIndex = null;

function attachDragEvents() {
    document.querySelectorAll("#leavetable thead th").forEach((th, index) => {
        th.style.cursor = "move";
        
        th.addEventListener("dragstart", function (e) {
            draggedColIndex = index;
            e.dataTransfer.effectAllowed = "move";
        });

        th.addEventListener("dragover", function (e) {
            e.preventDefault();
            this.classList.add("over");
        });

        th.addEventListener("dragleave", function () {
            this.classList.remove("over");
        });

        th.addEventListener("drop", function (e) {
            e.preventDefault();
            this.classList.remove("over");

            let targetColIndex = Array.from(this.parentNode.children).indexOf(this);

            if (draggedColIndex === targetColIndex) return;

            swapTableBodyColumns(draggedColIndex, targetColIndex);
        });
    });
}

function swapTableBodyColumns(fromIndex, toIndex) {
    const table = document.getElementById("leavetable");
    
    // ✅ Only swap body cells (NOT header)
    const tbody = table.querySelector("tbody");
    for (let row of tbody.rows) {
        let cells = row.cells;
        if (fromIndex < cells.length && toIndex < cells.length) {
            if (fromIndex < toIndex) {
                row.insertBefore(cells[fromIndex], cells[toIndex].nextSibling);
            } else {
                row.insertBefore(cells[fromIndex], cells[toIndex]);
            }
        }
    }
}

// ✅ Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('fk_usertype').value = '1';
    
    const pubtypeSelect = document.getElementById('fk_pubtype');
    if (pubtypeSelect.options.length > 1) {
        pubtypeSelect.selectedIndex = 1;
    }
    
    updateTableHeaders();
});

// ✅ Listen for dropdown changes
document.getElementById('fk_usertype').addEventListener('change', function() {
    updateTableHeaders();
    document.querySelector('#leavetable tbody').innerHTML = '';
});

document.getElementById('fk_pubtype').addEventListener('change', function() {
    updateTableHeaders();
    document.querySelector('#leavetable tbody').innerHTML = '';
});

// ✅ Excel file upload and parse
document.getElementById('excel_file').addEventListener('change', function(e) {

    uploadedFile = e.target.files[0];
    if (!uploadedFile) return;

    // 🔹 FULL PAGE LOADER ON
    showLoader();

    let tableBody = document.querySelector('#leavetable tbody');
    tableBody.innerHTML = `
        <tr>
            <td colspan="${currentColumns.length}" class="text-center">
                <div class="spinner-border spinner-border-sm"></div>
                <div>Loading data...</div>
            </td>
        </tr>
    `;

    const reader = new FileReader();

    reader.onload = function(event) {
        setTimeout(() => {
            try {
                const data = new Uint8Array(event.target.result);
                const workbook = XLSX.read(data, { type: 'array' });

                const sheetName = workbook.SheetNames[0];
                const worksheet = workbook.Sheets[sheetName];
                const rows = XLSX.utils.sheet_to_json(worksheet, { header: 1 });

                tableBody.innerHTML = '';

                if (rows.length > 0) {
                    rows.forEach(row => {
                        if (!row || row.length === 0) return;

                        let tr = document.createElement('tr');

                        for (let c = 0; c < currentColumns.length; c++) {
                            let cellValue = row[c] ?? "";

                            // 🔹 Excel Date conversion
                            if (typeof cellValue === "number" && cellValue > 30000 && cellValue < 60000) {
                                let excelDate = XLSX.SSF.parse_date_code(cellValue);
                                if (excelDate) {
                                    let jsDate = new Date(excelDate.y, excelDate.m - 1, excelDate.d);
                                    cellValue = `${String(jsDate.getDate()).padStart(2,'0')}-${String(jsDate.getMonth()+1).padStart(2,'0')}-${jsDate.getFullYear()}`;
                                }
                            }

                            let td = document.createElement('td');
                            td.textContent = cellValue;

                            if (c !== 0) td.setAttribute('contenteditable','true');

                            tr.appendChild(td);
                        }
                        tableBody.appendChild(tr);
                    });
                } else {
                    tableBody.innerHTML = `
                        <tr>
                            <td colspan="${currentColumns.length}" class="text-center text-muted">
                                No data found in sheet
                            </td>
                        </tr>`;
                }

                // 🔹 ALL DONE
                hideLoader();

            } catch (err) {
                hideLoader();
                Swal.fire("Error", "Failed to process Excel file!", "error");
                console.error(err);
            }
        }, 300);
    };

    reader.onerror = function () {
        hideLoader();
        Swal.fire("Error", "Failed to read Excel file!", "error");
    };

    reader.readAsArrayBuffer(uploadedFile);
});


// ✅ Save Data
document.getElementById('submit').addEventListener('click', function() {
    let tableData = [];
    let rows = document.querySelectorAll("#leavetable tbody tr");
    
    rows.forEach(tr => {
        let cells = tr.querySelectorAll("td");
        if (cells.length > 0) {
            let rowData = {};
            
            cells.forEach((cell, index) => {
                let columnName = currentColumns[index];
                let fieldName = fieldMapping[columnName];
                if (fieldName) {
                    rowData[fieldName] = cell.textContent.trim();
                }
            });
            
            // Add selected dropdown values
            rowData['fk_usertype'] = document.getElementById('fk_usertype').value;
            rowData['fk_pubtype'] = document.getElementById('fk_pubtype').value;
            rowData['Financial_Year'] = document.getElementById('Financial_Year').value;
            
            tableData.push(rowData);
        }
    });
    
    if (tableData.length === 0) {
        Swal.fire("No Data", "Please upload and arrange data first!", "warning");
        return;
    }
    
    let formData = new FormData();
    formData.append('tableData', JSON.stringify(tableData));
    // for submenu id code
formData.append('fk_submenuId', $('#fk_submenuId').val());
    
    if (uploadedFile) {
        formData.append('excel_file', uploadedFile);
    }
    
    // ✅ Use jQuery AJAX instead of fetch for consistency
    $.ajax({
        url: "<?= base_url('admin/Import_studpub_Excel/import_excel_save') ?>",
        type: "POST",
        data: formData,
        processData: false,
        contentType: false,
        beforeSend: function() {
            $("#loader").show();
            $('#submit').prop('disabled', true).html('Saving...');
        },
        success: function(data) {
            $('#submit').prop('disabled', false).html('<i class="fa-solid fa-file-excel"></i> Save Data');
            $('#loader').fadeOut();
            
            let message = (data === 'success') ? 'Imported Successfully!' 
                : (data === 'no_data' ? 'No data in Excel!' 
                : (data === 'file_error' ? 'File upload failed!' : data));
            
            Swal.fire({
                position: 'center',
                icon: data === 'success' ? 'success' : 'warning',
                title: '<strong>' + (data === 'success' ? 'Success!' : 'Notice') + '</strong>',
                html: message,
                showConfirmButton: false,
                timer: 2000,
                customClass: {
                    popup: 'custom-swal-popup',
                    icon: 'custom-swal-icon',
                    title: 'custom-swal-title',
                    htmlContainer: 'custom-swal-text'
                }
            }).then(() => location.reload());
        },
        error: function() {
            $('#submit').prop('disabled', false).html('<i class="fa-solid fa-file-excel"></i> Save Data');
            $('#loader').fadeOut();
            
            Swal.fire({
                position: 'center',
                icon: 'error',
                title: '<strong>Error!</strong>',
                html: 'Something went wrong!',
                showConfirmButton: true,
                customClass: {
                    popup: 'custom-swal-popup',
                    icon: 'custom-swal-icon',
                    title: 'custom-swal-title',
                    htmlContainer: 'custom-swal-text'
                }
            });
        }
    });
});

// ✅ Highlight editable cells
document.addEventListener('focusin', function(e) {
    if (e.target.tagName === 'TD' && e.target.isContentEditable) {
        e.target.style.backgroundColor = '#fffacd';
    }
});

document.addEventListener('focusout', function(e) {
    if (e.target.tagName === 'TD' && e.target.isContentEditable) {
        e.target.style.backgroundColor = '';
    }
});
// let uploadedFile = null;
// let currentColumns = [];

// // ✅ Column Configuration based on usertype and publication type
// const columnConfig = {
//     'faculty_book': ['ID', 'Department', 'Name Of Author', 'Title Of Book/Book Chapter', 'Name Of Publisher', 'Date Of Publications', 'ISBN No'],
//     'student_book': ['ID', 'Department', 'Name Of Author', 'PRN No.', 'Title Of Book/Book Chapter', 'Name Of Publisher', 'Date Of Publications', 'ISBN No'],
//     'faculty_conference': ['ID', 'Department', 'Name Of Author', 'Title of Paper', 'Name of the Conference', 'SCI/ESCI/SCIE/Scopus/UGC care/Other', 'Name Of Publisher','DOI/ Vol. Issue & page no', 'Date & Place of Conference'],
//     'student_conference': ['ID', 'Department', 'Name Of Author', 'PRN No.', 'Title of Paper', 'Name of the Conference', 'SCI/ESCI/SCIE/Scopus/UGC care/Other', 'Name Of Publisher', 'DOI/ Vol. Issue & page no', 'Date & Place of Conference'],
//     'faculty_journal': ['ID', 'Department', 'Name Of Author', 'Title of Paper', 'Name of the Journal', 'SCI/ESCI/SCIE/Scopus/UGC care/Other', 'Q1/Q2/Q3/Q4', 'Name Of Publisher', 'DOI/ Vol. Issue & page no', 'Date Of Publications', 'Collaborative Publications'],
//     'student_journal': ['ID', 'Department', 'Name Of Author', 'PRN No.', 'Title of Paper', 'Name of the Journal', 'SCI/ESCI/SCIE/Scopus/UGC care/Other', 'Q1/Q2/Q3/Q4', 'Name Of Publisher', 'DOI/ Vol. Issue & page no', 'Date Of Publications', 'Collaborative Publications']
// };

// // ✅ Column to DB field mapping
// const fieldMapping = {
//     'ID': 'stu_Id',
//     'Department': 'fk_branch',
//     'Name Of Author': 'authour_name',
//     'PRN No.': 'prn_no',
//     'Title Of Book/Book Chapter': 'book_title',
//     'Title of Paper': 'paper_name',
//     'Name Of Publisher': 'publisher_name',
//     'Date Of Publications': 'pub_date',
//     'ISBN No': 'ISBN_NO',
//     'Name of the Conference': 'conf_name',
//     'SCI/ESCI/SCIE/Scopus/UGC care/Other': 'sci_other',
//     'DOI/ Vol. Issue & page no': 'doi_issue',
//     'Date & Place of Conference': 'date_place',
//     'Name of the Journal': 'journal_name',
//     'Q1/Q2/Q3/Q4': 'qurter',
//     'Collaborative Publications': 'collaborative'
// };

// // ✅ Update table headers based on selection
// function updateTableHeaders() {
//     const usertype = $('#fk_usertype').val() || '1';
//     const pubtypeText = $('#fk_pubtype option:selected').text().toLowerCase().trim();
    
//     console.log('Usertype:', usertype, 'Pubtype:', pubtypeText); // Debug
    
//     let configKey = '';
    
//     // Determine config key
//     if (usertype === '1') {
//         if (pubtypeText.includes('book') || pubtypeText.includes('chapter')) {
//             configKey = 'student_book';
//         } else if (pubtypeText.includes('conference')) {
//             configKey = 'student_conference';
//         } else if (pubtypeText.includes('journal')) {
//             configKey = 'student_journal';
//         } else {
//             configKey = 'student_book'; // Default
//         }
//     } else if (usertype === '2') {
//         if (pubtypeText.includes('book') || pubtypeText.includes('chapter')) {
//             configKey = 'faculty_book';
//         } else if (pubtypeText.includes('conference')) {
//             configKey = 'faculty_conference';
//         } else if (pubtypeText.includes('journal')) {
//             configKey = 'faculty_journal';
//         } else {
//             configKey = 'faculty_book'; // Default
//         }
//     } else {
//         configKey = 'student_book'; // Default if nothing selected
//     }
    
//     console.log('Config Key:', configKey); // Debug
    
//     currentColumns = columnConfig[configKey] || columnConfig['student_book'];
    
//     console.log('Current Columns:', currentColumns); // Debug
    
//     // Update table headers
//     let headerHTML = '<tr>';
//     currentColumns.forEach(col => {
//         headerHTML += `<th draggable="true" style="white-space: nowrap;">${col}</th>`;
//     });
//     headerHTML += '</tr>';
//     $('#tableHeader').html(headerHTML);
    
//     // Reattach drag events
//     setTimeout(function() {
//         attachDragEvents();
//     }, 100);
    
//     console.log('Table headers updated'); // Debug
// }

// // ✅ Initialize on page load

// $(document).ready(function() {
//     // Set default values
//     $('#fk_usertype').val('1'); // Student
    
//     // Set first publication type option as selected
//     $('#fk_pubtype option:eq(1)').prop('selected', true);
    
//     // Initialize table
//     updateTableHeaders();
// });

// // ✅ Listen for dropdown changes with multiple event types
// $('#fk_usertype').on('change', function() {
//     console.log('Usertype changed to:', $(this).val());
//     updateTableHeaders();
//     $('#leavetable tbody').empty();
// });

// $('#fk_pubtype').on('change', function() {
//     console.log('Pubtype changed to:', $(this).val(), $(this).find('option:selected').text());
//     updateTableHeaders();
//     $('#leavetable tbody').empty();
// });

// // ✅ Excel file upload and parse
// $('#excel_file').on('change', function(e) {
//     uploadedFile = e.target.files[0];
//     if (!uploadedFile) return;
    
//     let tableBody = $('#leavetable tbody');
//     tableBody.html(`
//         <tr>
//             <td colspan="${currentColumns.length}" class="text-center">
//                 <div class="spinner-border spinner-border-sm"></div>
//                 <div>Loading data...</div>
//             </td>
//         </tr>
//     `);
    
//     const reader = new FileReader();
//     reader.onload = function(event) {
//         const data = new Uint8Array(event.target.result);
//         const workbook = XLSX.read(data, { type: 'array' });
        
//         const sheetName = workbook.SheetNames[0];
//         const worksheet = workbook.Sheets[sheetName];
//         const rows = XLSX.utils.sheet_to_json(worksheet, { header: 1 });
        
//         tableBody.empty();
        
//         if (rows.length > 0) {
//             for (let i = 0; i < rows.length; i++) {
//                 const row = rows[i];
//                 if (!row || row.length === 0) continue;
                
//                 let tr = $('<tr></tr>');
                
//                 for (let c = 0; c < currentColumns.length; c++) {
//                     let cellValue = row[c] ?? "";
                    
//                     // Date conversion
//                     if (typeof cellValue === "number" && cellValue > 30000 && cellValue < 60000) {
//                         let excelDate = XLSX.SSF.parse_date_code(cellValue);
//                         if (excelDate) {
//                             let jsDate = new Date(excelDate.y, excelDate.m - 1, excelDate.d);
//                             let day = String(jsDate.getDate()).padStart(2, '0');
//                             let month = String(jsDate.getMonth() + 1).padStart(2, '0');
//                             let year = jsDate.getFullYear();
//                             cellValue = `${day}-${month}-${year}`;
//                         }
//                     }
                    
//                     let td = $('<td></td>').text(cellValue);
                    
//                     // Make editable except ID
//                     if (c !== 0) {
//                         td.attr('contenteditable', 'true');
//                     }
                    
//                     tr.append(td);
//                 }
//                 tableBody.append(tr);
//             }
//         } else {
//             tableBody.html(`<tr><td colspan="${currentColumns.length}" class="text-center text-muted">No data found in sheet</td></tr>`);
//         }
//     };
    
//     reader.readAsArrayBuffer(uploadedFile);
// });

// // ✅ Drag & Drop functionality
// let draggedColIndex = null;

// function attachDragEvents() {
//     $("#leavetable thead th").each(function(index) {
//         $(this).css('cursor', 'move');
        
//         // Remove old events first
//         $(this).off('dragstart dragover dragleave drop');
        
//         $(this).on('dragstart', function(e) {
//             draggedColIndex = index;
//             e.originalEvent.dataTransfer.effectAllowed = "move";
//         });
        
//         $(this).on('dragover', function(e) {
//             e.preventDefault();
//             $(this).addClass("over");
//         });
        
//         $(this).on('dragleave', function() {
//             $(this).removeClass("over");
//         });
        
//         $(this).on('drop', function(e) {
//             e.preventDefault();
//             $(this).removeClass("over");
            
//             let targetColIndex = $(this).index();
//             if (draggedColIndex === targetColIndex) return;
            
//             swapTableColumns(draggedColIndex, targetColIndex);
//         });
//     });
// }

// function swapTableColumns(fromIndex, toIndex) {
//     // Swap in header
//     const header = $("#leavetable thead tr");
//     const headerCells = header.find('th');
//     if (fromIndex < toIndex) {
//         headerCells.eq(fromIndex).insertAfter(headerCells.eq(toIndex));
//     } else {
//         headerCells.eq(fromIndex).insertBefore(headerCells.eq(toIndex));
//     }
    
//     // Swap in currentColumns array
//     const temp = currentColumns[fromIndex];
//     currentColumns.splice(fromIndex, 1);
//     currentColumns.splice(toIndex, 0, temp);
    
//     // Swap in body
//     const tbody = $("#leavetable tbody");
//     tbody.find('tr').each(function() {
//         let cells = $(this).find('td');
//         if (fromIndex < cells.length && toIndex < cells.length) {
//             if (fromIndex < toIndex) {
//                 cells.eq(fromIndex).insertAfter(cells.eq(toIndex));
//             } else {
//                 cells.eq(fromIndex).insertBefore(cells.eq(toIndex));
//             }
//         }
//     });
    
//     // Reattach events
//     attachDragEvents();
// }

// // ✅ Save Data
// $('#submit').on('click', function() {
//     let tableData = [];
//     let rows = $("#leavetable tbody tr");
    
//     rows.each(function() {
//         let cells = $(this).find("td");
//         if (cells.length > 0) {
//             let rowData = {};
            
//             cells.each(function(index) {
//                 let columnName = currentColumns[index];
//                 let fieldName = fieldMapping[columnName];
//                 if (fieldName) {
//                     rowData[fieldName] = $(this).text().trim();
//                 }
//             });
            
//             // Add selected dropdown values
//             rowData['fk_usertype'] = $('#fk_usertype').val();
//             rowData['fk_pubtype'] = $('#fk_pubtype').val();
//             rowData['Financial_Year'] = $('#Financial_Year').val();
            
//             tableData.push(rowData);
//         }
//     });
    
//     if (tableData.length === 0) {
//         Swal.fire("No Data", "Please upload and arrange data first!", "warning");
//         return;
//     }
    
//     let formData = new FormData();
//     formData.append('tableData', JSON.stringify(tableData));
    
//     if (uploadedFile) {
//         formData.append('excel_file', uploadedFile);
//     }
    
//     $.ajax({
//         url: "<?= base_url('admin/Import_studpub_Excel/import_excel_save') ?>",
//         type: "POST",
//         data: formData,
//         processData: false,
//         contentType: false,
//         beforeSend: function() {
//             $("#loader").show();
//             $('#submit').prop('disabled', true).html('Saving...');
//         },
//         success: function(data) {
//             $('#submit').prop('disabled', false).html('<i class="fa-solid fa-file-excel"></i> Save Data');
//             $('#loader').fadeOut();
            
//             let message = (data === 'success') ? 'Imported Successfully!' 
//                 : (data === 'no_data' ? 'No data in Excel!' 
//                 : (data === 'file_error' ? 'File upload failed!' : data));
            
//              Swal.fire({
//                 position: 'center',
//                 icon: data === 'success' ? 'success' : 'warning',
//                 title: '<strong>' + (data === 'success' ? 'Success!' : 'Notice') + '</strong>',
//                 html: message,
//                 showConfirmButton: false,
//                 timer: 2000,
//                 customClass: {
//                     popup: 'custom-swal-popup',
//                     icon: 'custom-swal-icon',
//                     title: 'custom-swal-title',
//                     htmlContainer: 'custom-swal-text'
//                 }
//             }).then(() => location.reload());
//         },
//         error: function() {
//             $('#submit').prop('disabled', false).html('<i class="fa-solid fa-file-excel"></i> Save Data');
//             $('#loader').fadeOut();
            
//             Swal.fire({
//                 position: 'center',
//                 icon: 'error',
//                 title: '<strong>Error!</strong>',
//                 html: 'Something went wrong!',
//                 showConfirmButton: true
//             });
//         }
//     });
// });

// // ✅ Highlight editable cells
// $(document).on('focusin', '#leavetable td[contenteditable="true"]', function() {
//     $(this).css('background-color', '#fffacd');
// });

// $(document).on('focusout', '#leavetable td[contenteditable="true"]', function() {
//     $(this).css('background-color', '');
// });



</script>