<style>
    th {
        background-color: #0d40a9 !important;
        color: white !important;
        font-weight: bold;
        padding: 10px;
        letter-spacing: 0.5px;
        border: 1px solid black; 
    }
    
    .form-section {
        background-color: #f8f9fa;
        padding: 20px;
        border-radius: 8px;
        margin-bottom: 20px;
        border: 1px solid #dee2e6;
    }
    
    .form-section h5 {
        color: #0d40a9;
        margin-bottom: 15px;
        font-weight: bold;
    }
    
</style>

<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1">Mini & Mega Project Form</div>
                    </div>
                    <div class="card-body">
                        <form role="form" id="Form" method="post">
                            <!-- Hidden field for main excel ID -->
                            <input type="hidden" id="main_excel_id" name="main_excel_id" 
                                   value="<?= !empty($childData) && isset($childData[0]->excel_upload_id) ? $childData[0]->excel_upload_id : '' ?>" />

<!-- hidden submenuid -->
<input class="form-control" id="fk_submenuId" name="fk_submenuId" type="hidden"
                           value="<?= isset($subId) ? $subId : '' ?>"  />

                            <!-- Main Dropdown Section -->
                            <div class="row gutters mb-3">
                                <!-- Project Type Selection -->
                                <div class="col-md-3">
                                    <div class="field-wrapper">
                                        <select name="ProjectType" id="ProjectType" class="select-single js-states form-control" required>
                                            <option value="">Select Mini or Mega Project</option>
                                            <?php foreach($projectTypeList as $type): ?>
                                                <?php $savedType = isset($mainData->ProjectType) ? $mainData->ProjectType : ''; ?>
                                                <option value="<?= $type->MiMe_ID ?>"
                                                    <?= ($type->MiMe_ID == $savedType) ? 'selected' : '' ?>>
                                                    <?= $type->MiMe_Name ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Mini Or Mega Project <span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <!-- Academic Year Selection -->
                                <div class="col-md-3">
                                    <div class="field-wrapper">
                                        <select name="FiniYear" id="FiniYear" class="select-single js-states form-control" required>
                                            <option value="">Select year</option>
                                            <?php foreach($yearList as $year): ?>
                                                <?php 
                                                    $savedYear = '';
                                                    if (isset($mainData) && isset($mainData->FiniYear)) {
                                                        $savedYear = $mainData->FiniYear;
                                                    } elseif (!empty($childData) && isset($childData[0]->Financial_Year)) {
                                                        $savedYear = $childData[0]->Financial_Year;
                                                    }
                                                ?>
                                                <option value="<?= $year->finiYear_id ?>"
                                                    <?= ($year->finiYear_id == $savedYear) ? 'selected' : '' ?>>
                                                    <?= $year->fini_Label ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Academic Year <span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <!-- Branch/Department Selection -->
                                <div class="col-md-3">
                                    <div class="field-wrapper">
                                        <select name="BranchID" id="BranchID" class="select-single js-states form-control" required>
                                            <option value="">Select Branch/Department</option>
                                            <?php foreach($branchList as $branch): ?>
                                                <?php $savedBranch = isset($mainData->BranchID) ? $mainData->BranchID : ''; ?>
                                                <option value="<?= $branch->branch_id ?>"
                                                    <?= ($branch->branch_id == $savedBranch) ? 'selected' : '' ?>>
                                                    <?= $branch->branch_name ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Branch/Department <span class="text-danger">*</span></div>
                                    </div>
                                </div>
                            </div>


                            <!-- Data Entry Form Section -->
                            <!-- <div class="form-section"> -->
                                <!-- <h5><i class="fa fa-edit"></i> Enter Project Details</h5> -->
                                <div class="row gutters">
                                    <div class="col-md-2">
                                        <div class="field-wrapper">
                                            <input type="text" id="input_group_no" class="form-control" placeholder="Group No">
                                            <div class="field-placeholder">Group No.<span class="text-danger">*</span></div>			
                                       
                                        </div>
                                    </div>

                                    <div class="col-md-2">
                                        <div class="field-wrapper">
                                            
                                            <input type="text" id="input_roll_no" class="form-control" placeholder="Roll No">
                                            <div class="field-placeholder">Roll No.</div>
													
                                        </div>
                                    </div>

                                    
                                    <div class="col-md-2">
                                     
                                            <div class="field-wrapper">
                                             <input
    type="text"
    id="input_prn"
    class="form-control"
    maxlength="16"
    pattern="\d{16}"
 
    oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 16)">
 
                                            <div class="field-placeholder">PRN No.</div>
													
                                        </div>
                                    </div>
                                    <!-- MODIFIED: Class Dropdown -->
                                    <div class="col-md-2">
                                        <div class="field-wrapper">
                                            <select id="input_class" class="select-single js-states form-control">
                                                <option value="">Select Class</option>
                                                <?php foreach($classList as $class): ?>
                                                    <option value="<?= $class->class_id ?>"><?= $class->classname ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <div class="field-placeholder">Class</div>
                                        </div>
                                    </div>
                                    <!-- MODIFIED: Division Dropdown -->
                                    <div class="col-md-2">
                                        <div class="field-wrapper">
                                            <select id="input_division" class="select-single js-states form-control">
                                                <option value="">Select Division</option>
                                                <?php foreach($divisionList as $division): ?>
                                                    <option value="<?= $division->div_id ?>"><?= $division->div_name ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <div class="field-placeholder">Division</div>
                                        </div>
                                    </div>
                                    <!-- MODIFIED: Student Dropdown -->
                                    <div class="col-md-2">
                                        <div class="field-wrapper">
                                            <select id="input_student_name" class="select-single js-states form-control">
                                                <option value="">Select Student</option>
                                                <?php foreach($studentList as $student): ?>
                                                    <option value="<?= $student->Student_id ?>"><?= $student->FullName ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <div class="field-placeholder">Student Name <span class="text-danger">*</span></div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row gutters mt-3">
                                    <div class="col-md-3">
                                        <div class="field-wrapper">
                                            
                                            <input type="text" id="input_guide_name" class="form-control" placeholder="Guide Name">
                                            <div class="field-placeholder">Guide Name</div>
													
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="field-wrapper">
                                            <input type="text" id="input_project_title" class="form-control" placeholder="Project Title">
                                                <div class="field-placeholder">Project Title<span class="text-danger">*</span></div>
												
                                        </div>
                                    </div>
                                    <!-- MODIFIED: Sponsorship Dropdown -->
                                    <div class="col-md-2">
                                        <div class="field-wrapper">
                                            <select id="input_sponsorship" class="select-single js-states form-control">
                                                <option value="">Select Sponsorship</option>
                                                <?php foreach($sponsorList as $sponsor): ?>
                                                    <option value="<?= $sponsor->type_id ?>"><?= $sponsor->type_name ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <div class="field-placeholder">Sponsorship</div>
                                        </div>
                                    </div>
                                    <!-- MODIFIED: Rank Dropdown -->
                                    <div class="col-md-2">
                                        <div class="field-wrapper">
                                            <select id="input_rank" class="select-single js-states form-control">
                                                <option value="">Select Rank</option>
                                                <?php foreach($rankList as $rank): ?>
                                                    <option value="<?= $rank->rank_id ?>"><?= $rank->rank_name ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <div class="field-placeholder">Rank</div>
                                        </div>
                                    </div>
                                    <div class="col-md-1 mt-1">
                                        
                                            
                                            <button type="button" class="btn btn-primary btn-block" id="addEntryBtn">
                                                <i class="fa fa-plus"></i> Add
                                            </button>
                                    </div>
                                </div>
                            <!-- </div> -->

                            <!-- Data Table -->
                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 mt-4">
                                <div class="table-responsive" id="printableTable">
                                    <!-- <div class="float-end mb-2">
                                        <?php if (!empty($childData)): ?>
                                            <button class="btn btn-danger btn-sm m-1" type="button" id="btnClearAll">
                                                <i class="fas fa-times"></i> Clear All
                                            </button>
                                        <?php endif; ?>
                                    </div> -->

                                    <table id="leavetable" class="table custom-table">
                                        <thead>
                                            <tr>
                                                <th class="text-white">Sr.No</th>
                                                <th style=" min-width:150px;" class="text-white">Group No</th>
                                                <th style=" min-width:150px;" class="text-white">Roll No.</th>
                                                <th style=" min-width:150px;" class="text-white">PRN No.</th>
                                                <th style=" min-width:150px;" class="text-white">Class</th>
                                                <th style=" min-width:150px;" class="text-white">Division</th>
                                                <th style=" min-width:240px;" class="text-white">Student Name</th>
                                                <th style=" min-width:240px;" class="text-white">Guide Name</th>
                                                <th style=" min-width:240px;" class="text-white">Project Title</th>
                                                <th style=" min-width:200px;" class="text-white">Department/Branch</th>
                                                <th style=" min-width:200px;" class="text-white">Project Type</th>
                                                <th style=" min-width:200px;" class="text-white">Academic Year</th>
                                                <th style=" min-width:180px;" class="text-white">Sponsorship</th>
                                                <th style=" min-width:200px;" class="text-white">Rank</th>
                                                <th style=" min-width:150px;" class="text-white">Action</th>
                                            </tr>
                                        </thead>
                                        <tbody id="tableBody">
                                            <?php if(!empty($childData)): 
                                                $i = 1;
                                                $selectedProjectTypeText = '';
                                                $selectedYearText = '';
                                                if(isset($mainData->ProjectType)) {
                                                    foreach($projectTypeList as $type) {
                                                        if($type->MiMe_ID == $mainData->ProjectType) {
                                                            $selectedProjectTypeText = $type->MiMe_Name;
                                                            break;
                                                        }
                                                    }
                                                }
                                                if(isset($mainData->FiniYear)) {
                                                    foreach($yearList as $year) {
                                                        if($year->finiYear_id == $mainData->FiniYear) {
                                                            $selectedYearText = $year->fini_Label;
                                                            break;
                                                        }
                                                    }
                                                }

                                                foreach($childData as $row): ?>
                                                <tr>
                                                    <td><?= $i++ ?></td>
                                                    <td>
                                                        <input type="hidden" name="project_id[]" value="<?= $row->project_id ?>">
                                                        <input type="text" name="group_no[]" class="form-control" placeholder="Group No" value="<?= $row->group_no ?? '' ?>">
                                                    </td>
                                                    <td><input type="text" name="roll_no[]" class="form-control" placeholder="Roll No" value="<?= $row->roll_no ?>"></td>
                                                    <td><input type="text" name="prn[]" class="form-control" placeholder="PRN" value="<?= $row->prn ?>"></td>
                                                    <!-- MODIFIED: Class Dropdown in Table -->
                                                    <td>
                                                        <select name="class[]" class="form-control">
                                                            <?php foreach($classList as $class): ?>
                                                                <option value="<?= $class->class_id ?>" <?= ($class->class_id == $row->class) ? 'selected' : '' ?>><?= $class->classname ?></option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                    <!-- MODIFIED: Division Dropdown in Table -->
                                                    <td>
                                                        <select name="division[]" class="form-control">
                                                            <?php foreach($divisionList as $division): ?>
                                                                <option value="<?= $division->div_id ?>" <?= ($division->div_id == $row->division) ? 'selected' : '' ?>><?= $division->div_name ?></option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                    <!-- MODIFIED: Student Dropdown in Table -->
                                                    <td>
                                                        <select name="student_name[]" class="form-control">
                                                            <?php foreach($studentList as $student): ?>
                                                                <option value="<?= $student->Student_id ?>" <?= ($student->Student_id == $row->student_name) ? 'selected' : '' ?>><?= $student->FullName ?></option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                    <td><input type="text" name="guide_name[]" class="form-control" placeholder="Guide Name" value="<?= $row->guide_name ?>"></td>
                                                    <td><input type="text" name="project_title[]" class="form-control" placeholder="Project Title" value="<?= $row->project_title ?>"></td>
                                                    <td><input type="text" name="department[]" class="form-control" value="<?= $row->department ?? '' ?>" readonly></td>
                                                    <td><input type="text" name="project_type[]" class="form-control" value="<?= $selectedProjectTypeText ?>" readonly></td>
                                                    <td><input type="text" name="academic_year[]" class="form-control" value="<?= $selectedYearText ?>" readonly></td>
                                                    <!-- MODIFIED: Sponsorship Dropdown in Table -->
                                                    <td>
                                                        <select name="fk_sponser[]" class="form-control">
                                                            <?php foreach($sponsorList as $sponsor): ?>
                                                                <option value="<?= $sponsor->type_id ?>" <?= ($sponsor->type_id == $row->fk_sponser) ? 'selected' : '' ?>><?= $sponsor->type_name ?></option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                    <!-- MODIFIED: Rank Dropdown in Table -->
                                                    <td>
                                                        <select name="rank[]" class="form-control">
                                                            <?php foreach($rankList as $rank): ?>
                                                                <option value="<?= $rank->rank_id ?>" <?= ($rank->rank_id == $row->rank) ? 'selected' : '' ?>><?= $rank->rank_name ?></option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                    <td>
                                                        <button type="button" class="btn text-danger btn-sm removeRow">
                                                            <i class="fa-solid fa-trash"></i>
                                                        </button>
                                                    </td>
                                                </tr>
                                            <?php endforeach; endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            </div>

                            <!-- Action Buttons -->
                            <div class="card-body">
                                <div class="">
                                    <button type="button" class="btn mb-md-0 mb-2 btn-quarternary" id="btn_save">
                                        <i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save
                                    </button>
                                    <a class="btn mb-md-0 mb-2 btn-quarternary1" href="<?=base_url()?>admin/MiniAdd/index" type="button">
                                        <i class="fa-solid fa-list"></i>&nbsp;&nbsp;List
                                    </a>
                                    <!-- <button class="btn mb-md-0 mb-2 btn-quarternaryhome" type="button" onclick="window.location.href='<?= base_url() ?>admin/MiniAdd/dashboard'">
                                        <i class="fa-solid fa-home"></i>&nbsp;&nbsp;Home
                                    </button> -->

                                    <button type="button"
    class="btn mb-md-0 mb-2 btn-quarternaryhome"
    onclick="window.location.href='<?= base_url('admin/MiniAdd/dashboard') ?>'">
    
    <i class="fa-solid fa-home fa-lg"></i>
    <span class="fw-semibold">Home</span>

</button>

                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Scripts -->
<script src="<?php echo base_url();?>Assets/js/jquery.min.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<!-- <script>
var baseURL = '<?= base_url() ?>';
var childDataCount = <?= !empty($childData) ? count($childData) : 0 ?>;

// Pass PHP arrays to JavaScript for use in addRow function
var classList = <?= json_encode($classList) ?>;
var divisionList = <?= json_encode($divisionList) ?>;
var studentList = <?= json_encode($studentList) ?>;
var sponsorList = <?= json_encode($sponsorList) ?>;
var rankList = <?= json_encode($rankList) ?>;

 $(document).ready(function () {
    let rowCount = typeof childDataCount !== 'undefined' ? childDataCount : 0;
    
    /**
     * Helper function to create a dropdown HTML string
     */
    function createDropdown(options, selectedValue, name) {
        let dropdownHtml = `<select name="${name}" class="form-control">`;
        options.forEach(item => {
            const isSelected = (item.id || item.value || item.type_id || item.rank_id || item.Student_id) == selectedValue ? 'selected' : '';
            dropdownHtml += `<option value="${item.id || item.value || item.type_id || item.rank_id || item.Student_id}" ${isSelected}>${item.name || item.text || item.type_name || item.rank_name || item.FullName}</option>`;
        });
        dropdownHtml += '</select>';
        return dropdownHtml;
    }

    /**
     * Adds a new row to the table with the given data.
     */
    function addRow(groupNo = "", rollNo = "", prn = "", classId = "", divisionId = "", studentId = "", guideName = "", projectTitle = "", department = "", projectType = "", academicYear = "", sponsorshipId = "", rankId = "", projectId = "") {
        rowCount++;
        
        // Prepare data for dropdowns
        const classOptions = classList.map(c => ({ id: c.class_id, name: c.classname }));
        const divisionOptions = divisionList.map(d => ({ id: d.div_id, name: d.div_name }));
        const studentOptions = studentList.map(s => ({ id: s.Student_id, name: s.FullName }));
        const sponsorOptions = sponsorList.map(s => ({ id: s.type_id, name: s.type_name }));
        const rankOptions = rankList.map(r => ({ id: r.rank_id, name: r.rank_name }));

        let newRow = `
            <tr>
                <td>${rowCount}</td>
                <td>
                    <input type="hidden" name="project_id[]" value="${projectId}">
                    <input type="text" name="group_no[]" class="form-control" placeholder="Group No" value="${groupNo}">
                </td>
                <td><input type="text" name="roll_no[]" class="form-control" placeholder="Roll No" value="${rollNo}"></td>
                <td><input type="text" name="prn[]" class="form-control" placeholder="PRN" value="${prn}"></td>
                <td>${createDropdown(classOptions, classId, 'class[]')}</td>
                <td>${createDropdown(divisionOptions, divisionId, 'division[]')}</td>
                <td>${createDropdown(studentOptions, studentId, 'student_name[]')}</td>
                <td><input type="text" name="guide_name[]" class="form-control" placeholder="Guide Name" value="${guideName}"></td>
                <td><input type="text" name="project_title[]" class="form-control" placeholder="Project Title" value="${projectTitle}"></td>
                <td><input type="text" name="department[]" class="form-control" value="${department}" readonly></td>
                <td><input type="text" name="project_type[]" class="form-control" value="${projectType}" readonly></td>
                <td><input type="text" name="academic_year[]" class="form-control" value="${academicYear}" readonly></td>
                <td>${createDropdown(sponsorOptions, sponsorshipId, 'fk_sponser[]')}</td>
                <td>${createDropdown(rankOptions, rankId, 'rank[]')}</td>
                <td>
                    <button type="button" class="btn text-danger btn-sm removeRow">
                        <i class="fa-solid fa-trash"></i>
                    </button>
                </td>
            </tr>`;
        $("#tableBody").append(newRow);
        updateSerialNumbers();
    }

    // Add Entry Button Click
    $("#addEntryBtn").click(function () {
        // Validate required fields
        let projectType = $("#ProjectType").val();
        let finiYear = $("#FiniYear").val();
        let branchId = $("#BranchID").val();
        let groupNo = $("#input_group_no").val().trim();
        let studentName = $("#input_student_name").val();
        let projectTitle = $("#input_project_title").val().trim();

        if (!projectType || !finiYear || !branchId) {
            Swal.fire("Error", "Please select Project Type, Academic Year, and Branch/Department first!", "error");
            return;
        }

        if (!groupNo) {
            Swal.fire("Error", "Group No is required!", "error");
            return;
        }

        if (!studentName) {
            Swal.fire("Error", "Student Name is required!", "error");
            return;
        }

        if (!projectTitle) {
            Swal.fire("Error", "Project Title is required!", "error");
            return;
        }

        // Get dropdown text values for readonly fields
        let selectedBranch = $("#BranchID option:selected").text().trim();
        let selectedProjectType = $("#ProjectType option:selected").text().trim();
        let selectedAcademicYear = $("#FiniYear option:selected").text().trim();

        // Get input values
        let rollNo = $("#input_roll_no").val().trim();
        let prn = $("#input_prn").val().trim();
        let classId = $("#input_class").val();
        let divisionId = $("#input_division").val();
        let guideName = $("#input_guide_name").val().trim();
        let sponsorshipId = $("#input_sponsorship").val();
        let rankId = $("#input_rank").val();

        // Add row to table
        addRow(
            groupNo,
            rollNo,
            prn,
            classId,
            divisionId,
            studentName,
            guideName,
            projectTitle,
            selectedBranch,
            selectedProjectType,
            selectedAcademicYear,
            sponsorshipId,
            rankId,
            ""
        );

        // Clear input fields
        $("#input_group_no").val("");
        $("#input_roll_no").val("");
        $("#input_prn").val("");
        $("#input_class").val("");
        $("#input_division").val("");
        $("#input_student_name").val("");
        $("#input_guide_name").val("");
        $("#input_project_title").val("");
        $("#input_sponsorship").val("");
        $("#input_rank").val("");

        // Focus on first field
        $("#input_group_no").focus();
    });

    // Remove Row Button
    $(document).on("click", ".removeRow", function () {
        let projectId = $(this).closest('tr').find("input[name='project_id[]']").val();
        
        // If project has an ID (exists in database), confirm deletion
        if (projectId && projectId !== '') {
            Swal.fire({
                title: 'Are you sure?',
                text: 'Do you want to delete this project?',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: baseURL + 'admin/MiniAdd/deleteProject',
                        type: 'POST',
                        data: { project_id: projectId },
                        dataType: 'json',
                        success: function(response) {
                            if (response.status === 'success') {
                                $(this).closest("tr").remove();
                                updateSerialNumbers();
                                Swal.fire('Deleted!', 'Project has been deleted.', 'success');
                            } else {
                                Swal.fire('Error', response.message || 'Failed to delete', 'error');
                            }
                        }.bind(this),
                        error: function() {
                            Swal.fire('Error', 'Failed to delete. Please try again.', 'error');
                        }
                    });
                }
            });
        } else {
            // Just remove the row if it's not saved yet
            $(this).closest("tr").remove();
            updateSerialNumbers();
        }
    });

    // Clear All Button
    $("#btnClearAll").click(function () {
        Swal.fire({
            title: 'Are you sure?',
            text: 'This will clear all rows from the table!',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, clear all!'
        }).then((result) => {
            if (result.isConfirmed) {
                $("#tableBody").empty();
                rowCount = 0;
                Swal.fire('Cleared!', 'Table cleared successfully.', 'success');
            }
        });
    });

    // Save Button
    $("#btn_save").click(function (e) {
        e.preventDefault();

        if ($("#tableBody tr").length === 0) {
            Swal.fire("Error", "Please add at least one project!", "error");
            return;
        }

        let formData = new FormData($("#Form")[0]);

        // Determine save URL based on whether we have project_id fields
        let hasProjectIds = $("input[name='project_id[]']").filter(function() {
            return $(this).val() !== '';
        }).length > 0;
        
        let saveUrl = hasProjectIds ? 
            baseURL + 'admin/MiniAdd/updateMiniProject' : 
            baseURL + 'admin/MiniAdd/insertMiniProject';

        $.ajax({
            url: saveUrl,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            beforeSend: function() {
                $("#btn_save").prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');
            },
            success: function (response) {
                $("#btn_save").prop('disabled', false).html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
                
                if (response.status === 'success') {
                   Swal.fire({
  position: 'center',
  icon: 'success',
  title: '<strong>Success!</strong>',
  html: 'Data Submitted Successfully',
  showConfirmButton: false,
  timer: 2000,
  customClass: {
    popup: 'custom-swal-popup',
    icon: 'custom-swal-icon',
    title: 'custom-swal-title',
    htmlContainer: 'custom-swal-text'
  }
}).then(() => {
                        window.location.href = baseURL + 'admin/MiniAdd/index';
                    });
                } else {
                    Swal.fire('Error', response.message || 'Failed to save', 'error');
                }
            },
            error: function (xhr, status, error) {
                $("#btn_save").prop('disabled', false).html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
                console.error('Save Error:', error);
                Swal.fire('Error', 'Failed to save data. Please try again.', 'error');
            }
        });
    });

    // Helper function to update serial numbers
    function updateSerialNumbers() {
        $("#tableBody tr").each(function(index) {
            $(this).find("td:first").text(index + 1);
        });
        rowCount = $("#tableBody tr").length;
    }
});
</script> -->

<script>
var baseURL = '<?= base_url() ?>';
var childDataCount = <?= !empty($childData) ? count($childData) : 0 ?>;

// Pass PHP arrays to JavaScript
var classList = <?= json_encode($classList) ?>;
var divisionList = <?= json_encode($divisionList) ?>;
var studentList = <?= json_encode($studentList) ?>;
var sponsorList = <?= json_encode($sponsorList) ?>;
var rankList = <?= json_encode($rankList) ?>;

$(document).ready(function () {

// ✅ dropdown safe set (edit/update ke liye)
function setSelectValue(selector, value) {
    if (value && value !== "0") {
        $(selector).val(value).trigger("change");
    } else {
        $(selector).val("").trigger("change"); // stays on "Select ..."
    }
}

// ✅ reset all inputs + dropdowns (Add ke baad)
function resetInputs() {
    $("#input_group_no").val("");
    $("#input_roll_no").val("");
    $("#input_prn").val("");

    $("#input_class").val("").trigger("change");
    $("#input_division").val("").trigger("change");
    $("#input_student_name").val("").trigger("change");
    $("#input_sponsorship").val("").trigger("change");
    $("#input_rank").val("").trigger("change");

    $("#input_guide_name").val("");
    $("#input_project_title").val("");
}

    
    let rowCount = typeof childDataCount !== 'undefined' ? childDataCount : 0;
    let isEditMode = rowCount > 0; // Detect if we're in edit mode
    
    // Hide Clear All, Delete and Add buttons if in edit mode
    if (isEditMode) {
        $("#btnClearAll").hide();
        $("#addEntryBtn").hide();
        $(".removeRow").hide();
    }
    
    // Initialize Select2
    $('.select-single').select2({
        width: '100%'
    });
    
    /**
     * Helper function to create a dropdown HTML string
     */
    function createDropdown(options, selectedValue, name, includeEmpty = true) {
        let dropdownHtml = `<select name="${name}" class="form-control select2-table">`;
        if (includeEmpty) {
            dropdownHtml += '<option value="">Select</option>';
        }
        options.forEach(item => {
            const itemValue = item.class_id || item.div_id || item.Student_id || item.type_id || item.rank_id;
            const itemText = item.classname || item.div_name || item.FullName || item.type_name || item.rank_name;
            const isSelected = itemValue == selectedValue ? 'selected' : '';
            dropdownHtml += `<option value="${itemValue}" ${isSelected}>${itemText}</option>`;
        });
        dropdownHtml += '</select>';
        return dropdownHtml;
    }

    /**
     * Initialize Select2 for table dropdowns
     */
    function initTableSelect2() {
        $('.select2-table').select2({
            width: '100%',
            dropdownAutoWidth: true
        });
    }

    /**
     * Adds a new row to the table with the given data.
     */
    function addRow(groupNo = "", rollNo = "", prn = "", classId = "", divisionId = "", studentId = "", guideName = "", projectTitle = "", department = "", projectType = "", academicYear = "", sponsorshipId = "", rankId = "", projectId = "") {
        rowCount++;
        
        let newRow = `
            <tr>
                <td>${rowCount}</td>
                <td>
                    <input type="hidden" name="project_id[]" value="${projectId}">
                    <input type="text" name="group_no[]" class="form-control group-input" placeholder="Group No" value="${groupNo}">
                </td>
                <td><input type="text" name="roll_no[]" class="form-control roll-input" placeholder="Roll No" value="${rollNo}"></td>
                <td><input type="text" name="prn[]" class="form-control prn-input" placeholder="PRN" value="${prn}"></td>
                <td>${createDropdown(classList, classId, 'class[]', false)}</td>
                <td>${createDropdown(divisionList, divisionId, 'division[]', false)}</td>
                <td>${createDropdown(studentList, studentId, 'student_name[]', false)}</td>
                <td><input type="text" name="guide_name[]" class="form-control guide-input" placeholder="Guide Name" value="${guideName}"></td>
                <td><input type="text" name="project_title[]" class="form-control title-input" placeholder="Project Title" value="${projectTitle}"></td>
                <td><input type="text" name="department[]" class="form-control" value="${department}" readonly></td>
                <td><input type="text" name="project_type[]" class="form-control" value="${projectType}" readonly></td>
                <td><input type="text" name="academic_year[]" class="form-control" value="${academicYear}" readonly></td>
                <td>${createDropdown(sponsorList, sponsorshipId, 'fk_sponser[]', false)}</td>
                <td>${createDropdown(rankList, rankId, 'rank[]', false)}</td>
                <td>
                    <button type="button" class="btn text-danger btn-sm removeRow">
                        <i class="fa-solid fa-trash"></i>
                    </button>
                </td>
            </tr>`;
        $("#tableBody").append(newRow);
        updateSerialNumbers();
        
        // Initialize Select2 for new row
        initTableSelect2();
    }

    // When table values change, update input fields (for first row in edit mode)
    $(document).on('input change', '#tableBody tr:first input, #tableBody tr:first select', function() {
        if (!isEditMode) return;
        
        let $row = $(this).closest('tr');
        
        // Update input fields from first row
        $('#input_group_no').val($row.find('input[name="group_no[]"]').val());
        $('#input_roll_no').val($row.find('input[name="roll_no[]"]').val());
        $('#input_prn').val($row.find('input[name="prn[]"]').val());
        
        // Update Select2 dropdowns properly
        $('#input_class').val($row.find('select[name="class[]"]').val()).trigger('change');
        $('#input_division').val($row.find('select[name="division[]"]').val()).trigger('change');
        $('#input_student_name').val($row.find('select[name="student_name[]"]').val()).trigger('change');
        $('#input_sponsorship').val($row.find('select[name="fk_sponser[]"]').val()).trigger('change');
        $('#input_rank').val($row.find('select[name="rank[]"]').val()).trigger('change');
        
        $('#input_guide_name').val($row.find('input[name="guide_name[]"]').val());
        $('#input_project_title').val($row.find('input[name="project_title[]"]').val());
    });

    // When input fields change, update first row of table
    $('#input_group_no, #input_roll_no, #input_prn, #input_guide_name, #input_project_title').on('input', function() {
        if (!isEditMode || $("#tableBody tr").length === 0) return;
        
        let $firstRow = $("#tableBody tr:first");
        let fieldName = $(this).attr('id').replace('input_', '');
        
        if (fieldName === 'group_no') {
            $firstRow.find('input[name="group_no[]"]').val($(this).val());
        } else if (fieldName === 'roll_no') {
            $firstRow.find('input[name="roll_no[]"]').val($(this).val());
        } else if (fieldName === 'prn') {
            $firstRow.find('input[name="prn[]"]').val($(this).val());
        } else if (fieldName === 'guide_name') {
            $firstRow.find('input[name="guide_name[]"]').val($(this).val());
        } else if (fieldName === 'project_title') {
            $firstRow.find('input[name="project_title[]"]').val($(this).val());
        }
    });

    // When dropdown inputs change, update first row and all rows for main dropdowns
    $('#input_class, #input_division, #input_student_name, #input_sponsorship, #input_rank').on('change', function() {
        if (!isEditMode || $("#tableBody tr").length === 0) return;
        
        let $firstRow = $("#tableBody tr:first");
        let fieldName = $(this).attr('id').replace('input_', '');
        
        if (fieldName === 'class') {
            $firstRow.find('select[name="class[]"]').val($(this).val());
        } else if (fieldName === 'division') {
            $firstRow.find('select[name="division[]"]').val($(this).val());
        } else if (fieldName === 'student_name') {
            $firstRow.find('select[name="student_name[]"]').val($(this).val());
        } else if (fieldName === 'sponsorship') {
            $firstRow.find('select[name="fk_sponser[]"]').val($(this).val());
        } else if (fieldName === 'rank') {
            $firstRow.find('select[name="rank[]"]').val($(this).val());
        }
    });

    // When main dropdowns change (Branch, Year, Project Type), update all table rows
    $('#BranchID, #FiniYear, #ProjectType').on('change', function() {
        if (!isEditMode || $("#tableBody tr").length === 0) return;
        
        let fieldName = $(this).attr('id');
        let selectedText = $(this).find('option:selected').text().trim();
        
        $("#tableBody tr").each(function() {
            if (fieldName === 'BranchID') {
                $(this).find('input[name="department[]"]').val(selectedText);
            } else if (fieldName === 'FiniYear') {
                $(this).find('input[name="academic_year[]"]').val(selectedText);
            } else if (fieldName === 'ProjectType') {
                $(this).find('input[name="project_type[]"]').val(selectedText);
            }
        });
    });

    // Populate input fields from existing data on page load
    if (isEditMode && $("#tableBody tr").length > 0) {
        let $firstRow = $("#tableBody tr:first");
        
        $('#input_group_no').val($firstRow.find('input[name="group_no[]"]').val());
        $('#input_roll_no').val($firstRow.find('input[name="roll_no[]"]').val());
        $('#input_prn').val($firstRow.find('input[name="prn[]"]').val());
        

        // ✅ YAHI replace karo dropdown ke liye
    setSelectValue('#input_class',        $firstRow.find('select[name="class[]"]').val());
    setSelectValue('#input_division',     $firstRow.find('select[name="division[]"]').val());
    setSelectValue('#input_student_name', $firstRow.find('select[name="student_name[]"]').val());
    setSelectValue('#input_sponsorship',  $firstRow.find('select[name="fk_sponser[]"]').val());
    setSelectValue('#input_rank',         $firstRow.find('select[name="rank[]"]').val());

        // Set Select2 values properly with trigger
        // $('#input_class').val($firstRow.find('select[name="class[]"]').val()).trigger('change');
        // $('#input_division').val($firstRow.find('select[name="division[]"]').val()).trigger('change');
        // $('#input_student_name').val($firstRow.find('select[name="student_name[]"]').val()).trigger('change');
        // $('#input_sponsorship').val($firstRow.find('select[name="fk_sponser[]"]').val()).trigger('change');
        // $('#input_rank').val($firstRow.find('select[name="rank[]"]').val()).trigger('change');
        
        $('#input_guide_name').val($firstRow.find('input[name="guide_name[]"]').val());
        $('#input_project_title').val($firstRow.find('input[name="project_title[]"]').val());
        
        // Initialize Select2 for table dropdowns
        initTableSelect2();
    }

    // Add Entry Button Click
    $("#addEntryBtn").click(function () {
        // Validate required fields
        let projectType = $("#ProjectType").val();
        let finiYear = $("#FiniYear").val();
        let branchId = $("#BranchID").val();
        let groupNo = $("#input_group_no").val().trim();
        let studentName = $("#input_student_name").val();
        let projectTitle = $("#input_project_title").val().trim();

        if (!projectType || !finiYear || !branchId) {
            Swal.fire("Error", "Please select Project Type, Academic Year, and Branch/Department first!", "error");
            return;
        }

        if (!groupNo) {
            Swal.fire("Error", "Group No is required!", "error");
            return;
        }

        if (!studentName) {
            Swal.fire("Error", "Student Name is required!", "error");
            return;
        }

        if (!projectTitle) {
            Swal.fire("Error", "Project Title is required!", "error");
            return;
        }

        // Get dropdown text values for readonly fields
        let selectedBranch = $("#BranchID option:selected").text().trim();
        let selectedProjectType = $("#ProjectType option:selected").text().trim();
        let selectedAcademicYear = $("#FiniYear option:selected").text().trim();

        // Get input values
        let rollNo = $("#input_roll_no").val().trim();
        let prn = $("#input_prn").val().trim();
        let classId = $("#input_class").val();
        let divisionId = $("#input_division").val();
        let guideName = $("#input_guide_name").val().trim();
        let sponsorshipId = $("#input_sponsorship").val();
        let rankId = $("#input_rank").val();

        // Add row to table
        addRow(
            groupNo,
            rollNo,
            prn,
            classId,
            divisionId,
            studentName,
            guideName,
            projectTitle,
            selectedBranch,
            selectedProjectType,
            selectedAcademicYear,
            sponsorshipId,
            rankId,
            ""
        );

        resetInputs();
$("#input_group_no").focus();


        // // Clear input fields
        // $("#input_group_no").val("");
        // $("#input_roll_no").val("");
        // $("#input_prn").val("");
        // $("#input_class").val("");
        // $("#input_division").val("");
        // $("#input_student_name").val("");
        // $("#input_guide_name").val("");
        // $("#input_project_title").val("");
        // $("#input_sponsorship").val("");
        // $("#input_rank").val("");

        // // Focus on first field
        // $("#input_group_no").focus();
    });

    // Remove Row Button
    $(document).on("click", ".removeRow", function () {
        let projectId = $(this).closest('tr').find("input[name='project_id[]']").val();
        
        // If project has an ID (exists in database), confirm deletion
        if (projectId && projectId !== '') {
            Swal.fire({
                title: 'Are you sure?',
                text: 'Do you want to delete this project from database?',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: baseURL + 'admin/MiniAdd/deleteProject',
                        type: 'POST',
                        data: { project_id: projectId },
                        dataType: 'json',
                        success: function(response) {
                            if (response.status === 'success') {
                                $(this).closest("tr").remove();
                                updateSerialNumbers();
                                Swal.fire('Deleted!', 'Project has been deleted.', 'success');
                                
                                // If no rows left, reload page
                                if ($("#tableBody tr").length === 0) {
                                    window.location.href = baseURL + 'admin/MiniAdd/index';
                                }
                            } else {
                                Swal.fire('Error', response.message || 'Failed to delete', 'error');
                            }
                        }.bind(this),
                        error: function() {
                            Swal.fire('Error', 'Failed to delete. Please try again.', 'error');
                        }
                    });
                }
            });
        } else {
            // Just remove the row if it's not saved yet
            $(this).closest("tr").remove();
            updateSerialNumbers();
        }
    });

    // Save Button
    $("#btn_save").click(function (e) {
        e.preventDefault();

        if ($("#tableBody tr").length === 0) {
            Swal.fire("Error", "Please add at least one project!", "error");
            return;
        }

        let formData = new FormData($("#Form")[0]);

        // Use update URL if we have any project_id
        let hasProjectIds = $("input[name='project_id[]']").filter(function() {
            return $(this).val() !== '';
        }).length > 0;
        
        let saveUrl = hasProjectIds ? 
            baseURL + 'admin/MiniAdd/updateMiniProject' : 
            baseURL + 'admin/MiniAdd/insertMiniProject';

        $.ajax({
            url: saveUrl,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            beforeSend: function() {
                $("#btn_save").prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');
            },
            success: function (response) {
                $("#btn_save").prop('disabled', false).html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
                
                if (response.status === 'success') {
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: '<strong>Success!</strong>',
                        html: response.message,
                        showConfirmButton: false,
                        timer: 2000,
                        customClass: {
                            popup: 'custom-swal-popup',
                            icon: 'custom-swal-icon',
                            title: 'custom-swal-title',
                            htmlContainer: 'custom-swal-text'
                        }
                    }).then(() => {
                        window.location.href = baseURL + 'admin/MiniAdd/index';
                    });
                } else {
                    Swal.fire('Error', response.message || 'Failed to save', 'error');
                }
            },
            error: function (xhr, status, error) {
                $("#btn_save").prop('disabled', false).html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
                console.error('Save Error:', error);
                Swal.fire('Error', 'Failed to save data. Please try again.', 'error');
            }
        });
    });

    // Helper function to update serial numbers
    function updateSerialNumbers() {
        $("#tableBody tr").each(function(index) {
            $(this).find("td:first").text(index + 1);
        });
        rowCount = $("#tableBody tr").length;
    }
});
</script>