<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1">MOU Report</div>
                    </div>
                    <div class="card-body">
                        <form role="form" id="Form">
                            <div class="row gutters">
                                <!-- Branch Dropdown -->
                                <div class="col-md-3">
                                    <div class="field-wrapper">
                                        <select class="form-control select-single" name="fkbranch_id[]" id="fkbranch_id" multiple>
                                            <option value="">Select Branch</option>
                                            <?php foreach ($Branch as $b): ?>
                                                <option value="<?= $b->branch_id ?>"><?= $b->branch_name ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Branch</div>
                                    </div>
                                </div>

                                <!-- Year Dropdown -->
                                <div class="col-md-2">
                                    <div class="field-wrapper">
                                        <select class="select-single js-states" name="year" id="year_dropdown">
                                            <option value="0">All Years</option>
                                            <?php 
                                            foreach ($yeardata as $value) {
                                                $selected = ($value->finiYear_id == $active_year_id) ? "selected='selected'" : "";
                                                echo '<option value="'.$value->finiYear_id.'" '.$selected.'>'.$value->fini_Label.'</option>';
                                            }
                                            ?>
                                        </select>
                                        <div class="field-placeholder">Select Year</div>
                                    </div>
                                </div>

                                <!-- Date Filter Toggle -->
                                <div class="col-md-7 d-flex align-items-center">
                                    <a class="mx-4" href="javascript:void(0)" onclick="toggleSection('datewise')" 
                                       style="text-decoration:underline !important; color: #0d6efd; font-size: 14px;">
                                        <i class="fa-solid fa-calendar-days me-2"></i>DateWise
                                    </a>

                                    <div id="datewise_section" class="row d-none">
                                        <div class="col-md-5 mb-3">
                                            <div class="field-wrapper">
                                                <div class="field-placeholder">From Date</div>
                                                <input type="date" class="form-control" id="startdate" name="startdate">
                                            </div>
                                        </div>
                                        <div class="col-md-5 mb-3">
                                            <div class="field-wrapper">
                                                <div class="field-placeholder">To Date</div>
                                                <input type="date" class="form-control" id="enddate" name="enddate">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-2">
                                        <button class="btn btn-success btn-sm m-1" type="button" id="btnShow" 
                                                style="padding: 5px 10px; font-size: 13px; font-weight:600;">
                                            <i class="fas fa-search"></i> Show Data
                                        </button>
                                    </div>
                                </div>
                            </div>

                            <!-- Action Buttons -->
                            <div class="row mt-3">
                                <div class="col-md-12 text-right">
                                    <button class="btn btn-danger btn-sm rounded-3" type="button" onclick="printTable()">
                                        <i class="fas fa-print bg-white p-1 rounded-circle text-danger shadow-lg"></i> Print
                                    </button>
                                    <button type="button" class="btn btn-success btn-sm rounded-3" onclick="exportToExcel()">
                                        <i class="fas fa-file-excel bg-white p-1 rounded-circle text-success shadow-lg"></i>Excel
                                    </button>
                                    <button type="button" class="btn btn-dark btn-sm rounded-3" onclick="window.location.href='<?= base_url() ?>admin/Mou/dashboard'">
                                        <i class="fa-solid fa-home bg-white p-1 rounded-circle text-dark shadow-lg"></i>Home
                                    </button>
                                </div>
                            </div>

                            <!-- Data Table -->
                            <div class="table-responsive mt-3" id="printableTable">
                                <table id="leavetable" class="table custom-table">
                                    <thead style="background-color: #1273eb;">
                                        <tr>
                                            <th>Sr.No.</th>
                                            <th class="no-print">View Details</th>
                                            <th>Industry/Org Name</th>
                                            <th>Branch</th>
                                            <th>Sign Date</th>
                                            <th>Start Date</th>
                                            <th>End Date</th>
                                            <th>Duration</th>
                                            <th>Year</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr><td colspan="9" class="text-center">Please select filters and click "Show Data"</td></tr>
                                    </tbody>
                                </table>
                            </div>

                            <hr>

                            <!-- Graphical Report Section -->
                            <div class="row mb-3">
                                <div class="col-md-12 d-flex align-items-center">
                                    <button type="button" class="btn btn-sm btn-primary me-2" onclick="toggleFilterSection()">
                                        <i class="fas fa-filter shadow-lg"></i> Graphical Report
                                    </button>
                                </div>
                            </div>

                            <!-- Chart Filter Section -->
                            <div id="filterSection" class="card mb-3 p-3" style="display:none;">
                                <div class="row align-items-center">
                                    <!-- Branch Dropdown -->
                                    <div class="col-md-4">
                                        <div class="field-wrapper">
                                            <select class="select-single js-states" id="branchwise_dropdown" name="branchwise_dropdown[]" multiple="multiple">
                                                <option value="">Select Branch</option>
                                                <?php foreach($branchdata as $value){ ?>
                                                    <option value="<?= $value->branch_id ?>"><?= $value->branch_name ?></option>
                                                <?php } ?>
                                            </select>
                                            <div class="field-placeholder">Branch</div>
                                        </div>
                                    </div>

                                    <!-- Year Dropdown -->
                                    <div class="col-md-4">
                                        <div class="field-wrapper">
                                            <select class="select-single js-states" id="year_id" name="year_id[]" multiple="multiple">
                                                <?php foreach($yeardata as $value){ ?>
                                                    <option value="<?= $value->finiYear_id ?>"><?= $value->fini_Label ?></option>
                                                <?php } ?>
                                            </select>
                                            <div class="field-placeholder">Year</div>
                                        </div>
                                    </div>

                                    <!-- Action Buttons -->
                                    <div class="col-md-4 d-flex mb-2 align-items-center">
                                        <button type="button" class="btn btn-success me-2 custom-gradient-btn" id="searchBtn">
                                            <i class="fas fa-search me-1"></i> Search
                                        </button>
                                        <button type="button" class="btn btn-danger btn-sm rounded-3" onclick="printCombinedChart()">
                                            <i class="fas fa-print me-1 bg-white p-1 rounded-circle text-danger shadow-lg"></i> Print
                                        </button>
                                    </div>
                                </div>
                            </div>

                            <!-- Chart Loader -->
                            <div id="chartLoader" style="display:none; text-align:center; margin:20px 0;">
                                <div class="spinner-border text-primary"></div>
                                <p>Loading charts...</p>
                            </div>

                            <!-- Charts Row -->
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="card p-3 text-center">
                                        <h5>Branchwise Chart</h5>
                                        <div style="height:250px; width:100%;">
                                            <canvas id="branchChart"></canvas>
                                            <div id="branchDetails"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="card p-3 text-center">
                                        <h5>Yearwise Chart</h5>
                                        <div style="height:250px;">
                                            <canvas id="yearChart"></canvas>
                                            <div id="yearDetails"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- MOU Details Modal -->
<div class="modal fade" id="mouDetailsModal" tabindex="-1" aria-labelledby="mouDetailsModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title text-center w-100" id="mouDetailsModalLabel">MOU Details</h5>
                <button type="button" class="btn-close custom-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            
            <div class="modal-body">
                <div id="printmodal">
                    <!-- MOU Basic Information -->
                    <div id="mouInfo" class="mb-3 border p-3 rounded bg-light">
                        <div class="row">
                            <div class="col-md-6 mb-2">
                                <b>Sr.No:</b> <span id="modal_srNo"></span>
                            </div>
                            <div class="col-md-6 mb-2">
                                <b>Industry/Org Name:</b> <span id="modal_induName"></span>
                            </div>
                            <div class="col-md-6 mb-2">
                                <b>Branch:</b> <span id="modal_branch"></span>
                            </div>
                            <div class="col-md-6 mb-2">
                                <b>Sign Date:</b> <span id="modal_signdate"></span>
                            </div>
                            <div class="col-md-6 mb-2">
                                <b>Start Date:</b> <span id="modal_startdate"></span>
                            </div>
                            <div class="col-md-6 mb-2">
                                <b>End Date:</b> <span id="modal_enddate"></span>
                            </div>
                            <div class="col-md-6 mb-2">
                                <b>Duration:</b> <span id="modal_duration"></span>
                            </div>
                            <div class="col-md-6 mb-2">
                                <b>Year:</b> <span id="modal_year"></span>
                            </div>
                        </div>
                    </div>

                    <!-- Documents Section -->
                    <div id="documentsInfo" class="mb-3 border p-3 rounded bg-light">
                        <h6 class="mb-3"><b>Documents</b></h6>
                        <div class="row">
                            <div class="col-md-6 mb-2">
                                <b>Certificate:</b>
                                <span id="modal_certificate">
                                    <a href="#" id="link_certificate" target="_blank" style="text-decoration: none;">
                                        <i class="fas fa-file-pdf" style="color: red; font-size: 20px;"></i>
                                    </a>
                                </span>
                            </div>
                            <div class="col-md-6 mb-2">
                                <b>Training:</b>
                                <span id="modal_training">
                                    <a href="#" id="link_training" target="_blank" style="text-decoration: none;">
                                        <i class="fas fa-file-pdf" style="color: red; font-size: 20px;"></i>
                                    </a>
                                </span>
                            </div>
                            <div class="col-md-6 mb-2">
                                <b>Internship:</b>
                                <span id="modal_intership">
                                    <a href="#" id="link_intership" target="_blank" style="text-decoration: none;">
                                        <i class="fas fa-file-pdf" style="color: red; font-size: 20px;"></i>
                                    </a>
                                </span>
                            </div>
                            <div class="col-md-6 mb-2">
                                <b>Guest Lecture:</b>
                                <span id="modal_guestlec">
                                    <a href="#" id="link_guestlec" target="_blank" style="text-decoration: none;">
                                        <i class="fas fa-file-pdf" style="color: red; font-size: 20px;"></i>
                                    </a>
                                </span>
                            </div>
                            <div class="col-md-6 mb-2">
                                <b>Industry Visit:</b>
                                <span id="modal_industryvisit">
                                    <a href="#" id="link_industryvisit" target="_blank" style="text-decoration: none;">
                                        <i class="fas fa-file-pdf" style="color: red; font-size: 20px;"></i>
                                    </a>
                                </span>
                            </div>
                            <div class="col-md-6 mb-2">
                                <b>VAP:</b>
                                <span id="modal_vap">
                                    <a href="#" id="link_vap" target="_blank" style="text-decoration: none;">
                                        <i class="fas fa-file-pdf" style="color: red; font-size: 20px;"></i>
                                    </a>
                                </span>
                            </div>
                            <div class="col-md-6 mb-2">
                                <b>Consultancy:</b>
                                <span id="modal_consultancy">
                                    <a href="#" id="link_consultancy" target="_blank" style="text-decoration: none;">
                                        <i class="fas fa-file-pdf" style="color: red; font-size: 20px;"></i>
                                    </a>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="text-center">
                    <button type="button" class="btn btn-danger btn-sm rounded-3" onclick="printTablemodal()">
                        <i class="fas fa-print bg-white p-1 rounded-circle text-danger shadow-lg"></i> Print
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Scripts -->
<script src="<?php echo base_url();?>Assets/js/jquery.min.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
var base_url = "<?php echo base_url(); ?>";

// Date formatting function
function formatDate(dateStr) {
    if (!dateStr) return '';
    const dateObj = new Date(dateStr);
    const day = String(dateObj.getDate()).padStart(2, '0');
    const month = String(dateObj.getMonth() + 1).padStart(2, '0');
    const year = dateObj.getFullYear();
    return `${day}-${month}-${year}`;
}

// Toggle date section
function toggleSection(type) {
    if (type === 'datewise') {
        document.getElementById('datewise_section').classList.toggle('d-none');
    }
}

// Toggle filter section
function toggleFilterSection() {
    $("#filterSection").slideToggle();
}

// Show Data Button Click - Table
$(document).ready(function () {
    $('#btnShow').click(function () {
        var branch_ids = $('#fkbranch_id').val();
        var year = $('#year_dropdown').val();
        var startdate = $('#startdate').val();
        var enddate = $('#enddate').val();

        // Show loading
        $('#leavetable tbody').html(`
            <tr>
                <td colspan="9" class="text-center">
                    <div class="spinner-border text-primary"></div>
                    <div>Loading data...</div>
                </td>
            </tr>
        `);

        $.ajax({
            url: base_url + 'admin/Mou/showDataByFilters',
            type: 'POST',
            data: { 
                fkbranch_id: branch_ids,
                year: year,
                startdate: startdate,
                enddate: enddate
            },
            dataType: 'json',
            success: function (response) {
                let html = '';

                if (response.length > 0) {
                    $.each(response, function (index, item) {
                        html += `<tr>
                            <td>${index + 1}</td>
                            <td class="no-print">
                                <button type="button" class="btn btn-sm btn-dark btn-view-mou"
                                    data-mouid="${item.mou_id}"
                                    data-indu="${item.Indu_Name}"
                                    data-branch="${item.branch_name}"
                                    data-signdate="${item.SignDate || ''}"
                                    data-startdate="${item.StartDate || ''}"
                                    data-enddate="${item.EndDate || ''}"
                                    data-duration="${item.duration_type}"
                                    data-year="${item.fini_Label}"
                                    data-certificate="${item.Certificate || ''}"
                                    data-training="${item.Training || ''}"
                                    data-intership="${item.Intership || ''}"
                                    data-guestlec="${item.Guest_Lec || ''}"
                                    data-industryvisit="${item.Industry_visit || ''}"
                                    data-vap="${item.VAP || ''}"
                                    data-consultancy="${item.Consultancy || ''}">
                                    <i class="fa fa-eye"></i> View
                                </button>
                            </td>
                            <td>${item.Indu_Name || ''}</td>
                            <td>${item.branch_name || ''}</td>
                            <td>${item.SignDate ? formatDate(item.SignDate) : ''}</td>
                            <td>${item.StartDate ? formatDate(item.StartDate) : ''}</td>
                            <td>${item.EndDate ? formatDate(item.EndDate) : ''}</td>
                            <td>${item.duration_type || ''}</td>
                            <td>${item.fini_Label || ''}</td>
                        </tr>`;
                    });
                } else {
                    html = `<tr><td colspan="9" class="text-center text-danger">No data found</td></tr>`;
                }

                $('#leavetable tbody').html(html);
            },
            error: function() {
                $('#leavetable tbody').html(`<tr><td colspan="9" class="text-center text-danger">Error loading data</td></tr>`);
            }
        });
    });
});

// Handle View MOU Details Button Click
$(document).on('click', '.btn-view-mou', function () {
    let mou_id = $(this).data('mouid');
    let indu_name = $(this).data('indu');
    let branch_name = $(this).data('branch');
    let sign_date = $(this).data('signdate');
    let start_date = $(this).data('startdate');
    let end_date = $(this).data('enddate');
    let duration = $(this).data('duration');
    let year = $(this).data('year');
    
    // File paths
    let certificate = $(this).data('certificate') || '';
    let training = $(this).data('training') || '';
    let intership = $(this).data('intership') || '';
    let guestlec = $(this).data('guestlec') || '';
    let industryvisit = $(this).data('industryvisit') || '';
    let vap = $(this).data('vap') || '';
    let consultancy = $(this).data('consultancy') || '';

    // Fill modal basic info
    $("#modal_srNo").text(mou_id);
    $("#modal_induName").text(indu_name);
    $("#modal_branch").text(branch_name);
    $("#modal_signdate").text(sign_date ? formatDate(sign_date) : '-');
    $("#modal_startdate").text(start_date ? formatDate(start_date) : '-');
    $("#modal_enddate").text(end_date ? formatDate(end_date) : '-');
    $("#modal_duration").text(duration);
    $("#modal_year").text(year);

    const baseUrl = base_url;

    // Reset all PDF links first
    $("#link_certificate").attr('href', '#').hide();
    $("#modal_certificate").html('<span class="text-muted">Not Available</span>');
    
    $("#link_training").attr('href', '#').hide();
    $("#modal_training").html('<span class="text-muted">Not Available</span>');
    
    $("#link_intership").attr('href', '#').hide();
    $("#modal_intership").html('<span class="text-muted">Not Available</span>');
    
    $("#link_guestlec").attr('href', '#').hide();
    $("#modal_guestlec").html('<span class="text-muted">Not Available</span>');
    
    $("#link_industryvisit").attr('href', '#').hide();
    $("#modal_industryvisit").html('<span class="text-muted">Not Available</span>');
    
    $("#link_vap").attr('href', '#').hide();
    $("#modal_vap").html('<span class="text-muted">Not Available</span>');
    
    $("#link_consultancy").attr('href', '#').hide();
    $("#modal_consultancy").html('<span class="text-muted">Not Available</span>');

    // Set available PDFs
    if (certificate && certificate.trim() !== '') {
        $("#link_certificate").attr('href', baseUrl + certificate).show();
        $("#modal_certificate").html(`<a href="${baseUrl + certificate}" target="_blank" style="text-decoration: none;">
            <i class="fas fa-file-pdf" style="color: red; font-size: 20px;"></i>
        </a>`);
    }
    
    if (training && training.trim() !== '') {
        $("#link_training").attr('href', baseUrl + training).show();
        $("#modal_training").html(`<a href="${baseUrl + training}" target="_blank" style="text-decoration: none;">
            <i class="fas fa-file-pdf" style="color: red; font-size: 20px;"></i>
        </a>`);
    }
    
    if (intership && intership.trim() !== '') {
        $("#link_intership").attr('href', baseUrl + intership).show();
        $("#modal_intership").html(`<a href="${baseUrl + intership}" target="_blank" style="text-decoration: none;">
            <i class="fas fa-file-pdf" style="color: red; font-size: 20px;"></i>
        </a>`);
    }
    
    if (guestlec && guestlec.trim() !== '') {
        $("#link_guestlec").attr('href', baseUrl + guestlec).show();
        $("#modal_guestlec").html(`<a href="${baseUrl + guestlec}" target="_blank" style="text-decoration: none;">
            <i class="fas fa-file-pdf" style="color: red; font-size: 20px;"></i>
        </a>`);
    }
    
    if (industryvisit && industryvisit.trim() !== '') {
        $("#link_industryvisit").attr('href', baseUrl + industryvisit).show();
        $("#modal_industryvisit").html(`<a href="${baseUrl + industryvisit}" target="_blank" style="text-decoration: none;">
            <i class="fas fa-file-pdf" style="color: red; font-size: 20px;"></i>
        </a>`);
    }
    
    if (vap && vap.trim() !== '') {
        $("#link_vap").attr('href', baseUrl + vap).show();
        $("#modal_vap").html(`<a href="${baseUrl + vap}" target="_blank" style="text-decoration: none;">
            <i class="fas fa-file-pdf" style="color: red; font-size: 20px;"></i>
        </a>`);
    }
    
    if (consultancy && consultancy.trim() !== '') {
        $("#link_consultancy").attr('href', baseUrl + consultancy).show();
        $("#modal_consultancy").html(`<a href="${baseUrl + consultancy}" target="_blank" style="text-decoration: none;">
            <i class="fas fa-file-pdf" style="color: red; font-size: 20px;"></i>
        </a>`);
    }

    // Show modal
    $('#mouDetailsModal').modal({
        backdrop: 'static',
        keyboard: false
    }).modal('show');
});

// Print Modal Function
function printTablemodal() {
    const printElement = document.getElementById('printmodal');

    $.ajax({
        url: base_url + 'admin/Mou/getPrintHeadings',
        method: 'GET',
        dataType: 'json',
        success: function (heading) {
            const iframe = document.createElement('iframe');
            iframe.style.cssText = 'position:fixed;right:0;bottom:0;width:0;height:0;border:0';
            document.body.appendChild(iframe);

            const doc = iframe.contentWindow.document;

            let logoPath = (heading.logo || 'Assets/images/sit_logo.png').replace(/^\/+/, '');
            const fullLogoPath = base_url + logoPath;

            doc.open();
            doc.write(`
                <html>
                <head>
                    <title>MOU Details</title>
                    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
                    <style>
                        body {
                            font-family: sans-serif;
                            margin: 10px 5px;
                            padding: 0;
                        }
                        .header-section {
                            display: flex;
                            align-items: center;
                            justify-content: center;
                            gap: 10px;
                            margin-bottom: 5px;
                        }
                        .logo-container img {
                            max-height: 80px;
                            max-width: 80px;
                            width: auto;
                            height: auto;
                        }
                        .heading-content {
                            text-align: center;
                        }
                        h4, h6, .sub-heading, .autonomous-badge {
                            margin: 0;
                            padding: 0;
                        }
                        h4 {
                            font-size: 20px;
                            font-weight: bold;
                            color: #d32f2f;
                        }
                        h6 {
                            font-size: 14px;
                            font-weight: normal;
                        }
                        .sub-heading, .autonomous-badge {
                            font-size: 14px;
                        }
                        .border {
                            border: 1px solid #dee2e6 !important;
                        }
                        .bg-light {
                            background-color: #f8f9fa !important;
                        }
                        .no-print {
                            display: none !important;
                        }
                    </style>
                </head>
                <body>
                    <div class="header-section">
                        <div class="logo-container">
                            <img src="${fullLogoPath}" alt="Logo">
                        </div>
                        <div class="heading-content">
                            <h6>${heading.subHead1 || ''}</h6>
                            <h4>${heading.head || ''}</h4>
                            <div class="autonomous-badge">${heading.subHead2 || ''}</div>
                            <div class="sub-heading">${heading.subHead3 || ''}</div>
                        </div>
                    </div>
                    <br>
                    ${printElement.outerHTML}
                </body>
                </html>
            `);
            doc.close();

            iframe.onload = function() {
                setTimeout(function() {
                    iframe.contentWindow.focus();
                    iframe.contentWindow.print();
                }, 500);
            };

            setTimeout(() => {
                document.body.removeChild(iframe);
            }, 3000);
        }
    });
}

// Chart Variables
let branchChart = null;
let yearChart = null;

// Search button for charts
// $("#searchBtn").on("click", function () {
//     $("#chartLoader").show();
//     $("#branchChart").hide();
//     $("#yearChart").hide();
//     $("#branchDetails").html("");
//     $("#yearDetails").html("");

//     let selectedBranches = $("#branchwise_dropdown").val();
//     let selectedYears = $("#year_id").val();
//     let startDate = $('#startdate').val();
//     let endDate = $('#enddate').val();

//     $.ajax({
//         url: base_url + "admin/Mou/getCombinedData",
//         type: "POST",
//         data: {
//             branches: selectedBranches,
//             years: selectedYears,
//             StartDate: startDate,
//             EndDate: endDate
//         },
//         dataType: "json",
//         success: function (response) {
//             if (response.status === "success") {
//                 renderBranchChart({
//                     labels: response.branchData.map(b => b.branch_name),
//                     values: response.branchData.map(b => b.mou_count),
//                     ids: response.branchData.map(b => b.branch_id)
//                 });

//                 renderYearChart({
//                     labels: response.yearData.map(y => y.year),
//                     values: response.yearData.map(y => y.count),
//                     ids: response.yearData.map(y => y.year_id)
//                 });

//                 $("#branchChart").show();
//                 $("#yearChart").show();
//             }
//         },
//         complete: function () {
//             $("#chartLoader").hide();
//         }
//     });
// });
$("#searchBtn").on("click", function () {
    $("#chartLoader").show();
    $("#branchChart").hide();
    $("#yearChart").hide();
    $("#branchDetails").html("");
    $("#yearDetails").html("");

    let selectedBranches = $("#branchwise_dropdown").val();
    let selectedYears = $("#year_id").val();
    let startDate = $('#startdate').val();
    let endDate = $('#enddate').val();

    // Ensure arrays are sent (not null)
    if (!selectedBranches || !Array.isArray(selectedBranches)) selectedBranches = [];
    if (!selectedYears || !Array.isArray(selectedYears)) selectedYears = [];

    console.log('=== SEARCH PARAMETERS ===');
    console.log('Branches:', selectedBranches);
    console.log('Years:', selectedYears);
    console.log('Start Date:', startDate);
    console.log('End Date:', endDate);

    $.ajax({
        url: base_url + "admin/Mou/getCombinedData",
        type: "POST",
        data: {
            branches: selectedBranches,
            years: selectedYears,
            StartDate: startDate,
            EndDate: endDate
        },
        dataType: "json",
        success: function (response) {
            console.log('=== API RESPONSE ===');
            console.log('Full Response:', response);
            
            if (response.status === "success") {
                let hasData = false;

                // Handle Branch Data
                if (response.branchData && response.branchData.length > 0) {
                    console.log('Rendering Branch Chart with:', response.branchData);
                    renderBranchChart({
                        labels: response.branchData.map(b => b.branch_name),
                        values: response.branchData.map(b => parseInt(b.mou_count)),
                        ids: response.branchData.map(b => b.branch_id)
                    });
                    $("#branchChart").show();
                    hasData = true;
                } else {
                    $("#branchChart").hide();
                    $("#branchDetails").html('<div class="alert alert-warning mt-3">No branch data found for selected filters</div>');
                }

                // Handle Year Data
                if (response.yearData && response.yearData.length > 0) {
                    console.log('Rendering Year Chart with:', response.yearData);
                    renderYearChart({
                        labels: response.yearData.map(y => y.year),
                        values: response.yearData.map(y => parseInt(y.count)),
                        ids: response.yearData.map(y => y.year_id)
                    });
                    $("#yearChart").show();
                    hasData = true;
                } else {
                    $("#yearChart").hide();
                    $("#yearDetails").html('<div class="alert alert-warning mt-3">No year data found for selected filters</div>');
                }

                // If no data at all
                if (!hasData) {
                    $("#branchDetails").html('<div class="alert alert-danger mt-3">No data found for selected filters. Please adjust your search criteria.</div>');
                }
            } else {
                $("#branchDetails").html('<div class="alert alert-danger">Error: ' + (response.message || 'Unknown error') + '</div>');
            }
        },
        error: function(xhr, status, error) {
            console.error('=== AJAX ERROR ===');
            console.error('Status:', status);
            console.error('Error:', error);
            console.error('Response:', xhr.responseText);
            $("#branchDetails").html('<div class="alert alert-danger">Error loading data: ' + error + '</div>');
            $("#yearDetails").html('<div class="alert alert-danger">Error loading data: ' + error + '</div>');
        },
        complete: function () {
            $("#chartLoader").hide();
        }
    });
});
// Render Branch Chart
// function renderBranchChart(data) {
//     const ctx = document.getElementById("branchChart").getContext("2d");
//     if (branchChart) branchChart.destroy();

//     branchChart = new Chart(ctx, {
//         type: "pie",
//         data: {
//             labels: data.labels,
//             datasets: [{ data: data.values, borderWidth: 1 }]
//         },
//         options: {
//             responsive: true,
//             maintainAspectRatio: false,
//             onClick: function (event, elements) {
//                 if (elements.length > 0) {
//                     const idx = elements[0].index;
//                     const branchId = data.ids[idx];
//                     const branchName = data.labels[idx];
//                     loadBranchDetails(branchId, branchName);
//                 }
//             }
//         }
//     });
// }

function renderBranchChart(data) {
    console.log('=== RENDERING BRANCH CHART ===');
    console.log('Labels:', data.labels);
    console.log('Values:', data.values);
    
    const ctx = document.getElementById("branchChart").getContext("2d");
    if (branchChart) branchChart.destroy();

    // Check if we have data
    if (!data.labels || data.labels.length === 0) {
        $("#branchChart").hide();
        $("#branchDetails").html('<div class="alert alert-warning">No branch data to display</div>');
        return;
    }

    branchChart = new Chart(ctx, {
        type: "pie",
        data: {
            labels: data.labels,
            datasets: [{
                data: data.values,
                backgroundColor: [
                    'rgba(255, 99, 132, 0.8)',
                    'rgba(54, 162, 235, 0.8)',
                    'rgba(255, 206, 86, 0.8)',
                    'rgba(75, 192, 192, 0.8)',
                    'rgba(153, 102, 255, 0.8)',
                    'rgba(255, 159, 64, 0.8)',
                    'rgba(199, 199, 199, 0.8)',
                    'rgba(83, 102, 255, 0.8)',
                    'rgba(255, 99, 255, 0.8)',
                    'rgba(99, 255, 132, 0.8)'
                ],
                borderWidth: 2
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom'
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            let total = context.dataset.data.reduce((a, b) => a + b, 0);
                            let percentage = ((context.parsed / total) * 100).toFixed(1);
                            return context.label + ': ' + context.parsed + ' MOUs (' + percentage + '%)';
                        }
                    }
                }
            },
            onClick: function (event, elements) {
                if (elements.length > 0) {
                    const idx = elements[0].index;
                    const branchId = data.ids[idx];
                    const branchName = data.labels[idx];
                    console.log('Clicked Branch:', branchName, 'ID:', branchId);
                    loadBranchDetails(branchId, branchName);
                }
            }
        }
    });
}


// Load Branch Details
// function loadBranchDetails(branchId, branchName) {
//     $.ajax({
//         url: base_url + "admin/Mou/getBranchDetails",
//         type: "POST",
//         data: {
//             branch_id: branchId,
//             year: $("#year_id").val(),
//             StartDate: $('#startdate').val(),
//             EndDate: $('#enddate').val()
//         },
//         dataType: "json",
//         beforeSend: function () {
//             $("#branchDetails").html(`<div class="text-center"><div class="spinner-border text-primary"></div><p>Loading ${branchName} details...</p></div>`);
//         },
//         success: function (data) {
//             populateBranchTable(data, branchName);
//         }
//     });
// }

function loadBranchDetails(branchId, branchName) {
    let selectedYears = $("#year_id").val() || [];
    
    console.log('=== LOADING BRANCH DETAILS ===');
    console.log('Branch ID:', branchId);
    console.log('Branch Name:', branchName);
    console.log('Selected Years:', selectedYears);
    
    $.ajax({
        url: base_url + "admin/Mou/getBranchDetails",
        type: "POST",
        data: {
            branch_id: branchId,
            year: selectedYears,
            StartDate: $('#startdate').val(),
            EndDate: $('#enddate').val()
        },
        dataType: "json",
        beforeSend: function () {
            $("#branchDetails").html(`<div class="text-center mt-3"><div class="spinner-border text-primary"></div><p>Loading ${branchName} details...</p></div>`);
        },
        success: function (data) {
            console.log('Branch Details Response:', data);
            if (data && data.length > 0) {
                populateBranchTable(data, branchName);
            } else {
                $("#branchDetails").html(`<div class="alert alert-info mt-3">No MOUs found for ${branchName} with current filters</div>`);
            }
        },
        error: function(xhr, status, error) {
            console.error('Branch Details Error:', error);
            $("#branchDetails").html('<div class="alert alert-danger mt-3">Error loading branch details: ' + error + '</div>');
        }
    });
}

// Populate Branch Table
function populateBranchTable(data, branchName) {
    let html = `
        <div class="card mt-3">
            <div class="card-header bg-primary text-white"><h5>${branchName} - MOU Details</h5></div>
            <div class="card-body branch">
                <table class="table table-bordered">
                    <thead><tr class="head">
                        <th style="color:black !important;">Sr.No</th>
                        <th style="color:black !important;">View</th>
                        <th style="color:black !important;">Industry Name</th>
                        <th style="color:black !important;">Start Date</th>
                        <th style="color:black !important;">End Date</th>
                    </tr></thead>
                    <tbody>`;
    
    if (data.length > 0) {
        data.forEach((row, i) => {
            html += `<tr>
                <td>${i + 1}</td>
                <td>
                    <button type="button" class="btn btn-sm btn-dark btn-view-mou"
                        data-mouid="${row.mou_id || ''}"
                        data-indu="${row.Indu_Name || ''}"
                        data-branch="${row.branch_name || ''}"
                        data-signdate="${row.SignDate || ''}"
                        data-startdate="${row.StartDate || ''}"
                        data-enddate="${row.EndDate || ''}"
                        data-duration="${row.duration_type || ''}"
                        data-year="${row.year || ''}"
                        data-certificate="${row.Certificate || ''}"
                        data-training="${row.Training || ''}"
                        data-intership="${row.Intership || ''}"
                        data-guestlec="${row.Guest_Lec || ''}"
                        data-industryvisit="${row.Industry_visit || ''}"
                        data-vap="${row.VAP || ''}"
                        data-consultancy="${row.Consultancy || ''}">
                        <i class="fa fa-eye"></i>View
                    </button>
                </td>
                <td>${row.Indu_Name || '-'}</td>
                <td>${row.StartDate ? formatDate(row.StartDate) : '-'}</td>
                <td>${row.EndDate ? formatDate(row.EndDate) : '-'}</td>
            </tr>`;
        });
    } else {
        html += `<tr><td colspan="5" class="text-center">No records found</td></tr>`;
    }
    
    html += `</tbody></table></div></div>`;
    $("#branchDetails").html(html);
}

// Render Year Chart
// function renderYearChart(data) {
//     const ctx = document.getElementById("yearChart").getContext("2d");
//     if (yearChart) yearChart.destroy();

//     yearChart = new Chart(ctx, {
//         type: "bar",
//         data: {
//             labels: data.labels,
//             datasets: [{ label: 'MOUs', data: data.values, backgroundColor: "rgba(18,115,235,0.7)" }]
//         },
//         options: {
//             responsive: true,
//             scales: { y: { beginAtZero: true } },
//             onClick: function (event, elements) {
//                 if (elements.length > 0) {
//                     const idx = elements[0].index;
//                     const yearId = data.ids[idx];
//                     const yearLabel = data.labels[idx];
//                     loadYearDetails(yearId, yearLabel);
//                 }
//             }
//         }
//     });
// }

function renderYearChart(data) {
    console.log('=== RENDERING YEAR CHART ===');
    console.log('Labels:', data.labels);
    console.log('Values:', data.values);
    
    const ctx = document.getElementById("yearChart").getContext("2d");
    if (yearChart) yearChart.destroy();

    // Check if we have data
    if (!data.labels || data.labels.length === 0) {
        $("#yearChart").hide();
        $("#yearDetails").html('<div class="alert alert-warning">No year data to display</div>');
        return;
    }

    yearChart = new Chart(ctx, {
        type: "bar",
        data: {
            labels: data.labels,
            datasets: [{
                label: 'Number of MOUs',
                data: data.values,
                backgroundColor: "rgba(18,115,235,0.7)",
                borderColor: "rgba(18,115,235,1)",
                borderWidth: 2
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        stepSize: 1,
                        precision: 0
                    }
                }
            },
            plugins: {
                legend: {
                    display: true,
                    position: 'top'
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return 'MOUs: ' + context.parsed.y;
                        }
                    }
                }
            },
            onClick: function (event, elements) {
                if (elements.length > 0) {
                    const idx = elements[0].index;
                    const yearId = data.ids[idx];
                    const yearLabel = data.labels[idx];
                    console.log('Clicked Year:', yearLabel, 'ID:', yearId);
                    loadYearDetails(yearId, yearLabel);
                }
            }
        }
    });
}

// Load Year Details
// function loadYearDetails(yearId, yearLabel) {
//     $.ajax({
//         url: base_url + "admin/Mou/getYearwiseData",
//         type: "POST",
//         data: {
//             year: yearId,
//             branches: $("#branchwise_dropdown").val(),
//             StartDate: $('#startdate').val(),
//             EndDate: $('#enddate').val()
//         },
//         dataType: "json",
//         beforeSend: function () {
//             $("#yearDetails").html(`<div class="text-center"><div class="spinner-border text-success"></div><p>Loading ${yearLabel} details...</p></div>`);
//         },
//         success: function (response) {
//             if (response.status === "success") {
//                 populateYearTable(response.types, yearLabel);
//             }
//         }
//     });
// }

function loadYearDetails(yearId, yearLabel) {
    let selectedBranches = $("#branchwise_dropdown").val() || [];
    
    console.log('=== LOADING YEAR DETAILS ===');
    console.log('Year ID:', yearId);
    console.log('Year Label:', yearLabel);
    console.log('Selected Branches:', selectedBranches);
    
    $.ajax({
        url: base_url + "admin/Mou/getYearwiseData",
        type: "POST",
        data: {
            year: yearId,
            branches: selectedBranches,
            StartDate: $('#startdate').val(),
            EndDate: $('#enddate').val()
        },
        dataType: "json",
        beforeSend: function () {
            $("#yearDetails").html(`<div class="text-center mt-3"><div class="spinner-border text-success"></div><p>Loading ${yearLabel} details...</p></div>`);
        },
        success: function (response) {
            console.log('Year Details Response:', response);
            if (response.status === "success") {
                if (response.types && response.types.length > 0) {
                    populateYearTable(response.types, yearLabel);
                } else {
                    $("#yearDetails").html(`<div class="alert alert-info mt-3">No MOUs found for ${yearLabel} with current filters</div>`);
                }
            }
        },
        error: function(xhr, status, error) {
            console.error('Year Details Error:', error);
            $("#yearDetails").html('<div class="alert alert-danger mt-3">Error loading year details: ' + error + '</div>');
        }
    });
}

// Populate Year Table
function populateYearTable(data, yearLabel) {
    let html = `
        <div class="card mt-3">
            <div class="card-header bg-success text-white"><h5>${yearLabel} - MOU Details</h5></div>
            <div class="card-body year">
                <table class="table table-bordered">
                    <thead><tr class="head">
                        <th style="color:black !important;">Sr.No</th>
                        <th style="color:black !important;">View</th>
                        <th style="color:black !important;">Industry Name</th>
                        <th style="color:black !important;">Branch</th>
                        <th style="color:black !important;">Start Date</th>
                    </tr></thead>
                    <tbody>`;
    
    if (data.length > 0) {
        data.forEach((row, i) => {
            html += `<tr>
                <td>${i + 1}</td>
                <td>
                    <button type="button" class="btn btn-sm btn-dark btn-view-mou"
                        data-mouid="${row.mou_id || ''}"
                        data-indu="${row.Indu_Name || ''}"
                        data-branch="${row.branch_name || ''}"
                        data-signdate="${row.SignDate || ''}"
                        data-startdate="${row.StartDate || ''}"
                        data-enddate="${row.EndDate || ''}"
                        data-duration="${row.duration_type || ''}"
                        data-year="${row.year || ''}"
                        data-certificate="${row.Certificate || ''}"
                        data-training="${row.Training || ''}"
                        data-intership="${row.Intership || ''}"
                        data-guestlec="${row.Guest_Lec || ''}"
                        data-industryvisit="${row.Industry_visit || ''}"
                        data-vap="${row.VAP || ''}"
                        data-consultancy="${row.Consultancy || ''}">
                        <i class="fa fa-eye"></i>View
                    </button>
                </td>
                <td>${row.Indu_Name || '-'}</td>
                <td>${row.branch_name || '-'}</td>
                <td>${row.StartDate ? formatDate(row.StartDate) : '-'}</td>
            </tr>`;
        });
    } else {
        html += `<tr><td colspan="5" class="text-center">No records found</td></tr>`;
    }
    
    html += `</tbody></table></div></div>`;
    $("#yearDetails").html(html);
}

// Print Table
function printTable() {
    const printElement = document.getElementById('printableTable');
    
    $.ajax({
        url: base_url + "admin/Mou/getPrintHeadings",
        method: 'GET',
        dataType: 'json',
        success: function (heading) {
            const iframe = document.createElement('iframe');
            iframe.style.cssText = 'position:fixed;right:0;bottom:0;width:0;height:0;border:0';
            document.body.appendChild(iframe);
            
            const doc = iframe.contentWindow.document;
            let logoPath = (heading.logo || 'Assets/images/sit_logo.png').replace(/^\/+/, '');
            const fullLogoPath = base_url + logoPath;
            
            doc.open();
            doc.write(`
                <html>
                <head>
                    <title>MOU Report</title>
                    <style>
                        body { font-family: sans-serif; margin: 10px 5px; }
                        .header-section { display: flex; align-items: center; justify-content: center; gap: 10px; margin-bottom: 5px; }
                        .logo-container img { max-height: 80px; max-width: 80px; }
                        .heading-content { text-align: center; }
                        h4, h6, .sub-heading, .autonomous-badge { margin: 0; padding: 0; }
                        h4 { font-size: 20px; font-weight: bold; color: #d32f2f; }
                        h6 { font-size: 14px; }
                        table { width: 100%; border-collapse: collapse; margin-top: 5px; }
                        th, td { border: 1px solid black; padding: 4px; text-align: center; font-size: 12px; }
                        .no-print { display: none !important; }
                    </style>
                </head>
                <body>
                    <div class="header-section">
                        <div class="logo-container"><img src="${fullLogoPath}" alt="Logo"></div>
                        <div class="heading-content">
                            <h6>${heading.subHead1 || ''}</h6>
                            <h4>${heading.head || ''}</h4>
                            <div class="autonomous-badge">${heading.subHead2 || ''}</div>
                            <div class="sub-heading">${heading.subHead3 || ''}</div>
                        </div>
                    </div>
                    <br>
                    ${printElement.outerHTML}
                </body>
                </html>
            `);
            doc.close();
            
            iframe.contentWindow.onload = function() {
                setTimeout(() => {
                    iframe.contentWindow.focus();
                    iframe.contentWindow.print();
                }, 500);
            };
            
            setTimeout(() => document.body.removeChild(iframe), 3000);
        }
    });
}

// Export to Excel
function exportToExcel() {
    $.ajax({
        url: base_url + "admin/Mou/getPrintHeadings",
        method: 'GET',
        dataType: 'json',
        success: function (heading) {
            var wb = XLSX.utils.book_new();
            var header = [
                [heading.subHead1 || ''],
                [heading.head || ''],
                [heading.subHead2 || ''],
                [heading.subHead3 || ''],
                ['']
            ];
            
            var table = document.getElementById('printableTable');
            var wsTable = XLSX.utils.table_to_sheet(table);
            var tableData = XLSX.utils.sheet_to_json(wsTable, { header: 1 });
            var fullData = header.concat(tableData);
            var ws = XLSX.utils.aoa_to_sheet(fullData);
            
            XLSX.utils.book_append_sheet(wb, ws, 'MOU Report');
            XLSX.writeFile(wb, 'MOU_Report.xlsx');
        }
    });
}

// Print Combined Charts
function printCombinedChart() {
    const branchChartImg = branchChart.toBase64Image();
    const yearChartImg = yearChart.toBase64Image();
    const branchTable = document.getElementById("branchDetails").innerHTML;
    const yearTable = document.getElementById("yearDetails").innerHTML;
    
    let printFrame = document.createElement('iframe');
    printFrame.style.cssText = 'position:absolute;width:0;height:0;border:none';
    document.body.appendChild(printFrame);
    
    const frameDoc = printFrame.contentWindow.document;
    frameDoc.open();
    frameDoc.write(`
        <!DOCTYPE html>
        <html>
        <head>
            <title>Charts Print</title>
            <style>
                @page { size: A4; margin: 15mm; }
                body { font-family: Arial, sans-serif; margin: 20px; }
                .chart-section { margin-bottom: 20px; }
                .chart-section h2 { font-size: 18px; margin-bottom: 15px; }
                img { max-width: 100%; height: auto; margin-bottom: 15px; }
                table { width: 100%; border-collapse: collapse; font-size: 11px; }
                th, td { border: 1px solid #333; padding: 6px 8px; }
                th { background: #f2f2f2; font-weight: bold; }
                .page-break { page-break-before: always; }
                .no-print { display: none !important; }
            </style>
        </head>
        <body>
            <div class="chart-section">
                <h2>Branchwise Chart</h2>
                <img src="${branchChartImg}" alt="Branch Chart">
            </div>
            <div class="table-section">${branchTable}</div>
            <div class="chart-section page-break">
                <h2>Yearwise Chart</h2>
                <img src="${yearChartImg}" alt="Year Chart">
            </div>
            <div class="table-section">${yearTable}</div>
        </body>
        </html>
    `);
    frameDoc.close();
    
    setTimeout(() => {
        printFrame.contentWindow.focus();
        printFrame.contentWindow.print();
        setTimeout(() => printFrame.remove(), 100);
    }, 500);
}
</script>