<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <div class="card-title">Photo Gallery</div>
                        
                        <!-- Download ALL Photos Button (One by One) -->
                        <?php if (!empty($photos['local']) || !empty($photos['google'])): ?>
                            <button class="btn btn-primary" id="downloadAllBtn">
                                <i class="fas fa-download"></i> Download All Photos
                            </button>
                        <?php endif; ?>
                    </div>
                    <div class="card-body">
                        <?php if (!empty($photos['local']) || !empty($photos['google'])): ?>
                            <div class="row">
                                <!-- Display Local Photos -->
                                <?php if (!empty($photos['local'])): ?>
                                    <?php foreach ($photos['local'] as $index => $photo): ?>
                                        <div class="col-md-3 col-sm-4 col-6 mb-4">
                                            <div class="photo-item-wrapper">
                                                <div class="photo-item">
                                                    <a href="<?= base_url($photo) ?>" 
                                                       data-lightbox="gallery" 
                                                       data-title="<?= basename($photo) ?>">
                                                        <img src="<?= base_url($photo) ?>" 
                                                             class="photo-img" 
                                                             alt="Photo">
                                                    </a>
                                                    
                                                    <!-- Individual Download Icon -->
                                                    <a href="javascript:void(0);" 
                                                       class="download-icon download-single"
                                                       data-url="<?= base_url($photo) ?>"
                                                       data-filename="<?= basename($photo) ?>"
                                                       title="Download Photo">
                                                        <i class="fas fa-download"></i>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php endif; ?>

                                <!-- Display Google Photos (if any) -->
                                <?php if (!empty($photos['google'])): ?>
                                    <?php foreach ($photos['google'] as $index => $google_url): ?>
                                        <div class="col-md-3 col-sm-4 col-6 mb-4">
                                            <div class="photo-item-wrapper">
                                                <div class="photo-item">
                                                    <a href="<?= $google_url ?>" 
                                                       data-lightbox="gallery" 
                                                       data-title="Google Photo">
                                                        <img src="<?= $google_url ?>" 
                                                             class="photo-img" 
                                                             alt="Google Photo"
                                                             onerror="this.src='<?= base_url('Assets/img/placeholder.png') ?>'">
                                                    </a>
                                                    
                                                    <!-- Google Photo Download Icon -->
                                                    <a href="javascript:void(0);" 
                                                       class="download-icon download-single google-download" 
                                                       data-url="<?= $google_url ?>"
                                                       data-filename="google_photo_<?= $index ?>.jpg"
                                                       title="Download Google Photo">
                                                        <i class="fas fa-download"></i>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-info text-center">
                                <i class="fa fa-info-circle"></i> No photos found for this record.
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.photo-item-wrapper {
    position: relative;
}

.photo-item {
    border: 2px solid #e0e0e0;
    border-radius: 12px;
    overflow: hidden;
    height: 250px;
    width: 100%;
    background: #f8f9fa;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 50px;
    transition: all 0.3s ease;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    position: relative;
}

.photo-item:hover {
    transform: translateY(-8px);
    box-shadow: 0 12px 24px rgba(0,0,0,0.15);
    border-color: #007bff;
}

.photo-img {
    max-width: 100%;
    max-height: 100%;
    width: auto;
    height: auto;
    object-fit: contain;
    display: block;
}

/* Download Icon Styling */
.download-icon {
    position: absolute;
    top: 10px;
    right: 10px;
    background: rgba(0, 123, 255, 0.9);
    color: white;
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 16px;
    cursor: pointer;
    transition: all 0.3s ease;
    z-index: 10;
    text-decoration: none;
    border: 2px solid white;
    box-shadow: 0 2px 8px rgba(0,0,0,0.3);
    opacity: 0;
    border: none;
}

.photo-item:hover .download-icon {
    opacity: 1;
}

.download-icon:hover {
    background: rgba(0, 86, 179, 1);
    transform: scale(1.1);
    color: white;
    text-decoration: none;
}

/* Page Download Button */
#downloadAllBtn {
    padding: 8px 20px;
    font-size: 14px;
    border-radius: 6px;
    box-shadow: 0 2px 6px rgba(0,0,0,0.2);
}

#downloadAllBtn:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.3);
}

#downloadAllBtn:disabled {
    opacity: 0.6;
    cursor: not-allowed;
}
</style>

<!-- jQuery MUST be loaded first -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- Lightbox library -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.3/css/lightbox.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.3/js/lightbox.min.js"></script>

<script>
// Pure JavaScript - No jQuery needed for download functionality
document.addEventListener('DOMContentLoaded', function() {
    
    // ⭐ Helper Function to Download File
    function downloadFile(url, filename) {
        return new Promise((resolve, reject) => {
            fetch(url)
                .then(response => {
                    if (!response.ok) throw new Error('Network response was not ok');
                    return response.blob();
                })
                .then(blob => {
                    const blobUrl = window.URL.createObjectURL(blob);
                    const a = document.createElement('a');
                    a.style.display = 'none';
                    a.href = blobUrl;
                    a.download = filename;
                    document.body.appendChild(a);
                    a.click();
                    
                    // Clean up
                    setTimeout(() => {
                        window.URL.revokeObjectURL(blobUrl);
                        document.body.removeChild(a);
                        resolve();
                    }, 100);
                })
                .catch(err => {
                    console.error('Download failed for:', filename, err);
                    reject(err);
                });
        });
    }
    
    // ⭐ Individual Photo Download
    const downloadButtons = document.querySelectorAll('.download-single');
    downloadButtons.forEach(button => {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            
            const url = this.getAttribute('data-url');
            const filename = this.getAttribute('data-filename');
            
            downloadFile(url, filename)
                .catch(err => alert('Failed to download photo: ' + filename));
        });
    });
    
    // ⭐ Download ALL Photos (One by One)
    const downloadAllBtn = document.getElementById('downloadAllBtn');
    if (downloadAllBtn) {
        downloadAllBtn.addEventListener('click', function() {
            const allPhotos = [];
            
            // Collect all photo URLs and filenames
            document.querySelectorAll('.download-single').forEach(button => {
                allPhotos.push({
                    url: button.getAttribute('data-url'),
                    filename: button.getAttribute('data-filename')
                });
            });
            
            if (allPhotos.length === 0) {
                alert('No photos to download!');
                return;
            }
            
            // Disable button and show progress
            downloadAllBtn.disabled = true;
            const totalPhotos = allPhotos.length;
            let downloaded = 0;
            
            downloadAllBtn.innerHTML = `<i class="fas fa-spinner fa-spin"></i> Downloading ${downloaded}/${totalPhotos}...`;
            
            // Download photos one by one with delay
            async function downloadAllSequentially() {
                for (let photo of allPhotos) {
                    try {
                        await downloadFile(photo.url, photo.filename);
                        downloaded++;
                        downloadAllBtn.innerHTML = `<i class="fas fa-spinner fa-spin"></i> Downloading ${downloaded}/${totalPhotos}...`;
                        
                        // Add delay between downloads (browser ko sambhalne ke liye)
                        await new Promise(resolve => setTimeout(resolve, 800));
                    } catch (err) {
                        console.error('Failed to download:', photo.filename, err);
                    }
                }
                
                // Re-enable button
                downloadAllBtn.disabled = false;
                downloadAllBtn.innerHTML = '<i class="fas fa-check"></i> All Photos Downloaded!';
                
                // Reset button after 3 seconds
                setTimeout(() => {
                    downloadAllBtn.innerHTML = '<i class="fas fa-download"></i> Download All Photos';
                }, 3000);
            }
            
            downloadAllSequentially();
        });
    }
});
</script>