<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<!-- <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css"> -->

<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1 mb-4">Scholarship Data Report</div>
                    </div>
                    <div class="card-body">
                        <form role="form" id="scholarshipFilterForm">
                            <div class="row gutters">
                                
                                <!-- Branch Filter -->
                               
<div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
    <div class="field-wrapper">
        <select class="select-single js-states" id="branch_name" name="branch_name" multiple="multiple">
            <?php foreach($branchList as $branch): ?>
                <option value="<?= $branch->branch_name ?>"><?= $branch->branch_name ?></option>
            <?php endforeach; ?>
        </select>
        <div class="field-placeholder">Branch</div>
    </div>
</div>

<!-- Scholarship Level Filter -->
<div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
    <div class="field-wrapper">
        <select class="select-single js-states" id="Scholer_Level" name="Scholer_Level[]" multiple="multiple">
            <?php foreach($levelList as $level): ?>
                <option value="<?= $level->Scholer_Level ?>"><?= $level->Scholer_Level ?></option>
            <?php endforeach; ?>
        </select>
        <div class="field-placeholder">Scholarship Level</div>
    </div>
</div>

<!-- Caste Filter -->
<div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
    <div class="field-wrapper">
        <select class="select-single js-states" id="Caste" name="Caste[]" multiple="multiple">
            <?php foreach($casteList as $caste): ?>
                <option value="<?= $caste->Caste ?>"><?= $caste->Caste ?></option>
            <?php endforeach; ?>
        </select>
        <div class="field-placeholder">Caste</div>
    </div>
</div>

                                <!-- Year Filter -->
                                <div class="col-md-3">
                                    <div class="field-wrapper">
                                        <select class="select-single js-states" name="year_id[]" id="year_id" multiple="multiple">
                                            <?php foreach($yearList as $year): ?>
                                                <option value="<?= $year->finiYear_id ?>"><?= $year->fini_Label ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Financial Year</div>
                                    </div>
                                </div>

                                <!-- Search Button -->
                               
                            </div>
<div class="row">
                             <!-- <div class="col-md-2">
                                    <button class="btn btn-primary btn-sm rounded-3" type="button" id="btnSearch">
                                        <i class="fas fa-search"></i> Search
                                    </button>
                                </div> -->

                                <div class="col-md-3 mt-2">
 <button class="btn btn-success btn-sm m-1 " type="button" id="btnShow" style="padding: px 10px;font-size: 13px; font-weight:600;">
    <i class="fas fa-search"></i> Show Data
</button>
 <!-- <button class="btn btn-danger btn-sm" onclick="printTable()"><i class="fas fa-print"></i> Print</button>
<button class="btn btn-warning btn-sm" onclick="exportToExcel()"><i class="fas fa-file-excel"></i>Excel</button> -->
        </div>
 </div>
                                <!-- Action Buttons -->
                               
                                <div class="row">
                                            <div class="col-md-12 text-right">
                                                <button class="btn btn-danger btn-sm rounded-3" type="button" onclick="printTable()"><i class="fas fa-print bg-white p-1 rounded-circle text-danger shadow-lg" style=" box-shadow: 4px 6px 12px rgba(0, 0, 0, 0.5) !important;"></i> Print</button>
                                                 <!-- <button type="button" class="btn btn-danger btn-sm mx-1" onclick="printTable()" ><i class="fas fa-print"></i>Print</button> -->
<button type="button" class="btn btn-success btn-sm rounded-3" onclick="exportToExcel()"><i class="fas fa-file-excel bg-white p-1 rounded-circle text-success shadow-lg" style=" box-shadow: 4px 6px 12px rgba(0, 0, 0, 0.5) !important;"></i>Excel</button>
 <button type="button" class="btn btn-dark btn-sm rounded-3" type="button" onclick="window.location.href='<?= base_url() ?>admin/Scholership/dashboard'"><i class="fa-solid fa-home bg-white p-1 rounded-circle text-dark shadow-lg" ></i>Home</button>
                                            </div>
                                        </div>

                                           

                            <!-- Data Table -->
                            <div class="table-responsive mt-3" id="printableTable">
                                <table id="leavetable" class="table custom-table">
                                    <thead style="background-color: #0d40a9;">
                                        <tr>
                                            <th>Sr.No.</th>
                                            <th>Student Name</th>
                                            <th>PRN</th>
                                            <th>Branch</th>
                                            <th>Scholarship Level</th>
                                            <th>Scholarship Name</th>
                                            <th>Caste</th>
                                            <th>Year</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td colspan="8" class="text-center">Please select filters and click Search</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <hr>

                            <!-- Graphical Report Section -->
                            <div class="row mb-3">
                                <div class="col-md-12 d-flex align-items-center">
                                    <button type="button" class="btn btn-sm btn-primary me-2" onclick="toggleFilterSection()">
                                        <i class="fas fa-filter shadow-lg"></i> Graphical Report
                                    </button>
                                </div>
                            </div>

                            <!-- Charts Filter Section -->
                            <div id="filterSection" class="card mb-3 p-3" style="display:none;">
                                <div class="row align-items-center">
                                    <div class="col-md-4">
                                        <div class="field-wrapper">
                                            <select class="select-single js-states" id="branchwise_dropdown" name="branchwise_dropdown[]" multiple="multiple">
                                                <?php foreach($branchList as $branch): ?>
                                                    <option value="<?= $branch->branch_id ?>"><?= $branch->branch_name ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <div class="field-placeholder">Branch</div>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="field-wrapper">
                                            <select class="select-single js-states" id="year_chart_id" name="year_chart_id[]" multiple="multiple">
                                                <?php foreach($yearList as $year): ?>
                                                    <option value="<?= $year->finiYear_id ?>"><?= $year->fini_Label ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <div class="field-placeholder">Year</div>
                                        </div>
                                    </div>

                                    <div class="col-md-4 d-flex mb-2 align-items-center">
                                        <button type="button" class="btn btn-success me-2 custom-gradient-btn" id="searchChartBtn">
                                            <i class="fas fa-search me-1"></i> Search
                                        </button>
                                        <button type="button" class="btn btn-danger btn-sm rounded-3" onclick="printCombinedChart()">
                                            <i class="fas fa-print me-1 bg-white p-1 rounded-circle text-danger shadow-lg"></i> Print
                                        </button>
                                    </div>
                                </div>
                            </div>

                            <!-- Charts Row -->
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="card p-3 text-center">
                                        <h5>Branchwise Chart</h5>
                                        <div style="height:250px; width:100%;">
                                            <canvas id="branchChart"></canvas>
                                            <div id="branchDetails"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="card p-3 text-center">
                                        <h5>Yearwise Chart</h5>
                                        <div style="height:250px;">
                                            <canvas id="yearChart"></canvas>
                                            <div id="yearDetails"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="<?php echo base_url();?>Assets/js/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
function printTable() {
    const printElement = document.getElementById('printableTable');
 
    $.ajax({
        url: '<?= base_url("admin/ScholershipReport/getPrintHeadings") ?>',
        method: 'GET',
        dataType: 'json',
        success: function (heading) {
            const iframe = document.createElement('iframe');
            iframe.style.position = 'fixed';
            iframe.style.right = '0';
            iframe.style.bottom = '0';
            iframe.style.width = '0';
            iframe.style.height = '0';
            iframe.style.border = '0';
            document.body.appendChild(iframe);
 
            const doc = iframe.contentWindow.document;
 
            const baseUrl = '<?= base_url() ?>';
            let logoPath = heading.logo || 'Assets/images/sit_logo.png';
            logoPath = logoPath.replace(/^\/+/, '');
            const fullLogoPath = baseUrl + logoPath;
 
            doc.open();
            doc.write(`
                <html>
                <head>
                    <title>Print</title>
                    <style>
                        body {
                            font-family: sans-serif;
                            margin: 10px 5px;
                            padding: 0;
                        }
                        .header-section {
                            display: flex;
                            align-items: center;
                            justify-content: center;
                            gap: 10px; /* chhota gap between logo and text */
                            margin-bottom: 5px; /* minimal gap under header */
                        }
                        .logo-container img {
                            max-height: 80px;
                            max-width: 80px;
                            width: auto;
                            height: auto;
                        }
                        .heading-content {
                            text-align: center;
                        }
                        h4, h6, .sub-heading, .autonomous-badge {
                            margin: 0;
                            padding: 0;
                        }
                        h4 {
                            font-size: 20px;
                            font-weight: bold;
                            color: #d32f2f;
                        }
                        h6 {
                            font-size: 14px;
                            font-weight: normal;
                        }
                        .sub-heading, .autonomous-badge {
                            font-size: 14px;
                        }
                        table {
                            width: 100%;
                            border-collapse: collapse;
                            margin-top: 5px; /* minimal gap before table */
                        }
                        th, td {
                            border: 1px solid black;
                            padding: 4px;
                            text-align: center;
                            word-break: break-word;
                        }
 
                         /* 🟢 Table layout optimization */
    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 5px;
        table-layout: fixed; /* ensures equal layout distribution */
    }
    th, td {
        border: 1px solid black;
        padding: 6px 4px;
        text-align: center;
        vertical-align: middle;
        word-wrap: break-word;
        font-size: 12px;
    }
        .no-print {
                            display: none !important;
                        }
                    </style>
                </head>
                <body>
                    <div class="header-section">
                        <div class="logo-container">
                            <img src="${fullLogoPath}" alt="Logo"
                                 onerror="this.style.display='none'; this.parentElement.innerHTML='<div style=\\'color:red; font-size:12px;\\'>Logo Not Found</div>';">
                        </div>
                        <div class="heading-content">
                            <h6>${heading.subHead1 || ''}</h6>
                            <h4>${heading.head || ''}</h4>
                            <div class="autonomous-badge">${heading.subHead2 || ''}</div>
                            <div class="sub-heading">${heading.subHead3 || ''}</div>
                        </div>
                    </div>
                    <br>
                   
                    ${printElement.outerHTML}
                </body>
                </html>
            `);
            doc.close();
 
            iframe.contentWindow.onload = function() {
                setTimeout(function() {
                    iframe.contentWindow.focus();
                    iframe.contentWindow.print();
                }, 500);
            };
 
            setTimeout(() => {
                document.body.removeChild(iframe);
            }, 3000);
        },
        error: function(xhr, status, error) {
            console.error('AJAX Error:', error);
            alert('Error loading print data: ' + error);
        }
    });
}
</script>
 
 
<!-- excel script -->
<script>
function exportToExcel() {
    $.ajax({
        url: '<?= base_url("admin/ScholershipReport/getPrintHeadings") ?>',
        method: 'GET',
        dataType: 'json',
        success: function (heading) {
            var wb = XLSX.utils.book_new();
 
            // Dynamic header using response
            var header = [
                [heading.subHead1 || ''],
                [heading.head || ''],
                [heading.subHead2 || ''],
                [heading.subHead3 || ''],
                ['']
            ];
 
           
            var table = document.getElementById('printableTable');
            var wsTable = XLSX.utils.table_to_sheet(table);
            var tableData = XLSX.utils.sheet_to_json(wsTable, { header: 1 });
 
         
            var fullData = header.concat(tableData);
 
            var ws = XLSX.utils.aoa_to_sheet(fullData);
            XLSX.utils.book_append_sheet(wb, ws, 'Grant Recieved');
            XLSX.writeFile(wb, 'Grant Recieved Report.xlsx');
        }
    });
}
</script>
<script>
  // Fixed btnShow click handler
$("#btnShow").click(function () {
    // Get filter values - matching your HTML IDs
    var branch_ids = $("#branch_name").val();      // Multiple select
    var level_ids = $("#Scholer_Level").val();     // Multiple select
    var caste_ids = $("#Caste").val();             // Multiple select
    var year_ids = $("#year_id").val();            // Multiple select

    console.log("Filters:", {
        branch_ids: branch_ids,
        level_ids: level_ids,
        caste_ids: caste_ids,
        year_ids: year_ids
    });

    // Show spinner loader
    $('#leavetable tbody').html(`
        <tr>
            <td colspan="8" class="text-center">
                <div class="spinner-border text-primary" role="status">
                    <span class="sr-only">Loading...</span>
                </div>
                <div class="mt-2">Loading scholarship data...</div>
            </td>
        </tr>
    `);

    $.ajax({
        url: "<?php echo base_url('admin/ScholershipReport/getReportData'); ?>",
        type: "POST",
        data: {
            branch_ids: branch_ids,
            level_ids: level_ids,
            caste_ids: caste_ids,
            year_ids: year_ids
        },
        dataType: "json",
        success: function (data) {
            console.log("Response data:", data);
            
            var tbody = $("#leavetable tbody");
            tbody.empty();
            
            if (data && data.length > 0) {
                $.each(data, function (index, row) {
                    tbody.append(
                        "<tr>" +
                        "<td>" + (index + 1) + "</td>" +
                        "<td>" + (row.Student_name || '-') + "</td>" +
                        "<td>" + (row.PRN || '-') + "</td>" +
                        "<td>" + (row.branch_name || '-') + "</td>" +
                        "<td>" + (row.Scholer_Level || '-') + "</td>" +
                        "<td>" + (row.ScholershipName || '-') + "</td>" +
                        "<td>" + (row.Caste || '-') + "</td>" +
                        "<td>" + (row.year_label || '-') + "</td>" +
                        "</tr>"
                    );
                });
            } else {
                tbody.append(
                    "<tr><td colspan='8' class='text-center text-danger'>" +
                    "No Data Found. Please adjust your filters and try again." +
                    "</td></tr>"
                );
            }
        },
        error: function (xhr, status, error) {
            console.error("AJAX Error:", {
                status: status,
                error: error,
                response: xhr.responseText
            });
            
            $("#leavetable tbody").html(
                "<tr><td colspan='8' class='text-center text-danger'>" +
                "Error fetching data! Please try again.<br>" +
                "<small>Error: " + error + "</small>" +
                "</td></tr>"
            );
        }
    });
});

// Helper function to format date if needed
function formatDate(isoDate) {
    if (!isoDate) return '-';
    let dateObj = new Date(isoDate);
    let d = ("0" + dateObj.getDate()).slice(-2);
    let m = ("0" + (dateObj.getMonth() + 1)).slice(-2);
    let y = dateObj.getFullYear();
    return d + "-" + m + "-" + y;
}

// Initialize Select2 dropdowns
$(document).ready(function() {
    $('.select-single').select2({
        placeholder: "Select options",
        allowClear: true
    });
});
</script>



<!--pai graph code  new  -->
 <script>
// Initialize Chart variables
let branchChart = null;
let yearChart = null;

// 🔹 Toggle filter section
function toggleFilterSection() {
    $("#filterSection").slideToggle();
}

// 🔹 Search button click → fetch combined data (FIXED button ID)
$("#searchChartBtn").on("click", function () {
    // ✅ Show loader, hide charts & tables
    $("#branchChart").parent().parent().parent().hide();  // Hide branch chart card
    $("#yearChart").parent().parent().parent().hide();     // Hide year chart card
    $("#branchDetails").html(`
        <div class="text-center">
            <div class="spinner-border text-primary"></div>
            <p>Please wait, loading charts...</p>
        </div>
    `);
    $("#yearDetails").html("");

    let selectedBranches = $("#branchwise_dropdown").val();
    let selectedYears = $("#year_chart_id").val(); // ✅ FIXED: Changed from year_id to year_chart_id

    $.ajax({
        url: "<?= base_url('admin/ScholershipReport/getCombinedData') ?>",
        type: "POST",
        data: {
            branches: selectedBranches,
            years: selectedYears
        },
        dataType: "json",

        beforeSend: function () {
            // ✅ Customize loader message
            console.log("AJAX request starting...");
        },

        success: function (response) {
            console.log("AJAX Response:", response);
            
            if (response.status === "success") {
                renderBranchChart({
                    labels: response.branchData.map(b => b.branch_name),
                    values: response.branchData.map(b => parseInt(b.Grant_count)),
                    ids: response.branchData.map(b => b.branch_id)
                });

                renderYearChart({
                    labels: response.yearData.map(y => y.year),
                    values: response.yearData.map(y => parseInt(y.count)),
                    ids: response.yearData.map(y => y.year_id)
                });

                // ✅ Show charts after successful load
                $("#branchChart").parent().parent().parent().show();
                $("#yearChart").parent().parent().parent().show();

                // ✅ Hide tables on fresh search
                $("#branchDetails").html("");
                $("#yearDetails").html("");
            } else {
                $("#branchDetails").html('<p class="text-danger">No data available</p>');
            }
        },

        error: function (xhr, status, error) {
            console.error("AJAX Error:", error);
            console.error("Response:", xhr.responseText);
            // ✅ Show error message in loader area
            $("#branchDetails").html(`
                <p class="text-danger">Error loading data. Please try again.</p>
            `);
            setTimeout(() => {
                $("#branchDetails").html("");
            }, 3000);
        },

        complete: function () {
            console.log("AJAX request completed");
        }
    });
});

// ================== BRANCH CHART ==================
function renderBranchChart(data) {
    const ctx = document.getElementById("branchChart").getContext("2d");
    if (branchChart) branchChart.destroy();
 
    branchChart = new Chart(ctx, {
        type: "pie",
        data: {
            labels: data.labels,
            datasets: [{ data: data.values, borderWidth: 1 }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            onClick: function (event, elements) {
                if (elements.length > 0) {
                    const idx = elements[0].index;
                    const branchId = data.ids[idx];
                    const branchName = data.labels[idx];
                    loadBranchDetails(branchId, branchName);
                }
            }
        }
    });
}

function loadBranchDetails(branchId, branchName) {
    $.ajax({
        url: "<?= base_url('admin/ScholershipReport/getBranchDetails') ?>",
        type: "POST",
        data: {
            branch_id: branchId,
            year: $("#year_chart_id").val()
        },
        dataType: "json",
        beforeSend: function () {
            $("#branchDetails").html(`<div class="text-center"><div class="spinner-border text-primary"></div><p>Loading ${branchName} details...</p></div>`);
        },
        success: function (data) {
            populateBranchTable(data, branchName);
        },
        error: function () {
            $("#branchDetails").html(`<p class="text-danger">Error loading ${branchName} data.</p>`);
        }
    });
}
 
function populateBranchTable(data, branchName) {
    let html = `
        <div class="card mt-3">
            <div class="card-header bg-primary text-white"><h5>${branchName} - Scholarship Details</h5></div>
            <div class="card-body branch">
                <table class="table table-bordered">
                    <thead><tr class="head">
                     <th style="color:black !important;">Sr.No</th>
                            <th style="color:black !important;">Student Name</th>
                            <th style="color:black !important;">PRN</th>
                            <th style="color:black !important;">Scholarship Name</th>
                            <th style="color:black !important;">Level</th>
                            <th style="color:black !important;">Caste</th>
                            <th style="color:black !important;">Branch</th>
                     
                    <tbody id="branchid">`;
    if (data.length > 0) {
        data.forEach((row, i) => {
            html += `<tr>
                        <td>${i + 1}</td>
                        
                        <td>${row.Student_name || '-'}</td>
                        <td>${row.PRN || '-'}</td>
                        <td>${row.ScholershipName || '-'}</td>
                        <td>${row.Scholer_Level || '-'}</td>
                        <td>${row.Caste || '-'}</td>
                         <td>${row.branch_name || '-'}</td>
                        
                        
                        
                     </tr>`;
        });
    } else {
        html += `<tr><td colspan="6" class="text-center">No records found</td></tr>`;
    }
    html += `</tbody></table></div></div>`;
    $("#branchDetails").html(html);
}

// ================== YEAR CHART ==================
function renderYearChart(data) {
    const ctx = document.getElementById("yearChart").getContext("2d");
    if (yearChart) yearChart.destroy();
 
    yearChart = new Chart(ctx, {
        type: "bar",
        data: {
            labels: data.labels,
            datasets: [{ label: 'Scholarship Data', data: data.values, borderWidth: 1, backgroundColor: "rgba(18,115,235,0.7)" }]
        },
        options: {
            responsive: true,
            scales: { y: { beginAtZero: true } },
            onClick: function (event, elements) {
                if (elements.length > 0) {
                    const idx = elements[0].index;
                    const yearId = data.ids[idx];
                    const yearLabel = data.labels[idx];
                    loadYearDetails(yearId, yearLabel);
                }
            }
        }
    });
}

 // branch wise year 
function loadYearDetails(yearId, yearLabel) {
    $.ajax({
        url: "<?= base_url('admin/ScholershipReport/getYearwiseData') ?>",
        type: "POST",
        data: {
            year: yearId,
            branches: $("#branchwise_dropdown").val()
           
        },
        dataType: "json",
        beforeSend: function () {
            $("#yearDetails").html(`<div class="text-center"><div class="spinner-border text-success"></div><p>Loading ${yearLabel} details...</p></div>`);
        },
        success: function (response) {
            if (response.status === "success") {
                populateYearTable(response.types, yearLabel);
            } else {
                $("#yearDetails").html(`<p class="text-danger">No data for ${yearLabel}</p>`);
            }
        },
        error: function () {
            $("#yearDetails").html(`<p class="text-danger">Error loading ${yearLabel} data.</p>`);
        }
    });
}
 

 
function populateYearTable(data, yearLabel) {
    let html = `
        <div class="card mt-3">
            <div class="card-header bg-success text-white"><h5>${yearLabel} - Scholarship Details</h5></div>
            <div class="card-body year">
                <table class="table table-bordered">
                    <thead>
                        <tr class="head"><th style="color:black !important;">Sr.No</th>
                        <th style="color:black !important;">Student Name</th>
                            <th style="color:black !important;">PRN</th>
                            <th style="color:black !important;">Scholarship Name</th>
                            <th style="color:black !important;">Level</th>
                            <th style="color:black !important;">Year</th>
                            
                        
                       
                    </thead>
                    <tbody id="yearid">`;
    if (data.length > 0) {
        data.forEach((row, i) => {
            html += `<tr>
                        <td>${i + 1}</td>
                       <td>${row.Student_name || '-'}</td>
                        <td>${row.PRN || '-'}</td>
                        <td>${row.ScholershipName || '-'}</td>
                        <td>${row.Scholer_Level || '-'}</td>
                         <td>${row.year || '-'}</td>
                       
                      
                        
                     </tr>`;
        });
    } else {
        html += `<tr><td colspan="6" class="text-center">No records found</td></tr>`;
    }
    html += `</tbody></table></div></div>`;
    $("#yearDetails").html(html);
}

// ================== PRINT BOTH ==================
function printCombinedChart() {
    // Convert both charts to Base64 images
    const branchChartImg = branchChart.toBase64Image();
    const yearChartImg   = yearChart.toBase64Image();
 
    // Get the tables' HTML
    const branchTable = document.getElementById("branchDetails").innerHTML;
    const yearTable   = document.getElementById("yearDetails").innerHTML;
 
    // Create iframe for printing
    let printFrame = document.getElementById('printFrame');
    if (printFrame) {
        printFrame.remove();
    }
   
    printFrame = document.createElement('iframe');
    printFrame.id = 'printFrame';
    printFrame.style.position = 'absolute';
    printFrame.style.width = '0';
    printFrame.style.height = '0';
    printFrame.style.border = 'none';
   
    document.body.appendChild(printFrame);
   
    const frameDoc = printFrame.contentWindow.document;
    frameDoc.open();
    frameDoc.write(`
        <!DOCTYPE html>
        <html>
        <head>
            <title>Charts & Tables Print</title>
            <style>
                @page {
                    size: A4;
                    margin: 15mm;
                }
               
                body {
                    font-family: Arial, sans-serif;
                    margin: 0;
                    padding: 20px;
                }
               
                .chart-section {
                    margin-bottom: 20px;
                }
               
                .chart-section h2 {
                    font-size: 18px;
                    margin-bottom: 15px;
                    color: #000;
                }
               
                .table-section h3 {
                    font-size: 14px;
                    margin: 15px 0 10px 0;
                    color: #000;
                }
               
                img {
                    max-width: 100%;
                    height: auto;
                    display: block;
                    margin-bottom: 15px;
                }
               
                table {
                    width: 100%;
                    border-collapse: collapse;
                    margin-bottom: 20px;
                    font-size: 11px;
                }
               
                th, td {
                    border: 1px solid #333;
                    padding: 6px 8px;
                    text-align: left;
                }
               
                th {
                    background: #f2f2f2;
                    color: #000;
                    font-weight: bold;
                }
               
                .page-break {
                    page-break-before: always;
                }
               
                @media print {
                    table {
                        page-break-inside: auto;
                    }
                   
                    tr {
                        page-break-inside: avoid;
                        page-break-after: auto;
                    }
                   
                    th {
                        background: #f2f2f2 !important;
                        -webkit-print-color-adjust: exact;
                        print-color-adjust: exact;
                    }
                }
            </style>
        </head>
        <body>
            <div class="chart-section">
                <h2>Branchwise Chart</h2>
                <img src="${branchChartImg}" alt="Branch Chart">
            </div>
           
            <div class="table-section">
                <h3>Scholarship Details - Branch wise</h3>
                ${branchTable}
            </div>
           
            <div class="chart-section page-break">
                <h2>Yearwise Chart</h2>
                <img src="${yearChartImg}" alt="Year Chart">
            </div>
           
            <div class="table-section">
                <h3>Scholarship Details - Year wise</h3>
                ${yearTable}
            </div>
        </body>
        </html>
    `);
    frameDoc.close();
   
    // Wait for content to load
    setTimeout(() => {
        printFrame.contentWindow.focus();
        printFrame.contentWindow.print();
       
        // Cleanup after print
        setTimeout(() => {
            if (printFrame) {
                printFrame.remove();
            }
        }, 100);
    }, 500);
}
</script>



 
<!-- print modal  -->
 
<script>
function printTablemodal() {
    const printElement = document.getElementById('printmodal');
 
    $.ajax({
        url: '<?= base_url("admin/ScholershipReport/getPrintHeadings") ?>',
        method: 'GET',
        dataType: 'json',
        success: function (heading) {
            const iframe = document.createElement('iframe');
            iframe.style.position = 'fixed';
            iframe.style.right = '0';
            iframe.style.bottom = '0';
            iframe.style.width = '0';
            iframe.style.height = '0';
            iframe.style.border = '0';
            document.body.appendChild(iframe);
 
            const doc = iframe.contentWindow.document;
 
            const baseUrl = '<?= base_url() ?>';
            let logoPath = heading.logo || 'Assets/images/sit_logo.png';
            logoPath = logoPath.replace(/^\/+/, '');
            const fullLogoPath = baseUrl + logoPath;
 
            doc.open();
            doc.write(`
                <html>
                <head>
                    <title>Print</title>
                    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
                    <style>
                        body {
                            font-family: sans-serif;
                            margin: 10px 5px;
                            padding: 0;
                        }
                        .header-section {
                            display: flex;
                            align-items: center;
                            justify-content: center;
                            gap: 10px; /* logo and heading gap */
                            margin-bottom: 5px; /* minimal space below header */
                        }
                        .logo-container img {
                            max-height: 80px;
                            max-width: 80px;
                            width: auto;
                            height: auto;
                        }
                        .heading-content {
                            text-align: center;
                        }
                        h4, h6, .sub-heading, .autonomous-badge {
                            margin: 0;
                            padding: 0;
                        }
                        h4 {
                            font-size: 20px;
                            font-weight: bold;
                            color: #d32f2f;
                        }
                        h6 {
                            font-size: 14px;
                            font-weight: normal;
                        }
                        .sub-heading, .autonomous-badge {
                            font-size: 14px;
                        }
                        table {
                            width: 100%;
                            border-collapse: collapse;
                            margin-top: 5px;
                        }
                        th, td {
                            border: 1px solid black;
                            padding: 4px;
                            text-align: center;
                            word-break: break-word;
                        }
                        .no-print {
                            display: none !important;
                        }
 
       
                    </style>
                </head>
                <body>
                    <div class="header-section">
                        <div class="logo-container">
                            <img src="${fullLogoPath}" alt="Logo"
                                 onerror="this.style.display='none'; this.parentElement.innerHTML='<div style=\\'color:red; font-size:12px;\\'>Logo Not Found</div>';">
                        </div>
                        <div class="heading-content">
                            <h6>${heading.subHead1 || ''}</h6>
                            <h4>${heading.head || ''}</h4>
                            <div class="autonomous-badge">${heading.subHead2 || ''}</div>
                            <div class="sub-heading">${heading.subHead3 || ''}</div>
                        </div>
                    </div>
<br>
                    ${printElement.outerHTML}
                </body>
                </html>
            `);
            doc.close();
 
            iframe.onload = function() {
                setTimeout(function() {
                    iframe.contentWindow.focus();
                    iframe.contentWindow.print();
                }, 500);
            };
 
            setTimeout(() => {
                document.body.removeChild(iframe);
            }, 3000);
        }
    });
}
</script>

