<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1">Student Feedback Report</div>
                    </div>
                    <div class="card-body">
                        <form role="form" id="feedbackFilterForm">
                            <div class="row gutters">
   
                                <!-- Hostel Filter -->
                                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <div class="field-wrapper">
                                        <select class="select-single js-states" id="hostel_id" name="hostel_id[]" multiple="multiple">
                                            <?php foreach($hostelList as $hostel): ?>
                                                <option value="<?= $hostel->Hostel_id ?>"><?= $hostel->Hostel_Name ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Hostel Type</div>
                                    </div>
                                </div>

                                <!-- Branch Filter -->
                                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <div class="field-wrapper">
                                        <select class="select-single js-states" id="branch_id" name="branch_id[]" multiple="multiple">
                                            <?php foreach($branchList as $branch): ?>
                                                <option value="<?= $branch->branch_id ?>"><?= $branch->branch_name ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Branch</div>
                                    </div>
                                </div>

                                <!-- Institute Filter -->
                                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <div class="field-wrapper">
                                        <select class="select-single js-states" id="institute_id" name="institute_id[]" multiple="multiple">
                                            <?php foreach($instituteList as $institute): ?>
                                                <option value="<?= $institute->Institu_id ?>"><?= $institute->Institu_name ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Institute</div>
                                    </div>
                                </div>

                                <!-- Year Filter -->
                                <div class="col-md-3">
                                    <div class="field-wrapper">
                                        <select class="select-single js-states" name="year_id[]" id="year_id" multiple="multiple">
                                            <?php foreach($yearList as $year): ?>
                                                <option value="<?= $year->finiYear_id ?>"><?= $year->fini_Label ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Financial Year</div>
                                    </div>
                                </div>

                            </div>

                            <div class="row">
                                <div class="col-md-9 d-flex">
                                    <div class="col-md-3 mt-2">
                                        <button class="btn btn-success btn-sm m-1" type="button" id="btnShow" style="padding: 8px 10px;font-size: 13px; font-weight:600;">
                                            <i class="fas fa-search"></i> Show Data
                                        </button>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-12 text-right">
                                        <button class="btn btn-danger btn-sm rounded-3" type="button" onclick="printTable()">
                                            <i class="fas fa-print bg-white p-1 rounded-circle text-danger shadow-lg" style="box-shadow: 4px 6px 12px rgba(0, 0, 0, 0.5) !important;"></i> Print
                                        </button>
                                        <button type="button" class="btn btn-success btn-sm rounded-3" onclick="exportToExcel()">
                                            <i class="fas fa-file-excel bg-white p-1 rounded-circle text-success shadow-lg" style="box-shadow: 4px 6px 12px rgba(0, 0, 0, 0.5) !important;"></i> Excel
                                        </button>
                                        <button type="button" class="btn btn-dark btn-sm rounded-3" onclick="window.location.href='<?= base_url() ?>admin/Survey/dashboard'">
                                            <i class="fa-solid fa-home bg-white p-1 rounded-circle text-dark shadow-lg"></i> Home
                                        </button>
                                    </div>
                                </div>
                            </div>

                            <!-- Data Table -->
                            <div class="table-responsive mt-3" id="printableTable">
                                <table id="feedbackTable" class="table custom-table">
                                    <thead style="background-color: #0d40a9;">
                                        <tr>
                                            <th style="color: white;">Sr.No.</th>
                                            <th style="color: white;">Student Name</th>
                                            <th style="color: white;">PRN No</th>
                                            <th style="color: white;">Branch Name</th>
                                            <th style="color: white;">Hostel Type</th>
                                            <th style="color: white;">Institute</th>
                                            <th style="color: white;">Financial Year</th>
                                            <th style="color: white;">URL</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td colspan="8" class="text-center">Please select filters and click Show Data</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <hr>

                            <!-- Graphical Report Section -->
                            <div class="row mb-3">
                                <div class="col-md-12 d-flex align-items-center">
                                    <button type="button" class="btn btn-sm btn-primary me-2" onclick="toggleFilterSection()">
                                        <i class="fas fa-filter shadow-lg"></i> Graphical Report
                                    </button>
                                </div>
                            </div>

                            <!-- Charts Filter Section -->
                            <div id="filterSection" class="card mb-3 p-3" style="display:none;">
                                <div class="row align-items-center">
                                    <div class="col-md-4">
                                        <div class="field-wrapper">
                                            <select class="select-single js-states" id="branchwise_dropdown" name="branchwise_dropdown[]" multiple="multiple">
                                                <?php foreach($branchList as $branch): ?>
                                                    <option value="<?= $branch->branch_id ?>"><?= $branch->branch_name ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <div class="field-placeholder">Branch</div>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="field-wrapper">
                                            <select class="select-single js-states" id="year_chart_id" name="year_chart_id[]" multiple="multiple">
                                                <?php foreach($yearList as $year): ?>
                                                    <option value="<?= $year->finiYear_id ?>"><?= $year->fini_Label ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <div class="field-placeholder">Year</div>
                                        </div>
                                    </div>

                                    <div class="col-md-4 d-flex mb-2 align-items-center">
                                        <button type="button" class="btn btn-success me-2 custom-gradient-btn" id="searchChartBtn">
                                            <i class="fas fa-search me-1"></i> Search
                                        </button>
                                        <button type="button" class="btn btn-danger btn-sm rounded-3" onclick="printCombinedChart()">
                                            <i class="fas fa-print me-1 bg-white p-1 rounded-circle text-danger shadow-lg"></i> Print
                                        </button>
                                    </div>
                                </div>
                            </div>

                            <!-- Chart Loader -->
                            <div id="chartLoader" style="display:none; text-align:center; margin:20px 0;">
                                <div class="spinner-border text-primary"></div>
                                <p>Loading charts...</p>
                            </div>

                            <!-- Charts Row -->
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="card p-3 text-center">
                                        <h5>Branchwise Chart</h5>
                                        <div style="height:250px; width:100%;">
                                            <canvas id="branchChart"></canvas>
                                            <div id="branchDetails"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="card p-3 text-center">
                                        <h5>Yearwise Chart</h5>
                                        <div style="height:250px;">
                                            <canvas id="yearChart"></canvas>
                                            <div id="yearDetails"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="<?php echo base_url();?>Assets/js/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
$(document).ready(function() {
    // Initialize Select2 for all dropdowns
    $('.js-states').select2({
        placeholder: "Select options",
        allowClear: true
    });

    // Set default active year
    <?php if(isset($activeYear) && $activeYear): ?>
    var activeYearId = '<?= $activeYear->finiYear_id ?>';
    $('#year_id').val([activeYearId]).trigger('change');
    $('#year_chart_id').val([activeYearId]).trigger('change');
    <?php endif; ?>

    // Search button click handler
    $("#btnShow").click(function() {
        loadFeedbackData();
    });

    // Chart search button
    $("#searchChartBtn").click(function() {
        loadChartData();
    });
});

// Load feedback data based on filters
function loadFeedbackData() {
    var formData = {
        hostel_ids: $("#hostel_id").val(),
        branch_ids: $("#branch_id").val(),
        Institu_ids: $("#Institu_id").val(),
        year_ids: $("#year_id").val()
    };

    $("#feedbackTable tbody").html(
        '<tr><td colspan="8" class="text-center"><div class="spinner-border text-primary"></div><p>Loading data...</p></td></tr>'
    );

    $.ajax({
        url: "<?= base_url('admin/StudentFeedReport/getFeedbackData') ?>",
        type: "POST",
        data: formData,
        dataType: "json",
        success: function(response) {
            var tbody = "";
            if (response.length > 0) {
                $.each(response, function(index, row) {
                    tbody += `
                        <tr>
                            <td>${index + 1}</td>
                            <td>${row.student_name || '-'}</td>
                            <td>${row.prno || '-'}</td>
                            <td>${row.branch_name || '-'}</td>
                            <td>${row.hostel_name || '-'}</td>
                            <td>${row.institute_name || '-'}</td>
                            <td>${row.year_label || '-'}</td>
<td>${row.url ? '<a href="' + row.url + '" target="_blank">View</a>' : '-'}</td>
                        </tr>
                    `;
                });
            } else {
                tbody = '<tr><td colspan="8" class="text-center text-warning">No data found for selected filters</td></tr>';
            }
            $("#feedbackTable tbody").html(tbody);
        },
        error: function(xhr, status, error) {
            console.error('AJAX Error:', error);
            Swal.fire("Error", "Failed to load data!", "error");
            $("#feedbackTable tbody").html(
                '<tr><td colspan="8" class="text-center text-danger">Error loading data</td></tr>'
            );
        }
    });
}

// Toggle filter section
function toggleFilterSection() {
    $("#filterSection").slideToggle();
}

// Chart variables
let branchChart = null;
let yearChart = null;

// Load chart data
function loadChartData() {
    let selectedBranches = $("#branchwise_dropdown").val();
    let selectedYears = $("#year_chart_id").val();
    
    $("#chartLoader").show();
    $("#branchChart").parent().parent().hide();
    $("#yearChart").parent().parent().hide();

    $.ajax({
        url: "<?= base_url('admin/StudentFeedReport/getChartData') ?>",
        type: "POST",
        data: {
            branches: selectedBranches,
            years: selectedYears
        },
        dataType: "json",
        success: function(response) {
            if (response.status === "success") {
                renderBranchChart({
                    labels: response.branchData.map(b => b.branch_name),
                    values: response.branchData.map(b => b.feedback_count),
                    ids: response.branchData.map(b => b.branch_id)
                });

                renderYearChart({
                    labels: response.yearData.map(y => y.year),
                    values: response.yearData.map(y => y.count),
                    ids: response.yearData.map(y => y.year_id)
                });

                $("#branchChart").parent().parent().show();
                $("#yearChart").parent().parent().show();
                $("#branchDetails").html("");
                $("#yearDetails").html("");
            } else {
                Swal.fire("No Data", "No data found for selected filters!", "info");
            }
        },
        error: function(xhr, status, error) {
            console.error("Chart AJAX Error:", error);
            Swal.fire("Error", "Failed to load chart data!", "error");
        },
        complete: function() {
            $("#chartLoader").hide();
        }
    });
}

// Render branch chart
function renderBranchChart(data) {
    const ctx = document.getElementById("branchChart").getContext("2d");
    
    if (branchChart) {
        branchChart.destroy();
    }

    branchChart = new Chart(ctx, {
        type: "pie",
        data: {
            labels: data.labels,
            datasets: [{
                data: data.values,
                backgroundColor: [
                    '#FF6384', '#36A2EB', '#FFCE56', '#4BC0C0',
                    '#9966FF', '#FF9F40', '#FF6384', '#C9CBCF',
                    '#E7E9ED', '#4BC0C0'
                ],
                borderWidth: 1,
                borderColor: '#fff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 10,
                        font: { size: 11 }
                    }
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return context.label + ': ' + context.parsed + ' records';
                        }
                    }
                }
            },
            onClick: function(event, elements) {
                if (elements.length > 0) {
                    const idx = elements[0].index;
                    const branchId = data.ids[idx];
                    const branchName = data.labels[idx];
                    loadBranchDetails(branchId, branchName);
                }
            }
        }
    });
}

// Render year chart
function renderYearChart(data) {
    const ctx = document.getElementById("yearChart").getContext("2d");
    
    if (yearChart) {
        yearChart.destroy();
    }

    yearChart = new Chart(ctx, {
        type: "bar",
        data: {
            labels: data.labels,
            datasets: [{
                label: 'Feedback Records',
                data: data.values,
                backgroundColor: "rgba(18,115,235,0.7)",
                borderColor: "rgba(18,115,235,1)",
                borderWidth: 2,
                borderRadius: 5
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: true,
                    position: 'top'
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return 'Records: ' + context.parsed.y;
                        }
                    }
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        stepSize: 1,
                        callback: function(value) {
                            return Number.isInteger(value) ? value : '';
                        }
                    }
                }
            },
            onClick: function(event, elements) {
                if (elements.length > 0) {
                    const idx = elements[0].index;
                    const yearId = data.ids[idx];
                    const yearLabel = data.labels[idx];
                    loadYearDetails(yearId, yearLabel);
                }
            }
        }
    });
}

// Load branch details
function loadBranchDetails(branchId, branchName) {
    var selectedYears = $("#year_chart_id").val();
    
    $.ajax({
        url: "<?= base_url('admin/StudentFeedReport/getBranchDetails') ?>",
        type: "POST",
        data: {
            branch_id: branchId,
            years: selectedYears
        },
        dataType: "json",
        beforeSend: function() {
            $("#branchDetails").html(`<div class="text-center"><div class="spinner-border text-primary"></div><p>Loading ${branchName} details...</p></div>`);
        },
        success: function(data) {
            populateBranchTable(data, branchName);
        },
        error: function(xhr, status, error) {
            console.error('Error:', error);
            $("#branchDetails").html(`<p class="text-danger">Error loading ${branchName} data.</p>`);
        }
    });
}

// Populate branch table
function populateBranchTable(data, branchName) {
    let html = `
        <div class="card mt-3">
            <div class="card-header bg-primary text-white"><h5>${branchName} - Feedback Details</h5></div>
            <div class="card-body year">
                <table class="table table-bordered">
                    <thead>
                        <tr class="head">
                            <th>Sr.No</th>
                            <th>Student Name</th>
                            <th>PRN No</th>
                            <th>Hostel</th>
                            <th>Institute</th>
                            <th>Year</th>
                        </tr>
                    </thead>
                    <tbody>`;
    
    if (data.length > 0) {
        data.forEach((row, i) => {
            html += `<tr>
                        <td>${i + 1}</td>
                        <td>${row.student_name || '-'}</td>
                        <td>${row.prno || '-'}</td>
                        <td>${row.hostel_name || '-'}</td>
                        <td>${row.institute_name || '-'}</td>
                        <td>${row.year_label || '-'}</td>
                     </tr>`;
        });
    } else {
        html += `<tr><td colspan="6" class="text-center">No records found</td></tr>`;
    }
    
    html += `</tbody></table></div></div>`;
    $("#branchDetails").html(html);
}

// Load year details
function loadYearDetails(yearId, yearLabel) {
    $.ajax({
        url: "<?= base_url('admin/StudentFeedReport/getYearDetails') ?>",
        type: "POST",
        data: {
            year_id: yearId,
            branches: $("#branchwise_dropdown").val()
        },
        dataType: "json",
        beforeSend: function() {
            $("#yearDetails").html(`<div class="text-center"><div class="spinner-border text-success"></div><p>Loading ${yearLabel} details...</p></div>`);
        },
        success: function(response) {
            if (response.status === "success") {
                populateYearTable(response.data, yearLabel);
            } else {
                $("#yearDetails").html(`<p class="text-danger">No data for ${yearLabel}</p>`);
            }
        },
        error: function() {
            $("#yearDetails").html(`<p class="text-danger">Error loading ${yearLabel} data.</p>`);
        }
    });
}

// Populate year table
function populateYearTable(data, yearLabel) {
    let html = `
        <div class="card mt-3">
            <div class="card-header bg-success text-white"><h5>${yearLabel} - Feedback Details</h5></div>
            <div class="card-body year">
                <table class="table table-bordered">
                    <thead>
                        <tr class="head">
                            <th>Sr.No</th>
                            <th>Student Name</th>
                            <th>PRN No</th>
                            <th>Branch</th>
                            <th>Hostel</th>
                            <th>Institute</th>
                        </tr>
                    </thead>
                    <tbody>`;
    
    if (data.length > 0) {
        data.forEach((row, i) => {
            html += `<tr>
                        <td>${i + 1}</td>
                        <td>${row.student_name || '-'}</td>
                        <td>${row.prno || '-'}</td>
                        <td>${row.branch_name || '-'}</td>
                        <td>${row.hostel_name || '-'}</td>
                        <td>${row.institute_name || '-'}</td>
                     </tr>`;
        });
    } else {
        html += `<tr><td colspan="6" class="text-center">No records found</td></tr>`;
    }
    
    html += `</tbody></table></div></div>`;
    $("#yearDetails").html(html);
}

// Print table function
function printTable() {
    const printElement = document.getElementById('printableTable');
    
    $.ajax({
        url: '<?= base_url("admin/StudentFeedReport/getPrintHeadings") ?>',
        method: 'GET',
        dataType: 'json',
        success: function(heading) {
            const iframe = document.createElement('iframe');
            iframe.style.position = 'fixed';
            iframe.style.right = '0';
            iframe.style.bottom = '0';
            iframe.style.width = '0';
            iframe.style.height = '0';
            iframe.style.border = '0';
            document.body.appendChild(iframe);

            const doc = iframe.contentWindow.document;
            const baseUrl = '<?= base_url() ?>';
            let logoPath = heading.logo || 'Assets/images/sit_logo.png';
            logoPath = logoPath.replace(/^\/+/, '');
            const fullLogoPath = baseUrl + logoPath;

            doc.open();
            doc.write(`
                <html>
                <head>
                    <title>Print Student Feedback Report</title>
                    <style>
                        body { font-family: sans-serif; margin: 10px 5px; padding: 0; }
                        .header-section { display: flex; align-items: center; justify-content: center; gap: 10px; margin-bottom: 5px; }
                        .logo-container img { max-height: 80px; max-width: 80px; }
                        .heading-content { text-align: center; }
                        h4, h6 { margin: 0; padding: 0; }
                        h4 { font-size: 20px; font-weight: bold; color: #d32f2f; }
                        h6 { font-size: 14px; font-weight: normal; }
                        table { width: 100%; border-collapse: collapse; margin-top: 5px; }
                        th, td { border: 1px solid black; padding: 6px 4px; text-align: center; font-size: 12px; color: black; }
                        th { background-color: #0d40a9 !important; color: white !important; }
                    </style>
                </head>
                <body>
                    <div class="header-section">
                        <div class="logo-container">
                            <img src="${fullLogoPath}" alt="Logo" onerror="this.style.display='none';">
                        </div>
                        <div class="heading-content">
                            <h6>${heading.subHead1 || ''}</h6>
                            <h4>${heading.head || 'Student Feedback Report'}</h4>
                            <div>${heading.subHead2 || ''}</div>
                            <div>${heading.subHead3 || ''}</div>
                        </div>
                    </div>
                    <br>
                    ${printElement.outerHTML}
                </body>
                </html>
            `);
            doc.close();

            iframe.contentWindow.onload = function() {
                setTimeout(function() {
                    iframe.contentWindow.focus();
                    iframe.contentWindow.print();
                }, 500);
            };

            setTimeout(() => {
                document.body.removeChild(iframe);
            }, 3000);
        },
        error: function(xhr, status, error) {
            console.error('AJAX Error:', error);
            alert('Error loading print data: ' + error);
        }
    });
}
// Export to Excel function
function exportToExcel() {
    $.ajax({
        url: '<?= base_url("admin/StudentFeedReport/getPrintHeadings") ?>',
        method: 'GET',
        dataType: 'json',
        success: function(heading) {
            var wb = XLSX.utils.book_new();
            var header = [
                [heading.subHead1 || ''],
                [heading.head || 'Library Report'],
                [heading.subHead2 || ''],
                [heading.subHead3 || ''],
                ['']
            ];
            
            var table = document.getElementById('printableTable');
            var wsTable = XLSX.utils.table_to_sheet(table);
            var tableData = XLSX.utils.sheet_to_json(wsTable, { header: 1 });
            var fullData = header.concat(tableData);
            var ws = XLSX.utils.aoa_to_sheet(fullData);
            
            XLSX.utils.book_append_sheet(wb, ws, 'Library Data');
            XLSX.writeFile(wb, 'Library_Report_' + new Date().toISOString().slice(0,10) + '.xlsx');
        }
    });
}

// Print combined chart
function printCombinedChart() {
    if (!branchChart || !yearChart) {
        Swal.fire("Warning", "Please generate charts first!", "warning");
        return;
    }

    const branchChartImg = branchChart.toBase64Image();
    const yearChartImg = yearChart.toBase64Image();
    const branchTable = document.getElementById("branchDetails").innerHTML;
    const yearTable = document.getElementById("yearDetails").innerHTML;

    let printFrame = document.getElementById('printFrame');
    if (printFrame) {
        printFrame.remove();
    }
    
    printFrame = document.createElement('iframe');
    printFrame.id = 'printFrame';
    printFrame.style.position = 'absolute';
    printFrame.style.width = '0';
    printFrame.style.height = '0';
    printFrame.style.border = 'none';
    
    document.body.appendChild(printFrame);
    
    const frameDoc = printFrame.contentWindow.document;
    frameDoc.open();
    frameDoc.write(`
        <!DOCTYPE html>
        <html>
        <head>
            <title>Library Charts & Tables Print</title>
            <style>
                @page { size: A4; margin: 15mm; }
                body { font-family: Arial, sans-serif; margin: 0; padding: 20px; }
                .chart-section { margin-bottom: 20px; }
                .chart-section h2 { font-size: 18px; margin-bottom: 15px; color: #000; }
                .table-section h3 { font-size: 14px; margin: 15px 0 10px 0; color: #000; }
                img { max-width: 100%; height: auto; display: block; margin-bottom: 15px; }
                table { width: 100%; border-collapse: collapse; margin-bottom: 20px; font-size: 11px; }
                th, td { border: 1px solid #333; padding: 6px 8px; text-align: left; color:black; }
                th { background: #f2f2f2; color: #000; font-weight: bold; }
                .page-break { page-break-before: always; }
            </style>
        </head>
        <body>
            <div class="chart-section">
                <h2>Branchwise Chart</h2>
                <img src="${branchChartImg}" alt="Branch Chart">
            </div>
            <div class="table-section">
                <h3>Library Details</h3>
                ${branchTable}
            </div>
            <div class="chart-section page-break">
                <h2>Yearwise Chart</h2>
                <img src="${yearChartImg}" alt="Year Chart">
            </div>
            <div class="table-section">
                <h3>Library Details</h3>
                ${yearTable}
            </div>
        </body>
        </html>
    `);
    frameDoc.close();
    
    setTimeout(() => {
        printFrame.contentWindow.focus();
        printFrame.contentWindow.print();
        setTimeout(() => {
            if (printFrame) {
                printFrame.remove();
            }
        }, 100);
    }, 500);
}
// Add this function to handle URL click and show feedback details in modal
function showFeedbackDetails(feedbackId, studentName) {
    $.ajax({
        url: "<?= base_url('admin/StudentFeedReport/getFeedbackDetailsByFeedback') ?>",
        type: "POST",
        data: { feedback_id: feedbackId },
        dataType: "json",
        beforeSend: function() {
            Swal.fire({
                title: 'Loading...',
                text: 'Fetching feedback details',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });
        },
        success: function(response) {
            Swal.close();
            
            if (response.status === "success" && response.data.length > 0) {
                displayFeedbackModal(response.data, studentName);
            } else {
                Swal.fire("No Data", "No feedback details found for this URL", "info");
            }
        },
        error: function(xhr, status, error) {
            console.error('Error fetching feedback details:', error);
            Swal.fire("Error", "Failed to load feedback details!", "error");
        }
    });
}

// Display feedback details in a modal
function displayFeedbackModal(data, studentName) {
    let modalContent = `
        <div class="modal fade" id="feedbackDetailsModal" tabindex="-1" role="dialog" aria-labelledby="feedbackModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-xl" role="document" style="max-width: 90vw;">
                <div class="modal-content" style="max-height: 90vh; display: flex; flex-direction: column;">
                    <div class="modal-header bg-primary text-white" style="flex-shrink: 0;">
                        <h5 class="modal-title" id="feedbackModalLabel">Feedback Details - ${studentName || 'Student'}</h5>
                        <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close" onclick="closeFeedbackModal()">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body" style="overflow-y: auto; flex: 1;">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped table-sm">
                                <thead class="thead-dark" style="position: sticky; top: 0; z-index: 10;">
                                    <tr>
                                        <th style="width: 8%;">Sr.No.</th>
                                        <th style="width: 30%;">Heading</th>
                                        <th style="width: 35%;">Sub Heading</th>
                                        <th style="width: 27%;">Response</th>
                                    </tr>
                                </thead>
                                <tbody>`;
    
    data.forEach((item, index) => {
        modalContent += `
            <tr>
                <td>${index + 1}</td>
                <td>${item.heading || '-'}</td>
                <td>${item.subheading || '-'}</td>
                <td>${item.option_text || '-'}</td>
            </tr>`;
    });
    
    modalContent += `
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="modal-footer" style="flex-shrink: 0;">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal" onclick="closeFeedbackModal()">Close</button>
                        <button type="button" class="btn btn-primary" onclick="printFeedbackDetails()">
                            <i class="fas fa-print"></i> Print
                        </button>
                    </div>
                </div>
            </div>
        </div>`;
    
    // Remove existing modal if any
    $('#feedbackDetailsModal').remove();
    
    // Append and show new modal
    $('body').append(modalContent);
    $('#feedbackDetailsModal').modal('show');
    
    // Store data for printing
    window.currentFeedbackData = {
        studentName: studentName,
        details: data
    };
}

// Function to close feedback modal
function closeFeedbackModal() {
    $('#feedbackDetailsModal').modal('hide');
    setTimeout(function() {
        $('#feedbackDetailsModal').remove();
        $('.modal-backdrop').remove();
        $('body').removeClass('modal-open');
        $('body').css('padding-right', '');
    }, 300);
}

// Print feedback details
function printFeedbackDetails() {
    if (!window.currentFeedbackData) {
        Swal.fire("Error", "No feedback data to print", "error");
        return;
    }
    
    const data = window.currentFeedbackData;
    
    $.ajax({
        url: '<?= base_url("admin/StudentFeedReport/getPrintHeadings") ?>',
        method: 'GET',
        dataType: 'json',
        success: function(heading) {
            const iframe = document.createElement('iframe');
            iframe.style.position = 'fixed';
            iframe.style.right = '0';
            iframe.style.bottom = '0';
            iframe.style.width = '0';
            iframe.style.height = '0';
            iframe.style.border = '0';
            document.body.appendChild(iframe);

            const doc = iframe.contentWindow.document;
            const baseUrl = '<?= base_url() ?>';
            let logoPath = heading.logo || 'Assets/images/sit_logo.png';
            logoPath = logoPath.replace(/^\/+/, '');
            const fullLogoPath = baseUrl + logoPath;

            let tableRows = '';
            data.details.forEach((item, index) => {
                tableRows += `
                    <tr>
                        <td>${index + 1}</td>
                        <td>${item.heading || '-'}</td>
                        <td>${item.subheading || '-'}</td>
                        <td>${item.option_text || '-'}</td>
                    </tr>`;
            });

            doc.open();
            doc.write(`
                <html>
                <head>
                    <title>Feedback Details - ${data.studentName}</title>
                    <style>
                        body { font-family: sans-serif; margin: 10px 5px; padding: 0; }
                        .header-section { display: flex; align-items: center; justify-content: center; gap: 10px; margin-bottom: 10px; }
                        .logo-container img { max-height: 80px; max-width: 80px; }
                        .heading-content { text-align: center; }
                        h4, h6 { margin: 0; padding: 0; }
                        h4 { font-size: 20px; font-weight: bold; color: #d32f2f; }
                        h6 { font-size: 14px; font-weight: normal; }
                        .student-info { text-align: center; margin: 10px 0; font-weight: bold; font-size: 16px; }
                        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
                        th, td { border: 1px solid black; padding: 8px; text-align: left; font-size: 12px; color: black; }
                        th { background-color: #343a40 !important; color: white !important; text-align: center; }
                        td:first-child { text-align: center; }
                    </style>
                </head>
                <body>
                    <div class="header-section">
                        <div class="logo-container">
                            <img src="${fullLogoPath}" alt="Logo" onerror="this.style.display='none';">
                        </div>
                        <div class="heading-content">
                            <h6>${heading.subHead1 || ''}</h6>
                            <h4>${heading.head || 'Student Feedback Report'}</h4>
                            <div>${heading.subHead2 || ''}</div>
                            <div>${heading.subHead3 || ''}</div>
                        </div>
                    </div>
                    <div class="student-info">Student: ${data.studentName}</div>
                    <table>
                        <thead>
                            <tr>
                                <th style="width: 8%;">Sr.No.</th>
                                <th style="width: 30%;">Heading</th>
                                <th style="width: 32%;">Sub Heading</th>
                                <th style="width: 30%;">Response</th>
                            </tr>
                        </thead>
                        <tbody>
                            ${tableRows}
                        </tbody>
                    </table>
                </body>
                </html>
            `);
            doc.close();

            iframe.contentWindow.onload = function() {
                setTimeout(function() {
                    iframe.contentWindow.focus();
                    iframe.contentWindow.print();
                }, 500);
            };

            setTimeout(() => {
                document.body.removeChild(iframe);
            }, 3000);
        },
        error: function(xhr, status, error) {
            console.error('AJAX Error:', error);
            Swal.fire('Error', 'Error loading print data', 'error');
        }
    });
}

// Update the loadFeedbackData function to include clickable URLs
function loadFeedbackData() {
    var formData = {
        hostel_ids: $("#hostel_id").val(),
        branch_ids: $("#branch_id").val(),
        Institu_ids: $("#institute_id").val(),
        year_ids: $("#year_id").val()
    };

    $("#feedbackTable tbody").html(
        '<tr><td colspan="8" class="text-center"><div class="spinner-border text-primary"></div><p>Loading data...</p></td></tr>'
    );

    $.ajax({
        url: "<?= base_url('admin/StudentFeedReport/getFeedbackData') ?>",
        type: "POST",
        data: formData,
        dataType: "json",
        success: function(response) {
            var tbody = "";
            if (response.length > 0) {
                $.each(response, function(index, row) {
                    let urlCell = '-';
                    if (row.url && row.feedback_id) {
                        urlCell = `<a href="javascript:void(0);" 
                                     onclick="showFeedbackDetails(${row.feedback_id}, '${(row.student_name || '').replace(/'/g, "\\'")}')" 
                                     class="btn btn-sm btn-info">
                                     <i class="fas fa-eye"></i> View Details
                                   </a>`;
                    }
                    
                    tbody += `
                        <tr>
                            <td>${index + 1}</td>
                            <td>${row.student_name || '-'}</td>
                            <td>${row.prno || '-'}</td>
                            <td>${row.branch_name || '-'}</td>
                            <td>${row.hostel_name || '-'}</td>
                            <td>${row.institute_name || '-'}</td>
                            <td>${row.year_label || '-'}</td>
                            <td>${urlCell}</td>
                        </tr>
                    `;
                });
            } else {
                tbody = '<tr><td colspan="8" class="text-center text-warning">No data found for selected filters</td></tr>';
            }
            $("#feedbackTable tbody").html(tbody);
        },
        error: function(xhr, status, error) {
            console.error('AJAX Error:', error);
            Swal.fire("Error", "Failed to load data!", "error");
            $("#feedbackTable tbody").html(
                '<tr><td colspan="8" class="text-center text-danger">Error loading data</td></tr>'
            );
        }
    });
}
</script>
