<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1">
                            Student Counseling Details
                        </div>
                    </div>

                    <div class="card-body">
                        <form role="form" id="Form" method="post" enctype="multipart/form-data">
                            <div class="row gutters">
                                <!-- Hidden Fields -->
                                <input class="form-control" id="stud_counseling_id" name="stud_counseling_id" type="hidden"
                                    value="<?= !empty($data) ? $data[0]->stud_counseling_id : '' ?>" />
                                    
                                     <!-- hidden submenuid -->
<input class="form-control" id="fk_submenuId" name="fk_submenuId" type="hidden"
                           value="<?= isset($subId) ? $subId : '' ?>"  />

                                <!-- Counseling Type -->
                                <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                    <div class="field-wrapper">
                                        <select class="select-single js-states" id="fk_counseling_type" name="fk_counseling_type" required>
                                            <option value="">Select Counseling Type</option>
                                            <?php 
                                            foreach($counseling_types as $type){
                                                $selected = "";
                                                if (!empty($data[0]->fk_counseling_type)) {
                                                    if ($type->counseling_id == $data[0]->fk_counseling_type) {
                                                        $selected = "selected='selected'";
                                                    }
                                                }
                                                echo '<option value="'.$type->counseling_id.'"'.$selected.'>'.$type->counseling_name.'</option>';
                                            }
                                            ?>
                                        </select>
                                        <div class="field-placeholder">Counseling Type<span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <!-- Name of Faculty/Mentor -->
                                <div class="col-md-4 col-12">
                                    <div class="field-wrapper">
                                        <input class="form-control" type="text" name="faculty_name" id="faculty_name" 
                                            value="<?php if(!empty($data)) echo $data[0]->faculty_name; ?>">
                                        <div class="field-placeholder">Name of Faculty/Mentor</div>
                                    </div>
                                </div>

                                <!-- Faculty ID/Thumb -->
                                <div class="col-md-4 col-12">
                                    <div class="field-wrapper">
                                        <input class="form-control" type="text" name="faculty_thumb" id="faculty_thumb" 
                                            value="<?php if(!empty($data)) echo $data[0]->faculty_thumb; ?>">
                                        <div class="field-placeholder">Faculty ID/Thumb</div>
                                    </div>
                                </div>

                                <!-- Department -->
                                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <div class="field-wrapper">
                                        <select class="select-single js-states" id="fk_department" name="fk_department" required>
                                            <option value="">Select Department</option>
                                            <?php 
                                            foreach($departments as $dept){
                                                $selected = "";
                                                if (!empty($data[0]->fk_department)) {
                                                    if ($dept->branch_id == $data[0]->fk_department) {
                                                        $selected = "selected='selected'";
                                                    }
                                                }
                                                echo '<option value="'.$dept->branch_id.'"'.$selected.'>'.$dept->branch_name.'</option>';
                                            }
                                            ?>
                                        </select>
                                        <div class="field-placeholder">Department<span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <!-- PDF Upload -->
                                <div class="col-md-3 col-sm-12 col-12">
                                    <div class="field-wrapper">
                                        <div class="field-placeholder">Report PDF</div>
                                        <input type="file" name="pdf_file" id="pdf_file" class="form-control" 
                                            accept=".pdf,.doc,.docx" onchange="previewPDF(this)">
                                        
                                        <div id="pdf_preview" style="margin-top:10px;">
                                            <?php
                                            if (!empty($data[0]->pdf_file)) {
                                                $fileUrl = base_url($data[0]->pdf_file);
                                                ?>
                                                <a href="<?= $fileUrl ?>" target="_blank">
                                                    <img src="<?= base_url('Assets/img/Document_file.png') ?>" 
                                                        alt="View PDF" style="height: 80px;" />
                                                </a>
                                            <?php } ?>
                                        </div>
                                        
                                        <input type="hidden" name="hidden_pdf" 
                                            value="<?= !empty($data[0]->pdf_file) ? $data[0]->pdf_file : '' ?>">
                                    </div>
                                </div>

                                <!-- Counseling Date -->
                                <div class="col-md-3 col-12">
                                    <div class="field-wrapper">
                                        <input class="form-control" type="date" name="counseling_date" id="counseling_date" 
                                            value="<?php if(!empty($data)) echo $data[0]->counseling_date; ?>" required>
                                        <div class="field-placeholder">Date<span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <!-- Academic Year -->
                                <div class="col-md-3">
                                    <div class="field-wrapper">
                                        <select name="fk_year" id="fk_year" class="select-single js-states form-control" required>
                                            <?php
                                            $savedYear = '';
                                            if (!empty($data) && isset($data[0]->fk_year)) {
                                                $savedYear = $data[0]->fk_year;
                                            } elseif (!empty($detailData) && isset($detailData[0]->fk_year)) {
                                                $savedYear = $detailData[0]->fk_year;
                                            }
                                            if (empty($savedYear) && !empty($activeYear)) {
                                                $savedYear = $activeYear->finiYear_id;
                                            }
                                            ?>
                                            <option value="">Select year</option>
                                            <?php foreach($yeardata as $year): ?>
                                                <option value="<?= $year->finiYear_id ?>"
                                                    <?= ($year->finiYear_id == $savedYear) ? 'selected' : '' ?>>
                                                    <?= $year->fini_Label ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Year<span class="text-danger">*</span></div>
                                    </div>
                                </div>
                            </div>

                            <!-- Student Detail Table -->
                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-3 col-12">
                                <div class="table-responsive mt-3 mb-3" id="printableTable">
                                    <div class="float-end mb-2">
                                        <?php if (!empty($data)): ?>
                                            <button class="btn btn-danger btn-sm m-1" type="button" id="btnClearAll" 
                                                style="padding: 6px 10px; font-size: 13px;">
                                                <i class="fas fa-times"></i> Clear All
                                            </button>
                                        <?php endif; ?>
                                    </div>
<style>
#studentTable th {
    background-color: #0d40a9;
    color: white !important;
    font-weight: bold;
    padding: 10px;
    letter-spacing: 0.5px;
    border: 1px solid black;
}
</style>
                                    <table id="studentTable" class="table custom-table">
                                        <thead>
                                            <tr>
                                                <th class="text-white">Sr.No.</th>
                                                <th class="text-white">Student Name</th>
                                                <th class="text-white">PRN No</th>
                                                <th class="text-white">Mobile No</th>
                                                <th class="text-white">Remark</th>
                                                <th class="text-white">Action</th>
                                            </tr>
                                        </thead>
                                        <tbody id="tableBody">
                                            <?php if(!empty($detailData)): 
                                                $i = 1;
                                                foreach($detailData as $row): ?>
                                                <tr>
                                                    <td><?= $i++ ?></td>
                                                    <td>
                                                        <input type="hidden" name="counseling_detail_id[]" 
                                                            value="<?= $row->counseling_detail_id ?>">
                                                        <input type="text" name="student_name[]" class="form-control" 
                                                            value="<?= $row->student_name ?>" required>
                                                    </td>
                                                    <td>
                                                        <input type="text" name="prn_no[]" class="form-control" 
                                                            value="<?= $row->prn_no ?>">
                                                    </td>
                                                    <td>
                                                        <input type="text" name="mobile_no[]" class="form-control" 
                                                            value="<?= $row->mobile_no ?>">
                                                    </td>
                                                    <td>
                                                        <input type="text" name="remark[]" class="form-control" 
                                                            value="<?= $row->remark ?>">
                                                    </td>
                                                    <td>
                                                        <button type="button" class="btn text-danger btn-sm removeRow">
                                                            <i class="fa-solid fa-trash"></i>
                                                        </button>
                                                    </td>
                                                </tr>
                                            <?php endforeach; endif; ?>
                                        </tbody>
                                    </table>

                                    <div class="float-end">
                                        <button type="button" class="btn btn-success btn-sm p-2 rounded-3 mb-2" id="addRowBtn">
                                            <i class="fa-solid fa-plus bg-white p-1 rounded-circle text-success shadow-lg"></i>
                                            Add Row
                                        </button>
                                    </div>
                                </div>

                                <!-- Action Buttons -->
                                <div class="card-body">
                                    <div class="">
                                        <button class="btn mb-md-0 mb-2 btn-quarternary" id="btn_save" name="btn_save" type="button">
                                            <i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save
                                        </button>
                                        <a class="btn mb-md-0 mb-2 btn-quarternary1" 
                                            href="<?= base_url() ?>admin/Student_Counseling/index" type="button">
                                            <i class="fa-solid fa-list"></i>&nbsp;&nbsp;List
                                        </a>
                                        <button type="button" class="btn mb-md-0 mb-2 btn-quarternaryhome"
                                            onclick="window.location.href='<?= base_url('admin/Student_Counseling/dashboard') ?>'">
                                            <i class="fa-solid fa-home fa-lg"></i>
                                            <span class="fw-semibold">Home</span>
                                        </button>
                                        <br>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="<?php echo base_url();?>Assets/js/jquery.min.js"></script>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script> 
<script src="<?php echo base_url();?>Assets/js/CreateJs/admin/Student_Counseling.js"></script>

<script>
    // PDF Preview Function
    function previewPDF(input) {
        const preview = document.getElementById('pdf_preview');
        const file = input.files[0];

        if (file) {
            const fileUrl = URL.createObjectURL(file);
            preview.innerHTML = `<a href="${fileUrl}" target="_blank">
                                    <img src="<?= base_url('Assets/img/Document_file.png') ?>" 
                                        alt="View PDF" style="height: 80px;">
                                 </a>`;
        } else {
            preview.innerHTML = '';
        }
    }

    // Set today's date if empty
    document.addEventListener('DOMContentLoaded', () => {
        const today = new Date().toISOString().split('T')[0];
        const setDateIfEmpty = (id) => {
            const input = document.getElementById(id);
            if (!input.value) {
                input.value = today;
            }
        };
        setDateIfEmpty("counseling_date");
    });
</script>

<!-- Add/Remove Row Script -->
<script>
$(document).ready(function () {
    let rowCount = <?= !empty($detailData) ? count($detailData) : 0 ?>;
    let isUpdateMode = $("#stud_counseling_id").val() ? true : false;

    function addRow(student_name = "", prn_no = "", mobile_no = "", remark = "", detail_id = "") {
        rowCount++;
        let newRow = `
            <tr>
                <td>${rowCount}</td>
                <td>
                    <input type="hidden" name="counseling_detail_id[]" value="${detail_id}">
                    <input type="text" name="student_name[]" class="form-control" value="${student_name}" required>
                </td>
                <td><input type="text" name="prn_no[]" class="form-control" value="${prn_no}"></td>
                <td><input type="text" name="mobile_no[]" class="form-control" value="${mobile_no}"></td>
                <td><input type="text" name="remark[]" class="form-control" value="${remark}"></td>
                <td>
                    <button type="button" class="btn text-danger btn-sm removeRow">
                        <i class="fa-solid fa-trash"></i>
                    </button>
                </td>
            </tr>`;
        $("#tableBody").append(newRow);
    }

    if (!isUpdateMode && $("#tableBody tr").length === 0) {
        addRow();
    }

    $("#addRowBtn").click(function () {
        addRow();
    });

    $("#btnClearAll").click(function () {
        Swal.fire({
            title: 'Are you sure?',
            text: 'This will clear all table data!',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, clear all!'
        }).then((result) => {
            if (result.isConfirmed) {
                $("#tableBody").empty();
                rowCount = 0;
                Swal.fire('Cleared!', 'All table data has been cleared.', 'success');
            }
        });
    });

    $(document).on("click", ".removeRow", function () {
        $(this).closest("tr").remove();
        updateSerialNumbers();
    });

    function updateSerialNumbers() {
        rowCount = 0;
        $("#tableBody tr").each(function () {
            rowCount++;
            $(this).find("td:first").text(rowCount);
        });
    }
});
</script>
