<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Student Registration Dashboard</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <style>
        body {
            background-color: #f5f5f5;
            font-family: Arial, sans-serif;
        }

        p {
            margin-bottom: 0.2rem;
            line-height: 273%;
        }
        .ribbon {
            display: inline-block;
            background-color: #17a2b8;
            color: white;
            font-size: 27px;
            font-weight: 600;
            font-family: 'Times New Roman', serif;
            padding: 4px 20px;
            position: relative;
            margin: 0px;
        }
        .ribbon::after {
            content: '';
            position: absolute;
            top: 0;
            right: -20px;
            width: 0;
            height: 0;
            border-left: 21px solid #17a2b8;
            border-top: 18px solid transparent;
            border-bottom: 23px solid transparent;
        }
        .ribbon::before {
            content: '';
            position: absolute;
            top: 0;
            left: -20px;
            width: 0;
            height: 0;
            border-right: 21px solid #17a2b8;
            border-top: 18px solid transparent;
            border-bottom: 23px solid transparent;
        }

        .technical-menu {
            position: relative;
            background: #f8f9fa00;
            border-radius: 10px;
            padding: 20px;
            margin-top: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            border: 2px solid black;
        }
        
        .legend-header {
            position: absolute;
            top: -12px;
            left: 20px;
            background: white;
            padding: 0 10px;
        }
        
        .legend-header h5 {
            color: #df0a7b;
            font-weight: 600;
            margin: 0;
            font-size: 1.2rem;
        }

        .menu-item {
            background: white;
            border: none;
            border-radius: 8px;
            padding: 10px 14px;
            margin: 8px 0;
            width: 100%;
            text-align: left;
            transition: all 0.3s ease;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            cursor: pointer;
        }

        .menu-item:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(0,0,0,0.15);
        }

        .menu-item a {
            text-decoration: none;
            color: #333;
            display: block;
            width: 100%;
            height: 100%;
        }

        .menu-item i {
            width: 20px;
            margin-right: 10px;
            color:black;
        }

        .form-text {
            font-size: 0.85em;
            color: #6c757d;
            margin-top: 4px;
            display: block;
        }

        .loading {
            text-align: center;
            padding: 20px;
            color: #666;
        }

        .error-message {
            text-align: center;
            padding: 20px;
            color: #dc3545;
        }

        @media screen and (max-width: 1420px) {
            .ribbon {
                font-size: 22px !important;
            }
        }
    </style>
</head>
<body>
    <div class="content-wrapper">
        <div class="container-fluid">
            <div class="card p-4 shadow">
                <!-- Dashboard Header -->
                <div class="col-12 mx-auto main_dashbord">
                    <div class="col-12 mx-auto mt-1">
                        <div class="row" style="justify-content:space-evenly;">
                            <div class="col-4">
                                <h4 class="ribbon" id="head"></h4>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Two Section Menu Row -->
                <div class="col-12 mx-auto">
                    <div class="row">
                        <!-- Student Registration Menu Section (fkFormTypeID = 1) -->
                        <div class="col-6">
                            <div class="technical-menu">
                                <div class="legend-header">
                                    <h5 class="mb-2"id="subhead"></h5>
                                </div>
                                
                                <div class="row" id="menuSection">
                                    <div class="col-12 loading">
                                        <i class="fas fa-spinner fa-spin"></i> Loading menu items...
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Reports Section (fkFormTypeID = 2) -->
                        <div class="col-6">
                            <div class="technical-menu">
                                <div class="legend-header">
                                    <h5 class="mb-2"id="report"></h5>
                                </div>
                                
                                <div class="row" id="reportSection">
                                    <div class="col-12 loading">
                                        <i class="fas fa-spinner fa-spin"></i> Loading reports...
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        $(document).ready(function() {
             const fkMenuID = <?= isset($fkMenuID) ? $fkMenuID : 0 ?>;// Set your menu ID here
            
            // Function to fetch submenu data from database
            // alert(fkMenuID)
            function fetchSubmenuData() {
                $.ajax({
                    url: '<?php echo base_url("admin/StudentReg/get_submenu_data"); ?>', // CodeIgniter URL
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        fkMenuID: fkMenuID
                    },
                    
                    success: function(response) {
                        if (response.success) {
                            console.log(response.data[0]['MenuMainHead'])
                            $('#head').append(response.data[0]['MenuMainHead']);
                             $('#subhead').append(response.data[0]['MenuSubHead'])
                              $('#report').append(response.data[0]['MenuReport'])

                            loadMenuItems(response.data);
                            loadReportItems(response.data);
                        } else {
                            showError('menuSection', response.message || 'Failed to load menu items');
                            showError('reportSection', response.message || 'Failed to load reports');
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error('AJAX Error:', error);
                        showError('menuSection', 'Error loading menu items. Please try again.');
                        showError('reportSection', 'Error loading reports. Please try again.');
                    }
                });
            }

            // Function to show error message
            function showError(elementId, message) {
                $(`#${elementId}`).html(`
                    <div class="col-12 error-message">
                        <i class="fas fa-exclamation-triangle"></i> ${message}
                    </div>
                `);
            }

            // Function to load menu items
            function loadMenuItems(submenuData) {
                console.log('Loading menu items, data:', submenuData);
                
                // Filter items where fkFormTypeID = 1 or fkFormTypeID = "1" (handle both)
                const menuItems = submenuData.filter(item => {
                    console.log('Item:', item.Name, 'fkFormTypeID:', item.fkFormTypeID, 'Type:', typeof item.fkFormTypeID);
                    return (item.fkFormTypeID == 1);
                }).sort((a, b) => a.ArrangeNO - b.ArrangeNO);

                console.log('Filtered menu items:', menuItems);

                if (menuItems.length === 0) {
                    $('#menuSection').html('<div class="col-12 text-center p-3">No menu items available</div>');
                    return;
                }

                let menuHTML = '';
                menuItems.forEach(item => {
                    // Clean the URL - remove 'sitcollage/' prefix if it exists
                    let cleanURL = item.URL;
                    
                    // Remove any occurrence of 'sitcollage/' at the start
                    cleanURL = cleanURL.replace(/^sitcollage\//, '');
                    
                    // Also remove any leading slashes
                    cleanURL = cleanURL.replace(/^\/+/, '');
                    
                    // Remove full URL if present
                    cleanURL = cleanURL.replace(/^https?:\/\/[^\/]+\/sitcollage\//, '');
                    cleanURL = cleanURL.replace(/^https?:\/\/[^\/]+\//, '');
                    
                    console.log('Original URL:', item.URL, 'Clean URL:', cleanURL);
                    
                    menuHTML += `
                        <div class="col-12">
                            <button class="menu-item">
                                <a href="<?php echo base_url(); ?>${cleanURL}">
                                    <i class="fas fa-clipboard-list"></i>
                                    ${item.Name}
                                    ${item.SubName ? `<div class="form-text">${item.SubName}</div>` : ''}
                                </a>
                            </button>
                        </div>
                    `;
                });

                $('#menuSection').html(menuHTML);
            }

            // Function to load report items
            function loadReportItems(submenuData) {
                console.log('Loading report items, data:', submenuData);
                
                // Filter items where fkFormTypeID = 2 or fkFormTypeID = "2" (handle both)
                const reportItems = submenuData.filter(item => {
                    console.log('Report Item:', item.Name, 'fkFormTypeID:', item.fkFormTypeID, 'Type:', typeof item.fkFormTypeID);
                    return (item.fkFormTypeID == 2);
                }).sort((a, b) => a.ArrangeNO - b.ArrangeNO);

                console.log('Filtered report items:', reportItems);

                if (reportItems.length === 0) {
                    $('#reportSection').html('<div class="col-12 text-center p-3">No reports available</div>');
                    return;
                }

                let reportHTML = '';
                reportItems.forEach(item => {
                    // Clean the URL - remove 'sitcollage/' prefix if it exists
                    let cleanURL = item.URL;
                    
                    // Remove any occurrence of 'sitcollage/' at the start
                    cleanURL = cleanURL.replace(/^sitcollage\//, '');
                    
                    // Also remove any leading slashes
                    cleanURL = cleanURL.replace(/^\/+/, '');
                    
                    // Remove full URL if present
                    cleanURL = cleanURL.replace(/^https?:\/\/[^\/]+\/sitcollage\//, '');
                    cleanURL = cleanURL.replace(/^https?:\/\/[^\/]+\//, '');
                    
                    console.log('Original URL:', item.URL, 'Clean URL:', cleanURL);
                    
                    reportHTML += `
                        <div class="col-12">
                            <button class="menu-item">
                                <a href="<?php echo base_url(); ?>${cleanURL}">
                                    <i class="fas fa-list"></i>
                                    ${item.Name}
                                    ${item.SubName ? `<div class="form-text">${item.SubName}</div>` : ''}
                                </a>
                            </button>
                        </div>
                    `;
                });

                $('#reportSection').html(reportHTML);
            }

            // Initialize dashboard by fetching data from database
            fetchSubmenuData();
        });
    </script>
</body>
</html>