<!-- Fonts & Icons -->
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">

<!-- Styles -->
<style>
    body {
        font-family: 'Poppins', sans-serif;
        background-color: #f6f8fb;
    }

    .card {
        border: none;
        box-shadow: 0 0 6px rgba(0, 0, 0, 0.02);
        border-radius: 10px;
        margin: 0;
        padding: 0;
    }

    .card-header {
        padding: 10px 15px;
    }

    .card-body {
        padding: 10px 15px;
    }

    .card-title {
        font-size: 16px;
        font-weight: 600;
        margin: 0;
        color: #333;
    }

    #searchInput {
        border-radius: 20px;
        padding: 6px 12px;
        border: 1px solid #ccc;
        max-width: 250px;
        font-size: 13px;
        outline: none;
    }

    #searchInput:focus {
        border-color: #28a745;
        box-shadow: 0 0 0 2px rgba(40, 167, 69, 0.1);
    }

    .report-item {
        background: #fff;
        border: 1px solid #e0e0e0;
        border-radius: 8px;
        padding: 8px 12px;
        margin-bottom: 6px;
        display: flex;
        align-items: center;
        gap: 8px;
        transition: background-color 0.2s ease;
        font-size: 13px;
    }

    .report-item:hover {
        background-color: #ecfdf5;
    }

    .report-icon {
        font-size: 14px;
        color: #28a745;
        flex-shrink: 0;
    }

    .report-text a {
        font-size: 13px;
        font-weight: 500;
        text-decoration: none;
        color: #222;
        transition: all 0.2s;
    }

    .report-text a:hover {
        color: #198754;
    }

    .text-muted {
        color: #999 !important;
        font-size: 13px;
    }

    .highlight {
        background-color: #fff3cd;
        padding: 1px 3px;
        border-radius: 3px;
        font-weight: 600;
        color: #856404;
    }
</style>

<!-- View -->
<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center flex-wrap gap-2">
                        <div class="card-title">🗂 Submenu Report</div>
                        <input type="text" id="searchInput" class="form-control form-control-sm" placeholder="🔍 Search submenu..." />
                    </div>

                    <div class="card-body">
                        <form id="Form" method="post">
                            <div class="row" id="reportContainer">
                                <?php if (!empty($submenu)): ?>
                                    <?php foreach ($submenu as $index => $sm): ?>
                                        <div class="col-md-12 report-item">
                                            <div class="report-icon">
                                                <i class="fa-solid <?= !empty($sm->URL) ? 'fa-link' : 'fa-file-lines' ?>"></i>
                                            </div>
                                            <div class="report-text">
                                                <?php if (!empty($sm->URL)): ?>
                                                <a href="<?= base_url('admin/' . $sm->URL) ?>" target="_self">
    <?= ($index + 1) ?>. <?= $sm->SubMenuName ?>
</a>

                                                    <!--<a href="<?= base_url($sm->URL) ?>" target="_self">-->
                                                    <!--    <?= ($index + 1) ?>. <?= $sm->SubMenuName ?>-->
                                                    <!--</a>-->
                                                <?php else: ?>
                                                    <span class="text-muted">
                                                        <?= ($index + 1) ?>. <?= $sm->SubMenuName ?> (No URL)
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <div class="col-md-12 text-center text-muted">No submenu entries found.</div>
                                <?php endif; ?>
                            </div>
                        </form>
                    </div>
                </div> <!-- End Card -->
            </div>
        </div>
    </div>
</div>

<!-- jQuery -->
<script src="<?= base_url(); ?>Assets/js/jquery.min.js"></script>

<!-- Search Filter Script -->
<script>
$(document).ready(function () {
    $('.report-item').each(function () {
        let $text = $(this).find('.report-text');
        $text.data('original-html', $text.html());
    });

    $('#searchInput').on('keyup', function () {
        let keyword = $(this).val().toLowerCase();

        $('.report-item').each(function () {
            let $reportText = $(this).find('.report-text');
            let $link = $reportText.find('a');

            if (keyword === "") {
                $reportText.html($reportText.data('original-html'));
                $(this).show();
                return;
            }

            let textToSearch = $link.length ? $link.text().toLowerCase() : $reportText.text().toLowerCase();

            if (textToSearch.includes(keyword)) {
                $(this).show();

                let safeKeyword = keyword.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
                let regex = new RegExp('(' + safeKeyword + ')', 'gi');

                if ($link.length) {
                    let originalText = $link.text();
                    let highlightedText = originalText.replace(regex, '<span class="highlight">$1</span>');
                    $link.html(highlightedText);
                } else {
                    let originalText = $reportText.text();
                    let highlightedText = originalText.replace(regex, '<span class="highlight">$1</span>');
                    $reportText.html('<span class="text-muted">' + highlightedText + '</span>');
                }
            } else {
                $(this).hide();
            }
        });
    });
});
</script>
