<!DOCTYPE html>
<html lang="en">
<head>
    <!-- In <head> -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Hostel Feedback Form</title>
<style>
* {
	margin: 0;
	padding: 0;
	box-sizing: border-box;
}

body {
	font-family: 'Segoe UI', Tahoma, sans-serif;
	background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
	min-height: 100vh;
	padding-bottom: 65px;
}

.container {
	max-width: 600px;
	margin: 0 auto;
	padding: 10px;
}

.college-header {
    background: white;
    padding: 10px 15px;
    margin: 2px -5px 15px -5px;
    border-radius: 15px;
    text-align: center;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
}

.header-inner {
	display: flex;
	flex-direction: column;
	align-items: center;
}

.college-logo {
	width: 70px;
	height: 70px;
	object-fit: contain;
}

.college-details h1 {
	font-size: 18px;
	color: #e93939;
	font-weight: 600;
	line-height: 1.3;
	margin-bottom: 5px;
}

.college-details p {
	font-size: 13px;
	color: #666;
	margin: 2px 0;
}

.info-card {
    background: white;
    padding: 20px 15px;
    margin: -10px -5px 4px -5px;
    border-radius: 15px;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
}

.form-group {
	margin-bottom: 15px;
}

.form-group label {
	display: block;
	font-size: 13px;
	font-weight: 600;
	color: #333;
	margin-bottom: 6px;
}

.form-group input,
.form-group select {
	width: 100%;
	padding: 12px;
	border: 2px solid #e1e8ed;
	border-radius: 10px;
	font-size: 14px;
	transition: all 0.3s;
	background: #f8f9fa;
}

.form-group input:focus,
.form-group select:focus {
	outline: none;
	border-color: #007bff;
	background: white;
   box-shadow: 0 4px 15px rgba(0, 0, 0, 0.3);
}

.progress-container {
    background: white;
    padding: 15px;
    margin: 0 -5px 15px -5px;
    border-radius: 15px;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
}

.progress-text {
	text-align: center;
	font-size: 13px;
	color: #666;
	margin-bottom: 10px;
}

.progress-text span {
	font-weight: bold;
	color: #007bff;
	font-size: 16px;
}

.progress-bar {
	width: 100%;
	height: 8px;
	background: #e1e8ed;
	border-radius: 10px;
	overflow: hidden;
}

.progress-fill {
	height: 100%;
	background: linear-gradient(90deg, #007bff, #0056b3);
	border-radius: 10px;
	transition: width 0.4s ease;
}

.tab-dots {
	display: flex;
	justify-content: center;
	gap: 8px;
	margin-top: 12px;
}

.dot {
	width: 10px;
	height: 10px;
	border-radius: 50%;
	background: #e1e8ed;
	transition: all 0.3s;
}

.dot.active {
	background: #007bff;
	transform: scale(1.3);
}

.section {
	display: none;
}

.section.active {
	display: block;
	animation: fadeIn 0.4s ease;
}

@keyframes fadeIn {
	from {
		opacity: 0;
		transform: translateY(10px);
	}
	to {
		opacity: 1;
		transform: translateY(0);
	}
}

.section-header {
    background: white;
    padding: 15px;
    margin: -11px -5px 5px -5px;
    border-radius: 15px;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
}

.section-header h2 {
	font-size: 18px;
	color: #007bff;
	font-weight: 600;
	display: flex;
	align-items: center;
	gap: 10px;
}

.section-icon {
	width: 35px;
	height: 35px;
	background: linear-gradient(135deg, #667eea, #764ba2);
	border-radius: 10px;
	display: flex;
	align-items: center;
	justify-content: center;
	color: white;
	font-size: 18px;
}

.card {
	background: white;
	padding: 18px 15px;
	border-radius: 15px;
	margin-bottom: 5px;
    margin-left: -5px;
    margin-right: -5px;
	box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
}

.question {
	font-size: 14px;
	font-weight: 600;
	color: #333;
	margin-bottom: 12px;
	line-height: 1.4;
}

.options {
	display: flex;
	flex-direction: column;
	gap: 8px;
}

.option-label {
	display: flex;
	align-items: center;
	padding: 10px 12px;
	border: 2px solid #e1e8ed;
	border-radius: 10px;
	cursor: pointer;
	transition: all 0.3s;
	background: #f8f9fa;
}

.option-label:hover {
	border-color: #007bff;
	background: #f0f7ff;
}

.option-label input[type="radio"] {
	width: 18px;
	height: 18px;
	margin-right: 10px;
	cursor: pointer;
	accent-color: #007bff;
}

.option-label:has(input:checked) {
	border-color: #007bff;
	background: #e7f3ff;
}

.option-text {
	font-size: 13px;
	color: #333;
	font-weight: 500;
}

.nav-buttons {
	position: fixed;
	bottom: 0;
	left: 0;
	right: 0;
	background: white;
	padding: 12px 15px;
	box-shadow: 0 -3px 15px rgba(0, 0, 0, 0.1);
	display: flex;
	gap: 10px;
	z-index: 100;
}

.btn {
	flex: 1;
	padding: 14px;
	font-size: 15px;
	font-weight: 600;
	border: none;
	border-radius: 12px;
	cursor: pointer;
	transition: all 0.3s;
	text-transform: uppercase;
	letter-spacing: 0.5px;
}

.btn-prev {
	background: #f8f9fa;
	color: #666;
	border: 2px solid #e1e8ed;
}

.btn-prev:not(.disabled):hover {
	background: #e1e8ed;
}

.btn-next {
	background: linear-gradient(135deg, #667eea, #764ba2);
	color: white;
}

.btn-next:hover {
	transform: translateY(-2px);
	box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
}

.btn.disabled {
	opacity: 0.4;
	cursor: not-allowed;
	pointer-events: none;
}

.success-message {
	display: none;
	background: white;
	padding: 40px 20px;
	border-radius: 15px;
	text-align: center;
	box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
	animation: fadeIn 0.5s ease;
    margin-top: 5px;

}

.success-icon {
	width: 80px;
	height: 80px;
	background: linear-gradient(135deg, #11998e, #38ef7d);
	border-radius: 50%;
	margin: 0 auto 20px;
	display: flex;
	align-items: center;
	justify-content: center;
	font-size: 40px;
	color: white;
}

.success-message h2 {
	font-size: 22px;
	color: #333;
	margin-bottom: 10px;
}

.success-message p {
	color: #666;
	font-size: 14px;
	line-height: 1.6;
}

@media (max-width: 480px) {
	.container {
		padding-top: 0px;
	}
	.college-details h1 {
		font-size: 16px;
	}
	.section-header h2 {
		font-size: 16px;
	}
	.college-logo {
		width: 60px;
		height: 60px;
		font-size: 20px;
	}
}
</style>
</head>
<body>
<div class="container">
<!--     
<?php if(isset($heading) && $heading): ?>
<div class="college-header">
    <div class="header-inner">
      <?php if(!empty($heading->logo)): ?>
    <img src="<?= base_url(ltrim($heading->logo, '/')) ?>" 
         alt="College Logo" 
         class="college-logo">
<?php else: ?>
    <img src="<?= base_url('assets/images/sit_logo.png') ?>" 
         alt="College Logo" 
         class="college-logo">
<?php endif; ?>
        
        <div class="college-details">
            <h1>
                <?= !empty($heading->subHead1) ? htmlspecialchars($heading->subHead1) : 'Sharad Institute of Technology' ?>
                <?php if(!empty($heading->head)): ?>
                    <br><?= htmlspecialchars($heading->head) ?>
                <?php endif; ?>
            </h1>
            
            <?php if(!empty($heading->subHead2)): ?>
                <h1><?= htmlspecialchars($heading->subHead2) ?></h1>
            <?php endif; ?>
            
            <p>Hostel Feedback Form</p>
            
            <?php if(isset($financial_year) && $financial_year): ?>
                <p>Academic Year <?= htmlspecialchars($financial_year->fini_Label) ?></p>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php else: ?>
<div class="college-header">
    <div class="header-inner">
        <img src="<?= base_url('assets/images/sit_logo.png') ?>" alt="College Logo" class="college-logo">
        <div class="college-details">
            <h1>Sharad Institute of Technology<br>College of Engineering, Yadrav</h1>
            <h1>Ichalkaranji</h1>
            <p>Hostel Feedback Form</p>
            <p>Academic Year 2024-2025</p>
        </div>
    </div>
</div>
<?php endif; ?> -->
<?php if(isset($heading) && $heading): ?>
<div class="college-header">
    <div class="header-inner">
        <?php if(!empty($heading->logo)): ?>
            <img src="<?= base_url(ltrim($heading->logo, '/')) ?>" 
                 alt="College Logo" 
                 class="college-logo">
        <?php else: ?>
            <img src="<?= base_url('assets/images/sit_logo.png') ?>" 
                 alt="College Logo" 
                 class="college-logo">
        <?php endif; ?>
        
        <div class="college-details">
            <h1>
                <?= !empty($heading->subHead1) ? htmlspecialchars($heading->subHead1) : 'Sharad Institute of Technology' ?>
                <?php if(!empty($heading->head)): ?>
                    <br><?= htmlspecialchars($heading->head) ?>
                <?php endif; ?>
            </h1>
            
            <?php if(!empty($heading->subHead2)): ?>
                <h1><?= htmlspecialchars($heading->subHead2) ?></h1>
            <?php endif; ?>
            
            <!-- Display Institute Name and Hostel Type instead of static text -->
            <p>
                <!-- <?php if(isset($institute_name) && !empty($institute_name)): ?>
                    <?= htmlspecialchars($institute_name) ?>
                <?php else: ?>
                    Institute
                <?php endif; ?> -->
                
                <?php if(isset($Hostel_Name) && !empty($Hostel_Name)): ?>
                     <?= htmlspecialchars($Hostel_Name) ?>
                <?php endif; ?>
                Feedback Form
            </p>
            
            <?php if(isset($financial_year) && $financial_year): ?>
                <p>Academic Year <?= htmlspecialchars($financial_year->fini_Label) ?></p>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php else: ?>
<div class="college-header">
    <div class="header-inner">
        <img src="<?= base_url('assets/images/sit_logo.png') ?>" alt="College Logo" class="college-logo">
        <div class="college-details">
            <h1>Sharad Institute of Technology<br>College of Engineering, Yadrav</h1>
            <h1>Ichalkaranji</h1>
            <p>Hostel Feedback Form</p>
            <p>Academic Year 2024-2025</p>
        </div>
    </div>
</div>
<?php endif; ?>

<div class="info-card">
    <div class="form-group">
        <label>Student Name *</label>
        <input type="text" id="studentName" required>
    </div>
    <div class="form-group">
        <label>PRN Number *</label>
        <input type="text" id="prnNumber" required>
    </div>
    <div class="form-group">
    <label>Branch *</label>
    <select id="branch" required>
        <option value="">Select your branch</option>
        <?php if (!empty($branches)): ?>
            <?php foreach ($branches as $branch): ?>
                <option value="<?= htmlspecialchars($branch->branch_name) ?>">
                    <?= htmlspecialchars($branch->branch_name) ?>
                </option>
            <?php endforeach; ?>
        <?php else: ?>
            <option value="">No branches available</option>
        <?php endif; ?>
    </select>
</div>

</div>

<div class="progress-container">
    <div class="progress-text">Section <span id="currentSection">1</span> of <span id="totalSections"><?= count($survey_structure) ?></span></div>
    <div class="progress-bar">
        <div class="progress-fill" id="progressFill" style="width: <?= (1 / count($survey_structure)) * 100 ?>%"></div>
    </div>
    <div class="tab-dots" id="tabDots">
        <?php foreach ($survey_structure as $index => $heading): ?>
            <div class="dot <?= $index == 0 ? 'active' : '' ?>"></div>
        <?php endforeach; ?>
    </div>
</div>

<form id="surveyForm" method="post" action="<?= base_url('admin/survey/submit_survey') ?>">
    <input type="hidden" id="hiddenStudentName" name="studentName">
    <input type="hidden" id="hiddenPrnNumber" name="prnNumber">
    <input type="hidden" id="hiddenBranch" name="branch">
      <?php if(isset($financial_year) && $financial_year): ?>
        <input type="hidden" name="financial_year_id" value="<?= $financial_year->finiYear_id ?>">
    <?php endif; ?>
    
    <?php if(isset($institute_id) && $institute_id): ?>
        <input type="hidden" name="institute_id" value="<?= $institute_id ?>">
    <?php endif; ?>

<?php if(isset($Hostel_id) && $Hostel_id): ?>
    <input type="hidden" name="Hostel_id" value="<?= $Hostel_id ?>">
<?php endif; ?>

<?php if(isset($fkURL_id) && !empty($fkURL_id)): ?>
    <input type="hidden" name="fkURL_id" value="<?= $fkURL_id ?>">
<?php endif; ?>

      <!-- <?php if(isset($financial_year) && $financial_year): ?>
        <input type="hidden" name="financial_year_id" value="<?= $financial_year->finiYear_id ?>">
    <?php endif; ?>
    
    <?php if(isset($institute_id) && $institute_id): ?>
        <input type="hidden" name="institute_id" value="<?= $institute_id ?>">
    <?php endif; ?> -->

    <?php if (!empty($survey_structure)): ?>
        <?php $section_index = 0; ?>
        <?php foreach ($survey_structure as $heading): ?>
            
            <div id="section<?= $section_index ?>" class="section <?= $section_index == 0 ? 'active' : '' ?>">
                <div class="section-header">
                    <h2>
                        <span class="section-icon"><?= $this->Survey_model->get_heading_icon($heading['heading_text']) ?></span>
                        <?= htmlspecialchars($heading['heading_text']) ?>
                    </h2>
                </div>
                
                <?php if (!empty($heading['subheadings'])): ?>
                    <?php $question_num = 1; ?>
                    <?php foreach ($heading['subheadings'] as $subheading): ?>
                        
                        <div class="card">
                            <div class="question">
                                <?= $question_num ?>. <?= htmlspecialchars($subheading['subheading_text']) ?>
                            </div>
                            
                            <div class="options">
                                <?php if (!empty($options)): ?>
                                    <?php $first_option = true; ?>
                                    <?php foreach ($options as $option): ?>
                                        <label class="option-label">
                                            <input type="radio" 
                                                   name="q<?= $subheading['subheading_id'] ?>" 
                                                   value="<?= $option->option_id ?>" 
                                                   <?= $first_option ? 'checked' : '' ?>
                                                   required>
                                            <span class="option-text">
                                                <?= $this->Survey_model->get_option_emoji($option->option_text) ?> <?= htmlspecialchars($option->option_text) ?>
                                            </span>
                                        </label>
                                        <?php $first_option = false; ?>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <p>No options available</p>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <?php $question_num++; ?>
                    <?php endforeach; ?>
                <?php else: ?>
                    <p>No questions available for this section</p>
                <?php endif; ?>
            </div>
            
            <?php $section_index++; ?>
        <?php endforeach; ?>
    <?php else: ?>
        <p>No survey structure found</p>
    <?php endif; ?>
</form>

<div class="success-message" id="successMsg">
    <div class="success-icon">✓</div>
    <h2>Thank You!</h2>
    <p>Your feedback has been submitted successfully.<br>We appreciate your valuable input.</p>
</div>

</div>

<div class="nav-buttons">
    <button class="btn btn-prev disabled" id="prevBtn" onclick="prevSection()">Previous</button>
    <button class="btn btn-next" id="nextBtn" onclick="nextSection()">Next</button>
</div>

<!-- Before </body> -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
const totalSections = <?= count($survey_structure) ?>;
let currentSection = 0;

function validateStudentInfo() {
    const name = document.getElementById('studentName').value.trim();
    const prn = document.getElementById('prnNumber').value.trim();
    const branch = document.getElementById('branch').value;
    
    if (!name || !prn || !branch) {
        Swal.fire({
            position: 'center',
            icon: 'warning',
            title: '<strong>Incomplete Information</strong>',
            html: 'Please fill in all student information fields before proceeding.',
            showConfirmButton: true,
            confirmButtonText: 'OK',
            confirmButtonColor: '#667eea',
            customClass: {
                popup: 'custom-swal-popup',
                icon: 'custom-swal-icon',
                title: 'custom-swal-title',
                htmlContainer: 'custom-swal-text'
            }
        });
        return false;
    }
    
    // Store in hidden fields
    document.getElementById('hiddenStudentName').value = name;
    document.getElementById('hiddenPrnNumber').value = prn;
    document.getElementById('hiddenBranch').value = branch;
    
    return true;
}

function showSection(n) {
    const sections = document.querySelectorAll('.section');
    const dots = document.querySelectorAll('.dot');
    
    sections.forEach(section => section.classList.remove('active'));
    sections[n].classList.add('active');
    
    dots.forEach((dot, idx) => dot.classList.toggle('active', idx === n));
    
    currentSection = n;
    document.getElementById('currentSection').textContent = n + 1;
    document.getElementById('progressFill').style.width = ((n + 1) / totalSections * 100) + '%';
    
    document.getElementById('prevBtn').classList.toggle('disabled', n === 0);
    document.getElementById('nextBtn').textContent = n === totalSections - 1 ? 'Submit' : 'Next';
    
    window.scrollTo({ top: 0, behavior: 'smooth' });
}

function nextSection() {
    // Validate student info on first next click
    if (currentSection === 0 && !validateStudentInfo()) {
        return;
    }
    
    if (currentSection < totalSections - 1) {
        showSection(currentSection + 1);
    } else {
        // Submit the form
        submitSurvey();
    }
}

function prevSection() {
    if (currentSection > 0) {
        showSection(currentSection - 1);
    }
}

function submitSurvey() {
    // Validate all fields are filled
    if (!validateStudentInfo()) {
        showSection(0);
        return;
    }
    
    const formData = new FormData(document.getElementById('surveyForm'));
    
    // Show loading with SweetAlert
    Swal.fire({
        title: '<strong>Submitting...</strong>',
        html: 'Please wait while we submit your feedback.',
        allowOutsideClick: false,
        allowEscapeKey: false,
        showConfirmButton: false,
        customClass: {
            popup: 'custom-swal-popup',
            title: 'custom-swal-title',
            htmlContainer: 'custom-swal-text'
        },
        didOpen: () => {
            Swal.showLoading();
        }
    });
    
    // Also update button text
    document.getElementById('nextBtn').textContent = 'Submitting...';
    document.getElementById('nextBtn').disabled = true;
    
    fetch('<?= base_url('admin/survey/submit_survey') ?>', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.status === 'success') {
            // Show success message with SweetAlert
            Swal.fire({
                position: 'center',
                icon: 'success',
                title: '<strong>Thank You!</strong>',
                html: 'Your feedback has been submitted successfully.<br>We appreciate your valuable input.',
                showConfirmButton: false,
                timer: 3000,
                customClass: {
                    popup: 'custom-swal-popup',
                    icon: 'custom-swal-icon',
                    title: 'custom-swal-title',
                    htmlContainer: 'custom-swal-text'
                }
            }).then(() => {
                // Hide everything and show success message
                document.querySelector('.container').innerHTML = 
                    '<div class="success-message" style="display:block">' +
                    '<div class="success-icon">✓</div>' +
                    '<h2>Thank You!</h2>' +
                    '<p>Your feedback has been submitted successfully.<br>We appreciate your valuable input.</p>' +
                    '</div>';
                document.querySelector('.nav-buttons').style.display = 'none';
            });
        } else {
            // Show error message with SweetAlert
            Swal.fire({
                position: 'center',
                icon: 'error',
                title: '<strong>Submission Failed</strong>',
                html: data.message || 'Error submitting survey. Please try again.',
                showConfirmButton: true,
                confirmButtonText: 'OK',
                confirmButtonColor: '#667eea',
                customClass: {
                    popup: 'custom-swal-popup',
                    icon: 'custom-swal-icon',
                    title: 'custom-swal-title',
                    htmlContainer: 'custom-swal-text'
                }
            });
            document.getElementById('nextBtn').textContent = 'Submit';
            document.getElementById('nextBtn').disabled = false;
        }
    })
    .catch(error => {
        console.error('Error:', error);
        // Show network error message with SweetAlert
        Swal.fire({
            position: 'center',
            icon: 'error',
            title: '<strong>Network Error</strong>',
            html: 'An error occurred while submitting the survey. Please check your connection and try again.',
            showConfirmButton: true,
            confirmButtonText: 'OK',
            confirmButtonColor: '#667eea',
            customClass: {
                popup: 'custom-swal-popup',
                icon: 'custom-swal-icon',
                title: 'custom-swal-title',
                htmlContainer: 'custom-swal-text'
            }
        });
        document.getElementById('nextBtn').textContent = 'Submit';
        document.getElementById('nextBtn').disabled = false;
    });
}

// Initialize
showSection(0);
</script>

</body>
</html>