<style>
    .file-upload-cell {
        position: relative;
        width: 120px;
    }
    .file-input {
        position: absolute;
        opacity: 0;
        width: 100%;
        height: 100%;
        cursor: pointer;
    }
    .file-label {
        display: inline-block;
        background: #007bff;
        color: white;
        padding: 5px 10px;
        border-radius: 4px;
        cursor: pointer;
        font-size: 12px;
        text-align: center;
        width: 100px;
    }
    .file-label:hover {
        background: #0056b3;
    }
    .file-name {
        font-size: 10px;
        color: #666;
        margin-top: 2px;
        word-break: break-word;
    }
    .file-remove {
        color: red;
        cursor: pointer;
        font-size: 10px;
        margin-left: 5px;
    }
    .wide-th {
        width: 200px !important;  
    }
    .total-row {
        background-color: #f8f9fa;
        font-weight: bold;
        border-top: 2px solid #dee2e6;
    }
    .total-row td {
        padding: 12px 8px !important;
        font-size: 14px;
    }
    .total-amount {
        color: #28a745;
        font-size: 16px;
        font-weight: 600;
    }

    /* Select2 ko normal dropdown jaisa banao */
.select2-container .select2-selection--single {
    height: 38px !important;
    border: 1px solid #ced4da !important;
    border-radius: 4px !important;
}
 
.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 36px !important;
    padding-left: 12px !important;
    color: #495057 !important;
    padding: 2px;
}
 
.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 36px !important;
    right: 8px !important;
}
 
.select2-container--default .select2-selection--single .select2-selection__arrow b {
    border-color: #495057 transparent transparent transparent !important;
}
 
/* Dropdown menu styling */
.select2-dropdown {
       border: 1px solid #f89450 !important;
            border-radius: 4px !important;
            
    background-color: #edfff2 !important;
}
 
.select2-container--default .select2-results__option--highlighted[aria-selected] {
    background-color: #007bff !important;
    color: white !important;
}
 
.select2-search--dropdown .select2-search__field {
    border: 1px solid #ced4da !important;
    border-radius: 4px !important;
    padding: 6px 12px !important;
}
 
/* Focus state */
.select2-container--default.select2-container--focus .select2-selection--single {
    border-color: #80bdff !important;
    outline: 0 !important;
    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25) !important;
}

/* Select2 container width */
.select2-container {
    width: 100% !important;
}
 .content-wrapper {
   
    overflow-x: hidden !important;
   
}

</style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<!-- Select2 CSS -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<div class="content-wrapper-scroll">
    <div class="content-wrapper">
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1">Under-Graduate Fellowship</div>
                    </div>
                    <div class="card-body">
                        <form role="form" id="Form" action="" method="post" enctype="multipart/form-data">
                            <div class="row gutters">
                                <input type="hidden" id="UG_id" name="UG_id" class="hiddenId" value="<?php echo isset($record->UG_id) ? $record->UG_id : ''; ?>">

<!-- hidden submenuid -->
<input class="form-control" id="fk_submenuId" name="fk_submenuId" type="hidden"
                           value="<?= isset($subId) ? $subId : '' ?>"  />


                                <?php if(!isset($record) || empty($record->UG_id)): ?>
                                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <label for="excel_file" class="form-label">Import Excel</label>
                                    <div class="card" id="studentCard"
                                         style="height: 120px; width: 60%; cursor: pointer; padding: 10px;
                                                border: 2px dashed black; text-align: center; display: flex;
                                                flex-direction: column; justify-content: flex-start; align-items: center;
                                                position: relative; overflow: hidden;"
                                         onclick="document.getElementById('excel_file').click();">
                                        <img src="<?= base_url('Assets/img/excel.png'); ?>" id="studentImg"
                                             style="max-height: 50px; object-fit: contain; margin-bottom: 5px;">
                                        <span id="studentFileText" style="font-size: 11px; color: black; font-weight:600;">
                                            (<span class="text-danger">*</span>File extension allowed: .xls .xlsx)
                                        </span>
                                        <input type="file" accept=".xls,.xlsx" style="display: none;"
                                               class="form-control form-control-sm"
                                               id="excel_file" name="excel_file">
                                    </div>
                                    <button class="btn btn-success btn-sm m-1" type="button" id="btnShow" style="padding: 5px 10px;font-size: 13px;">
                                        <i class="fas fa-search"></i> Show Excel Data
                                    </button>
                                </div>

                                <div class="row">
                                    <div class="col-md-12 text-end mt-3">
                                        <a href="<?= base_url('uploads/formatexcel/UGFellowship.xlsx'); ?>"
                                           download
                                           style="color: #0b0a0aff; text-decoration: underline; font-weight: 600; font-size:14px;">
                                            <i class="fas fa-file-excel" style="color: green; margin-right: 6px; font-size:16px;"></i>
                                            Download Excel Format
                                        </a>
                                    </div>
                                </div>
                                <?php endif; ?>

                                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-3 col-12">
                                    <div class="table-responsive mt-3" id="printableTable">
                                        <?php if(!isset($record) || empty($record->UG_id)): ?>
                                        <div class="float-end mb-2">
                                            <button class="btn btn-danger btn-sm m-1" type="button" id="btnClearAll">
                                                <i class="fas fa-times"></i> Clear All
                                            </button>
                                        </div>
                                        <?php endif; ?>

                                        <table id="leavetable" class="table custom-table">
                                            <thead style="background-color: #1273eb;">
                                                <tr>
                                                    <th class="w-auto">Sr.No.</th>
                                                    <th style="min-width:260px;">PRN</th>
                                                    <th style="min-width:260px;">Student Name</th>
                                                    <th style="min-width:260px;">Branch/Department</th> 
                                                    <th style="min-width:170px;">Class</th>
                                                    <th style="min-width:170px;">Division</th>
                                                    <th style="min-width:260px;">Project Name</th>
                                                    <th style="min-width:200px;">Contact</th>
                                                    <th style="min-width:260px;">University Name</th>
                                                    <th style="min-width:300px;">Photo URl</th>
                                                    <th style="min-width:260px;">Guide Name</th>
                                                    <th style="min-width:150px;">Year</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tableBody">
                                                <?php if(isset($record)): ?>
                                                <tr>
                                                    <td>1</td>
                                                    <td>
                                                        <input type="text" name="prn[]" class="form-control" value="<?= $record->prn ?>">
                                                    </td>
                                                    <td>
                                                        <select name="fkStudent_id[]" class="form-control student-select">
                                                            <option value="">Select Student Name</option>
                                                            <?php foreach($studentdata as $student): ?>
                                                                <option value="<?= $student->Student_id ?>" 
                                                                    <?= ($student->Student_id == $record->fkStudent_id) ? 'selected' : '' ?>>
                                                                    <?= $student->FullName ?>
                                                                </option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                    <td>
                                                        <select name="fkbranch_id[]" class="form-control student-select">
                                                            <option value="">Select Branch Name</option>
                                                            <?php foreach($branchdata as $branch): ?>
                                                               <option value="<?= $branch->branch_id ?>"
                                                                    <?= ($branch->branch_id == $record->fkbranch_id) ? 'selected' : '' ?>>
                                                                    <?= $branch->branch_name ?>
                                                                </option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                    <td>
                                                        <select name="fkclass_id[]" class="form-control class-select">
                                                            <option value="">Select Class</option>
                                                            <?php foreach($classdata as $class): ?>
                                                                <option value="<?= $class->class_id ?>" 
                                                                    <?= ($class->class_id == $record->fkclass_id) ? 'selected' : '' ?>>
                                                                    <?= $class->classname ?>
                                                                </option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                    <td>
                                                        <input type="text" name="Division[]" class="form-control" value="<?= $record->Division ?>">
                                                    </td>
                                                    <td>
                                                        <input type="text" name="project_name[]" class="form-control" value="<?= $record->project_name ?>">
                                                    </td>
                                                    <td>
                                                        <input type="number" name="Contact[]" class="form-control" value="<?= $record->Contact ?>">
                                                    </td>
                                                    <td>
                                                        <select name="institute[]" class="form-control institute-select">
                                                            <option value="">Select University Name</option>
                                                            <?php foreach($institutedata as $institu): ?>
                                                                <option value="<?= $institu->Institu_id ?>" 
                                                                    <?= ($institu->Institu_id == $record->institute) ? 'selected' : '' ?>>
                                                                    <?= $institu->Institu_name ?>
                                                                </option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                    <td>
                                                        <input type="text" name="Photo_Url[]" class="form-control" value="<?= $record->Photo_Url ?>">
                                                    </td>
                                                    <td>
                                                        <input type="text" name="gurd_name[]" class="form-control" value="<?= $record->gurd_name ?>">
                                                    </td>
                                                    <td>
                                                        <select name="finicial_Year[]" class="form-control year-select">
                                                            <option value="">Select Year</option>
                                                            <?php foreach($yeardata as $year): ?>
                                                                <option value="<?= $year->finiYear_id ?>" 
                                                                    <?= ($year->finiYear_id == $record->finicial_Year) ? 'selected' : '' ?>>
                                                                    <?= $year->fini_Label ?>
                                                                </option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                    <td>
                                                        <button type="button" class="btn text-danger btn-sm removeRow">
                                                            <i class="fa-solid fa-trash"></i>
                                                        </button>
                                                    </td>
                                                </tr>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                        <?php if(!isset($record) || empty($record->UG_id)): ?>
                                        <div class="float-end">
                                            <button type="button" class="btn btn-success btn-sm p-2 rounded-3" id="addRowBtn" style="font-size:13px; font-weight:600;">
                                                <i class="fa-solid fa-plus bg-white p-1 rounded-circle text-success shadow-lg me-2"></i>Add Row
                                            </button>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 mt-3">
                                    <button type="button" class="btn mb-md-0 mb-2 btn-quarternary" id="submit">
                                        <i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save
                                    </button>
                                    <a class="btn mb-md-0 mb-2 btn-quarternary1" href="<?=base_url()?>admin/UGfellow/index">
                                        <i class="fa-solid fa-list"></i>&nbsp;&nbsp;List
                                    </a>
                                    <button class="btn mb-md-0 mb-2 btn-quarternaryhome" type="button" onclick="window.location.href='<?= base_url() ?>admin/UGfellow/Dashboard'">
                                        <i class="fa-solid fa-home"></i>&nbsp;&nbsp;Home
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Hidden data for JavaScript -->
<script type="text/javascript">
var studentOptions = <?= json_encode($studentdata ?? []) ?>;
var branchOptions = <?= json_encode($branchdata ?? []) ?>;
var classOptions = <?= json_encode($classdata ?? []) ?>;
var instituteOptions = <?= json_encode($institutedata ?? []) ?>;
var yearOptions = <?= json_encode($yeardata ?? []) ?>;
var isUpdateMode = <?= isset($record->UG_id) && !empty($record->UG_id) ? 'true' : 'false' ?>;
</script>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<!-- Select2 JS -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
$(document).ready(function() {
    // Focus search field when Select2 opens
    $(document).on('select2:open', () => {
        setTimeout(() => {
            document.querySelector('.select2-search__field').focus();
        }, 0);
    });
});
</script>

<script>
$(document).ready(function () {
    let rowCount = 0;

    // Show one empty row on page load only in insert mode
    if (!isUpdateMode && $("#tableBody tr").length === 0) {
        addRow();
    }

    // Initialize Select2 for existing dropdowns
    function initializeSelect2() {
        $('.student-select, .branch-select, .class-select, .institute-select, .year-select').select2({
            placeholder: "Select an option",
            allowClear: false,
            width: '100%'
        });
    }

    // Initialize on page load
    initializeSelect2();

    // Generate dropdown functions with Select2
    function getStudentDropdown(selectedId = "", selectedName = "") {
        let options = '<option value="">Select Student Name</option>';
        
        if (typeof studentOptions !== 'undefined' && studentOptions.length > 0) {
            studentOptions.forEach(function(student) {
                let selected = (student.Student_id == selectedId) ? 'selected' : '';
                options += `<option value="${student.Student_id}" ${selected}>${student.FullName}</option>`;
            });
        }
        if (selectedName && !selectedId) {
            options += `<option value="NEW::${selectedName}" selected>${selectedName} (New)</option>`;
        }
        
        return `<select name="fkStudent_id[]" class="form-control student-select">${options}</select>`;
    }

    function getBranchDropdown(selectedId = "", selectedName = "") {
        let options = '<option value="">Select Branch</option>';
        
        if (typeof branchOptions !== 'undefined' && branchOptions.length > 0) {
            branchOptions.forEach(function(branch) {
                let selected = (branch.branch_id == selectedId) ? 'selected' : '';
                options += `<option value="${branch.branch_id}" ${selected}>${branch.branch_name}</option>`;
            });
        }
        if (selectedName && !selectedId) {
            options += `<option value="NEW::${selectedName}" selected>${selectedName} (New)</option>`;
        }
        
        return `<select name="fkbranch_id[]" class="form-control branch-select">${options}</select>`;
    }

    function getClassDropdown(selectedId = "", selectedName = "") {
        let options = '<option value="">Select Class Name</option>';
        
        if (typeof classOptions !== 'undefined' && classOptions.length > 0) {
            classOptions.forEach(function(cls) {
                let selected = (cls.class_id == selectedId) ? 'selected' : '';
                options += `<option value="${cls.class_id}" ${selected}>${cls.classname}</option>`;
            });
        }
        if (selectedName && !selectedId) {
            options += `<option value="NEW::${selectedName}" selected>${selectedName} (New)</option>`;
        }
        
        return `<select name="fkclass_id[]" class="form-control class-select">${options}</select>`;
    }

    function getInstituteDropdown(selectedId = "", selectedName = "") {
        let options = '<option value="">Select University Name</option>';
        
        if (typeof instituteOptions !== 'undefined' && instituteOptions.length > 0) {
            instituteOptions.forEach(function(institu) {
                let selected = (institu.Institu_id == selectedId) ? 'selected' : '';
                options += `<option value="${institu.Institu_id}" ${selected}>${institu.Institu_name}</option>`;
            });
        }
        if (selectedName && !selectedId) {
            options += `<option value="NEW::${selectedName}" selected>${selectedName} (New)</option>`;
        }
        
        return `<select name="institute[]" class="form-control institute-select">${options}</select>`;
    }

    function getYearDropdown(selectedId = "", selectedName = "") {
        let options = '<option value="">Select Year</option>';
        
        if (typeof yearOptions !== 'undefined' && yearOptions.length > 0) {
            yearOptions.forEach(function(year) {
                let selected = (year.finiYear_id == selectedId) ? 'selected' : '';
                options += `<option value="${year.finiYear_id}" ${selected}>${year.fini_Label}</option>`;
            });
        }
        if (selectedName && !selectedId) {
            options += `<option value="NEW::${selectedName}" selected>${selectedName} (New)</option>`;
        }
        
        return `<select name="finicial_Year[]" class="form-control year-select">${options}</select>`;
    }

    // Add Row Function
    function addRow(
        prn = "",
        Student_id = "",
        student_name = "",
        fkbranch_id = "",      
        branch_name = "",  
        class_id = "",
        classname = "",
        Division = "",
        project_name = "",
        Contact = "",
        Institu_id = "",
        institute_name = "",
        Photo_Url = "",
        gurd_name = "",
        finicial_Year = "",
        year_name = ""
    ) {
        rowCount++;
        
        let newRow = `
            <tr>
                <td>${rowCount}</td>
                <td><input type="text" name="prn[]" class="form-control" value="${prn}"></td>
                <td>${getStudentDropdown(Student_id, student_name)}</td>
                <td>${getBranchDropdown(fkbranch_id, branch_name)}</td>
                <td>${getClassDropdown(class_id, classname)}</td>
                <td><input type="text" name="Division[]" class="form-control" value="${Division}"></td>
                <td><input type="text" name="project_name[]" class="form-control" value="${project_name}"></td>
                <td><input type="text" name="Contact[]" class="form-control" value="${Contact}"></td>
                <td>${getInstituteDropdown(Institu_id, institute_name)}</td>
                <td><input type="text" name="Photo_Url[]" class="form-control" value="${Photo_Url}"></td>
                <td><input type="text" name="gurd_name[]" class="form-control" value="${gurd_name}"></td>
                <td>${getYearDropdown(finicial_Year, year_name)}</td>
                <td><button type="button" class="btn text-danger btn-sm removeRow"><i class="fa-solid fa-trash"></i></button></td>
            </tr>`;
        $("#tableBody").append(newRow);
        
        // Initialize Select2 for newly added dropdowns
        initializeSelect2();
    }

    // Manual Add Row - Only in insert mode
    $("#addRowBtn").click(function () {
        if (!isUpdateMode) {
            addRow();
        }
    });

    // Remove Row
    $(document).on("click", ".removeRow", function () {
        if ($("#tableBody tr").length <= 1) {
            Swal.fire("Warning", "At least one row is required!", "warning");
            return;
        }
        $(this).closest("tr").remove();
        updateSerialNumbers();
    });

    // Update serial numbers
    function updateSerialNumbers() {
        rowCount = 0;
        $("#tableBody tr").each(function () {
            rowCount++;
            $(this).find("td:first").text(rowCount);
        });
    }

    // Clear All Rows - Only in insert mode
    $("#btnClearAll").click(function () {
        if (!isUpdateMode) {
            Swal.fire({
                title: 'Are you sure?',
                text: 'This will clear all table data!',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, clear all!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $("#tableBody").empty();
                    rowCount = 0;
                    addRow();
                    Swal.fire('Cleared!', 'All table data has been cleared.', 'success');
                }
            });
        }
    });

    // Helper functions
    function findStudentByName(studentName) {
        if (!studentName || typeof studentOptions === 'undefined') return { id: '', name: studentName };
        let name = studentName.toString().trim().toLowerCase();
        for (let i = 0; i < studentOptions.length; i++) {
            if (studentOptions[i].FullName.toLowerCase() === name) {
                return { id: studentOptions[i].Student_id, name: studentOptions[i].FullName };
            }
        }
        return { id: '', name: studentName.toString().trim() };
    }

    function findBranchByName(branchName) {
        if (!branchName || typeof branchOptions === 'undefined') return { id: '', name: branchName };
        let name = branchName.toString().trim().toLowerCase();
        for (let i = 0; i < branchOptions.length; i++) {
            if (branchOptions[i].branch_name.toLowerCase() === name) {
                return { id: branchOptions[i].branch_id, name: branchOptions[i].branch_name };
            }
        }
        return { id: '', name: branchName.toString().trim() };
    }

    function findClassByName(className) {
        if (!className) return { id: '', name: className };
        if (typeof classOptions === 'undefined' || classOptions.length === 0) {
            return { id: '', name: className.toString().trim() };
        }
        let name = className.toString().trim().toLowerCase();
        for (let i = 0; i < classOptions.length; i++) {
            if (classOptions[i].classname.toLowerCase() === name) {
                return { id: classOptions[i].class_id, name: classOptions[i].classname };
            }
        }
        return { id: '', name: className.toString().trim() };
    }

    function findInstituteByName(instituteName) {
        if (!instituteName || typeof instituteOptions === 'undefined') return { id: '', name: instituteName };
        let name = instituteName.toString().trim().toLowerCase();
        for (let i = 0; i < instituteOptions.length; i++) {
            if (instituteOptions[i].Institu_name.toLowerCase() === name) {
                return { id: instituteOptions[i].Institu_id, name: instituteOptions[i].Institu_name };
            }
        }
        return { id: '', name: instituteName.toString().trim() };
    }

    function findYearByName(yearName) {
        if (!yearName || typeof yearOptions === 'undefined') return { id: '', name: yearName };
        let name = yearName.toString().trim().toLowerCase();
        for (let i = 0; i < yearOptions.length; i++) {
            if (yearOptions[i].fini_Label.toLowerCase() === name) {
                return { id: yearOptions[i].finiYear_id, name: yearOptions[i].fini_Label };
            }
        }
        return { id: '', name: yearName.toString().trim() };
    }

    // Show Excel Data - Only in insert mode
    $("#btnShow").click(function () {
        if (isUpdateMode) return; // Prevent execution in update mode
        
        if (typeof XLSX === 'undefined') {
            Swal.fire("Error", "Excel processing library not loaded. Please refresh the page.", "error");
            return;
        }

        let file = $("#excel_file")[0].files[0];
        if (!file) {
            Swal.fire("Error", "Please select an Excel file first!", "error");
            return;
        }

        if (!file.name.toLowerCase().match(/\.(xlsx|xls)$/)) {
            Swal.fire("Error", "Please select a valid Excel file (.xlsx or .xls)", "error");
            return;
        }

        let reader = new FileReader();
        reader.onload = function (e) {
            try {
                let data = e.target.result;
                let workbook = XLSX.read(data, { 
                    type: "binary",
                    cellText: false,
                    cellDates: true,
                    dateNF: 'dd/mm/yyyy'
                });
                
                let firstSheet = workbook.Sheets[workbook.SheetNames[0]];
                let jsonData = XLSX.utils.sheet_to_json(firstSheet, { 
                    header: 1,
                    defval: "",
                    blankrows: false,
                    raw: false
                });

                if (jsonData.length < 2) {
                    Swal.fire("Error", "Excel file must contain header row and at least one data row!", "error");
                    return;
                }

                $("#tableBody").empty();
                rowCount = 0;

                let rowsData = [];

                for (let i = 1; i < jsonData.length; i++) {
                    let row = jsonData[i];
                    
                    if (!row || row.length < 1 || !row[0]) {
                        continue;
                    }
                    
                    let prn = (row[0] || "").toString().trim();
                    let student_name = (row[1] || "").toString().trim();
                    let branch_name = (row[2] || "").toString().trim();
                    let classname = (row[3] || "").toString().trim();
                    let Division = (row[4] || "").toString().trim();
                    let project_name = (row[5] || "").toString().trim();
                    let Contact = (row[6] || "").toString().trim();
                    let institute_name = (row[7] || "").toString().trim();
                    let Photo_Url = (row[8] || "").toString().trim();
                    let gurd_name = (row[9] || "").toString().trim();
                    let year_name = (row[10] || "").toString().trim();

                    let student = findStudentByName(student_name);
                    let branch = findBranchByName(branch_name);
                    let cls = findClassByName(classname);
                    let institu = findInstituteByName(institute_name);
                    let year = findYearByName(year_name);

                    rowsData.push({
                        prn: prn,
                        Student_id: student.id,
                        student_name: student.name,
                        branch_id: branch.id,
                        branch_name: branch.name,
                        class_id: cls.id,
                        classname: cls.name,
                        Division: Division,
                        project_name: project_name,
                        Contact: Contact,
                        Institu_id: institu.id,
                        institute_name: institu.name,
                        Photo_Url: Photo_Url,
                        gurd_name: gurd_name,
                        finicial_Year: year.id,
                        year_name: year.name
                    });
                }

                if (rowsData.length === 0) {
                    Swal.fire("Warning", "No valid records found in the Excel file!", "warning");
                    addRow();
                    return;
                }

                rowsData.forEach((rowData) => {
                    addRow(
                        rowData.prn,
                        rowData.Student_id,
                        rowData.student_name,
                        rowData.branch_id,
                        rowData.branch_name,
                        rowData.class_id,
                        rowData.classname,
                        rowData.Division,
                        rowData.project_name,
                        rowData.Contact,
                        rowData.Institu_id,
                        rowData.institute_name,
                        rowData.Photo_Url,
                        rowData.gurd_name,
                        rowData.finicial_Year,
                        rowData.year_name
                    );
                });

            } catch (error) {
                console.error("Excel processing error:", error);
                Swal.fire("Error", "Failed to process Excel file: " + error.message, "error");
            }
        };
        
        reader.onerror = function(error) {
            console.error("File reading error:", error);
            Swal.fire("Error", "Failed to read Excel file!", "error");
        };
        
        reader.readAsBinaryString(file);
    });

    // Save Form Data
    $("#submit").click(function(e) {
        e.preventDefault();

        if ($("#tableBody tr").length === 0) {
            Swal.fire('Validation Error', 'Please add at least one record!', 'error');
            return;
        }

        let newStudents = [];
        let newBranches = [];
        let newClasses = [];
        let newInstitutes = [];
        let newYears = [];

        $('select[name="fkStudent_id[]"]').each(function() {
            let val = $(this).val();
            if (val && val.startsWith('NEW::')) {
                let newName = val.replace('NEW::', '');
                if (newName && newStudents.indexOf(newName) === -1) {
                    newStudents.push(newName);
                }
            }
        });

        $('select[name="fkbranch_id[]"]').each(function() {
            let val = $(this).val();
            if (val && val.startsWith('NEW::')) {
                let newName = val.replace('NEW::', '');
                if (newName && newBranches.indexOf(newName) === -1) {
                    newBranches.push(newName);
                }
            }
        });

        $('select[name="fkclass_id[]"]').each(function() {
            let val = $(this).val();
            if (val && val.startsWith('NEW::')) {
                let newName = val.replace('NEW::', '');
                if (newName && newClasses.indexOf(newName) === -1) {
                    newClasses.push(newName);
                }
            }
        });

        $('select[name="institute[]"]').each(function() {
            let val = $(this).val();
            if (val && val.startsWith('NEW::')) {
                let newName = val.replace('NEW::', '');
                if (newName && newInstitutes.indexOf(newName) === -1) {
                    newInstitutes.push(newName);
                }
            }
        });

        $('select[name="finicial_Year[]"]').each(function() {
            let val = $(this).val();
            if (val && val.startsWith('NEW::')) {
                let newName = val.replace('NEW::', '');
                if (newName && newYears.indexOf(newName) === -1) {
                    newYears.push(newName);
                }
            }
        });

        // Prepare form data
        let formData = new FormData($('#Form')[0]);
        
        formData.append('new_students', JSON.stringify(newStudents));
        formData.append('new_branches', JSON.stringify(newBranches));
        formData.append('new_classes', JSON.stringify(newClasses));
        formData.append('new_institutes', JSON.stringify(newInstitutes));
        formData.append('new_years', JSON.stringify(newYears));

        let UG_id = $('#UG_id').val();
        let isUpdateMode = (UG_id && UG_id.trim() !== '');
        
        let ajaxUrl = isUpdateMode 
            ? '<?= base_url() ?>admin/UGfellow/updateUGfellow' 
            : '<?= base_url() ?>admin/UGfellow/insertUGfellow';

        $.ajax({
            url: ajaxUrl,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function() {
                $("#submit").prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');
            },
            success: function(response) {
                try {
                    let result = typeof response === 'string' ? JSON.parse(response) : response;
                    
                    if (result.status === 'success') {
                        Swal.fire({
                            position: 'center',
                            icon: 'success',
                            title: '<strong>Success!</strong>',
                            html: 'Data Submitted Successfully',
                            showConfirmButton: false,
                            timer: 2000,
                            customClass: {
                                popup: 'custom-swal-popup',
                                icon: 'custom-swal-icon',
                                title: 'custom-swal-title',
                                htmlContainer: 'custom-swal-text'
                            }
                        }).then(() => { 
                            window.location.href = '<?= base_url() ?>admin/UGfellow/index';
                        });
                    } else {
                        Swal.fire('Error!', result.message || 'Failed to save data!', 'error');
                    }
                } catch (e) {
                    console.error("JSON parse error:", e);
                    Swal.fire('Error!', 'Server returned invalid response.', 'error');
                }
            },
            error: function(xhr, status, error) {
                console.error("AJAX Error:", error);
                Swal.fire('Error!', 'Something went wrong!', 'error');
            },
            complete: function() {
                $("#submit").prop('disabled', false).html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
            }
        });
    });
});
</script>