<style>
    .wysiwyg-container {
        margin: 20px 0;
    }
    .editor-label {
        font-weight: 600;
        margin-bottom: 10px;
        color: #333;
    }
</style>

<div class="content-wrapper-scroll">
    <!-- Content wrapper start -->
    <div class="content-wrapper">
        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <!-- Card start -->
                <div class="card">
                    <div class="card-header d-flex justify-content-center">
                        <div class="ribbon1"> Vision & Mission Form </div>
                    </div>
                    <div class="card-body">
                        <form role="form" id="Form" action="" method="post">
                            <!-- Row start -->
                            <div class="row gutters">
                                <input type="hidden" id="Vision_id" name="Vision_id" class="hiddenId" 
                                       value="<?php if(!empty($data)) echo $data[0]->Vision_id; ?>">

                                <!-- hidden submenuid -->
                                <input class="form-control" id="fk_submenuId" name="fk_submenuId" type="hidden"
                                       value="<?= isset($subId) ? $subId : '' ?>" />

                                <!-- Branch Selection -->
                                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <div class="field-wrapper">
                                        <select name="fkbranch_id" id="fkbranch_id" class="select-single js-states form-control" required>
                                            <option value="">Select branch</option>
                                            <?php foreach($branchdata as $branch): ?>
                                                <option value="<?= $branch->branch_id ?>" 
                                                    <?= (!empty($data[0]->fkbranch_id) && $branch->branch_id == $data[0]->fkbranch_id) ? 'selected' : '' ?>>
                                                    <?= $branch->branch_name ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Department <span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <!-- Academic Year Selection -->
                                <div class="col-md-2">
                                    <div class="field-wrapper">
                                        <select name="finicial_Year" id="finicial_Year" class="select-single js-states form-control" required>
                                            <?php
                                            $savedYear = '';
                                            if (!empty($data) && isset($data[0]->finicial_Year)) {
                                                $savedYear = $data[0]->finicial_Year;
                                            } elseif (!empty($activeYear)) {
                                                $savedYear = $activeYear->finiYear_id;
                                            }
                                            ?>
                                            <option value="">Select year</option>
                                            <?php foreach($yeardata as $year): ?>
                                                <option value="<?= $year->finiYear_id ?>"
                                                    <?= ($year->finiYear_id == $savedYear) ? 'selected' : '' ?>>
                                                    <?= $year->fini_Label ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="field-placeholder">Academic Year <span class="text-danger">*</span></div>
                                    </div>
                                </div>

                                <!-- Vision Editor -->
                                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                    <div class="field-wrapper wysiwyg-container">
                                        <label class="editor-label">Vision <span class="text-danger">*</span></label>
                                        <textarea id="Vision" name="Vision" class="form-control wysiwyg-editor" rows="5" required></textarea>
                                        <!-- Store RAW content without any encoding/escaping -->
                                        <script type="text/plain" id="vision-content-holder">
<?php 
if(!empty($data)) {
    // Output raw HTML without any htmlspecialchars or escaping
    // This preserves base64 image data in src attributes
    echo $data[0]->Vision;
}
?>
</script>
                                    </div>
                                </div>

                                <!-- Mission Editor -->
                                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                    <div class="field-wrapper wysiwyg-container">
                                        <label class="editor-label">Mission <span class="text-danger">*</span></label>
                                        <textarea id="Mission" name="Mission" class="form-control wysiwyg-editor" rows="5" required></textarea>
                                        <!-- Store RAW content without any encoding/escaping -->
                                        <script type="text/plain" id="mission-content-holder">
<?php 
if(!empty($data)) {
    // Output raw HTML without any htmlspecialchars or escaping
    echo $data[0]->Mission;
}
?>
</script>
                                    </div>
                                </div>

                                <!-- Action Buttons -->
                                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 mt-3">
                                    <button type="button" class="btn mb-md-0 mb-2 btn-quarternary" id="submit" name="submit">
                                        <i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save
                                    </button>
                                    <a class="btn mb-md-0 mb-2 btn-quarternary1" href="<?=base_url()?>admin/Vision/index" type="button">
                                        <i class="fa-solid fa-list"></i>&nbsp;&nbsp;List
                                    </a>
                                    <button class="btn mb-md-0 mb-2 btn-quarternaryhome" type="button" 
                                            onclick="window.location.href='<?= base_url() ?>admin/Vision/Dashboard'">
                                        <i class="fa-solid fa-home"></i>&nbsp;&nbsp;Home
                                    </button>
                                </div>
                            </div>
                            <!-- Row end -->
                        </form>
                    </div>
                </div>
                <!-- Card end -->
            </div>
        </div>
        <!-- Row end -->
    </div>
    <!-- Content wrapper end -->
</div>

<!-- Include Required Libraries -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css">
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
$(document).ready(function() {
    console.log('=== Summernote Initialization Started ===');
    
    // Initialize Summernote WYSIWYG Editor
    $('#Vision, #Mission').summernote({
        height: 300,
        toolbar: [
            ['style', ['style']],
            ['font', ['bold', 'italic', 'underline', 'clear']],
            ['fontname', ['fontname']],
            ['fontsize', ['fontsize']],
            ['color', ['color']],
            ['para', ['ul', 'ol', 'paragraph']],
            ['table', ['table']],
            ['insert', ['link', 'picture', 'video']],
            ['view', ['fullscreen', 'codeview', 'help']]
        ],
        placeholder: 'Enter content here...',
        callbacks: {
            onChange: function(contents, $editable) {
                $(this).removeClass('custom-invalid');
            },
            onInit: function() {
                console.log('Summernote initialized successfully');
            }
        }
    });

    // ============================================================================
    // CRITICAL: Load content AFTER Summernote is initialized
    // Using <script type="text/plain"> preserves base64 data without corruption
    // ============================================================================
    setTimeout(function() {
        console.log('=== Loading Existing Content ===');
        
        // Get content from script tags (preserves base64 data)
        var visionContent = $('#vision-content-holder').text().trim();
        var missionContent = $('#mission-content-holder').text().trim();
        
        // Debug information
        console.log('Vision Content Length:', visionContent.length);
        console.log('Mission Content Length:', missionContent.length);
        
        // Check if content has images
        if (visionContent.indexOf('<img') > -1) {
            console.log('✓ Vision contains images');
            
            // Check if images have src attribute
            if (visionContent.indexOf('src="data:image') > -1) {
                console.log('✓ Vision images have base64 src');
            } else if (visionContent.indexOf('data-filename') > -1 && visionContent.indexOf('src=') === -1) {
                console.error('✗ WARNING: Vision images missing src attribute! Data was truncated.');
                console.log('First 500 chars:', visionContent.substring(0, 500));
            }
        }
        
        if (missionContent.indexOf('<img') > -1) {
            console.log('✓ Mission contains images');
            
            if (missionContent.indexOf('src="data:image') > -1) {
                console.log('✓ Mission images have base64 src');
            } else if (missionContent.indexOf('data-filename') > -1 && missionContent.indexOf('src=') === -1) {
                console.error('✗ WARNING: Mission images missing src attribute! Data was truncated.');
                console.log('First 500 chars:', missionContent.substring(0, 500));
            }
        }
        
        // Load content into Summernote
        if (visionContent && visionContent !== '') {
            $('#Vision').summernote('code', visionContent);
            console.log('✓ Vision content loaded into editor');
        }
        
        if (missionContent && missionContent !== '') {
            $('#Mission').summernote('code', missionContent);
            console.log('✓ Mission content loaded into editor');
        }
        
        console.log('=== Content Loading Complete ===');
    }, 200); // Increased timeout to ensure full initialization

    // Form Validation and Submit
    $('#submit').click(function(e) {
        e.preventDefault();
        
        var isValid = true;
        
        // Validate required fields
        $('#Form').find('input[required], select[required]').each(function() {
            if (!$(this).val().trim()) {
                $(this).addClass('custom-invalid');
                isValid = false;
            } else {
                $(this).removeClass('custom-invalid');
            }
        });
        
        // Validate Vision
        var visionContent = $('#Vision').summernote('code');
        var visionText = $('<div>').html(visionContent).text().trim();
        if (!visionText || visionText === '') {
            $('#Vision').next('.note-editor').addClass('custom-invalid');
            isValid = false;
        } else {
            $('#Vision').next('.note-editor').removeClass('custom-invalid');
        }
        
        // Validate Mission
        var missionContent = $('#Mission').summernote('code');
        var missionText = $('<div>').html(missionContent).text().trim();
        if (!missionText || missionText === '') {
            $('#Mission').next('.note-editor').addClass('custom-invalid');
            isValid = false;
        } else {
            $('#Mission').next('.note-editor').removeClass('custom-invalid');
        }
        
        if (isValid) {
            saveperform();
        } else {
            Swal.fire({
                icon: 'warning',
                title: 'Validation Error',
                text: 'Please fill all required fields'
            });
        }
    });
    
    // Remove validation error on input change
    $('#Form').on('input change', 'input, select', function() {
        if ($(this).val().trim() !== '') {
            $(this).removeClass('custom-invalid');
        }
    });
});

function saveperform() {
    console.log('=== Saving Data ===');
    
    var Id = $('#Vision_id').val();
    var fkbranch_id = $('#fkbranch_id').val();
    var finicial_Year = $('#finicial_Year').val();
    var Vision = $('#Vision').summernote('code');
    var Mission = $('#Mission').summernote('code');
    var fk_submenuId = $('#fk_submenuId').val();
    
    // Debug: Log data sizes
    console.log('Vision size:', Vision.length, 'bytes');
    console.log('Mission size:', Mission.length, 'bytes');
    
    // Check if content has images
    if (Vision.indexOf('<img') > -1) {
        console.log('Vision contains images');
    }
    if (Mission.indexOf('<img') > -1) {
        console.log('Mission contains images');
    }
    
    var formData = new FormData();
    formData.append('Vision_id', Id);
    formData.append('fkbranch_id', fkbranch_id);
    formData.append('finicial_Year', finicial_Year);
    formData.append('Vision', Vision);
    formData.append('Mission', Mission);
    formData.append('fk_submenuId', fk_submenuId);
    
    var url = base_path + (Id > 0 ? "admin/Vision/updateVision" : "admin/Vision/insertVision");
    var successMessage = Id > 0 ? "Data Updated Successfully" : "Data Submitted Successfully";
    
    $.ajax({
        url: url,
        type: "POST",
        data: formData,
        processData: false,
        contentType: false,
        beforeSend: function() {
            $('#submit').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Loading...');
        },
        success: function(response) {
            console.log('Save response:', response);
            
            $('#submit').prop('disabled', false).html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
            
            // Parse response
            var data = typeof response === 'string' ? JSON.parse(response) : response;
            
            if (data.status === 'success') {
                console.log('✓ Data saved successfully');
                if (data.data) {
                    console.log('Vision saved length:', data.data.vision_length);
                    console.log('Mission saved length:', data.data.mission_length);
                }
            }
            
            Swal.fire({
                position: 'center',
                icon: 'success',
                title: '<strong>Success!</strong>',
                html: successMessage,
                showConfirmButton: false,
                timer: 2000
            }).then(() => {
                window.location.href = base_path + 'admin/Vision/index';
            });
        },
        error: function(xhr, status, error) {
            console.error('Save error:', error);
            console.error('Response:', xhr.responseText);
            
            $('#submit').prop('disabled', false).html('<i class="fa-solid fa-floppy-disk"></i>&nbsp;&nbsp;Save');
            
            Swal.fire({
                icon: 'error',
                title: 'Error!',
                text: 'Failed to save data. Please try again.'
            });
        }
    });
}
</script>

<style>
.custom-invalid {
    border: 2px solid #dc3545 !important;
}

.note-editor.custom-invalid {
    border: 2px solid #dc3545 !important;
}

.field-wrapper {
    margin-bottom: 20px;
}

.text-danger {
    color: #dc3545;
}
</style>