var isSubmitting = false;

$(document).ready(function () {
    
    $('#Form').submit(function (e) {
        e.preventDefault(); 

        if (!isSubmitting) {
            validateAndSubmitComplaint(); 
        }
    });

    $(document).on('input change', 'input, textarea', function () {
        updateFieldBorder($(this));
    });
});

function updateFieldBorder(element) {
    var val = element.val().trim();
    if (val === '') {
        element.css('border', '2px solid red');
    } else {
        element.css('border', '2px solid green');
    }
}

function validateAndSubmitComplaint() {
    let valid = true;

    let requiredFields = [
        '#Stud_name',
        '#Stud_mailId',
        '#Stud_mobileNo'
    ];

    requiredFields.forEach(function (selector) {
        let $el = $(selector);
        if ($el.val().trim() === '') {
            $el.css('border', '2px solid red');
            valid = false;
        } else {
            $el.css('border', '2px solid green');
        }
    });

    if (!valid) {
        Swal.fire('Missing Fields', 'Please fill all required fields!', 'error');
        return;
    }

    submitComplaintForm();
}

function submitComplaintForm() {
    let form = $("#Form")[0];
    let formData = new FormData(form);
    let compId = $('#StudComp_id').val();

    isSubmitting = true;

    $.ajax({
        url: base_path + "Heads/Complaint/updateData",
        type: "POST",
        data: formData,
        processData: false,
        contentType: false,
        beforeSend: function () {
            $('#btn_save').prop('disabled', true).html('Updating...');
        },
 success: function (response) {
    isSubmitting = false;
    $('#btn_save').prop('disabled', false).html('Update');

    let res = typeof response === 'string' ? JSON.parse(response) : response;

    if (!res.status) {
        Swal.fire('Error', res.message, 'error');
        return;
    }

    // Swal.fire({
    //     position: 'center',
    //     icon: 'success',
    //     title: '<strong>Success!</strong>',
    //     html: 'Data Updated Successfully',
    //     showConfirmButton: false,
    //     timer: 2000
    // })
      Swal.fire({
  position: 'center',
  icon: 'success',
  title: '<strong>Success!</strong>',
  html: 'Data Updated Successfully',
  showConfirmButton: false,
  timer: 2000,
  customClass: {
    popup: 'custom-swal-popup',
    icon: 'custom-swal-icon',
    title: 'custom-swal-title',
    htmlContainer: 'custom-swal-text'
  }
})
    .then(() => {
        // ✅ Redirection logic
        let redirectUrl = '';
        if (res.form_role === 'HOD') {
            redirectUrl = base_path + "Heads/Complaint/HodComverify";
        } else if (res.form_role === 'REG') {
            redirectUrl = base_path + "Heads/Complaint/RegComverify";
        } else if (res.form_role === 'Princ') {
            redirectUrl = base_path + "Heads/Complaint/PrincComverify";
        }

        if (redirectUrl !== '') {
            window.location.href = redirectUrl;
        } else {
            Swal.fire('Error', 'Redirection failed. Unknown role.', 'error');
        }
    });

        },
        error: function () {
            isSubmitting = false;
            $('#btn_save').prop('disabled', false).html('Update');
            Swal.fire('Error', 'Something went wrong. Please try again.', 'error');
        }
    });
}
