<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css" integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<style>
.custom-invalid {
    border: 1px solid red !important;
}

body, html {
    overflow-x: hidden !important;
}

.page-wrapper,
.content-wrapper-scroll {
    overflow-x: hidden !important;
}

.wizard {
    margin: 20px auto;
    background: #fff;
}

.wizard-inner {
    position: relative;
    margin-top: -47px;
}

.wizard .nav-tabs {
    display: flex;
    justify-content: space-between;
    align-items: center;
    list-style: none;
    padding-left: 0;
    margin: 40px auto 0;
    border-bottom: none;
    position: relative;
}

.wizard .nav-tabs > li {
    flex: 1;
    text-align: center;
    position: relative;
}

.wizard .nav-tabs > li a {
    width: 70px;
    height: 70px;
    margin: 20px auto;
    border-radius: 100%;
    padding: 0;
    background: transparent;
}

.wizard .nav-tabs > li a:hover {
    background: transparent;
}

span.round-tab {
    width: 70px;
    height: 70px;
    line-height: 70px;
    display: inline-block;
    border-radius: 100px;
    background: #fff;
    border: 2px solid #e0e0e0;
    z-index: 2;
    position: relative;
    text-align: center;
    font-size: 25px;
    transition: 0.3s;
}

span.round-tab i {
    color: #555555;
}

.wizard li.active span.round-tab {
    background: #fff;
    border: 2px solid #1273eb;
}

.wizard li.active span.round-tab i {
    color: #1273eb;
}

span.round-tab:hover {
    color: #333;
    border: 2px solid #333;
}

.connecting-line {
    height: 2px;
    background: #e0e0e0;
    position: absolute;
    width: 100%;
    top: 50%;
    left: 0;
    right: 0;
    z-index: 1;
}

.wizard li:after {
    content: " ";
    position: absolute;
    left: 50%;
    transform: translateX(-50%);
    opacity: 0;
    bottom: 0;
    border: 5px solid transparent;
    border-bottom-color: #1273eb;
    transition: 0.1s ease-in-out;
}

/* .wizard li.active:after {
    content: " ";
    opacity: 1;
    border: 10px solid transparent;
    border-bottom-color: #1273eb;
} */

.wizard li.active:after {
    content: " ";
    opacity: 1;
    border: 10px solid transparent;
    border-bottom-color: #1273eb; /* green arrow */
}


.wizard .tab-pane {
    position: relative;
    padding-top: 50px;
}

.wizard h3 {
    margin-top: 0;
}

/* Responsive styles */
@media (max-width: 585px) {
    .wizard {
        width: 100%;
    }

    span.round-tab {
        font-size: 16px;
        width: 50px;
        height: 50px;
        line-height: 50px;
    }

    .wizard .nav-tabs > li a {
        width: 50px;
        height: 50px;
        line-height: 50px;
    }

    .wizard li.active:after {
        left: 35%;
    }
}
.wizard-inner .nav-tabs > li {
        text-align: center;
        width: 20%; /* evenly spaced */
    }

    .round-tab {
        width: 40px;
        height: 40px;
        line-height: 40px;
        border-radius: 50%;
        background: #f1f1f1;
        display: inline-block;
        font-size: 16px;
    }

    .step-title {
        display: block;
        margin-top: 5px;
        font-size: 12px;
        color: #333;
    }

    .nav-tabs > li a {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        text-decoration: none;
    }
   /* Green connecting line */
.step-progress-bar {
    position: absolute;
    height: 2px;
    top: 50%;
    left: 0;
    background-color: #28a745; /* green */
    width: 0%;
    z-index: 2;
    transition: width 0.4s ease-in-out;
}

/* Completed step (green round with original icon) */
.wizard li.completed span.round-tab {
    background: #28a745;
    border-color: #28a745;
    color: #fff;
}

.wizard li.completed span.round-tab i {
    color: #fff;
}

</style>

<div class="content-wrapper-scroll">

					<!-- Content wrapper start -->
					<div class="content-wrapper"style="padding: 1.5rem 1.5rem 1.5rem 1.5rem !important;
   
    overflow: auto">

						<!-- Row start -->
<div class="row gutters">
	<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

								<!-- Card start -->
		<div class="card">
			<!-- <div class="card-header"> -->
										<!-- <div class="card-title">Form 3</div> -->
									<!-- </div> -->
                                    <div class=" card-body">

<div class="container-fluid">
	<div class="row">
		<section>
        <div class="wizard">
            <!-- <div class="wizard-inner">
                <div class="connecting-line"></div>
                <ul class="nav nav-tabs" role="tablist">

                    <li role="presentation" class="active">
                        <a href="#step1" data-toggle="tab" aria-controls="step1" role="tab" title="Personal Details">
                            <span class="round-tab">
                                <i class="fa-solid fa-user"></i>
                            </span>
                        </a>
                    </li>

                     <li role="presentation" class="disabled">
                        <a href="#step2" data-toggle="tab" aria-controls="step2" role="tab" title="Address Details">
                            <span class="round-tab">
                                <i class="fa-solid fa-location-dot"></i>
                            </span>
                        </a>
                    </li>

                    <li role="presentation" class="disabled">
                        <a href="#step3" data-toggle="tab" aria-controls="step3" role="tab" title="Educational Information">
                            <span class="round-tab">
                               <i class="fa-solid fa-user-graduate"></i>
                            </span>
                        </a>
                    </li>
                    <li role="presentation" class="disabled">
                        <a href="#step4" data-toggle="tab" aria-controls="step4" role="tab" title="Document Information">
                            <span class="round-tab">
                               <i class="glyphicon glyphicon-folder-open"></i>
                            </span>
                        </a>
                    </li>

                    <li role="presentation" class="disabled">
                        <a href="#step5" data-toggle="tab" aria-controls="step5" role="tab" title="Department Detail">
                            <span class="round-tab">
                                <i class="fa-solid fa-building"></i>
                            </span>
                        </a>
                    </li>
                </ul>
            </div> -->
<div class="wizard-inner">
    <div class="connecting-line"></div>
    <div class="step-progress-bar" id="stepProgress"></div>
    <ul class="nav nav-tabs" role="tablist">

        <li role="presentation" class="active">
            <a href="#step1" data-toggle="tab" aria-controls="step1" role="tab" title="Personal Details">
                <span class="round-tab">
                    <i class="fa-solid fa-user"></i>
                </span>
                <span class="step-title">Personal</span>
            </a>
        </li>

        <li role="presentation" class="disabled">
            <a href="#step2" data-toggle="tab" aria-controls="step2" role="tab" title="Address Details">
                <span class="round-tab">
                    <i class="fa-solid fa-location-dot"></i>
                </span>
                <span class="step-title">Address</span>
            </a>
        </li>

        <li role="presentation" class="disabled">
            <a href="#step3" data-toggle="tab" aria-controls="step3" role="tab" title="Educational Information">
                <span class="round-tab">
                    <i class="fa-solid fa-user-graduate"></i>
                </span>
                <span class="step-title">Education</span>
            </a>
        </li>

        <li role="presentation" class="disabled">
            <a href="#step4" data-toggle="tab" aria-controls="step4" role="tab" title="Document Information">
                <span class="round-tab">
                    <i class="glyphicon glyphicon-folder-open"></i>
                </span>
                <span class="step-title">Documents</span>
            </a>
        </li>

        <li role="presentation" class="disabled">
            <a href="#step5" data-toggle="tab" aria-controls="step5" role="tab" title="Department Detail">
                <span class="round-tab">
                    <i class="fa-solid fa-building"></i>
                </span>
                <span class="step-title">Department</span>
            </a>
        </li>
    </ul>
</div>

            <!-- <form role="form"> -->
                <div class="tab-content">
                    <div class="tab-pane active" role="tabpanel" id="step1">
                        <!-- <h3>Personal Information</h3> -->
   <form id="Form" enctype="multipart/form-data" autocomplete="off">
    <div class="row gutters">

        <!-- Title -->
        <div class="col-xl-1 col-lg-1 col-md-1 col-sm-1 col-6">
            <div class="field-wrapper">
                <select class="select-single js-states" name="fkTitle_id" id="fkTitle_id"
                    title="Select Title" data-live-search="true">
                    <?php if (!empty($Title)): ?>
                        <?php foreach ($Title as $tit): ?>
                            <option value="<?= $tit->Title_id ?>"><?= $tit->Title_name ?></option>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <option value="">No Title found</option>
                    <?php endif; ?>
                </select>
                <div class="field-placeholder">Title</div>
            </div>
        </div>

         <!-- First Name -->
        <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
            <div class="field-wrapper">
                <input class="form-control" type="text" name="fac_Fname" id="fac_Fname"
                    value="<?php if (!empty($data)) echo $data[0]->fac_Fname; ?>" required>
                <div class="field-placeholder">First Name<span class="text-danger">*</span></div>
                <div class="form-text">Please Enter Your First Name.</div>
            </div>
        </div>

        <!-- Middle Name -->
        <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
            <div class="field-wrapper">
                <input class="form-control" type="text" name="fac_Mname" id="fac_Mname"
                    value="<?php if (!empty($data)) echo $data[0]->fac_Mname; ?>" required>
                <div class="field-placeholder">Middle Name<span class="text-danger">*</span></div>
                <div class="form-text">Please Enter Your Middle Name.</div>
            </div>
        </div>

        <!-- Last Name -->
        <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
            <div class="field-wrapper">
                <input class="form-control" type="text" name="fac_Lname" id="fac_Lname"
                    value="<?php if (!empty($data)) echo $data[0]->fac_Lname; ?>" required>
                <div class="field-placeholder">Last Name<span class="text-danger">*</span></div>
                <div class="form-text">Please Enter Your Last Name.</div>
            </div>
        </div>


        <!-- Gender -->
        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
            <div class="field-wrapper">
                <div class="checkbox-container">
                    <?php if (!empty($genders)): ?>
                        <?php $index = 0; ?>
                        <?php foreach ($genders as $gender): ?>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="fkgender"
                                    id="fkgender<?= $gender->gender_id ?>" value="<?= $gender->gender_id ?>"
                                    <?= $index === 0 ? 'checked' : '' ?>>
                                <label class="form-check-label" for="fkgender<?= $gender->gender_id ?>">
                                    <?= $gender->gender_name ?>
                                </label>
                            </div>
                            <?php $index++; ?>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <p>No gender options found.</p>
                    <?php endif; ?>
                    <div class="field-placeholder">Gender</div>
                </div>
            </div>
        </div>


        <!-- Full Name -->
        <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-10">
            <div class="field-wrapper">
                <input class="form-control" type="text" name="fac_Fullname" id="fac_Fullname"
                    value="<?php if (!empty($data)) echo $data[0]->fac_Fullname; ?>" readonly required>
                <div class="field-placeholder">Full Name<span class="text-danger">*</span></div>
                <div class="form-text">Please Enter Your Full Name.</div>
            </div>
        </div>


        <!-- Mobile Number -->
        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
            <div class="field-wrapper">
                <input class="form-control" type="number" name="fac_mobileNo" id="fac_mobileNo"
                    onKeyPress="if(this.value.length==10) return false;"
                    value="<?php if (!empty($data)) echo $data[0]->fac_mobileNo; ?>" required>
                <div class="field-placeholder">Mobile NO.<span class="text-danger">*</span></div>
                <div class="form-text">Please Enter Your Mobile Number.</div>
            </div>
        </div>

         <!-- Email -->
        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
            <div class="field-wrapper">
                <input class="form-control" type="email" name="fac_mailId" id="fac_mailId"
                    value="<?php if (!empty($data)) echo $data[0]->fac_mailId; ?>" required>
                <div class="field-placeholder">Email ID<span class="text-danger">*</span></div>
                <div class="form-text">We'll never share your email with anyone.</div>
            </div>
        </div>

   <!-- Religion -->
        <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
            <div class="field-wrapper">
                <select class="select-single js-states" name="fkReligion_id" id="fkReligion_id"
                    title="Select Religion" data-live-search="true">
                    <?php if (!empty($Religion)): ?>
                        <?php foreach ($Religion as $rel): ?>
                            <option value="<?= $rel->Religion_id ?>"><?= $rel->Religion_name ?></option>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <option value="">No Religion found</option>
                    <?php endif; ?>
                </select>
                <div class="field-placeholder">Religion</div>
            </div>
        </div>

        <!-- Caste -->
        <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
            <div class="field-wrapper">
                <select class="select-single js-states" name="fkCaste_id" id="fkCaste_id"
                    title="Select Caste" data-live-search="true">
                    <?php if (!empty($Caste)): ?>
                        <?php foreach ($Caste as $cas): ?>
                            <option value="<?= $cas->Caste_id ?>"><?= $cas->Caste_name ?></option>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <option value="">No Caste found</option>
                    <?php endif; ?>
                </select>
                <div class="field-placeholder">Select Caste</div>
            </div>
        </div>

        <!-- Caste Category -->
        <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
            <div class="field-wrapper">
                <select class="select-single js-states" name="fkCasteCateg_id" id="fkCasteCateg_id"
                    title="Select Caste Category" data-live-search="true">
                    <?php if (!empty($CasteCate)): ?>
                        <?php foreach ($CasteCate as $cat): ?>
                            <option value="<?= $cat->Category_id ?>"><?= $cat->Category_name ?></option>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <option value="">No Caste categories found</option>
                    <?php endif; ?>
                </select>
                <div class="field-placeholder">Caste Category</div>
            </div>
        </div>

        <!-- Sub-Caste -->
        <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
            <div class="field-wrapper">
                <select class="select-single js-states" name="fkSubCaste_id" id="fkSubCaste_id"
                    title="Select Sub-Caste Category" data-live-search="true">
                    <?php if (!empty($SubCaste)): ?>
                        <?php foreach ($SubCaste as $sub): ?>
                            <option value="<?= $sub->SubCaste_id ?>"><?= $sub->SubCaste_name ?></option>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <option value="">No Sub-Caste categories found</option>
                    <?php endif; ?>
                </select>
                <div class="field-placeholder">Sub-Caste Category</div>
            </div>
        </div>

        <!-- Caste Number -->
        <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
            <div class="field-wrapper">
                <input class="form-control" type="number" name="CasteNo" id="CasteNo"
                    value="<?php if (!empty($data)) echo $data[0]->CasteNo; ?>" required>
                <div class="field-placeholder">Caste Number</div>
            </div>
        </div>


         <!-- Qualification -->
        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
            <div class="field-wrapper">
                <!-- <input class="form-control" type="text" autocomplete="off" name="fkQualify_id" id="fkQualify_id"
                    value="<?php if (!empty($data)) echo $data[0]->fkQualify_id; ?>" required> -->
                    <input class="form-control" type="text" 
                          name="fkQualify_id" id="fkQualify_id"
                          autocomplete="off"
                         value="<?php if (!empty($data)) echo $data[0]->fkQualify_id; ?>" required>

                <div class="field-placeholder">Qualification</div>
            </div>
        </div>

        <!-- Blood Group -->
        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
            <div class="field-wrapper">
                <select class="select-single js-states" name="fkBloodgrp" id="fkBloodgrp"
                    title="Select Blood Group" data-live-search="true">
                    <?php if (!empty($Blood)): ?>
                        <?php foreach ($Blood as $bld): ?>
                            <option value="<?= $bld->Bloodgrp_id ?>"><?= $bld->Bloodgrp_name ?></option>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <option value="">No Blood Group found</option>
                    <?php endif; ?>
                </select>
                <div class="field-placeholder">Select Blood Group</div>
            </div>
        </div>

        <!-- Handicap Checkbox -->
        <div class="col-md-2 mt-4">
            <div class="form-check mt-2">
                <input class="form-check-input" type="checkbox" id="is_handikaped" name="is_handikaped" value="1">
                <label class="form-check-label" for="is_handikaped">Handicap</label>
            </div>
        </div>

        <!-- Handicap Type -->
        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
            <div class="field-wrapper">
                <select class="select-single js-states" name="fkhandikap_type" id="fkhandikap_type"
                    title="Select Handicap Type" data-live-search="true">
                    <?php if (!empty($Handi)): ?>
                        <?php foreach ($Handi as $hand): ?>
                            <option value="<?= $hand->handikap_id ?>"><?= $hand->handikap_name ?></option>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <option value="">No Handicap Type found</option>
                    <?php endif; ?>
                </select>
                <div class="field-placeholder">Handicap Type</div>
            </div>
        </div>

        <!-- Active/Deactive -->
        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
            <div class="field-wrapper">
                <label class="form-label">Active/Deactive</label>
                <div class="form-check form-check-inline">
                    <input class="form-check-input" type="radio" name="Active_Deactive" value="1" id="active" checked>
                    <label class="form-check-label" for="active">Active</label>
                </div>
                <div class="form-check form-check-inline">
                    <input class="form-check-input" type="radio" name="Active_Deactive" value="0" id="deactive">
                    <label class="form-check-label" for="deactive">Deactive</label>
                </div>
            </div>
        </div>

       
        <!-- File Upload -->
        <!-- <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
            <div class="field-wrapper">
                <div class="input-group">
                    <input type="file" class="form-control" id="fac_Photo" name="fac_Photo">
                    <button class="btn btn-outline-primary" type="button">Photo Upload</button>
                </div>
            </div>
            <?php if (!empty($data[0]->Photo_1)) { ?>
                <a href="<?= base_url(); ?>upload/<?= $data[0]->Photo_1; ?>" target="_blank">
                    <img src="<?= base_url(); ?>upload/<?= $data[0]->Photo_1; ?>" id="fac_Photo_img_preview"
                        class="img-thumbnail" style="height: 86px; margin: 10px 32px;">
                </a>
            <?php } else { ?>
                <img src="" id="fac_Photo_img_preview" class="img-thumbnail"
                    style="margin: 10px 32px; height: 86px; display: none;">
            <?php } ?>
            <input type="hidden" name="hidden_photo" id="hidden_photo"
                value="<?php if (!empty($data[0]->Photo_1)) echo $data[0]->Photo_1; ?>">
        </div> -->

       <div class="col-xl-3 col-lg-3 col-md-12 col-sm-12 col-12">
  <div class="field-wrapper">
    <div class="field-placeholder">Photo</div>

    <input type="file" name="fac_Photo" id="fac_Photo" class="form-control" onchange="previewFile(this)">

    <div id="file-preview" style="margin-top:10px;">
      <?php
      if (!empty($data[0]->fac_Photo)) {
          $file = $data[0]->fac_Photo;
          $ext = pathinfo($file, PATHINFO_EXTENSION);
          $fileUrl = base_url('uploads/faculty/' . $file);
          $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
          ?>
          <a href="<?= $fileUrl ?>" target="_blank">
            <?php if ($isImage): ?>
              <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
            <?php else: ?>
              <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
            <?php endif; ?>
          </a>
      <?php } else { ?>
          <img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" alt="No File" style="height: 100px;" />
      <?php } ?>
    </div>

    <input type="hidden" name="hidden_Leave_Document" value="<?= !empty($data[0]->fac_Photo) ? $data[0]->fac_Photo : '' ?>">
  </div>
</div>

 
<script>
function previewFile(input) {
    const preview = document.getElementById('file-preview');
    const file = input.files[0];

    if (file) {
        const fileType = file.type;
        const fileUrl = URL.createObjectURL(file);

        if (fileType.startsWith('image/')) {
            
            preview.innerHTML = `<img src="${fileUrl}" style="height: 100px; border:1px solid #ccc; padding:2px;">`;
        } else {
           
            preview.innerHTML = `<img src="<?= base_url('Assets/img/Document_file.png') ?>" style="height: 100px;">`;
        }

    } else {
        
        preview.innerHTML = `<img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" style="height: 100px;">`;
    }
}
</script>


        <!-- Password -->
      <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
    <div class="field-wrapper position-relative">
        <input class="form-control" type="password"
            id="Password" name="Password"
            autocomplete="new-password"
            value="<?php if (!empty($data)) echo $data[0]->Password; ?>">

        <div class="field-placeholder">Password<span class="text-danger">*</span></div>

        <!-- Eye Icon -->
        <span toggle="#Password" class="fa fa-fw fa-eye field-icon toggle-password"
              style="position: absolute; top: 50%; right: 15px; transform: translateY(-50%); cursor: pointer;"></span>
    </div>
</div>


        <!-- Branch -->
         <div class="col-md-3">
                <div class="field-wrapper">
                    <select class="select-single js-states" name="fkbranch_id" id="fkbranch_id" data-live-search="true" title="Select Branch Name">
                        <option value="">Select Branch</option>
                        <?php foreach ($Branch ?? [] as $bran): ?>
                            <option value="<?= $bran->branch_id ?>"><?= $bran->branch_name ?></option>
                        <?php endforeach; ?>
                    </select>
                    <div class="field-placeholder">Select Branch<span class="text-danger">*</span></div>
                </div>
            </div>
 
</form>
		
										</div>
                        
                        <ul class="list-inline pull-right">
                            <li><button type="button" class="btn btn-primary next-step"  name="btn_save" id="btn_save">Save and continue</button></li>
                        <li>
    <button type="button" class="btn btn-outline-primary" onclick="window.location.href='<?= base_url('admin/Faculty/index') ?>'">
        <i class="fas fa-list"></i> View List
    </button>
</li>

                        </ul>
                    </div>

                    <!-- Educational Information -->
                    <div class="tab-pane" role="tabpanel" id="step3">
                        <!-- <h3>Educational Information</h3> -->
                  <!-- All content inside one accordion body -->
        <form id="Form1" enctype="multipart/form-data">
<input type="hidden" id="base_path" value="<?= base_url(); ?>">
 <input type="hidden" id="fac_id" name="fac_id" value="<?= !empty($data) ? $data[0]->fac_id : '' ?>">
          <div class="row gutters">
              
            <!-- Highest Qualification -->
            <div class="col-md-3">
               <div class="field-wrapper">
          <select class="select-single js-states" name="fkfac_HighestQualify" id="fkfac_HighestQualify"
                title="Select Qualification" data-live-search="true">
                <?php if (!empty($Qualification)): ?>
                    <?php foreach ($Qualification as $Qualify): ?>
                        <option value="<?= $Qualify->Qualify_id ?>"><?= $Qualify->Qualify_name ?></option>
                    <?php endforeach; ?>
                <?php else: ?>
                    <option value="">No Branch found</option>
                <?php endif; ?>
            </select>
            <div class="field-placeholder">Higher Qualification</div>
        </div>
            </div>

            <!-- Institute Name -->
            <div class="col-md-3">
                 <div class="field-wrapper">
            <select class="select-single js-states" name="fkInstitu_id" id="fkInstitu_id"
                title="Select Institute Name" data-live-search="true">
                <?php if (!empty($Institute)): ?>
                    <?php foreach ($Institute as $Insti): ?>
                        <option value="<?= $Insti->Institu_id ?>"><?= $Insti->Institu_name ?></option>
                    <?php endforeach; ?>
                <?php else: ?>
                    <option value="">No Institute Name found</option>
                <?php endif; ?>
            </select>
            <div class="field-placeholder">Select Institue</div>
        </div>
            </div>

            <!-- Department -->
            <div class="col-md-3">
                     <div class="field-wrapper">
            <select class="select-single js-states" name="fkDepartment" id="fkDepartment"
                title="Select Department Name" data-live-search="true">
                <?php if (!empty($Department)): ?>
                    <?php foreach ($Department as $dep): ?>
                        <option value="<?= $dep->dep_id ?>"><?= $dep->dep_name ?></option>
                    <?php endforeach; ?>
                <?php else: ?>
                    <option value="">No Department found</option>
                <?php endif; ?>
            </select>
            <div class="field-placeholder">Select Department</div>
        </div>
            </div>

            <!-- Branch -->
            <div class="col-md-3">
              <div class="field-wrapper">
            <select class="select-single js-states" name="fkBrach" id="fkBrach"
                title="Select Branch Name" data-live-search="true">
                <?php if (!empty($Branch)): ?>
                    <?php foreach ($Branch as $bran): ?>
                        <option value="<?= $bran->branch_id ?>"><?= $bran->branch_name ?></option>
                    <?php endforeach; ?>
                <?php else: ?>
                    <option value="">No Branch found</option>
                <?php endif; ?>
            </select>
            <div class="field-placeholder">Select Branch</div>
        </div>
            </div>

            <!-- Subject -->
            <div class="col-md-3 mt-3">
          <div class="field-wrapper">
            <select class="select-single js-states" name="fksub_id" id="fksub_id"
                title="Select Subject Name" data-live-search="true">
                <?php if (!empty($Subject)): ?>
                    <?php foreach ($Subject as $sub): ?>
                        <option value="<?= $sub->sub_id ?>"><?= $sub->sub_name ?></option>
                    <?php endforeach; ?>
                <?php else: ?>
                    <option value="">No Subject found</option>
                <?php endif; ?>
            </select>
            <div class="field-placeholder">Select Subject</div>
        </div>
            </div>

            <!-- Designation -->
            <div class="col-md-3 mt-3">
             <div class="field-wrapper">
            <select class="select-single js-states" name="fkdesig_id" id="fkdesig_id"
                title="Select Designation Name" data-live-search="true">
                <?php if (!empty($Designation)): ?>
                    <?php foreach ($Designation as $desgi): ?>
                        <option value="<?= $desgi->desig_id ?>"><?= $desgi->desig_name ?></option>
                    <?php endforeach; ?>
                <?php else: ?>
                    <option value="">No Designation found</option>
                <?php endif; ?>
            </select>
            <div class="field-placeholder">Select Designation</div>
        </div>
            </div>

            <!-- BE/B.Tech Info -->
            <div class="col-md-3 mt-3">
             <div class="field-wrapper">
           <select class="select-single js-states" name="Btech_branchID" id="Btech_branchID"
                title="Select Branch Name" data-live-search="true">
                <?php if (!empty($Branch)): ?>
                    <?php foreach ($Branch as $bran): ?>
                        <option value="<?= $bran->branch_id ?>"><?= $bran->branch_name ?></option>
                    <?php endforeach; ?>
                <?php else: ?>
                    <option value="">No Branch found</option>
                <?php endif; ?>
            </select>
            <div class="field-placeholder">BE/B.Tech Branch</div>
        </div>
            </div>

            <div class="col-md-2 mt-3">
              <div class="field-wrapper">
                <input type="text" class="form-control" name="Btech_Mark" id="Btech_Mark"
                 value="<?php if(!empty($data)) echo $data[0]->Btech_Mark; ?>" required="">
                <div class="field-placeholder">BE/B.Tech Marks</div>
                <!-- <div class="valid-tooltip">Looks good!</div> -->
              </div>
            </div>

        <div class="col-md-2 mt-3">
  <div class="field-wrapper">
    <input type="text" class="form-control month-year-format" placeholder="MM-YY" name="Btech_CompliYear" id="Btech_CompliYear"
           value="<?php if(!empty($data)) echo $data[0]->Btech_CompliYear; ?>" maxlength="5" required>
    <div class="field-placeholder">BE/B.Tech Completed Year</div>
  </div>
</div>


            <!-- M.Tech Info -->
            <div class="col-md-3 mt-3">
             <div class="field-wrapper">
           <select class="select-single js-states" name="Mtech_branchID" id="Mtech_branchID"
                title="Select M.Tech Name" data-live-search="true">
                <?php if (!empty($Branch)): ?>
                    <?php foreach ($Branch as $bran): ?>
                        <option value="<?= $bran->branch_id ?>"><?= $bran->branch_name ?></option>
                    <?php endforeach; ?>
                <?php else: ?>
                    <option value="">No Branch found</option>
                <?php endif; ?>
            </select>
            <div class="field-placeholder">M.Tech Branch</div>
        </div>
            </div>

            <div class="col-md-2 mt-3">
              <div class="field-wrapper">
                <input type="text" class="form-control" name="Mtech_Mark" id="Mtech_Mark"
                 value="<?php if(!empty($data)) echo $data[0]->Mtech_Mark; ?>" required="">
                <div class="field-placeholder">M.Tech Marks</div>
                <!-- <div class="valid-tooltip">Looks good!</div> -->
              </div>
            </div>

           <div class="col-md-2 mt-3">
  <div class="field-wrapper">
    <input type="text" class="form-control month-year-format" placeholder="MM-YY" name="Mtech_CompliYear" id="Mtech_CompliYear"
           value="<?php if(!empty($data)) echo $data[0]->Mtech_CompliYear; ?>" maxlength="5" required>
    <div class="field-placeholder">M.Tech Completed Year</div>
  </div>
</div>

            <!-- PhD Info -->
            <div class="col-md-2 mt-4">
              <div class="form-check mt-2">
                <input class="form-check-input" type="checkbox" name="PHD_flag" id="PHD_flag" value="1">

                <label class="form-check-label" for="phdCheck">PhD</label>
              </div>
            </div>

            <div class="col-md-3 mt-3">
              <div class="field-wrapper">
          <select class="select-single js-states" name="PHD_branchID" id="PHD_branchID"
                title="Select Branch Name" data-live-search="true">
                <?php if (!empty($Branch)): ?>
                    <?php foreach ($Branch as $bran): ?>
                        <option value="<?= $bran->branch_id ?>"><?= $bran->branch_name ?></option>
                    <?php endforeach; ?>
                <?php else: ?>
                    <option value="">No Branch found</option>
                <?php endif; ?>
            </select>
            <div class="field-placeholder">PHD Branch</div>
        </div>
            </div>

            <div class="col-md-3 mt-3">
              <div class="field-wrapper">
                <input type="text" class="form-control month-year-format" placeholder="MM-YY" name="PHD_CompliYear" id="PHD_CompliYear"
                                                value="<?php if(!empty($data)) echo $data[0]->PHD_CompliYear; ?>" required="">
                <div class="field-placeholder">PhD Completed Year</div>
              </div>
            </div>

            <!-- Teaching Experience -->
         <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12 mt-3">
                                    <div class="field-wrapper">
                                        <input class="form-control" type="number" name="Teach_Exp" id="Teach_Exp"
                                                value="<?php if(!empty($data)) echo $data[0]->Teach_Exp; ?>" required="">
                                        <div class="field-placeholder">Teaching Experience</div>
                                    </div>
                                </div>
          <!-- Industrial Experience -->
         <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12 mt-3">
                                    <div class="field-wrapper">
                                        <input class="form-control" type="number" name="Indu_Exp" id="Indu_Exp"
                                                value="<?php if(!empty($data)) echo $data[0]->Indu_Exp; ?>" required="">
                                        <div class="field-placeholder">Industrial Experience</div>
                                    </div>
                                </div>

  <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12 mt-3">
                                    <div class="field-wrapper">
                                        <input class="form-control" type="text" name="Pre_work" id="Pre_work"
                                                value="<?php if(!empty($data)) echo $data[0]->Pre_work; ?>" required="">
                                        <div class="field-placeholder">Previous Work</div>
                                    </div>
                                </div>

          </div>
           <!-- Submit Button -->
         <!-- <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <button class="btn btn-primary" type="button" name="btn_submit" id="btn_submit">Submit</button>
                                    </div> -->
        </form>



                        <ul class="list-inline pull-right">
                            <li><button type="button" class="btn btn-default prev-step">Previous</button></li>
                            <li><button type="button" class="btn btn-primary next-step"  name="btn_submit" id="btn_submit">Save and continue</button></li>
                        </ul>
                    </div>


<!-- Address Information -->
  <div class="tab-pane" role="tabpanel" id="step2">
                        <!-- <h3>Educational Information</h3> -->
                  <!-- All content inside one accordion body -->
       <form id="Form3" enctype="multipart/form-data">
    <input type="hidden" id="fac_id_add" name="fac_id">

    <!-- Present Address Row -->
    <div class="row gutters">
        <!-- Present Address -->
        <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
            <div class="field-wrapper">
                <textarea class="form-control" name="fac_PresentAdd" id="fac_PresentAdd" rows="3" required><?php if(!empty($data)) echo $data[0]->fac_PresentAdd; ?></textarea>
                <div class="field-placeholder">Present Address</div>
            </div>
        </div>

        <!-- Present District -->
        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
            <div class="field-wrapper">
                <select class="select-single js-states" name="fkPresentDist_id" id="fkPresentDist_id"
                    title="Select District" data-live-search="true" required>
                    <?php if (!empty($District)): ?>
                        <?php foreach ($District as $dis): ?>
                            <option value="<?= $dis->district_id ?>"><?= $dis->district_name ?></option>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <option value="">No District found</option>
                    <?php endif; ?>
                </select>
                <div class="field-placeholder">Select District</div>
            </div>
        </div>

        <!-- Present State -->
        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
            <div class="field-wrapper">
                <select class="select-single js-states" name="fkPresentState_id" id="fkPresentState_id"
                    title="Select State" data-live-search="true" required>
                    <?php if (!empty($State)): ?>
                        <?php foreach ($State as $sta): ?>
                            <option value="<?= $sta->stateId ?>"><?= $sta->stateName ?></option>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <option value="">No State found</option>
                    <?php endif; ?>
                </select>
                <div class="field-placeholder">Select State</div>
            </div>
        </div>
    </div>

    <!-- Permanent Address Row -->
    <div class="row gutters">
        <!-- Permanent Address -->
        <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
            <div class="field-wrapper">
                <textarea class="form-control" name="fac_PermanantAdd" id="fac_PermanantAdd" rows="3" required><?php if(!empty($data)) echo $data[0]->fac_PermanantAdd; ?></textarea>
                <div class="field-placeholder">Permanent Address</div>
            </div>
        </div>

        <!-- Permanent District -->
        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
            <div class="field-wrapper">
                <select class="select-single js-states" name="fkPermanantDist_id" id="fkPermanantDist_id"
                    title="Select District" data-live-search="true" required>
                    <?php if (!empty($District)): ?>
                        <?php foreach ($District as $dis): ?>
                            <option value="<?= $dis->district_id ?>"><?= $dis->district_name ?></option>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <option value="">No District found</option>
                    <?php endif; ?>
                </select>
                <div class="field-placeholder">Permanent District</div>
            </div>
        </div>

        <!-- Permanent State -->
        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
            <div class="field-wrapper">
                <select class="select-single js-states" name="fkPermanantState_id" id="fkPermanantState_id"
                    title="Select State" data-live-search="true" required>
                    <?php if (!empty($State)): ?>
                        <?php foreach ($State as $sta): ?>
                            <option value="<?= $sta->stateId ?>"><?= $sta->stateName ?></option>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <option value="">No State found</option>
                    <?php endif; ?>
                </select>
                <div class="field-placeholder">Permanent State</div>
            </div>
        </div>
    </div>
    
</form>




                        <ul class="list-inline pull-right">
                            <li><button type="button" class="btn btn-default prev-step">Previous</button></li>
                            <li><button type="button" class="btn btn-primary next-step"  name="btn_address_submit" id="btn_address_submit">Save and continue</button></li>
                        </ul>
                    </div>
                    <!-- Document Information -->
                    <div class="tab-pane" role="tabpanel" id="step4">
                        <!-- <h3>Document Information</h3> -->
                       <!-- All content inside one accordion body -->
        <form  id="Form2" enctype="multipart/form-data">
            <input type="hidden" name="fac_id"  id="fac_id_doc" value="<?php if(!empty($data)) echo $data[0]->fac_id; ?>">
          <div class="row gutters">
            <!-- Aadhar Card Number -->
             <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                    <div class="field-wrapper">
                                        <input type="number" class="form-control" name="fac_AadharNo" id="fac_AadharNo"
                                                value="<?php if(!empty($data)) echo $data[0]->fac_AadharNo; ?>" onKeyPress="if(this.value.length==12) return false;" required="">
                                        <div class="field-placeholder">Aadhar Card Number</div>
                                        <!-- <div class="valid-feedback">Looks good!</div> -->
                                    </div>
                                </div>

           <!-- Aadhar Card Photo -->
          
<!-- <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-4">
    <div class="field-wrapper">
        <div class="input-group">
            <input type="file" class="form-control" name="fac_AadharPhoto" id="fac_AadharPhoto">
            <button class="btn btn-outline-primary" type="button">Aadhar Card Photo</button>
        </div>
        <?php if (!empty($data[0]->fac_AadharPhoto)) { ?>
            <a href="<?= base_url(); ?>upload/<?= $data[0]->fac_AadharPhoto; ?>" target="_blank">
                <img src="<?= base_url(); ?>upload/<?= $data[0]->fac_AadharPhoto; ?>" id="aadhar_img_preview"
                     class="img-thumbnail" style="height: 86px; margin: 10px 32px;">
            </a>
        <?php } else { ?>
            <img src="" id="aadhar_img_preview" class="img-thumbnail"
                 style="height: 86px; margin: 10px 32px; display: none;">
        <?php } ?>
        <input type="hidden" name="hidden_aadhar_photo" value="<?= !empty($data[0]->fac_AadharPhoto) ? $data[0]->fac_AadharPhoto : ''; ?>">
    </div>
</div> -->

   <div class="col-xl-3 col-lg-3 col-md-12 col-sm-12 col-12">
  <div class="field-wrapper">
    <div class="field-placeholder">Aadhar Card Photo</div>

    <input type="file" name="fac_AadharPhoto" id="fac_AadharPhoto" class="form-control" onchange="previewaadhar(this)">

    <div id="file_aadhar" style="margin-top:10px;">
      <?php
      if (!empty($data[0]->fac_AadharPhoto)) {
          $file = $data[0]->fac_AadharPhoto;
          $ext = pathinfo($file, PATHINFO_EXTENSION);
          $fileUrl = base_url('uploads/faculty/' . $file);
          $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
          ?>
          <a href="<?= $fileUrl ?>" target="_blank">
            <?php if ($isImage): ?>
              <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
            <?php else: ?>
              <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
            <?php endif; ?>
          </a>
      <?php } else { ?>
          <img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" alt="No File" style="height: 100px;" />
      <?php } ?>
    </div>

    <input type="hidden" name="hidden_Leave_Document" value="<?= !empty($data[0]->fac_AadharPhoto) ? $data[0]->fac_AadharPhoto : '' ?>">
  </div>
</div>

 
<script>
function previewaadhar(input) {
    const preview = document.getElementById('file_aadhar');
    const file = input.files[0];

    if (file) {
        const fileType = file.type;
        const fileUrl = URL.createObjectURL(file);

        if (fileType.startsWith('image/')) {
            
            preview.innerHTML = `<img src="${fileUrl}" style="height: 100px; border:1px solid #ccc; padding:2px;">`;
        } else {
           
            preview.innerHTML = `<img src="<?= base_url('Assets/img/Document_file.png') ?>" style="height: 100px;">`;
        }

    } else {
        
        preview.innerHTML = `<img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" style="height: 100px;">`;
    }
}
</script>
                                

            <!-- PAN Card Number -->
              <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
                                    <div class="field-wrapper">
                                        <input type="text" class="form-control" name="fac_PanCardNo" id="fac_PanCardNo"
                                                value="<?php if(!empty($data)) echo $data[0]->fac_PanCardNo; ?>" required="">
                                        <div class="field-placeholder">PAN Card Number</div>
                                        <!-- <div class="valid-feedback">Looks good!</div> -->
                                    </div>
                                </div>

           

                                <!-- PAN Card Photo -->
<!-- <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-4">
    <div class="field-wrapper">
        <div class="input-group">
            <input type="file" class="form-control" name="fac_PanCardPhoto" id="fac_PanCardPhoto">
            <button class="btn btn-outline-primary" type="button">PAN Card Photo</button>
        </div>
        <?php if (!empty($data[0]->fac_PanCardPhoto)) { ?>
            <a href="<?= base_url(); ?>upload/<?= $data[0]->fac_PanCardPhoto; ?>" target="_blank">
                <img src="<?= base_url(); ?>upload/<?= $data[0]->fac_PanCardPhoto; ?>" id="pan_img_preview"
                     class="img-thumbnail" style="height: 86px; margin: 10px 32px;">
            </a>
        <?php } else { ?>
            <img src="" id="pan_img_preview" class="img-thumbnail"
                 style="height: 86px; margin: 10px 32px; display: none;">
        <?php } ?>
        <input type="hidden" name="hidden_pan_photo" value="<?= !empty($data[0]->fac_PanCardPhoto) ? $data[0]->fac_PanCardPhoto : ''; ?>">
    </div>
</div> -->

   <div class="col-xl-3 col-lg-3 col-md-12 col-sm-12 col-12">
  <div class="field-wrapper">
    <div class="field-placeholder">Pan Card Photo</div>

    <input type="file" name="fac_PanCardPhoto" id="fac_PanCardPhoto" class="form-control" onchange="previewpan(this)">

    <div id="file_pan" style="margin-top:10px;">
      <?php
      if (!empty($data[0]->fac_PanCardPhoto)) {
          $file = $data[0]->fac_PanCardPhoto;
          $ext = pathinfo($file, PATHINFO_EXTENSION);
          $fileUrl = base_url('uploads/faculty/' . $file);
          $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
          ?>
          <a href="<?= $fileUrl ?>" target="_blank">
            <?php if ($isImage): ?>
              <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
            <?php else: ?>
              <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
            <?php endif; ?>
          </a>
      <?php } else { ?>
          <img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" alt="No File" style="height: 100px;" />
      <?php } ?>
    </div>

    <input type="hidden" name="hidden_Leave_Document" value="<?= !empty($data[0]->fac_PanCardPhoto) ? $data[0]->fac_PanCardPhoto : '' ?>">
  </div>
</div>

 
<script>
function previewpan(input) {
    const preview = document.getElementById('file_pan');
    const file = input.files[0];

    if (file) {
        const fileType = file.type;
        const fileUrl = URL.createObjectURL(file);

        if (fileType.startsWith('image/')) {
            
            preview.innerHTML = `<img src="${fileUrl}" style="height: 100px; border:1px solid #ccc; padding:2px;">`;
        } else {
           
            preview.innerHTML = `<img src="<?= base_url('Assets/img/Document_file.png') ?>" style="height: 100px;">`;
        }

    } else {
        
        preview.innerHTML = `<img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" style="height: 100px;">`;
    }
}
</script>
            <!-- Voter Card -->
           <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
                                    <div class="field-wrapper">
                                        <input type="text" class="form-control" name="fac_VoterCard" id="fac_VoterCard"
                                                value="<?php if(!empty($data)) echo $data[0]->fac_VoterCard; ?>" required="">
                                        <div class="field-placeholder">Voter Card</div>
                                        <!-- <div class="valid-feedback">Looks good!</div> -->
                                    </div>
                                </div>

            <!-- Driving Licences -->
            <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
                                    <div class="field-wrapper">
                                        <input type="text" class="form-control" name="fac_DrivingLic" id="fac_DrivingLic"
                                                value="<?php if(!empty($data)) echo $data[0]->fac_DrivingLic; ?>" required="">
                                        <div class="field-placeholder">Driving Licences</div>
                                        <!-- <div class="valid-feedback">Looks good!</div> -->
                                    </div>
                                </div>


                                
<!-- Document 1 -->
<!-- <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-4">
    <div class="field-wrapper">
        <div class="input-group">
            <input type="file" class="form-control" name="Doc1" id="Doc1">
            <button class="btn btn-outline-primary" type="button">Document-1</button>
        </div>
        <?php if (!empty($data[0]->Doc1)) { ?>
            <a href="<?= base_url(); ?>upload/<?= $data[0]->Doc1; ?>" target="_blank">
                <img src="<?= base_url(); ?>upload/<?= $data[0]->Doc1; ?>" id="doc1_img_preview"
                     class="img-thumbnail" style="height: 86px; margin: 10px 32px;">
            </a>
        <?php } else { ?>
            <img src="" id="doc1_img_preview" class="img-thumbnail"
                 style="height: 86px; margin: 10px 32px; display: none;">
        <?php } ?>
        <input type="hidden" name="hidden_doc1" value="<?= !empty($data[0]->Doc1) ? $data[0]->Doc1 : ''; ?>">
    </div>
</div> -->

   <div class="col-xl-3 col-lg-3 col-md-12 col-sm-12 col-12">
  <div class="field-wrapper">
    <div class="field-placeholder">Document-1</div>

    <input type="file" name="Doc1" id="Doc1" class="form-control" onchange="previewdoc1(this)">

    <div id="file_doc1" style="margin-top:10px;">
      <?php
      if (!empty($data[0]->Doc1)) {
          $file = $data[0]->Doc1;
          $ext = pathinfo($file, PATHINFO_EXTENSION);
          $fileUrl = base_url('uploads/faculty/' . $file);
          $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
          ?>
          <a href="<?= $fileUrl ?>" target="_blank">
            <?php if ($isImage): ?>
              <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
            <?php else: ?>
              <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
            <?php endif; ?>
          </a>
      <?php } else { ?>
          <img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" alt="No File" style="height: 100px;" />
      <?php } ?>
    </div>

    <input type="hidden" name="hidden_Leave_Document" value="<?= !empty($data[0]->Doc1) ? $data[0]->Doc1 : '' ?>">
  </div>
</div>

 
<script>
function previewdoc1(input) {
    const preview = document.getElementById('file_doc1');
    const file = input.files[0];

    if (file) {
        const fileType = file.type;
        const fileUrl = URL.createObjectURL(file);

        if (fileType.startsWith('image/')) {
            
            preview.innerHTML = `<img src="${fileUrl}" style="height: 100px; border:1px solid #ccc; padding:2px;">`;
        } else {
           
            preview.innerHTML = `<img src="<?= base_url('Assets/img/Document_file.png') ?>" style="height: 100px;">`;
        }

    } else {
        
        preview.innerHTML = `<img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" style="height: 100px;">`;
    }
}
</script>

 <!-- Document 2-->

                                <!-- <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-4">
    <div class="field-wrapper">
        <div class="input-group">
            <input type="file" class="form-control" name="Doc2" id="Doc2" required>
            <button class="btn btn-outline-primary" type="button">Document-2</button>
        </div>
        <?php if (!empty($data[0]->Doc2)) { ?>
            <a href="<?= base_url(); ?>upload/<?= $data[0]->Doc2; ?>" target="_blank">
                <img src="<?= base_url(); ?>upload/<?= $data[0]->Doc2; ?>" id="doc2_img_preview"
                     class="img-thumbnail" style="height: 86px; margin: 10px 32px;">
            </a>
        <?php } else { ?>
            <img src="" id="doc2_img_preview" class="img-thumbnail"
                 style="height: 86px; margin: 10px 32px; display: none;">
        <?php } ?>
        <input type="hidden" name="hidden_doc2" value="<?= !empty($data[0]->Doc2) ? $data[0]->Doc2 : ''; ?>">
    </div>
</div> -->

   <div class="col-xl-3 col-lg-3 col-md-12 col-sm-12 col-12">
  <div class="field-wrapper">
    <div class="field-placeholder">Document-2</div>

    <input type="file" name="Doc2" id="Doc2" class="form-control" onchange="previewdoc2(this)">

    <div id="file_doc2" style="margin-top:10px;">
      <?php
      if (!empty($data[0]->Doc2)) {
          $file = $data[0]->Doc2;
          $ext = pathinfo($file, PATHINFO_EXTENSION);
          $fileUrl = base_url('uploads/faculty/' . $file);
          $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
          ?>
          <a href="<?= $fileUrl ?>" target="_blank">
            <?php if ($isImage): ?>
              <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
            <?php else: ?>
              <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
            <?php endif; ?>
          </a>
      <?php } else { ?>
          <img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" alt="No File" style="height: 100px;" />
      <?php } ?>
    </div>

    <input type="hidden" name="hidden_Leave_Document" value="<?= !empty($data[0]->Doc2) ? $data[0]->Doc2 : '' ?>">
  </div>
</div>

 
<script>
function previewdoc2(input) {
    const preview = document.getElementById('file_doc2');
    const file = input.files[0];

    if (file) {
        const fileType = file.type;
        const fileUrl = URL.createObjectURL(file);

        if (fileType.startsWith('image/')) {
            
            preview.innerHTML = `<img src="${fileUrl}" style="height: 100px; border:1px solid #ccc; padding:2px;">`;
        } else {
           
            preview.innerHTML = `<img src="<?= base_url('Assets/img/Document_file.png') ?>" style="height: 100px;">`;
        }

    } else {
        
        preview.innerHTML = `<img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" style="height: 100px;">`;
    }
}
</script>


 <!-- Document 3-->
       

<!-- <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-4">
    <div class="field-wrapper">
        <div class="input-group">
            <input type="file" class="form-control" name="Doc3" id="Doc3" required>
            <button class="btn btn-outline-primary" type="button">Document-3</button>
        </div>
        <?php if (!empty($data[0]->Doc3)) { ?>
            <a href="<?= base_url(); ?>upload/<?= $data[0]->Doc3; ?>" target="_blank">
                <img src="<?= base_url(); ?>upload/<?= $data[0]->Doc3; ?>" id="doc3_img_preview"
                     class="img-thumbnail" style="height: 86px; margin: 10px 32px;">
            </a>
        <?php } else { ?>
            <img src="" id="doc3_img_preview" class="img-thumbnail"
                 style="height: 86px; margin: 10px 32px; display: none;">
        <?php } ?>
        <input type="hidden" name="hidden_doc3" value="<?= !empty($data[0]->Doc3) ? $data[0]->Doc3 : ''; ?>">
    </div>
</div> -->

   <div class="col-xl-3 col-lg-3 col-md-12 col-sm-12 col-12">
  <div class="field-wrapper">
    <div class="field-placeholder">Document-3</div>

    <input type="file" name="Doc3" id="Doc3" class="form-control" onchange="previewdoc3(this)">

    <div id="file_doc3" style="margin-top:10px;">
      <?php
      if (!empty($data[0]->Doc3)) {
          $file = $data[0]->Doc3;
          $ext = pathinfo($file, PATHINFO_EXTENSION);
          $fileUrl = base_url('uploads/faculty/' . $file);
          $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
          ?>
          <a href="<?= $fileUrl ?>" target="_blank">
            <?php if ($isImage): ?>
              <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
            <?php else: ?>
              <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
            <?php endif; ?>
          </a>
      <?php } else { ?>
          <img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" alt="No File" style="height: 100px;" />
      <?php } ?>
    </div>

    <input type="hidden" name="hidden_Leave_Document" value="<?= !empty($data[0]->Doc3) ? $data[0]->Doc3 : '' ?>">
  </div>
</div>

 
<script>
function previewdoc3(input) {
    const preview = document.getElementById('file_doc3');
    const file = input.files[0];

    if (file) {
        const fileType = file.type;
        const fileUrl = URL.createObjectURL(file);

        if (fileType.startsWith('image/')) {
            
            preview.innerHTML = `<img src="${fileUrl}" style="height: 100px; border:1px solid #ccc; padding:2px;">`;
        } else {
           
            preview.innerHTML = `<img src="<?= base_url('Assets/img/Document_file.png') ?>" style="height: 100px;">`;
        }

    } else {
        
        preview.innerHTML = `<img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" style="height: 100px;">`;
    }
}
</script>

            <!-- Caste Validation Photo -->
                   

                                <!-- <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-4">
    <div class="field-wrapper">
        <div class="input-group">
            <input type="file" class="form-control" name="fac_CasteValPhoto" id="fac_CasteValPhoto" required>
            <button class="btn btn-outline-primary" type="button">Caste Validation</button>
        </div>
        <?php if (!empty($data[0]->fac_CasteValPhoto)) { ?>
            <a href="<?= base_url(); ?>upload/<?= $data[0]->fac_CasteValPhoto; ?>" target="_blank">
                <img src="<?= base_url(); ?>upload/<?= $data[0]->fac_CasteValPhoto; ?>" id="caste_val_img_preview"
                     class="img-thumbnail" style="height: 86px; margin: 10px 32px;">
            </a>
        <?php } else { ?>
            <img src="" id="caste_val_img_preview" class="img-thumbnail"
                 style="height: 86px; margin: 10px 32px; display: none;">
        <?php } ?>
        <input type="hidden" name="hidden_fac_CasteValPhoto" value="<?= !empty($data[0]->fac_CasteValPhoto) ? $data[0]->fac_CasteValPhoto : ''; ?>">
    </div>
</div> -->

   <div class="col-xl-3 col-lg-3 col-md-12 col-sm-12 col-12">
  <div class="field-wrapper">
    <div class="field-placeholder">Cast Validation Photo</div>

    <input type="file" name="fac_CasteValPhoto" id="fac_CasteValPhoto" class="form-control" onchange="previewcast(this)">

    <div id="file_cast" style="margin-top:10px;">
      <?php
      if (!empty($data[0]->fac_CasteValPhoto)) {
          $file = $data[0]->fac_CasteValPhoto;
          $ext = pathinfo($file, PATHINFO_EXTENSION);
          $fileUrl = base_url('uploads/faculty/' . $file);
          $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
          ?>
          <a href="<?= $fileUrl ?>" target="_blank">
            <?php if ($isImage): ?>
              <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
            <?php else: ?>
              <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
            <?php endif; ?>
          </a>
      <?php } else { ?>
          <img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" alt="No File" style="height: 100px;" />
      <?php } ?>
    </div>

    <input type="hidden" name="hidden_Leave_Document" value="<?= !empty($data[0]->fac_CasteValPhoto) ? $data[0]->fac_CasteValPhoto : '' ?>">
  </div>
</div>

 
<script>
function previewcast(input) {
    const preview = document.getElementById('file_cast');
    const file = input.files[0];

    if (file) {
        const fileType = file.type;
        const fileUrl = URL.createObjectURL(file);

        if (fileType.startsWith('image/')) {
            
            preview.innerHTML = `<img src="${fileUrl}" style="height: 100px; border:1px solid #ccc; padding:2px;">`;
        } else {
           
            preview.innerHTML = `<img src="<?= base_url('Assets/img/Document_file.png') ?>" style="height: 100px;">`;
        }

    } else {
        
        preview.innerHTML = `<img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" style="height: 100px;">`;
    }
}
</script>
                                
 <!-- Resume-->
      
                                <!-- <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-4"> -->
    <!-- <div class="field-wrapper">
        <div class="input-group">
            <input type="file" class="form-control" name="Resume" id="Resume" required>
            <button class="btn btn-outline-primary" type="button">Resume</button>
        </div>
        <?php if (!empty($data[0]->Resume)) { ?>
            <a href="<?= base_url(); ?>upload/<?= $data[0]->Resume; ?>" target="_blank">
                <img src="<?= base_url(); ?>upload/<?= $data[0]->Resume; ?>" id="resume_img_preview"
                     class="img-thumbnail" style="height: 86px; margin: 10px 32px;">
            </a>
        <?php } else { ?>
            <img src="" id="resume_img_preview" class="img-thumbnail"
                 style="height: 86px; margin: 10px 32px; display: none;">
        <?php } ?>
        <input type="hidden" name="hidden_Resume" value="<?= !empty($data[0]->Resume) ? $data[0]->Resume : ''; ?>">
    </div>
</div> -->

   <div class="col-xl-3 col-lg-3 col-md-12 col-sm-12 col-12">
  <div class="field-wrapper">
    <div class="field-placeholder">Resume</div>

    <input type="file" name="Resume" id="Resume" class="form-control" onchange="previewresume(this)">

    <div id="file_resume" style="margin-top:10px;">
      <?php
      if (!empty($data[0]->Resume)) {
          $file = $data[0]->Resume;
          $ext = pathinfo($file, PATHINFO_EXTENSION);
          $fileUrl = base_url('uploads/faculty/' . $file);
          $isImage = in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
          ?>
          <a href="<?= $fileUrl ?>" target="_blank">
            <?php if ($isImage): ?>
              <img src="<?= $fileUrl ?>" alt="Preview" style="height: 100px; border: 1px solid #ccc; padding: 2px;" />
            <?php else: ?>
              <img src="<?= base_url('Assets/img/Document_file.png') ?>" alt="View File" style="height: 100px;" />
            <?php endif; ?>
          </a>
      <?php } else { ?>
          <img src="<?= base_url('Assets/img/Nodocument_file.png') ?>" alt="No File" style="height: 100px;" />
      <?php } ?>
    </div>

    <input type="hidden" name="hidden_Leave_Document" value="<?= !empty($data[0]->Resume) ? $data[0]->Resume : '' ?>">
  </div>
</div>

 
<script>
function previewresume(input) {
    const preview = document.getElementById('file_resume');
    const file = input.files[0];

    if (file) {
        const fileType = file.type;
        const fileUrl = URL.createObjectURL(file);

        // Default document icon path from PHP (escaped into JS)
        const documentIcon = "<?= base_url('Assets/img/Document_file.png') ?>";

        if (fileType.startsWith('image/')) {
            // Image preview
            preview.innerHTML = `
                <img src="${fileUrl}" style="height: 100px; border:1px solid #ccc; padding:2px;">
            `;
        } else {
            // Document file: use default document icon
            preview.innerHTML = `
                <img src="${documentIcon}" style="height: 100px;">
            `;
        }
    } else {
        // No file selected
        const noDocIcon = "<?= base_url('Assets/img/Nodocument_file.png') ?>";
        preview.innerHTML = `
            <img src="${noDocIcon}" style="height: 100px;">
        `;
    }
}
</script>

                                            	  

          </div>
              <!-- <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <button class="btn btn-primary" type="button" name="btn_doc_submit" id="btn_doc_submit">Submit</button>
                                    </div> -->
        </form>


                        <ul class="list-inline pull-right">
                            <li><button type="button" class="btn btn-default prev-step">Previous</button></li>
                            <!-- <li><button type="button" class="btn btn-default next-step">Skip</button></li> -->
                            <li><button type="button" class="btn btn-primary btn-info-full next-step"  name="btn_doc_submit" id="btn_doc_submit">Save and continue</button></li>
                        </ul>
                    </div>

                  <!-- Step 5: Department Information -->
<div class="tab-pane" role="tabpanel" id="step5">
    <form id="Form4" enctype="multipart/form-data">
        <input type="hidden" id="base_path" value="<?= base_url(); ?>">
        <input type="hidden" id="fac_id" name="fac_id" value="<?= !empty($data) ? $data[0]->fac_id : '' ?>">

        <div class="row gutters">

            <!-- Institute -->
             <!-- Institute -->
<div class="col-md-3">
    <div class="field-wrapper">
        <select class="select-single js-states" name="fkInstitute" id="fkInstitute" data-live-search="true" title="Select Institute Name">
            <?php foreach ($Institute ?? [] as $index => $Insti): ?>
                <option value="<?= $Insti->Institu_id ?>" <?= $index === 0 ? 'selected' : '' ?>>
                    <?= $Insti->Institu_name ?>
                </option>
            <?php endforeach; ?>
        </select>
        <div class="field-placeholder">Select Institute<span class="text-danger">*</span></div>
    </div>
</div>

            <!-- <div class="col-md-4">
                <div class="field-wrapper">
                    <select class="select-single js-states" name="fkInstitute" id="fkInstitute" data-live-search="true" title="Select Institute Name">
                        <option value="">Select Institute</option>
                        <?php foreach ($Institute ?? [] as $Insti): ?>
                            <option value="<?= $Insti->Institu_id ?>"><?= $Insti->Institu_name ?></option>
                        <?php endforeach; ?>
                    </select>
                    <div class="field-placeholder">Select Institute</div>
                </div>
            </div> -->

            <!-- Department -->
            <div class="col-md-3">
                <div class="field-wrapper">
                    <select class="select-single js-states" name="fkdep_id" id="fkdep_id" data-live-search="true" title="Select Department Name">
                        <option value="">Select Department</option>
                        <?php foreach ($Department ?? [] as $dep): ?>
                            <option value="<?= $dep->dep_id ?>"><?= $dep->dep_name ?></option>
                        <?php endforeach; ?>
                    </select>
                    <div class="field-placeholder">Select Department<span class="text-danger">*</span></div>
                </div>
            </div>

            <!-- Branch -->
            <!-- <div class="col-md-4">
                <div class="field-wrapper">
                    <select class="select-single js-states" name="fkbranch_id" id="fkbranch_id" data-live-search="true" title="Select Branch Name">
                        <option value="">Select Branch</option>
                        <?php foreach ($Branch ?? [] as $bran): ?>
                            <option value="<?= $bran->branch_id ?>"><?= $bran->branch_name ?></option>
                        <?php endforeach; ?>
                    </select>
                    <div class="field-placeholder">Select Branch<span class="text-danger">*</span></div>
                </div>
            </div> -->

            <!-- Subject -->
            <div class="col-md-3">
                <div class="field-wrapper">
                    <select class="select-single js-states" name="fkSubject" id="fkSubject" data-live-search="true" title="Select Subject">
                        <option value="">Select Subject</option>
                        <?php foreach ($Subject ?? [] as $sub): ?>
                            <option value="<?= $sub->sub_id ?>"><?= $sub->sub_name ?></option>
                        <?php endforeach; ?>
                    </select>
                    <div class="field-placeholder">Select Subject</div>
                </div>
            </div>

            <!-- Designation -->
            <div class="col-md-3">
                <div class="field-wrapper">
                    <select class="select-single js-states" name="fkDesignation" id="fkDesignation" data-live-search="true" title="Select Designation">
                        <option value="">Select Designation</option>
                        <?php foreach ($Designation ?? [] as $desgi): ?>
                            <option value="<?= $desgi->desig_id ?>"><?= $desgi->desig_name ?></option>
                        <?php endforeach; ?>
                    </select>
                    <div class="field-placeholder">Select Designation</div>
                </div>
            </div>

            <!-- Joining Date -->
            
                                <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
  <!-- Field wrapper start -->
  <div class="field-wrapper">
    <input type="date" 
           class="form-control" 
           name="joining_date" 
           id="joining_date"
           value="<?php if(!empty($data)) echo $data[0]->joining_date; ?>" 
           required />
    <div class="field-placeholder">Joining Date</div>
  </div>
  <!-- Field wrapper end -->
</div>
        </div>

        <!-- Submit Buttons -->
        <div class="mt-4 text-end">
            <ul class="list-inline">
                <li class="list-inline-item"><button type="button" class="btn btn-default prev-step">Previous</button></li>
                <li class="list-inline-item"><button type="button" class="btn btn-primary next-step" name="btn_department_submit" id="btn_department_submit">Save and Continue</button></li>
            </ul>
        </div>
    </form>
</div>

            <!-- </form> -->
        </div>
    </section>
   </div>
</div>
                                    </div>
                                    
									
									


				





				                    
 <!-- end  -->
									
			</div>
								<!-- Card end -->

		</div>
	</div>
						<!-- Row end -->

</div>
					<!-- Content wrapper end -->
	<script  src="<?php echo base_url();?>Assets/js/jquery.min.js"></script>          
 
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
 
<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>
 
<script src="<?php echo base_url();?>Assets/js/CreateJs/admin/Faculty.js"></script>

<script>
$(document).ready(function() {
    $(".toggle-password").click(function() {
        var input = $($(this).attr("toggle"));
        var icon = $(this);
 
        // Toggle input type
        if (input.attr("type") === "password") {
            input.attr("type", "text");
            icon.removeClass("fa-eye").addClass("fa-eye-slash");
        } else {
            input.attr("type", "password");
            icon.removeClass("fa-eye-slash").addClass("fa-eye");
        }
    });
});
</script>

					