<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Complaint extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Complaint_model');
    }

public function HodComverify() {
    $branch_id = $this->session->userdata('branch_id'); // HOD ki branch
    $data['alldata'] = $this->Complaint_model->getComplaintDetails($branch_id);

    $this->load->view('Heads/header_view');
    $this->load->view('Heads/CompverifyHod', $data);
    $this->load->view('Heads/footer_view');
}

    public function RegComverify() {
      $data['alldata'] = $this->Complaint_model->geRegtComplaintDetails();

        $this->load->view('Heads/header_view');
        $this->load->view('Heads/CompverifyReg', $data);
        $this->load->view('Heads/footer_view');
    }
        public function PrincComverify() {
      $data['alldata'] = $this->Complaint_model->getPrincComplaintDetails();

        $this->load->view('Heads/header_view');
        $this->load->view('Heads/CompverifyPrinc', $data);
        $this->load->view('Heads/footer_view');
    }
   public function update($id)
{
    $data['data'] = $this->Complaint_model->getById($id);
    $data['departments'] = $this->Complaint_model->getDepartments();
    $data['branches'] = $this->Complaint_model->getBranches();
    $data['categories'] = $this->Complaint_model->getCategories();

        $this->load->view('Heads/header_view');

    $this->load->view('Heads/ComplaintUpdate_view', $data);
        $this->load->view('Heads/footer_view');

}
   public function updateRegcom($id)
{
    $data['data'] = $this->Complaint_model->getById($id);
    $data['departments'] = $this->Complaint_model->getDepartments();
    $data['branches'] = $this->Complaint_model->getBranches();
    $data['categories'] = $this->Complaint_model->getCategories();

        $this->load->view('Heads/header_view');

    $this->load->view('Heads/ComplaintReg', $data);
        $this->load->view('Heads/footer_view');

}
   public function updatePrincicom($id)
{
    $data['data'] = $this->Complaint_model->getById($id);
    $data['departments'] = $this->Complaint_model->getDepartments();
    $data['branches'] = $this->Complaint_model->getBranches();
    $data['categories'] = $this->Complaint_model->getCategories();

        $this->load->view('Heads/header_view');

    $this->load->view('Heads/ComplaintPrinc', $data);
        $this->load->view('Heads/footer_view');

}

public function updateData()
{
    $id = $this->input->post('StudComp_id');
    $form_role = $this->input->post('form_role'); // ✅ STEP 1: Get form_role
    $uploadPath = './Assets/Upload/';
    // $uploadPath = './uploads/complaint/';

    $this->load->library('upload');

    $formData = [];

    // 2. HOD
    if ($this->input->post('HOD_Approval') !== null) {
        $formData['HOD_Approval'] = $this->input->post('HOD_Approval');
        $formData['HOD_remark']   = $this->input->post('HOD_remark');
        $formData['HOD_Date']     = date('Y-m-d H:i:s');
        $formData['HOD_solution'] = $this->input->post('HOD_solution');

        if (!empty($_FILES['HOD_file']['name'])) {
            $config['upload_path']   = $uploadPath;
            $config['allowed_types'] = '*';
            $config['file_name']     = 'HOD_' . time() . '_' . $_FILES['HOD_file']['name'];
            $this->upload->initialize($config);
            if ($this->upload->do_upload('HOD_file')) {
                $formData['HOD_file'] = $this->upload->data('file_name');
            }
        }
    }

    // 3. REG
    if ($this->input->post('REG_Approval') !== null) {
        $formData['REG_Approval'] = $this->input->post('REG_Approval');
        $formData['REG_remark']   = $this->input->post('REG_remark');
        $formData['REG_Date']     = date('Y-m-d H:i:s');
        $formData['REG_solution'] = $this->input->post('REG_solution');

        if (!empty($_FILES['REG_file']['name'])) {
            $config['upload_path']   = $uploadPath;
            $config['allowed_types'] = '*';
            $config['file_name']     = 'REG_' . time() . '_' . $_FILES['REG_file']['name'];
            $this->upload->initialize($config);
            if ($this->upload->do_upload('REG_file')) {
                $formData['REG_file'] = $this->upload->data('file_name');
            }
        }
    }

    // 4. Principal
    if ($this->input->post('Princ_Approval') !== null) {
        $formData['Princ_Approval'] = $this->input->post('Princ_Approval');
        $formData['Princ_remark']   = $this->input->post('Princ_remark');
        $formData['Princ_Date']     = date('Y-m-d H:i:s');
        $formData['Princ_solution'] = $this->input->post('Princ_solution');

        if (!empty($_FILES['Princ_file']['name'])) {
            $config['upload_path']   = $uploadPath;
            $config['allowed_types'] = '*';
            $config['file_name']     = 'PRINC_' . time() . '_' . $_FILES['Princ_file']['name'];
            $this->upload->initialize($config);
            if ($this->upload->do_upload('Princ_file')) {
                $formData['Princ_file'] = $this->upload->data('file_name');
            }
        }
    }

    if (!empty($formData)) {
        $this->Complaint_model->updateComplaint($id, $formData);
    }

    // ✅ STEP 2: Add form_role to response
    echo json_encode([
        'status'     => true,
        'message'    => 'Complaint updated successfully!',
        'form_role'  => $form_role
    ]);
}



}
